/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jline.builtins.ConsoleOptionGetter;
import org.jline.utils.StyleResolver;

public class Styles {
    private static final String DEFAULT_LS_COLORS = "di=1;91:ex=1;92:ln=1;96:fi=";
    private static final String DEFAULT_HELP_COLORS = "ti=1;34:co=1:ar=3:op=33";
    private static final String DEFAULT_PRNT_COLORS = "th=1;34:rn=1;34:mk=1;34:em=31:vs=32";
    private static final String LS_COLORS = "LS_COLORS";
    private static final String HELP_COLORS = "HELP_COLORS";
    private static final String PRNT_COLORS = "PRNT_COLORS";
    private static final String KEY = "([a-z]{2}|\\*\\.[a-zA-Z0-9]+)";
    private static final String VALUE = "[0-9]*(;[0-9]+){0,2}";
    private static final String ANSI_STYLE_PATTERN = "([a-z]{2}|\\*\\.[a-zA-Z0-9]+)=[0-9]*(;[0-9]+){0,2}(:([a-z]{2}|\\*\\.[a-zA-Z0-9]+)=[0-9]*(;[0-9]+){0,2})*(:|)";

    public static StyleResolver lsStyle() {
        return Styles.style(LS_COLORS, DEFAULT_LS_COLORS);
    }

    public static StyleResolver helpStyle() {
        return Styles.style(HELP_COLORS, DEFAULT_HELP_COLORS);
    }

    public static StyleResolver prntStyle() {
        return Styles.style(PRNT_COLORS, DEFAULT_PRNT_COLORS);
    }

    public static boolean isAnsiStylePattern(String style) {
        return style.matches(ANSI_STYLE_PATTERN);
    }

    private static StyleResolver style(String name, String defStyle) {
        String style = Styles.consoleOption(name);
        if (style == null) {
            style = defStyle;
        }
        return Styles.style(style);
    }

    private static String consoleOption(String name) {
        String out = null;
        try {
            ConsoleOptionGetter cog = (ConsoleOptionGetter)Class.forName("org.jline.console.SystemRegistry").getDeclaredMethod("get", new Class[0]).invoke(null, new Object[0]);
            if (cog != null && (out = (String)cog.consoleOption(name)) != null && !out.matches(ANSI_STYLE_PATTERN)) {
                out = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (out == null && (out = System.getenv(name)) != null && !out.matches(ANSI_STYLE_PATTERN)) {
            out = null;
        }
        return out;
    }

    private static StyleResolver style(String style) {
        Map<String, String> colors = Arrays.stream(style.split(":")).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> s.substring(s.indexOf(61) + 1)));
        return new StyleResolver(colors::get);
    }
}

