/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CInputStream;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oci.OracleOCIConnection;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CDriverExtension
extends OracleDriverExtension {
    static final int T2C_DEFAULT_BATCHSIZE = 1;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    T2CDriverExtension() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$6, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    final Connection getConnection(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            void url;
            void info;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$0, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties), abstractConnectionBuilder);
            }
            T2CConnection t2Conn = null;
            t2Conn = info.getProperty("is_connection_pooling") == "true" ? new OracleOCIConnection((String)url, (Properties)info, (Object)this) : new T2CConnection((String)url, (Properties)info, this);
            t2Conn.connect((AbstractConnectionBuilder<?, ?>)builder);
            T2CConnection t2CConnection = t2Conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$0, this, t2CConnection);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$0, this, null);
            }
            return t2CConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final CompletionStage<Connection> getConnectionAsync(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$1, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties), abstractConnectionBuilder);
            }
            CompletionStage<Connection> completionStage = CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connection is not supported by the Type 2 OCI driver"));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$1, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$1, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    oracle.jdbc.internal.OracleStatement allocateStatement(OracleConnection oracleConnection, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            void stmtProps;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$2, this, oracleConnection, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            if (stmtProps != null) {
                stmtProps.setProperty("execute_batch", Integer.toString(1));
                stmtProps.setProperty("row_prefetch", Integer.toString(((PhysicalConnection)conn).defaultRowPrefetch));
            }
            T2CStatement t2CStatement = new T2CStatement((T2CConnection)conn, (Properties)stmtProps);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$2, this, t2CStatement);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$2, this, null);
            }
            return t2CStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    OraclePreparedStatement allocatePreparedStatement(OracleConnection oracleConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            void conn;
            void stmtProps;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$3, this, oracleConnection, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            if (stmtProps != null) {
                stmtProps.setProperty("execute_batch", Integer.toString(((PhysicalConnection)conn).defaultExecuteBatch));
                stmtProps.setProperty("row_prefetch", Integer.toString(((PhysicalConnection)conn).defaultRowPrefetch));
            }
            T2CPreparedStatement t2CPreparedStatement = new T2CPreparedStatement((T2CConnection)conn, (String)sql, (Properties)stmtProps);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$3, this, t2CPreparedStatement);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$3, this, null);
            }
            return t2CPreparedStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    OracleCallableStatement allocateCallableStatement(OracleConnection oracleConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            void conn;
            void stmtProps;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$4, this, oracleConnection, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            if (stmtProps != null) {
                stmtProps.setProperty("execute_batch", Integer.toString(((PhysicalConnection)conn).defaultExecuteBatch));
                stmtProps.setProperty("row_prefetch", Integer.toString(((PhysicalConnection)conn).defaultRowPrefetch));
            }
            T2CCallableStatement t2CCallableStatement = new T2CCallableStatement((T2CConnection)conn, (String)sql, (Properties)stmtProps);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$4, this, t2CCallableStatement);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$4, this, null);
            }
            return t2CCallableStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OracleInputStream createInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void accessor2;
            void index;
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$5, this, oracleStatement, n2, accessor);
            }
            T2CInputStream t2CInputStream = new T2CInputStream((OracleStatement)stmt, (int)index, (Accessor)accessor2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$5, this, t2CInputStream);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$5, this, null);
            }
            return t2CInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T2CDriverExtension.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$6 = T2CDriverExtension.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T2CDriverExtension.class.getDeclaredMethod("createInputStream", OracleStatement.class, Integer.TYPE, Accessor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T2CDriverExtension.class.getDeclaredMethod("allocateCallableStatement", OracleConnection.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T2CDriverExtension.class.getDeclaredMethod("allocatePreparedStatement", OracleConnection.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T2CDriverExtension.class.getDeclaredMethod("allocateStatement", OracleConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T2CDriverExtension.class.getDeclaredMethod("getConnectionAsync", String.class, Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T2CDriverExtension.class.getDeclaredMethod("getConnection", String.class, Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

