/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.lint.LintObjectType;
import schemacrawler.tools.lint.Linter;
import schemacrawler.tools.lint.config.LinterConfig;
import us.fatehi.utility.string.StringFormat;

public abstract class BaseLinter
extends Linter {
    private static final Logger LOGGER = Logger.getLogger(BaseLinter.class.getName());
    private Catalog catalog;
    private InclusionRule tableInclusionRule;
    private InclusionRule columnInclusionRule;
    private TableTypesFilter tableTypesFilter;

    protected BaseLinter() {
        this.setTableTypesFilter(null);
        this.setTableInclusionRule(null);
        this.setColumnInclusionRule(null);
    }

    protected final void addCatalogLint(String message) {
        this.addLint(LintObjectType.catalog, this.catalog, message, null);
    }

    protected final <V extends Serializable> void addCatalogLint(String message, V value) {
        this.addLint(LintObjectType.catalog, this.catalog, message, value);
    }

    protected final void addTableLint(Table table, String message) {
        this.addLint(LintObjectType.table, table, message, null);
    }

    protected final <V extends Serializable> void addTableLint(Table table, String message, V value) {
        this.addLint(LintObjectType.table, table, message, value);
    }

    protected void end(Connection connection) throws SchemaCrawlerException {
    }

    protected final List<Column> getColumns(Table table) {
        if (table == null) {
            return Collections.emptyList();
        }
        ArrayList<Column> columns = new ArrayList<Column>(table.getColumns());
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (this.includeColumn(column)) continue;
            iterator.remove();
        }
        return columns;
    }

    protected final CrawlInfo getCrawlInfo() {
        return this.catalog.getCrawlInfo();
    }

    protected final TableTypesFilter getTableTypesFilter() {
        return this.tableTypesFilter;
    }

    protected final boolean includeColumn(Column column) {
        return column != null && this.columnInclusionRule.test((Object)column.getFullName());
    }

    protected final boolean includeTable(Table table) {
        return table != null && this.tableInclusionRule.test((Object)table.getFullName());
    }

    protected abstract void lint(Table var1, Connection var2) throws SchemaCrawlerException;

    protected final void setTableTypesFilter(TableTypesFilter tableTypesFilter) {
        this.tableTypesFilter = tableTypesFilter == null ? new TableTypesFilter() : tableTypesFilter;
    }

    protected void start(Connection connection) throws SchemaCrawlerException {
    }

    @Override
    final void configure(LinterConfig linterConfig) {
        super.configure(linterConfig);
        if (linterConfig != null) {
            this.setTableInclusionRule(linterConfig.getTableInclusionRule());
            this.setColumnInclusionRule(linterConfig.getColumnInclusionRule());
        }
    }

    @Override
    final void lint(Catalog catalog, Connection connection) throws SchemaCrawlerException {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
        this.start(connection);
        for (Table table : catalog.getTables()) {
            if (this.tableInclusionRule.test((Object)table.getFullName()) && this.tableTypesFilter.test(table)) {
                this.lint(table, connection);
                continue;
            }
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Excluding table <%s> for lint <%s>", new Object[]{table, this.getLinterId()}));
        }
        this.end(connection);
        this.catalog = null;
    }

    private final void setColumnInclusionRule(InclusionRule columnInclusionRule) {
        this.columnInclusionRule = columnInclusionRule == null ? new IncludeAll() : columnInclusionRule;
    }

    private final void setTableInclusionRule(InclusionRule tableInclusionRule) {
        this.tableInclusionRule = tableInclusionRule == null ? new IncludeAll() : tableInclusionRule;
    }
}

