/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint.formatter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.lint.Lint;
import schemacrawler.tools.lint.LintReport;
import schemacrawler.tools.lint.formatter.LintReportBuilder;
import schemacrawler.tools.options.OutputOptions;

abstract class BaseLintReportJacksonBuilder
implements LintReportBuilder {
    private final PrintWriter out;

    BaseLintReportJacksonBuilder(OutputOptions outputOptions) throws SchemaCrawlerException {
        try {
            this.out = new PrintWriter(outputOptions.openNewOutputWriter(), true);
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Cannot open output writer", (Throwable)e);
        }
    }

    @Override
    public void generateLintReport(LintReport report) throws SchemaCrawlerException {
        Objects.requireNonNull(this.out, "No output stream provided");
        try {
            ObjectMapper mapper = this.newConfiguredObjectMapper();
            mapper.writeValue((Writer)this.out, (Object)report);
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not generate lint report", (Throwable)e);
        }
    }

    protected abstract ObjectMapper newObjectMapper();

    private ObjectMapper newConfiguredObjectMapper() {
        JavaTimeModule timeModule = new JavaTimeModule();
        timeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        ObjectMapper mapper = this.newObjectMapper();
        mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT, SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID, SerializationFeature.WRITE_ENUMS_USING_TO_STRING});
        @JsonPropertyOrder(alphabetic=true)
        @JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
        abstract class JacksonAnnotationMixIn {
            @JsonIgnore
            public Object value;

            JacksonAnnotationMixIn() {
            }

            @JsonProperty(value="value")
            public abstract Object getValueAsString();
        }
        mapper.addMixIn(Object.class, JacksonAnnotationMixIn.class);
        mapper.addMixIn(Lint.class, JacksonAnnotationMixIn.class);
        mapper.registerModule((Module)timeModule);
        return mapper;
    }
}

