/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.lint.BaseLinter;
import us.fatehi.utility.Multimap;

public class LinterColumnTypes
extends BaseLinter {
    private Multimap<String, ColumnDataType> columnTypes;

    @Override
    public String getSummary() {
        return "column with same name but different data types";
    }

    @Override
    protected void end(Connection connection) throws SchemaCrawlerException {
        Objects.requireNonNull(this.columnTypes, "Not initialized");
        for (Map.Entry entry : this.columnTypes.entrySet()) {
            TreeSet currentColumnTypes = new TreeSet((Collection)entry.getValue());
            if (currentColumnTypes.size() <= 1) continue;
            this.addCatalogLint(this.getSummary(), (String)entry.getKey() + " " + currentColumnTypes);
        }
        this.columnTypes = null;
        super.end(connection);
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        Objects.requireNonNull(this.columnTypes, "Not initialized");
        for (Column column : this.getColumns(table)) {
            if (!column.isColumnDataTypeKnown()) continue;
            this.columnTypes.add((Object)column.getName(), (Object)column.getColumnDataType());
        }
    }

    @Override
    protected void start(Connection connection) throws SchemaCrawlerException {
        super.start(connection);
        this.columnTypes = new Multimap();
    }
}

