/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetWrapper;

public class MonetDataSource
extends MonetWrapper
implements DataSource {
    private String user;
    private String password;
    private String description = "MonetDB database";
    private String url = "jdbc:monetdb://localhost/";
    private int loginTimeout;
    private String directory;
    private final MonetDriver driver = new MonetDriver();

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = new Properties();
        props.put("user", username);
        props.put("password", password);
        if (this.loginTimeout > 0) {
            props.put("so_timeout", Integer.toString(this.loginTimeout));
        }
        if (this.directory != null) {
            props.put("embedded", "true");
            props.put("directory", this.directory);
        }
        return this.driver.connect(this.url, props);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean isEmbedded() {
        return this.directory != null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw MonetDataSource.newSQLFeatureNotSupportedException("getParentLogger");
    }
}

