/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.template;

import java.io.File;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import schemacrawler.schemacrawler.SchemaCrawlerRuntimeException;
import schemacrawler.tools.command.template.BaseTemplateRenderer;
import schemacrawler.tools.options.OutputOptions;

public final class VelocityRenderer
extends BaseTemplateRenderer {
    private static void setVelocityResourceLoaderProperty(Properties p, String resourceLoaderName, String resourceLoaderPropertyName, String resourceLoaderPropertyValue) {
        p.setProperty(resourceLoaderName + "." + "resource.loader" + "." + resourceLoaderPropertyName, resourceLoaderPropertyValue);
    }

    @Override
    public void execute() throws Exception {
        OutputOptions outputOptions = this.getOutputOptions();
        String templateLocation = this.getResourceFilename();
        String templatePath = ".";
        File templateFilePath = new File(templateLocation);
        if (templateFilePath.exists()) {
            templatePath = templatePath + "," + templateFilePath.getAbsoluteFile().getParent();
            templateLocation = templateFilePath.getName();
        }
        VelocityEngine ve = new VelocityEngine();
        String fileResourceLoader = "file";
        String classpathResourceLoader = "classpath";
        Properties p = new Properties();
        p.setProperty("resource.loader", "file,classpath");
        VelocityRenderer.setVelocityResourceLoaderProperty(p, "classpath", "class", ClasspathResourceLoader.class.getName());
        VelocityRenderer.setVelocityResourceLoaderProperty(p, "file", "class", FileResourceLoader.class.getName());
        VelocityRenderer.setVelocityResourceLoaderProperty(p, "file", "path", templatePath);
        ve.init(p);
        VelocityContext context = new VelocityContext(this.getContext());
        try (Writer writer = outputOptions.openNewOutputWriter();){
            String templateEncoding = outputOptions.getInputCharset().name();
            Template template = ve.getTemplate(templateLocation, templateEncoding);
            template.merge((Context)context, writer);
        }
        catch (ResourceNotFoundException e) {
            throw new SchemaCrawlerRuntimeException("Please specify an Apache Velocity template", (Throwable)e);
        }
    }
}

