/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.util.regex.Pattern;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectionSource;
import schemacrawler.tools.databaseconnector.DatabaseConnectionUrlBuilder;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import us.fatehi.utility.PropertiesUtility;

final class UnknownDatabaseConnector
extends DatabaseConnector {
    private static final Pattern[] patterns = new Pattern[]{Pattern.compile("jdbc:db2:.*"), Pattern.compile("jdbc:(mysql|mariadb):.*"), Pattern.compile("jdbc:oracle:.*"), Pattern.compile("jdbc:postgresql:.*"), Pattern.compile("jdbc:sqlite:.*"), Pattern.compile("jdbc:sqlserver:.*")};

    UnknownDatabaseConnector() {
        super(DatabaseServerType.UNKNOWN, url -> false, (informationSchemaViewsBuilder, connection) -> {}, (schemaRetrievalOptionsBuilder, connection) -> {}, limitOptionsBuilder -> {}, () -> DatabaseConnectionUrlBuilder.builder(""));
    }

    @Override
    public DatabaseConnectionSource newDatabaseConnectionSource(DatabaseConnectionOptions connectionOptions) throws SchemaCrawlerException {
        DatabaseConnectionSource databaseConnectionSource = super.newDatabaseConnectionSource(connectionOptions);
        String withoutDatabasePlugin = PropertiesUtility.getSystemConfigurationProperty((String)"SC_IGNORE_MISSING_DATABASE_PLUGIN", (String)Boolean.FALSE.toString());
        if (!Boolean.valueOf(withoutDatabasePlugin).booleanValue()) {
            String url = databaseConnectionSource.getConnectionUrl();
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(url).matches()) continue;
                throw new SchemaCrawlerException(String.format("SchemaCrawler database plugin should be on the CLASSPATH for <%s>", url));
            }
        }
        return databaseConnectionSource;
    }
}

