SELECT /*+ PARALLEL(AUTO) */
  NULL AS TABLE_CATALOG,
  VIEWS.OWNER AS TABLE_SCHEMA,
  VIEWS.VIEW_NAME AS TABLE_NAME,
  VIEWS.TEXT AS VIEW_DEFINITION,
  'UNKNOWN' AS CHECK_OPTION,
  CASE WHEN VIEWS.READ_ONLY = 'N' THEN 'Y' ELSE 'N' END AS IS_UPDATABLE
FROM
  ${catalogscope}_VIEWS VIEWS
WHERE
  VIEWS.OWNER NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'APPQOSSYS', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'GSMADMIN_INTERNAL', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL', 'RDSADMIN')  
  AND NOT REGEXP_LIKE(VIEWS.OWNER, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(VIEWS.OWNER, '^FLOWS_[0-9]{5,6}$')
  AND REGEXP_LIKE(VIEWS.OWNER, '${schemas}')
  AND VIEWS.VIEW_NAME NOT LIKE 'BIN$%'
  AND NOT REGEXP_LIKE(VIEWS.VIEW_NAME, '^(SYS_IOT|MDOS|MDRS|MDRT|MDOT|MDXT)_.*$')
UNION ALL
SELECT /*+ PARALLEL(AUTO) */
  NULL AS TABLE_CATALOG,
  MVIEWS.OWNER AS TABLE_SCHEMA,
  MVIEWS.MVIEW_NAME AS TABLE_NAME,
  MVIEWS.QUERY AS VIEW_DEFINITION,
  'UNKNOWN' AS CHECK_OPTION,
  'N' AS IS_UPDATABLE
FROM
  ${catalogscope}_MVIEWS MVIEWS
WHERE
  MVIEWS.OWNER NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'APPQOSSYS', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'GSMADMIN_INTERNAL', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL', 'RDSADMIN')  
  AND NOT REGEXP_LIKE(MVIEWS.OWNER, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(MVIEWS.OWNER, '^FLOWS_[0-9]{5,6}$')
  AND REGEXP_LIKE(MVIEWS.OWNER, '${schemas}')
  AND MVIEWS.MVIEW_NAME NOT LIKE 'BIN$%'
  AND NOT REGEXP_LIKE(MVIEWS.MVIEW_NAME, '^(SYS_IOT|MDOS|MDRS|MDRT|MDOT|MDXT)_.*$')
