"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.grepQueryBuilder = void 0;
const utils_1 = require("../utils");
const task_1 = require("./task");
const disallowedOptions = ['-h'];
const Query = Symbol('grepQuery');
class GrepQuery {
    constructor() {
        this[_a] = [];
    }
    *[(_a = Query, Symbol.iterator)]() {
        for (const query of this[Query]) {
            yield query;
        }
    }
    and(...and) {
        and.length && this[Query].push('--and', '(', ...utils_1.prefixedArray(and, '-e'), ')');
        return this;
    }
    param(...param) {
        this[Query].push(...utils_1.prefixedArray(param, '-e'));
        return this;
    }
}
/**
 * Creates a new builder for a `git.grep` query with optional params
 */
function grepQueryBuilder(...params) {
    return new GrepQuery().param(...params);
}
exports.grepQueryBuilder = grepQueryBuilder;
function parseGrep(grep) {
    const paths = new Set();
    const results = {};
    utils_1.forEachLineWithContent(grep, (input) => {
        const [path, line, preview] = input.split(utils_1.NULL);
        paths.add(path);
        (results[path] = results[path] || []).push({
            line: utils_1.asNumber(line),
            path,
            preview,
        });
    });
    return {
        paths,
        results,
    };
}
function default_1() {
    return {
        grep(searchTerm) {
            const then = utils_1.trailingFunctionArgument(arguments);
            const options = utils_1.getTrailingOptions(arguments);
            for (const option of disallowedOptions) {
                if (options.includes(option)) {
                    return this._runTask(task_1.configurationErrorTask(`git.grep: use of "${option}" is not supported.`), then);
                }
            }
            if (typeof searchTerm === 'string') {
                searchTerm = grepQueryBuilder().param(searchTerm);
            }
            const commands = ['grep', '--null', '-n', '--full-name', ...options, ...searchTerm];
            return this._runTask({
                commands,
                format: 'utf-8',
                parser(stdOut) {
                    return parseGrep(stdOut);
                },
            }, then);
        }
    };
}
exports.default = default_1;
//# sourceMappingURL=grep.js.map