require("source-map-support").install();
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */,
/* 2 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AddonsLinterUserError = void 0;
exports.apiToMessage = apiToMessage;
exports.basicCompatVersionComparison = basicCompatVersionComparison;
exports.buildI18nObject = buildI18nObject;
exports.checkMinNodeVersion = checkMinNodeVersion;
exports.couldBeMinifiedCode = couldBeMinifiedCode;
exports.createCompatibilityRule = createCompatibilityRule;
exports.ensureFilenameExists = ensureFilenameExists;
exports.errorParamsToUnsupportedVersionRange = errorParamsToUnsupportedVersionRange;
exports.firefoxStrictMinVersion = firefoxStrictMinVersion;
exports.firstStableVersion = firstStableVersion;
exports.getI18Data = getI18Data;
exports.getLineAndColumnFromMatch = getLineAndColumnFromMatch;
exports.getLocale = getLocale;
exports.getNodeReference = getNodeReference;
exports.getPackageTypeAsString = getPackageTypeAsString;
exports.getRootExpression = getRootExpression;
exports.getVariable = getVariable;
exports.i18n = void 0;
exports.ignorePrivateFunctions = ignorePrivateFunctions;
exports.isBrowserNamespace = isBrowserNamespace;
exports.isCompatible = isCompatible;
exports.isLocalUrl = isLocalUrl;
exports.normalizePath = normalizePath;
exports.parseCspPolicy = parseCspPolicy;

var _url = _interopRequireDefault(__webpack_require__(3));

var _upath = _interopRequireDefault(__webpack_require__(4));

var _jed2 = _interopRequireDefault(__webpack_require__(5));

var _semver = _interopRequireDefault(__webpack_require__(6));

var _commonTags = __webpack_require__(7);

var _osLocale = _interopRequireDefault(__webpack_require__(8));

var _logger = _interopRequireDefault(__webpack_require__(9));

var _const = __webpack_require__(11);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* global nodeRequire, localesRoot */
const SOURCE_MAP_RE = /\/\/[#@]\s(source(?:Mapping)?URL)=\s*(\S+)/; // Represents an error condition related to a user error (e.g. an invalid
// configuration option passed to the linter class, usually through the
// command line arguments).
//
// In bin/addons-linter instances of this error are recognized through the
// error name property and by default they will be logged on stderr as
// plain error messages and the error stack trace omitted (unless explicitly
// requested by passing --stack as an additional CLI options, useful for
// debugging reasons).

class AddonsLinterUserError extends Error {
  get name() {
    return 'AddonsLinterUserError';
  }

}

exports.AddonsLinterUserError = AddonsLinterUserError;

function errorParamsToUnsupportedVersionRange(errorParams) {
  const {
    min_manifest_version,
    max_manifest_version
  } = errorParams || {};

  if (min_manifest_version != null || max_manifest_version != null) {
    return [min_manifest_version ? `< ${min_manifest_version}` : undefined, max_manifest_version ? `> ${max_manifest_version}` : undefined].filter(e => e !== undefined).join(', ');
  }

  return '';
}

function normalizePath(iconPath) {
  // Convert the icon path to a URL so we can strip any fragments and resolve
  // . and .. automatically. We need an absolute URL to use as a base so we're
  // using https://example.com/.
  const {
    pathname
  } = new URL(iconPath, 'https://example.com/'); // Convert filename to unix path separator (as the ones stored
  // into the scanned files map).

  return _upath.default.toUnix(decodeURIComponent(pathname).slice(1));
}
/*
 * Takes an AST node and returns the root property.
 *
 * example: foo().bar.baz() will return the AST node for foo.
 */


function getRootExpression(node) {
  let root = node.callee; // If we encounter a member, grab the parent

  if (node.callee.type === 'MemberExpression') {
    let parent = node.callee.object;

    while (parent.type !== 'Identifier') {
      if (parent.callee.type === 'MemberExpression') {
        parent = parent.callee.object;
      } else {
        parent = parent.callee;
      }
    }

    root = parent;
  }

  return root;
}
/*
 * Returns the name of the reference node passed.
 *
 * example: var foo = document;
 *  The node for foo will return 'document'
 */


function getNodeReference(context, node) {
  const {
    variables
  } = context.getScope();
  let scopeVar; // Just return the value if the node passed in is a reference to a literal.

  if (typeof node === 'undefined' || node.type === 'Literal') {
    return node;
  } // Finds variable reference in current scope.


  for (let i = 0; i < variables.length; i++) {
    const variable = variables[i];

    if (variable.name === node.name) {
      scopeVar = variable;
      break;
    }
  }

  if (scopeVar && scopeVar.defs && scopeVar.defs[0] && scopeVar.defs[0].parent && scopeVar.defs[0].parent.parent && scopeVar.defs[0].parent.parent.body) {
    // This represents all occurrences of the variable
    const occurances = scopeVar.defs[0].parent.parent.body;
    let lastAssignment;

    if (occurances instanceof Array) {
      occurances.forEach(occurance => {
        if (occurance.type === 'VariableDeclaration' && occurance.declarations[0].init !== null) {
          // Get what the name of what it was assigned to or the raw
          // value depending on the initalization
          lastAssignment = occurance.declarations[0].init;
        } else if (occurance.type === 'ExpressionStatement' && occurance.expression.type === 'AssignmentExpression') {
          // Get the right hand side of the assignment
          lastAssignment = occurance.expression.right;
        }
      });
    } // Return the name of the first definition of the variable which
    // corresponds to the node passed in.


    if (lastAssignment) {
      return lastAssignment;
    }
  } // If that variable doesn't exist in scope, then just return the node's
  // name.


  return node;
}
/*
 * Get a variable from a eslint context object if it exists, otherwise
 * undefined.
 */


function getVariable(context, name) {
  const {
    variables
  } = context.getScope();
  let result;
  variables.forEach(variable => {
    if (variable.name === name && variable.defs && variable.defs[0] && variable.defs[0].name && variable.defs[0].name.parent) {
      result = variable.defs[0].name.parent.init;
    }
  });
  return result;
}

function getLocale() {
  return _osLocale.default.sync();
}

function getI18Data(locale) {
  let i18ndata = {};

  try {
    // eslint-disable-next-line global-require, import/no-dynamic-require
    i18ndata = nodeRequire(`${localesRoot}/${locale}/messages.js`);
  } catch (err) {
    _logger.default.info('Initialize locales using extract-locales command');
  }

  return i18ndata;
}
/*
 * Gettext utils. Used for translating strings.
 */


function buildI18nObject(i18nData) {
  const _jed = new _jed2.default(i18nData);

  return {
    jed: _jed,
    getI18Data,
    _: str => {
      return _jed.gettext(str);
    },
    gettext: str => {
      return _jed.gettext(str);
    },
    sprintf: (fmt, args) => {
      return _jed.sprintf(fmt, args);
    }
  };
}

const i18n = buildI18nObject(getI18Data(getLocale()));
/*
 * Check the minimum node version is met
 */

exports.i18n = i18n;

async function checkMinNodeVersion(minVersion, _process = process) {
  // eslint-disable-next-line no-param-reassign
  minVersion = minVersion || '0.12.0';

  if (!_semver.default.gte(_process.version, minVersion)) {
    throw new Error((0, _commonTags.oneLine)`Node version must be ${minVersion} or
                    greater. You are using ${_process.version}.`);
  }
}

function getPackageTypeAsString(numericPackageType) {
  const packageKeys = Object.keys(_const.PACKAGE_TYPES);

  for (let i = 0; i < packageKeys.length; i++) {
    const packageType = packageKeys[i];

    if (parseInt(numericPackageType, 10) === _const.PACKAGE_TYPES[packageType]) {
      return packageType;
    }
  }

  throw new Error(`Invalid package type constant "${numericPackageType}"`);
}
/*
 * Looks through all exported functions and returns only
 * "public" *functions* that aren't prefixed with an _
 *
 * Used for ignoring private functions and constants in rules files.
 * Rules can have private functions we don't run; anything that
 * starts with an "_" shouldn't be returned.
 *
 * This exists because we export private functions in rule files
 * for testing.
 */


function ignorePrivateFunctions(list) {
  const filteredList = {};
  Object.keys(list).forEach(functionName => {
    if (functionName.startsWith('_') === false && typeof list[functionName] === 'function') {
      filteredList[functionName] = list[functionName];
    }
  });
  return filteredList;
}
/*
 * Check a filename to make sure it's valid; used by scanners so we never
 * accept new scanners that don't specify which file they're referencing.
 */


function ensureFilenameExists(filename) {
  if (typeof filename !== 'string' || filename.length < 1) {
    throw new Error('Filename is required');
  }
}

function isLocalUrl(urlInput) {
  const parsedUrl = _url.default.parse(urlInput);

  const {
    protocol,
    path
  } = parsedUrl; // Check protocol is chrome: or resource: if set.
  // Details on the chrome protocol are here: https://goo.gl/W52T0Q
  // Details on resource protocol are here: https://goo.gl/HHqeJA

  if (protocol && !_const.LOCAL_PROTOCOLS.includes(protocol)) {
    return false;
  } // Disallow protocol-free remote urls.


  if (path.startsWith('//')) {
    return false;
  }

  return true;
}

function apiToMessage(string) {
  return string.replace(/^extension/, 'ext').replace(/\./g, '_').toUpperCase().substr(0, 25);
}

function isBrowserNamespace(string) {
  return ['browser', 'chrome'].includes(string);
}

function parseCspPolicy(policy) {
  if (!policy) {
    return {};
  } // eslint-disable-next-line no-param-reassign


  policy = policy.toLowerCase();
  const parsedPolicy = {};
  const directives = policy.split(';');
  directives.forEach(directive => {
    // eslint-disable-next-line no-param-reassign
    directive = directive.trim();
    const tokens = directive.split(/\s+/);
    const name = tokens[0];

    if (name) {
      parsedPolicy[name] = tokens.slice(1, tokens.length);
    }
  });
  return parsedPolicy;
}

function getLineAndColumnFromMatch(match) {
  const matchedLines = match.input.substr(0, match.index).split('\n');
  const matchedColumn = matchedLines.slice(-1)[0].length + 1;
  const matchedLine = matchedLines.length;
  return {
    matchedLine,
    matchedColumn
  };
}
/**
 * Determines if the source text is minified.
 * Using the percentage no. of the indented lines from a sample set of lines
 * to determine if the js file is minified.
 * Inspired by code for the Firefox Developer Toolbar.
 */


function couldBeMinifiedCode(code) {
  // Fast exit if `code` is empty. Could happen in tests, but also in real
  // files.
  if (!code) {
    return false;
  } // If there's a source map reference it's very certainly minified code.


  if (SOURCE_MAP_RE.test(code)) {
    return true;
  } // Number of lines to look at, taken from the head of the code.


  const sampleSize = 30; // Threshold in percent of indented lines to mark a file as not
  // minified.

  const indentCountThreshold = 20; // percentage
  // Length of a line that looks suspicious of being minified

  const hugeLinesLength = 500; // Number of huge lines to also mark a file as potentially minified
  // Hint: Minified AngularJS has 12 lines, jQuery 4

  const hugeLinesThreshold = 4;
  let lineEndIndex = 0;
  let lineStartIndex = 0;
  let lines = 1;
  let indentCount = 0;
  let hugeLinesCount = 0; // Strip comments.

  const normalizedCode = code.replace(/\/\*[\S\s]*?\*\/|\/\/.+/g, '');

  while (lines < sampleSize) {
    lineEndIndex = normalizedCode.indexOf('\n', lineStartIndex);

    if (lineEndIndex === -1) {
      break;
    }

    const currentLine = normalizedCode.slice(lineStartIndex, lineEndIndex);

    if (/^\s+/.test(currentLine)) {
      indentCount++;
    }

    if (currentLine.length >= hugeLinesLength) {
      hugeLinesCount++;
    }

    lineStartIndex = lineEndIndex + 1;
    lines++;
  }

  return indentCount / lines * 100 < indentCountThreshold || hugeLinesCount > hugeLinesThreshold;
}

function firefoxStrictMinVersion(manifestJson) {
  if (manifestJson.applications && manifestJson.applications.gecko && manifestJson.applications.gecko.strict_min_version && typeof manifestJson.applications.gecko.strict_min_version === 'string') {
    return parseInt(manifestJson.applications.gecko.strict_min_version.split('.')[0], 10);
  }

  return null;
}

function basicCompatVersionComparison(versionAdded, minVersion) {
  const asNumber = parseInt(versionAdded, 10);
  return !Number.isNaN(asNumber) && asNumber > minVersion;
}
/**
 * @param {*} supportInfo - bcd support info of a feature
 * @returns {string|boolean} The first version number to support the feature
 *          or a boolean indicating if the feature is supported at all. We do
 *          not consider any holes in the supported versions, only the first
 *          stable version is taken into account.
 */


function firstStableVersion(supportInfo) {
  let supportInfoArray = supportInfo;

  if (!Array.isArray(supportInfo)) {
    supportInfoArray = [supportInfo];
  }

  return supportInfoArray.reduce((versionAdded, supportEntry) => {
    if (!Object.prototype.hasOwnProperty.call(supportEntry, 'flags') && (!versionAdded || supportEntry.version_added && !basicCompatVersionComparison(supportEntry.version_added, parseInt(versionAdded, 10)))) {
      return supportEntry.version_added;
    }

    return versionAdded;
  }, false);
}

function isCompatible(bcd, path, minVersion, application) {
  const steps = path.split('.');
  let {
    api
  } = bcd.webextensions;

  for (const step of steps) {
    if (Object.prototype.hasOwnProperty.call(api, step)) {
      api = api[step];
    } else {
      break;
    }
  } // API namespace may be undocumented or not implemented, ignore in that case.


  if (api.__compat) {
    const supportInfo = api.__compat.support[application];
    const versionAdded = firstStableVersion(supportInfo);
    return !basicCompatVersionComparison(versionAdded, minVersion);
  }

  return true;
}

function createCompatibilityRule(application, message, context, bcd, hasBrowserApi) {
  const {
    addonMetadata
  } = context.settings;
  const minVersion = addonMetadata && firefoxStrictMinVersion({
    applications: {
      gecko: {
        strict_min_version: context.settings.addonMetadata.firefoxMinVersion
      }
    }
  });

  if (minVersion) {
    return {
      MemberExpression(node) {
        if (!node.computed && node.object.object && isBrowserNamespace(node.object.object.name)) {
          const namespace = node.object.property.name;
          const property = node.property.name;
          const api = `${namespace}.${property}`;

          if (hasBrowserApi(namespace, property, addonMetadata) && !isCompatible(bcd, api, minVersion, application)) {
            context.report(node, message.messageFormat, {
              api,
              minVersion: addonMetadata.firefoxMinVersion
            });
          }
        }
      }

    };
  }

  return {};
}

/***/ }),
/* 3 */
/***/ ((module) => {

module.exports = require("url");

/***/ }),
/* 4 */
/***/ ((module) => {

module.exports = require("upath");

/***/ }),
/* 5 */
/***/ ((module) => {

module.exports = require("jed");

/***/ }),
/* 6 */
/***/ ((module) => {

module.exports = require("semver");

/***/ }),
/* 7 */
/***/ ((module) => {

module.exports = require("common-tags");

/***/ }),
/* 8 */
/***/ ((module) => {

module.exports = require("os-locale");

/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createLogger = createLogger;
exports["default"] = void 0;

var _pino = _interopRequireDefault(__webpack_require__(10));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createLogger(_process = process) {
  const level = _process.env.LOG_LEVEL || 'fatal';
  return (0, _pino.default)({
    name: 'AddonLinterJS',
    level
  }, process.stdout);
}

var _default = createLogger();

exports["default"] = _default;

/***/ }),
/* 10 */
/***/ ((module) => {

module.exports = require("pino");

/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ZIP_LIB_CORRUPT_FILE_ERROR = exports.VALIDATION_WARNING = exports.VALIDATION_NOTICE = exports.VALIDATION_ERROR = exports.TEMPORARY_APIS = exports.STATIC_THEME_IMAGE_MIMES = exports.RESTRICTED_PERMISSIONS = exports.RESTRICTED_HOMEPAGE_URLS = exports.RESERVED_FILENAMES = exports.PERMS_DATAPATH_REGEX = exports.PACKAGE_TYPES = exports.PACKAGE_THEME = exports.PACKAGE_SUBPACKAGE = exports.PACKAGE_SEARCHPROV = exports.PACKAGE_MULTI = exports.PACKAGE_LANGPACK = exports.PACKAGE_EXTENSION = exports.PACKAGE_DICTIONARY = exports.PACKAGE_ANY = exports.MESSAGE_TYPES = exports.MESSAGE_PLACEHOLDER_REGEXP = exports.MESSAGES_JSON = exports.MAX_FILE_SIZE_TO_PARSE_MB = exports.MANIFEST_VERSION_MIN = exports.MANIFEST_VERSION_MAX = exports.MANIFEST_VERSION_DEFAULT = exports.MANIFEST_JSON = exports.LOCAL_PROTOCOLS = exports.LOCALES_DIRECTORY = exports.IMAGE_FILE_EXTENSIONS = exports.HIDDEN_FILE_REGEX = exports.FLAGGED_FILE_REGEX = exports.FLAGGED_FILE_MAGIC_NUMBERS = exports.FLAGGED_FILE_EXTENSIONS = exports.FILE_EXTENSIONS_TO_MIME = exports.EXTERNAL_RULE_MAPPING = exports.ESLINT_WARNING = exports.ESLINT_TYPES = exports.ESLINT_RULE_MAPPING = exports.ESLINT_ERROR = exports.DEPRECATED_MANIFEST_PROPERTIES = exports.DEPRECATED_JAVASCRIPT_APIS = exports.CSP_KEYWORD_RE = exports.ALREADY_SIGNED_REGEX = void 0;
const ESLINT_ERROR = 2;
exports.ESLINT_ERROR = ESLINT_ERROR;
const ESLINT_WARNING = 1;
exports.ESLINT_WARNING = ESLINT_WARNING;
const NO_UNSANITIZED_OPTIONS = {
  variableTracing: false,
  // Disable escapers (Sanitizer.escapeHTML, escapeHTML) and unwrappers
  // (Sanitizer.unwrapSafeHTML, unwrapSafeHTML) which are allowed by default by
  // this plugin.
  escape: {
    taggedTemplates: [],
    methods: []
  }
}; // 3rd party / eslint-internal rules

const EXTERNAL_RULE_MAPPING = {
  'no-eval': [ESLINT_WARNING, {
    allowIndirect: false
  }],
  'no-implied-eval': ESLINT_WARNING,
  'no-new-func': ESLINT_WARNING,
  'no-unsanitized/method': [ESLINT_WARNING, NO_UNSANITIZED_OPTIONS],
  'no-unsanitized/property': [ESLINT_WARNING, NO_UNSANITIZED_OPTIONS]
};
exports.EXTERNAL_RULE_MAPPING = EXTERNAL_RULE_MAPPING;
const ESLINT_RULE_MAPPING = {
  'deprecated-entities': ESLINT_WARNING,
  'event-listener-fourth': ESLINT_WARNING,
  'global-require-arg': ESLINT_WARNING,
  'opendialog-nonlit-uri': ESLINT_WARNING,
  'opendialog-remote-uri': ESLINT_WARNING,
  'webextension-api': ESLINT_WARNING,
  'webextension-deprecated-api': ESLINT_WARNING,
  'webextension-unsupported-api': ESLINT_WARNING,
  'content-scripts-file-absent': ESLINT_ERROR,
  'webextension-api-compat': ESLINT_WARNING,
  'webextension-api-compat-android': ESLINT_WARNING,
  ...EXTERNAL_RULE_MAPPING
};
exports.ESLINT_RULE_MAPPING = ESLINT_RULE_MAPPING;
const VALIDATION_ERROR = 'error';
exports.VALIDATION_ERROR = VALIDATION_ERROR;
const VALIDATION_NOTICE = 'notice';
exports.VALIDATION_NOTICE = VALIDATION_NOTICE;
const VALIDATION_WARNING = 'warning';
exports.VALIDATION_WARNING = VALIDATION_WARNING;
const ESLINT_TYPES = {
  0: VALIDATION_NOTICE,
  1: VALIDATION_WARNING,
  2: VALIDATION_ERROR
};
exports.ESLINT_TYPES = ESLINT_TYPES;
const MESSAGE_TYPES = [VALIDATION_ERROR, VALIDATION_NOTICE, VALIDATION_WARNING]; // Package type constants.

exports.MESSAGE_TYPES = MESSAGE_TYPES;
const PACKAGE_ANY = 0;
exports.PACKAGE_ANY = PACKAGE_ANY;
const PACKAGE_EXTENSION = 1;
exports.PACKAGE_EXTENSION = PACKAGE_EXTENSION;
const PACKAGE_THEME = 2;
exports.PACKAGE_THEME = PACKAGE_THEME;
const PACKAGE_DICTIONARY = 3;
exports.PACKAGE_DICTIONARY = PACKAGE_DICTIONARY;
const PACKAGE_LANGPACK = 4;
exports.PACKAGE_LANGPACK = PACKAGE_LANGPACK;
const PACKAGE_SEARCHPROV = 5;
exports.PACKAGE_SEARCHPROV = PACKAGE_SEARCHPROV;
const PACKAGE_MULTI = 1; // A multi extension is an extension

exports.PACKAGE_MULTI = PACKAGE_MULTI;
const PACKAGE_SUBPACKAGE = 7;
exports.PACKAGE_SUBPACKAGE = PACKAGE_SUBPACKAGE;
const PACKAGE_TYPES = {
  PACKAGE_ANY,
  PACKAGE_EXTENSION,
  PACKAGE_THEME,
  PACKAGE_DICTIONARY,
  PACKAGE_LANGPACK,
  PACKAGE_SEARCHPROV,
  PACKAGE_MULTI,
  PACKAGE_SUBPACKAGE
};
exports.PACKAGE_TYPES = PACKAGE_TYPES;
const LOCAL_PROTOCOLS = ['chrome:', 'resource:'];
exports.LOCAL_PROTOCOLS = LOCAL_PROTOCOLS;
const MANIFEST_JSON = 'manifest.json'; // The manifest_version value to use to complete the validation if an explicit one
// was missing from the extension manifest.json (but we will still be collecting the
// error for the missing manifest_version property, because it is mandatory).

exports.MANIFEST_JSON = MANIFEST_JSON;
const MANIFEST_VERSION_DEFAULT = 2; // Default min/max_manifest_version values used for schema definitions that do not
// have an explicit one on their own.

exports.MANIFEST_VERSION_DEFAULT = MANIFEST_VERSION_DEFAULT;
const MANIFEST_VERSION_MIN = 2;
exports.MANIFEST_VERSION_MIN = MANIFEST_VERSION_MIN;
const MANIFEST_VERSION_MAX = 3; // This is the limit in megabytes of a file we will parse (eg. CSS, JS, etc.)
// A singular CSS/JS file over 4MB seems bad and may actually be full of data
// best stored in JSON/some other data format rather than code.
// https://github.com/mozilla/addons-linter/issues/730
// We increased this limit from 2MB to 4MB as per:
// https://github.com/mozilla/addons/issues/181
//
// We should be careful about increasing this any further.

exports.MANIFEST_VERSION_MAX = MANIFEST_VERSION_MAX;
const MAX_FILE_SIZE_TO_PARSE_MB = 4;
exports.MAX_FILE_SIZE_TO_PARSE_MB = MAX_FILE_SIZE_TO_PARSE_MB;
const HIDDEN_FILE_REGEX = /^__MACOSX\//;
exports.HIDDEN_FILE_REGEX = HIDDEN_FILE_REGEX;
const FLAGGED_FILE_REGEX = /thumbs\.db$|\.DS_Store$|\.orig$|\.old$|~$/i;
exports.FLAGGED_FILE_REGEX = FLAGGED_FILE_REGEX;
const ALREADY_SIGNED_REGEX = /^META-INF\/manifest\.mf/;
exports.ALREADY_SIGNED_REGEX = ALREADY_SIGNED_REGEX;
const PERMS_DATAPATH_REGEX = /^\/(permissions|optional_permissions|host_permissions)\/([\d+])/;
exports.PERMS_DATAPATH_REGEX = PERMS_DATAPATH_REGEX;
const RESERVED_FILENAMES = ['mozilla-recommendation.json'];
exports.RESERVED_FILENAMES = RESERVED_FILENAMES;
const FLAGGED_FILE_EXTENSIONS = ['.class', '.dll', '.dylib', '.exe', '.jar', '.sh', '.so', '.swf'];
exports.FLAGGED_FILE_EXTENSIONS = FLAGGED_FILE_EXTENSIONS;
const IMAGE_FILE_EXTENSIONS = ['jpg', 'jpeg', 'webp', 'gif', 'png', 'svg'];
exports.IMAGE_FILE_EXTENSIONS = IMAGE_FILE_EXTENSIONS;
const FILE_EXTENSIONS_TO_MIME = {
  svg: 'image/svg+xml',
  gif: 'image/gif',
  jpg: 'image/jpeg',
  jpeg: 'image/jpeg',
  png: 'image/png',
  webp: 'image/webp'
}; // Unique list of mime types for the allowed static theme images.

exports.FILE_EXTENSIONS_TO_MIME = FILE_EXTENSIONS_TO_MIME;
const STATIC_THEME_IMAGE_MIMES = [...new Set(Object.values(FILE_EXTENSIONS_TO_MIME))]; // Mapping of "schema data paths" of the deprecated properties that we
// issue warnings for.
// If the value is `null` we will be using the `deprecated` message
// from the schema. Otherwise `code`, `message` and `description` will be taken
// from the object provided.
// Note that we have to use the constants name as we can't import
// the message object here.

exports.STATIC_THEME_IMAGE_MIMES = STATIC_THEME_IMAGE_MIMES;
const DEPRECATED_MANIFEST_PROPERTIES = {
  '/theme/images/headerURL': 'MANIFEST_THEME_LWT_ALIAS',
  '/theme/colors/accentcolor': 'MANIFEST_THEME_LWT_ALIAS',
  '/theme/colors/textcolor': 'MANIFEST_THEME_LWT_ALIAS'
}; // Mapping of deprecated javascript apis.
// If the value is `null` we will be using the `deprecated` message
// from the schema. Otherwise `code`, `message` and `description` will be taken
// from the object provided.
// Note that we have to use the constants name as we can't import
// the message object here.

exports.DEPRECATED_MANIFEST_PROPERTIES = DEPRECATED_MANIFEST_PROPERTIES;
const DEPRECATED_JAVASCRIPT_APIS = {
  // These APIs were already deprecated by Chrome and Firefox never
  // supported them. We do still issue deprecation warnings for them.
  'app.getDetails': 'DEPRECATED_CHROME_API',
  'extension.onRequest': 'DEPRECATED_CHROME_API',
  'extension.onRequestExternal': 'DEPRECATED_CHROME_API',
  'extension.sendRequest': 'DEPRECATED_CHROME_API',
  'tabs.getAllInWindow': 'DEPRECATED_CHROME_API',
  'tabs.getSelected': 'DEPRECATED_CHROME_API',
  'tabs.onActiveChanged': 'DEPRECATED_CHROME_API',
  'tabs.onSelectionChanged': 'DEPRECATED_CHROME_API',
  'tabs.sendRequest': 'DEPRECATED_CHROME_API',
  // https://github.com/mozilla/addons-linter/issues/2556
  'proxy.register': 'DEPRECATED_API',
  'proxy.unregister': 'DEPRECATED_API',
  'proxy.onProxyError': 'DEPRECATED_API',
  'proxy.registerProxyScript': 'DEPRECATED_API'
}; // A list of magic numbers that we won't allow.

exports.DEPRECATED_JAVASCRIPT_APIS = DEPRECATED_JAVASCRIPT_APIS;
const FLAGGED_FILE_MAGIC_NUMBERS = [[0x4d, 0x5a], // EXE or DLL,
[0x5a, 0x4d], // Alternative EXE or DLL
[0x7f, 0x45, 0x4c, 0x46], // UNIX elf
[0x23, 0x21], // Shell script
[0xca, 0xfe, 0xba, 0xbe], // Java + Mach-O (dylib)
[0xca, 0xfe, 0xd0, 0x0d], // Java packed
[0x43, 0x57, 0x53] // Compressed SWF
]; // These are APIs that will cause problems when loaded temporarily
// in about:debugging.
// APIs listed here should be defined in https://mzl.la/31p4AMc

exports.FLAGGED_FILE_MAGIC_NUMBERS = FLAGGED_FILE_MAGIC_NUMBERS;
const TEMPORARY_APIS = ['identity.getRedirectURL', 'storage.sync', 'storage.managed', 'runtime.onMessageExternal', 'runtime.onConnectExternal']; // All valid CSP keywords that are options to keys like `default-src` and
// `script-src`. Used in manifest.json parser for validation.
// See https://mzl.la/2vwqbGU for more details and allowed options.

exports.TEMPORARY_APIS = TEMPORARY_APIS;
const CSP_KEYWORD_RE = new RegExp(['(self|none|unsafe-inline|strict-dynamic|unsafe-hashed-attributes)', // Only match these keywords, anything else is forbidden
'(?!.)', '|(sha(256|384|512)-|nonce-)'].join(''));
exports.CSP_KEYWORD_RE = CSP_KEYWORD_RE;
const MESSAGES_JSON = 'messages.json';
exports.MESSAGES_JSON = MESSAGES_JSON;
const LOCALES_DIRECTORY = '_locales'; // This is a string, since it has to be matched globally on a message string.
// This should match
// https://searchfox.org/mozilla-central/rev/3abf6fa7e2a6d9a7bfb88796141b0f012e68c2db/toolkit/components/extensions/ExtensionCommon.jsm#1711

exports.LOCALES_DIRECTORY = LOCALES_DIRECTORY;
const MESSAGE_PLACEHOLDER_REGEXP = '\\$([a-zA-Z0-9_@]+)\\$'; // yauzl should trow error with this message in case of corrupt zip file

exports.MESSAGE_PLACEHOLDER_REGEXP = MESSAGE_PLACEHOLDER_REGEXP;
const ZIP_LIB_CORRUPT_FILE_ERROR = 'end of central directory record signature not found'; // URLs in this array are restricted from being used in the manifest.json "homepage_url" prperty

exports.ZIP_LIB_CORRUPT_FILE_ERROR = ZIP_LIB_CORRUPT_FILE_ERROR;
const RESTRICTED_HOMEPAGE_URLS = ['addons-dev.allizom.org', 'addons.mozilla.org']; // This map should contain entries with a permission name as key and a min
// Firefox version as value (both string values).

exports.RESTRICTED_HOMEPAGE_URLS = RESTRICTED_HOMEPAGE_URLS;
const RESTRICTED_PERMISSIONS = new Map([// See: https://bugzilla.mozilla.org/show_bug.cgi?id=1733159
['proxy', '91.1.0']]);
exports.RESTRICTED_PERMISSIONS = RESTRICTED_PERMISSIONS;

/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.UNSUPPORTED_API = exports.UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT = exports.UNEXPECTED_GLOGAL_ARG = exports.UNADVISED_LIBRARY = exports.STORAGE_SYNC = exports.STORAGE_MANAGED = exports.RUNTIME_ONMESSAGEEXTERNAL = exports.RUNTIME_ONCONNECTEXTERNAL = exports.REMOVED_MV2_API = exports.OPENDIALOG_REMOTE_URI = exports.OPENDIALOG_NONLIT_URI = exports.NO_IMPLIED_EVAL = exports.NO_DOCUMENT_WRITE = exports.KNOWN_LIBRARY = exports.JS_SYNTAX_ERROR = exports.INCOMPATIBLE_API = exports.IDENTITY_GETREDIRECTURL = exports.EVENT_LISTENER_FOURTH = exports.ESLINT_OVERWRITE_MESSAGE = exports.DEPRECATED_CHROME_API = exports.DEPRECATED_API = exports.DANGEROUS_EVAL = exports.CONTENT_SCRIPT_NOT_FOUND = exports.CONTENT_SCRIPT_EMPTY = exports.BANNED_LIBRARY = exports.ANDROID_INCOMPATIBLE_API = void 0;
exports._methodPassedRemoteUri = _methodPassedRemoteUri;
exports._nonLiteralUri = _nonLiteralUri;

var _commonTags = __webpack_require__(7);

var _utils = __webpack_require__(2);

const JS_SYNTAX_ERROR = {
  code: 'JS_SYNTAX_ERROR',
  message: _utils.i18n._('JavaScript syntax error'),
  description: _utils.i18n._((0, _commonTags.oneLine)`There is a JavaScript syntax error in your
    code, which might be related to some experimental JavaScript features that
    aren't an official part of the language specification and therefore not
    supported yet. The validation cannot continue on this file.`)
};
exports.JS_SYNTAX_ERROR = JS_SYNTAX_ERROR;
const EVENT_LISTENER_FOURTH = {
  code: 'EVENT_LISTENER_FOURTH',
  message: _utils.i18n._('addEventListener` called with truthy fourth argument.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`When called with a truthy forth argument,
    listeners can be triggered potentially unsafely by untrusted code. This
    requires careful review.`)
};
exports.EVENT_LISTENER_FOURTH = EVENT_LISTENER_FOURTH;
const CONTENT_SCRIPT_NOT_FOUND = {
  code: 'CONTENT_SCRIPT_NOT_FOUND',
  legacyCode: null,
  message: _utils.i18n._('Content script file could not be found.'),
  description: _utils.i18n._('Content script file could not be found')
};
exports.CONTENT_SCRIPT_NOT_FOUND = CONTENT_SCRIPT_NOT_FOUND;
const CONTENT_SCRIPT_EMPTY = {
  code: 'CONTENT_SCRIPT_EMPTY',
  legacyCode: null,
  message: _utils.i18n._('Content script file name should not be empty.'),
  description: _utils.i18n._('Content script file name should not be empty')
};
exports.CONTENT_SCRIPT_EMPTY = CONTENT_SCRIPT_EMPTY;

function _nonLiteralUri(method) {
  return {
    code: `${method}_NONLIT_URI`.toUpperCase(),
    message: _utils.i18n._(`'${method}' called with a non-literal uri`),
    description: _utils.i18n._((0, _commonTags.oneLine)`Calling '${method}' with variable
      parameters can result in potential security vulnerabilities if the
      variable contains a remote URI. Consider using 'window.open' with
      the 'chrome=no' flag.`)
  };
}

function _methodPassedRemoteUri(method) {
  return {
    code: `${method}_REMOTE_URI`.toUpperCase(),
    message: _utils.i18n._(`'${method}' called with non-local URI`),
    description: _utils.i18n._((0, _commonTags.oneLine)`Calling '${method}' with a non-local
      URI will result in the dialog being opened with chrome privileges.`)
  };
}

const OPENDIALOG_REMOTE_URI = _methodPassedRemoteUri('openDialog');

exports.OPENDIALOG_REMOTE_URI = OPENDIALOG_REMOTE_URI;

const OPENDIALOG_NONLIT_URI = _nonLiteralUri('openDialog');

exports.OPENDIALOG_NONLIT_URI = OPENDIALOG_NONLIT_URI;
const DANGEROUS_EVAL = {
  code: 'DANGEROUS_EVAL',
  message: null,
  description: _utils.i18n._((0, _commonTags.oneLine)`Evaluation of strings as code can lead to
    security vulnerabilities and performance issues, even in the
    most innocuous of circumstances. Please avoid using \`eval\` and the
    \`Function\` constructor when at all possible.'`)
};
exports.DANGEROUS_EVAL = DANGEROUS_EVAL;
const NO_IMPLIED_EVAL = {
  code: 'NO_IMPLIED_EVAL',
  message: null,
  description: _utils.i18n._((0, _commonTags.oneLine)`setTimeout, setInterval and execScript
    functions should be called only with function expressions as their
    first argument`)
};
exports.NO_IMPLIED_EVAL = NO_IMPLIED_EVAL;
const UNEXPECTED_GLOGAL_ARG = {
  code: 'UNEXPECTED_GLOGAL_ARG',
  message: _utils.i18n._('Unexpected global passed as an argument'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Passing a global as an argument
    is not recommended. Please make this a var instead.`)
};
exports.UNEXPECTED_GLOGAL_ARG = UNEXPECTED_GLOGAL_ARG;
const NO_DOCUMENT_WRITE = {
  code: 'NO_DOCUMENT_WRITE',
  message: _utils.i18n._('Use of document.write strongly discouraged.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`document.write will fail in many
    circumstances when used in extensions, and has potentially severe security
    repercussions when used improperly. Therefore, it should not be used.`)
};
exports.NO_DOCUMENT_WRITE = NO_DOCUMENT_WRITE;
const BANNED_LIBRARY = {
  code: 'BANNED_LIBRARY',
  message: _utils.i18n._('Banned 3rd-party JS library'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Your add-on uses a JavaScript library we
    consider unsafe. Read more: https://bit.ly/1TRIyZY`)
};
exports.BANNED_LIBRARY = BANNED_LIBRARY;
const UNADVISED_LIBRARY = {
  code: 'UNADVISED_LIBRARY',
  message: _utils.i18n._('Unadvised 3rd-party JS library'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Your add-on uses a JavaScript library we do
    not recommend. Read more: https://bit.ly/1TRIyZY`)
};
exports.UNADVISED_LIBRARY = UNADVISED_LIBRARY;
const KNOWN_LIBRARY = {
  code: 'KNOWN_LIBRARY',
  message: _utils.i18n._('Known JS library detected'),
  description: _utils.i18n._((0, _commonTags.oneLine)`JavaScript libraries are discouraged for
    simple add-ons, but are generally accepted.`)
};
exports.KNOWN_LIBRARY = KNOWN_LIBRARY;
const UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT = {
  code: 'UNSAFE_VAR_ASSIGNMENT',
  // Uses original message from eslint
  message: null,
  description: _utils.i18n._((0, _commonTags.oneLine)`Due to both security and performance
    concerns, this may not be set using dynamic values which have
    not been adequately sanitized. This can lead to security issues or fairly
    serious performance degradation.`)
};
exports.UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT = UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT;
const UNSUPPORTED_API = {
  code: 'UNSUPPORTED_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is not supported'),
  description: _utils.i18n._('This API has not been implemented by Firefox.')
};
exports.UNSUPPORTED_API = UNSUPPORTED_API;
const REMOVED_MV2_API = {
  code: 'UNSUPPORTED_API',
  message: null,
  messageFormat: _utils.i18n._('"{{api}}" has been removed in Manifest Version 3 (`manifest_version` property)'),
  description: null
};
exports.REMOVED_MV2_API = REMOVED_MV2_API;
const DEPRECATED_API = {
  code: 'DEPRECATED_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is deprecated'),
  description: _utils.i18n._('This API has been deprecated by Firefox.')
};
exports.DEPRECATED_API = DEPRECATED_API;
const DEPRECATED_CHROME_API = {
  // We are re-using the same code here for consistency and for technical
  // reasons. We aren't really able to issue different codes from the same
  // rule, so until we have to, we're going to re-use the `DEPRECATED_API`
  // code.
  // Because of that implementation detail ``description`` isn't being usable
  // too.
  code: 'DEPRECATED_API',
  message: null,
  messageFormat: _utils.i18n._('"{{api}}" is deprecated or unimplemented'),
  description: null
};
exports.DEPRECATED_CHROME_API = DEPRECATED_CHROME_API;

function temporaryAPI(api) {
  return {
    code: (0, _utils.apiToMessage)(api),
    message: _utils.i18n._(`"${api}" can cause issues when loaded temporarily`),
    description: _utils.i18n._((0, _commonTags.oneLine)`This API can cause issues when loaded
      temporarily using about:debugging in Firefox unless you specify
      applications|browser_specific_settings > gecko > id in the manifest.
      Please see: https://mzl.la/2hizK4a for more.`)
  };
}

const STORAGE_SYNC = temporaryAPI('storage.sync');
exports.STORAGE_SYNC = STORAGE_SYNC;
const IDENTITY_GETREDIRECTURL = temporaryAPI('identity.getRedirectURL');
exports.IDENTITY_GETREDIRECTURL = IDENTITY_GETREDIRECTURL;
const STORAGE_MANAGED = temporaryAPI('storage.managed');
exports.STORAGE_MANAGED = STORAGE_MANAGED;
const RUNTIME_ONMESSAGEEXTERNAL = temporaryAPI('runtime.onMessageExternal');
exports.RUNTIME_ONMESSAGEEXTERNAL = RUNTIME_ONMESSAGEEXTERNAL;
const RUNTIME_ONCONNECTEXTERNAL = temporaryAPI('runtime.onConnectExternal');
exports.RUNTIME_ONCONNECTEXTERNAL = RUNTIME_ONCONNECTEXTERNAL;
const INCOMPATIBLE_API = {
  code: 'INCOMPATIBLE_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is not supported in Firefox version {{minVersion}}'),
  description: _utils.i18n._('This API is not implemented by the given minimum Firefox version')
};
exports.INCOMPATIBLE_API = INCOMPATIBLE_API;
const ANDROID_INCOMPATIBLE_API = {
  code: 'ANDROID_INCOMPATIBLE_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is not supported in Firefox for Android version {{minVersion}}'),
  description: _utils.i18n._('This API is not implemented by the given minimum Firefox for Android version')
};
exports.ANDROID_INCOMPATIBLE_API = ANDROID_INCOMPATIBLE_API;
const ESLINT_OVERWRITE_MESSAGE = {
  'no-eval': DANGEROUS_EVAL,
  'no-implied-eval': NO_IMPLIED_EVAL,
  'no-new-func': DANGEROUS_EVAL,
  'no-unsanitized/property': UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT,
  'no-unsanitized/method': UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT,
  'webextension-unsupported-api': UNSUPPORTED_API,
  'webextension-deprecated-api': DEPRECATED_API,
  'webextension-api-compat': INCOMPATIBLE_API,
  'webextension-api-compat-android': ANDROID_INCOMPATIBLE_API
};
exports.ESLINT_OVERWRITE_MESSAGE = ESLINT_OVERWRITE_MESSAGE;

/***/ }),
/* 13 */,
/* 14 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var _css = __webpack_require__(15);

Object.keys(_css).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _css[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _css[key];
    }
  });
});

var _html = __webpack_require__(16);

Object.keys(_html).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _html[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _html[key];
    }
  });
});

var _javascript = __webpack_require__(12);

Object.keys(_javascript).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _javascript[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _javascript[key];
    }
  });
});

var _json = __webpack_require__(17);

Object.keys(_json).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _json[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _json[key];
    }
  });
});

var _layout = __webpack_require__(18);

Object.keys(_layout).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _layout[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _layout[key];
    }
  });
});

var _manifestjson = __webpack_require__(19);

Object.keys(_manifestjson).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _manifestjson[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _manifestjson[key];
    }
  });
});

var _fluent = __webpack_require__(20);

Object.keys(_fluent).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _fluent[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _fluent[key];
    }
  });
});

var _localeMessagesjson = __webpack_require__(21);

Object.keys(_localeMessagesjson).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _localeMessagesjson[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _localeMessagesjson[key];
    }
  });
});

/***/ }),
/* 15 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.INVALID_SELECTOR_NESTING = exports.CSS_SYNTAX_ERROR = void 0;

var _commonTags = __webpack_require__(7);

var _utils = __webpack_require__(2);

const CSS_SYNTAX_ERROR = {
  code: 'CSS_SYNTAX_ERROR',
  // This will be overriden by the reason passed from the error.
  message: _utils.i18n._('A CSS syntax error was encountered'),
  description: _utils.i18n._((0, _commonTags.oneLine)`An error was found in the CSS file being
    processed as a result further processing of that file is not possible`)
};
exports.CSS_SYNTAX_ERROR = CSS_SYNTAX_ERROR;
const INVALID_SELECTOR_NESTING = {
  code: 'INVALID_SELECTOR_NESTING',
  message: _utils.i18n._('Invalid nesting of selectors found'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Selectors should not be nested`)
};
exports.INVALID_SELECTOR_NESTING = INVALID_SELECTOR_NESTING;

/***/ }),
/* 16 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.REMOTE_SCRIPT = exports.INLINE_SCRIPT = void 0;

var _commonTags = __webpack_require__(7);

var _utils = __webpack_require__(2);

const INLINE_SCRIPT = {
  code: 'INLINE_SCRIPT',
  message: _utils.i18n._('Inline scripts blocked by default'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Default CSP rules prevent inline JavaScript
    from running (https://mzl.la/2pn32nd).`)
};
exports.INLINE_SCRIPT = INLINE_SCRIPT;
const REMOTE_SCRIPT = {
  code: 'REMOTE_SCRIPT',
  message: _utils.i18n._('Remote scripts are not allowed as per the Add-on Policies.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Please include all scripts in the add-on.
    For more information, refer to https://mzl.la/2uEOkYp.`)
};
exports.REMOTE_SCRIPT = REMOTE_SCRIPT;

/***/ }),
/* 17 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.JSON_INVALID = exports.JSON_DUPLICATE_KEY = exports.JSON_BLOCK_COMMENTS = void 0;

var _commonTags = __webpack_require__(7);

var _utils = __webpack_require__(2);

const JSON_INVALID = {
  code: 'JSON_INVALID',
  message: _utils.i18n._('Your JSON is not valid.'),
  description: _utils.i18n._('Your JSON file could not be parsed.')
};
exports.JSON_INVALID = JSON_INVALID;
const JSON_BLOCK_COMMENTS = {
  code: 'JSON_BLOCK_COMMENTS',
  message: _utils.i18n._('Your JSON contains block comments.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Only line comments (comments beginning with
    "//") are allowed in JSON files. Please remove block comments (comments
    beginning with "/*")`)
};
exports.JSON_BLOCK_COMMENTS = JSON_BLOCK_COMMENTS;
const JSON_DUPLICATE_KEY = {
  code: 'JSON_DUPLICATE_KEY',
  message: _utils.i18n._('Duplicate keys are not allowed in JSON files.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Duplicate key found in JSON file.`)
};
exports.JSON_DUPLICATE_KEY = JSON_DUPLICATE_KEY;

/***/ }),
/* 18 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.TYPE_NO_MANIFEST_JSON = exports.RESERVED_FILENAME = exports.INVALID_XPI_ENTRY = exports.HIDDEN_FILE = exports.FLAGGED_FILE_TYPE = exports.FLAGGED_FILE_EXTENSION = exports.FLAGGED_FILE = exports.FILE_TOO_LARGE = exports.DUPLICATE_XPI_ENTRY = exports.COINMINER_USAGE_DETECTED = exports.BAD_ZIPFILE = exports.ALREADY_SIGNED = void 0;

var _commonTags = __webpack_require__(7);

var _const = __webpack_require__(11);

var _utils = __webpack_require__(2);

const DUPLICATE_XPI_ENTRY = {
  code: 'DUPLICATE_XPI_ENTRY',
  message: _utils.i18n._('Package contains duplicate entries'),
  description: _utils.i18n._((0, _commonTags.oneLine)`The package contains multiple entries
    with the same name. This practice has been banned. Try unzipping
    and re-zipping your add-on package and try again.`)
};
exports.DUPLICATE_XPI_ENTRY = DUPLICATE_XPI_ENTRY;
const INVALID_XPI_ENTRY = {
  code: 'INVALID_XPI_ENTRY',
  // `message` will be replaced with the `InvalidZipFileError` message
  // got from the addons-scanner-utils dependency when we were reading
  // the zip file entries (in particular this would be triggered by
  // a zipfile entry using invalid characters, like '\' as a path
  // separator, and the underlying yauzl error message follows the
  // format:
  //   `invalid characters in fileName: nameOfTheInvalidZipFileEntry`
  message: 'Invalid ZIP file entry',
  description: _utils.i18n._((0, _commonTags.oneLine)`The package is invalid. It may contain
    entries using invalid characters, as an example using '\\' as a
    path separator is not allowed in Firefox. Try to recreate your
    add-on package (ZIP) and make sure all entries are using '/' as the
    path separator.`)
};
exports.INVALID_XPI_ENTRY = INVALID_XPI_ENTRY;
const BAD_ZIPFILE = {
  code: 'BAD_ZIPFILE',
  message: 'Corrupt ZIP file',
  description: _utils.i18n._('We were unable to decompress the zip file.')
};
exports.BAD_ZIPFILE = BAD_ZIPFILE;
const TYPE_NO_MANIFEST_JSON = {
  code: 'TYPE_NO_MANIFEST_JSON',
  message: _utils.i18n._('manifest.json was not found'),
  description: _utils.i18n._((0, _commonTags.oneLine)`No manifest.json was found at the root of the extension.
    The package file must be a ZIP of the extension's files themselves, not of the
    containing directory. See: https://mzl.la/2r2McKv for more on packaging.`)
};
exports.TYPE_NO_MANIFEST_JSON = TYPE_NO_MANIFEST_JSON;
const FILE_TOO_LARGE = {
  code: 'FILE_TOO_LARGE',
  message: _utils.i18n._('File is too large to parse.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`This file is not binary and is too large to
    parse. Files larger than ${_const.MAX_FILE_SIZE_TO_PARSE_MB}MB will not be
    parsed. Consider moving large lists of data out of JavaScript files and
    into JSON files, or splitting very large files into smaller ones.`)
};
exports.FILE_TOO_LARGE = FILE_TOO_LARGE;
const HIDDEN_FILE = {
  code: 'HIDDEN_FILE',
  message: _utils.i18n._('Hidden file flagged'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Hidden files complicate the
    review process and can contain sensitive information about the system that
    generated the add-on. Please modify the packaging process so that these
    files aren't included.`)
};
exports.HIDDEN_FILE = HIDDEN_FILE;
const FLAGGED_FILE = {
  code: 'FLAGGED_FILE',
  message: _utils.i18n._('Flagged filename found'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Files were found that are either unnecessary
    or have been included unintentionally. They should be removed.`)
};
exports.FLAGGED_FILE = FLAGGED_FILE;
const FLAGGED_FILE_EXTENSION = {
  code: 'FLAGGED_FILE_EXTENSION',
  message: _utils.i18n._('Flagged file extensions found'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Files were found that are either unnecessary
    or have been included unintentionally. They should be removed.`)
};
exports.FLAGGED_FILE_EXTENSION = FLAGGED_FILE_EXTENSION;
const FLAGGED_FILE_TYPE = {
  code: 'FLAGGED_FILE_TYPE',
  message: _utils.i18n._('Flagged file type found'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Files whose names end with flagged extensions
    have been found in the add-on. The extension of these files are flagged
    because they usually identify binary components. Please see
    https://bit.ly/review-policy for more information on the binary content
    review process.`)
};
exports.FLAGGED_FILE_TYPE = FLAGGED_FILE_TYPE;
const ALREADY_SIGNED = {
  code: 'ALREADY_SIGNED',
  message: _utils.i18n._('Package already signed'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Add-ons which are already signed will be
    re-signed when published on AMO. This will replace any existing signatures
    on the add-on.`)
};
exports.ALREADY_SIGNED = ALREADY_SIGNED;
const COINMINER_USAGE_DETECTED = {
  code: 'COINMINER_USAGE_DETECTED',
  message: _utils.i18n._('Firefox add-ons are not allowed to run coin miners.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`We do not allow coinminer scripts to be run inside
    WebExtensions.
    See https://github.com/mozilla/addons-linter/issues/1643 for more
    details.`)
};
exports.COINMINER_USAGE_DETECTED = COINMINER_USAGE_DETECTED;
const RESERVED_FILENAME = {
  code: 'RESERVED_FILENAME',
  message: _utils.i18n._('Reserved filename found.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Files whose names are reserved have been found in
    the add-on. Please refrain from using them and rename your files.`)
};
exports.RESERVED_FILENAME = RESERVED_FILENAME;

/***/ }),
/* 19 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.WRONG_ICON_EXTENSION = exports.STRICT_MAX_VERSION = exports.RESTRICTED_PERMISSION = exports.RESTRICTED_HOMEPAGE_URL = exports.PROP_VERSION_TOOLKIT_ONLY = exports.PROP_VERSION_MISSING = exports.PROP_VERSION_INVALID = exports.PROP_NAME_MISSING = exports.PROP_NAME_INVALID = exports.PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = exports.PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = exports.NO_MESSAGES_FILE_IN_LOCALES = exports.NO_MESSAGES_FILE = exports.NO_DEFAULT_LOCALE = exports.MANIFEST_VERSION_INVALID = exports.MANIFEST_UPDATE_URL = exports.MANIFEST_UNUSED_UPDATE = exports.MANIFEST_THEME_LWT_ALIAS = exports.MANIFEST_THEME_IMAGE_WRONG_MIME = exports.MANIFEST_THEME_IMAGE_WRONG_EXT = exports.MANIFEST_THEME_IMAGE_NOT_FOUND = exports.MANIFEST_THEME_IMAGE_MIME_MISMATCH = exports.MANIFEST_THEME_IMAGE_CORRUPTED = exports.MANIFEST_PERMISSION_UNSUPPORTED = exports.MANIFEST_PERMISSIONS = exports.MANIFEST_OPTIONAL_PERMISSIONS = exports.MANIFEST_MULTIPLE_DICTS = exports.MANIFEST_INVALID_CONTENT = exports.MANIFEST_ICON_NOT_FOUND = exports.MANIFEST_HOST_PERMISSIONS = exports.MANIFEST_FIELD_UNSUPPORTED = exports.MANIFEST_FIELD_REQUIRED = exports.MANIFEST_FIELD_INVALID = exports.MANIFEST_FIELD_DEPRECATED = exports.MANIFEST_EMPTY_DICTS = exports.MANIFEST_DICT_NOT_FOUND = exports.MANIFEST_DICT_MISSING_ID = exports.MANIFEST_CSP_UNSAFE_EVAL = exports.MANIFEST_CSP = exports.MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND = exports.MANIFEST_BAD_PERMISSION = exports.MANIFEST_BAD_OPTIONAL_PERMISSION = exports.MANIFEST_BAD_HOST_PERMISSION = exports.MANIFEST_BACKGROUND_FILE_NOT_FOUND = exports.KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = exports.KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = exports.IGNORED_APPLICATIONS_PROPERTY = exports.ICON_SIZE_INVALID = exports.ICON_NOT_SQUARE = exports.CORRUPT_ICON_FILE = void 0;
exports.corruptIconFile = corruptIconFile;
exports.iconIsNotSquare = iconIsNotSquare;
exports.iconSizeInvalid = iconSizeInvalid;
exports.keyFirefoxAndroidUnsupportedByMinVersion = keyFirefoxAndroidUnsupportedByMinVersion;
exports.keyFirefoxUnsupportedByMinVersion = keyFirefoxUnsupportedByMinVersion;
exports.makeRestrictedPermission = void 0;
exports.manifestBackgroundMissing = manifestBackgroundMissing;
exports.manifestContentScriptFileMissing = manifestContentScriptFileMissing;
exports.manifestCsp = manifestCsp;
exports.manifestCspUnsafeEval = manifestCspUnsafeEval;
exports.manifestDictionaryFileMissing = manifestDictionaryFileMissing;
exports.manifestFieldUnsupported = manifestFieldUnsupported;
exports.manifestIconMissing = manifestIconMissing;
exports.manifestPermissionUnsupported = manifestPermissionUnsupported;
exports.manifestPropMissing = manifestPropMissing;
exports.manifestThemeImageCorrupted = manifestThemeImageCorrupted;
exports.manifestThemeImageMimeMismatch = manifestThemeImageMimeMismatch;
exports.manifestThemeImageMissing = manifestThemeImageMissing;
exports.manifestThemeImageWrongExtension = manifestThemeImageWrongExtension;
exports.manifestThemeImageWrongMime = manifestThemeImageWrongMime;
exports.noMessagesFileInLocales = noMessagesFileInLocales;
exports.permissionFirefoxAndroidUnsupportedByMinVersion = permissionFirefoxAndroidUnsupportedByMinVersion;
exports.permissionFirefoxUnsupportedByMinVersion = permissionFirefoxUnsupportedByMinVersion;

var _commonTags = __webpack_require__(7);

var _utils = __webpack_require__(2);

var _const = __webpack_require__(11);

const MANIFEST_FIELD_REQUIRED = {
  code: 'MANIFEST_FIELD_REQUIRED',
  message: _utils.i18n._('The field is required.'),
  description: _utils.i18n._('See https://mzl.la/1ZOhoEN (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_FIELD_REQUIRED = MANIFEST_FIELD_REQUIRED;
const MANIFEST_FIELD_INVALID = {
  code: 'MANIFEST_FIELD_INVALID',
  message: _utils.i18n._('The field is invalid.'),
  description: _utils.i18n._('See https://mzl.la/1ZOhoEN (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_FIELD_INVALID = MANIFEST_FIELD_INVALID;
const MANIFEST_FIELD_UNSUPPORTED = 'MANIFEST_FIELD_UNSUPPORTED';
exports.MANIFEST_FIELD_UNSUPPORTED = MANIFEST_FIELD_UNSUPPORTED;

function manifestFieldUnsupported(fieldName, error) {
  const versionRange = (0, _utils.errorParamsToUnsupportedVersionRange)(error.params);
  const messageTmpl = versionRange ? _utils.i18n._((0, _commonTags.oneLine)`"%(fieldName)s" is in a format not supported in
                     manifest versions %(versionRange)s.`) : _utils.i18n._((0, _commonTags.oneLine)`"%(fieldName)s" is in an unsupported format.`);

  const message = _utils.i18n.sprintf(messageTmpl, {
    fieldName,
    versionRange
  });

  return {
    code: MANIFEST_FIELD_UNSUPPORTED,
    message,
    description: message,
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_PERMISSION_UNSUPPORTED = 'MANIFEST_PERMISSION_UNSUPPORTED';
exports.MANIFEST_PERMISSION_UNSUPPORTED = MANIFEST_PERMISSION_UNSUPPORTED;

function manifestPermissionUnsupported(permissionName, error) {
  const versionRange = (0, _utils.errorParamsToUnsupportedVersionRange)(error.params);
  const messageTmpl = versionRange ? _utils.i18n._((0, _commonTags.oneLine)`/%(fieldName)s: "%(permissionName)s" is not supported in
                     manifest versions %(versionRange)s.`) : _utils.i18n._((0, _commonTags.oneLine)`/%(fieldName)s: "%(permissionName)s" is not supported.`);

  const message = _utils.i18n.sprintf(messageTmpl, {
    permissionName,
    versionRange,
    fieldName: error.dataPath.match(_const.PERMS_DATAPATH_REGEX)[1]
  });

  return {
    code: MANIFEST_PERMISSION_UNSUPPORTED,
    message,
    description: message,
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_BAD_PERMISSION = {
  code: 'MANIFEST_BAD_PERMISSION',
  message: _utils.i18n._('The permission type is unsupported.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`See https://mzl.la/1R1n1t0
    (MDN Docs) for more information.`),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_BAD_PERMISSION = MANIFEST_BAD_PERMISSION;
const MANIFEST_BAD_OPTIONAL_PERMISSION = {
  code: 'MANIFEST_BAD_OPTIONAL_PERMISSION',
  message: _utils.i18n._('The permission type is unsupported.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`See https://mzl.la/2Qn0fWC
    (MDN Docs) for more information.`),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_BAD_OPTIONAL_PERMISSION = MANIFEST_BAD_OPTIONAL_PERMISSION;
const MANIFEST_BAD_HOST_PERMISSION = {
  code: 'MANIFEST_BAD_HOST_PERMISSION',
  message: _utils.i18n._('The permission type is unsupported.'),
  // TODO(https://github.com/mozilla/addons-linter/issues/3893): link host_permissions
  // MDN doc page here once we have created it.
  description: _utils.i18n._('The permission type is unsupported.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_BAD_HOST_PERMISSION = MANIFEST_BAD_HOST_PERMISSION;
const MANIFEST_PERMISSIONS = {
  code: 'MANIFEST_PERMISSIONS',
  message: _utils.i18n._('Unknown permission.'),
  description: _utils.i18n._('See https://mzl.la/1R1n1t0 (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_PERMISSIONS = MANIFEST_PERMISSIONS;
const MANIFEST_OPTIONAL_PERMISSIONS = {
  code: 'MANIFEST_OPTIONAL_PERMISSIONS',
  message: _utils.i18n._('Unknown permission.'),
  description: _utils.i18n._('See https://mzl.la/2Qn0fWC (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_OPTIONAL_PERMISSIONS = MANIFEST_OPTIONAL_PERMISSIONS;
const MANIFEST_HOST_PERMISSIONS = {
  code: 'MANIFEST_HOST_PERMISSIONS',
  message: _utils.i18n._('Invalid host permission.'),
  // TODO(https://github.com/mozilla/addons-linter/issues/3893): link host_permissions
  // MDN doc page here once we have created it.
  description: _utils.i18n._('Invalid host permission.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_HOST_PERMISSIONS = MANIFEST_HOST_PERMISSIONS;
const MANIFEST_VERSION_INVALID = {
  code: 'MANIFEST_VERSION_INVALID',
  message: _utils.i18n._('"manifest_version" in the manifest.json is not a valid value'),
  description: _utils.i18n._('See https://mzl.la/20PenXl (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_VERSION_INVALID = MANIFEST_VERSION_INVALID;
const MANIFEST_CSP = 'MANIFEST_CSP';
exports.MANIFEST_CSP = MANIFEST_CSP;

function manifestCsp(property) {
  return {
    // Note: don't change this 'code' without updating addons-server first, as
    // it depends on it to detect add-ons with a custom content security policy.
    code: MANIFEST_CSP,
    message: _utils.i18n._((0, _commonTags.oneLine)`
      "${property}" allows remote code execution in manifest.json`),
    description: _utils.i18n._(`A custom ${property} needs additional review.`),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_CSP_UNSAFE_EVAL = 'MANIFEST_CSP_UNSAFE_EVAL';
exports.MANIFEST_CSP_UNSAFE_EVAL = MANIFEST_CSP_UNSAFE_EVAL;

function manifestCspUnsafeEval(property) {
  return {
    code: MANIFEST_CSP_UNSAFE_EVAL,
    message: _utils.i18n._((0, _commonTags.oneLine)`
      ${property} allows 'eval', which has strong security and performance implications.`),
    description: _utils.i18n._((0, _commonTags.oneLine)`
      In most cases the same result can be achieved differently,
      therefore it is generally prohibited`),
    file: _const.MANIFEST_JSON
  };
}

const PROP_NAME_INVALID = {
  code: 'PROP_NAME_INVALID',
  message: _utils.i18n._('The "name" property must be a string.'),
  description: _utils.i18n._('See http://mzl.la/1STmr48 (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
exports.PROP_NAME_INVALID = PROP_NAME_INVALID;
const PROP_VERSION_INVALID = {
  code: 'PROP_VERSION_INVALID',
  message: _utils.i18n._('The "version" property must be a string.'),
  description: _utils.i18n._('See http://mzl.la/1kXIADa (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
exports.PROP_VERSION_INVALID = PROP_VERSION_INVALID;
const PROP_VERSION_TOOLKIT_ONLY = {
  code: 'PROP_VERSION_TOOLKIT_ONLY',
  message: _utils.i18n._('The "version" property uses a Firefox-specific format.'),
  description: _utils.i18n._('See http://mzl.la/1kXIADa (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
exports.PROP_VERSION_TOOLKIT_ONLY = PROP_VERSION_TOOLKIT_ONLY;
const MANIFEST_UPDATE_URL = {
  code: 'MANIFEST_UPDATE_URL',
  message: _utils.i18n._('"update_url" is not allowed.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`
    "applications.gecko.update_url" or
    "browser_specific_settings.gecko.update_url" are not allowed for
    Mozilla-hosted add-ons.`),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_UPDATE_URL = MANIFEST_UPDATE_URL;
const MANIFEST_UNUSED_UPDATE = {
  code: 'MANIFEST_UNUSED_UPDATE',
  message: _utils.i18n._('The "update_url" property is not used by Firefox.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`The "update_url" is not used by Firefox in
    the root of a manifest; your add-on will be updated via the Add-ons
    site and not your "update_url". See: https://mzl.la/25zqk4O`),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_UNUSED_UPDATE = MANIFEST_UNUSED_UPDATE;
const STRICT_MAX_VERSION = {
  code: 'STRICT_MAX_VERSION',
  message: _utils.i18n._('"strict_max_version" not required.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`"strict_max_version" shouldn't be used unless
    the add-on is expected not to work with future versions of Firefox.`),
  file: _const.MANIFEST_JSON
};
exports.STRICT_MAX_VERSION = STRICT_MAX_VERSION;

function manifestPropMissing(property) {
  return {
    code: `PROP_${property.toUpperCase()}_MISSING`,
    message: _utils.i18n._(`No "${property}" property found in manifest.json`),
    description: _utils.i18n._(`"${property}" is required`),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_ICON_NOT_FOUND = 'MANIFEST_ICON_NOT_FOUND';
exports.MANIFEST_ICON_NOT_FOUND = MANIFEST_ICON_NOT_FOUND;

function manifestIconMissing(path) {
  return {
    code: MANIFEST_ICON_NOT_FOUND,
    message: _utils.i18n._('An icon defined in the manifest could not be found in the package.'),
    description: _utils.i18n.sprintf(_utils.i18n._('Icon could not be found at "%(path)s".'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_BACKGROUND_FILE_NOT_FOUND = 'MANIFEST_BACKGROUND_FILE_NOT_FOUND';
exports.MANIFEST_BACKGROUND_FILE_NOT_FOUND = MANIFEST_BACKGROUND_FILE_NOT_FOUND;

function manifestBackgroundMissing(path, type) {
  return {
    code: MANIFEST_BACKGROUND_FILE_NOT_FOUND,
    legacyCode: null,
    message: type === 'script' ? _utils.i18n._('A background script defined in the manifest could not be found.') : _utils.i18n._('A background page defined in the manifest could not be found.'),
    description: _utils.i18n.sprintf(type === 'script' ? _utils.i18n._('Background script could not be found at "%(path)s".') : _utils.i18n._('Background page could not be found at "%(path)s".'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND = 'MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND';
exports.MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND = MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND;

function manifestContentScriptFileMissing(path, type) {
  return {
    code: MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND,
    legacyCode: null,
    message: type === 'script' ? _utils.i18n._('A content script defined in the manifest could not be found.') : _utils.i18n._('A content script css file defined in the manifest could not be found.'),
    description: _utils.i18n.sprintf(type === 'script' ? _utils.i18n._('Content script defined in the manifest could not be found at "%(path)s".') : _utils.i18n._('Content script css file defined in the manifest could not be found at "%(path)s".'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_DICT_NOT_FOUND = 'MANIFEST_DICT_NOT_FOUND';
exports.MANIFEST_DICT_NOT_FOUND = MANIFEST_DICT_NOT_FOUND;

function manifestDictionaryFileMissing(path) {
  return {
    code: MANIFEST_DICT_NOT_FOUND,
    legacyCode: null,
    message: _utils.i18n._('A dictionary file defined in the manifest could not be found.'),
    description: _utils.i18n.sprintf(_utils.i18n._('Dictionary file defined in the manifest could not be found at "%(path)s".'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_MULTIPLE_DICTS = {
  code: 'MANIFEST_MULTIPLE_DICTS',
  legacyCode: null,
  message: _utils.i18n._('The manifest contains multiple dictionaries.'),
  description: _utils.i18n._('Multiple dictionaries were defined in the manifest, which is unsupported.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_MULTIPLE_DICTS = MANIFEST_MULTIPLE_DICTS;
const MANIFEST_EMPTY_DICTS = {
  code: 'MANIFEST_EMPTY_DICTS',
  legacyCode: null,
  message: _utils.i18n._('The manifest contains a dictionaries object, but it is empty.'),
  description: _utils.i18n._('A dictionaries object was defined in the manifest, but it was empty.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_EMPTY_DICTS = MANIFEST_EMPTY_DICTS;
const MANIFEST_DICT_MISSING_ID = {
  code: 'MANIFEST_DICT_MISSING_ID',
  legacyCode: null,
  message: _utils.i18n._('The manifest contains a dictionary but no id property.'),
  description: _utils.i18n._('A dictionary was found in the manifest, but there was no id set.'),
  file: _const.MANIFEST_JSON
}; // https://github.com/mozilla/addons-linter/issues/1650
// Potentially temporary

exports.MANIFEST_DICT_MISSING_ID = MANIFEST_DICT_MISSING_ID;
const MANIFEST_INVALID_CONTENT = {
  code: 'MANIFEST_INVALID_CONTENT',
  message: _utils.i18n._('Forbidden content found in add-on.'),
  description: _utils.i18n._('This add-on contains forbidden content.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_INVALID_CONTENT = MANIFEST_INVALID_CONTENT;
const ICON_NOT_SQUARE = 'ICON_NOT_SQUARE';
exports.ICON_NOT_SQUARE = ICON_NOT_SQUARE;

function iconIsNotSquare(path) {
  return {
    code: ICON_NOT_SQUARE,
    message: _utils.i18n._('Icons must be square.'),
    description: _utils.i18n.sprintf(_utils.i18n._('Icon at "%(path)s" must be square.'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}

const ICON_SIZE_INVALID = 'ICON_SIZE_INVALID';
exports.ICON_SIZE_INVALID = ICON_SIZE_INVALID;

function iconSizeInvalid({
  path,
  expected,
  actual
}) {
  return {
    code: ICON_SIZE_INVALID,
    message: _utils.i18n._('The size of the icon does not match the manifest.'),
    description: _utils.i18n.sprintf(_utils.i18n._((0, _commonTags.oneLine)`
      Expected icon at "%(path)s" to be %(expected)d pixels wide but was %(actual)d.
    `), {
      path,
      expected,
      actual
    }),
    file: _const.MANIFEST_JSON
  };
}

const CORRUPT_ICON_FILE = 'CORRUPT_ICON_FILE';
exports.CORRUPT_ICON_FILE = CORRUPT_ICON_FILE;

function corruptIconFile({
  path
}) {
  return {
    code: CORRUPT_ICON_FILE,
    message: _utils.i18n._('Corrupt image file'),
    description: _utils.i18n.sprintf(_utils.i18n._('Expected icon file at "%(path)s" is corrupted'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_FIELD_DEPRECATED = {
  code: 'MANIFEST_FIELD_DEPRECATED',
  message: _utils.i18n._('This property has been deprecated.'),
  description: null,
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_FIELD_DEPRECATED = MANIFEST_FIELD_DEPRECATED;
const MANIFEST_THEME_LWT_ALIAS = {
  code: 'MANIFEST_THEME_LWT_ALIAS',
  message: _utils.i18n._('This theme LWT alias has been removed in Firefox 70.'),
  description: _utils.i18n._('See https://mzl.la/2T11Lkc (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
exports.MANIFEST_THEME_LWT_ALIAS = MANIFEST_THEME_LWT_ALIAS;
const MANIFEST_THEME_IMAGE_NOT_FOUND = 'MANIFEST_THEME_IMAGE_NOT_FOUND';
exports.MANIFEST_THEME_IMAGE_NOT_FOUND = MANIFEST_THEME_IMAGE_NOT_FOUND;

function manifestThemeImageMissing(path, type) {
  return {
    code: MANIFEST_THEME_IMAGE_NOT_FOUND,
    message: _utils.i18n.sprintf('Theme image for "%(type)s" could not be found in the package', {
      type
    }),
    description: _utils.i18n.sprintf(_utils.i18n._('Theme image for "%(type)s" could not be found at "%(path)s"'), {
      path,
      type
    }),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_THEME_IMAGE_CORRUPTED = 'MANIFEST_THEME_IMAGE_CORRUPTED';
exports.MANIFEST_THEME_IMAGE_CORRUPTED = MANIFEST_THEME_IMAGE_CORRUPTED;

function manifestThemeImageCorrupted({
  path
}) {
  return {
    code: MANIFEST_THEME_IMAGE_CORRUPTED,
    message: _utils.i18n._('Corrupted theme image file'),
    description: _utils.i18n.sprintf(_utils.i18n._('Theme image file at "%(path)s" is corrupted'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_THEME_IMAGE_WRONG_EXT = 'MANIFEST_THEME_IMAGE_WRONG_EXT';
exports.MANIFEST_THEME_IMAGE_WRONG_EXT = MANIFEST_THEME_IMAGE_WRONG_EXT;

function manifestThemeImageWrongExtension({
  path
}) {
  return {
    code: MANIFEST_THEME_IMAGE_WRONG_EXT,
    message: _utils.i18n._('Theme image file has an unsupported file extension'),
    description: _utils.i18n.sprintf(_utils.i18n._('Theme image file at "%(path)s" has an unsupported file extension'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_THEME_IMAGE_WRONG_MIME = 'MANIFEST_THEME_IMAGE_WRONG_MIME';
exports.MANIFEST_THEME_IMAGE_WRONG_MIME = MANIFEST_THEME_IMAGE_WRONG_MIME;

function manifestThemeImageWrongMime({
  path,
  mime
}) {
  return {
    code: MANIFEST_THEME_IMAGE_WRONG_MIME,
    message: _utils.i18n._('Theme image file has an unsupported mime type'),
    description: _utils.i18n.sprintf(_utils.i18n._('Theme image file at "%(path)s" has the unsupported mime type "%(mime)s"'), {
      path,
      mime
    }),
    file: _const.MANIFEST_JSON
  };
}

const MANIFEST_THEME_IMAGE_MIME_MISMATCH = 'MANIFEST_THEME_IMAGE_MIME_MISMATCH';
exports.MANIFEST_THEME_IMAGE_MIME_MISMATCH = MANIFEST_THEME_IMAGE_MIME_MISMATCH;

function manifestThemeImageMimeMismatch({
  path,
  mime
}) {
  return {
    code: MANIFEST_THEME_IMAGE_MIME_MISMATCH,
    message: _utils.i18n._('Theme image file mime type does not match its file extension'),
    description: _utils.i18n.sprintf(_utils.i18n._('Theme image file extension at "%(path)s" does not match its actual mime type "%(mime)s"'), {
      path,
      mime
    }),
    file: _const.MANIFEST_JSON
  };
}

const PROP_NAME_MISSING = manifestPropMissing('name');
exports.PROP_NAME_MISSING = PROP_NAME_MISSING;
const PROP_VERSION_MISSING = manifestPropMissing('version');
exports.PROP_VERSION_MISSING = PROP_VERSION_MISSING;
const NO_MESSAGES_FILE = {
  code: 'NO_MESSAGES_FILE',
  message: _utils.i18n._('The "default_locale" is missing localizations.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`The "default_locale" value is specified in
    the manifest, but no matching "messages.json" in the "_locales" directory
    exists. See: https://mzl.la/2hjcaEE`),
  file: _const.MANIFEST_JSON
};
exports.NO_MESSAGES_FILE = NO_MESSAGES_FILE;
const NO_DEFAULT_LOCALE = {
  code: 'NO_DEFAULT_LOCALE',
  message: _utils.i18n._('The "default_locale" is missing but "_locales" exist.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`The "default_locale" value is not specifed in
    the manifest, but a "_locales" directory exists.
    See: https://mzl.la/2hjcaEE`),
  file: _const.MANIFEST_JSON
};
exports.NO_DEFAULT_LOCALE = NO_DEFAULT_LOCALE;
const WRONG_ICON_EXTENSION = {
  code: 'WRONG_ICON_EXTENSION',
  message: _utils.i18n._('Unsupported image extension'),
  description: _utils.i18n._('Icons should be one of JPG/JPEG, WebP, GIF, PNG or SVG.'),
  file: _const.MANIFEST_JSON
};
exports.WRONG_ICON_EXTENSION = WRONG_ICON_EXTENSION;
const IGNORED_APPLICATIONS_PROPERTY = {
  code: 'IGNORED_APPLICATIONS_PROPERTY',
  message: _utils.i18n._('"applications" property overridden by "browser_specific_settings" property'),
  description: _utils.i18n._((0, _commonTags.oneLine)`The "applications" property is being ignored because it is superseded by the "browser_specific_settings" property which is also defined in your manifest. Consider removing applications.`),
  file: _const.MANIFEST_JSON
};
exports.IGNORED_APPLICATIONS_PROPERTY = IGNORED_APPLICATIONS_PROPERTY;
const NO_MESSAGES_FILE_IN_LOCALES = 'NO_MESSAGES_FILE_IN_LOCALES';
exports.NO_MESSAGES_FILE_IN_LOCALES = NO_MESSAGES_FILE_IN_LOCALES;

function noMessagesFileInLocales(path) {
  return {
    code: NO_MESSAGES_FILE_IN_LOCALES,
    message: _utils.i18n._('Empty language directory'),
    description: _utils.i18n.sprintf(_utils.i18n._('messages.json file missing in "%(path)s"'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}

const KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = 'KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION';
exports.KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION;

function keyFirefoxUnsupportedByMinVersion(key, minVersion, versionAdded) {
  return {
    code: KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION,
    message: _utils.i18n._('Manifest key not supported by the specified minimum Firefox version'),
    description: _utils.i18n.sprintf(_utils.i18n._((0, _commonTags.oneLine)`"strict_min_version" requires Firefox %(minVersion)s, which
        was released before version %(versionAdded)s introduced support for
        "%(key)s".`), {
      key,
      minVersion,
      versionAdded
    }),
    file: _const.MANIFEST_JSON
  };
}

const PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = 'PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION';
exports.PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION;

function permissionFirefoxUnsupportedByMinVersion(key, minVersion, versionAdded) {
  return {
    code: PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION,
    message: _utils.i18n._('Permission not supported by the specified minimum Firefox version'),
    description: _utils.i18n.sprintf(_utils.i18n._((0, _commonTags.oneLine)`"strict_min_version" requires Firefox %(minVersion)s, which
        was released before version %(versionAdded)s introduced support for
        "%(key)s".`), {
      key,
      minVersion,
      versionAdded
    }),
    file: _const.MANIFEST_JSON
  };
}

const KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = 'KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION';
exports.KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION;

function keyFirefoxAndroidUnsupportedByMinVersion(key, minVersion, versionAdded) {
  return {
    code: KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION,
    message: _utils.i18n._('Manifest key not supported by the specified minimum Firefox for Android version'),
    description: _utils.i18n.sprintf(_utils.i18n._((0, _commonTags.oneLine)`"strict_min_version" requires Firefox for Android
        %(minVersion)s, which was released before version %(versionAdded)s
        introduced support for "%(key)s".`), {
      key,
      minVersion,
      versionAdded
    }),
    file: _const.MANIFEST_JSON
  };
}

const PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = 'PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION';
exports.PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION;

function permissionFirefoxAndroidUnsupportedByMinVersion(key, minVersion, versionAdded) {
  return {
    code: PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION,
    message: _utils.i18n._('Permission not supported by the specified minimum Firefox for Android version'),
    description: _utils.i18n.sprintf(_utils.i18n._((0, _commonTags.oneLine)`"strict_min_version" requires Firefox for Android
        %(minVersion)s, which was released before version %(versionAdded)s
        introduced support for "%(key)s".`), {
      key,
      minVersion,
      versionAdded
    }),
    file: _const.MANIFEST_JSON
  };
}

const RESTRICTED_HOMEPAGE_URL = {
  code: 'RESTRICTED_HOMEPAGE_URL',
  message: _utils.i18n._('Linking to "addons.mozilla.org" is not allowed'),
  description: _utils.i18n._('Links directing to "addons.mozilla.org" are not allowed to be used for homepage'),
  file: _const.MANIFEST_JSON
};
exports.RESTRICTED_HOMEPAGE_URL = RESTRICTED_HOMEPAGE_URL;
const RESTRICTED_PERMISSION = 'RESTRICTED_PERMISSION';
exports.RESTRICTED_PERMISSION = RESTRICTED_PERMISSION;

const makeRestrictedPermission = (permission, minFirefoxVersion) => {
  return {
    code: RESTRICTED_PERMISSION,
    message: _utils.i18n.sprintf(_utils.i18n._((0, _commonTags.oneLine)`The "%(permission)s" permission requires
        "strict_min_version" to be set to "%(minFirefoxVersion)s" or above`), {
      permission,
      minFirefoxVersion
    }),
    description: _utils.i18n.sprintf(_utils.i18n._((0, _commonTags.oneLine)`The "%(permission)s" permission requires
        "strict_min_version" to be set to "%(minFirefoxVersion)s" or above.
        Please update your manifest.json version to specify a minimum Firefox
        version.`), {
      permission,
      minFirefoxVersion
    }),
    file: _const.MANIFEST_JSON
  };
};

exports.makeRestrictedPermission = makeRestrictedPermission;

/***/ }),
/* 20 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FLUENT_INVALID = void 0;

var _utils = __webpack_require__(2);

const FLUENT_INVALID = {
  code: 'FLUENT_INVALID',
  message: _utils.i18n._('Your FTL is not valid.'),
  description: _utils.i18n._('Your FTL file could not be parsed.')
};
exports.FLUENT_INVALID = FLUENT_INVALID;

/***/ }),
/* 21 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PREDEFINED_MESSAGE_NAME = exports.NO_PLACEHOLDER_CONTENT = exports.NO_MESSAGE = exports.MISSING_PLACEHOLDER = exports.INVALID_PLACEHOLDER_NAME = exports.INVALID_MESSAGE_NAME = void 0;

var _commonTags = __webpack_require__(7);

var _utils = __webpack_require__(2);

const NO_MESSAGE = {
  code: 'NO_MESSAGE',
  message: _utils.i18n._('Translation string is missing the message property'),
  description: _utils.i18n._('No "message" message property is set for a string (https://mzl.la/2DSBTjA).')
};
exports.NO_MESSAGE = NO_MESSAGE;
const PREDEFINED_MESSAGE_NAME = {
  code: 'PREDEFINED_MESSAGE_NAME',
  message: _utils.i18n._('String name is reserved for a predefined message'),
  description: _utils.i18n._((0, _commonTags.oneLine)`String names starting with @@ get translated to built-in
    constants (https://mzl.la/2BL9ZjE).`)
};
exports.PREDEFINED_MESSAGE_NAME = PREDEFINED_MESSAGE_NAME;
const INVALID_MESSAGE_NAME = {
  code: 'INVALID_MESSAGE_NAME',
  message: 'String name contains invalid characters',
  description: _utils.i18n._((0, _commonTags.oneLine)`String name should only contain alpha-numeric
    characters, _ and @ (https://mzl.la/2Eztyi5).`)
};
exports.INVALID_MESSAGE_NAME = INVALID_MESSAGE_NAME;
const MISSING_PLACEHOLDER = {
  code: 'MISSING_PLACEHOLDER',
  message: _utils.i18n._('Placeholder for message is missing'),
  description: _utils.i18n._('A placeholder used in the message is not defined.')
};
exports.MISSING_PLACEHOLDER = MISSING_PLACEHOLDER;
const INVALID_PLACEHOLDER_NAME = {
  code: 'INVALID_PLACEHOLDER_NAME',
  message: _utils.i18n._('Placeholder name contains invalid characters'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Placeholder name should only contain alpha-numeric
    characters, _ and @ (https://mzl.la/2ExbYez).`)
};
exports.INVALID_PLACEHOLDER_NAME = INVALID_PLACEHOLDER_NAME;
const NO_PLACEHOLDER_CONTENT = {
  code: 'NO_PLACEHOLDER_CONTENT',
  message: _utils.i18n._('Placeholder is missing the content property'),
  description: _utils.i18n._((0, _commonTags.oneLine)`A placeholder needs a content property defining the
    replacement of it (https://mzl.la/2DT1MQd)`)
};
exports.NO_PLACEHOLDER_CONTENT = NO_PLACEHOLDER_CONTENT;

/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
var exports = __webpack_exports__;


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;

var _messages = __webpack_require__(14);

var _utils = __webpack_require__(2);

/*
 * This rule will detect a global passed to `require()` as the first argument.
 */
const rule = {
  create(context) {
    return {
      // eslint-disable-next-line consistent-return
      CallExpression(node) {
        if (node.callee.name === 'require' && node.arguments && node.arguments.length) {
          const firstArg = node.arguments[0];

          if (firstArg.type === 'Identifier') {
            const pathVar = (0, _utils.getVariable)(context, firstArg.name);

            if (typeof pathVar === 'undefined') {
              // We infer this is probably a global.
              return context.report(node, _messages.UNEXPECTED_GLOGAL_ARG.code);
            }
          }
        }
      }

    };
  }

};
var _default = rule;
exports["default"] = _default;
const {
  create
} = rule;
exports.create = create;
})();

module.exports = __webpack_exports__["default"];
/******/ })()
;
//# sourceMappingURL=global-require-arg.js.map