/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;
import net.sourceforge.jnlp.security.dialogresults.SetValueHandler;
import net.sourceforge.jnlp.security.dialogresults.YesNo;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.security.dialogs.remember.RememberPanel;
import net.sourceforge.jnlp.security.dialogs.remember.RememberPanelResult;
import net.sourceforge.jnlp.security.dialogs.remember.RememberableDialog;
import net.sourceforge.jnlp.util.logging.OutputController;

public class MissingPermissionsAttributePanel
extends SecurityDialogPanel
implements RememberableDialog {
    private RememberPanel rememberPanel;

    public MissingPermissionsAttributePanel(SecurityDialog x, String title, String codebase) {
        super(x);
        try {
            this.addComponents(title, codebase);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (x != null) {
            x.getViwableDialog().setMinimumSize(new Dimension(400, 400));
        }
    }

    protected final void addComponents(String title, String codebase) throws IOException {
        URL imgUrl = this.getClass().getResource("/net/sourceforge/jnlp/resources/warning.png");
        ImageIcon icon = null;
        BufferedImage img = ImageIO.read(imgUrl);
        icon = new ImageIcon(img);
        String topLabelText = Translator.R("MissingPermissionsMainTitle", title, codebase);
        String bottomLabelText = Translator.R("MissingPermissionsInfo");
        JLabel topLabel = new JLabel(MissingPermissionsAttributePanel.htmlWrap(topLabelText), icon, 0);
        topLabel.setFont(new Font(topLabel.getFont().toString(), 1, 12));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        topPanel.add((Component)topLabel, "Center");
        topPanel.setPreferredSize(new Dimension(400, 80));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JEditorPane bottomLabel = new JEditorPane("text/html", MissingPermissionsAttributePanel.htmlWrap(bottomLabelText));
        bottomLabel.setEditable(false);
        bottomLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                }
                catch (IOException ex) {
                    OutputController.getLogger().log(ex);
                }
                catch (URISyntaxException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
        });
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.add((Component)bottomLabel, "Center");
        infoPanel.setPreferredSize(new Dimension(400, 80));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        bottomLabel.setBackground(infoPanel.getBackground());
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton yes = new JButton(Translator.R("ButYes"));
        JButton no = new JButton(Translator.R("ButNo"));
        this.rememberPanel = new RememberPanel(codebase);
        yes.addActionListener(SetValueHandler.createSetValueListener(this.parent, YesNo.yes()));
        no.addActionListener(SetValueHandler.createSetValueListener(this.parent, YesNo.no()));
        this.initialFocusComponent = no;
        buttonPanel.add(yes);
        buttonPanel.add(no);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.add(topPanel);
        this.add(infoPanel);
        this.add(buttonPanel);
        this.add(this.rememberPanel);
        this.validate();
    }

    public static void main(String[] args) {
        MissingPermissionsAttributePanel w = new MissingPermissionsAttributePanel(null, "HelloWorld", "http://nbblah.url");
        JFrame f = new JFrame();
        f.setSize(400, 400);
        f.add((Component)w, "Center");
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    @Override
    public RememberPanelResult getRemeberAction() {
        return this.rememberPanel.getRememberAction();
    }

    @Override
    public DialogResult getValue() {
        return this.parent.getValue();
    }

    @Override
    public JNLPFile getFile() {
        return this.parent.getFile();
    }

    @Override
    public DialogResult readValue(String s) {
        return YesNo.readValue(s);
    }

    @Override
    public DialogResult getDefaultNegativeAnswer() {
        return YesNo.no();
    }

    @Override
    public DialogResult getDefaultPositiveAnswer() {
        return YesNo.yes();
    }

    @Override
    public DialogResult readFromStdIn(String what) {
        return YesNo.readValue(what);
    }

    @Override
    public String helpToStdIn() {
        return YesNo.no().getAllowedValues().toString();
    }
}

