/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.tomcat.util.modeler.BaseModelMBean;

public class ContainerMBean
extends BaseModelMBean {
    public void addChild(String string, String string2) throws MBeanException {
        Container container = null;
        try {
            LifecycleListener lifecycleListener;
            container = (Container)Class.forName(string).newInstance();
            container.setName(string2);
            if (container instanceof StandardHost) {
                lifecycleListener = new HostConfig();
                container.addLifecycleListener(lifecycleListener);
            } else if (container instanceof StandardContext) {
                lifecycleListener = new ContextConfig();
                container.addLifecycleListener(lifecycleListener);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new MBeanException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MBeanException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MBeanException(classNotFoundException);
        }
        boolean bl = true;
        ContainerBase containerBase = null;
        try {
            containerBase = (ContainerBase)this.getManagedResource();
            bl = containerBase.getStartChildren();
            containerBase.setStartChildren(false);
            containerBase.addChild(container);
            container.init();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new MBeanException(instanceNotFoundException);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new MBeanException(runtimeOperationsException);
        }
        catch (InvalidTargetObjectTypeException invalidTargetObjectTypeException) {
            throw new MBeanException(invalidTargetObjectTypeException);
        }
        catch (LifecycleException lifecycleException) {
            throw new MBeanException(lifecycleException);
        }
        finally {
            if (containerBase != null) {
                containerBase.setStartChildren(bl);
            }
        }
    }

    public void removeChild(String string) throws MBeanException {
        if (string != null) {
            try {
                Container container = (Container)this.getManagedResource();
                Container container2 = container.findChild(string);
                container.removeChild(container2);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new MBeanException(instanceNotFoundException);
            }
            catch (RuntimeOperationsException runtimeOperationsException) {
                throw new MBeanException(runtimeOperationsException);
            }
            catch (InvalidTargetObjectTypeException invalidTargetObjectTypeException) {
                throw new MBeanException(invalidTargetObjectTypeException);
            }
        }
    }

    public String addValve(String string) throws MBeanException {
        Valve valve = null;
        try {
            valve = (Valve)Class.forName(string).newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new MBeanException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MBeanException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MBeanException(classNotFoundException);
        }
        if (valve == null) {
            return null;
        }
        try {
            ContainerBase containerBase = (ContainerBase)this.getManagedResource();
            containerBase.addValve(valve);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new MBeanException(instanceNotFoundException);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new MBeanException(runtimeOperationsException);
        }
        catch (InvalidTargetObjectTypeException invalidTargetObjectTypeException) {
            throw new MBeanException(invalidTargetObjectTypeException);
        }
        return ((LifecycleMBeanBase)((Object)valve)).getObjectName().toString();
    }

    public void removeValve(String string) throws MBeanException {
        ObjectName objectName;
        ContainerBase containerBase = null;
        try {
            containerBase = (ContainerBase)this.getManagedResource();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new MBeanException(instanceNotFoundException);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new MBeanException(runtimeOperationsException);
        }
        catch (InvalidTargetObjectTypeException invalidTargetObjectTypeException) {
            throw new MBeanException(invalidTargetObjectTypeException);
        }
        try {
            objectName = new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new MBeanException(malformedObjectNameException);
        }
        catch (NullPointerException nullPointerException) {
            throw new MBeanException(nullPointerException);
        }
        if (containerBase != null) {
            Valve[] valveArray;
            for (Valve valve : valveArray = containerBase.getPipeline().getValves()) {
                ObjectName objectName2;
                if (!(valve instanceof JmxEnabled) || !(objectName2 = ((JmxEnabled)((Object)valve)).getObjectName()).equals(objectName)) continue;
                containerBase.getPipeline().removeValve(valve);
            }
        }
    }

    public void addLifeCycleListener(String string) throws MBeanException {
        LifecycleListener lifecycleListener = null;
        try {
            lifecycleListener = (LifecycleListener)Class.forName(string).newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new MBeanException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MBeanException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MBeanException(classNotFoundException);
        }
        if (lifecycleListener != null) {
            try {
                ContainerBase containerBase = (ContainerBase)this.getManagedResource();
                containerBase.addLifecycleListener(lifecycleListener);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new MBeanException(instanceNotFoundException);
            }
            catch (RuntimeOperationsException runtimeOperationsException) {
                throw new MBeanException(runtimeOperationsException);
            }
            catch (InvalidTargetObjectTypeException invalidTargetObjectTypeException) {
                throw new MBeanException(invalidTargetObjectTypeException);
            }
        }
    }

    public void removeLifeCycleListeners(String string) throws MBeanException {
        LifecycleListener[] lifecycleListenerArray;
        ContainerBase containerBase = null;
        try {
            containerBase = (ContainerBase)this.getManagedResource();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new MBeanException(instanceNotFoundException);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new MBeanException(runtimeOperationsException);
        }
        catch (InvalidTargetObjectTypeException invalidTargetObjectTypeException) {
            throw new MBeanException(invalidTargetObjectTypeException);
        }
        for (LifecycleListener lifecycleListener : lifecycleListenerArray = containerBase.findLifecycleListeners()) {
            if (!lifecycleListener.getClass().getName().equals(string)) continue;
            containerBase.removeLifecycleListener(lifecycleListener);
        }
    }

    public String[] findLifecycleListenerNames() throws MBeanException {
        LifecycleListener[] lifecycleListenerArray;
        ContainerBase containerBase = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            containerBase = (ContainerBase)this.getManagedResource();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new MBeanException(instanceNotFoundException);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new MBeanException(runtimeOperationsException);
        }
        catch (InvalidTargetObjectTypeException invalidTargetObjectTypeException) {
            throw new MBeanException(invalidTargetObjectTypeException);
        }
        for (LifecycleListener lifecycleListener : lifecycleListenerArray = containerBase.findLifecycleListeners()) {
            arrayList.add(lifecycleListener.getClass().getName());
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] findContainerListenerNames() throws MBeanException {
        ContainerListener[] containerListenerArray;
        ContainerBase containerBase = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            containerBase = (ContainerBase)this.getManagedResource();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new MBeanException(instanceNotFoundException);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new MBeanException(runtimeOperationsException);
        }
        catch (InvalidTargetObjectTypeException invalidTargetObjectTypeException) {
            throw new MBeanException(invalidTargetObjectTypeException);
        }
        for (ContainerListener containerListener : containerListenerArray = containerBase.findContainerListeners()) {
            arrayList.add(containerListener.getClass().getName());
        }
        return arrayList.toArray(new String[0]);
    }
}

