/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring.namespace;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.spring.BeanCreator;
import org.directwebremoting.spring.CreatorConfig;
import org.directwebremoting.spring.namespace.CreatorParserHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ProxyParser
extends CreatorParserHelper
implements BeanDefinitionParser {
    private static final Log log = LogFactory.getLog(ProxyParser.class);

    public BeanDefinition parse(Element proxyElement, ParserContext parserContext) {
        String beanRef = proxyElement.getAttribute("bean");
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        BeanDefinition beanRefDefinition = this.findParentDefinition(beanRef, registry);
        String javascript = proxyElement.getAttribute("javascript");
        if (!StringUtils.hasText((String)javascript)) {
            javascript = StringUtils.capitalize((String)beanRef);
            if (log.isDebugEnabled()) {
                log.debug((Object)("No javascript name provided. Remoting using bean id [" + javascript + "]"));
            }
            javascript = StringUtils.capitalize((String)beanRef);
        }
        BeanDefinitionBuilder beanCreator = BeanDefinitionBuilder.rootBeanDefinition(BeanCreator.class);
        beanCreator.addPropertyValue("beanClass", (Object)this.resolveBeanClassname(beanRefDefinition, registry));
        beanCreator.addPropertyValue("beanId", (Object)beanRef);
        beanCreator.addDependsOn(beanRef);
        beanCreator.addPropertyValue("javascript", (Object)javascript);
        BeanDefinitionBuilder creatorConfig = BeanDefinitionBuilder.rootBeanDefinition(CreatorConfig.class);
        creatorConfig.addPropertyValue("creator", (Object)beanCreator.getBeanDefinition());
        this.configureCreator(registry, javascript, creatorConfig, proxyElement.getChildNodes());
        this.registerCreator(registry, creatorConfig, javascript);
        return creatorConfig.getBeanDefinition();
    }
}

