/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectsProvider;
import org.graalvm.visualvm.heapviewer.truffle.ui.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.ui.FilterUtils;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.PluggableTreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.ActionPopupButton;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;

public class TruffleObjectsView
extends HeapViewerFeature {
    private static final String FEATURE_ID = "objects";
    private final TruffleLanguage language;
    private final HeapContext context;
    private ProfilerToolbar toolbar;
    private final PluggableTreeTableView objectsView;
    private JComponent component;
    private Preset preset = Preset.ALL_OBJECTS;
    private Aggregation aggregation = Aggregation.TYPES;
    private ActionPopupButton apbPreset;
    private JToggleButton tbType;
    private JToggleButton tbObject;
    private volatile boolean skipReload = false;
    private Runnable dominatorsRefresher;
    private volatile boolean countVisible1 = true;
    private volatile boolean countVisible2 = false;

    public TruffleObjectsView(TruffleLanguage language, final HeapContext context, HeapViewerActions actions) {
        super(TruffleObjectsView.idFromLanguage(language), Bundle.TruffleObjectsView_Name(), Bundle.TruffleObjectsView_Description(), TruffleObjectsView.iconFromLanguage(language), 200);
        this.language = language;
        this.context = context;
        Heap heap = context.getFragment().getHeap();
        final TruffleObjectsProvider objectsProvider = new TruffleObjectsProvider(language);
        this.objectsView = new PluggableTreeTableView(this.getID(), context, actions, TreeTableViewColumn.classes((Heap)heap, (boolean)true)){

            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                switch (TruffleObjectsView.this.getPreset()) {
                    case ALL_OBJECTS: {
                        switch (TruffleObjectsView.this.getAggregation()) {
                            case TYPES: {
                                return objectsProvider.getAllObjects((HeapViewerNode)root, context, viewID, viewFilter, dataTypes, sortOrders, progress, 1);
                            }
                        }
                        return objectsProvider.getAllObjects((HeapViewerNode)root, context, viewID, viewFilter, dataTypes, sortOrders, progress, 0);
                    }
                    case DOMINATORS: {
                        switch (TruffleObjectsView.this.getAggregation()) {
                            case TYPES: {
                                return objectsProvider.getDominators((HeapViewerNode)root, context, viewID, viewFilter, dataTypes, sortOrders, progress, 1);
                            }
                        }
                        return objectsProvider.getDominators((HeapViewerNode)root, context, viewID, viewFilter, dataTypes, sortOrders, progress, 0);
                    }
                    case GC_ROOTS: {
                        switch (TruffleObjectsView.this.getAggregation()) {
                            case TYPES: {
                                return objectsProvider.getGCRoots((HeapViewerNode)root, context, viewID, viewFilter, dataTypes, sortOrders, progress, 1);
                            }
                        }
                        return objectsProvider.getGCRoots((HeapViewerNode)root, context, viewID, viewFilter, dataTypes, sortOrders, progress, 0);
                    }
                }
                return HeapViewerNode.NO_NODES;
            }

            protected JComponent createComponent() {
                if (TruffleObjectsView.this.component == null) {
                    TruffleObjectsView.this.component = super.createComponent();
                    this.setFilterComponent(FilterUtils.createFilterPanel((TreeTableView)this));
                }
                return TruffleObjectsView.this.component;
            }
        };
    }

    static String idFromLanguage(TruffleLanguage language) {
        return language.getID() + "_" + FEATURE_ID;
    }

    static Icon iconFromLanguage(TruffleLanguage language) {
        return language.createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Class"));
    }

    public JComponent getComponent() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.objectsView.getComponent();
    }

    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    public void configureTypesByObjectsCount() {
        try {
            this.objectsView.setSortColumn(DataType.COUNT, SortOrder.DESCENDING);
            if (this.apbPreset == null) {
                this.preset = Preset.ALL_OBJECTS;
            } else if (this.preset != Preset.ALL_OBJECTS) {
                this.skipReload = true;
                this.setPreset(Preset.ALL_OBJECTS);
                this.apbPreset.selectAction(this.preset.ordinal());
            }
            if (this.tbType == null) {
                this.skipReload = true;
                this.setAggregation(Aggregation.TYPES);
            } else if (!this.tbType.isSelected()) {
                this.skipReload = true;
                this.tbType.setSelected(true);
            }
            if (this.skipReload) {
                this.objectsView.reloadView();
            }
        }
        finally {
            this.skipReload = false;
        }
    }

    public void configureTypesByObjectsSize() {
        try {
            this.objectsView.setSortColumn(DataType.OWN_SIZE, SortOrder.DESCENDING);
            if (this.apbPreset == null) {
                this.preset = Preset.ALL_OBJECTS;
            } else if (this.preset != Preset.ALL_OBJECTS) {
                this.skipReload = true;
                this.setPreset(Preset.ALL_OBJECTS);
                this.apbPreset.selectAction(this.preset.ordinal());
            }
            if (this.tbType == null) {
                this.skipReload = true;
                this.setAggregation(Aggregation.TYPES);
            } else if (!this.tbType.isSelected()) {
                this.skipReload = true;
                this.tbType.setSelected(true);
            }
            if (this.skipReload) {
                this.objectsView.reloadView();
            }
        }
        finally {
            this.skipReload = false;
        }
    }

    public void configureObjectsBySize() {
        try {
            this.objectsView.setSortColumn(DataType.OWN_SIZE, SortOrder.DESCENDING);
            if (this.apbPreset == null) {
                this.preset = Preset.ALL_OBJECTS;
            } else if (this.preset != Preset.ALL_OBJECTS) {
                this.skipReload = true;
                this.setPreset(Preset.ALL_OBJECTS);
                this.apbPreset.selectAction(this.preset.ordinal());
            }
            if (this.tbObject == null) {
                this.skipReload = true;
                this.setAggregation(Aggregation.OBJECTS);
            } else if (!this.tbObject.isSelected()) {
                this.skipReload = true;
                this.tbObject.setSelected(true);
            }
            if (this.skipReload) {
                this.objectsView.reloadView();
            }
        }
        finally {
            this.skipReload = false;
        }
    }

    public void configureDominatorsByRetainedSize() {
        try {
            this.objectsView.setSortColumn(DataType.RETAINED_SIZE, SortOrder.DESCENDING);
            if (this.apbPreset == null) {
                this.preset = Preset.DOMINATORS;
            } else if (this.preset != Preset.DOMINATORS) {
                this.skipReload = true;
                this.setPreset(Preset.DOMINATORS);
                this.apbPreset.selectAction(this.preset.ordinal());
            }
            if (this.tbObject == null) {
                this.skipReload = true;
                this.setAggregation(Aggregation.OBJECTS);
            } else if (!this.tbObject.isSelected()) {
                this.skipReload = true;
                this.tbObject.setSelected(true);
            }
            if (this.skipReload) {
                this.objectsView.reloadView();
            }
        }
        finally {
            this.skipReload = false;
        }
    }

    synchronized void setPreset(Preset preset) {
        Heap heap;
        if (preset == Preset.DOMINATORS && !DataType.RETAINED_SIZE.valuesAvailable(heap = this.context.getFragment().getHeap())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TruffleObjectsView.this.dominatorsRefresher = new Runnable(){

                        @Override
                        public void run() {
                            if (TruffleObjectsView.this.getPreset() == Preset.DOMINATORS) {
                                TruffleObjectsView.this.objectsView.reloadView();
                            }
                            TruffleObjectsView.this.dominatorsRefresher = null;
                        }
                    };
                    DataType.RETAINED_SIZE.notifyWhenAvailable(heap, TruffleObjectsView.this.dominatorsRefresher);
                    DataType.RETAINED_SIZE.computeValues(heap, null);
                }
            });
        }
        this.preset = preset;
        this.objectsView.setViewName(preset.toString());
        if (!this.skipReload) {
            this.objectsView.reloadView();
        }
    }

    private synchronized Preset getPreset() {
        return this.preset;
    }

    synchronized void setAggregation(Aggregation aggregation) {
        boolean objectsInvolved = Aggregation.OBJECTS.equals((Object)aggregation) || Aggregation.OBJECTS.equals((Object)this.aggregation);
        this.aggregation = aggregation;
        if (objectsInvolved) {
            this.objectsView.getComponent();
            boolean countVisible = this.objectsView.isColumnVisible(DataType.COUNT);
            if (Aggregation.OBJECTS.equals((Object)aggregation)) {
                this.countVisible1 = countVisible;
                this.objectsView.setColumnVisible(DataType.COUNT, this.countVisible2);
            } else {
                this.countVisible2 = countVisible;
                this.objectsView.setColumnVisible(DataType.COUNT, this.countVisible1);
            }
        }
        if (!this.skipReload) {
            this.objectsView.reloadView();
        }
    }

    private synchronized Aggregation getAggregation() {
        return this.aggregation;
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.TruffleObjectsView_Preset()));
        this.toolbar.addSpace(2);
        Preset[] presetItems = Preset.values();
        class PresetAction
        extends AbstractAction {
            final Preset preset;

            PresetAction(Preset preset) {
                this.preset = preset;
                this.putValue("Name", preset.toString());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TruffleObjectsView.this.setPreset(this.preset);
            }
        }
        Action[] presetActions = new PresetAction[presetItems.length];
        for (int i = 0; i < presetItems.length; ++i) {
            presetActions[i] = new PresetAction(presetItems[i]);
        }
        this.apbPreset = new ActionPopupButton(0, presetActions);
        this.apbPreset.selectAction(this.preset.ordinal());
        this.toolbar.add((Component)this.apbPreset);
        this.toolbar.addSpace(8);
        this.toolbar.add((Component)new GrayLabel(Bundle.TruffleObjectsView_Aggregation()));
        this.toolbar.addSpace(2);
        final ButtonGroup aggregationBG = new ButtonGroup();
        class AggregationButton
        extends JToggleButton {
            private final Aggregation aggregation;

            AggregationButton(Aggregation aggregation, boolean selected) {
                super(TruffleObjectsView.this.language.createLanguageIcon(aggregation.getIcon()), selected);
                this.aggregation = aggregation;
                this.setToolTipText(aggregation.toString());
                aggregationBG.add(this);
            }

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && this.aggregation != null) {
                    TruffleObjectsView.this.setAggregation(this.aggregation);
                }
            }
        }
        this.tbType = new AggregationButton(Aggregation.TYPES, Aggregation.TYPES.equals((Object)this.aggregation));
        this.tbType.putClientProperty("JButton.buttonType", "segmented");
        this.tbType.putClientProperty("JButton.segmentPosition", "first");
        this.toolbar.add((Component)this.tbType);
        this.tbObject = new AggregationButton(Aggregation.OBJECTS, Aggregation.OBJECTS.equals((Object)this.aggregation));
        this.tbObject.putClientProperty("JButton.buttonType", "segmented");
        this.tbObject.putClientProperty("JButton.segmentPosition", "last");
        this.toolbar.add((Component)this.tbObject);
        this.setPreset(this.preset);
        if (this.objectsView.hasPlugins()) {
            this.toolbar.addSpace(8);
            this.toolbar.add((Component)new GrayLabel(Bundle.TruffleObjectsView_Details()));
            this.toolbar.addSpace(2);
            this.toolbar.add(this.objectsView.getToolbar());
        }
    }

    protected static enum Aggregation {
        TYPES(Bundle.TruffleObjectsView_Types(), Icons.getIcon((String)"LanguageIcons.Package")),
        OBJECTS(Bundle.TruffleObjectsView_Objects(), Icons.getIcon((String)"LanguageIcons.Instance"));

        private final String aggregationName;
        private final Icon aggregationIcon;

        private Aggregation(String aggregationName, Icon aggregationIcon) {
            this.aggregationName = aggregationName;
            this.aggregationIcon = aggregationIcon;
        }

        public String toString() {
            return this.aggregationName;
        }

        public Icon getIcon() {
            return this.aggregationIcon;
        }
    }

    protected static enum Preset {
        ALL_OBJECTS(Bundle.TruffleObjectsView_AllObjects()),
        DOMINATORS(Bundle.TruffleObjectsView_Dominators()),
        GC_ROOTS(Bundle.TruffleObjectsView_GcRoots());

        private final String presetName;

        private Preset(String presetName) {
            this.presetName = presetName;
        }

        public String toString() {
            return this.presetName;
        }
    }
}

