/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.console.r;

import java.awt.AWTException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.RenderingHints;
import java.util.Objects;
import javax.swing.JPanel;
import org.graalvm.visualvm.lib.ui.UIUtils;

class RPlotPanel
extends JPanel {
    private Image offscreenImage;
    private Boolean renderingQuality;

    RPlotPanel() {
        this.setOpaque(true);
        this.setBackground(UIUtils.getProfilerResultsBackground());
    }

    final void setRenderingQuality(Boolean renderingQuality) {
        boolean change = !Objects.equals(this.renderingQuality, renderingQuality);
        this.renderingQuality = renderingQuality;
        if (change) {
            this.repaint();
        }
    }

    final Boolean getRenderingQuality() {
        return this.renderingQuality;
    }

    Image createPlotImage() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (w <= 0 || h <= 0) {
            this.offscreenImage = null;
        } else {
            try {
                this.offscreenImage = this.createVolatileImage(this.getWidth(), this.getHeight(), new ImageCapabilities(true));
            }
            catch (AWTException e1) {
                try {
                    this.offscreenImage = this.createVolatileImage(this.getWidth(), this.getHeight(), new ImageCapabilities(false));
                }
                catch (AWTException e2) {
                    this.offscreenImage = this.createImage(this.getWidth(), this.getHeight());
                }
            }
        }
        return this.offscreenImage;
    }

    @Override
    public void paint(Graphics g) {
        Image img;
        super.paint(g);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.renderingQuality != null && g instanceof Graphics2D) {
            Object interpolation = this.renderingQuality != false ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
        }
        if ((img = this.offscreenImage) != null && w > 0 && h > 0) {
            g.drawImage(img, 0, 0, w, h, null);
        }
    }
}

