/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.jruby.CompatVersion;
import org.jruby.anno.AnnotationHelper;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.util.CodegenUtils;

@SupportedAnnotationTypes(value={"org.jruby.anno.JRubyMethod"})
public class AnnotationBinder
extends AbstractProcessor {
    public static final String POPULATOR_SUFFIX = "$POPULATOR";
    public static final String SRC_GEN_DIR = "target/generated-sources/org/jruby/gen/";
    private final List<CharSequence> classNames = new ArrayList<CharSequence>();
    private PrintStream out;
    private Types types;
    private static final boolean DEBUG = false;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.types = processingEnv.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        for (TypeElement element : ElementFilter.typesIn(roundEnvironment.getRootElements())) {
            this.processType(element);
        }
        try {
            FileWriter fw = new FileWriter("target/generated-sources/annotated_classes.txt");
            for (CharSequence name2 : this.classNames) {
                fw.write(name2.toString());
                fw.write(10);
            }
            fw.close();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public void processType(TypeElement cd) {
        for (TypeElement innerType : ElementFilter.typesIn(cd.getEnclosedElements())) {
            this.processType(innerType);
        }
        try {
            String qualifiedName = cd.getQualifiedName().toString().replace('.', '$');
            if (!qualifiedName.contains("org$jruby")) {
                return;
            }
            ByteArrayOutputStream bytes2 = new ByteArrayOutputStream(1024);
            this.out = new PrintStream(bytes2);
            this.out.println("/* THIS FILE IS GENERATED. DO NOT EDIT */");
            this.out.println("package org.jruby.gen;");
            this.out.println("");
            this.out.println("import org.jruby.Ruby;");
            this.out.println("import org.jruby.RubyModule;");
            this.out.println("import org.jruby.RubyClass;");
            this.out.println("import org.jruby.anno.TypePopulator;");
            this.out.println("import org.jruby.internal.runtime.methods.JavaMethod;");
            this.out.println("import org.jruby.internal.runtime.methods.DynamicMethod;");
            this.out.println("import org.jruby.runtime.Arity;");
            this.out.println("import org.jruby.runtime.Visibility;");
            this.out.println("import org.jruby.runtime.MethodIndex;");
            this.out.println("import java.util.Arrays;");
            this.out.println("import java.util.List;");
            this.out.println("import jakarta.annotation.Generated;");
            this.out.println("");
            this.out.println("@Generated(\"org.jruby.anno.AnnotationBinder\")");
            this.out.println("@SuppressWarnings(\"deprecation\")");
            this.out.println("public class " + qualifiedName + POPULATOR_SUFFIX + " extends TypePopulator {");
            this.out.println("    public void populate(RubyModule cls, Class clazz) {");
            boolean hasAnno = false;
            boolean hasMeta = false;
            boolean hasModule = false;
            for (ExecutableElement method2 : ElementFilter.methodsIn(cd.getEnclosedElements())) {
                JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
                if (anno == null) continue;
                hasAnno = true;
                hasMeta |= anno.meta();
                hasModule |= anno.module();
            }
            if (!hasAnno) {
                return;
            }
            this.out.println("        JavaMethod javaMethod;");
            this.out.println("        DynamicMethod moduleMethod, aliasedMethod;");
            if (hasMeta || hasModule) {
                this.out.println("        RubyClass singletonClass = cls.getSingletonClass();");
            }
            this.out.println("        Ruby runtime = cls.getRuntime();");
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<Set<FrameField>, List<String>> readGroups = new HashMap<Set<FrameField>, List<String>>();
            HashMap<Set<FrameField>, List<String>> writeGroups = new HashMap<Set<FrameField>, List<String>>();
            int methodCount = 0;
            for (ExecutableElement method3 : ElementFilter.methodsIn(cd.getEnclosedElements())) {
                JRubyMethod anno = method3.getAnnotation(JRubyMethod.class);
                if (anno == null || anno.compat() == CompatVersion.RUBY1_8) continue;
                ++methodCount;
                AnnotationBinder.checkForThrows(cd, method3);
                Name name2 = anno.name().length == 0 ? method3.getSimpleName() : anno.name()[0];
                HashMap<CharSequence, List<ExecutableElement>> methodsHash = method3.getModifiers().contains((Object)Modifier.STATIC) ? staticAnnotatedMethods : annotatedMethods;
                ArrayList<ExecutableElement> methodDescs = (ArrayList<ExecutableElement>)methodsHash.get(name2);
                if (methodDescs == null) {
                    methodDescs = new ArrayList<ExecutableElement>(4);
                    methodsHash.put(name2, methodDescs);
                }
                methodDescs.add(method3);
                AnnotationHelper.groupFrameFields(readGroups, writeGroups, anno, method3.getSimpleName().toString());
            }
            if (methodCount == 0) {
                return;
            }
            CharSequence primaryName = AnnotationBinder.getActualQualifiedName(cd);
            this.classNames.add(primaryName);
            ArrayList<String> classAndSubs = new ArrayList<String>();
            classAndSubs.add(cd.getQualifiedName().toString());
            JRubyClass classAnno = cd.getAnnotation(JRubyClass.class);
            if (classAnno != null) {
                this.addSubclassNames(classAndSubs, classAnno);
            }
            HashMap<CharSequence, CharSequence> mappings = new HashMap<CharSequence, CharSequence>();
            this.processMethodDeclarations(staticAnnotatedMethods);
            this.gatherMappings(staticAnnotatedMethods, mappings);
            this.processMethodDeclarations(annotatedMethods);
            this.gatherMappings(annotatedMethods, mappings);
            this.out.println("");
            this.out.print("        runtime.addBoundMethods(" + classAndSubs.size() + ", ");
            this.out.print(classAndSubs.stream().map(s2 -> AnnotationBinder.quote(s2)).collect(Collectors.joining(", ")));
            mappings.forEach((javaName, rubyName) -> this.out.print(", " + AnnotationBinder.quote(javaName) + ", " + AnnotationBinder.quote(rubyName) + ""));
            this.out.println(");");
            this.out.println("    }");
            this.out.println("    static {");
            AnnotationHelper.populateMethodIndex(readGroups, (bits, names2) -> this.emitIndexCode((int)bits, (String)names2, "        MethodIndex.addMethodReadFieldsPacked(%d, \"%s\");"));
            AnnotationHelper.populateMethodIndex(writeGroups, (bits, names2) -> this.emitIndexCode((int)bits, (String)names2, "        MethodIndex.addMethodWriteFieldsPacked(%d, \"%s\");"));
            this.out.println("    }");
            this.out.println("}");
            this.out.close();
            this.out = null;
            new File(SRC_GEN_DIR).mkdirs();
            FileOutputStream fos = new FileOutputStream(SRC_GEN_DIR + qualifiedName + POPULATOR_SUFFIX + ".java");
            fos.write(bytes2.toByteArray());
            fos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void addSubclassNames(List<String> classAndSubs, JRubyClass classAnno) {
        try {
            AnnotationHelper.addSubclassNames(classAndSubs, classAnno);
        }
        catch (MirroredTypesException mte) {
            for (TypeMirror typeMirror : mte.getTypeMirrors()) {
                classAndSubs.add(((TypeElement)this.types.asElement(typeMirror)).getQualifiedName().toString());
            }
        }
    }

    protected void gatherMappings(Map<CharSequence, List<ExecutableElement>> methods2, Map<CharSequence, CharSequence> mappings) {
        for (Map.Entry<CharSequence, List<ExecutableElement>> entry : methods2.entrySet()) {
            ExecutableElement decl = entry.getValue().get(0);
            JRubyMethod anno = decl.getAnnotation(JRubyMethod.class);
            if (anno.omit()) continue;
            String javaName = decl.getSimpleName().toString();
            CharSequence rubyName = entry.getKey();
            mappings.putIfAbsent(javaName, rubyName);
        }
    }

    public void emitIndexCode(int bits, String names2, String format) {
        this.out.println(String.format(format, bits, names2));
    }

    public void processMethodDeclarations(Map<CharSequence, List<ExecutableElement>> declarations) {
        for (Map.Entry<CharSequence, List<ExecutableElement>> entry : declarations.entrySet()) {
            List<ExecutableElement> list2 = entry.getValue();
            if (list2.size() == 1) {
                this.processMethodDeclaration(list2.get(0));
                continue;
            }
            this.processMethodDeclarationMulti(list2.get(0));
        }
    }

    public void processMethodDeclaration(ExecutableElement method2) {
        JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
        if (anno != null && this.out != null) {
            boolean isStatic = method2.getModifiers().contains((Object)Modifier.STATIC);
            CharSequence qualifiedName = AnnotationBinder.getActualQualifiedName((TypeElement)method2.getEnclosingElement());
            ParametersInfo info = AnnotationBinder.identifyParameters(method2.getParameters());
            int actualRequired = AnnotationBinder.calculateActualRequired(method2, method2.getParameters().size(), anno.optional(), anno.rest(), isStatic, info.hasContext, info.hasBlock);
            String annotatedBindingName = CodegenUtils.getAnnotatedBindingClassName(method2.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), false, anno.frame());
            String implClass = anno.meta() ? "singletonClass" : "cls";
            String baseName = AnnotationBinder.getBaseName(anno.name(), method2);
            this.out.println("        javaMethod = new " + annotatedBindingName + "(" + implClass + ", Visibility." + (Object)((Object)anno.visibility()) + ", \"" + baseName + "\");");
            this.out.println("        populateMethod(javaMethod, " + AnnotationBinder.join(AnnotationHelper.getArityValue(anno, actualRequired), AnnotationBinder.quote(method2.getSimpleName()), isStatic, anno.notImplemented(), ((TypeElement)method2.getEnclosingElement()).getQualifiedName() + ".class", AnnotationBinder.quote(method2.getSimpleName()), method2.getReturnType() + ".class", info.typeDecl) + ");");
            this.generateMethodAddCalls(method2, anno);
        }
    }

    public void processMethodDeclarationMulti(ExecutableElement method2) {
        JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
        if (anno != null && this.out != null) {
            boolean isStatic = method2.getModifiers().contains((Object)Modifier.STATIC);
            CharSequence qualifiedName = AnnotationBinder.getActualQualifiedName((TypeElement)method2.getEnclosingElement());
            ParametersInfo info = AnnotationBinder.identifyParameters(method2.getParameters());
            int actualRequired = AnnotationBinder.calculateActualRequired(method2, method2.getParameters().size(), anno.optional(), anno.rest(), isStatic, info.hasContext, info.hasBlock);
            String annotatedBindingName = CodegenUtils.getAnnotatedBindingClassName(method2.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), true, anno.frame());
            String implClass = anno.meta() ? "singletonClass" : "cls";
            String baseName = AnnotationBinder.getBaseName(anno.name(), method2);
            this.out.println("        javaMethod = new " + annotatedBindingName + "(" + implClass + ", Visibility." + (Object)((Object)anno.visibility()) + ", \"" + baseName + "\");");
            this.out.println("        populateMethod(javaMethod, " + AnnotationBinder.join(-1, AnnotationBinder.quote(method2.getSimpleName()), isStatic, anno.notImplemented(), ((TypeElement)method2.getEnclosingElement()).getQualifiedName() + ".class", AnnotationBinder.quote(method2.getSimpleName()), method2.getReturnType() + ".class", info.typeDecl) + ");");
            this.generateMethodAddCalls(method2, anno);
        }
    }

    private static ParametersInfo identifyParameters(List<? extends VariableElement> parameters2) {
        boolean hasContext = false;
        boolean hasBlock = false;
        int s2 = 0;
        int l = parameters2.size();
        if (l > 0 && parameters2.get(0).asType().toString().equals("org.jruby.runtime.ThreadContext")) {
            hasContext = true;
            ++s2;
        }
        if (l > 0 && parameters2.get(l - 1).asType().toString().equals("org.jruby.runtime.Block")) {
            hasBlock = true;
            --l;
        }
        boolean allIRubyObject = true;
        boolean aryIRubyObject = false;
        TypeMirror[] types = new TypeMirror[l - s2];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = parameters2.get(s2 + i2).asType();
            if (!types[i2].toString().startsWith("org.jruby.runtime.builtin.IRubyObject")) {
                allIRubyObject = false;
                break;
            }
            if (!types[i2].toString().endsWith("[]")) continue;
            aryIRubyObject = true;
        }
        if (allIRubyObject) {
            StringJoiner constant = new StringJoiner("_");
            if (hasContext) {
                constant.add("CONTEXT");
            }
            constant.add("ARG" + (aryIRubyObject ? types.length - 1 : types.length));
            if (aryIRubyObject) {
                constant.add("ARY");
            }
            if (hasBlock) {
                constant.add("BLOCK");
            }
            return new ParametersInfo(constant.toString(), hasContext, hasBlock);
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (VariableElement variableElement : parameters2) {
            joiner.add(variableElement.asType() + ".class");
        }
        return new ParametersInfo("new Class[] { " + joiner + " }", hasContext, hasBlock);
    }

    private static CharSequence getActualQualifiedName(TypeElement elem) {
        if (elem.getNestingKind() == NestingKind.MEMBER) {
            return AnnotationBinder.getActualQualifiedName((TypeElement)elem.getEnclosingElement()) + "$" + elem.getSimpleName();
        }
        return elem.getQualifiedName().toString();
    }

    private static StringBuilder join(Object ... vals) {
        return AnnotationBinder.join(", ", Arrays.asList(vals));
    }

    private static StringBuilder join(String sep, Iterable<?> names2) {
        StringBuilder str = new StringBuilder();
        for (Object name2 : names2) {
            if (str.length() > 0) {
                str.append(sep);
            }
            str.append(name2);
        }
        return str;
    }

    private static CharSequence quote(Object name2) {
        return new StringBuilder().append('\"').append(name2).append('\"');
    }

    private static int calculateActualRequired(ExecutableElement method2, int paramsLength, int optional, boolean rest2, boolean isStatic, boolean hasContext, boolean hasBlock) {
        int args2 = paramsLength;
        if (args2 == 0) {
            return 0;
        }
        if (isStatic) {
            --args2;
        }
        if (hasContext) {
            --args2;
        }
        if (hasBlock) {
            --args2;
        }
        if (optional == 0 && !rest2) {
            return args2;
        }
        if (--args2 != 0) {
            throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported: " + ((TypeElement)method2.getEnclosingElement()).getQualifiedName() + "." + method2);
        }
        return args2;
    }

    public void generateMethodAddCalls(ExecutableElement md, JRubyMethod anno) {
        this.generateMethodAddCalls(md, anno.meta(), anno.module(), anno.name(), anno.alias());
    }

    private void generateMethodAddCalls(ExecutableElement md, boolean meta, boolean module, String[] names2, String[] aliases2) {
        if (meta) {
            this.defineMethodOnClass("javaMethod", "singletonClass", names2, aliases2, md);
        } else {
            this.defineMethodOnClass("javaMethod", "cls", names2, aliases2, md);
            if (module) {
                this.out.println("        moduleMethod = populateModuleMethod(cls, javaMethod);");
                this.defineMethodOnClass("moduleMethod", "singletonClass", names2, aliases2, md);
            }
        }
    }

    private void defineMethodOnClass(String methodVar, String classVar, String[] names2, String[] aliases2, ExecutableElement md) {
        String baseName = AnnotationBinder.getBaseName(names2, md);
        this.out.println("        aliasedMethod = " + classVar + ".putMethod(runtime, \"" + baseName + "\", " + methodVar + ");");
        if (names2.length > 0) {
            for (String name2 : names2) {
                if (name2.contentEquals(baseName)) continue;
                this.out.println("        " + classVar + ".putMethod(runtime, \"" + name2 + "\", " + methodVar + ");");
            }
        }
        if (aliases2.length > 0) {
            for (String alias : aliases2) {
                this.out.println("        " + classVar + ".putAlias(\"" + alias + "\", aliasedMethod, \"" + baseName + "\");");
            }
        }
    }

    public static void checkForThrows(TypeElement type2, ExecutableElement method2) {
        ArrayList<String> exNames = new ArrayList<String>();
        for (TypeMirror typeMirror : method2.getThrownTypes()) {
            String name2 = typeMirror.toString();
            if (name2.equals("org.jruby.exceptions.RaiseException")) continue;
            exNames.add(name2);
        }
        if (exNames.size() > 0) {
            AnnotationBinder.warn("method " + type2 + "." + method2 + " should not throw exceptions: " + AnnotationBinder.join(", ", exNames));
        }
    }

    public static String getBaseName(String[] names2, ExecutableElement md) {
        if (names2.length == 0) {
            return md.getSimpleName().toString();
        }
        return names2[0];
    }

    private static void warn(CharSequence msg) {
        System.err.println(msg);
    }

    private static class ParametersInfo {
        final String typeDecl;
        final boolean hasContext;
        final boolean hasBlock;

        ParametersInfo(String name2, boolean hasContext, boolean hasBlock) {
            this.typeDecl = name2;
            this.hasContext = hasContext;
            this.hasBlock = hasBlock;
        }
    }
}

