/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import mediathek.config.MVColor;
import mediathek.daten.DatenFilm;
import mediathek.daten.abo.DatenAbo;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Filter {
    private static final LoadingCache<String, Pattern> CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(new PatternCacheLoader());
    private static final Logger logger = LogManager.getLogger(Filter.class);
    public static final Set<String> regExpErrorList = new HashSet<String>();

    public static boolean aboExistiertBereits(DatenAbo aboExistiert, DatenAbo aboPruefen) {
        String senderExistiert = aboExistiert.getSender();
        String themaExistiert = aboExistiert.getThema();
        String[] titelExistiert = StringUtils.split(aboExistiert.getTitle().toLowerCase(), ",");
        String[] themaTitelExistiert = StringUtils.split(aboExistiert.getThemaTitel().toLowerCase(), ",");
        String[] irgendwoExistiert = StringUtils.split(aboExistiert.getIrgendwo().toLowerCase(), ",");
        String themaPruefen = aboPruefen.getThema();
        String titelPruefen = aboPruefen.getTitle();
        String irgendwoPruefen = aboPruefen.getIrgendwo();
        return Filter.conditionExists(senderExistiert, aboPruefen.getSender()) && Filter.conditionExists(themaExistiert, themaPruefen) && Filter.titleConditionExists(titelExistiert, titelPruefen) && Filter.themaTitelConditionExists(themaTitelExistiert, themaPruefen, titelPruefen) && Filter.aboIrgendwoConditionExists(irgendwoExistiert, themaPruefen, titelPruefen, irgendwoPruefen);
    }

    private static boolean aboIrgendwoConditionExists(String[] irgendwoExistiert, String themaPruefen, String titelPruefen, String irgendwoPruefen) {
        return irgendwoExistiert.length == 0 || Filter.pruefen(irgendwoExistiert, themaPruefen) || Filter.pruefen(irgendwoExistiert, titelPruefen) || Filter.pruefen(irgendwoExistiert, irgendwoPruefen);
    }

    public static boolean filterAufFilmPruefenWithLength(String senderSuchen, String themaSuchen, String[] titelSuchen, String[] themaTitelSuchen, String[] irgendwoSuchen, int laengeMinutenSuchen, boolean min2, DatenFilm film, boolean checkLength) {
        boolean result = false;
        String thema = film.getThema();
        String title = film.getTitle();
        if (Filter.senderConditionExists(senderSuchen, film) && Filter.conditionExists(themaSuchen, thema) && Filter.titleConditionExists(titelSuchen, title) && Filter.themaTitelConditionExists(themaTitelSuchen, thema, title) && Filter.irgendwoConditionExists(film, irgendwoSuchen, thema, title)) {
            result = checkLength ? Filter.laengePruefen(laengeMinutenSuchen, film.getFilmLength(), min2) : true;
        }
        return result;
    }

    public static boolean filterAufFilmPruefen(@NotNull String senderSuchen, @NotNull String themaSuchen, @NotNull String[] titelSuchen, @NotNull String[] themaTitelSuchen, @NotNull String[] irgendwoSuchen, @NotNull DatenFilm film) {
        boolean result = false;
        String thema = film.getThema();
        String title = film.getTitle();
        if (Filter.senderConditionExists(senderSuchen, film) && Filter.conditionExists(themaSuchen, thema) && Filter.titleConditionExists(titelSuchen, title) && Filter.themaTitelConditionExists(themaTitelSuchen, thema, title) && Filter.irgendwoConditionExists(film, irgendwoSuchen, thema, title)) {
            result = true;
        }
        return result;
    }

    private static boolean irgendwoConditionExists(@NotNull DatenFilm film, @NotNull String[] irgendwoSuchen, @NotNull String thema, @NotNull String title) {
        return irgendwoSuchen.length == 0 || Filter.pruefen(irgendwoSuchen, film.getDescription()) || Filter.pruefen(irgendwoSuchen, thema) || Filter.pruefen(irgendwoSuchen, title);
    }

    private static boolean themaTitelConditionExists(@NotNull String[] themaTitelSuchen, @NotNull String thema, @NotNull String title) {
        return themaTitelSuchen.length == 0 || Filter.pruefen(themaTitelSuchen, thema) || Filter.pruefen(themaTitelSuchen, title);
    }

    private static boolean titleConditionExists(@NotNull String[] titelSuchen, @NotNull String title) {
        return titelSuchen.length == 0 || Filter.pruefen(titelSuchen, title);
    }

    private static boolean conditionExists(@NotNull String obj1, @NotNull String obj2) {
        return obj1.isEmpty() || obj2.equalsIgnoreCase(obj1);
    }

    private static boolean senderConditionExists(@NotNull String senderSuchen, @NotNull DatenFilm film) {
        return senderSuchen.isEmpty() || film.getSender().compareTo(senderSuchen) == 0;
    }

    public static boolean lengthCheck(int filterLaengeInMinuten, long filmLaenge) {
        return filterLaengeInMinuten == 0 || filmLaenge == 0L;
    }

    private static boolean checkLengthNoMin(int filterLaengeInMinuten, long filmLaenge) {
        int filterLength = filterLaengeInMinuten * 60;
        return Filter.lengthCheck(filterLaengeInMinuten, filmLaenge) || filmLaenge < (long)filterLength;
    }

    public static boolean checkLengthWithMin(int filterLaengeInMinuten, long filmLaenge) {
        int filterLength = filterLaengeInMinuten * 60;
        return Filter.lengthCheck(filterLaengeInMinuten, filmLaenge) || filmLaenge > (long)filterLength;
    }

    public static boolean laengePruefen(int filterLaengeInMinuten, long filmLaenge, boolean min2) {
        boolean result = min2 ? Filter.checkLengthWithMin(filterLaengeInMinuten, filmLaenge) : Filter.checkLengthNoMin(filterLaengeInMinuten, filmLaenge);
        return result;
    }

    public static boolean pruefen(@NotNull String[] filter, @NotNull String im) {
        String strFilter = filter[0];
        if (filter.length == 1) {
            if (strFilter.isEmpty()) {
                return true;
            }
            Pattern p = Filter.makePattern(strFilter);
            if (p != null) {
                return p.matcher(im).matches();
            }
        }
        return Filter.checkLowercase(filter, im.toLowerCase());
    }

    public static boolean checkLowercase(@NotNull String[] filter, @NotNull String im) {
        for (String s2 : filter) {
            if (!im.contains(s2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPattern(@NotNull String textSuchen) {
        return textSuchen.startsWith("#:");
    }

    public static Pattern makePattern(String regExpStr) {
        Pattern p;
        if (Filter.isPattern(regExpStr)) {
            try {
                p = CACHE.get(regExpStr);
            }
            catch (Exception ex) {
                logger.error("!!!!");
                logger.error("INVALID REGEX PATTERN DETECTED: {}", (Object)regExpStr);
                logger.error("!!! Please review your config files !!!");
                logger.error("!!!!");
                regExpErrorList.add(regExpStr);
                p = null;
            }
        } else {
            p = null;
        }
        return p;
    }

    public static Pattern makePatternNoCache(String regExpStr) {
        Pattern p;
        if (Filter.isPattern(regExpStr)) {
            try {
                String regexPattern = regExpStr.substring(2);
                p = Pattern.compile(regexPattern, 98);
            }
            catch (IllegalArgumentException ex) {
                p = null;
            }
        } else {
            p = null;
        }
        return p;
    }

    public static boolean regExpErrorsOccured() {
        return !regExpErrorList.isEmpty();
    }

    public static void validatePatternInput(JTextField tf) {
        String text = tf.getText();
        if (Filter.isPattern(text)) {
            if (Filter.makePattern(text) == null) {
                tf.setBackground(MVColor.FILTER_REGEX_FEHLER.color);
            } else {
                tf.setBackground(MVColor.FILTER_REGEX.color);
            }
        } else {
            tf.setBackground(Color.WHITE);
        }
    }

    static class PatternCacheLoader
    extends CacheLoader<String, Pattern> {
        PatternCacheLoader() {
        }

        @Override
        public Pattern load(@NotNull String pattern) throws IllegalArgumentException {
            logger.trace("COMPILING PATTERN: " + pattern);
            String regexPattern = pattern.substring(2);
            return Pattern.compile(regexPattern, 98);
        }
    }
}

