info = {
    "name": "es",
    "date_order": "DMY",
    "january": [
        "ene",
        "enero"
    ],
    "february": [
        "feb",
        "febrero"
    ],
    "march": [
        "mar",
        "marzo"
    ],
    "april": [
        "abr",
        "abril"
    ],
    "may": [
        "may",
        "mayo"
    ],
    "june": [
        "jun",
        "junio"
    ],
    "july": [
        "jul",
        "julio"
    ],
    "august": [
        "ago",
        "agosto"
    ],
    "september": [
        "sept",
        "septiembre",
        "Setiembre",
        "Sep",
        "Set"
    ],
    "october": [
        "oct",
        "octubre"
    ],
    "november": [
        "nov",
        "noviembre"
    ],
    "december": [
        "dic",
        "diciembre"
    ],
    "monday": [
        "lun",
        "lunes",
        "Lu"
    ],
    "tuesday": [
        "mar",
        "martes"
    ],
    "wednesday": [
        "mié",
        "miércoles",
        "Mi"
    ],
    "thursday": [
        "jue",
        "jueves",
        "Ju"
    ],
    "friday": [
        "vie",
        "viernes",
        "Vi"
    ],
    "saturday": [
        "sáb",
        "sábado",
        "Sa"
    ],
    "sunday": [
        "dom",
        "domingo",
        "Do"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "a",
        "año",
        "años"
    ],
    "month": [
        "m",
        "mes",
        "meses"
    ],
    "week": [
        "sem",
        "semana",
        "semanas"
    ],
    "day": [
        "d",
        "día",
        "días"
    ],
    "hour": [
        "h",
        "hora",
        "horas"
    ],
    "minute": [
        "min",
        "minuto",
        "minutos"
    ],
    "second": [
        "s",
        "segundo",
        "segundos"
    ],
    "relative-type": {
        "0 day ago": [
            "hoy"
        ],
        "0 hour ago": [
            "esta hora"
        ],
        "0 minute ago": [
            "este minuto"
        ],
        "0 month ago": [
            "este mes"
        ],
        "0 second ago": [
            "ahora"
        ],
        "0 week ago": [
            "esta semana"
        ],
        "0 year ago": [
            "este año"
        ],
        "1 day ago": [
            "ayer"
        ],
        "1 month ago": [
            "el mes pasado"
        ],
        "1 week ago": [
            "la semana pasada"
        ],
        "1 year ago": [
            "el año pasado"
        ],
        "in 1 day": [
            "mañana"
        ],
        "in 1 month": [
            "el próximo mes"
        ],
        "in 1 week": [
            "la próxima semana"
        ],
        "in 1 year": [
            "el próximo año"
        ],
        "2 day ago": [
            "anteayer"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "hace (\\d+) día",
            "hace (\\d+) días"
        ],
        "\\1 hour ago": [
            "hace (\\d+) h",
            "hace (\\d+) hora",
            "hace (\\d+) horas"
        ],
        "\\1 minute ago": [
            "hace (\\d+) min",
            "hace (\\d+) minuto",
            "hace (\\d+) minutos"
        ],
        "\\1 month ago": [
            "hace (\\d+) m",
            "hace (\\d+) mes",
            "hace (\\d+) meses"
        ],
        "\\1 second ago": [
            "hace (\\d+) s",
            "hace (\\d+) segundo",
            "hace (\\d+) segundos"
        ],
        "\\1 week ago": [
            "hace (\\d+) sem",
            "hace (\\d+) semana",
            "hace (\\d+) semanas"
        ],
        "\\1 year ago": [
            "hace (\\d+) a",
            "hace (\\d+) año",
            "hace (\\d+) años"
        ],
        "in \\1 day": [
            "dentro de (\\d+) día",
            "dentro de (\\d+) días"
        ],
        "in \\1 hour": [
            "dentro de (\\d+) h",
            "dentro de (\\d+) hora",
            "dentro de (\\d+) horas"
        ],
        "in \\1 minute": [
            "dentro de (\\d+) min",
            "dentro de (\\d+) minuto",
            "dentro de (\\d+) minutos"
        ],
        "in \\1 month": [
            "dentro de (\\d+) m",
            "dentro de (\\d+) mes",
            "dentro de (\\d+) meses"
        ],
        "in \\1 second": [
            "dentro de (\\d+) s",
            "dentro de (\\d+) segundo",
            "dentro de (\\d+) segundos"
        ],
        "in \\1 week": [
            "dentro de (\\d+) sem",
            "dentro de (\\d+) semana",
            "dentro de (\\d+) semanas"
        ],
        "in \\1 year": [
            "dentro de (\\d+) a",
            "dentro de (\\d+) año",
            "dentro de (\\d+) años"
        ]
    },
    "locale_specific": {
        "es-419": {
            "name": "es-419",
            "september": [
                "sep"
            ]
        },
        "es-AR": {
            "name": "es-AR",
            "september": [
                "sep"
            ],
            "second": [
                "seg"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "hace (\\d+) seg"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) seg"
                ]
            }
        },
        "es-BO": {
            "name": "es-BO",
            "september": [
                "sep"
            ]
        },
        "es-BR": {
            "name": "es-BR",
            "september": [
                "sep"
            ]
        },
        "es-BZ": {
            "name": "es-BZ",
            "september": [
                "sep"
            ]
        },
        "es-CL": {
            "name": "es-CL",
            "september": [
                "sep"
            ]
        },
        "es-CO": {
            "name": "es-CO",
            "september": [
                "sep"
            ]
        },
        "es-CR": {
            "name": "es-CR",
            "september": [
                "sep"
            ]
        },
        "es-CU": {
            "name": "es-CU",
            "september": [
                "sep"
            ]
        },
        "es-DO": {
            "name": "es-DO",
            "september": [
                "sep"
            ]
        },
        "es-EA": {
            "name": "es-EA"
        },
        "es-EC": {
            "name": "es-EC",
            "september": [
                "sep"
            ]
        },
        "es-GQ": {
            "name": "es-GQ"
        },
        "es-GT": {
            "name": "es-GT",
            "september": [
                "sep"
            ]
        },
        "es-HN": {
            "name": "es-HN",
            "september": [
                "sep"
            ]
        },
        "es-IC": {
            "name": "es-IC"
        },
        "es-MX": {
            "name": "es-MX",
            "september": [
                "sep"
            ],
            "relative-type": {
                "in 1 month": [
                    "el mes próximo"
                ],
                "in 1 week": [
                    "la semana próxima"
                ],
                "in 1 year": [
                    "el año próximo"
                ]
            },
            "relative-type-regex": {
                "in \\1 day": [
                    "en (\\d+) día",
                    "en (\\d+) días"
                ],
                "in \\1 hour": [
                    "en (\\d+) h",
                    "en (\\d+) n"
                ],
                "in \\1 minute": [
                    "en (\\d+) min"
                ],
                "in \\1 month": [
                    "en (\\d+) m",
                    "en (\\d+) mes",
                    "en (\\d+) meses"
                ],
                "in \\1 second": [
                    "en (\\d+) s"
                ],
                "in \\1 week": [
                    "en (\\d+) sem"
                ],
                "in \\1 year": [
                    "en (\\d+) a"
                ]
            }
        },
        "es-NI": {
            "name": "es-NI",
            "september": [
                "sep"
            ]
        },
        "es-PA": {
            "name": "es-PA",
            "date_order": "MDY",
            "september": [
                "sep"
            ]
        },
        "es-PE": {
            "name": "es-PE",
            "september": [
                "set",
                "setiembre"
            ]
        },
        "es-PH": {
            "name": "es-PH"
        },
        "es-PR": {
            "name": "es-PR",
            "date_order": "MDY",
            "september": [
                "sep"
            ]
        },
        "es-PY": {
            "name": "es-PY",
            "second": [
                "seg"
            ],
            "relative-type-regex": {
                "\\1 second ago": [
                    "hace (\\d+) seg"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) seg"
                ]
            }
        },
        "es-SV": {
            "name": "es-SV",
            "september": [
                "sep"
            ]
        },
        "es-US": {
            "name": "es-US",
            "september": [
                "sep"
            ]
        },
        "es-UY": {
            "name": "es-UY",
            "september": [
                "set",
                "setiembre"
            ]
        },
        "es-VE": {
            "name": "es-VE"
        }
    },
    "skip": [
        "a las",
        "cerca",
        "de",
        "del",
        "en",
        "y",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "pertain": [
        "de",
        "del"
    ],
    "sentence_splitter_group": 2,
    "ago": [
        "hace"
    ],
    "in": [
        "en"
    ],
    "simplifications": [
        {
            "una": "1"
        },
        {
            "un": "1"
        }
    ]
}
