/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.tagplugin.TagPlugin;
import org.apache.jasper.compiler.tagplugin.TagPluginContext;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;

public class TagPluginManager {
    private static final String META_INF_JASPER_TAG_PLUGINS_XML = "META-INF/org.apache.jasper/tagPlugins.xml";
    private static final String TAG_PLUGINS_XML = "/WEB-INF/tagPlugins.xml";
    private static final String TAG_PLUGINS_ROOT_ELEM = "tag-plugins";
    private boolean initialized = false;
    private HashMap<String, TagPlugin> tagPlugins = null;
    private ServletContext ctxt;

    public TagPluginManager(ServletContext servletContext) {
        this.ctxt = servletContext;
    }

    public void apply(Node.Nodes nodes, ErrorDispatcher errorDispatcher, PageInfo pageInfo) throws JasperException {
        this.init(errorDispatcher);
        if (this.tagPlugins == null || this.tagPlugins.size() == 0) {
            return;
        }
        nodes.visit(new NodeVisitor(this, pageInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ErrorDispatcher errorDispatcher) throws JasperException {
        Object object;
        if (this.initialized) {
            return;
        }
        this.tagPlugins = new HashMap();
        Enumeration<URL> enumeration = null;
        try {
            enumeration = this.ctxt.getClassLoader().getResources(META_INF_JASPER_TAG_PLUGINS_XML);
        }
        catch (IOException iOException) {
            throw new JasperException(iOException);
        }
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            InputStream inputStream = null;
            try {
                inputStream = ((URL)object).openStream();
                this.loadTagPlugins(errorDispatcher, inputStream);
            }
            catch (IOException iOException) {
                throw new JasperException(iOException);
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new JasperException(iOException);
                }
            }
        }
        object = null;
        try {
            object = this.ctxt.getResourceAsStream(TAG_PLUGINS_XML);
            if (object != null) {
                this.loadTagPlugins(errorDispatcher, (InputStream)object);
            }
        }
        finally {
            try {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            catch (IOException iOException) {
                throw new JasperException(iOException);
            }
        }
        this.initialized = true;
    }

    private void loadTagPlugins(ErrorDispatcher errorDispatcher, InputStream inputStream) throws JasperException {
        String string = this.ctxt.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
        boolean bl = string == null ? true : Boolean.parseBoolean(string);
        ParserUtils parserUtils = new ParserUtils(false, bl);
        TreeNode treeNode = parserUtils.parseXMLDocument(TAG_PLUGINS_XML, inputStream);
        if (!TAG_PLUGINS_ROOT_ELEM.equals(treeNode.getName())) {
            errorDispatcher.jspError("jsp.error.plugin.wrongRootElement", TAG_PLUGINS_XML, TAG_PLUGINS_ROOT_ELEM);
        }
        this.tagPlugins = new HashMap();
        Iterator<TreeNode> iterator = treeNode.findChildren("tag-plugin");
        while (iterator.hasNext()) {
            TreeNode treeNode2 = iterator.next();
            TreeNode treeNode3 = treeNode2.findChild("tag-class");
            if (treeNode3 == null) {
                return;
            }
            String string2 = treeNode3.getBody().trim();
            TreeNode treeNode4 = treeNode2.findChild("plugin-class");
            if (treeNode4 == null) {
                return;
            }
            String string3 = treeNode4.getBody();
            TagPlugin tagPlugin = null;
            try {
                Class<?> clazz = this.ctxt.getClassLoader().loadClass(string3);
                tagPlugin = (TagPlugin)clazz.newInstance();
                this.tagPlugins.put(string2, tagPlugin);
            }
            catch (Exception exception) {
                throw new JasperException(exception);
            }
        }
        this.initialized = true;
    }

    private void invokePlugin(Node.CustomTag customTag, PageInfo pageInfo) {
        TagPlugin tagPlugin = this.tagPlugins.get(customTag.getTagHandlerClass().getName());
        if (tagPlugin == null) {
            return;
        }
        TagPluginContextImpl tagPluginContextImpl = new TagPluginContextImpl(customTag, pageInfo);
        customTag.setTagPluginContext(tagPluginContextImpl);
        tagPlugin.doTag(tagPluginContextImpl);
    }

    private static class TagPluginContextImpl
    implements TagPluginContext {
        private final Node.CustomTag node;
        private Node.Nodes curNodes;
        private PageInfo pageInfo;
        private HashMap<String, Object> pluginAttributes;

        TagPluginContextImpl(Node.CustomTag customTag, PageInfo pageInfo) {
            this.node = customTag;
            this.pageInfo = pageInfo;
            this.curNodes = new Node.Nodes();
            customTag.setAtETag(this.curNodes);
            this.curNodes = new Node.Nodes();
            customTag.setAtSTag(this.curNodes);
            customTag.setUseTagPlugin(true);
            this.pluginAttributes = new HashMap();
        }

        @Override
        public TagPluginContext getParentContext() {
            Node node = this.node.getParent();
            if (!(node instanceof Node.CustomTag)) {
                return null;
            }
            return ((Node.CustomTag)node).getTagPluginContext();
        }

        @Override
        public void setPluginAttribute(String string, Object object) {
            this.pluginAttributes.put(string, object);
        }

        @Override
        public Object getPluginAttribute(String string) {
            return this.pluginAttributes.get(string);
        }

        @Override
        public boolean isScriptless() {
            return this.node.getChildInfo().isScriptless();
        }

        @Override
        public boolean isConstantAttribute(String string) {
            Node.JspAttribute jspAttribute = this.getNodeAttribute(string);
            if (jspAttribute == null) {
                return false;
            }
            return jspAttribute.isLiteral();
        }

        @Override
        public String getConstantAttribute(String string) {
            Node.JspAttribute jspAttribute = this.getNodeAttribute(string);
            if (jspAttribute == null) {
                return null;
            }
            return jspAttribute.getValue();
        }

        @Override
        public boolean isAttributeSpecified(String string) {
            return this.getNodeAttribute(string) != null;
        }

        @Override
        public String getTemporaryVariableName() {
            return this.node.getRoot().nextTemporaryVariableName();
        }

        @Override
        public void generateImport(String string) {
            this.pageInfo.addImport(string);
        }

        @Override
        public void generateDeclaration(String string, String string2) {
            if (this.pageInfo.isPluginDeclared(string)) {
                return;
            }
            this.curNodes.add(new Node.Declaration(string2, this.node.getStart(), null));
        }

        @Override
        public void generateJavaSource(String string) {
            this.curNodes.add(new Node.Scriptlet(string, this.node.getStart(), null));
        }

        @Override
        public void generateAttribute(String string) {
            this.curNodes.add(new Node.AttributeGenerator(this.node.getStart(), string, this.node));
        }

        @Override
        public void dontUseTagPlugin() {
            this.node.setUseTagPlugin(false);
        }

        @Override
        public void generateBody() {
            this.curNodes = this.node.getAtETag();
        }

        @Override
        public boolean isTagFile() {
            return this.pageInfo.isTagFile();
        }

        private Node.JspAttribute getNodeAttribute(String string) {
            Node.JspAttribute[] jspAttributeArray = this.node.getJspAttributes();
            for (int i = 0; jspAttributeArray != null && i < jspAttributeArray.length; ++i) {
                if (!jspAttributeArray[i].getName().equals(string)) continue;
                return jspAttributeArray[i];
            }
            return null;
        }
    }

    private static class NodeVisitor
    extends Node.Visitor {
        private final TagPluginManager manager;
        private final PageInfo pageInfo;

        public NodeVisitor(TagPluginManager tagPluginManager, PageInfo pageInfo) {
            this.manager = tagPluginManager;
            this.pageInfo = pageInfo;
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            this.manager.invokePlugin(customTag, this.pageInfo);
            this.visitBody(customTag);
        }
    }
}

