from types import TracebackType
from typing import Any, Type

from .tracer import Tracer

class SpanContext:
    EMPTY_BAGGAGE: dict[str, str]
    @property
    def baggage(self) -> dict[str, str]: ...

class Span:
    def __init__(self, tracer: Tracer, context: SpanContext) -> None: ...
    @property
    def context(self) -> SpanContext: ...
    @property
    def tracer(self) -> Tracer: ...
    def set_operation_name(self, operation_name: str) -> Span: ...
    def finish(self, finish_time: float | None = ...) -> None: ...
    def set_tag(self, key: str, value: str | bool | int | float) -> Span: ...
    def log_kv(self, key_values: dict[str, Any], timestamp: float | None = ...) -> Span: ...
    def set_baggage_item(self, key: str, value: str) -> Span: ...
    def get_baggage_item(self, key: str) -> str | None: ...
    def __enter__(self) -> Span: ...
    def __exit__(
        self, exc_type: Type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None
    ) -> None: ...
    def log_event(self, event: Any, payload: Any | None = ...) -> Span: ...
    def log(self, **kwargs: Any) -> Span: ...
