/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.jsp.JspFactory;
import java.io.IOException;
import java.util.Set;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TldCache;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.security.SecurityClassLoad;
import org.apache.jasper.servlet.TldScanner;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.xml.sax.SAXException;

public class JasperInitializer
implements ServletContainerInitializer {
    private static final String MSG = "org.apache.jasper.servlet.JasperInitializer";
    private final Log log = LogFactory.getLog(JasperInitializer.class);
    private static JspFactoryImpl defaultFactory;

    public void onStartup(Set<Class<?>> set, ServletContext servletContext) throws ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)Localizer.getMessage("org.apache.jasper.servlet.JasperInitializer.onStartup", servletContext.getServletContextName()));
        }
        if (servletContext.getAttribute(InstanceManager.class.getName()) == null) {
            servletContext.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        }
        boolean bl = Boolean.parseBoolean(servletContext.getInitParameter("org.apache.jasper.XML_VALIDATE_TLD"));
        String string = servletContext.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
        boolean bl2 = string == null ? true : Boolean.parseBoolean(string);
        TldScanner tldScanner = this.newTldScanner(servletContext, true, bl, bl2);
        try {
            tldScanner.scan();
        }
        catch (IOException | SAXException exception) {
            throw new ServletException((Throwable)exception);
        }
        for (String string2 : tldScanner.getListeners()) {
            servletContext.addListener(string2);
        }
        servletContext.setAttribute(TldCache.SERVLET_CONTEXT_ATTRIBUTE_NAME, (Object)new TldCache(servletContext, tldScanner.getUriTldResourcePathMap(), tldScanner.getTldResourcePathTaglibXmlMap()));
        String string3 = servletContext.getInitParameter("org.apache.jasper.runtime.JspFactoryImpl.POOL_SIZE");
        int n = 8;
        if (string3 != null) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ServletException((Throwable)numberFormatException);
            }
        }
        defaultFactory.setPoolSize(n);
    }

    protected TldScanner newTldScanner(ServletContext servletContext, boolean bl, boolean bl2, boolean bl3) {
        return new TldScanner(servletContext, bl, bl2, bl3);
    }

    static {
        JspFactoryImpl jspFactoryImpl = new JspFactoryImpl();
        SecurityClassLoad.securityClassLoad(((Object)((Object)jspFactoryImpl)).getClass().getClassLoader());
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)jspFactoryImpl);
            defaultFactory = jspFactoryImpl;
        }
    }
}

