/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet.sheets.excel;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;
import org.gephi.io.importer.plugin.file.spreadsheet.sheets.excel.ExcelSheetRow;

public class ExcelSheetParser
implements SheetParser {
    private final Sheet sheet;
    private final boolean withFirstRecordAsHeader;
    private final Map<String, Integer> headerMap = new LinkedHashMap<String, Integer>();
    private ExcelIterator iterator;
    private int rowsFirstIndex = Integer.MAX_VALUE;
    private int rowsLastIndex = Integer.MIN_VALUE;

    public ExcelSheetParser(Sheet sheet, boolean withFirstRecordAsHeader) {
        this.sheet = sheet;
        this.withFirstRecordAsHeader = withFirstRecordAsHeader;
        this.calculateRowStartAndEndIndexes();
        if (withFirstRecordAsHeader) {
            this.initHeaderInfo();
        }
    }

    private void calculateRowStartAndEndIndexes() {
        int rowsToScan = this.withFirstRecordAsHeader ? 1 : 25;
        int i = this.sheet.getFirstRowNum();
        for (int j = 0; i < this.sheet.getLastRowNum() && j < rowsToScan; ++i, ++j) {
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            this.rowsFirstIndex = Math.min(this.rowsFirstIndex, row.getFirstCellNum());
            this.rowsLastIndex = Math.max(this.rowsLastIndex, row.getLastCellNum() - 1);
        }
        if (this.rowsFirstIndex == Integer.MAX_VALUE) {
            this.rowsFirstIndex = 0;
            this.rowsLastIndex = 0;
        }
    }

    private void initHeaderInfo() {
        Row firstRow = this.sheet.getRow(this.sheet.getFirstRowNum());
        int zeroBasedIndex = 0;
        for (int i = this.rowsFirstIndex; i <= this.rowsLastIndex; ++i) {
            Cell cell = firstRow.getCell(i);
            String header = ExcelSheetRow.getRowCellAsString(cell, i);
            if (header != null && !header.trim().isEmpty()) {
                this.headerMap.put(header.trim(), zeroBasedIndex);
            }
            ++zeroBasedIndex;
        }
    }

    @Override
    public Map<String, Integer> getHeaderMap() {
        return new LinkedHashMap<String, Integer>(this.headerMap);
    }

    @Override
    public long getCurrentRecordNumber() {
        return this.iterator != null ? this.iterator.getRowNum() : 0L;
    }

    @Override
    public Iterator<SheetRow> iterator() {
        this.iterator = new ExcelIterator();
        return this.iterator;
    }

    @Override
    public void close() throws IOException {
        this.iterator = null;
        this.sheet.getWorkbook().close();
    }

    private class ExcelIterator
    implements Iterator<SheetRow> {
        private final Iterator<Row> iterator;
        private Row currentRow = null;

        public ExcelIterator() {
            this.iterator = ExcelSheetParser.this.sheet.iterator();
            if (ExcelSheetParser.this.withFirstRecordAsHeader && this.iterator.hasNext()) {
                this.iterator.next();
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.iterator.hasNext();
            }
            catch (Exception e) {
                Logger.getLogger("").severe(e.getMessage());
                return false;
            }
        }

        @Override
        public SheetRow next() {
            this.currentRow = this.iterator.next();
            return new ExcelSheetRow(this.currentRow, ExcelSheetParser.this.rowsFirstIndex, ExcelSheetParser.this.rowsLastIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private long getRowNum() {
            if (this.currentRow != null) {
                return this.currentRow.getRowNum();
            }
            return 0L;
        }
    }
}

