/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanNotificationInfo;
import org.apache.tomcat.util.modeler.FeatureInfo;

public class NotificationInfo
extends FeatureInfo {
    static final long serialVersionUID = -6319885418912650856L;
    transient MBeanNotificationInfo info = null;
    protected String[] notifTypes = new String[0];
    protected final ReadWriteLock notifTypesLock = new ReentrantReadWriteLock();

    @Override
    public void setDescription(String string) {
        super.setDescription(string);
        this.info = null;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.info = null;
    }

    public String[] getNotifTypes() {
        Lock lock = this.notifTypesLock.readLock();
        try {
            lock.lock();
            String[] stringArray = this.notifTypes;
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotifType(String string) {
        Lock lock = this.notifTypesLock.writeLock();
        try {
            lock.lock();
            String[] stringArray = new String[this.notifTypes.length + 1];
            System.arraycopy(this.notifTypes, 0, stringArray, 0, this.notifTypes.length);
            stringArray[this.notifTypes.length] = string;
            this.notifTypes = stringArray;
            this.info = null;
        }
        finally {
            lock.unlock();
        }
    }

    public MBeanNotificationInfo createNotificationInfo() {
        if (this.info != null) {
            return this.info;
        }
        this.info = new MBeanNotificationInfo(this.getNotifTypes(), this.getName(), this.getDescription());
        return this.info;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NotificationInfo[");
        stringBuilder.append("name=");
        stringBuilder.append(this.name);
        stringBuilder.append(", description=");
        stringBuilder.append(this.description);
        stringBuilder.append(", notifTypes=");
        Lock lock = this.notifTypesLock.readLock();
        try {
            lock.lock();
            stringBuilder.append(this.notifTypes.length);
        }
        finally {
            lock.unlock();
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

