/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.memory;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.graalvm.visualvm.lib.jfluid.results.AbstractDataFrameProcessor;
import org.graalvm.visualvm.lib.jfluid.results.ProfilingResultListener;
import org.graalvm.visualvm.lib.jfluid.results.locks.AbstractLockDataFrameProcessor;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryProfilingResultsListener;

public class MemoryDataFrameProcessor
extends AbstractLockDataFrameProcessor {
    @Override
    public void doProcessDataFrame(ByteBuffer buffer) {
        int n = -1;
        block12: while (buffer.hasRemaining()) {
            byte eventType = buffer.get();
            switch (eventType) {
                case 12: {
                    char classId = buffer.getChar();
                    long objSize = MemoryDataFrameProcessor.getObjSize(buffer);
                    int depth = MemoryDataFrameProcessor.getDepth(buffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Allocation stack trace: classId=" + classId + ", objSize=" + objSize + ", depth=" + depth);
                    }
                    int[] methodIds = new int[depth];
                    for (int i = 0; i < depth; ++i) {
                        methodIds[i] = buffer.getInt();
                    }
                    this.fireAllocStackTrace(classId, objSize, methodIds);
                    continue block12;
                }
                case 14: {
                    char c;
                    char classId = buffer.getChar();
                    char objEpoch = buffer.getChar();
                    if (objEpoch > c) {
                        c = objEpoch;
                    }
                    long objectId = ((long)classId & 0xFFFFL) << 48 | ((long)objEpoch & 0xFFFFL) << 32 | (long)buffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
                    long objSize = MemoryDataFrameProcessor.getObjSize(buffer);
                    int depth = MemoryDataFrameProcessor.getDepth(buffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Liveness stack trace: classId=" + classId + ", objectId=" + objectId + ", objEpoch=" + objEpoch + ", objSize=" + objSize + ", depth=" + depth);
                    }
                    int[] methodIds = new int[depth];
                    for (int i = 0; i < depth; ++i) {
                        methodIds[i] = buffer.getInt();
                    }
                    this.fireLivenessStackTrace(classId, objectId, objEpoch, objSize, methodIds);
                    continue block12;
                }
                case 15: {
                    char c;
                    char classId = buffer.getChar();
                    char objEpoch = buffer.getChar();
                    if (objEpoch > c) {
                        c = objEpoch;
                    }
                    long objectId = ((long)classId & 0xFFFFL) << 48 | ((long)objEpoch & 0xFFFFL) << 32 | (long)buffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("GC Performed: classId=" + classId + ", objectId=" + objectId + ", objEpoch=" + objEpoch);
                    }
                    this.fireGCPerformed(classId, objectId, objEpoch);
                    continue block12;
                }
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    continue block12;
                }
                case 29: {
                    char id = buffer.getChar();
                    long timeStamp = MemoryDataFrameProcessor.getTimeStamp(buffer);
                    char threadId = buffer.getChar();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profile Point Hit " + id + ", threadId=" + id + ", timeStamp=" + timeStamp);
                    }
                    this.fireProfilingPoint(threadId, id, timeStamp);
                    continue block12;
                }
                case 13: {
                    this.currentThreadId = buffer.getChar();
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block12;
                    LOGGER.log(Level.FINEST, "Change current thread , tId={0}", this.currentThreadId);
                    continue block12;
                }
                case 11: {
                    char threadId = buffer.getChar();
                    String threadName = MemoryDataFrameProcessor.getString(buffer);
                    String threadClassName = MemoryDataFrameProcessor.getString(buffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new thread , tId={0}", threadId);
                    }
                    this.fireNewThread(threadId, threadName, threadClassName);
                    this.currentThreadId = threadId;
                    continue block12;
                }
                case 28: {
                    int hash = buffer.getInt();
                    String className = MemoryDataFrameProcessor.getString(buffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new monitor , monitorId={0} , className={1}", new Object[]{Integer.toHexString(hash), className});
                    }
                    this.fireNewMonitor(hash, className);
                    continue block12;
                }
                case 22: 
                case 23: {
                    long timeStamp0 = MemoryDataFrameProcessor.getTimeStamp(buffer);
                    long timeStamp1 = -1L;
                    int hash = buffer.getInt();
                    if (eventType == 22) {
                        int ownerThreadId = buffer.getInt();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Monitor entry , tId={0} , monitorId={1} , ownerId={2}", new Object[]{this.currentThreadId, Integer.toHexString(hash), ownerThreadId});
                        }
                        this.fireMonitorEntry(this.currentThreadId, timeStamp0, timeStamp1, hash, ownerThreadId);
                    }
                    if (eventType != 23) continue block12;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Monitor exit , tId={0} , monitorId={1}", new Object[]{this.currentThreadId, Integer.toHexString(hash)});
                    }
                    this.fireMonitorExit(this.currentThreadId, timeStamp0, timeStamp1, hash);
                    continue block12;
                }
                case 5: {
                    long timeStamp1;
                    long timeStamp0 = MemoryDataFrameProcessor.getTimeStamp(buffer);
                    long l = timeStamp1 = this.collectingTwoTimeStamps ? MemoryDataFrameProcessor.getTimeStamp(buffer) : 0L;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Adjust time , tId={0}", this.currentThreadId);
                    }
                    this.fireAdjustTime(this.currentThreadId, timeStamp0, timeStamp1);
                    continue block12;
                }
            }
            LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in MemoryDataFrameProcessor: " + eventType + " at " + buffer.position());
        }
    }

    private void fireAllocStackTrace(final char classId, final long objSize, final int[] methodIds) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                try {
                    ((MemoryProfilingResultsListener)listener).onAllocStackTrace(classId, objSize, methodIds);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fireGCPerformed(final char classId, final long objectId, final int objEpoch) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((MemoryProfilingResultsListener)listener).onGcPerformed(classId, objectId, objEpoch);
            }
        });
    }

    private void fireLivenessStackTrace(final char classId, final long objectId, final int objEpoch, final long objSize, final int[] methodIds) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((MemoryProfilingResultsListener)listener).onLivenessStackTrace(classId, objectId, objEpoch, objSize, methodIds);
            }
        });
    }

    private static long getObjSize(ByteBuffer buffer) {
        long objSize = ((long)buffer.get() & 0xFFL) << 32 | ((long)buffer.get() & 0xFFL) << 24 | ((long)buffer.get() & 0xFFL) << 16 | ((long)buffer.get() & 0xFFL) << 8 | (long)buffer.get() & 0xFFL;
        return objSize;
    }

    private static int getDepth(ByteBuffer buffer) {
        int depth = (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
        return depth;
    }
}

