/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.users.GenericGroup;
import org.apache.catalina.users.GenericRole;
import org.apache.catalina.users.GenericUser;
import org.apache.catalina.users.SparseUserDatabase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class DataSourceUserDatabase
extends SparseUserDatabase {
    private static final Log log = LogFactory.getLog(DataSourceUserDatabase.class);
    private static final StringManager sm = StringManager.getManager(DataSourceUserDatabase.class);
    protected final DataSource dataSource;
    protected final String id;
    protected final ConcurrentHashMap<String, User> createdUsers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, User> modifiedUsers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, User> removedUsers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Group> createdGroups = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Group> modifiedGroups = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Group> removedGroups = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Role> createdRoles = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Role> modifiedRoles = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Role> removedRoles = new ConcurrentHashMap();
    private String preparedAllUsers = null;
    private String preparedAllGroups = null;
    private String preparedAllRoles = null;
    private String preparedGroup = null;
    private String preparedRole = null;
    private String preparedUserRoles = null;
    private String preparedUser = null;
    private String preparedUserGroups = null;
    private String preparedGroupRoles = null;
    protected String dataSourceName = null;
    protected String roleNameCol = null;
    protected String roleAndGroupDescriptionCol = null;
    protected String groupNameCol = null;
    protected String userCredCol = null;
    protected String userFullNameCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userGroupTable = null;
    protected String groupRoleTable = null;
    protected String userTable = null;
    protected String groupTable = null;
    protected String roleTable = null;
    private volatile boolean connectionSuccess = true;
    protected boolean readonly = true;
    private final ReentrantReadWriteLock dbLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.dbLock.readLock();
    private final Lock writeLock = this.dbLock.writeLock();

    public DataSourceUserDatabase(DataSource dataSource, String string) {
        this.dataSource = dataSource;
        this.id = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String string) {
        this.roleNameCol = string;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String string) {
        this.userCredCol = string;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String string) {
        this.userNameCol = string;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String string) {
        this.userRoleTable = string;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String string) {
        this.userTable = string;
    }

    public String getRoleAndGroupDescriptionCol() {
        return this.roleAndGroupDescriptionCol;
    }

    public void setRoleAndGroupDescriptionCol(String string) {
        this.roleAndGroupDescriptionCol = string;
    }

    public String getGroupNameCol() {
        return this.groupNameCol;
    }

    public void setGroupNameCol(String string) {
        this.groupNameCol = string;
    }

    public String getUserFullNameCol() {
        return this.userFullNameCol;
    }

    public void setUserFullNameCol(String string) {
        this.userFullNameCol = string;
    }

    public String getUserGroupTable() {
        return this.userGroupTable;
    }

    public void setUserGroupTable(String string) {
        this.userGroupTable = string;
    }

    public String getGroupRoleTable() {
        return this.groupRoleTable;
    }

    public void setGroupRoleTable(String string) {
        this.groupRoleTable = string;
    }

    public String getGroupTable() {
        return this.groupTable;
    }

    public void setGroupTable(String string) {
        this.groupTable = string;
    }

    public String getRoleTable() {
        return this.roleTable;
    }

    public void setRoleTable(String string) {
        this.roleTable = string;
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Group> getGroups() {
        this.readLock.lock();
        try {
            Object object;
            HashMap<String, Group> hashMap = new HashMap<String, Group>();
            hashMap.putAll(this.createdGroups);
            hashMap.putAll(this.modifiedGroups);
            Connection connection = this.openConnection();
            if (connection != null && this.preparedAllGroups != null) {
                try {
                    object = connection.prepareStatement(this.preparedAllGroups);
                    Throwable throwable = null;
                    try (ResultSet resultSet = object.executeQuery();){
                        while (resultSet.next()) {
                            Group group;
                            String string = resultSet.getString(1);
                            if (string == null || hashMap.containsKey(string) || this.removedGroups.containsKey(string) || (group = this.findGroupInternal(connection, string)) == null) continue;
                            hashMap.put(string, group);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                }
                finally {
                    this.closeConnection(connection);
                }
            }
            object = hashMap.values().iterator();
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Role> getRoles() {
        this.readLock.lock();
        try {
            Object object;
            HashMap<String, Role> hashMap = new HashMap<String, Role>();
            hashMap.putAll(this.createdRoles);
            hashMap.putAll(this.modifiedRoles);
            Connection connection = this.openConnection();
            if (connection != null && this.preparedAllRoles != null) {
                try {
                    object = connection.prepareStatement(this.preparedAllRoles);
                    Throwable throwable = null;
                    try (ResultSet resultSet = object.executeQuery();){
                        while (resultSet.next()) {
                            Role role;
                            String string = resultSet.getString(1);
                            if (string == null || hashMap.containsKey(string) || this.removedRoles.containsKey(string) || (role = this.findRoleInternal(connection, string)) == null) continue;
                            hashMap.put(string, role);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                }
                finally {
                    this.closeConnection(connection);
                }
            }
            object = hashMap.values().iterator();
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<User> getUsers() {
        this.readLock.lock();
        try {
            Object object;
            HashMap<String, User> hashMap = new HashMap<String, User>();
            hashMap.putAll(this.createdUsers);
            hashMap.putAll(this.modifiedUsers);
            Connection connection = this.openConnection();
            if (connection != null) {
                try {
                    object = connection.prepareStatement(this.preparedAllUsers);
                    Throwable throwable = null;
                    try (ResultSet resultSet = object.executeQuery();){
                        while (resultSet.next()) {
                            User user;
                            String string = resultSet.getString(1);
                            if (string == null || hashMap.containsKey(string) || this.removedUsers.containsKey(string) || (user = this.findUserInternal(connection, string)) == null) continue;
                            hashMap.put(string, user);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                }
                finally {
                    this.closeConnection(connection);
                }
            }
            object = hashMap.values().iterator();
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void close() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(String string, String string2) {
        this.readLock.lock();
        try {
            GenericGroup<DataSourceUserDatabase> genericGroup = new GenericGroup<DataSourceUserDatabase>(this, string, string2, null);
            this.createdGroups.put(string, genericGroup);
            this.modifiedGroups.remove(string);
            GenericGroup<DataSourceUserDatabase> genericGroup2 = genericGroup;
            return genericGroup2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role createRole(String string, String string2) {
        this.readLock.lock();
        try {
            GenericRole<DataSourceUserDatabase> genericRole = new GenericRole<DataSourceUserDatabase>(this, string, string2);
            this.createdRoles.put(string, genericRole);
            this.modifiedRoles.remove(string);
            GenericRole<DataSourceUserDatabase> genericRole2 = genericRole;
            return genericRole2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(String string, String string2, String string3) {
        this.readLock.lock();
        try {
            GenericUser<DataSourceUserDatabase> genericUser = new GenericUser<DataSourceUserDatabase>(this, string, string2, string3, null, null);
            this.createdUsers.put(string, genericUser);
            this.modifiedUsers.remove(string);
            GenericUser<DataSourceUserDatabase> genericUser2 = genericUser;
            return genericUser2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group findGroup(String string) {
        this.readLock.lock();
        try {
            Group group = this.createdGroups.get(string);
            if (group != null) {
                Group group2 = group;
                return group2;
            }
            group = this.modifiedGroups.get(string);
            if (group != null) {
                Group group3 = group;
                return group3;
            }
            group = this.removedGroups.get(string);
            if (group != null) {
                Group group4 = null;
                return group4;
            }
            if (this.isGroupStoreDefined()) {
                Connection connection = this.openConnection();
                if (connection == null) {
                    Group group5 = null;
                    return group5;
                }
                try {
                    Group group6 = this.findGroupInternal(connection, string);
                    return group6;
                }
                finally {
                    this.closeConnection(connection);
                }
            }
            Group group7 = null;
            return group7;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Group findGroupInternal(Connection connection, String string) {
        GenericGroup<DataSourceUserDatabase> genericGroup;
        block54: {
            genericGroup = null;
            try (PreparedStatement preparedStatement = connection.prepareStatement(this.preparedGroup);){
                preparedStatement.setString(1, string);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (!resultSet.next() || resultSet.getString(1) == null) break block54;
                    String string2 = this.roleAndGroupDescriptionCol != null ? resultSet.getString(2) : null;
                    ArrayList<Role> arrayList = new ArrayList<Role>();
                    if (string != null) {
                        string = string.trim();
                        try (PreparedStatement preparedStatement2 = connection.prepareStatement(this.preparedGroupRoles);){
                            preparedStatement2.setString(1, string);
                            try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                                while (resultSet2.next()) {
                                    Role role;
                                    String string3 = resultSet2.getString(1);
                                    if (string3 == null || (role = this.findRoleInternal(connection, string3)) == null) continue;
                                    arrayList.add(role);
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                        }
                    }
                    genericGroup = new GenericGroup<DataSourceUserDatabase>(this, string, string2, arrayList);
                }
            }
            catch (SQLException sQLException) {
                log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
            }
        }
        return genericGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role findRole(String string) {
        this.readLock.lock();
        try {
            Role role = this.createdRoles.get(string);
            if (role != null) {
                Role role2 = role;
                return role2;
            }
            role = this.modifiedRoles.get(string);
            if (role != null) {
                Role role3 = role;
                return role3;
            }
            role = this.removedRoles.get(string);
            if (role != null) {
                Role role4 = null;
                return role4;
            }
            if (this.userRoleTable != null && this.roleNameCol != null) {
                Connection connection = this.openConnection();
                if (connection == null) {
                    Role role5 = null;
                    return role5;
                }
                try {
                    Role role6 = this.findRoleInternal(connection, string);
                    return role6;
                }
                finally {
                    this.closeConnection(connection);
                }
            }
            Role role7 = null;
            return role7;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Role findRoleInternal(Connection connection, String string) {
        GenericRole<DataSourceUserDatabase> genericRole = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.preparedRole);){
            preparedStatement.setString(1, string);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next() && resultSet.getString(1) != null) {
                    String string2 = this.roleAndGroupDescriptionCol != null ? resultSet.getString(2) : null;
                    genericRole = new GenericRole<DataSourceUserDatabase>(this, string, string2);
                }
            }
        }
        catch (SQLException sQLException) {
            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
        }
        return genericRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User findUser(String string) {
        this.readLock.lock();
        try {
            User user = this.createdUsers.get(string);
            if (user != null) {
                User user2 = user;
                return user2;
            }
            user = this.modifiedUsers.get(string);
            if (user != null) {
                User user3 = user;
                return user3;
            }
            user = this.removedUsers.get(string);
            if (user != null) {
                User user4 = null;
                return user4;
            }
            Connection connection = this.openConnection();
            if (connection == null) {
                User user5 = null;
                return user5;
            }
            try {
                User user6 = this.findUserInternal(connection, string);
                this.closeConnection(connection);
                return user6;
            }
            catch (Throwable throwable) {
                this.closeConnection(connection);
                throw throwable;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public User findUserInternal(Connection connection, String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        GenericUser<DataSourceUserDatabase> genericUser;
        Object object5;
        Object object6;
        String string2 = null;
        String string3 = null;
        try {
            object6 = connection.prepareStatement(this.preparedUser);
            object5 = null;
            try {
                object6.setString(1, string);
                genericUser = object6.executeQuery();
                object4 = null;
                try {
                    if (genericUser.next()) {
                        string2 = genericUser.getString(1);
                        if (this.userFullNameCol != null) {
                            string3 = genericUser.getString(2);
                        }
                    }
                    string2 = string2 != null ? string2.trim() : null;
                }
                catch (Throwable throwable) {
                    object4 = throwable;
                    throw throwable;
                }
                finally {
                    if (genericUser != null) {
                        if (object4 != null) {
                            try {
                                genericUser.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object4).addSuppressed(throwable);
                            }
                        } else {
                            genericUser.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object5 = throwable;
                throw throwable;
            }
            finally {
                if (object6 != null) {
                    if (object5 != null) {
                        try {
                            object6.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object5).addSuppressed(throwable);
                        }
                    } else {
                        object6.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
        }
        object6 = new ArrayList();
        if (this.isGroupStoreDefined()) {
            try {
                object5 = connection.prepareStatement(this.preparedUserGroups);
                genericUser = null;
                try {
                    object5.setString(1, string);
                    object4 = object5.executeQuery();
                    object3 = null;
                    try {
                        while (object4.next()) {
                            object2 = object4.getString(1);
                            if (object2 == null || (object = this.findGroupInternal(connection, (String)object2)) == null) continue;
                            ((ArrayList)object6).add(object);
                        }
                    }
                    catch (Throwable throwable) {
                        object3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object4 != null) {
                            if (object3 != null) {
                                try {
                                    object4.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object3).addSuppressed(throwable);
                                }
                            } else {
                                object4.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    genericUser = throwable;
                    throw throwable;
                }
                finally {
                    if (object5 != null) {
                        if (genericUser != null) {
                            try {
                                object5.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)genericUser)).addSuppressed(throwable);
                            }
                        } else {
                            object5.close();
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
            }
        }
        object5 = new ArrayList();
        if (this.userRoleTable != null && this.roleNameCol != null) {
            try {
                genericUser = connection.prepareStatement(this.preparedUserRoles);
                object4 = null;
                try {
                    genericUser.setString(1, string);
                    object3 = genericUser.executeQuery();
                    object2 = null;
                    try {
                        while (object3.next()) {
                            Role role;
                            object = object3.getString(1);
                            if (object == null || (role = this.findRoleInternal(connection, (String)object)) == null) continue;
                            ((ArrayList)object5).add(role);
                        }
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object3 != null) {
                            if (object2 != null) {
                                try {
                                    object3.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object2).addSuppressed(throwable);
                                }
                            } else {
                                object3.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    object4 = throwable;
                    throw throwable;
                }
                finally {
                    if (genericUser != null) {
                        if (object4 != null) {
                            try {
                                genericUser.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object4).addSuppressed(throwable);
                            }
                        } else {
                            genericUser.close();
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
            }
        }
        genericUser = new GenericUser<DataSourceUserDatabase>(this, string, string2, string3, (List<Group>)object6, (List<Role>)object5);
        return genericUser;
    }

    @Override
    public void modifiedGroup(Group group) {
        this.readLock.lock();
        try {
            String string = group.getName();
            if (!this.createdGroups.containsKey(string) && !this.removedGroups.containsKey(string)) {
                this.modifiedGroups.put(string, group);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void modifiedRole(Role role) {
        this.readLock.lock();
        try {
            String string = role.getName();
            if (!this.createdRoles.containsKey(string) && !this.removedRoles.containsKey(string)) {
                this.modifiedRoles.put(string, role);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void modifiedUser(User user) {
        this.readLock.lock();
        try {
            String string = user.getName();
            if (!this.createdUsers.containsKey(string) && !this.removedUsers.containsKey(string)) {
                this.modifiedUsers.put(string, user);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void open() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("DataSource UserDatabase features: User<->Role [" + Boolean.toString(this.userRoleTable != null && this.roleNameCol != null) + "], Roles [" + Boolean.toString(this.isRoleStoreDefined()) + "], Groups [" + Boolean.toString(this.isRoleStoreDefined()) + "]"));
        }
        this.writeLock.lock();
        try {
            StringBuilder stringBuilder = new StringBuilder("SELECT ");
            stringBuilder.append(this.userCredCol);
            if (this.userFullNameCol != null) {
                stringBuilder.append(",").append(this.userFullNameCol);
            }
            stringBuilder.append(" FROM ");
            stringBuilder.append(this.userTable);
            stringBuilder.append(" WHERE ");
            stringBuilder.append(this.userNameCol);
            stringBuilder.append(" = ?");
            this.preparedUser = stringBuilder.toString();
            stringBuilder = new StringBuilder("SELECT ");
            stringBuilder.append(this.userNameCol);
            stringBuilder.append(" FROM ");
            stringBuilder.append(this.userTable);
            this.preparedAllUsers = stringBuilder.toString();
            stringBuilder = new StringBuilder("SELECT ");
            stringBuilder.append(this.roleNameCol);
            stringBuilder.append(" FROM ");
            stringBuilder.append(this.userRoleTable);
            stringBuilder.append(" WHERE ");
            stringBuilder.append(this.userNameCol);
            stringBuilder.append(" = ?");
            this.preparedUserRoles = stringBuilder.toString();
            if (this.isGroupStoreDefined()) {
                stringBuilder = new StringBuilder("SELECT ");
                stringBuilder.append(this.groupNameCol);
                stringBuilder.append(" FROM ");
                stringBuilder.append(this.userGroupTable);
                stringBuilder.append(" WHERE ");
                stringBuilder.append(this.userNameCol);
                stringBuilder.append(" = ?");
                this.preparedUserGroups = stringBuilder.toString();
                stringBuilder = new StringBuilder("SELECT ");
                stringBuilder.append(this.roleNameCol);
                stringBuilder.append(" FROM ");
                stringBuilder.append(this.groupRoleTable);
                stringBuilder.append(" WHERE ");
                stringBuilder.append(this.groupNameCol);
                stringBuilder.append(" = ?");
                this.preparedGroupRoles = stringBuilder.toString();
                stringBuilder = new StringBuilder("SELECT ");
                stringBuilder.append(this.groupNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    stringBuilder.append(",").append(this.roleAndGroupDescriptionCol);
                }
                stringBuilder.append(" FROM ");
                stringBuilder.append(this.groupTable);
                stringBuilder.append(" WHERE ");
                stringBuilder.append(this.groupNameCol);
                stringBuilder.append(" = ?");
                this.preparedGroup = stringBuilder.toString();
                stringBuilder = new StringBuilder("SELECT ");
                stringBuilder.append(this.groupNameCol);
                stringBuilder.append(" FROM ");
                stringBuilder.append(this.groupTable);
                this.preparedAllGroups = stringBuilder.toString();
            }
            if (this.isRoleStoreDefined()) {
                stringBuilder = new StringBuilder("SELECT ");
                stringBuilder.append(this.roleNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    stringBuilder.append(",").append(this.roleAndGroupDescriptionCol);
                }
                stringBuilder.append(" FROM ");
                stringBuilder.append(this.roleTable);
                stringBuilder.append(" WHERE ");
                stringBuilder.append(this.roleNameCol);
                stringBuilder.append(" = ?");
                this.preparedRole = stringBuilder.toString();
                stringBuilder = new StringBuilder("SELECT ");
                stringBuilder.append(this.roleNameCol);
                stringBuilder.append(" FROM ");
                stringBuilder.append(this.roleTable);
                this.preparedAllRoles = stringBuilder.toString();
            } else if (this.userRoleTable != null && this.roleNameCol != null) {
                stringBuilder = new StringBuilder("SELECT ");
                stringBuilder.append(this.roleNameCol);
                stringBuilder.append(" FROM ");
                stringBuilder.append(this.userRoleTable);
                stringBuilder.append(" WHERE ");
                stringBuilder.append(this.roleNameCol);
                stringBuilder.append(" = ?");
                this.preparedRole = stringBuilder.toString();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeGroup(Group group) {
        this.readLock.lock();
        try {
            String string = group.getName();
            this.createdGroups.remove(string);
            this.modifiedGroups.remove(string);
            this.removedGroups.put(string, group);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void removeRole(Role role) {
        this.readLock.lock();
        try {
            String string = role.getName();
            this.createdRoles.remove(string);
            this.modifiedRoles.remove(string);
            this.removedRoles.put(string, role);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void removeUser(User user) {
        this.readLock.lock();
        try {
            String string = user.getName();
            this.createdUsers.remove(string);
            this.modifiedUsers.remove(string);
            this.removedUsers.put(string, user);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void save() throws Exception {
        if (this.readonly) {
            return;
        }
        Connection connection = this.openConnection();
        if (connection == null) {
            return;
        }
        this.writeLock.lock();
        try {
            try {
                this.saveInternal(connection);
            }
            finally {
                this.closeConnection(connection);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void saveInternal(Connection connection) {
        void var7_39;
        Throwable throwable;
        PreparedStatement preparedStatement;
        void var8_66;
        void var6_17;
        Object object;
        Object object2;
        Iterator<Role> iterator4;
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        StringBuilder stringBuilder3 = null;
        if (this.isRoleStoreDefined()) {
            if (!this.removedRoles.isEmpty()) {
                stringBuilder = new StringBuilder("DELETE FROM ");
                stringBuilder.append(this.roleTable);
                stringBuilder.append(" WHERE ").append(this.roleNameCol);
                stringBuilder.append(" = ?");
                if (this.groupRoleTable != null) {
                    stringBuilder3 = new StringBuilder("DELETE FROM ");
                    stringBuilder3.append(this.groupRoleTable);
                    stringBuilder3.append(" WHERE ");
                    stringBuilder3.append(this.roleNameCol);
                    stringBuilder3.append(" = ?");
                }
                iterator4 = new StringBuilder("DELETE FROM ");
                ((StringBuilder)((Object)iterator4)).append(this.userRoleTable);
                ((StringBuilder)((Object)iterator4)).append(" WHERE ");
                ((StringBuilder)((Object)iterator4)).append(this.roleNameCol);
                ((StringBuilder)((Object)iterator4)).append(" = ?");
                for (Role role : this.removedRoles.values()) {
                    if (stringBuilder3 != null) {
                        try {
                            Throwable throwable2 = null;
                            try (PreparedStatement preparedStatement2 = connection.prepareStatement(stringBuilder3.toString());){
                                preparedStatement2.setString(1, role.getRolename());
                                preparedStatement2.executeUpdate();
                            }
                            catch (Throwable throwable3) {
                                Throwable throwable4 = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (SQLException sQLException) {
                            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                        }
                    }
                    try {
                        Throwable throwable5 = null;
                        try (PreparedStatement preparedStatement3 = connection.prepareStatement(((StringBuilder)((Object)iterator4)).toString());){
                            preparedStatement3.setString(1, role.getRolename());
                            preparedStatement3.executeUpdate();
                        }
                        catch (Throwable throwable6) {
                            Throwable throwable7 = throwable6;
                            throw throwable6;
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                    try {
                        PreparedStatement preparedStatement4 = connection.prepareStatement(stringBuilder.toString());
                        Throwable throwable8 = null;
                        try {
                            preparedStatement4.setString(1, role.getRolename());
                            preparedStatement4.executeUpdate();
                        }
                        catch (Throwable throwable9) {
                            Throwable throwable10 = throwable9;
                            throw throwable9;
                        }
                        finally {
                            if (preparedStatement4 == null) continue;
                            if (throwable8 != null) {
                                try {
                                    preparedStatement4.close();
                                }
                                catch (Throwable throwable11) {
                                    throwable8.addSuppressed(throwable11);
                                }
                                continue;
                            }
                            preparedStatement4.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                }
                this.removedRoles.clear();
            }
            if (!this.createdRoles.isEmpty()) {
                stringBuilder = new StringBuilder("INSERT INTO ");
                stringBuilder.append(this.roleTable);
                stringBuilder.append('(').append(this.roleNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    stringBuilder.append(',').append(this.roleAndGroupDescriptionCol);
                }
                stringBuilder.append(") VALUES (?");
                if (this.roleAndGroupDescriptionCol != null) {
                    stringBuilder.append(", ?");
                }
                stringBuilder.append(')');
                for (Role role : this.createdRoles.values()) {
                    try {
                        PreparedStatement preparedStatement5 = connection.prepareStatement(stringBuilder.toString());
                        Throwable throwable12 = null;
                        try {
                            preparedStatement5.setString(1, role.getRolename());
                            if (this.roleAndGroupDescriptionCol != null) {
                                preparedStatement5.setString(2, role.getDescription());
                            }
                            preparedStatement5.executeUpdate();
                        }
                        catch (Throwable throwable13) {
                            Throwable throwable14 = throwable13;
                            throw throwable13;
                        }
                        finally {
                            if (preparedStatement5 == null) continue;
                            if (throwable12 != null) {
                                try {
                                    preparedStatement5.close();
                                }
                                catch (Throwable throwable15) {
                                    throwable12.addSuppressed(throwable15);
                                }
                                continue;
                            }
                            preparedStatement5.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                }
                this.createdRoles.clear();
            }
            if (!this.modifiedRoles.isEmpty() && this.roleAndGroupDescriptionCol != null) {
                stringBuilder = new StringBuilder("UPDATE ");
                stringBuilder.append(this.roleTable);
                stringBuilder.append(" SET ").append(this.roleAndGroupDescriptionCol);
                stringBuilder.append(" = ? WHERE ").append(this.roleNameCol);
                stringBuilder.append(" = ?");
                for (Role role : this.modifiedRoles.values()) {
                    try {
                        PreparedStatement preparedStatement6 = connection.prepareStatement(stringBuilder.toString());
                        Throwable throwable16 = null;
                        try {
                            preparedStatement6.setString(1, role.getDescription());
                            preparedStatement6.setString(2, role.getRolename());
                            preparedStatement6.executeUpdate();
                        }
                        catch (Throwable throwable17) {
                            Throwable throwable18 = throwable17;
                            throw throwable17;
                        }
                        finally {
                            if (preparedStatement6 == null) continue;
                            if (throwable16 != null) {
                                try {
                                    preparedStatement6.close();
                                }
                                catch (Throwable throwable19) {
                                    throwable16.addSuppressed(throwable19);
                                }
                                continue;
                            }
                            preparedStatement6.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                }
                this.modifiedRoles.clear();
            }
        } else if (this.userRoleTable != null && this.roleNameCol != null) {
            stringBuilder3 = new StringBuilder("DELETE FROM ");
            stringBuilder3.append(this.userRoleTable);
            stringBuilder3.append(" WHERE ");
            stringBuilder3.append(this.roleNameCol);
            stringBuilder3.append(" = ?");
            for (Role role : this.removedRoles.values()) {
                try {
                    PreparedStatement preparedStatement7 = connection.prepareStatement(stringBuilder3.toString());
                    Throwable throwable20 = null;
                    try {
                        preparedStatement7.setString(1, role.getRolename());
                        preparedStatement7.executeUpdate();
                    }
                    catch (Throwable throwable21) {
                        Throwable throwable22 = throwable21;
                        throw throwable21;
                    }
                    finally {
                        if (preparedStatement7 == null) continue;
                        if (throwable20 != null) {
                            try {
                                preparedStatement7.close();
                            }
                            catch (Throwable throwable23) {
                                throwable20.addSuppressed(throwable23);
                            }
                            continue;
                        }
                        preparedStatement7.close();
                    }
                }
                catch (SQLException sQLException) {
                    log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                }
            }
            this.removedRoles.clear();
        }
        if (this.isGroupStoreDefined()) {
            stringBuilder2 = new StringBuilder("INSERT INTO ");
            stringBuilder2.append(this.groupRoleTable);
            stringBuilder2.append('(').append(this.groupNameCol).append(", ");
            stringBuilder2.append(this.roleNameCol);
            stringBuilder2.append(") VALUES (?, ?)");
            iterator4 = stringBuilder2.toString();
            stringBuilder3 = new StringBuilder("DELETE FROM ");
            stringBuilder3.append(this.groupRoleTable);
            stringBuilder3.append(" WHERE ");
            stringBuilder3.append(this.groupNameCol);
            stringBuilder3.append(" = ?");
            String string = stringBuilder3.toString();
            if (!this.removedGroups.isEmpty()) {
                stringBuilder = new StringBuilder("DELETE FROM ");
                stringBuilder.append(this.groupTable);
                stringBuilder.append(" WHERE ").append(this.groupNameCol);
                stringBuilder.append(" = ?");
                StringBuilder stringBuilder4 = new StringBuilder("DELETE FROM ");
                stringBuilder4.append(this.userGroupTable);
                stringBuilder4.append(" WHERE ");
                stringBuilder4.append(this.groupNameCol);
                stringBuilder4.append(" = ?");
                for (Group group : this.removedGroups.values()) {
                    try {
                        PreparedStatement preparedStatement8 = connection.prepareStatement(string);
                        object2 = null;
                        try {
                            preparedStatement8.setString(1, group.getGroupname());
                            preparedStatement8.executeUpdate();
                        }
                        catch (Throwable throwable24) {
                            object2 = throwable24;
                            throw throwable24;
                        }
                        finally {
                            if (preparedStatement8 != null) {
                                if (object2 != null) {
                                    try {
                                        preparedStatement8.close();
                                    }
                                    catch (Throwable throwable25) {
                                        ((Throwable)object2).addSuppressed(throwable25);
                                    }
                                } else {
                                    preparedStatement8.close();
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                    try {
                        PreparedStatement preparedStatement9 = connection.prepareStatement(stringBuilder4.toString());
                        object2 = null;
                        try {
                            preparedStatement9.setString(1, group.getGroupname());
                            preparedStatement9.executeUpdate();
                        }
                        catch (Throwable throwable26) {
                            object2 = throwable26;
                            throw throwable26;
                        }
                        finally {
                            if (preparedStatement9 != null) {
                                if (object2 != null) {
                                    try {
                                        preparedStatement9.close();
                                    }
                                    catch (Throwable throwable27) {
                                        ((Throwable)object2).addSuppressed(throwable27);
                                    }
                                } else {
                                    preparedStatement9.close();
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                    try {
                        PreparedStatement preparedStatement10 = connection.prepareStatement(stringBuilder.toString());
                        object2 = null;
                        try {
                            preparedStatement10.setString(1, group.getGroupname());
                            preparedStatement10.executeUpdate();
                        }
                        catch (Throwable throwable28) {
                            object2 = throwable28;
                            throw throwable28;
                        }
                        finally {
                            if (preparedStatement10 == null) continue;
                            if (object2 != null) {
                                try {
                                    preparedStatement10.close();
                                }
                                catch (Throwable throwable29) {
                                    ((Throwable)object2).addSuppressed(throwable29);
                                }
                                continue;
                            }
                            preparedStatement10.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                }
                this.removedGroups.clear();
            }
            if (!this.createdGroups.isEmpty()) {
                stringBuilder = new StringBuilder("INSERT INTO ");
                stringBuilder.append(this.groupTable);
                stringBuilder.append('(').append(this.groupNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    stringBuilder.append(',').append(this.roleAndGroupDescriptionCol);
                }
                stringBuilder.append(") VALUES (?");
                if (this.roleAndGroupDescriptionCol != null) {
                    stringBuilder.append(", ?");
                }
                stringBuilder.append(')');
                for (Group group : this.createdGroups.values()) {
                    try {
                        Throwable throwable30 = null;
                        try (PreparedStatement preparedStatement11 = connection.prepareStatement(stringBuilder.toString());){
                            preparedStatement11.setString(1, group.getGroupname());
                            if (this.roleAndGroupDescriptionCol != null) {
                                preparedStatement11.setString(2, group.getDescription());
                            }
                            preparedStatement11.executeUpdate();
                        }
                        catch (Throwable throwable31) {
                            Throwable throwable32 = throwable31;
                            throw throwable31;
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                    Iterator<Role> iterator = group.getRoles();
                    while (iterator.hasNext()) {
                        Role role = iterator.next();
                        try {
                            object2 = connection.prepareStatement((String)((Object)iterator4));
                            object = null;
                            try {
                                object2.setString(1, group.getGroupname());
                                object2.setString(2, role.getRolename());
                                object2.executeUpdate();
                            }
                            catch (Throwable throwable33) {
                                object = throwable33;
                                throw throwable33;
                            }
                            finally {
                                if (object2 == null) continue;
                                if (object != null) {
                                    try {
                                        object2.close();
                                    }
                                    catch (Throwable throwable34) {
                                        ((Throwable)object).addSuppressed(throwable34);
                                    }
                                    continue;
                                }
                                object2.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                        }
                    }
                }
                this.createdGroups.clear();
            }
            if (!this.modifiedGroups.isEmpty()) {
                if (this.roleAndGroupDescriptionCol != null) {
                    stringBuilder = new StringBuilder("UPDATE ");
                    stringBuilder.append(this.groupTable);
                    stringBuilder.append(" SET ").append(this.roleAndGroupDescriptionCol);
                    stringBuilder.append(" = ? WHERE ").append(this.groupNameCol);
                    stringBuilder.append(" = ?");
                }
                for (Group group : this.modifiedGroups.values()) {
                    if (stringBuilder != null) {
                        try {
                            Throwable throwable35 = null;
                            try (PreparedStatement preparedStatement12 = connection.prepareStatement(stringBuilder.toString());){
                                preparedStatement12.setString(1, group.getDescription());
                                preparedStatement12.setString(2, group.getGroupname());
                                preparedStatement12.executeUpdate();
                            }
                            catch (Throwable throwable36) {
                                Throwable throwable37 = throwable36;
                                throw throwable36;
                            }
                        }
                        catch (SQLException sQLException) {
                            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                        }
                    }
                    try {
                        Throwable throwable38 = null;
                        try (PreparedStatement preparedStatement13 = connection.prepareStatement(string);){
                            preparedStatement13.setString(1, group.getGroupname());
                            preparedStatement13.executeUpdate();
                        }
                        catch (Throwable throwable39) {
                            Throwable throwable40 = throwable39;
                            throw throwable39;
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                    Iterator<Role> iterator = group.getRoles();
                    while (iterator.hasNext()) {
                        Role role = iterator.next();
                        try {
                            object2 = connection.prepareStatement((String)((Object)iterator4));
                            object = null;
                            try {
                                object2.setString(1, group.getGroupname());
                                object2.setString(2, role.getRolename());
                                object2.executeUpdate();
                            }
                            catch (Throwable throwable41) {
                                object = throwable41;
                                throw throwable41;
                            }
                            finally {
                                if (object2 == null) continue;
                                if (object != null) {
                                    try {
                                        object2.close();
                                    }
                                    catch (Throwable throwable42) {
                                        ((Throwable)object).addSuppressed(throwable42);
                                    }
                                    continue;
                                }
                                object2.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                        }
                    }
                }
                this.modifiedGroups.clear();
            }
        }
        iterator4 = null;
        Object var6_15 = null;
        if (this.userRoleTable != null && this.roleNameCol != null) {
            stringBuilder2 = new StringBuilder("INSERT INTO ");
            stringBuilder2.append(this.userRoleTable);
            stringBuilder2.append('(').append(this.userNameCol).append(", ");
            stringBuilder2.append(this.roleNameCol);
            stringBuilder2.append(") VALUES (?, ?)");
            iterator4 = stringBuilder2.toString();
            stringBuilder3 = new StringBuilder("DELETE FROM ");
            stringBuilder3.append(this.userRoleTable);
            stringBuilder3.append(" WHERE ");
            stringBuilder3.append(this.userNameCol);
            stringBuilder3.append(" = ?");
            String string = stringBuilder3.toString();
        }
        Object var7_37 = null;
        Object var8_64 = null;
        if (this.isGroupStoreDefined()) {
            stringBuilder2 = new StringBuilder("INSERT INTO ");
            stringBuilder2.append(this.userGroupTable);
            stringBuilder2.append('(').append(this.userNameCol).append(", ");
            stringBuilder2.append(this.groupNameCol);
            stringBuilder2.append(") VALUES (?, ?)");
            String string = stringBuilder2.toString();
            stringBuilder3 = new StringBuilder("DELETE FROM ");
            stringBuilder3.append(this.userGroupTable);
            stringBuilder3.append(" WHERE ");
            stringBuilder3.append(this.userNameCol);
            stringBuilder3.append(" = ?");
            String string2 = stringBuilder3.toString();
        }
        if (!this.removedUsers.isEmpty()) {
            stringBuilder = new StringBuilder("DELETE FROM ");
            stringBuilder.append(this.userTable);
            stringBuilder.append(" WHERE ").append(this.userNameCol);
            stringBuilder.append(" = ?");
            for (User user : this.removedUsers.values()) {
                if (var6_17 != null) {
                    try {
                        object2 = connection.prepareStatement((String)var6_17);
                        object = null;
                        try {
                            object2.setString(1, user.getUsername());
                            object2.executeUpdate();
                        }
                        catch (Throwable throwable43) {
                            object = throwable43;
                            throw throwable43;
                        }
                        finally {
                            if (object2 != null) {
                                if (object != null) {
                                    try {
                                        object2.close();
                                    }
                                    catch (Throwable throwable44) {
                                        ((Throwable)object).addSuppressed(throwable44);
                                    }
                                } else {
                                    object2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                }
                if (var8_66 != null) {
                    try {
                        object2 = connection.prepareStatement((String)var8_66);
                        object = null;
                        try {
                            object2.setString(1, user.getUsername());
                            object2.executeUpdate();
                        }
                        catch (Throwable throwable45) {
                            object = throwable45;
                            throw throwable45;
                        }
                        finally {
                            if (object2 != null) {
                                if (object != null) {
                                    try {
                                        object2.close();
                                    }
                                    catch (Throwable throwable46) {
                                        ((Throwable)object).addSuppressed(throwable46);
                                    }
                                } else {
                                    object2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                }
                try {
                    object2 = connection.prepareStatement(stringBuilder.toString());
                    object = null;
                    try {
                        object2.setString(1, user.getUsername());
                        object2.executeUpdate();
                    }
                    catch (Throwable throwable47) {
                        object = throwable47;
                        throw throwable47;
                    }
                    finally {
                        if (object2 == null) continue;
                        if (object != null) {
                            try {
                                object2.close();
                            }
                            catch (Throwable throwable48) {
                                ((Throwable)object).addSuppressed(throwable48);
                            }
                            continue;
                        }
                        object2.close();
                    }
                }
                catch (SQLException sQLException) {
                    log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                }
            }
            this.removedUsers.clear();
        }
        if (!this.createdUsers.isEmpty()) {
            stringBuilder = new StringBuilder("INSERT INTO ");
            stringBuilder.append(this.userTable);
            stringBuilder.append('(').append(this.userNameCol);
            stringBuilder.append(", ").append(this.userCredCol);
            if (this.userFullNameCol != null) {
                stringBuilder.append(',').append(this.userFullNameCol);
            }
            stringBuilder.append(") VALUES (?, ?");
            if (this.userFullNameCol != null) {
                stringBuilder.append(", ?");
            }
            stringBuilder.append(')');
            for (User user : this.createdUsers.values()) {
                try {
                    object2 = connection.prepareStatement(stringBuilder.toString());
                    object = null;
                    try {
                        object2.setString(1, user.getUsername());
                        object2.setString(2, user.getPassword());
                        if (this.userFullNameCol != null) {
                            object2.setString(3, user.getFullName());
                        }
                        object2.executeUpdate();
                    }
                    catch (Throwable throwable49) {
                        object = throwable49;
                        throw throwable49;
                    }
                    finally {
                        if (object2 != null) {
                            if (object != null) {
                                try {
                                    object2.close();
                                }
                                catch (Throwable throwable50) {
                                    ((Throwable)object).addSuppressed(throwable50);
                                }
                            } else {
                                object2.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                }
                if (iterator4 != null) {
                    object2 = user.getRoles();
                    while (object2.hasNext()) {
                        object = (Role)object2.next();
                        try {
                            preparedStatement = connection.prepareStatement((String)((Object)iterator4));
                            throwable = null;
                            try {
                                preparedStatement.setString(1, user.getUsername());
                                preparedStatement.setString(2, object.getRolename());
                                preparedStatement.executeUpdate();
                            }
                            catch (Throwable throwable51) {
                                throwable = throwable51;
                                throw throwable51;
                            }
                            finally {
                                if (preparedStatement == null) continue;
                                if (throwable != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable throwable52) {
                                        throwable.addSuppressed(throwable52);
                                    }
                                    continue;
                                }
                                preparedStatement.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                        }
                    }
                }
                if (var7_39 == null) continue;
                object2 = user.getGroups();
                while (object2.hasNext()) {
                    object = (Group)((Object)object2.next());
                    try {
                        preparedStatement = connection.prepareStatement((String)var7_39);
                        throwable = null;
                        try {
                            preparedStatement.setString(1, user.getUsername());
                            preparedStatement.setString(2, object.getGroupname());
                            preparedStatement.executeUpdate();
                        }
                        catch (Throwable throwable53) {
                            throwable = throwable53;
                            throw throwable53;
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            if (throwable != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable54) {
                                    throwable.addSuppressed(throwable54);
                                }
                                continue;
                            }
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                }
            }
            this.createdUsers.clear();
        }
        if (!this.modifiedUsers.isEmpty()) {
            stringBuilder = new StringBuilder("UPDATE ");
            stringBuilder.append(this.userTable);
            stringBuilder.append(" SET ").append(this.userCredCol);
            stringBuilder.append(" = ?");
            if (this.userFullNameCol != null) {
                stringBuilder.append(", ").append(this.userFullNameCol).append(" = ?");
            }
            stringBuilder.append(" WHERE ").append(this.userNameCol);
            stringBuilder.append(" = ?");
            for (User user : this.modifiedUsers.values()) {
                try {
                    object2 = connection.prepareStatement(stringBuilder.toString());
                    object = null;
                    try {
                        object2.setString(1, user.getPassword());
                        if (this.userFullNameCol != null) {
                            object2.setString(2, user.getFullName());
                            object2.setString(3, user.getUsername());
                        } else {
                            object2.setString(2, user.getUsername());
                        }
                        object2.executeUpdate();
                    }
                    catch (Throwable throwable55) {
                        object = throwable55;
                        throw throwable55;
                    }
                    finally {
                        if (object2 != null) {
                            if (object != null) {
                                try {
                                    object2.close();
                                }
                                catch (Throwable throwable56) {
                                    ((Throwable)object).addSuppressed(throwable56);
                                }
                            } else {
                                object2.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                }
                if (var6_17 != null) {
                    try {
                        object2 = connection.prepareStatement((String)var6_17);
                        object = null;
                        try {
                            object2.setString(1, user.getUsername());
                            object2.executeUpdate();
                        }
                        catch (Throwable throwable57) {
                            object = throwable57;
                            throw throwable57;
                        }
                        finally {
                            if (object2 != null) {
                                if (object != null) {
                                    try {
                                        object2.close();
                                    }
                                    catch (Throwable throwable58) {
                                        ((Throwable)object).addSuppressed(throwable58);
                                    }
                                } else {
                                    object2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                }
                if (var8_66 != null) {
                    try {
                        object2 = connection.prepareStatement((String)var8_66);
                        object = null;
                        try {
                            object2.setString(1, user.getUsername());
                            object2.executeUpdate();
                        }
                        catch (Throwable throwable59) {
                            object = throwable59;
                            throw throwable59;
                        }
                        finally {
                            if (object2 != null) {
                                if (object != null) {
                                    try {
                                        object2.close();
                                    }
                                    catch (Throwable throwable60) {
                                        ((Throwable)object).addSuppressed(throwable60);
                                    }
                                } else {
                                    object2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                }
                if (iterator4 != null) {
                    object2 = user.getRoles();
                    while (object2.hasNext()) {
                        object = (Role)object2.next();
                        try {
                            preparedStatement = connection.prepareStatement((String)((Object)iterator4));
                            throwable = null;
                            try {
                                preparedStatement.setString(1, user.getUsername());
                                preparedStatement.setString(2, object.getRolename());
                                preparedStatement.executeUpdate();
                            }
                            catch (Throwable throwable61) {
                                throwable = throwable61;
                                throw throwable61;
                            }
                            finally {
                                if (preparedStatement == null) continue;
                                if (throwable != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable throwable62) {
                                        throwable.addSuppressed(throwable62);
                                    }
                                    continue;
                                }
                                preparedStatement.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                        }
                    }
                }
                if (var7_39 == null) continue;
                object2 = user.getGroups();
                while (object2.hasNext()) {
                    object = (Group)object2.next();
                    try {
                        preparedStatement = connection.prepareStatement((String)var7_39);
                        throwable = null;
                        try {
                            preparedStatement.setString(1, user.getUsername());
                            preparedStatement.setString(2, object.getGroupname());
                            preparedStatement.executeUpdate();
                        }
                        catch (Throwable throwable63) {
                            throwable = throwable63;
                            throw throwable63;
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            if (throwable != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable64) {
                                    throwable.addSuppressed(throwable64);
                                }
                                continue;
                            }
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
                    }
                }
            }
            this.modifiedGroups.clear();
        }
    }

    @Override
    public boolean isAvailable() {
        return this.connectionSuccess;
    }

    protected boolean isGroupStoreDefined() {
        return this.groupTable != null && this.userGroupTable != null && this.groupNameCol != null && this.groupRoleTable != null && this.isRoleStoreDefined();
    }

    protected boolean isRoleStoreDefined() {
        return this.roleTable != null && this.userRoleTable != null && this.roleNameCol != null;
    }

    protected Connection openConnection() {
        if (this.dataSource == null) {
            return null;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            this.connectionSuccess = true;
            return connection;
        }
        catch (Exception exception) {
            this.connectionSuccess = false;
            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)exception);
            return null;
        }
    }

    protected void closeConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            log.error((Object)sm.getString("dataSourceUserDatabase.exception"), (Throwable)sQLException);
        }
    }
}

