/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.DoubleByteDecoder;
import sun.nio.cs.ext.DoubleByteEncoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;
import sun.nio.cs.ext.JIS_X_0208_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Encoder;

public class ISO2022_JP
extends Charset
implements HistoricallyNamedCharset {
    private static final int ASCII = 0;
    private static final int JISX0201_1976 = 1;
    private static final int JISX0208_1978 = 2;
    private static final int JISX0208_1983 = 3;
    private static final int JISX0212_1990 = 4;
    private static final int JISX0201_1976_KANA = 5;
    private static final int SHIFTOUT = 6;
    private static final int ESC = 27;
    private static final int SO = 14;
    private static final int SI = 15;

    public ISO2022_JP() {
        super("ISO-2022-JP", ExtendedCharsets.aliasesFor("ISO-2022-JP"));
    }

    protected ISO2022_JP(String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
    }

    @Override
    public String historicalName() {
        return "ISO2022JP";
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof JIS_X_0201 || cs instanceof US_ASCII || cs instanceof JIS_X_0208 || cs instanceof ISO2022_JP;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this, this.getDecIndex1(), this.getDecIndex2(), this.get0212Decoder());
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder((Charset)this, this.getEncIndex1(), this.getEncIndex2(), this.get0212Encoder(), this.doSBKANA());
    }

    protected short[] getDecIndex1() {
        return JIS_X_0208_Decoder.getIndex1();
    }

    protected String[] getDecIndex2() {
        return JIS_X_0208_Decoder.getIndex2();
    }

    protected DoubleByteDecoder get0212Decoder() {
        return null;
    }

    protected short[] getEncIndex1() {
        return JIS_X_0208_Encoder.getIndex1();
    }

    protected String[] getEncIndex2() {
        return JIS_X_0208_Encoder.getIndex2();
    }

    protected DoubleByteEncoder get0212Encoder() {
        return null;
    }

    protected boolean doSBKANA() {
        return true;
    }

    private static class Encoder
    extends DoubleByteEncoder {
        private static byte[] repl = new byte[]{33, 41};
        private int currentMode = 0;
        private int replaceMode = 3;
        private DoubleByteEncoder encoder0212 = null;
        private boolean doSBKANA;
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset cs, short[] index1, String[] index2, DoubleByteEncoder encoder0212, boolean doSBKANA) {
            super(cs, index1, index2, repl, 4.0f, encoder0212 != null ? 9.0f : 8.0f);
            this.encoder0212 = encoder0212;
            this.doSBKANA = doSBKANA;
        }

        @Override
        protected int encodeSingle(char inputChar) {
            return -1;
        }

        @Override
        protected void implReset() {
            this.currentMode = 0;
        }

        @Override
        protected void implReplaceWith(byte[] newReplacement) {
            if (newReplacement.length == 1) {
                this.replaceMode = 0;
            } else if (newReplacement.length == 2) {
                this.replaceMode = 3;
            }
        }

        @Override
        protected CoderResult implFlush(ByteBuffer out) {
            if (this.currentMode != 0) {
                if (out.remaining() < 3) {
                    return CoderResult.OVERFLOW;
                }
                out.put((byte)27);
                out.put((byte)40);
                out.put((byte)66);
                this.currentMode = 0;
            }
            return CoderResult.UNDERFLOW;
        }

        @Override
        public boolean canEncode(char c) {
            return c <= '\u007f' || c >= '\uff61' && c <= '\uff9f' || c == '\u00a5' || c == '\u203e' || super.canEncode(c) || this.encoder0212 != null && this.encoder0212.canEncode(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            try {
                for (sp = sp <= sl ? sp : sl; sp < sl; ++sp) {
                    char c = sa[sp];
                    if (c <= '\u007f') {
                        if (this.currentMode != 0) {
                            if (dl - dp < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            da[dp++] = 27;
                            da[dp++] = 40;
                            da[dp++] = 66;
                            this.currentMode = 0;
                        }
                        if (dl - dp < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)c;
                        continue;
                    }
                    if (c >= '\uff61' && c <= '\uff9f' && this.doSBKANA) {
                        if (this.currentMode != 5) {
                            if (dl - dp < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            da[dp++] = 27;
                            da[dp++] = 40;
                            da[dp++] = 73;
                            this.currentMode = 5;
                        }
                        if (dl - dp < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)(c - 65344);
                        continue;
                    }
                    if (c == '\u00a5' || c == '\u203e') {
                        if (this.currentMode != 1) {
                            if (dl - dp < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            da[dp++] = 27;
                            da[dp++] = 40;
                            da[dp++] = 74;
                            this.currentMode = 1;
                        }
                        if (dl - dp < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = c == '\u00a5' ? 92 : 126;
                        continue;
                    }
                    int index = this.encodeDouble(c);
                    if (index != 0) {
                        if (this.currentMode != 3) {
                            if (dl - dp < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            da[dp++] = 27;
                            da[dp++] = 36;
                            da[dp++] = 66;
                            this.currentMode = 3;
                        }
                        if (dl - dp < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)(index >> 8);
                        da[dp++] = (byte)(index & 0xFF);
                        continue;
                    }
                    if (this.encoder0212 != null && (index = this.encoder0212.encodeDouble(c)) != 0) {
                        if (this.currentMode != 4) {
                            if (dl - dp < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            da[dp++] = 27;
                            da[dp++] = 36;
                            da[dp++] = 40;
                            da[dp++] = 68;
                            this.currentMode = 4;
                        }
                        if (dl - dp < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)(index >> 8);
                        da[dp++] = (byte)(index & 0xFF);
                        continue;
                    }
                    if (Character.isSurrogate(c) && this.sgp.parse(c, sa, sp, sl) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    if (this.unmappableCharacterAction() == CodingErrorAction.REPLACE && this.currentMode != this.replaceMode) {
                        if (dl - dp < 3) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        if (this.replaceMode == 0) {
                            da[dp++] = 27;
                            da[dp++] = 40;
                            da[dp++] = 66;
                        } else {
                            da[dp++] = 27;
                            da[dp++] = 36;
                            da[dp++] = 66;
                        }
                        this.currentMode = this.replaceMode;
                    }
                    if (Character.isSurrogate(c)) {
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char c = src.get();
                    if (c <= '\u007f') {
                        if (this.currentMode != 0) {
                            if (dst.remaining() < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            dst.put((byte)27);
                            dst.put((byte)40);
                            dst.put((byte)66);
                            this.currentMode = 0;
                        }
                        if (dst.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)c);
                    } else if (c >= '\uff61' && c <= '\uff9f' && this.doSBKANA) {
                        if (this.currentMode != 5) {
                            if (dst.remaining() < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            dst.put((byte)27);
                            dst.put((byte)40);
                            dst.put((byte)73);
                            this.currentMode = 5;
                        }
                        if (dst.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)(c - 65344));
                    } else if (c == '\u00a5' || c == '\u203e') {
                        if (this.currentMode != 1) {
                            if (dst.remaining() < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            dst.put((byte)27);
                            dst.put((byte)40);
                            dst.put((byte)74);
                            this.currentMode = 1;
                        }
                        if (dst.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put(c == '\u00a5' ? (byte)92 : 126);
                    } else {
                        int index = this.encodeDouble(c);
                        if (index != 0) {
                            if (this.currentMode != 3) {
                                if (dst.remaining() < 3) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                dst.put((byte)27);
                                dst.put((byte)36);
                                dst.put((byte)66);
                                this.currentMode = 3;
                            }
                            if (dst.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            dst.put((byte)(index >> 8));
                            dst.put((byte)(index & 0xFF));
                        } else if (this.encoder0212 != null && (index = this.encoder0212.encodeDouble(c)) != 0) {
                            if (this.currentMode != 4) {
                                if (dst.remaining() < 4) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                dst.put((byte)27);
                                dst.put((byte)36);
                                dst.put((byte)40);
                                dst.put((byte)68);
                                this.currentMode = 4;
                            }
                            if (dst.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            dst.put((byte)(index >> 8));
                            dst.put((byte)(index & 0xFF));
                        } else {
                            if (Character.isSurrogate(c) && this.sgp.parse(c, src) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (this.unmappableCharacterAction() == CodingErrorAction.REPLACE && this.currentMode != this.replaceMode) {
                                if (dst.remaining() < 3) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                if (this.replaceMode == 0) {
                                    dst.put((byte)27);
                                    dst.put((byte)40);
                                    dst.put((byte)66);
                                } else {
                                    dst.put((byte)27);
                                    dst.put((byte)36);
                                    dst.put((byte)66);
                                }
                                this.currentMode = this.replaceMode;
                            }
                            if (Character.isSurrogate(c)) {
                                CoderResult coderResult = this.sgp.unmappableResult();
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }
    }

    private static class Decoder
    extends DoubleByteDecoder
    implements DelegatableDecoder {
        private int currentState;
        private int previousState;
        private DoubleByteDecoder decoder0212;

        protected Decoder(Charset cs, short[] index1, String[] index2, DoubleByteDecoder decoder0212) {
            super(cs, index1, index2, 33, 126);
            this.decoder0212 = decoder0212;
            this.currentState = 0;
            this.previousState = 0;
        }

        protected char convSingleByte(int b) {
            return '\ufffd';
        }

        @Override
        public void implReset() {
            this.currentState = 0;
            this.previousState = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            int inputSize = 0;
            int b1 = 0;
            int b2 = 0;
            int b3 = 0;
            int b4 = 0;
            int c = 65533;
            byte[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            sp = sp <= sl ? sp : sl;
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            try {
                while (sp < sl) {
                    block54: {
                        block53: {
                            block55: {
                                block57: {
                                    block56: {
                                        b1 = sa[sp] & 0xFF;
                                        inputSize = 1;
                                        if ((b1 & 0x80) != 0) {
                                            CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                            return coderResult;
                                        }
                                        if (b1 != 27 && b1 != 14 && b1 != 15) break block54;
                                        if (b1 != 27) break block55;
                                        if (sp + inputSize + 2 > sl) {
                                            CoderResult coderResult = CoderResult.UNDERFLOW;
                                            return coderResult;
                                        }
                                        if ((b2 = sa[sp + inputSize++] & 0xFF) != 40) break block56;
                                        if ((b3 = sa[sp + inputSize++] & 0xFF) == 66) {
                                            this.currentState = 0;
                                            break block53;
                                        } else if (b3 == 74) {
                                            this.currentState = 1;
                                            break block53;
                                        } else {
                                            if (b3 != 73) {
                                                CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                                return coderResult;
                                            }
                                            this.currentState = 5;
                                        }
                                        break block53;
                                    }
                                    if (b2 != 36) {
                                        CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                        return coderResult;
                                    }
                                    if ((b3 = sa[sp + inputSize++] & 0xFF) != 64) break block57;
                                    this.currentState = 2;
                                    break block53;
                                }
                                if (b3 == 66) {
                                    this.currentState = 3;
                                    break block53;
                                } else if (b3 == 40 && this.decoder0212 != null) {
                                    if (sp + inputSize + 1 > sl) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    if ((b4 = sa[sp + inputSize++] & 0xFF) != 68) {
                                        CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                        return coderResult;
                                    }
                                    this.currentState = 4;
                                    break block53;
                                } else {
                                    CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                    return coderResult;
                                }
                            }
                            if (b1 == 14) {
                                this.previousState = this.currentState;
                                this.currentState = 6;
                            } else if (b1 == 15) {
                                this.currentState = this.previousState;
                            }
                        }
                        sp += inputSize;
                        continue;
                    }
                    if (dp + 1 > dl) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    block14 : switch (this.currentState) {
                        case 0: {
                            da[dp++] = (char)(b1 & 0xFF);
                            break;
                        }
                        case 1: {
                            switch (b1) {
                                case 92: {
                                    da[dp++] = 165;
                                    break block14;
                                }
                                case 126: {
                                    da[dp++] = 8254;
                                    break block14;
                                }
                            }
                            da[dp++] = (char)b1;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (sp + inputSize + 1 > sl) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if ((c = (int)this.decodeDouble(b1, b2 = sa[sp + inputSize++] & 0xFF)) == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                                return coderResult;
                            }
                            da[dp++] = c;
                            break;
                        }
                        case 4: {
                            if (sp + inputSize + 1 > sl) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if ((c = (int)this.decoder0212.decodeDouble(b1, b2 = sa[sp + inputSize++] & 0xFF)) == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                                return coderResult;
                            }
                            da[dp++] = c;
                            break;
                        }
                        case 5: 
                        case 6: {
                            if (b1 > 96) {
                                CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                return coderResult;
                            }
                            da[dp++] = (char)(b1 + 65344);
                            break;
                        }
                    }
                    sp += inputSize;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            int b1 = 0;
            int b2 = 0;
            int b3 = 0;
            int b4 = 0;
            char c = '\ufffd';
            int inputSize = 0;
            try {
                while (src.hasRemaining()) {
                    block52: {
                        block51: {
                            block53: {
                                block55: {
                                    block54: {
                                        b1 = src.get() & 0xFF;
                                        inputSize = 1;
                                        if ((b1 & 0x80) != 0) {
                                            CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                            return coderResult;
                                        }
                                        if (b1 != 27 && b1 != 14 && b1 != 15) break block52;
                                        if (b1 != 27) break block53;
                                        if (src.remaining() < 2) {
                                            CoderResult coderResult = CoderResult.UNDERFLOW;
                                            return coderResult;
                                        }
                                        b2 = src.get() & 0xFF;
                                        ++inputSize;
                                        if (b2 != 40) break block54;
                                        b3 = src.get() & 0xFF;
                                        ++inputSize;
                                        if (b3 == 66) {
                                            this.currentState = 0;
                                            break block51;
                                        } else if (b3 == 74) {
                                            this.currentState = 1;
                                            break block51;
                                        } else {
                                            if (b3 != 73) {
                                                CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                                return coderResult;
                                            }
                                            this.currentState = 5;
                                        }
                                        break block51;
                                    }
                                    if (b2 != 36) {
                                        CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                        return coderResult;
                                    }
                                    b3 = src.get() & 0xFF;
                                    ++inputSize;
                                    if (b3 != 64) break block55;
                                    this.currentState = 2;
                                    break block51;
                                }
                                if (b3 == 66) {
                                    this.currentState = 3;
                                    break block51;
                                } else if (b3 == 40 && this.decoder0212 != null) {
                                    if (!src.hasRemaining()) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    b4 = src.get() & 0xFF;
                                    ++inputSize;
                                    if (b4 != 68) {
                                        CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                        return coderResult;
                                    }
                                    this.currentState = 4;
                                    break block51;
                                } else {
                                    CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                    return coderResult;
                                }
                            }
                            if (b1 == 14) {
                                this.previousState = this.currentState;
                                this.currentState = 6;
                            } else if (b1 == 15) {
                                this.currentState = this.previousState;
                            }
                        }
                        mark += inputSize;
                        continue;
                    }
                    if (!dst.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    block14 : switch (this.currentState) {
                        case 0: {
                            dst.put((char)(b1 & 0xFF));
                            break;
                        }
                        case 1: {
                            switch (b1) {
                                case 92: {
                                    dst.put('\u00a5');
                                    break block14;
                                }
                                case 126: {
                                    dst.put('\u203e');
                                    break block14;
                                }
                            }
                            dst.put((char)b1);
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (!src.hasRemaining()) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            b2 = src.get() & 0xFF;
                            ++inputSize;
                            c = this.decodeDouble(b1, b2);
                            if (c == '\ufffd') {
                                CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                                return coderResult;
                            }
                            dst.put(c);
                            break;
                        }
                        case 4: {
                            if (!src.hasRemaining()) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            b2 = src.get() & 0xFF;
                            ++inputSize;
                            c = this.decoder0212.decodeDouble(b1, b2);
                            if (c == '\ufffd') {
                                CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                                return coderResult;
                            }
                            dst.put(c);
                            break;
                        }
                        case 5: 
                        case 6: {
                            if (b1 > 96) {
                                CoderResult coderResult = CoderResult.malformedForLength(inputSize);
                                return coderResult;
                            }
                            dst.put((char)(b1 + 65344));
                            break;
                        }
                    }
                    mark += inputSize;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        @Override
        public CoderResult implFlush(CharBuffer out) {
            return super.implFlush(out);
        }
    }
}

