/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;

final class CipherBox {
    static final CipherBox NULL = new CipherBox();
    private static final Debug debug = Debug.getInstance("ssl");
    private final ProtocolVersion protocolVersion;
    private final Cipher cipher;
    private int blockSize;
    private SecureRandom random;
    private final boolean isCBCMode;
    private static Hashtable<Integer, IvParameterSpec> masks;

    private CipherBox() {
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.cipher = null;
        this.isCBCMode = false;
    }

    private CipherBox(ProtocolVersion protocolVersion, CipherSuite.BulkCipher bulkCipher, SecretKey key, IvParameterSpec iv, SecureRandom random, boolean encrypt) throws NoSuchAlgorithmException {
        try {
            int mode;
            this.protocolVersion = protocolVersion;
            this.cipher = JsseJce.getCipher(bulkCipher.transformation);
            int n = mode = encrypt ? 1 : 2;
            if (random == null) {
                random = JsseJce.getSecureRandom();
            }
            this.random = random;
            this.isCBCMode = bulkCipher.isCBCMode;
            if (iv == null && bulkCipher.ivSize != 0 && mode == 2 && protocolVersion.v >= ProtocolVersion.TLS11.v) {
                iv = CipherBox.getFixedMask(bulkCipher.ivSize);
            }
            this.cipher.init(mode, (Key)key, iv, random);
            this.blockSize = this.cipher.getBlockSize();
            if (this.blockSize == 1) {
                this.blockSize = 0;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, e);
        }
        catch (ExceptionInInitializerError e) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, e);
        }
    }

    static CipherBox newCipherBox(ProtocolVersion version, CipherSuite.BulkCipher cipher, SecretKey key, IvParameterSpec iv, SecureRandom random, boolean encrypt) throws NoSuchAlgorithmException {
        if (!cipher.allowed) {
            throw new NoSuchAlgorithmException("Unsupported cipher " + cipher);
        }
        if (cipher == CipherSuite.B_NULL) {
            return NULL;
        }
        return new CipherBox(version, cipher, key, iv, random, encrypt);
    }

    private static IvParameterSpec getFixedMask(int ivSize) {
        IvParameterSpec iv;
        if (masks == null) {
            masks = new Hashtable(5);
        }
        if ((iv = masks.get(ivSize)) == null) {
            iv = new IvParameterSpec(new byte[ivSize]);
            masks.put(ivSize, iv);
        }
        return iv;
    }

    int encrypt(byte[] buf, int offset, int len) {
        if (this.cipher == null) {
            return len;
        }
        try {
            int newLen;
            if (this.blockSize != 0) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    byte[] prefix = new byte[this.blockSize];
                    this.random.nextBytes(prefix);
                    System.arraycopy(buf, offset, buf, offset + prefix.length, len);
                    System.arraycopy(prefix, 0, buf, offset, prefix.length);
                    len += prefix.length;
                }
                len = CipherBox.addPadding(buf, offset, len, this.blockSize);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hd = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + len);
                    hd.encodeBuffer((InputStream)new ByteArrayInputStream(buf, offset, len), (OutputStream)System.out);
                }
                catch (IOException hd) {
                    // empty catch block
                }
            }
            if ((newLen = this.cipher.update(buf, offset, len, buf, offset)) != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return newLen;
        }
        catch (ShortBufferException e) {
            throw new ArrayIndexOutOfBoundsException(e.toString());
        }
    }

    int encrypt(ByteBuffer bb) {
        int len = bb.remaining();
        if (this.cipher == null) {
            bb.position(bb.limit());
            return len;
        }
        try {
            int pos = bb.position();
            if (this.blockSize != 0) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    byte[] prefix = new byte[this.blockSize];
                    this.random.nextBytes(prefix);
                    byte[] buf = null;
                    int limit = bb.limit();
                    if (bb.hasArray()) {
                        int arrayOffset = bb.arrayOffset();
                        buf = bb.array();
                        System.arraycopy(buf, arrayOffset + pos, buf, arrayOffset + pos + prefix.length, limit - pos);
                        bb.limit(limit + prefix.length);
                    } else {
                        buf = new byte[limit - pos];
                        bb.get(buf, 0, limit - pos);
                        bb.position(pos + prefix.length);
                        bb.limit(limit + prefix.length);
                        bb.put(buf);
                    }
                    bb.position(pos);
                    bb.put(prefix);
                    bb.position(pos);
                }
                len = CipherBox.addPadding(bb, this.blockSize);
                bb.position(pos);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hd = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + len);
                    hd.encodeBuffer(bb, (OutputStream)System.out);
                }
                catch (IOException hd) {
                    // empty catch block
                }
                bb.position(pos);
            }
            ByteBuffer dup = bb.duplicate();
            int newLen = this.cipher.update(dup, bb);
            if (bb.position() != dup.position()) {
                throw new RuntimeException("bytebuffer padding error");
            }
            if (newLen != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return newLen;
        }
        catch (ShortBufferException e) {
            RuntimeException exc = new RuntimeException(e.toString());
            exc.initCause(e);
            throw exc;
        }
    }

    int decrypt(byte[] buf, int offset, int len, int tagLen) throws BadPaddingException {
        if (this.cipher == null) {
            return len;
        }
        try {
            int newLen = this.cipher.update(buf, offset, len, buf, offset);
            if (newLen != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hd = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + newLen);
                    hd.encodeBuffer((InputStream)new ByteArrayInputStream(buf, offset, newLen), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.blockSize != 0) {
                newLen = CipherBox.removePadding(buf, offset, newLen, tagLen, this.blockSize, this.protocolVersion);
                if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    if (newLen < this.blockSize) {
                        throw new BadPaddingException("The length after padding removal (" + newLen + ") should be larger " + "than <" + this.blockSize + "> since explicit IV used");
                    }
                    System.arraycopy(buf, offset + this.blockSize, buf, offset, newLen - this.blockSize);
                    newLen -= this.blockSize;
                }
            }
            return newLen;
        }
        catch (ShortBufferException e) {
            throw new ArrayIndexOutOfBoundsException(e.toString());
        }
    }

    int decrypt(ByteBuffer bb, int tagLen) throws BadPaddingException {
        int len = bb.remaining();
        if (this.cipher == null) {
            bb.position(bb.limit());
            return len;
        }
        try {
            int pos = bb.position();
            ByteBuffer dup = bb.duplicate();
            int newLen = this.cipher.update(dup, bb);
            if (newLen != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hd = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + newLen);
                    hd.encodeBuffer((ByteBuffer)bb.duplicate().position(pos), (OutputStream)System.out);
                }
                catch (IOException hd) {
                    // empty catch block
                }
            }
            if (this.blockSize != 0) {
                bb.position(pos);
                newLen = CipherBox.removePadding(bb, tagLen, this.blockSize, this.protocolVersion);
                if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    if (newLen < this.blockSize) {
                        throw new BadPaddingException("The length after padding removal (" + newLen + ") should be larger " + "than <" + this.blockSize + "> since explicit IV used");
                    }
                    byte[] buf = null;
                    int limit = bb.limit();
                    if (bb.hasArray()) {
                        int arrayOffset = bb.arrayOffset();
                        buf = bb.array();
                        System.arraycopy(buf, arrayOffset + pos + this.blockSize, buf, arrayOffset + pos, limit - pos - this.blockSize);
                        bb.limit(limit - this.blockSize);
                    } else {
                        buf = new byte[limit - pos - this.blockSize];
                        bb.position(pos + this.blockSize);
                        bb.get(buf);
                        bb.position(pos);
                        bb.put(buf);
                        bb.limit(limit - this.blockSize);
                    }
                    limit = bb.limit();
                    bb.position(limit);
                }
            }
            return newLen;
        }
        catch (ShortBufferException e) {
            RuntimeException exc = new RuntimeException(e.toString());
            exc.initCause(e);
            throw exc;
        }
    }

    private static int addPadding(byte[] buf, int offset, int len, int blockSize) {
        int newlen = len + 1;
        if (newlen % blockSize != 0) {
            newlen += blockSize - 1;
            newlen -= newlen % blockSize;
        }
        int pad = newlen - len;
        if (buf.length < newlen + offset) {
            throw new IllegalArgumentException("no space to pad buffer");
        }
        offset += len;
        for (int i = 0; i < pad; ++i) {
            buf[offset++] = (byte)(pad - 1);
        }
        return newlen;
    }

    private static int addPadding(ByteBuffer bb, int blockSize) {
        int len = bb.remaining();
        int offset = bb.position();
        int newlen = len + 1;
        if (newlen % blockSize != 0) {
            newlen += blockSize - 1;
            newlen -= newlen % blockSize;
        }
        int pad = newlen - len;
        bb.limit(newlen + offset);
        offset += len;
        for (int i = 0; i < pad; ++i) {
            bb.put(offset++, (byte)(pad - 1));
        }
        bb.position(offset);
        bb.limit(offset);
        return newlen;
    }

    private static int[] checkPadding(byte[] buf, int offset, int len, byte pad) {
        if (len <= 0) {
            throw new RuntimeException("padding len must be positive");
        }
        int[] results = new int[]{0, 0};
        int i = 0;
        while (i <= 256) {
            for (int j = 0; j < len && i <= 256; ++j, ++i) {
                if (buf[offset + j] != pad) {
                    results[0] = results[0] + 1;
                    continue;
                }
                results[1] = results[1] + 1;
            }
        }
        return results;
    }

    private static int[] checkPadding(ByteBuffer bb, byte pad) {
        if (!bb.hasRemaining()) {
            throw new RuntimeException("hasRemaining() must be positive");
        }
        int[] results = new int[]{0, 0};
        bb.mark();
        int i = 0;
        while (i <= 256) {
            while (bb.hasRemaining() && i <= 256) {
                if (bb.get() != pad) {
                    results[0] = results[0] + 1;
                } else {
                    results[1] = results[1] + 1;
                }
                ++i;
            }
            bb.reset();
        }
        return results;
    }

    private static int removePadding(byte[] buf, int offset, int len, int tagLen, int blockSize, ProtocolVersion protocolVersion) throws BadPaddingException {
        int padOffset = offset + len - 1;
        int padLen = buf[padOffset] & 0xFF;
        int newLen = len - (padLen + 1);
        if (newLen - tagLen < 0) {
            CipherBox.checkPadding(buf, offset, len, (byte)(padLen & 0xFF));
            throw new BadPaddingException("Invalid Padding length: " + padLen);
        }
        int[] results = CipherBox.checkPadding(buf, offset + newLen, padLen + 1, (byte)(padLen & 0xFF));
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            if (results[0] != 0) {
                throw new BadPaddingException("Invalid TLS padding data");
            }
        } else if (padLen > blockSize) {
            throw new BadPaddingException("Padding length (" + padLen + ") of SSLv3 message should not be bigger " + "than the block size (" + blockSize + ")");
        }
        return newLen;
    }

    private static int removePadding(ByteBuffer bb, int tagLen, int blockSize, ProtocolVersion protocolVersion) throws BadPaddingException {
        int offset;
        int padOffset;
        int padLen;
        int len = bb.remaining();
        int newLen = len - ((padLen = bb.get(padOffset = (offset = bb.position()) + len - 1) & 0xFF) + 1);
        if (newLen - tagLen < 0) {
            CipherBox.checkPadding(bb.duplicate(), (byte)(padLen & 0xFF));
            throw new BadPaddingException("Invalid Padding length: " + padLen);
        }
        int[] results = CipherBox.checkPadding((ByteBuffer)bb.duplicate().position(offset + newLen), (byte)(padLen & 0xFF));
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            if (results[0] != 0) {
                throw new BadPaddingException("Invalid TLS padding data");
            }
        } else if (padLen > blockSize) {
            throw new BadPaddingException("Padding length (" + padLen + ") of SSLv3 message should not be bigger " + "than the block size (" + blockSize + ")");
        }
        bb.position(offset + newLen);
        bb.limit(offset + newLen);
        return newLen;
    }

    void dispose() {
        try {
            if (this.cipher != null) {
                this.cipher.doFinal();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }

    boolean isCBCMode() {
        return this.isCBCMode;
    }

    boolean isNullCipher() {
        return this.cipher == null;
    }

    boolean sanityCheck(int tagLen, int fragmentLen) {
        if (!this.isCBCMode) {
            return fragmentLen >= tagLen;
        }
        if (fragmentLen % this.blockSize == 0) {
            int minimal = tagLen + 1;
            int n = minimal = minimal >= this.blockSize ? minimal : this.blockSize;
            if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                minimal += this.blockSize;
            }
            return fragmentLen >= minimal;
        }
        return false;
    }
}

