/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;

public class ByteBufferUtils {
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.buf");
    private static final Log log = LogFactory.getLog(ByteBufferUtils.class);
    private static final Object unsafe;
    private static final Method cleanerMethod;
    private static final Method cleanMethod;
    private static final Method invokeCleanerMethod;

    private ByteBufferUtils() {
    }

    public static ByteBuffer expand(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2;
        if (byteBuffer.capacity() >= n) {
            return byteBuffer;
        }
        boolean bl = false;
        if (byteBuffer.isDirect()) {
            byteBuffer2 = ByteBuffer.allocateDirect(n);
            bl = true;
        } else {
            byteBuffer2 = ByteBuffer.allocate(n);
        }
        byteBuffer.flip();
        byteBuffer2.put(byteBuffer);
        if (bl) {
            ByteBufferUtils.cleanDirectBuffer(byteBuffer);
        }
        return byteBuffer2;
    }

    public static void cleanDirectBuffer(ByteBuffer byteBuffer) {
        block7: {
            if (cleanMethod != null) {
                try {
                    cleanMethod.invoke(cleanerMethod.invoke((Object)byteBuffer, new Object[0]), new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("byteBufferUtils.cleaner"), (Throwable)exception);
                    }
                    break block7;
                }
            }
            if (invokeCleanerMethod != null) {
                try {
                    invokeCleanerMethod.invoke(unsafe, byteBuffer);
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)sm.getString("byteBufferUtils.cleaner"), (Throwable)exception);
                }
            }
        }
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(0);
        Method method = null;
        Method method2 = null;
        Object object = null;
        Method method3 = null;
        if (JreCompat.isJre9Available()) {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Field field = clazz.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                object = field.get(null);
                method3 = clazz.getMethod("invokeCleaner", ByteBuffer.class);
                method3.invoke(object, byteBuffer);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                log.warn((Object)sm.getString("byteBufferUtils.cleaner"), (Throwable)exception);
                object = null;
                method3 = null;
            }
        } else {
            try {
                method = byteBuffer.getClass().getMethod("cleaner", new Class[0]);
                method.setAccessible(true);
                Object object2 = method.invoke((Object)byteBuffer, new Object[0]);
                method2 = object2.getClass().getMethod("clean", new Class[0]);
                method2.invoke(object2, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                log.warn((Object)sm.getString("byteBufferUtils.cleaner"), (Throwable)exception);
                method = null;
                method2 = null;
            }
        }
        cleanerMethod = method;
        cleanMethod = method2;
        unsafe = object;
        invokeCleanerMethod = method3;
    }
}

