/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntryNumericComparator;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.GlsRecord;
import com.dickimawbooks.bib2gls.SortSettings;
import java.util.Set;
import java.util.Vector;

public class Bib2GlsEntryRecordCountComparator
extends Bib2GlsEntryNumericComparator {
    public Bib2GlsEntryRecordCountComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2) throws Bib2GlsException {
        super(bib2Gls, vector, sortSettings, "", string, string2);
        if (!bib2Gls.isRecordCountSet()) {
            throw new Bib2GlsException(bib2Gls.getMessage("error.sort.requires.switch", sortSettings.getMethod(), "--record-count"));
        }
    }

    @Override
    protected String adjustSort(Bib2GlsEntry bib2GlsEntry, String string) {
        String string2 = bib2GlsEntry.getId();
        int n = 0;
        Set<GlsRecord> set = this.bib2gls.getRecordCountKeySet();
        if (set != null) {
            for (GlsRecord glsRecord : set) {
                if (!glsRecord.getLabel().equals(string2)) continue;
                Integer n2 = this.bib2gls.getRecordCount(glsRecord);
                n += n2.intValue();
            }
        }
        bib2GlsEntry.setNumericSort(n);
        return "" + n;
    }
}

