/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.attach;

import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.attach.HeapHistogramImpl;
import org.graalvm.visualvm.tools.attach.AttachModel;
import sun.tools.attach.HotSpotVirtualMachine;

class AttachModelImpl
extends AttachModel {
    static final String LIVE_OBJECTS_OPTION = "-live";
    static final String ALL_OBJECTS_OPTION = "-all";
    static final String HEAP_DUMP_NO_SPACE_ID = "No space left on device";
    static final String JCMD_VM_COMMAND_LINE = "VM.command_line";
    static final String JCMD_JFR_DUMP = "JFR.dump";
    static final String JCMD_JFR_DUMP_FILENAME = "filename";
    static final String JCMD_JFR_DUMP_RECORDING = "recording";
    static final String JCMD_JFR_DUMP_NAME = "name";
    static final String JCMD_JFR_CHECK = "JFR.check";
    static final String JCMD_JFR_CHECK_RECORDING_ID = "recording=";
    static final String JCMD_JFR_CHECK_RECORDING_ID1 = "Recording ";
    static final String JCMD_JFR_CHECK_HELP_OPTIONS_ID = "Options: ";
    static final String JCMD_JFR_CHECK_HELP_RECORDING_ID = "recording : ";
    static final String JCMD_JFR_START = "JFR.start";
    private static final String JCMD_JFR_START_NAME = "name";
    private static final String JCMD_JFR_START_SETTINGS = "settings";
    private static final String JCMD_JFR_START_DELAY = "delay";
    private static final String JCMD_JFR_START_DURATION = "duration";
    private static final String JCMD_JFR_START_DISK = "disk";
    private static final String JCMD_JFR_START_FILENAME = "filename";
    private static final String JCMD_JFR_START_MAXAGE = "maxage";
    private static final String JCMD_JFR_START_MAXSIZE = "maxsize";
    private static final String JCMD_JFR_START_DUMPONEXIT = "dumponexit";
    static final String JCMD_JFR_STOP = "JFR.stop";
    static final String JCMD_JFR_STOP_NAME = "name";
    static final String JCMD_JFR_UNLOCK_ID = "Use VM.unlock_commercial_features to enable";
    static final String JCMD_UNLOCK_CF = "VM.unlock_commercial_features";
    static final String JCMD_HELP = "help";
    static final String JCMD_CF_ID = " unlocked.";
    static final Logger LOGGER = Logger.getLogger(AttachModelImpl.class.getName());
    String pid;
    HotSpotVirtualMachine vm;
    Map<String, String> commandLineMap;
    boolean oldJFR;
    Boolean jfrAvailable;

    AttachModelImpl(Application app) {
        this.pid = Integer.toString(app.getPid());
    }

    public synchronized Properties getSystemProperties() {
        try {
            return this.getVirtualMachine().getSystemProperties();
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "getSystemProperties", ex);
            return null;
        }
    }

    public synchronized boolean takeHeapDump(String fileName) {
        try {
            InputStream in = this.getVirtualMachine().dumpHeap(fileName, LIVE_OBJECTS_OPTION);
            String out = this.readToEOF(in);
            if (!out.isEmpty()) {
                LOGGER.log(Level.INFO, "takeHeapDump", out);
            }
            Path f = Paths.get(fileName, new String[0]);
            if (out.contains(HEAP_DUMP_NO_SPACE_ID)) {
                Files.deleteIfExists(f);
                return false;
            }
            return Files.isRegularFile(f, LinkOption.NOFOLLOW_LINKS) && Files.isReadable(f);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "takeHeapDump", ex);
            return false;
        }
    }

    public synchronized String takeThreadDump() {
        try {
            InputStream in = this.getVirtualMachine().remoteDataDump("-l");
            return this.readToEOF(in);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "takeThreadDump", ex);
            return null;
        }
    }

    public synchronized String printFlag(String name) {
        try {
            InputStream in = this.getVirtualMachine().printFlag(name);
            return this.readToEOF(in);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "printFlag", ex);
            return null;
        }
    }

    public synchronized void setFlag(String name, String value) {
        try {
            InputStream in = this.getVirtualMachine().setFlag(name, value);
            String out = this.readToEOF(in);
            if (!out.isEmpty()) {
                LOGGER.log(Level.INFO, "setFlag", out);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "setFlag", ex);
        }
    }

    public synchronized HeapHistogramImpl takeHeapHistogram() {
        try {
            InputStream in = this.getVirtualMachine().heapHisto(ALL_OBJECTS_OPTION);
            HeapHistogramImpl h = new HeapHistogramImpl(in);
            in.close();
            return h;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "takeHeapHistogram", ex);
            return null;
        }
    }

    public String getCommandLine() {
        Map<String, String> cmdLineMap = this.getVMCommandLine();
        if (cmdLineMap != null) {
            return cmdLineMap.get("java_command");
        }
        return null;
    }

    public String getJvmArgs() {
        Map<String, String> cmdLineMap = this.getVMCommandLine();
        if (cmdLineMap != null) {
            return cmdLineMap.get("jvm_args");
        }
        return null;
    }

    public String getJvmFlags() {
        Map<String, String> cmdLineMap = this.getVMCommandLine();
        if (cmdLineMap != null) {
            return cmdLineMap.get("jvm_flags");
        }
        return null;
    }

    public synchronized boolean isJfrAvailable() {
        if (this.jfrAvailable == null) {
            String recordings = this.executeJCmd(JCMD_JFR_CHECK);
            this.jfrAvailable = recordings == null ? Boolean.FALSE : (recordings.contains(JCMD_JFR_UNLOCK_ID) ? Boolean.valueOf(this.unlockCommercialFeature()) : Boolean.TRUE);
            if (Boolean.TRUE.equals(this.jfrAvailable)) {
                this.oldJFR = this.checkForOldJFR();
            }
        }
        return this.jfrAvailable;
    }

    public List<Long> jfrCheck() {
        if (!this.isJfrAvailable()) {
            throw new UnsupportedOperationException();
        }
        String recordings = this.executeJCmd(JCMD_JFR_CHECK);
        if (recordings == null) {
            return Collections.EMPTY_LIST;
        }
        String[] lines = recordings.split("\\r?\\n");
        ArrayList<Long> recNumbers = new ArrayList<Long>(lines.length);
        for (String line : lines) {
            String recordingNum;
            int recEnd;
            int recStart;
            int index = line.indexOf(JCMD_JFR_CHECK_RECORDING_ID);
            if (index >= 0) {
                recStart = index + JCMD_JFR_CHECK_RECORDING_ID.length();
                recEnd = line.indexOf(32, recStart);
                if (recEnd <= recStart) continue;
                recordingNum = line.substring(recStart, recEnd);
                recNumbers.add(Long.valueOf(recordingNum));
                continue;
            }
            if (!line.startsWith(JCMD_JFR_CHECK_RECORDING_ID1) || (recEnd = line.indexOf(58, recStart = JCMD_JFR_CHECK_RECORDING_ID1.length())) <= recStart) continue;
            recordingNum = line.substring(recStart, recEnd);
            recNumbers.add(Long.valueOf(recordingNum));
        }
        return recNumbers;
    }

    public String takeJfrDump(long recording, String fileName) {
        if (!this.isJfrAvailable()) {
            throw new UnsupportedOperationException();
        }
        HashMap<String, Object> pars = new HashMap<String, Object>();
        pars.put("filename", fileName);
        pars.put(this.oldJFR ? JCMD_JFR_DUMP_RECORDING : "name", recording);
        return this.executeJCmd(JCMD_JFR_DUMP, pars);
    }

    public boolean startJfrRecording(String name, String[] settings, String delay, String duration, Boolean disk, String path, String maxAge, String maxSize, Boolean dumpOnExit) {
        if (!this.isJfrAvailable()) {
            throw new UnsupportedOperationException();
        }
        HashMap<String, Object> pars = new HashMap<String, Object>();
        if (name != null) {
            pars.put("name", name);
        }
        if (settings != null) {
            for (String setting : settings) {
                pars.put(JCMD_JFR_START_SETTINGS, setting);
            }
        }
        if (delay != null) {
            pars.put(JCMD_JFR_START_DELAY, delay);
        }
        if (duration != null) {
            pars.put(JCMD_JFR_START_DURATION, duration);
        }
        if (maxAge != null) {
            pars.put(JCMD_JFR_START_MAXAGE, maxAge);
        }
        if (maxSize != null) {
            pars.put(JCMD_JFR_START_MAXSIZE, maxSize);
        }
        if (dumpOnExit != null) {
            pars.put(JCMD_JFR_START_DUMPONEXIT, dumpOnExit);
        }
        if (path != null) {
            pars.put("filename", path);
        }
        if (disk != null && !this.oldJFR) {
            pars.put(JCMD_JFR_START_DISK, disk);
        }
        this.executeJCmd(JCMD_JFR_START, pars);
        return true;
    }

    public boolean stopJfrRecording() {
        if (!this.isJfrAvailable()) {
            throw new UnsupportedOperationException();
        }
        String recKey = this.oldJFR ? JCMD_JFR_DUMP_RECORDING : "name";
        for (Long recording : this.jfrCheck()) {
            Map<String, Object> pars = Collections.singletonMap(recKey, recording);
            this.executeJCmd(JCMD_JFR_STOP, pars);
        }
        return true;
    }

    HotSpotVirtualMachine getVirtualMachine() throws IOException {
        if (this.vm == null) {
            try {
                this.vm = (HotSpotVirtualMachine)VirtualMachine.attach(this.pid);
            }
            catch (Exception x) {
                throw new IOException(x.getLocalizedMessage(), x);
            }
        }
        return this.vm;
    }

    private String executeJCmd(String command, Map<String, Object> pars) {
        StringBuilder commandLine = new StringBuilder(command);
        for (Map.Entry<String, Object> e : pars.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            String par = val == null ? key : String.format("%s=%s", key, AttachModelImpl.quoteString(val.toString()));
            commandLine.append(' ').append(par);
        }
        return this.executeJCmd(commandLine.toString());
    }

    private static String quoteString(String val) {
        if (val.indexOf(32) >= 0) {
            return "\"" + val + "\"";
        }
        return val;
    }

    private boolean checkForOldJFR() {
        String ret = this.getJCmdHelp(JCMD_JFR_CHECK);
        if (ret != null) {
            int options = ret.indexOf(JCMD_JFR_CHECK_HELP_OPTIONS_ID);
            int recording = ret.indexOf(JCMD_JFR_CHECK_HELP_RECORDING_ID);
            return options != -1 && options < recording;
        }
        return false;
    }

    private boolean unlockCommercialFeature() {
        String ret = this.executeJCmd(JCMD_UNLOCK_CF);
        return ret.contains(JCMD_CF_ID);
    }

    private String getJCmdHelp(String command) {
        return this.executeJCmd("help " + command);
    }

    private synchronized Map<String, String> getVMCommandLine() {
        if (this.commandLineMap == null) {
            String text = this.executeJCmd(JCMD_VM_COMMAND_LINE);
            this.commandLineMap = new HashMap<String, String>();
            if (text != null) {
                String[] lines;
                for (String line : lines = text.split("\\R")) {
                    int offset = line.indexOf(58);
                    if (offset == -1) continue;
                    String key = line.substring(0, offset).trim();
                    String value = line.substring(offset + 1).trim();
                    this.commandLineMap.put(key, value);
                }
            }
        }
        return this.commandLineMap;
    }

    private synchronized String executeJCmd(String command) {
        try {
            InputStream in = this.getVirtualMachine().executeJCmd(command);
            return this.readToEOF(in);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "executeJCmd", ex);
            return null;
        }
    }

    private String readToEOF(InputStream in) throws IOException {
        int n;
        StringBuffer buffer = new StringBuffer(1024);
        byte[] b = new byte[256];
        do {
            if ((n = in.read(b)) <= 0) continue;
            String s = new String(b, 0, n, "UTF-8");
            buffer.append(s);
        } while (n > 0);
        in.close();
        return buffer.toString();
    }

    protected void finalize() throws Throwable {
        if (this.vm != null) {
            this.vm.detach();
        }
        super.finalize();
    }
}

