/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Customizer;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextProxy;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanChildren;
import org.openide.nodes.Children;
import org.openide.nodes.IndexedPropertySupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.nodes.TMUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public class BeanNode<T>
extends AbstractNode {
    private static final String ICON_BASE = "org/openide/nodes/beans.gif";
    private final T bean;
    private BeanInfo beanInfo;
    private Method nameGetter = null;
    private Method nameSetter = null;
    private Method removePCLMethod = null;
    private PropL propertyChangeListener = null;
    private boolean synchronizeName;

    public BeanNode(T t) throws IntrospectionException {
        this(t, null, null);
    }

    protected BeanNode(T t, Children children) throws IntrospectionException {
        this(t, children, null);
    }

    protected BeanNode(T t, Children children, Lookup lookup) throws IntrospectionException {
        super(children == null ? BeanNode.getChildren(t) : children, lookup);
        if (t == null) {
            throw new NullPointerException("cannot make a node for a null bean");
        }
        this.bean = t;
        try {
            this.initialization(lookup != null);
        }
        catch (IntrospectionException introspectionException) {
            throw introspectionException;
        }
        catch (RuntimeException runtimeException) {
            throw BeanNode.mkie(runtimeException);
        }
        catch (LinkageError linkageError) {
            throw BeanNode.mkie(linkageError);
        }
    }

    private static Children getChildren(Object object) {
        BeanContextChild beanContextChild;
        if (object instanceof BeanContext) {
            return new BeanChildren((BeanContext)object);
        }
        if (object instanceof BeanContextProxy && (beanContextChild = ((BeanContextProxy)object).getBeanContextProxy()) instanceof BeanContext) {
            return new BeanChildren((BeanContext)beanContextChild);
        }
        return Children.LEAF;
    }

    private static IntrospectionException mkie(Throwable throwable) {
        return (IntrospectionException)new IntrospectionException(throwable.toString()).initCause(throwable);
    }

    protected void setSynchronizeName(boolean bl) {
        this.synchronizeName = bl;
    }

    protected T getBean() {
        return this.bean;
    }

    @Override
    public void destroy() throws IOException {
        if (this.removePCLMethod != null) {
            try {
                Object object = Beans.getInstanceOf(this.bean, this.removePCLMethod.getDeclaringClass());
                this.removePCLMethod.invoke(object, this.propertyChangeListener);
            }
            catch (Exception exception) {
                NodeOp.exception(exception);
            }
        }
        super.destroy();
    }

    @Override
    public boolean canDestroy() {
        return true;
    }

    @Override
    public void setName(String string) {
        Method method;
        if (this.synchronizeName && (method = this.nameSetter) != null) {
            try {
                method.invoke(this.bean, string);
            }
            catch (Exception exception) {
                NodeOp.exception(exception);
            }
        }
        super.setName(string);
    }

    @Override
    public boolean canRename() {
        return !this.synchronizeName || this.nameSetter != null;
    }

    @Override
    public Image getIcon(int n) {
        Image image = this.beanInfo.getIcon(n);
        if (image != null) {
            return image;
        }
        return super.getIcon(n);
    }

    @Override
    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    @Override
    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx = HelpCtx.findHelp(this.bean);
        if (helpCtx != HelpCtx.DEFAULT_HELP) {
            return helpCtx;
        }
        return new HelpCtx(BeanNode.class);
    }

    protected void createProperties(T t, BeanInfo beanInfo) {
        Descriptor descriptor = BeanNode.computeProperties(t, beanInfo);
        Sheet sheet = this.getSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put(descriptor.property);
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        if (beanDescriptor != null && beanDescriptor.getValue("propertiesHelpID") != null) {
            set.setValue("helpID", beanDescriptor.getValue("propertiesHelpID"));
        }
        sheet.put(set);
        if (descriptor.expert.length != 0) {
            Sheet.Set set2 = Sheet.createExpertSet();
            set2.put(descriptor.expert);
            if (beanDescriptor != null && beanDescriptor.getValue("expertHelpID") != null) {
                set2.setValue("helpID", beanDescriptor.getValue("expertHelpID"));
            }
            sheet.put(set2);
        }
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public Action[] getActions(boolean bl) {
        return NodeOp.createFromNames(new String[]{"Copy", null, "Tools", "Properties"});
    }

    @Override
    public boolean hasCustomizer() {
        return this.beanInfo.getBeanDescriptor().getCustomizerClass() != null;
    }

    @Override
    public Component getCustomizer() {
        Object obj;
        Class<?> clazz = this.beanInfo.getBeanDescriptor().getCustomizerClass();
        if (clazz == null) {
            return null;
        }
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            NodeOp.exception(instantiationException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            NodeOp.exception(illegalAccessException);
            return null;
        }
        if (!(obj instanceof Customizer)) {
            return null;
        }
        Customizer customizer = (Customizer)obj;
        TMUtil.attachCustomizer(this, customizer);
        Component component = null;
        component = obj instanceof Component ? (Component)obj : TMUtil.createDialog(obj);
        if (component == null) {
            return null;
        }
        customizer.setObject(this.bean);
        if (this.removePCLMethod == null) {
            customizer.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BeanNode.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            });
        }
        return component;
    }

    public static Descriptor computeProperties(Object object, BeanInfo beanInfo) {
        ArrayList<Node.Property> arrayList = new ArrayList<Node.Property>();
        ArrayList<Node.Property> arrayList2 = new ArrayList<Node.Property>();
        ArrayList<Node.Property> arrayList3 = new ArrayList<Node.Property>();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            Node.Property property;
            String string;
            Enumeration<String> enumeration;
            Node.Property property2;
            Object object2;
            if (propertyDescriptorArray[i].getPropertyType() == null) continue;
            if (propertyDescriptorArray[i] instanceof IndexedPropertyDescriptor) {
                object2 = (IndexedPropertyDescriptor)propertyDescriptorArray[i];
                if (((PropertyDescriptor)object2).getReadMethod() != null && !((PropertyDescriptor)object2).getReadMethod().getReturnType().isArray()) continue;
                property2 = new IndexedPropertySupport(object, ((PropertyDescriptor)object2).getPropertyType(), ((IndexedPropertyDescriptor)object2).getIndexedPropertyType(), ((PropertyDescriptor)object2).getReadMethod(), ((PropertyDescriptor)object2).getWriteMethod(), ((IndexedPropertyDescriptor)object2).getIndexedReadMethod(), ((IndexedPropertyDescriptor)object2).getIndexedWriteMethod());
                ((IndexedPropertySupport)property2).setName(((FeatureDescriptor)object2).getName());
                ((IndexedPropertySupport)property2).setDisplayName(((FeatureDescriptor)object2).getDisplayName());
                ((IndexedPropertySupport)property2).setShortDescription(((FeatureDescriptor)object2).getShortDescription());
                enumeration = ((FeatureDescriptor)object2).attributeNames();
                while (enumeration.hasMoreElements()) {
                    string = enumeration.nextElement();
                    property2.setValue(string, ((FeatureDescriptor)object2).getValue(string));
                }
                property = property2;
            } else {
                object2 = propertyDescriptorArray[i];
                property2 = new PropertySupport.Reflection(object, ((PropertyDescriptor)object2).getPropertyType(), ((PropertyDescriptor)object2).getReadMethod(), ((PropertyDescriptor)object2).getWriteMethod());
                property2.setName(((FeatureDescriptor)object2).getName());
                property2.setDisplayName(((FeatureDescriptor)object2).getDisplayName());
                property2.setShortDescription(((FeatureDescriptor)object2).getShortDescription());
                ((PropertySupport.Reflection)property2).setPropertyEditorClass(((PropertyDescriptor)object2).getPropertyEditorClass());
                enumeration = ((FeatureDescriptor)object2).attributeNames();
                while (enumeration.hasMoreElements()) {
                    string = enumeration.nextElement();
                    property2.setValue(string, ((FeatureDescriptor)object2).getValue(string));
                }
                property = property2;
            }
            object2 = propertyDescriptorArray[i].getValue("helpID");
            if (object2 != null && object2 instanceof String) {
                property.setValue("helpID", object2);
            }
            if (propertyDescriptorArray[i].isHidden()) {
                arrayList3.add(property);
                continue;
            }
            if (propertyDescriptorArray[i].isExpert()) {
                arrayList2.add(property);
                property.setExpert(true);
                continue;
            }
            arrayList.add(property);
        }
        return new Descriptor(arrayList, arrayList2, arrayList3);
    }

    private void initialization(boolean bl) throws IntrospectionException {
        Object object;
        int n;
        this.setIconBaseWithExtension(ICON_BASE);
        this.setSynchronizeName(true);
        Class<Object> clazz = this.bean.getClass();
        while (!Modifier.isPublic(clazz.getModifiers()) && !this.hasExplicitBeanInfo(clazz)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            clazz = Object.class;
        }
        this.beanInfo = Utilities.getBeanInfo(clazz);
        this.registerName();
        this.setNameSilently(this.getNameForBean());
        BeanDescriptor beanDescriptor = this.beanInfo.getBeanDescriptor();
        String string = beanDescriptor.getShortDescription();
        if (!Utilities.compareObjects((Object)string, (Object)beanDescriptor.getDisplayName())) {
            this.setShortDescription(string);
        }
        EventSetDescriptor[] eventSetDescriptorArray = this.beanInfo.getEventSetDescriptors();
        int n2 = eventSetDescriptorArray.length;
        Method method = null;
        for (n = 0; !(n >= n2 || (method = eventSetDescriptorArray[n].getAddListenerMethod()) != null && method.getName().equals("addPropertyChangeListener") && Modifier.isPublic(method.getModifiers())); ++n) {
        }
        if (n != n2) {
            try {
                object = Beans.getInstanceOf(this.bean, method.getDeclaringClass());
                this.propertyChangeListener = new PropL();
                method.invoke(object, WeakListeners.propertyChange((PropertyChangeListener)this.propertyChangeListener, (Object)object));
                this.removePCLMethod = eventSetDescriptorArray[n].getRemoveListenerMethod();
            }
            catch (Exception exception) {
                Exceptions.attachMessage((Throwable)exception, (String)("Trying to invoke " + method + " where introspected class is " + clazz.getName()));
                NodeOp.warning(exception);
            }
        }
        this.createProperties(this.bean, this.beanInfo);
        object = this.beanInfo.getBeanDescriptor().attributeNames();
        while (object.hasMoreElements()) {
            String string2 = object.nextElement();
            this.setValue(string2, this.beanInfo.getBeanDescriptor().getValue(string2));
        }
        if (!bl && (object = TMUtil.createInstanceCookie(this.bean)) != null) {
            this.getCookieSet().add((Node.Cookie)object);
        }
    }

    private boolean hasExplicitBeanInfo(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        string = string.substring(n + 1);
        String[] stringArray = Introspector.getBeanInfoSearchPath();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i] + '.' + string + "BeanInfo";
            try {
                Class.forName(string2);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return false;
    }

    private void registerName() {
        Class<Object> clazz = this.bean.getClass();
        while (!Modifier.isPublic(clazz.getModifiers())) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            clazz = Object.class;
        }
        try {
            try {
                this.nameGetter = clazz.getMethod("getName", new Class[0]);
                if (this.nameGetter.getReturnType() != String.class) {
                    throw new NoSuchMethodException();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    this.nameGetter = clazz.getMethod("getDisplayName", new Class[0]);
                    if (this.nameGetter.getReturnType() != String.class) {
                        throw new NoSuchMethodException();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    this.nameGetter = null;
                    return;
                }
            }
        }
        catch (SecurityException securityException) {
            NodeOp.exception(securityException);
            this.nameGetter = null;
            return;
        }
        try {
            String string = (String)this.nameGetter.invoke(this.bean, new Object[0]);
        }
        catch (Exception exception) {
            Exceptions.attachMessage((Throwable)exception, (String)("Bad method: " + clazz.getName() + "." + this.nameGetter.getName()));
            Logger.getLogger(BeanNode.class.getName()).log(Level.WARNING, null, exception);
            this.nameGetter = null;
            return;
        }
        try {
            try {
                this.nameSetter = clazz.getMethod("setName", String.class);
                if (this.nameSetter.getReturnType() != Void.TYPE) {
                    throw new NoSuchMethodException();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    this.nameSetter = clazz.getMethod("setDisplayName", String.class);
                    if (this.nameSetter.getReturnType() != Void.TYPE) {
                        throw new NoSuchMethodException();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    this.nameSetter = null;
                }
            }
        }
        catch (SecurityException securityException) {
            NodeOp.exception(securityException);
        }
    }

    private String getNameForBean() {
        if (this.nameGetter != null) {
            try {
                String string = (String)this.nameGetter.invoke(this.bean, new Object[0]);
                return string != null ? string : "";
            }
            catch (Exception exception) {
                NodeOp.warning(exception);
            }
        }
        BeanDescriptor beanDescriptor = this.beanInfo.getBeanDescriptor();
        return beanDescriptor.getDisplayName();
    }

    void setNameSilently(String string) {
        super.setName(string);
    }

    @Override
    public Action getPreferredAction() {
        SystemAction[] systemActionArray = NodeOp.createFromNames(new String[]{"Properties"});
        return systemActionArray.length == 1 ? systemActionArray[0] : null;
    }

    private final class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                BeanNode.this.firePropertyChange(null, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else {
                object = BeanNode.this.beanInfo.getPropertyDescriptors();
                for (int i = 0; i < ((PropertyDescriptor[])object).length; ++i) {
                    if (object[i].isHidden() || !string.equals(object[i].getName())) continue;
                    BeanNode.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    break;
                }
            }
            if (BeanNode.this.synchronizeName && (string == null || string.equals("name") || string.equals("displayName")) && !((String)(object = BeanNode.this.getNameForBean())).equals(BeanNode.this.getName())) {
                BeanNode.this.setNameSilently((String)object);
            }
        }
    }

    public static final class Descriptor {
        public final Node.Property[] property;
        public final Node.Property[] expert;
        public final Node.Property[] hidden;

        Descriptor(List<Node.Property> list, List<Node.Property> list2, List<Node.Property> list3) {
            this.property = new Node.Property[list.size()];
            list.toArray(this.property);
            this.expert = new Node.Property[list2.size()];
            list2.toArray(this.expert);
            this.hidden = new Node.Property[list3.size()];
            list3.toArray(this.hidden);
        }
    }
}

