/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.apache.batik.css.parser.CSSLexicalUnit;
import org.apache.batik.css.parser.CSSSACMediaList;
import org.apache.batik.css.parser.CSSSelectorList;
import org.apache.batik.css.parser.DefaultConditionFactory;
import org.apache.batik.css.parser.DefaultDocumentHandler;
import org.apache.batik.css.parser.DefaultErrorHandler;
import org.apache.batik.css.parser.DefaultSelectorFactory;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.css.parser.ParseException;
import org.apache.batik.css.parser.Scanner;
import org.apache.batik.css.parser.ScannerUtilities;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;

public class Parser
implements ExtendedParser,
Localizable {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.css.parser.resources.Messages";
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.css.parser.resources.Messages", (class$org$apache$batik$css$parser$Parser == null ? (class$org$apache$batik$css$parser$Parser = Parser.class$("org.apache.batik.css.parser.Parser")) : class$org$apache$batik$css$parser$Parser).getClassLoader());
    protected Scanner scanner;
    protected int current;
    protected DocumentHandler documentHandler = DefaultDocumentHandler.INSTANCE;
    protected SelectorFactory selectorFactory = DefaultSelectorFactory.INSTANCE;
    protected ConditionFactory conditionFactory = DefaultConditionFactory.INSTANCE;
    protected ErrorHandler errorHandler = DefaultErrorHandler.INSTANCE;
    protected String pseudoElement;
    protected String documentURI;
    static /* synthetic */ Class class$org$apache$batik$css$parser$Parser;

    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2";
    }

    public void setLocale(Locale locale) throws CSSException {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this.selectorFactory = selectorFactory;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        this.conditionFactory = conditionFactory;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseStyleSheet(InputSource inputSource) throws CSSException, IOException {
        block18: {
            this.scanner = this.createScanner(inputSource);
            try {
                this.documentHandler.startDocument(inputSource);
                this.current = this.scanner.next();
                switch (this.current) {
                    case 30: {
                        if (this.nextIgnoreSpaces() != 19) {
                            this.reportError("charset.string");
                            break;
                        }
                        if (this.nextIgnoreSpaces() != 8) {
                            this.reportError("semicolon");
                        }
                        this.next();
                        break;
                    }
                    case 18: {
                        this.documentHandler.comment(this.scanner.getStringValue());
                    }
                }
                this.skipSpacesAndCDOCDC();
                while (this.current == 28) {
                    this.nextIgnoreSpaces();
                    this.parseImportRule();
                    this.nextIgnoreSpaces();
                }
                while (true) {
                    switch (this.current) {
                        case 33: {
                            this.nextIgnoreSpaces();
                            this.parsePageRule();
                            break;
                        }
                        case 32: {
                            this.nextIgnoreSpaces();
                            this.parseMediaRule();
                            break;
                        }
                        case 31: {
                            this.nextIgnoreSpaces();
                            this.parseFontFaceRule();
                            break;
                        }
                        case 29: {
                            this.nextIgnoreSpaces();
                            this.parseAtRule();
                            break;
                        }
                        case 0: {
                            break block18;
                        }
                        default: {
                            this.parseRuleSet();
                        }
                    }
                    this.skipSpacesAndCDOCDC();
                }
            }
            finally {
                this.documentHandler.endDocument(inputSource);
                this.scanner = null;
            }
        }
    }

    public void parseStyleSheet(String string) throws CSSException, IOException {
        this.parseStyleSheet(new InputSource(string));
    }

    public void parseStyleDeclaration(InputSource inputSource) throws CSSException, IOException {
        this.scanner = this.createScanner(inputSource);
        this.parseStyleDeclarationInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseStyleDeclarationInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        try {
            this.parseStyleDeclaration(false);
        }
        catch (CSSParseException cSSParseException) {
            this.reportError(cSSParseException);
        }
        finally {
            this.scanner = null;
        }
    }

    public void parseRule(InputSource inputSource) throws CSSException, IOException {
        this.scanner = this.createScanner(inputSource);
        this.parseRuleInternal();
    }

    protected void parseRuleInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        this.parseRule();
        this.scanner = null;
    }

    public SelectorList parseSelectors(InputSource inputSource) throws CSSException, IOException {
        this.scanner = this.createScanner(inputSource);
        return this.parseSelectorsInternal();
    }

    protected SelectorList parseSelectorsInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        SelectorList selectorList = this.parseSelectorList();
        this.scanner = null;
        return selectorList;
    }

    public LexicalUnit parsePropertyValue(InputSource inputSource) throws CSSException, IOException {
        this.scanner = this.createScanner(inputSource);
        return this.parsePropertyValueInternal();
    }

    protected LexicalUnit parsePropertyValueInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        LexicalUnit lexicalUnit = null;
        try {
            lexicalUnit = this.parseExpression(false);
        }
        catch (CSSParseException cSSParseException) {
            this.reportError(cSSParseException);
            throw cSSParseException;
        }
        CSSParseException cSSParseException = null;
        if (this.current != 0) {
            cSSParseException = this.createCSSParseException("eof.expected");
        }
        this.scanner = null;
        if (cSSParseException != null) {
            this.errorHandler.fatalError(cSSParseException);
        }
        return lexicalUnit;
    }

    public boolean parsePriority(InputSource inputSource) throws CSSException, IOException {
        this.scanner = this.createScanner(inputSource);
        return this.parsePriorityInternal();
    }

    protected boolean parsePriorityInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        this.scanner = null;
        switch (this.current) {
            case 0: {
                return false;
            }
            case 28: {
                return true;
            }
        }
        this.reportError("token", new Object[]{new Integer(this.current)});
        return false;
    }

    protected void parseRule() {
        switch (this.scanner.getType()) {
            case 28: {
                this.nextIgnoreSpaces();
                this.parseImportRule();
                break;
            }
            case 29: {
                this.nextIgnoreSpaces();
                this.parseAtRule();
                break;
            }
            case 31: {
                this.nextIgnoreSpaces();
                this.parseFontFaceRule();
                break;
            }
            case 32: {
                this.nextIgnoreSpaces();
                this.parseMediaRule();
                break;
            }
            case 33: {
                this.nextIgnoreSpaces();
                this.parsePageRule();
                break;
            }
            default: {
                this.parseRuleSet();
            }
        }
    }

    protected void parseAtRule() {
        this.scanner.scanAtRule();
        this.documentHandler.ignorableAtRule(this.scanner.getStringValue());
        this.nextIgnoreSpaces();
    }

    protected void parseImportRule() {
        CSSSACMediaList cSSSACMediaList;
        String string = null;
        switch (this.current) {
            default: {
                this.reportError("string.or.uri");
                return;
            }
            case 19: 
            case 51: 
        }
        string = this.scanner.getStringValue();
        this.nextIgnoreSpaces();
        if (this.current != 20) {
            cSSSACMediaList = new CSSSACMediaList();
            cSSSACMediaList.append("all");
        } else {
            cSSSACMediaList = this.parseMediaList();
        }
        this.documentHandler.importStyle(string, (SACMediaList)cSSSACMediaList, null);
        if (this.current != 8) {
            this.reportError("semicolon");
        } else {
            this.next();
        }
    }

    protected CSSSACMediaList parseMediaList() {
        CSSSACMediaList cSSSACMediaList = new CSSSACMediaList();
        cSSSACMediaList.append(this.scanner.getStringValue());
        this.nextIgnoreSpaces();
        block3: while (this.current == 6) {
            this.nextIgnoreSpaces();
            switch (this.current) {
                default: {
                    this.reportError("identifier");
                    continue block3;
                }
                case 20: 
            }
            cSSSACMediaList.append(this.scanner.getStringValue());
            this.nextIgnoreSpaces();
        }
        return cSSSACMediaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFontFaceRule() {
        try {
            this.documentHandler.startFontFace();
            if (this.current != 1) {
                this.reportError("left.curly.brace");
            } else {
                this.nextIgnoreSpaces();
                try {
                    this.parseStyleDeclaration(true);
                }
                catch (CSSParseException cSSParseException) {
                    this.reportError(cSSParseException);
                }
            }
        }
        finally {
            this.documentHandler.endFontFace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parsePageRule() {
        String string = null;
        String string2 = null;
        if (this.current == 20) {
            string = this.scanner.getStringValue();
            this.nextIgnoreSpaces();
            if (this.current == 16) {
                this.nextIgnoreSpaces();
                if (this.current != 20) {
                    this.reportError("identifier");
                    return;
                }
                string2 = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
            }
        }
        try {
            this.documentHandler.startPage(string, string2);
            if (this.current != 1) {
                this.reportError("left.curly.brace");
            } else {
                this.nextIgnoreSpaces();
                try {
                    this.parseStyleDeclaration(true);
                }
                catch (CSSParseException cSSParseException) {
                    this.reportError(cSSParseException);
                }
            }
        }
        finally {
            this.documentHandler.endPage(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseMediaRule() {
        if (this.current != 20) {
            this.reportError("identifier");
            return;
        }
        CSSSACMediaList cSSSACMediaList = this.parseMediaList();
        try {
            this.documentHandler.startMedia((SACMediaList)cSSSACMediaList);
            if (this.current != 1) {
                this.reportError("left.curly.brace");
            } else {
                this.nextIgnoreSpaces();
                block6: while (true) {
                    switch (this.current) {
                        case 0: 
                        case 2: {
                            break block6;
                        }
                        default: {
                            this.parseRuleSet();
                            continue block6;
                        }
                    }
                    break;
                }
                this.nextIgnoreSpaces();
            }
        }
        finally {
            this.documentHandler.endMedia((SACMediaList)cSSSACMediaList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRuleSet() {
        SelectorList selectorList = null;
        try {
            selectorList = this.parseSelectorList();
        }
        catch (CSSParseException cSSParseException) {
            this.reportError(cSSParseException);
            return;
        }
        try {
            this.documentHandler.startSelector(selectorList);
            if (this.current != 1) {
                this.reportError("left.curly.brace");
                if (this.current == 2) {
                    this.nextIgnoreSpaces();
                }
            } else {
                this.nextIgnoreSpaces();
                try {
                    this.parseStyleDeclaration(true);
                }
                catch (CSSParseException cSSParseException) {
                    this.reportError(cSSParseException);
                }
            }
        }
        finally {
            this.documentHandler.endSelector(selectorList);
        }
    }

    protected SelectorList parseSelectorList() {
        CSSSelectorList cSSSelectorList = new CSSSelectorList();
        cSSSelectorList.append(this.parseSelector());
        while (this.current == 6) {
            this.nextIgnoreSpaces();
            cSSSelectorList.append(this.parseSelector());
        }
        return cSSSelectorList;
    }

    protected Selector parseSelector() {
        this.pseudoElement = null;
        SimpleSelector simpleSelector = this.parseSimpleSelector();
        block5: while (true) {
            switch (this.current) {
                default: {
                    break block5;
                }
                case 7: 
                case 11: 
                case 13: 
                case 16: 
                case 20: 
                case 27: {
                    if (this.pseudoElement != null) {
                        throw this.createCSSParseException("pseudo.element.position");
                    }
                    simpleSelector = this.selectorFactory.createDescendantSelector((Selector)simpleSelector, this.parseSimpleSelector());
                    continue block5;
                }
                case 4: {
                    if (this.pseudoElement != null) {
                        throw this.createCSSParseException("pseudo.element.position");
                    }
                    this.nextIgnoreSpaces();
                    simpleSelector = this.selectorFactory.createDirectAdjacentSelector((short)1, (Selector)simpleSelector, this.parseSimpleSelector());
                    continue block5;
                }
                case 9: {
                    if (this.pseudoElement != null) {
                        throw this.createCSSParseException("pseudo.element.position");
                    }
                    this.nextIgnoreSpaces();
                    simpleSelector = this.selectorFactory.createChildSelector((Selector)simpleSelector, this.parseSimpleSelector());
                    continue block5;
                }
            }
            break;
        }
        if (this.pseudoElement != null) {
            simpleSelector = this.selectorFactory.createChildSelector((Selector)simpleSelector, (SimpleSelector)this.selectorFactory.createPseudoElementSelector(null, this.pseudoElement));
        }
        return simpleSelector;
    }

    protected SimpleSelector parseSimpleSelector() {
        ElementSelector elementSelector;
        switch (this.current) {
            case 20: {
                elementSelector = this.selectorFactory.createElementSelector(null, this.scanner.getStringValue());
                this.next();
                break;
            }
            case 13: {
                this.next();
            }
            default: {
                elementSelector = this.selectorFactory.createElementSelector(null, null);
            }
        }
        AttributeCondition attributeCondition = null;
        block25: while (true) {
            AttributeCondition attributeCondition2 = null;
            block4 : switch (this.current) {
                case 27: {
                    attributeCondition2 = this.conditionFactory.createIdCondition(this.scanner.getStringValue());
                    this.next();
                    break;
                }
                case 7: {
                    if (this.next() != 20) {
                        throw this.createCSSParseException("identifier");
                    }
                    attributeCondition2 = this.conditionFactory.createClassCondition(null, this.scanner.getStringValue());
                    this.next();
                    break;
                }
                case 11: {
                    if (this.nextIgnoreSpaces() != 20) {
                        throw this.createCSSParseException("identifier");
                    }
                    String string = this.scanner.getStringValue();
                    int n = this.nextIgnoreSpaces();
                    switch (n) {
                        default: {
                            throw this.createCSSParseException("right.bracket");
                        }
                        case 12: {
                            this.nextIgnoreSpaces();
                            attributeCondition2 = this.conditionFactory.createAttributeCondition(string, null, false, null);
                            break block4;
                        }
                        case 3: 
                        case 25: 
                        case 26: 
                    }
                    String string2 = null;
                    switch (this.nextIgnoreSpaces()) {
                        default: {
                            throw this.createCSSParseException("identifier.or.string");
                        }
                        case 19: 
                        case 20: 
                    }
                    string2 = this.scanner.getStringValue();
                    this.nextIgnoreSpaces();
                    if (this.current != 12) {
                        throw this.createCSSParseException("right.bracket");
                    }
                    this.next();
                    switch (n) {
                        case 3: {
                            attributeCondition2 = this.conditionFactory.createAttributeCondition(string, null, false, string2);
                            break block4;
                        }
                        case 26: {
                            attributeCondition2 = this.conditionFactory.createOneOfAttributeCondition(string, null, false, string2);
                            break block4;
                        }
                    }
                    attributeCondition2 = this.conditionFactory.createBeginHyphenAttributeCondition(string, null, false, string2);
                    break;
                }
                case 16: {
                    String string2;
                    switch (this.nextIgnoreSpaces()) {
                        case 20: {
                            string2 = this.scanner.getStringValue();
                            if (this.isPseudoElement(string2)) {
                                if (this.pseudoElement != null) {
                                    throw this.createCSSParseException("duplicate.pseudo.element");
                                }
                                this.pseudoElement = string2;
                            } else {
                                attributeCondition2 = this.conditionFactory.createPseudoClassCondition(null, string2);
                            }
                            this.next();
                            break block4;
                        }
                        case 52: {
                            String string = this.scanner.getStringValue();
                            if (this.nextIgnoreSpaces() != 20) {
                                throw this.createCSSParseException("identifier");
                            }
                            String string3 = this.scanner.getStringValue();
                            if (this.nextIgnoreSpaces() != 15) {
                                throw this.createCSSParseException("right.brace");
                            }
                            if (!string.equalsIgnoreCase("lang")) {
                                throw this.createCSSParseException("pseudo.function");
                            }
                            attributeCondition2 = this.conditionFactory.createLangCondition(string3);
                            this.next();
                            break block4;
                        }
                    }
                    throw this.createCSSParseException("identifier");
                }
                default: {
                    break block25;
                }
            }
            if (attributeCondition2 == null) continue;
            if (attributeCondition == null) {
                attributeCondition = attributeCondition2;
                continue;
            }
            attributeCondition = this.conditionFactory.createAndCondition((Condition)attributeCondition, (Condition)attributeCondition2);
        }
        this.skipSpaces();
        if (attributeCondition != null) {
            elementSelector = this.selectorFactory.createConditionalSelector((SimpleSelector)elementSelector, attributeCondition);
        }
        return elementSelector;
    }

    protected boolean isPseudoElement(String string) {
        switch (string.charAt(0)) {
            case 'A': 
            case 'a': {
                return string.equalsIgnoreCase("after");
            }
            case 'B': 
            case 'b': {
                return string.equalsIgnoreCase("before");
            }
            case 'F': 
            case 'f': {
                return string.equalsIgnoreCase("first-letter") || string.equalsIgnoreCase("first-line");
            }
        }
        return false;
    }

    protected void parseStyleDeclaration(boolean bl) throws CSSException {
        block8: while (true) {
            switch (this.current) {
                case 0: {
                    if (bl) {
                        throw this.createCSSParseException("eof");
                    }
                    return;
                }
                case 2: {
                    if (!bl) {
                        throw this.createCSSParseException("eof.expected");
                    }
                    this.nextIgnoreSpaces();
                    return;
                }
                case 8: {
                    this.nextIgnoreSpaces();
                    continue block8;
                }
                default: {
                    throw this.createCSSParseException("identifier");
                }
                case 20: 
            }
            String string = this.scanner.getStringValue();
            if (this.nextIgnoreSpaces() != 16) {
                throw this.createCSSParseException("colon");
            }
            this.nextIgnoreSpaces();
            LexicalUnit lexicalUnit = null;
            try {
                lexicalUnit = this.parseExpression(false);
            }
            catch (CSSParseException cSSParseException) {
                this.reportError(cSSParseException);
            }
            if (lexicalUnit == null) continue;
            boolean bl2 = false;
            if (this.current == 23) {
                bl2 = true;
                this.nextIgnoreSpaces();
            }
            this.documentHandler.property(string, lexicalUnit, bl2);
        }
    }

    protected LexicalUnit parseExpression(boolean bl) {
        LexicalUnit lexicalUnit;
        LexicalUnit lexicalUnit2 = lexicalUnit = this.parseTerm(null);
        while (true) {
            boolean bl2 = false;
            switch (this.current) {
                case 6: {
                    bl2 = true;
                    lexicalUnit2 = CSSLexicalUnit.createSimple((short)0, lexicalUnit2);
                    this.nextIgnoreSpaces();
                    break;
                }
                case 10: {
                    bl2 = true;
                    lexicalUnit2 = CSSLexicalUnit.createSimple((short)4, lexicalUnit2);
                    this.nextIgnoreSpaces();
                }
            }
            if (bl) {
                if (this.current == 15) {
                    if (bl2) {
                        throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
                    }
                    return lexicalUnit;
                }
                lexicalUnit2 = this.parseTerm(lexicalUnit2);
                continue;
            }
            switch (this.current) {
                case 0: 
                case 2: 
                case 8: 
                case 23: {
                    if (bl2) {
                        throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
                    }
                    return lexicalUnit;
                }
            }
            lexicalUnit2 = this.parseTerm(lexicalUnit2);
        }
    }

    protected LexicalUnit parseTerm(LexicalUnit lexicalUnit) {
        boolean bl = true;
        boolean bl2 = false;
        switch (this.current) {
            case 5: {
                bl = false;
            }
            case 4: {
                this.next();
                bl2 = true;
            }
        }
        switch (this.current) {
            case 24: {
                long l;
                String string = this.scanner.getStringValue();
                if (!bl) {
                    string = "-" + string;
                }
                if ((l = Long.parseLong(string)) >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                    int n = (int)l;
                    this.nextIgnoreSpaces();
                    return CSSLexicalUnit.createInteger(n, lexicalUnit);
                }
            }
            case 54: {
                return CSSLexicalUnit.createFloat((short)14, this.number(bl), lexicalUnit);
            }
            case 42: {
                return CSSLexicalUnit.createFloat((short)23, this.number(bl), lexicalUnit);
            }
            case 45: {
                return CSSLexicalUnit.createFloat((short)21, this.number(bl), lexicalUnit);
            }
            case 44: {
                return CSSLexicalUnit.createFloat((short)22, this.number(bl), lexicalUnit);
            }
            case 46: {
                return CSSLexicalUnit.createFloat((short)17, this.number(bl), lexicalUnit);
            }
            case 37: {
                return CSSLexicalUnit.createFloat((short)19, this.number(bl), lexicalUnit);
            }
            case 38: {
                return CSSLexicalUnit.createFloat((short)20, this.number(bl), lexicalUnit);
            }
            case 39: {
                return CSSLexicalUnit.createFloat((short)18, this.number(bl), lexicalUnit);
            }
            case 36: {
                return CSSLexicalUnit.createFloat((short)15, this.number(bl), lexicalUnit);
            }
            case 35: {
                return CSSLexicalUnit.createFloat((short)16, this.number(bl), lexicalUnit);
            }
            case 47: {
                return CSSLexicalUnit.createFloat((short)28, this.number(bl), lexicalUnit);
            }
            case 48: {
                return CSSLexicalUnit.createFloat((short)30, this.number(bl), lexicalUnit);
            }
            case 49: {
                return CSSLexicalUnit.createFloat((short)29, this.number(bl), lexicalUnit);
            }
            case 43: {
                return CSSLexicalUnit.createFloat((short)32, this.number(bl), lexicalUnit);
            }
            case 40: {
                return CSSLexicalUnit.createFloat((short)31, this.number(bl), lexicalUnit);
            }
            case 41: {
                return CSSLexicalUnit.createFloat((short)33, this.number(bl), lexicalUnit);
            }
            case 50: {
                return CSSLexicalUnit.createFloat((short)34, this.number(bl), lexicalUnit);
            }
            case 34: {
                return this.dimension(bl, lexicalUnit);
            }
            case 52: {
                return this.parseFunction(bl, lexicalUnit);
            }
        }
        if (bl2) {
            throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
        }
        switch (this.current) {
            case 19: {
                String string = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
                return CSSLexicalUnit.createString((short)36, string, lexicalUnit);
            }
            case 20: {
                String string = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
                if (string.equalsIgnoreCase("inherit")) {
                    return CSSLexicalUnit.createSimple((short)12, lexicalUnit);
                }
                return CSSLexicalUnit.createString((short)35, string, lexicalUnit);
            }
            case 51: {
                String string = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
                return CSSLexicalUnit.createString((short)24, string, lexicalUnit);
            }
            case 27: {
                return this.hexcolor(lexicalUnit);
            }
        }
        throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
    }

    protected LexicalUnit parseFunction(boolean bl, LexicalUnit lexicalUnit) {
        String string = this.scanner.getStringValue();
        this.nextIgnoreSpaces();
        LexicalUnit lexicalUnit2 = this.parseExpression(true);
        if (this.current != 15) {
            throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
        }
        this.nextIgnoreSpaces();
        block0 : switch (string.charAt(0)) {
            case 'R': 
            case 'r': {
                LexicalUnit lexicalUnit3;
                if (string.equalsIgnoreCase("rgb")) {
                    LexicalUnit lexicalUnit4 = lexicalUnit2;
                    if (lexicalUnit4 == null) break;
                    switch (lexicalUnit4.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 13: 
                        case 23: 
                    }
                    lexicalUnit4 = lexicalUnit4.getNextLexicalUnit();
                    if (lexicalUnit4 == null) break;
                    switch (lexicalUnit4.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 0: 
                    }
                    lexicalUnit4 = lexicalUnit4.getNextLexicalUnit();
                    if (lexicalUnit4 == null) break;
                    switch (lexicalUnit4.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 13: 
                        case 23: 
                    }
                    lexicalUnit4 = lexicalUnit4.getNextLexicalUnit();
                    if (lexicalUnit4 == null) break;
                    switch (lexicalUnit4.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 0: 
                    }
                    lexicalUnit4 = lexicalUnit4.getNextLexicalUnit();
                    if (lexicalUnit4 == null) break;
                    switch (lexicalUnit4.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 13: 
                        case 23: 
                    }
                    lexicalUnit4 = lexicalUnit4.getNextLexicalUnit();
                    if (lexicalUnit4 != null) break;
                    return CSSLexicalUnit.createPredefinedFunction((short)27, lexicalUnit2, lexicalUnit);
                }
                if (!string.equalsIgnoreCase("rect") || (lexicalUnit3 = lexicalUnit2) == null) break;
                switch (lexicalUnit3.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 13: {
                        if (lexicalUnit3.getIntegerValue() != 0) break block0;
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                        break;
                    }
                    case 35: {
                        if (!lexicalUnit3.getStringValue().equalsIgnoreCase("auto")) break block0;
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                    }
                }
                if (lexicalUnit3 == null) break;
                switch (lexicalUnit3.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 0: 
                }
                lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                if (lexicalUnit3 == null) break;
                switch (lexicalUnit3.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 13: {
                        if (lexicalUnit3.getIntegerValue() != 0) break block0;
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                        break;
                    }
                    case 35: {
                        if (!lexicalUnit3.getStringValue().equalsIgnoreCase("auto")) break block0;
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                    }
                }
                if (lexicalUnit3 == null) break;
                switch (lexicalUnit3.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 0: 
                }
                lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                if (lexicalUnit3 == null) break;
                switch (lexicalUnit3.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 13: {
                        if (lexicalUnit3.getIntegerValue() != 0) break block0;
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                        break;
                    }
                    case 35: {
                        if (!lexicalUnit3.getStringValue().equalsIgnoreCase("auto")) break block0;
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                    }
                }
                if (lexicalUnit3 == null) break;
                switch (lexicalUnit3.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 0: 
                }
                lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                if (lexicalUnit3 == null) break;
                switch (lexicalUnit3.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 13: {
                        if (lexicalUnit3.getIntegerValue() != 0) break block0;
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                        break;
                    }
                    case 35: {
                        if (!lexicalUnit3.getStringValue().equalsIgnoreCase("auto")) break block0;
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                    }
                }
                if (lexicalUnit3 != null) break;
                return CSSLexicalUnit.createPredefinedFunction((short)38, lexicalUnit2, lexicalUnit);
            }
            case 'C': 
            case 'c': {
                LexicalUnit lexicalUnit5;
                if (string.equalsIgnoreCase("counter")) {
                    LexicalUnit lexicalUnit6 = lexicalUnit2;
                    if (lexicalUnit6 == null) break;
                    switch (lexicalUnit6.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 35: 
                    }
                    lexicalUnit6 = lexicalUnit6.getNextLexicalUnit();
                    if (lexicalUnit6 == null) break;
                    switch (lexicalUnit6.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 0: 
                    }
                    lexicalUnit6 = lexicalUnit6.getNextLexicalUnit();
                    if (lexicalUnit6 == null) break;
                    switch (lexicalUnit6.getLexicalUnitType()) {
                        default: {
                            break block0;
                        }
                        case 35: 
                    }
                    lexicalUnit6 = lexicalUnit6.getNextLexicalUnit();
                    if (lexicalUnit6 != null) break;
                    return CSSLexicalUnit.createPredefinedFunction((short)25, lexicalUnit2, lexicalUnit);
                }
                if (!string.equalsIgnoreCase("counters") || (lexicalUnit5 = lexicalUnit2) == null) break;
                switch (lexicalUnit5.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 35: 
                }
                lexicalUnit5 = lexicalUnit5.getNextLexicalUnit();
                if (lexicalUnit5 == null) break;
                switch (lexicalUnit5.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 0: 
                }
                lexicalUnit5 = lexicalUnit5.getNextLexicalUnit();
                if (lexicalUnit5 == null) break;
                switch (lexicalUnit5.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 36: 
                }
                lexicalUnit5 = lexicalUnit5.getNextLexicalUnit();
                if (lexicalUnit5 == null) break;
                switch (lexicalUnit5.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 0: 
                }
                lexicalUnit5 = lexicalUnit5.getNextLexicalUnit();
                if (lexicalUnit5 == null) break;
                switch (lexicalUnit5.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 35: 
                }
                lexicalUnit5 = lexicalUnit5.getNextLexicalUnit();
                if (lexicalUnit5 != null) break;
                return CSSLexicalUnit.createPredefinedFunction((short)26, lexicalUnit2, lexicalUnit);
            }
            case 'A': 
            case 'a': {
                LexicalUnit lexicalUnit7;
                if (!string.equalsIgnoreCase("attr") || (lexicalUnit7 = lexicalUnit2) == null) break;
                switch (lexicalUnit7.getLexicalUnitType()) {
                    default: {
                        break block0;
                    }
                    case 35: 
                }
                lexicalUnit7 = lexicalUnit7.getNextLexicalUnit();
                if (lexicalUnit7 != null) break;
                return CSSLexicalUnit.createString((short)37, lexicalUnit2.getStringValue(), lexicalUnit);
            }
        }
        return CSSLexicalUnit.createFunction(string, lexicalUnit2, lexicalUnit);
    }

    protected LexicalUnit hexcolor(LexicalUnit lexicalUnit) {
        String string = this.scanner.getStringValue();
        int n = string.length();
        CSSLexicalUnit cSSLexicalUnit = null;
        switch (n) {
            case 3: {
                char c = Character.toLowerCase(string.charAt(0));
                char c2 = Character.toLowerCase(string.charAt(1));
                char c3 = Character.toLowerCase(string.charAt(2));
                if (!(ScannerUtilities.isCSSHexadecimalCharacter(c) && ScannerUtilities.isCSSHexadecimalCharacter(c2) && ScannerUtilities.isCSSHexadecimalCharacter(c3))) {
                    throw this.createCSSParseException("rgb.color", new Object[]{string});
                }
                int n2 = c >= '0' && c <= '9' ? c - 48 : c - 97 + 10;
                int n3 = n2;
                n3 |= (n2 <<= 4);
                n2 = c2 >= '0' && c2 <= '9' ? c2 - 48 : c2 - 97 + 10;
                int n4 = n2;
                n2 = c3 >= '0' && c3 <= '9' ? c3 - 48 : c3 - 97 + 10;
                int n5 = n2;
                cSSLexicalUnit = CSSLexicalUnit.createInteger(n3, null);
                CSSLexicalUnit cSSLexicalUnit2 = CSSLexicalUnit.createSimple((short)0, cSSLexicalUnit);
                cSSLexicalUnit2 = CSSLexicalUnit.createInteger(n4 |= (n2 <<= 4), cSSLexicalUnit2);
                cSSLexicalUnit2 = CSSLexicalUnit.createSimple((short)0, cSSLexicalUnit2);
                cSSLexicalUnit2 = CSSLexicalUnit.createInteger(n5 |= (n2 <<= 4), cSSLexicalUnit2);
                break;
            }
            case 6: {
                char c = Character.toLowerCase(string.charAt(0));
                char c4 = Character.toLowerCase(string.charAt(1));
                char c5 = Character.toLowerCase(string.charAt(2));
                char c6 = Character.toLowerCase(string.charAt(3));
                char c7 = Character.toLowerCase(string.charAt(4));
                char c8 = Character.toLowerCase(string.charAt(5));
                if (!(ScannerUtilities.isCSSHexadecimalCharacter(c) && ScannerUtilities.isCSSHexadecimalCharacter(c4) && ScannerUtilities.isCSSHexadecimalCharacter(c5) && ScannerUtilities.isCSSHexadecimalCharacter(c6) && ScannerUtilities.isCSSHexadecimalCharacter(c7) && ScannerUtilities.isCSSHexadecimalCharacter(c8))) {
                    throw this.createCSSParseException("rgb.color");
                }
                int n6 = c >= '0' && c <= '9' ? c - 48 : c - 97 + 10;
                n6 <<= 4;
                n6 |= c4 >= '0' && c4 <= '9' ? c4 - 48 : c4 - 97 + 10;
                int n7 = c5 >= '0' && c5 <= '9' ? c5 - 48 : c5 - 97 + 10;
                n7 <<= 4;
                n7 |= c6 >= '0' && c6 <= '9' ? c6 - 48 : c6 - 97 + 10;
                int n8 = c7 >= '0' && c7 <= '9' ? c7 - 48 : c7 - 97 + 10;
                n8 <<= 4;
                int n9 = c8 >= '0' && c8 <= '9' ? c8 - 48 : c8 - 97 + 10;
                cSSLexicalUnit = CSSLexicalUnit.createInteger(n6, null);
                CSSLexicalUnit cSSLexicalUnit3 = CSSLexicalUnit.createSimple((short)0, cSSLexicalUnit);
                cSSLexicalUnit3 = CSSLexicalUnit.createInteger(n7, cSSLexicalUnit3);
                cSSLexicalUnit3 = CSSLexicalUnit.createSimple((short)0, cSSLexicalUnit3);
                cSSLexicalUnit3 = CSSLexicalUnit.createInteger(n8 |= n9, cSSLexicalUnit3);
                break;
            }
            default: {
                throw this.createCSSParseException("rgb.color", new Object[]{string});
            }
        }
        this.nextIgnoreSpaces();
        return CSSLexicalUnit.createPredefinedFunction((short)27, cSSLexicalUnit, lexicalUnit);
    }

    protected Scanner createScanner(InputSource inputSource) {
        Reader reader;
        this.documentURI = inputSource.getURI();
        if (this.documentURI == null) {
            this.documentURI = "";
        }
        if ((reader = inputSource.getCharacterStream()) != null) {
            return new Scanner(reader);
        }
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            return new Scanner(inputStream, inputSource.getEncoding());
        }
        String string = inputSource.getURI();
        if (string == null) {
            throw new CSSException(this.formatMessage("empty.source", null));
        }
        try {
            ParsedURL parsedURL = new ParsedURL(string);
            inputStream = parsedURL.openStreamRaw("text/css");
            return new Scanner(inputStream, inputSource.getEncoding());
        }
        catch (IOException iOException) {
            throw new CSSException((Exception)iOException);
        }
    }

    protected int skipSpaces() {
        int n = this.scanner.getType();
        while (n == 17) {
            n = this.next();
        }
        return n;
    }

    protected int skipSpacesAndCDOCDC() {
        block3: while (true) {
            switch (this.current) {
                default: {
                    break block3;
                }
                case 17: 
                case 18: 
                case 21: 
                case 22: {
                    this.scanner.clearBuffer();
                    this.next();
                    continue block3;
                }
            }
            break;
        }
        return this.current;
    }

    protected float number(boolean bl) {
        try {
            float f = bl ? 1.0f : -1.0f;
            String string = this.scanner.getStringValue();
            this.nextIgnoreSpaces();
            return f * Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createCSSParseException("number.format");
        }
    }

    protected LexicalUnit dimension(boolean bl, LexicalUnit lexicalUnit) {
        try {
            int n;
            float f = bl ? 1.0f : -1.0f;
            String string = this.scanner.getStringValue();
            block5: for (n = 0; n < string.length(); ++n) {
                switch (string.charAt(n)) {
                    default: {
                        break block5;
                    }
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        continue block5;
                    }
                }
            }
            this.nextIgnoreSpaces();
            return CSSLexicalUnit.createDimension(f * Float.parseFloat(string.substring(0, n)), string.substring(n), lexicalUnit);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createCSSParseException("number.format");
        }
    }

    protected int next() {
        try {
            while (true) {
                this.scanner.clearBuffer();
                this.current = this.scanner.next();
                if (this.current != 18) break;
                this.documentHandler.comment(this.scanner.getStringValue());
            }
            return this.current;
        }
        catch (ParseException parseException) {
            this.reportError(parseException.getMessage());
            return this.current;
        }
    }

    protected int nextIgnoreSpaces() {
        try {
            block6: while (true) {
                this.scanner.clearBuffer();
                this.current = this.scanner.next();
                switch (this.current) {
                    case 18: {
                        this.documentHandler.comment(this.scanner.getStringValue());
                        continue block6;
                    }
                    default: {
                        break block6;
                    }
                    case 17: {
                        continue block6;
                    }
                }
                break;
            }
            return this.current;
        }
        catch (ParseException parseException) {
            this.errorHandler.error(this.createCSSParseException(parseException.getMessage()));
            return this.current;
        }
    }

    protected void reportError(String string) {
        this.reportError(string, null);
    }

    protected void reportError(String string, Object[] objectArray) {
        this.reportError(this.createCSSParseException(string, objectArray));
    }

    protected void reportError(CSSParseException cSSParseException) {
        this.errorHandler.error(cSSParseException);
        int n = 1;
        while (true) {
            switch (this.current) {
                case 0: {
                    return;
                }
                case 2: 
                case 8: {
                    if (--n == 0) {
                        this.nextIgnoreSpaces();
                        return;
                    }
                }
                case 1: {
                    ++n;
                }
            }
            this.nextIgnoreSpaces();
        }
    }

    protected CSSParseException createCSSParseException(String string) {
        return this.createCSSParseException(string, null);
    }

    protected CSSParseException createCSSParseException(String string, Object[] objectArray) {
        return new CSSParseException(this.formatMessage(string, objectArray), this.documentURI, this.scanner.getLine(), this.scanner.getColumn());
    }

    public void parseStyleDeclaration(String string) throws CSSException, IOException {
        this.scanner = new Scanner(string);
        this.parseStyleDeclarationInternal();
    }

    public void parseRule(String string) throws CSSException, IOException {
        this.scanner = new Scanner(string);
        this.parseRuleInternal();
    }

    public SelectorList parseSelectors(String string) throws CSSException, IOException {
        this.scanner = new Scanner(string);
        return this.parseSelectorsInternal();
    }

    public LexicalUnit parsePropertyValue(String string) throws CSSException, IOException {
        this.scanner = new Scanner(string);
        return this.parsePropertyValueInternal();
    }

    public boolean parsePriority(String string) throws CSSException, IOException {
        this.scanner = new Scanner(string);
        return this.parsePriorityInternal();
    }

    public SACMediaList parseMedia(String string) throws CSSException, IOException {
        CSSSACMediaList cSSSACMediaList = new CSSSACMediaList();
        if (!"all".equalsIgnoreCase(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                cSSSACMediaList.append(stringTokenizer.nextToken());
            }
        }
        return cSSSACMediaList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

