/* libecal-2.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "ECal", gir_namespace = "ECal", gir_version = "2.0", lower_case_cprefix = "e_cal_")]
namespace ECal {
	[CCode (cheader_filename = "libecal/libecal.h", type_id = "e_cal_client_get_type ()")]
	[Version (since = "3.2")]
	public class Client : E.Client, ECal.TimezoneCache, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Client ();
		public async bool add_timezone (ICal.Timezone zone, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool add_timezone_sync (ICal.Timezone zone, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool check_one_alarm_only ();
		public bool check_organizer_must_accept ();
		public bool check_organizer_must_attend ();
		public bool check_recurrences_no_master ();
		public bool check_save_schedules ();
		[Version (since = "3.34")]
		public static bool check_timezones_sync (ICal.Component vcalendar, GLib.SList<ICal.Component>? icalcomps, [CCode (delegate_target_pos = 3.5)] ECal.RecurResolveTimezoneCb? tzlookup, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.8")]
		public static async E.Client? connect (E.Source source, ECal.ClientSourceType source_type, uint32 wait_for_connected_seconds, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.8")]
		public static E.Client? connect_sync (E.Source source, ECal.ClientSourceType source_type, uint32 wait_for_connected_seconds, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool create_object (ICal.Component icalcomp, ECal.OperationFlags opflags, GLib.Cancellable? cancellable, out string? out_uid) throws GLib.Error;
		public bool create_object_sync (ICal.Component icalcomp, ECal.OperationFlags opflags, out string? out_uid, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.6")]
		public async bool create_objects (GLib.SList<ICal.Component> icalcomps, ECal.OperationFlags opflags, GLib.Cancellable? cancellable, out GLib.SList<string> out_uids) throws GLib.Error;
		[Version (since = "3.6")]
		public bool create_objects_sync (GLib.SList<ICal.Component> icalcomps, ECal.OperationFlags opflags, out GLib.SList<string>? out_uids, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool discard_alarm (string uid, string? rid, string auid, ECal.OperationFlags opflags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool discard_alarm_sync (string uid, string? rid, string auid, ECal.OperationFlags opflags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public static GLib.Error error_create (ECal.ClientError code, string? custom_msg);
		public static GLib.Quark error_quark ();
		public static unowned string error_to_string (ECal.ClientError code);
		public void generate_instances (long start, long end, GLib.Cancellable? cancellable, owned ECal.RecurInstanceCb cb);
		public void generate_instances_for_object (ICal.Component icalcomp, long start, long end, GLib.Cancellable? cancellable, owned ECal.RecurInstanceCb cb);
		public void generate_instances_for_object_sync (ICal.Component icalcomp, long start, long end, GLib.Cancellable? cancellable, ECal.RecurInstanceCb cb);
		public void generate_instances_sync (long start, long end, GLib.Cancellable? cancellable, ECal.RecurInstanceCb cb);
		public async bool get_attachment_uris (string uid, string? rid, GLib.Cancellable? cancellable, out GLib.SList<string> out_attachment_uris) throws GLib.Error;
		public bool get_attachment_uris_sync (string uid, string? rid, out GLib.SList<string> out_attachment_uris, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public string? get_component_as_string (ICal.Component icalcomp);
		public async bool get_default_object (GLib.Cancellable? cancellable, out ICal.Component out_icalcomp) throws GLib.Error;
		public bool get_default_object_sync (out ICal.Component out_icalcomp, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned ICal.Timezone get_default_timezone ();
		public async bool get_free_busy (long start, long end, GLib.SList<string> users, GLib.Cancellable? cancellable, out GLib.SList<ECal.Component> out_freebusy) throws GLib.Error;
		public bool get_free_busy_sync (long start, long end, GLib.SList<string> users, out GLib.SList<ECal.Component> out_freebusy, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned string get_local_attachment_store ();
		public async bool get_object (string uid, string? rid, GLib.Cancellable? cancellable, out ICal.Component out_icalcomp) throws GLib.Error;
		public async bool get_object_list (string sexp, GLib.Cancellable? cancellable, out GLib.SList<ICal.Component> out_icalcomps) throws GLib.Error;
		public async bool get_object_list_as_comps (string sexp, GLib.Cancellable? cancellable, out GLib.SList<ECal.Component> out_ecalcomps) throws GLib.Error;
		public bool get_object_list_as_comps_sync (string sexp, out GLib.SList<ECal.Component> out_ecalcomps, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool get_object_list_sync (string sexp, out GLib.SList<ICal.Component> out_icalcomps, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool get_object_sync (string uid, string? rid, out ICal.Component out_icalcomp, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool get_objects_for_uid (string uid, GLib.Cancellable? cancellable, out GLib.SList<ECal.Component> out_ecalcomps) throws GLib.Error;
		public bool get_objects_for_uid_sync (string uid, out GLib.SList<ECal.Component> out_ecalcomps, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ECal.ClientSourceType get_source_type ();
		public async bool get_timezone (string tzid, GLib.Cancellable? cancellable, out unowned ICal.Timezone out_zone) throws GLib.Error;
		public bool get_timezone_sync (string tzid, out unowned ICal.Timezone out_zone, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool get_view (string sexp, GLib.Cancellable? cancellable, out ECal.ClientView out_view) throws GLib.Error;
		public bool get_view_sync (string sexp, out ECal.ClientView out_view, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool modify_object (ICal.Component icalcomp, ECal.ObjModType mod, ECal.OperationFlags opflags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool modify_object_sync (ICal.Component icalcomp, ECal.ObjModType mod, ECal.OperationFlags opflags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.6")]
		public async bool modify_objects (GLib.SList<ICal.Component> icalcomps, ECal.ObjModType mod, ECal.OperationFlags opflags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.6")]
		public bool modify_objects_sync (GLib.SList<ICal.Component> icalcomps, ECal.ObjModType mod, ECal.OperationFlags opflags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool receive_objects (ICal.Component icalcomp, ECal.OperationFlags opflags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool receive_objects_sync (ICal.Component icalcomp, ECal.OperationFlags opflags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool remove_object (string uid, string? rid, ECal.ObjModType mod, ECal.OperationFlags opflags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool remove_object_sync (string uid, string? rid, ECal.ObjModType mod, ECal.OperationFlags opflags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.6")]
		public async bool remove_objects (GLib.SList<ECal.ComponentId> ids, ECal.ObjModType mod, ECal.OperationFlags opflags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.6")]
		public bool remove_objects_sync (GLib.SList<ECal.ComponentId> ids, ECal.ObjModType mod, ECal.OperationFlags opflags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool send_objects (ICal.Component icalcomp, ECal.OperationFlags opflags, GLib.Cancellable? cancellable, out GLib.SList<string> out_users, out ICal.Component out_modified_icalcomp) throws GLib.Error;
		public bool send_objects_sync (ICal.Component icalcomp, ECal.OperationFlags opflags, out GLib.SList<string> out_users, out ICal.Component out_modified_icalcomp, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void set_default_timezone (ICal.Timezone zone);
		[Version (since = "3.34")]
		public static unowned ICal.Timezone? tzlookup_cb (string tzid, ECal.Client ecalclient, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.34")]
		public static unowned ICal.Timezone? tzlookup_icalcomp_cb (string tzid, ECal.ClientTzlookupICalCompData lookup_data, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ICal.Timezone default_timezone { get; set; }
		public ECal.ClientSourceType source_type { get; construct; }
		public signal void free_busy_data (GLib.SList<ECal.Component> free_busy_ecalcomps);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", lower_case_csuffix = "client_tzlookup_icalcomp_data", type_id = "e_cal_client_tzlookup_icalcomp_data_get_type ()")]
	[Compact]
	[Version (since = "3.34")]
	public class ClientTzlookupICalCompData {
		[CCode (has_construct_function = false)]
		public ClientTzlookupICalCompData (ICal.Component icomp);
		public ECal.ClientTzlookupICalCompData? copy ();
		public void free ();
		public unowned ICal.Component get_icalcomponent ();
	}
	[CCode (cheader_filename = "libecal/libecal.h", type_id = "e_cal_client_view_get_type ()")]
	[Version (since = "3.2")]
	public class ClientView : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected ClientView ();
		[Version (since = "3.8")]
		public unowned GLib.DBusConnection get_connection ();
		[Version (since = "3.8")]
		public unowned string get_object_path ();
		public bool is_running ();
		[Version (since = "3.10")]
		public ECal.Client ref_client ();
		public void set_fields_of_interest (GLib.SList<string>? fields_of_interest) throws GLib.Error;
		[Version (since = "3.6")]
		public void set_flags (ECal.ClientViewFlags flags) throws GLib.Error;
		public void start () throws GLib.Error;
		public void stop () throws GLib.Error;
		[NoAccessorMethod]
		public ECal.Client client { owned get; construct; }
		public GLib.DBusConnection connection { get; construct; }
		public string object_path { get; construct; }
		public virtual signal void complete (GLib.Error error);
		public signal void objects_added (GLib.SList<ICal.Component> objects);
		public signal void objects_modified (GLib.SList<ICal.Component> objects);
		public signal void objects_removed (GLib.SList<ECal.ComponentId> uids);
		public virtual signal void progress (uint percent, string message);
	}
	[CCode (cheader_filename = "libecal/libecal.h", type_id = "e_cal_component_get_type ()")]
	public class Component : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public Component ();
		[Version (since = "3.34")]
		public void abort_sequence ();
		[Version (since = "3.34")]
		public void add_alarm (ECal.ComponentAlarm alarm);
		[Version (since = "3.34")]
		public ECal.Component clone ();
		[Version (since = "3.34")]
		public void commit_sequence ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public Component.from_icalcomponent (owned ICal.Component icalcomp);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public Component.from_string (string calobj);
		[Version (since = "3.34")]
		public ECal.ComponentAlarm? get_alarm (string auid);
		[Version (since = "3.34")]
		public GLib.SList<string>? get_alarm_uids ();
		[Version (since = "3.34")]
		public GLib.SList<ECal.ComponentAlarm>? get_all_alarms ();
		[Version (since = "3.34")]
		public string get_as_string ();
		[Version (since = "3.34")]
		public GLib.SList<ICal.Attach>? get_attachments ();
		[Version (since = "3.34")]
		public GLib.SList<ECal.ComponentAttendee>? get_attendees ();
		[Version (since = "3.34")]
		public string? get_categories ();
		[Version (since = "3.34")]
		public GLib.SList<string>? get_categories_list ();
		[Version (since = "3.34")]
		public ECal.ComponentClassification get_classification ();
		[Version (since = "3.34")]
		public GLib.SList<ECal.ComponentText>? get_comments ();
		[Version (since = "3.34")]
		public ICal.Time get_completed ();
		[Version (since = "3.34")]
		public GLib.SList<ECal.ComponentText> get_contacts ();
		[Version (since = "3.34")]
		public ICal.Time get_created ();
		[Version (since = "3.34")]
		public GLib.SList<ECal.ComponentText>? get_descriptions ();
		[Version (since = "3.34")]
		public ECal.ComponentDateTime? get_dtend ();
		[Version (since = "3.34")]
		public ICal.Time? get_dtstamp ();
		[Version (since = "3.34")]
		public ECal.ComponentDateTime? get_dtstart ();
		[Version (since = "3.34")]
		public ECal.ComponentDateTime? get_due ();
		[Version (since = "3.34")]
		public GLib.SList<ECal.ComponentDateTime>? get_exdates ();
		[Version (since = "3.34")]
		public GLib.SList<ICal.Property>? get_exrule_properties ();
		[Version (since = "3.34")]
		public GLib.SList<ICal.Recurrence>? get_exrules ();
		[Version (since = "3.34")]
		public ICal.Geo? get_geo ();
		[Version (since = "3.34")]
		public unowned ICal.Component? get_icalcomponent ();
		[Version (since = "3.34")]
		public ECal.ComponentId get_id ();
		[Version (since = "3.34")]
		public ICal.Time get_last_modified ();
		[Version (since = "3.34")]
		public string? get_location ();
		[Version (since = "3.34")]
		public ECal.ComponentOrganizer? get_organizer ();
		[Version (since = "3.34")]
		public int get_percent_complete ();
		[Version (since = "3.34")]
		public int get_priority ();
		[Version (since = "3.34")]
		public GLib.SList<ECal.ComponentPeriod>? get_rdates ();
		[Version (since = "3.34")]
		public ECal.ComponentRange? get_recurid ();
		[Version (since = "3.34")]
		public string get_recurid_as_string ();
		[Version (since = "3.34")]
		public GLib.SList<ICal.Property>? get_rrule_properties ();
		[Version (since = "3.34")]
		public GLib.SList<ICal.Recurrence>? get_rrules ();
		[Version (since = "3.34")]
		public int get_sequence ();
		[Version (since = "3.34")]
		public ICal.PropertyStatus get_status ();
		[Version (since = "3.34")]
		public ECal.ComponentText? get_summary ();
		[Version (since = "3.34")]
		public ECal.ComponentTransparency get_transparency ();
		[Version (since = "3.34")]
		public unowned string get_uid ();
		[Version (since = "3.34")]
		public string? get_url ();
		[Version (since = "3.34")]
		public ECal.ComponentVType get_vtype ();
		[Version (since = "3.34")]
		public bool has_alarms ();
		[Version (since = "3.34")]
		public bool has_attachments ();
		[Version (since = "3.34")]
		public bool has_attendees ();
		[Version (since = "3.34")]
		public bool has_exceptions ();
		[Version (since = "3.34")]
		public bool has_exdates ();
		[Version (since = "3.34")]
		public bool has_exrules ();
		[Version (since = "3.34")]
		public bool has_organizer ();
		[Version (since = "3.34")]
		public bool has_rdates ();
		[Version (since = "3.34")]
		public bool has_recurrences ();
		[Version (since = "3.34")]
		public bool has_rrules ();
		[Version (since = "3.34")]
		public bool has_simple_recurrence ();
		[Version (since = "3.34")]
		public bool is_instance ();
		[Version (since = "3.34")]
		public void remove_alarm (string auid);
		[Version (since = "3.34")]
		public void remove_all_alarms ();
		[Version (since = "3.34")]
		public void set_attachments (GLib.SList<ICal.Attach>? attachments);
		[Version (since = "3.34")]
		public void set_attendees (GLib.SList<ECal.ComponentAttendee>? attendee_list);
		[Version (since = "3.34")]
		public void set_categories (string categories);
		[Version (since = "3.34")]
		public void set_categories_list (GLib.SList<string> categ_list);
		[Version (since = "3.34")]
		public void set_classification (ECal.ComponentClassification classif);
		[Version (since = "3.34")]
		public void set_comments (GLib.SList<ECal.ComponentText> text_list);
		[Version (since = "3.34")]
		public void set_completed (ICal.Time? tt);
		[Version (since = "3.34")]
		public void set_contacts (GLib.SList<ECal.ComponentText> text_list);
		[Version (since = "3.34")]
		public void set_created (ICal.Time? tt);
		[Version (since = "3.34")]
		public void set_descriptions (GLib.SList<ECal.ComponentText> text_list);
		[Version (since = "3.34")]
		public void set_dtend (ECal.ComponentDateTime? dt);
		[Version (since = "3.34")]
		public void set_dtstamp (ICal.Time tt);
		[Version (since = "3.34")]
		public void set_dtstart (ECal.ComponentDateTime? dt);
		[Version (since = "3.34")]
		public void set_due (ECal.ComponentDateTime? dt);
		[Version (since = "3.34")]
		public void set_exdates (GLib.SList<ECal.ComponentDateTime>? exdate_list);
		[Version (since = "3.34")]
		public void set_exrules (GLib.SList<ICal.Recurrence>? recur_list);
		[Version (since = "3.34")]
		public void set_geo (ICal.Geo? geo);
		[Version (since = "3.34")]
		public bool set_icalcomponent (owned ICal.Component? icalcomp);
		[Version (since = "3.34")]
		public void set_last_modified (ICal.Time? tt);
		[Version (since = "3.34")]
		public void set_location (string? location);
		[Version (since = "3.34")]
		public void set_new_vtype (ECal.ComponentVType type);
		[Version (since = "3.34")]
		public void set_organizer (ECal.ComponentOrganizer? organizer);
		[Version (since = "3.34")]
		public void set_percent_complete (int percent);
		[Version (since = "3.34")]
		public void set_priority (int priority);
		[Version (since = "3.34")]
		public void set_rdates (GLib.SList<ECal.ComponentPeriod>? rdate_list);
		[Version (since = "3.34")]
		public void set_recurid (ECal.ComponentRange? recur_id);
		[Version (since = "3.34")]
		public void set_rrules (GLib.SList<ICal.Recurrence>? recur_list);
		[Version (since = "3.34")]
		public void set_sequence (int sequence);
		[Version (since = "3.34")]
		public void set_status (ICal.PropertyStatus status);
		[Version (since = "3.34")]
		public void set_summary (ECal.ComponentText summary);
		[Version (since = "3.34")]
		public void set_transparency (ECal.ComponentTransparency transp);
		[Version (since = "3.34")]
		public void set_uid (string uid);
		[Version (since = "3.34")]
		public void set_url (string? url);
		[Version (since = "3.34")]
		public void strip_errors ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public Component.vtype (ECal.ComponentVType vtype);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_alarm_get_type ()")]
	[Compact]
	public class ComponentAlarm {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAlarm ();
		[Version (since = "3.34")]
		public ECal.ComponentAlarm copy ();
		[Version (since = "3.34")]
		public void fill_component (ICal.Component component);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAlarm.from_component (ICal.Component component);
		[Version (since = "3.40")]
		public unowned ICal.Time? get_acknowledged ();
		[Version (since = "3.34")]
		public ECal.ComponentAlarmAction get_action ();
		[Version (since = "3.34")]
		public ICal.Component get_as_component ();
		[Version (since = "3.34")]
		public unowned GLib.SList<ICal.Attach>? get_attachments ();
		[Version (since = "3.34")]
		public unowned GLib.SList<ECal.ComponentAttendee>? get_attendees ();
		[Version (since = "3.34")]
		public unowned ECal.ComponentText? get_description ();
		[Version (since = "3.34")]
		public unowned ECal.ComponentPropertyBag get_property_bag ();
		[Version (since = "3.34")]
		public unowned ECal.ComponentAlarmRepeat? get_repeat ();
		[Version (since = "3.34")]
		public unowned ECal.ComponentText? get_summary ();
		[Version (since = "3.34")]
		public unowned ECal.ComponentAlarmTrigger? get_trigger ();
		[Version (since = "3.34")]
		public unowned string? get_uid ();
		[Version (since = "3.34")]
		public bool has_attachments ();
		[Version (since = "3.34")]
		public bool has_attendees ();
		[Version (since = "3.40")]
		public void set_acknowledged (ICal.Time? when);
		[Version (since = "3.34")]
		public void set_action (ECal.ComponentAlarmAction action);
		[Version (since = "3.34")]
		public void set_attachments (GLib.SList<ICal.Attach>? attachments);
		[Version (since = "3.34")]
		public void set_attendees (GLib.SList<ECal.ComponentAttendee>? attendees);
		[Version (since = "3.34")]
		public void set_description (ECal.ComponentText? description);
		[Version (since = "3.34")]
		public void set_from_component (ICal.Component component);
		[Version (since = "3.34")]
		public void set_repeat (ECal.ComponentAlarmRepeat? repeat);
		[Version (since = "3.34")]
		public void set_summary (ECal.ComponentText? summary);
		[Version (since = "3.34")]
		public void set_trigger (ECal.ComponentAlarmTrigger? trigger);
		[Version (since = "3.34")]
		public void set_uid (string? uid);
		[Version (since = "3.40")]
		public void take_acknowledged (owned ICal.Time? when);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_alarm_instance_get_type ()")]
	[Compact]
	public class ComponentAlarmInstance {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAlarmInstance (string uid, long instance_time, long occur_start, long occur_end);
		[Version (since = "3.34")]
		public ECal.ComponentAlarmInstance copy ();
		[Version (since = "3.34")]
		public long get_occur_end ();
		[Version (since = "3.34")]
		public long get_occur_start ();
		[Version (since = "3.40")]
		public unowned string? get_rid ();
		[Version (since = "3.34")]
		public long get_time ();
		[Version (since = "3.34")]
		public unowned string get_uid ();
		[Version (since = "3.34")]
		public void set_occur_end (long occur_end);
		[Version (since = "3.34")]
		public void set_occur_start (long occur_start);
		[Version (since = "3.40")]
		public void set_rid (string? rid);
		[Version (since = "3.34")]
		public void set_time (long instance_time);
		[Version (since = "3.34")]
		public void set_uid (string uid);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_alarm_repeat_get_type ()")]
	[Compact]
	public class ComponentAlarmRepeat {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAlarmRepeat (int repetitions, ICal.Duration interval);
		[Version (since = "3.34")]
		public ECal.ComponentAlarmRepeat copy ();
		[Version (since = "3.34")]
		public unowned ICal.Duration get_interval ();
		[Version (since = "3.34")]
		public int get_interval_seconds ();
		[Version (since = "3.34")]
		public int get_repetitions ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAlarmRepeat.seconds (int repetitions, int interval_seconds);
		[Version (since = "3.34")]
		public void set_interval (ICal.Duration interval);
		[Version (since = "3.34")]
		public void set_interval_seconds (int interval_seconds);
		[Version (since = "3.34")]
		public void set_repetitions (int repetitions);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_alarm_trigger_get_type ()")]
	[Compact]
	public class ComponentAlarmTrigger {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAlarmTrigger.absolute (ICal.Time absolute_time);
		[Version (since = "3.34")]
		public ECal.ComponentAlarmTrigger copy ();
		[Version (since = "3.34")]
		public void fill_property (ref ICal.Property property);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAlarmTrigger.from_property (ICal.Property property);
		[Version (since = "3.34")]
		public unowned ICal.Time? get_absolute_time ();
		[Version (since = "3.34")]
		public ICal.Property get_as_property ();
		[Version (since = "3.34")]
		public unowned ICal.Duration? get_duration ();
		[Version (since = "3.34")]
		public ECal.ComponentAlarmTriggerKind get_kind ();
		[Version (since = "3.34")]
		public unowned ECal.ComponentParameterBag get_parameter_bag ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAlarmTrigger.relative (ECal.ComponentAlarmTriggerKind kind, ICal.Duration duration);
		[Version (since = "3.34")]
		public void set_absolute (ICal.Time absolute_time);
		[Version (since = "3.34")]
		public void set_absolute_time (ICal.Time absolute_time);
		[Version (since = "3.34")]
		public void set_duration (ICal.Duration duration);
		[Version (since = "3.34")]
		public void set_from_property (ICal.Property property);
		[Version (since = "3.34")]
		public void set_kind (ECal.ComponentAlarmTriggerKind kind);
		[Version (since = "3.34")]
		public void set_relative (ECal.ComponentAlarmTriggerKind kind, ICal.Duration duration);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_alarms_get_type ()")]
	[Compact]
	public class ComponentAlarms {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAlarms (ECal.Component comp);
		[Version (since = "3.34")]
		public void add_instance (ECal.ComponentAlarmInstance instance);
		[Version (since = "3.34")]
		public ECal.ComponentAlarms copy ();
		[Version (since = "3.34")]
		public unowned ECal.Component get_component ();
		[Version (since = "3.34")]
		public unowned GLib.SList<ECal.ComponentAlarmInstance>? get_instances ();
		[Version (since = "3.34")]
		public bool remove_instance (ECal.ComponentAlarmInstance instance);
		[Version (since = "3.34")]
		public void set_instances (GLib.SList<ECal.ComponentAlarmInstance>? instances);
		[Version (since = "3.34")]
		public void take_instance (owned ECal.ComponentAlarmInstance instance);
		[Version (since = "3.34")]
		public void take_instances (owned GLib.SList<ECal.ComponentAlarmInstance>? instances);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_attendee_get_type ()")]
	[Compact]
	public class ComponentAttendee {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAttendee ();
		[Version (since = "3.34")]
		public ECal.ComponentAttendee copy ();
		[Version (since = "3.34")]
		public void fill_property (ref ICal.Property property);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAttendee.from_property (ICal.Property property);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentAttendee.full (string? value, string? member, ICal.ParameterCutype cutype, ICal.ParameterRole role, ICal.ParameterPartstat partstat, bool rsvp, string? delegatedfrom, string? delegatedto, string? sentby, string? cn, string? language);
		[Version (since = "3.34")]
		public ICal.Property get_as_property ();
		[Version (since = "3.34")]
		public unowned string? get_cn ();
		[Version (since = "3.34")]
		public ICal.ParameterCutype get_cutype ();
		[Version (since = "3.34")]
		public unowned string? get_delegatedfrom ();
		[Version (since = "3.34")]
		public unowned string? get_delegatedto ();
		[Version (since = "3.34")]
		public unowned string? get_language ();
		[Version (since = "3.34")]
		public unowned string? get_member ();
		[Version (since = "3.34")]
		public unowned ECal.ComponentParameterBag get_parameter_bag ();
		[Version (since = "3.34")]
		public ICal.ParameterPartstat get_partstat ();
		[Version (since = "3.34")]
		public ICal.ParameterRole get_role ();
		[Version (since = "3.34")]
		public bool get_rsvp ();
		[Version (since = "3.34")]
		public unowned string? get_sentby ();
		[Version (since = "3.34")]
		public unowned string? get_value ();
		[Version (since = "3.34")]
		public void set_cn (string? cn);
		[Version (since = "3.34")]
		public void set_cutype (ICal.ParameterCutype cutype);
		[Version (since = "3.34")]
		public void set_delegatedfrom (string? delegatedfrom);
		[Version (since = "3.34")]
		public void set_delegatedto (string? delegatedto);
		[Version (since = "3.34")]
		public void set_from_property (ICal.Property property);
		[Version (since = "3.34")]
		public void set_language (string? language);
		[Version (since = "3.34")]
		public void set_member (string? member);
		[Version (since = "3.34")]
		public void set_partstat (ICal.ParameterPartstat partstat);
		[Version (since = "3.34")]
		public void set_role (ICal.ParameterRole role);
		[Version (since = "3.34")]
		public void set_rsvp (bool rsvp);
		[Version (since = "3.34")]
		public void set_sentby (string? sentby);
		[Version (since = "3.34")]
		public void set_value (string? value);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", lower_case_csuffix = "component_datetime", type_id = "e_cal_component_datetime_get_type ()")]
	[Compact]
	public class ComponentDateTime {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentDateTime (ICal.Time value, string? tzid);
		[Version (since = "3.34")]
		public ECal.ComponentDateTime copy ();
		[Version (since = "3.34")]
		public unowned string? get_tzid ();
		[Version (since = "3.34")]
		public unowned ICal.Time get_value ();
		[Version (since = "3.34")]
		public void @set (ICal.Time value, string? tzid);
		[Version (since = "3.34")]
		public void set_tzid (string? tzid);
		[Version (since = "3.34")]
		public void set_value (ICal.Time value);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentDateTime.take (owned ICal.Time value, owned string? tzid);
		[Version (since = "3.34")]
		public void take_tzid (owned string? tzid);
		[Version (since = "3.34")]
		public void take_value (owned ICal.Time value);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_id_get_type ()")]
	[Compact]
	public class ComponentId {
		[CCode (has_construct_function = false)]
		[Version (since = "3.10")]
		public ComponentId (string uid, string? rid);
		[Version (since = "3.10")]
		public ECal.ComponentId copy ();
		[Version (since = "3.10")]
		public bool equal (ECal.ComponentId id2);
		[Version (since = "3.34")]
		public unowned string? get_rid ();
		[Version (since = "3.34")]
		public unowned string get_uid ();
		[Version (since = "3.10")]
		public uint hash ();
		[Version (since = "3.34")]
		public void set_rid (string? rid);
		[Version (since = "3.34")]
		public void set_uid (string uid);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentId.take (owned string uid, owned string? rid);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_organizer_get_type ()")]
	[Compact]
	public class ComponentOrganizer {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentOrganizer ();
		[Version (since = "3.34")]
		public ECal.ComponentOrganizer copy ();
		[Version (since = "3.34")]
		public void fill_property (ref ICal.Property property);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentOrganizer.from_property (ICal.Property property);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentOrganizer.full (string? value, string? sentby, string? cn, string? language);
		[Version (since = "3.34")]
		public ICal.Property get_as_property ();
		[Version (since = "3.34")]
		public unowned string? get_cn ();
		[Version (since = "3.34")]
		public unowned string? get_language ();
		[Version (since = "3.34")]
		public unowned ECal.ComponentParameterBag get_parameter_bag ();
		[Version (since = "3.34")]
		public unowned string? get_sentby ();
		[Version (since = "3.34")]
		public unowned string? get_value ();
		[Version (since = "3.34")]
		public void set_cn (string? cn);
		[Version (since = "3.34")]
		public void set_from_property (ICal.Property property);
		[Version (since = "3.34")]
		public void set_language (string? language);
		[Version (since = "3.34")]
		public void set_sentby (string? sentby);
		[Version (since = "3.34")]
		public void set_value (string? value);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_parameter_bag_get_type ()")]
	[Compact]
	public class ComponentParameterBag {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentParameterBag ();
		[Version (since = "3.34")]
		public void add (ICal.Parameter param);
		[Version (since = "3.34")]
		public void assign (ECal.ComponentParameterBag src_bag);
		[Version (since = "3.34")]
		public void clear ();
		[Version (since = "3.34")]
		public ECal.ComponentParameterBag copy ();
		[Version (since = "3.34")]
		public void fill_property (ICal.Property property);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentParameterBag.from_property (ICal.Property property, ECal.ComponentParameterBagFilterFunc? func);
		[Version (since = "3.34")]
		public unowned ICal.Parameter? @get (uint index);
		[Version (since = "3.34")]
		public uint get_count ();
		[Version (since = "3.34")]
		public uint get_first_by_kind (ICal.ParameterKind kind);
		[Version (since = "3.34")]
		public void remove (uint index);
		[Version (since = "3.34")]
		public uint remove_by_kind (ICal.ParameterKind kind, bool all);
		[Version (since = "3.34")]
		public void set_from_property (ICal.Property property);
		[Version (since = "3.34")]
		public void take (owned ICal.Parameter param);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_period_get_type ()")]
	[Compact]
	public class ComponentPeriod {
		[Version (since = "3.34")]
		public ECal.ComponentPeriod copy ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentPeriod.datetime (ICal.Time start, ICal.Time? end);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentPeriod.duration (ICal.Time start, ICal.Duration duration);
		[Version (since = "3.34")]
		public unowned ICal.Duration get_duration ();
		[Version (since = "3.34")]
		public unowned ICal.Time? get_end ();
		[Version (since = "3.34")]
		public ECal.ComponentPeriodKind get_kind ();
		[Version (since = "3.34")]
		public unowned ICal.Time get_start ();
		[Version (since = "3.34")]
		public void set_datetime_full (ICal.Time start, ICal.Time? end);
		[Version (since = "3.34")]
		public void set_duration (ICal.Duration duration);
		[Version (since = "3.34")]
		public void set_duration_full (ICal.Time start, ICal.Duration duration);
		[Version (since = "3.34")]
		public void set_end (ICal.Time? end);
		[Version (since = "3.34")]
		public void set_start (ICal.Time start);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_property_bag_get_type ()")]
	[Compact]
	public class ComponentPropertyBag {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentPropertyBag ();
		[Version (since = "3.34")]
		public void add (ICal.Property prop);
		[Version (since = "3.34")]
		public void assign (ECal.ComponentPropertyBag src_bag);
		[Version (since = "3.34")]
		public void clear ();
		[Version (since = "3.34")]
		public ECal.ComponentPropertyBag copy ();
		[Version (since = "3.34")]
		public void fill_component (ICal.Component component);
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentPropertyBag.from_component (ICal.Component component, ECal.ComponentPropertyBagFilterFunc? func);
		[Version (since = "3.34")]
		public unowned ICal.Property? @get (uint index);
		[Version (since = "3.34")]
		public uint get_count ();
		[Version (since = "3.34")]
		public uint get_first_by_kind (ICal.PropertyKind kind);
		[Version (since = "3.34")]
		public void remove (uint index);
		[Version (since = "3.34")]
		public uint remove_by_kind (ICal.PropertyKind kind, bool all);
		[Version (since = "3.34")]
		public void set_from_component (ICal.Component component);
		[Version (since = "3.34")]
		public void take (owned ICal.Property prop);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_range_get_type ()")]
	[Compact]
	public class ComponentRange {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentRange (ECal.ComponentRangeKind kind, ECal.ComponentDateTime datetime);
		[Version (since = "3.34")]
		public ECal.ComponentRange copy ();
		[Version (since = "3.34")]
		public unowned ECal.ComponentDateTime get_datetime ();
		[Version (since = "3.34")]
		public ECal.ComponentRangeKind get_kind ();
		[Version (since = "3.34")]
		public void set_datetime (ECal.ComponentDateTime datetime);
		[Version (since = "3.34")]
		public void set_kind (ECal.ComponentRangeKind kind);
	}
	[CCode (cheader_filename = "libecal/libecal.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_cal_component_text_get_type ()")]
	[Compact]
	public class ComponentText {
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public ComponentText (string? value, string? altrep);
		[Version (since = "3.34")]
		public ECal.ComponentText copy ();
		[Version (since = "3.34")]
		public unowned string get_altrep ();
		[Version (since = "3.34")]
		public unowned string get_value ();
		[Version (since = "3.34")]
		public void set_altrep (string? altrep);
		[Version (since = "3.34")]
		public void set_value (string? value);
	}
	[CCode (cheader_filename = "libecal/libecal.h", cname = "EReminderData", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_reminder_data_get_type ()")]
	[Compact]
	[Version (since = "3.30")]
	public class ReminderData {
		[CCode (cname = "e_reminder_data_new", has_construct_function = false)]
		public ReminderData (string source_uid, ECal.Component component, ECal.ComponentAlarmInstance instance);
		[CCode (cname = "e_reminder_data_copy")]
		public ECal.ReminderData copy ();
		[CCode (cname = "e_reminder_data_free")]
		public void free ();
		[CCode (cname = "e_reminder_data_get_component")]
		[Version (since = "3.34")]
		public unowned ECal.Component get_component ();
		[CCode (cname = "e_reminder_data_get_instance")]
		[Version (since = "3.34")]
		public unowned ECal.ComponentAlarmInstance get_instance ();
		[CCode (cname = "e_reminder_data_get_source_uid")]
		[Version (since = "3.34")]
		public unowned string get_source_uid ();
		[CCode (cname = "e_reminder_data_set_component")]
		[Version (since = "3.34")]
		public void set_component (ECal.Component component);
		[CCode (cname = "e_reminder_data_set_instance")]
		[Version (since = "3.34")]
		public void set_instance (ECal.ComponentAlarmInstance instance);
		[CCode (cname = "e_reminder_data_set_source_uid")]
		[Version (since = "3.34")]
		public void set_source_uid (string source_uid);
	}
	[CCode (cheader_filename = "libecal/libecal.h", cname = "EReminderWatcher", type_id = "e_reminder_watcher_get_type ()")]
	[Version (since = "3.30")]
	public class ReminderWatcher : GLib.Object {
		[CCode (cname = "e_reminder_watcher_new", has_construct_function = false)]
		public ReminderWatcher (E.SourceRegistry registry);
		[NoWrapper]
		public virtual async void cal_client_connect (E.Source source, ECal.ClientSourceType source_type, uint32 wait_for_connected_seconds, GLib.Cancellable? cancellable);
		[CCode (cname = "e_reminder_watcher_describe_data")]
		public string describe_data (ECal.ReminderData rd, uint32 flags);
		[CCode (cname = "e_reminder_watcher_dismiss")]
		public async bool dismiss (ECal.ReminderData rd, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "e_reminder_watcher_dismiss_all")]
		public async bool dismiss_all (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "e_reminder_watcher_dismiss_all_sync")]
		public bool dismiss_all_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (cname = "e_reminder_watcher_dismiss_sync")]
		public bool dismiss_sync (ECal.ReminderData rd, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (cname = "e_reminder_watcher_dup_default_zone")]
		public ICal.Timezone dup_default_zone ();
		[CCode (cname = "e_reminder_watcher_dup_past")]
		public GLib.SList<ECal.ReminderData>? dup_past ();
		[CCode (cname = "e_reminder_watcher_dup_snoozed")]
		public GLib.SList<ECal.ReminderData>? dup_snoozed ();
		[CCode (cname = "e_reminder_watcher_get_registry")]
		public unowned E.SourceRegistry get_registry ();
		[CCode (cname = "e_reminder_watcher_get_timers_enabled")]
		public bool get_timers_enabled ();
		[CCode (cname = "e_reminder_watcher_ref_opened_client")]
		public ECal.Client? ref_opened_client (string source_uid);
		[NoWrapper]
		public virtual void schedule_timer (int64 at_time);
		[CCode (cname = "e_reminder_watcher_set_default_zone")]
		public void set_default_zone (ICal.Timezone? zone);
		[CCode (cname = "e_reminder_watcher_set_timers_enabled")]
		public void set_timers_enabled (bool enabled);
		[CCode (cname = "e_reminder_watcher_snooze")]
		public void snooze (ECal.ReminderData rd, int64 until);
		[CCode (cname = "e_reminder_watcher_timer_elapsed")]
		public void timer_elapsed ();
		[NoAccessorMethod]
		public ICal.Timezone default_zone { owned get; set; }
		[NoAccessorMethod]
		public E.SourceRegistry registry { owned get; construct; }
		[NoAccessorMethod]
		public bool timers_enabled { get; set; }
		public virtual signal void changed ();
		public virtual signal void format_time (ECal.ReminderData rd, ICal.Time itt, ref void* inout_buffer, int buffer_size);
		public signal void triggered (GLib.SList<ECal.ReminderData> reminders, bool snoozed);
	}
	[CCode (cheader_filename = "libecal/libecal.h", cname = "ETimezoneCache", type_cname = "ETimezoneCacheInterface", type_id = "e_timezone_cache_get_type ()")]
	[Version (since = "3.8")]
	public interface TimezoneCache : GLib.Object {
		[CCode (cname = "e_timezone_cache_add_timezone")]
		public void add_tz (ICal.Timezone zone);
		[CCode (cname = "e_timezone_cache_get_timezone")]
		public unowned ICal.Timezone? get_tz (string tzid);
		[CCode (cname = "e_timezone_cache_list_timezones")]
		public GLib.List<weak ICal.Timezone> list_timezones ();
		[NoWrapper]
		public abstract void tzcache_add_timezone (ICal.Timezone zone);
		public virtual signal void timezone_added (ICal.Timezone zone);
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_CLIENT_ERROR_", has_type_id = false)]
	[Version (since = "3.2")]
	public enum ClientError {
		NO_SUCH_CALENDAR,
		OBJECT_NOT_FOUND,
		INVALID_OBJECT,
		UNKNOWN_USER,
		OBJECT_ID_ALREADY_EXISTS,
		INVALID_RANGE
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_CLIENT_SOURCE_TYPE_", type_id = "e_cal_client_source_type_get_type ()")]
	[Version (since = "3.2")]
	public enum ClientSourceType {
		EVENTS,
		TASKS,
		MEMOS
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_CLIENT_VIEW_FLAGS_", has_type_id = false)]
	[Flags]
	[Version (since = "3.6")]
	public enum ClientViewFlags {
		NONE,
		NOTIFY_INITIAL
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_COMPONENT_ALARM_", type_id = "e_cal_component_alarm_action_get_type ()")]
	public enum ComponentAlarmAction {
		NONE,
		AUDIO,
		DISPLAY,
		EMAIL,
		PROCEDURE,
		UNKNOWN
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_COMPONENT_ALARM_TRIGGER_", type_id = "e_cal_component_alarm_trigger_kind_get_type ()")]
	public enum ComponentAlarmTriggerKind {
		NONE,
		RELATIVE_START,
		RELATIVE_END,
		ABSOLUTE
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_COMPONENT_CLASS_", type_id = "e_cal_component_classification_get_type ()")]
	public enum ComponentClassification {
		NONE,
		PUBLIC,
		PRIVATE,
		CONFIDENTIAL,
		UNKNOWN
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_COMPONENT_PERIOD_", type_id = "e_cal_component_period_kind_get_type ()")]
	public enum ComponentPeriodKind {
		DATETIME,
		DURATION
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_COMPONENT_RANGE_", type_id = "e_cal_component_range_kind_get_type ()")]
	public enum ComponentRangeKind {
		SINGLE,
		THISPRIOR,
		THISFUTURE
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_COMPONENT_TRANSP_", type_id = "e_cal_component_transparency_get_type ()")]
	public enum ComponentTransparency {
		NONE,
		TRANSPARENT,
		OPAQUE,
		UNKNOWN
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_COMPONENT_", type_id = "e_cal_component_vtype_get_type ()")]
	public enum ComponentVType {
		NO_TYPE,
		EVENT,
		TODO,
		JOURNAL,
		FREEBUSY,
		TIMEZONE
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_OBJ_MOD_", type_id = "e_cal_obj_mod_type_get_type ()")]
	[Flags]
	[Version (since = "3.8")]
	public enum ObjModType {
		THIS,
		THIS_AND_PRIOR,
		THIS_AND_FUTURE,
		ALL,
		ONLY_THIS
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_OPERATION_FLAG_", type_id = "e_cal_operation_flags_get_type ()")]
	[Flags]
	[Version (since = "3.34")]
	public enum OperationFlags {
		NONE,
		CONFLICT_FAIL,
		CONFLICT_USE_NEWER,
		CONFLICT_KEEP_SERVER,
		CONFLICT_KEEP_LOCAL,
		CONFLICT_WRITE_COPY,
		DISABLE_ITIP_MESSAGE
	}
	[CCode (cheader_filename = "libecal/libecal.h", cprefix = "E_CAL_RECUR_DESCRIBE_RECURRENCE_FLAG_", type_id = "e_cal_recur_describe_recurrence_flags_get_type ()")]
	[Flags]
	[Version (since = "3.30")]
	public enum RecurDescribeRecurrenceFlags {
		NONE,
		PREFIXED,
		FALLBACK
	}
	[CCode (cheader_filename = "libecal/libecal.h", cname = "EReminderWatcherDescribeFlags", cprefix = "E_REMINDER_WATCHER_DESCRIBE_FLAG_", has_type_id = false)]
	[Flags]
	[Version (since = "3.30")]
	public enum ReminderWatcherDescribeFlags {
		NONE,
		MARKUP
	}
	[CCode (cheader_filename = "libecal/libecal.h", instance_pos = 1.9)]
	[Version (since = "3.34")]
	public delegate bool ComponentParameterBagFilterFunc (ICal.Parameter parameter);
	[CCode (cheader_filename = "libecal/libecal.h", instance_pos = 1.9)]
	[Version (since = "3.34")]
	public delegate bool ComponentPropertyBagFilterFunc (ICal.Property property);
	[CCode (cheader_filename = "libecal/libecal.h", has_target = false)]
	[Version (since = "3.38")]
	public delegate void RecurFormatDateTimeFunc (ICal.Time itt, string buffer, int buffer_size);
	[CCode (cheader_filename = "libecal/libecal.h", instance_pos = 3.9)]
	[Version (since = "3.34")]
	public delegate bool RecurInstanceCb (ICal.Component icomp, ICal.Time instance_start, ICal.Time instance_end, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libecal/libecal.h", instance_pos = 1.9)]
	[Version (since = "3.34")]
	public delegate unowned ICal.Timezone? RecurResolveTimezoneCb (string tzid, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_BACKEND_PROPERTY_ALARM_EMAIL_ADDRESS")]
	[Version (since = "3.2")]
	public const string BACKEND_PROPERTY_ALARM_EMAIL_ADDRESS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_BACKEND_PROPERTY_CAL_EMAIL_ADDRESS")]
	[Version (since = "3.2")]
	public const string BACKEND_PROPERTY_CAL_EMAIL_ADDRESS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_BACKEND_PROPERTY_DEFAULT_OBJECT")]
	[Version (since = "3.2")]
	public const string BACKEND_PROPERTY_DEFAULT_OBJECT;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_BACKEND_PROPERTY_REVISION")]
	[Version (since = "3.4")]
	public const string BACKEND_PROPERTY_REVISION;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_EVOLUTION_ALARM_UID_PROPERTY")]
	[Version (since = "3.34")]
	public const string EVOLUTION_ALARM_UID_PROPERTY;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_EVOLUTION_ENDDATE_PARAMETER")]
	[Version (since = "3.34")]
	public const string EVOLUTION_ENDDATE_PARAMETER;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "LIBICAL_GLIB_UNSTABLE_API")]
	public const int LIBICAL_GLIB_UNSTABLE_API;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_ALARM_DESCRIPTION")]
	[Version (since = "3.8")]
	public const string STATIC_CAPABILITY_ALARM_DESCRIPTION;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_ALL_DAY_EVENT_AS_TIME")]
	[Version (since = "3.18")]
	public const string STATIC_CAPABILITY_ALL_DAY_EVENT_AS_TIME;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_BULK_ADDS")]
	[Version (since = "3.6")]
	public const string STATIC_CAPABILITY_BULK_ADDS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_BULK_MODIFIES")]
	[Version (since = "3.6")]
	public const string STATIC_CAPABILITY_BULK_MODIFIES;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_BULK_REMOVES")]
	[Version (since = "3.6")]
	public const string STATIC_CAPABILITY_BULK_REMOVES;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_COMPONENT_COLOR")]
	[Version (since = "3.30")]
	public const string STATIC_CAPABILITY_COMPONENT_COLOR;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_CREATE_MESSAGES")]
	[Version (since = "2.26")]
	public const string STATIC_CAPABILITY_CREATE_MESSAGES;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_DELEGATE_SUPPORTED")]
	public const string STATIC_CAPABILITY_DELEGATE_SUPPORTED;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_DELEGATE_TO_MANY")]
	public const string STATIC_CAPABILITY_DELEGATE_TO_MANY;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_HAS_UNACCEPTED_MEETING")]
	public const string STATIC_CAPABILITY_HAS_UNACCEPTED_MEETING;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_ALARM_AFTER_START")]
	[Version (since = "3.8")]
	public const string STATIC_CAPABILITY_NO_ALARM_AFTER_START;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_ALARM_REPEAT")]
	public const string STATIC_CAPABILITY_NO_ALARM_REPEAT;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_AUDIO_ALARMS")]
	public const string STATIC_CAPABILITY_NO_AUDIO_ALARMS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_CONV_TO_ASSIGN_TASK")]
	public const string STATIC_CAPABILITY_NO_CONV_TO_ASSIGN_TASK;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_CONV_TO_RECUR")]
	public const string STATIC_CAPABILITY_NO_CONV_TO_RECUR;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_DISPLAY_ALARMS")]
	public const string STATIC_CAPABILITY_NO_DISPLAY_ALARMS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_EMAIL_ALARMS")]
	public const string STATIC_CAPABILITY_NO_EMAIL_ALARMS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_GEN_OPTIONS")]
	public const string STATIC_CAPABILITY_NO_GEN_OPTIONS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_MEMO_START_DATE")]
	public const string STATIC_CAPABILITY_NO_MEMO_START_DATE;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_ORGANIZER")]
	public const string STATIC_CAPABILITY_NO_ORGANIZER;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_PROCEDURE_ALARMS")]
	public const string STATIC_CAPABILITY_NO_PROCEDURE_ALARMS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_TASK_ASSIGNMENT")]
	public const string STATIC_CAPABILITY_NO_TASK_ASSIGNMENT;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_THISANDFUTURE")]
	public const string STATIC_CAPABILITY_NO_THISANDFUTURE;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_THISANDPRIOR")]
	public const string STATIC_CAPABILITY_NO_THISANDPRIOR;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_NO_TRANSPARENCY")]
	public const string STATIC_CAPABILITY_NO_TRANSPARENCY;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_ONE_ALARM_ONLY")]
	public const string STATIC_CAPABILITY_ONE_ALARM_ONLY;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_ORGANIZER_MUST_ACCEPT")]
	public const string STATIC_CAPABILITY_ORGANIZER_MUST_ACCEPT;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_ORGANIZER_MUST_ATTEND")]
	public const string STATIC_CAPABILITY_ORGANIZER_MUST_ATTEND;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_ORGANIZER_NOT_EMAIL_ADDRESS")]
	public const string STATIC_CAPABILITY_ORGANIZER_NOT_EMAIL_ADDRESS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_RECURRENCES_NO_MASTER")]
	public const string STATIC_CAPABILITY_RECURRENCES_NO_MASTER;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_REFRESH_SUPPORTED")]
	[Version (since = "2.30")]
	public const string STATIC_CAPABILITY_REFRESH_SUPPORTED;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_REMOVE_ALARMS")]
	public const string STATIC_CAPABILITY_REMOVE_ALARMS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_REMOVE_ONLY_THIS")]
	[Version (since = "3.2")]
	public const string STATIC_CAPABILITY_REMOVE_ONLY_THIS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_REQ_SEND_OPTIONS")]
	public const string STATIC_CAPABILITY_REQ_SEND_OPTIONS;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_SAVE_SCHEDULES")]
	public const string STATIC_CAPABILITY_SAVE_SCHEDULES;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_SIMPLE_MEMO")]
	[Version (since = "3.38")]
	public const string STATIC_CAPABILITY_SIMPLE_MEMO;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_SIMPLE_MEMO_WITH_SUMMARY")]
	[Version (since = "3.42")]
	public const string STATIC_CAPABILITY_SIMPLE_MEMO_WITH_SUMMARY;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_TASK_CAN_RECUR")]
	[Version (since = "3.30")]
	public const string STATIC_CAPABILITY_TASK_CAN_RECUR;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_TASK_DATE_ONLY")]
	[Version (since = "3.24")]
	public const string STATIC_CAPABILITY_TASK_DATE_ONLY;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_TASK_HANDLE_RECUR")]
	[Version (since = "3.34")]
	public const string STATIC_CAPABILITY_TASK_HANDLE_RECUR;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "E_CAL_STATIC_CAPABILITY_TASK_NO_ALARM")]
	[Version (since = "3.30")]
	public const string STATIC_CAPABILITY_TASK_NO_ALARM;
	[CCode (cheader_filename = "libecal/libecal.h", cname = "isodate_from_time_t")]
	public static string isodate_from_time_t (long t);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "2.24")]
	public static unowned string match_tzid (string tzid);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.30")]
	public static string? recur_describe_recurrence (ICal.Component icalcomp, GLib.DateWeekday week_start_day, uint32 flags);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.38")]
	public static string? recur_describe_recurrence_ex (ICal.Component icalcomp, GLib.DateWeekday week_start_day, uint32 flags, ECal.RecurFormatDateTimeFunc? datetime_fmt_func);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "2.32")]
	public static bool recur_ensure_end_dates (ECal.Component comp, bool refresh, [CCode (delegate_target_pos = 3.5)] ECal.RecurResolveTimezoneCb tz_cb, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.20")]
	public static bool recur_generate_instances_sync (ICal.Component icalcomp, ICal.Time interval_start, ICal.Time interval_end, [CCode (delegate_target_pos = 4.5)] ECal.RecurInstanceCb? callback, [CCode (delegate_target_pos = 5.5)] ECal.RecurResolveTimezoneCb? get_tz_callback, ICal.Timezone default_timezone, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.28")]
	public static unowned string recur_get_localized_nth (int nth);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static long recur_obtain_enddate (ICal.Recurrence ir, ICal.Property prop, ICal.Timezone zone, bool convert_end_date);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "2.28")]
	public static string system_timezone_get_location ();
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_add_day")]
	public static long time_add_day (long time, int days);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_add_day_with_zone")]
	public static long time_add_day_with_zone (long time, int days, ICal.Timezone zone);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_add_month_with_zone")]
	public static long time_add_month_with_zone (long time, int months, ICal.Timezone zone);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_add_week")]
	public static long time_add_week (long time, int weeks);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_add_week_with_zone")]
	public static long time_add_week_with_zone (long time, int weeks, ICal.Timezone zone);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_day_begin")]
	public static long time_day_begin (long t);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_day_begin_with_zone")]
	public static long time_day_begin_with_zone (long time, ICal.Timezone zone);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_day_end")]
	public static long time_day_end (long t);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_day_end_with_zone")]
	public static long time_day_end_with_zone (long time, ICal.Timezone zone);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_day_of_week")]
	public static int time_day_of_week (int day, int month, int year);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_day_of_year")]
	public static int time_day_of_year (int day, int month, int year);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_days_in_month")]
	public static int time_days_in_month (int year, int month);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_from_isodate")]
	public static long time_from_isodate (string str);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_is_leap_year")]
	public static bool time_is_leap_year (int year);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_leap_years_up_to")]
	public static int time_leap_years_up_to (int year);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_month_begin_with_zone")]
	public static long time_month_begin_with_zone (long time, ICal.Timezone zone);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_to_gdate_with_zone")]
	public static void time_to_gdate_with_zone (GLib.Date date, long time, ICal.Timezone? zone);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_week_begin_with_zone")]
	public static long time_week_begin_with_zone (long time, int week_start_day, ICal.Timezone zone);
	[CCode (cheader_filename = "libecal/libecal.h", cname = "time_year_begin_with_zone")]
	public static long time_year_begin_with_zone (long time, ICal.Timezone zone);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static void util_add_timezones_from_component (ICal.Component vcal_comp, ICal.Component icalcomp);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.40")]
	public static void util_clamp_vtimezone (ref ICal.Component vtimezone, ICal.Time from, ICal.Time? to);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.40")]
	public static void util_clamp_vtimezone_by_component (ref ICal.Component vtimezone, ICal.Component component);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static string? util_component_dup_x_property (ICal.Component icalcomp, string x_name);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static ICal.Property? util_component_find_x_property (ICal.Component icalcomp, string x_name);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static string? util_component_get_recurid_as_string (ICal.Component icalcomp);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static bool util_component_has_alarms (ICal.Component icalcomp);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static bool util_component_has_attendee (ICal.Component icalcomp);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static bool util_component_has_organizer (ICal.Component icalcomp);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static bool util_component_has_property (ICal.Component icalcomp, ICal.PropertyKind prop_kind);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static bool util_component_has_rdates (ICal.Component icalcomp);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static bool util_component_has_recurrences (ICal.Component icalcomp);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static bool util_component_has_rrules (ICal.Component icalcomp);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static bool util_component_has_x_property (ICal.Component icalcomp, string x_name);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static bool util_component_is_instance (ICal.Component icalcomp);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.30")]
	public static uint util_component_remove_property_by_kind (ICal.Component icalcomp, ICal.PropertyKind kind, bool all);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static bool util_component_remove_x_property (ICal.Component icalcomp, string x_name);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static void util_component_set_x_property (ICal.Component icalcomp, string x_name, string? value);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static uint32 util_conflict_resolution_to_operation_flags (E.ConflictResolution conflict_resolution);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static ICal.Component? util_construct_instance (ICal.Component icalcomp, ICal.Time rid);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static ICal.Timezone util_copy_timezone (ICal.Timezone zone);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static ECal.ComponentAlarms? util_generate_alarms_for_comp (ECal.Component comp, long start, long end, ECal.ComponentAlarmAction omit, [CCode (delegate_target_pos = 5.5)] ECal.RecurResolveTimezoneCb resolve_tzid, ICal.Timezone default_timezone);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static int util_generate_alarms_for_list (GLib.List<ECal.Component> comps, long start, long end, ECal.ComponentAlarmAction omit, out GLib.SList<ECal.ComponentAlarms> comp_alarms, [CCode (delegate_target_pos = 6.5)] ECal.RecurResolveTimezoneCb resolve_tzid, ICal.Timezone default_timezone);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "2.32")]
	public static void util_get_component_occur_times (ECal.Component comp, out long out_start, out long out_end, [CCode (delegate_target_pos = 4.5)] ECal.RecurResolveTimezoneCb tz_cb, ICal.Timezone default_timezone, ICal.ComponentKind kind);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "2.28")]
	public static unowned ICal.Timezone? util_get_system_timezone ();
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "2.28")]
	public static string util_get_system_timezone_location ();
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "2.22")]
	public static Posix.tm? util_icaltime_to_tm (ICal.Time itt);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "2.22")]
	public static Posix.tm? util_icaltime_to_tm_with_zone (ICal.Time itt, ICal.Timezone from_zone, ICal.Timezone to_zone);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.30")]
	public static bool util_init_recur_task_sync (ICal.Component vtodo, ECal.Client cal_client, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.40")]
	public static bool util_inline_local_attachments_sync (ICal.Component component, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.16")]
	public static bool util_is_first_instance (ECal.Component comp, ICal.Time rid, ECal.RecurResolveTimezoneCb tz_cb);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.30")]
	public static bool util_mark_task_complete_sync (ICal.Component vtodo, long completed_time, ECal.Client cal_client, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static ICal.Component util_new_component (ICal.ComponentKind kind);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static ICal.Component util_new_top_level ();
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.38")]
	public static void util_normalize_rrule_until_value (ICal.Component icalcomp, ICal.Time ttuntil, ECal.RecurResolveTimezoneCb tz_cb);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static E.ConflictResolution util_operation_flags_to_conflict_resolution (uint32 flags);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static ICal.Component? util_parse_ics_file (string filename);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static ICal.Component? util_parse_ics_string (string string);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static int util_priority_from_string (string string);
	[CCode (cheader_filename = "libecal/libecal.h")]
	public static unowned string util_priority_to_string (int priority);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.34")]
	public static bool util_property_has_parameter (ICal.Property prop, ICal.ParameterKind param_kind);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (deprecated = true, deprecated_since = "3.38")]
	public static void util_remove_instances (ICal.Component icalcomp, ICal.Time rid, ECal.ObjModType mod);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.38")]
	public static void util_remove_instances_ex (ICal.Component icalcomp, ICal.Time rid, ECal.ObjModType mod, ECal.RecurResolveTimezoneCb tz_cb);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.30")]
	public static string util_seconds_to_string (int64 seconds);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.40")]
	public static bool util_set_alarm_acknowledged (ECal.Component component, string auid, int64 when);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (deprecated = true, deprecated_since = "3.38", since = "3.16")]
	public static ICal.Component? util_split_at_instance (ICal.Component icalcomp, ICal.Time rid, ICal.Time? master_dtstart);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "3.38")]
	public static ICal.Component? util_split_at_instance_ex (ICal.Component icalcomp, ICal.Time rid, ICal.Time? master_dtstart, ECal.RecurResolveTimezoneCb tz_cb);
	[CCode (cheader_filename = "libecal/libecal.h")]
	[Version (since = "2.22")]
	public static ICal.Time util_tm_to_icaltime ([CCode (type = "tm*")] Posix.tm tm, bool is_date);
}
