/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.valves.AbstractAccessLogValve;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;

public class AccessLogValve
extends AbstractAccessLogValve {
    private static final Log log = LogFactory.getLog(AccessLogValve.class);
    private volatile String dateStamp = "";
    private String directory = "logs";
    protected volatile String prefix = "access_log";
    protected boolean rotatable = true;
    protected boolean renameOnRotate = false;
    private boolean buffered = true;
    protected volatile String suffix = "";
    protected PrintWriter writer = null;
    protected SimpleDateFormat fileDateFormatter = null;
    protected File currentLogFile = null;
    private volatile long rotationLastChecked = 0L;
    private boolean checkExists = false;
    protected String fileDateFormat = ".yyyy-MM-dd";
    protected volatile String encoding = null;
    private int maxDays = -1;
    private volatile boolean checkForOldLogs = false;

    public int getMaxDays() {
        return this.maxDays;
    }

    public void setMaxDays(int n) {
        this.maxDays = n;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    public boolean isCheckExists() {
        return this.checkExists;
    }

    public void setCheckExists(boolean bl) {
        this.checkExists = bl;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean bl) {
        this.rotatable = bl;
    }

    public boolean isRenameOnRotate() {
        return this.renameOnRotate;
    }

    public void setRenameOnRotate(boolean bl) {
        this.renameOnRotate = bl;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean bl) {
        this.buffered = bl;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileDateFormat(String string) {
        String string2 = string == null ? "" : string;
        this.fileDateFormat = string2;
        AccessLogValve accessLogValve = this;
        synchronized (accessLogValve) {
            this.fileDateFormatter = new SimpleDateFormat(string2, Locale.US);
            this.fileDateFormatter.setTimeZone(TimeZone.getDefault());
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string != null && string.length() > 0 ? string : null;
    }

    @Override
    public synchronized void backgroundProcess() {
        if (this.getState().isAvailable() && this.getEnabled() && this.writer != null && this.buffered) {
            this.writer.flush();
        }
        int n = this.maxDays;
        String string = this.prefix;
        String string2 = this.suffix;
        if (this.rotatable && this.checkForOldLogs && n > 0) {
            String[] stringArray;
            long l = System.currentTimeMillis() - (long)n * 24L * 60L * 60L * 1000L;
            File file = this.getDirectoryFile();
            if (file.isDirectory() && (stringArray = file.list()) != null) {
                for (String string3 : stringArray) {
                    File file2;
                    boolean bl = false;
                    if (string != null && string.length() > 0) {
                        if (!string3.startsWith(string)) continue;
                        bl = true;
                    }
                    if (string2 != null && string2.length() > 0) {
                        if (!string3.endsWith(string2)) continue;
                        bl = true;
                    }
                    if (!bl || !(file2 = new File(file, string3)).isFile() || file2.lastModified() >= l || file2.delete()) continue;
                    log.warn((Object)sm.getString("accessLogValve.deleteFail", new Object[]{file2.getAbsolutePath()}));
                }
            }
            this.checkForOldLogs = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate() {
        long l;
        if (this.rotatable && (l = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            AccessLogValve accessLogValve = this;
            synchronized (accessLogValve) {
                if (l - this.rotationLastChecked > 1000L) {
                    this.rotationLastChecked = l;
                    String string = this.fileDateFormatter.format(new Date(l));
                    if (!this.dateStamp.equals(string)) {
                        this.close(true);
                        this.dateStamp = string;
                        this.open();
                    }
                }
            }
        }
    }

    public synchronized boolean rotate(String string) {
        if (this.currentLogFile != null) {
            File file = this.currentLogFile;
            this.close(false);
            try {
                file.renameTo(new File(string));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("accessLogValve.rotateFail"), throwable);
            }
            this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
            this.open();
            return true;
        }
        return false;
    }

    private File getDirectoryFile() {
        File file = new File(this.directory);
        if (!file.isAbsolute()) {
            file = new File(this.getContainer().getCatalinaBase(), this.directory);
        }
        return file;
    }

    private File getLogFile(boolean bl) {
        File file;
        File file2;
        File file3 = this.getDirectoryFile();
        if (!file3.mkdirs() && !file3.isDirectory()) {
            log.error((Object)sm.getString("accessLogValve.openDirFail", new Object[]{file3}));
        }
        if (!(file2 = (file = bl ? new File(file3.getAbsoluteFile(), this.prefix + this.dateStamp + this.suffix) : new File(file3.getAbsoluteFile(), this.prefix + this.suffix)).getParentFile()).mkdirs() && !file2.isDirectory()) {
            log.error((Object)sm.getString("accessLogValve.openDirFail", new Object[]{file2}));
        }
        return file;
    }

    private void restore() {
        File file = this.getLogFile(false);
        File file2 = this.getLogFile(true);
        if (file2.exists() && !file.exists() && !file2.equals(file)) {
            try {
                if (!file2.renameTo(file)) {
                    log.error((Object)sm.getString("accessLogValve.renameFail", new Object[]{file2, file}));
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("accessLogValve.renameFail", new Object[]{file2, file}), throwable);
            }
        }
    }

    private synchronized void close(boolean bl) {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        if (bl && this.renameOnRotate) {
            File file = this.getLogFile(true);
            if (!file.exists()) {
                try {
                    if (!this.currentLogFile.renameTo(file)) {
                        log.error((Object)sm.getString("accessLogValve.renameFail", new Object[]{this.currentLogFile, file}));
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.error((Object)sm.getString("accessLogValve.renameFail", new Object[]{this.currentLogFile, file}), throwable);
                }
            } else {
                log.error((Object)sm.getString("accessLogValve.alreadyExists", new Object[]{this.currentLogFile, file}));
            }
        }
        this.writer = null;
        this.dateStamp = "";
        this.currentLogFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(CharArrayWriter charArrayWriter) {
        AccessLogValve accessLogValve;
        this.rotate();
        if (this.checkExists) {
            accessLogValve = this;
            synchronized (accessLogValve) {
                if (this.currentLogFile != null && !this.currentLogFile.exists()) {
                    try {
                        this.close(false);
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        log.info((Object)sm.getString("accessLogValve.closeFail"), throwable);
                    }
                    this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
                    this.open();
                }
            }
        }
        try {
            charArrayWriter.write(System.lineSeparator());
            accessLogValve = this;
            synchronized (accessLogValve) {
                if (this.writer != null) {
                    charArrayWriter.writeTo(this.writer);
                    if (!this.buffered) {
                        this.writer.flush();
                    }
                }
            }
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("accessLogValve.writeFail", new Object[]{charArrayWriter.toString()}), (Throwable)iOException);
        }
    }

    protected synchronized void open() {
        File file = this.getLogFile(this.rotatable && !this.renameOnRotate);
        Charset charset = null;
        if (this.encoding != null) {
            try {
                charset = B2CConverter.getCharset((String)this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.error((Object)sm.getString("accessLogValve.unsupportedEncoding", new Object[]{this.encoding}), (Throwable)unsupportedEncodingException);
            }
        }
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        try {
            this.writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), charset), 128000), false);
            this.currentLogFile = file;
        }
        catch (IOException iOException) {
            this.writer = null;
            this.currentLogFile = null;
            log.error((Object)sm.getString("accessLogValve.openFail", new Object[]{file, System.getProperty("user.name")}), (Throwable)iOException);
        }
        this.checkForOldLogs = true;
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        String string = this.getFileDateFormat();
        this.fileDateFormatter = new SimpleDateFormat(string, Locale.US);
        this.fileDateFormatter.setTimeZone(TimeZone.getDefault());
        this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
        if (this.rotatable && this.renameOnRotate) {
            this.restore();
        }
        this.open();
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.close(false);
    }
}

