/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.environment;

import javax.swing.ImageIcon;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.views.environment.EnvironmentViewSupport;
import org.graalvm.visualvm.jfr.views.environment.JFRSnapshotEnvironmentViewProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

final class JFRSnapshotEnvironmentView
extends JFRViewTab {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/environment.png";

    JFRSnapshotEnvironmentView(JFRSnapshot dataSource) {
        super(dataSource, "Environment", new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 90);
    }

    @Override
    protected DataViewComponent createComponent() {
        boolean hasEvents;
        JFRModel model = this.getModel();
        boolean bl = hasEvents = model != null && model.containsEvent(JFRSnapshotEnvironmentViewProvider.EventChecker.class);
        if (!hasEvents) {
            EnvironmentViewSupport.MasterViewSupport masterView = new EnvironmentViewSupport.MasterViewSupport(model){

                @Override
                void firstShown() {
                }
            };
            return new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        }
        final EnvironmentViewSupport.CPUUtilizationSupport cpuUtilizationView = new EnvironmentViewSupport.CPUUtilizationSupport(model);
        final EnvironmentViewSupport.NetworkUtilizationSupport networkUtilizationView = new EnvironmentViewSupport.NetworkUtilizationSupport(model);
        final EnvironmentViewSupport.MemoryUsageSupport memoryUsageView = new EnvironmentViewSupport.MemoryUsageSupport(model);
        final EnvironmentViewSupport.CPUDetailsSupport cpuDetailsView = new EnvironmentViewSupport.CPUDetailsSupport();
        final EnvironmentViewSupport.OSDetailsSupport osDetailsView = new EnvironmentViewSupport.OSDetailsSupport();
        final EnvironmentViewSupport.NetworkDetailsSupport networkDetailsView = new EnvironmentViewSupport.NetworkDetailsSupport();
        final EnvironmentViewSupport.EnvVarSupport envVarView = new EnvironmentViewSupport.EnvVarSupport();
        final EnvironmentViewSupport.ProcessesSupport processesView = new EnvironmentViewSupport.ProcessesSupport();
        EnvironmentViewSupport.MasterViewSupport masterView = new EnvironmentViewSupport.MasterViewSupport(model){

            @Override
            void firstShown() {
                JFRSnapshotEnvironmentView.this.initialize(new JFREventVisitor[]{this, cpuUtilizationView, networkUtilizationView, memoryUsageView, cpuDetailsView, osDetailsView, networkDetailsView, envVarView, processesView});
            }
        };
        DataViewComponent dvc = new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("CPU & Network", true), 1);
        dvc.addDetailsView(cpuUtilizationView.getDetailsView(), 1);
        dvc.addDetailsView(networkUtilizationView.getDetailsView(), 1);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Memory", true), 2);
        dvc.addDetailsView(memoryUsageView.getDetailsView(), 2);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Details", true), 3);
        dvc.addDetailsView(cpuDetailsView.getDetailsView(), 3);
        dvc.addDetailsView(osDetailsView.getDetailsView(), 3);
        dvc.addDetailsView(networkDetailsView.getDetailsView(), 3);
        dvc.addDetailsView(envVarView.getDetailsView(), 3);
        dvc.addDetailsView(processesView.getDetailsView(), 3);
        return dvc;
    }

    private void initialize(final JFREventVisitor ... visitors) {
        new RequestProcessor("JFR Environment Initializer").post(new Runnable(){

            @Override
            public void run() {
                JFRSnapshotEnvironmentView.this.getModel().visitEvents(visitors);
            }
        });
    }
}

