/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk;

import org.graalvm.visualvm.lib.profiler.oql.repository.api.OQLQueryDefinition;

public final class OQLSupport {

    public static final class Query {
        private String script;
        private String name;
        private String description;

        public Query(OQLQueryDefinition qdef) {
            this(qdef.getContent(), qdef.getName(), qdef.getDescription());
        }

        public Query(String script, String name, String description) {
            this.setScript(script);
            this.setName(name);
            this.setDescription(description);
        }

        public void setScript(String script) {
            if (script == null) {
                throw new IllegalArgumentException("Script cannot be null");
            }
            this.script = script;
        }

        public String getScript() {
            return this.script;
        }

        public void setName(String name) {
            this.name = Query.normalizeString(name);
            if (this.name == null) {
                throw new IllegalArgumentException("Name cannot be null");
            }
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String description) {
            this.description = Query.normalizeString(description);
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private static String normalizeString(String string) {
            String normalizedString = null;
            if (string != null && (normalizedString = string.trim()).isEmpty()) {
                normalizedString = null;
            }
            return normalizedString;
        }
    }
}

