/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle.cpu;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.sampler.truffle.TruffleDataProvider;
import org.openide.util.NbBundle;

public final class ThreadInfoProvider
extends TruffleDataProvider {
    public ThreadInfoProvider(Application app, String mode, boolean trackFlags) {
        this.status = this.initialize(app, mode, trackFlags);
    }

    private String initialize(Application application, String mode, boolean trackFlags) {
        String st = ThreadInfoProvider.initJMXConn(application);
        if (st != null) {
            return st;
        }
        try {
            if (!this.checkAndLoadJMX(application)) {
                return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads", (Object)VisualVM.getInstance().getLogfileHandle());
            }
            if (!this.tbean.isStackTracesEnabled()) {
                return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_stacktraces");
            }
            this.tbean.setTrackFlags(trackFlags);
            this.tbean.setMode(mode);
            this.tbean.dumpAllThreads();
        }
        catch (SecurityException e) {
            LOGGER.log(Level.INFO, "threadBean.getThreadInfo(ids, maxDepth) throws SecurityException for " + application, e);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads", (Object)VisualVM.getInstance().getLogfileHandle());
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "threadBean.getThreadInfo(ids, maxDepth) throws Throwable for " + application, t);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads", (Object)VisualVM.getInstance().getLogfileHandle());
        }
        return null;
    }

    Map<String, Object>[] dumpAllThreads() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.tbean.dumpAllThreads();
    }

    void setOptions(String mode, boolean trackFlags) {
        try {
            this.tbean.setMode(mode);
            this.tbean.setTrackFlags(trackFlags);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "threadBean.setMode(), setTrackFlags()", ex);
        }
    }
}

