/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class UtilDetailsProvider
extends DetailsProvider.Basic {
    private static final String LOGGER_MASK = "java.util.logging.Logger+";
    private static final String LEVEL_MASK = "java.util.logging.Level+";
    private static final String LOCALE_MASK = "java.util.Locale";
    private static final String DATE_MASK = "java.util.Date+";
    private static final String TIMEZONE_MASK = "java.util.TimeZone+";
    private static final String PATTERN_MASK = "java.util.regex.Pattern";
    private static final String CURRENCY_MASK = "java.util.Currency";
    private static final String ZIPENTRY_MASK = "java.util.zip.ZipEntry+";
    private static final String LOGRECORD_MASK = "java.util.logging.LogRecord";
    private static final String ATTR_NAME_MASK = "java.util.jar.Attributes$Name";
    private static final String COLLECTION_MASK = "java.util.AbstractCollection+";
    private static final String MAP_MASK = "java.util.AbstractMap+";
    private static final String A_SET_MASK = "java.util.AbstractSet+";
    private static final String VECTOR_MASK = "java.util.Vector+";
    private static final String SET_MASK = "java.util.HashSet+";
    private static final String TREESET_MASK = "java.util.TreeSet";
    private static final String HASHTABLE_MASK = "java.util.Hashtable+";
    private static final String UUID_MASK = "java.util.UUID";
    private static final String UNMOD_COLLECTION_MASK = "java.util.Collections$UnmodifiableCollection+";
    private static final String UNMOD_MAP_MASK = "java.util.Collections$UnmodifiableMap+";
    private static final String ARRAYS_LIST_MASK = "java.util.Arrays$ArrayList";
    private static final String EMPTY_LIST_MASK = "java.util.Collections$EmptyList";
    private static final String EMPTY_SET_MASK = "java.util.Collections$EmptySet";
    private static final String EMPTY_MAP_MASK = "java.util.Collections$EmptyMap";
    private static final String SINGLETON_LIST_MASK = "java.util.Collections$SingletonList";
    private static final String SINGLETON_SET_MASK = "java.util.Collections$SingletonSet";
    private static final String SINGLETON_MAP_MASK = "java.util.Collections$SingletonMap";
    private static final String SYN_COLLECTION_MASK = "java.util.Collections$SynchronizedCollection+";
    private static final String SYN_MAP_MASK = "java.util.Collections$SynchronizedMap+";
    private static final String DEQUE_MASK = "java.util.ArrayDeque+";
    private static final String ENUM_SET_MASK = "java.util.RegularEnumSet";
    private Formatter formatter = new SimpleFormatter();

    public UtilDetailsProvider() {
        super(LOGGER_MASK, LEVEL_MASK, LOCALE_MASK, DATE_MASK, TIMEZONE_MASK, PATTERN_MASK, CURRENCY_MASK, ZIPENTRY_MASK, LOGRECORD_MASK, ATTR_NAME_MASK, COLLECTION_MASK, MAP_MASK, A_SET_MASK, VECTOR_MASK, SET_MASK, TREESET_MASK, HASHTABLE_MASK, UUID_MASK, UNMOD_COLLECTION_MASK, UNMOD_MAP_MASK, ARRAYS_LIST_MASK, EMPTY_LIST_MASK, EMPTY_MAP_MASK, EMPTY_SET_MASK, SINGLETON_LIST_MASK, SINGLETON_MAP_MASK, SINGLETON_SET_MASK, SYN_COLLECTION_MASK, SYN_MAP_MASK, DEQUE_MASK, ENUM_SET_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        if (LOGGER_MASK.equals(className) || LEVEL_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "name");
        }
        if (LOCALE_MASK.equals(className)) {
            String country;
            String language = DetailsUtils.getInstanceFieldString(instance, "language");
            if (language == null) {
                language = "";
            }
            if ((country = DetailsUtils.getInstanceFieldString(instance, "country")) == null) {
                country = "";
            }
            if (!language.isEmpty() || !country.isEmpty()) {
                if (language.isEmpty() || country.isEmpty()) {
                    return language + country;
                }
                return language + "_" + country;
            }
        } else {
            if (DATE_MASK.equals(className)) {
                long fastTime = DetailsUtils.getLongFieldValue(instance, "fastTime", -1L);
                return new Date(fastTime).toString();
            }
            if (TIMEZONE_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "ID");
            }
            if (PATTERN_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "pattern");
            }
            if (CURRENCY_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "currencyCode");
            }
            if (ZIPENTRY_MASK.equals(className)) {
                String name = DetailsUtils.getInstanceFieldString(instance, "name");
                long size = DetailsUtils.getLongFieldValue(instance, "size", -1L);
                if (name != null && size != -1L) {
                    return String.format("%s, size=%d", name, size);
                }
                return name;
            }
            if (LOGRECORD_MASK.equals(className)) {
                return this.formatter.format(new DetailsLogRecord(instance));
            }
            if (ATTR_NAME_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "name");
            }
            if (COLLECTION_MASK.equals(className) || MAP_MASK.equals(className)) {
                int size = DetailsUtils.getIntFieldValue(instance, "size", -1);
                if (size != -1) {
                    return UtilDetailsProvider.getElementsString(size);
                }
            } else if (VECTOR_MASK.equals(className)) {
                int elements = DetailsUtils.getIntFieldValue(instance, "elementCount", -1);
                if (elements != -1) {
                    return UtilDetailsProvider.getElementsString(elements);
                }
            } else {
                if (SET_MASK.equals(className)) {
                    return DetailsUtils.getInstanceFieldString(instance, "map");
                }
                if (A_SET_MASK.equals(className)) {
                    return DetailsUtils.getInstanceFieldString(instance, "this$0");
                }
                if (TREESET_MASK.equals(className)) {
                    return DetailsUtils.getInstanceFieldString(instance, "m");
                }
                if (HASHTABLE_MASK.equals(className)) {
                    int elements = DetailsUtils.getIntFieldValue(instance, "count", -1);
                    if (elements != -1) {
                        return UtilDetailsProvider.getElementsString(elements);
                    }
                } else if (UUID_MASK.equals(className)) {
                    long mostSigBits = DetailsUtils.getLongFieldValue(instance, "mostSigBits", -1L);
                    long leastSigBits = DetailsUtils.getLongFieldValue(instance, "leastSigBits", -1L);
                    if (mostSigBits != -1L && leastSigBits != -1L) {
                        return new UUID(mostSigBits, leastSigBits).toString();
                    }
                } else {
                    if (UNMOD_COLLECTION_MASK.equals(className)) {
                        return DetailsUtils.getInstanceFieldString(instance, "c");
                    }
                    if (UNMOD_MAP_MASK.equals(className)) {
                        return DetailsUtils.getInstanceFieldString(instance, "m");
                    }
                    if (ARRAYS_LIST_MASK.equals(className)) {
                        ObjectArrayInstance arr = (ObjectArrayInstance)instance.getValueOfField("a");
                        if (arr != null) {
                            return UtilDetailsProvider.getElementsString(arr.getLength());
                        }
                    } else {
                        if (EMPTY_LIST_MASK.equals(className) || EMPTY_MAP_MASK.equals(className) || EMPTY_SET_MASK.equals(className)) {
                            return UtilDetailsProvider.getElementsString(0);
                        }
                        if (SINGLETON_LIST_MASK.equals(className) || SINGLETON_MAP_MASK.equals(className) || SINGLETON_SET_MASK.equals(className)) {
                            return UtilDetailsProvider.getElementsString(1);
                        }
                        if (DEQUE_MASK.equals(className)) {
                            int head = DetailsUtils.getIntFieldValue(instance, "head", -1);
                            int tail = DetailsUtils.getIntFieldValue(instance, "tail", -1);
                            ObjectArrayInstance arr = (ObjectArrayInstance)instance.getValueOfField("elements");
                            if (head != -1 && tail != -1 && arr != null) {
                                int size = tail - head & arr.getLength() - 1;
                                return UtilDetailsProvider.getElementsString(size);
                            }
                        } else {
                            Object elements;
                            if (SYN_COLLECTION_MASK.equals(className)) {
                                return DetailsUtils.getInstanceFieldString(instance, "c");
                            }
                            if (SYN_MAP_MASK.equals(className)) {
                                return DetailsUtils.getInstanceFieldString(instance, "m");
                            }
                            if (ENUM_SET_MASK.equals(className) && (elements = instance.getValueOfField("elements")) instanceof Long) {
                                return UtilDetailsProvider.getElementsString(Long.bitCount((Long)elements));
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private static String getElementsString(int length) {
        return length == 1 ? Bundle.UtilDetailsProvider_OneItemString() : Bundle.UtilDetailsProvider_ItemsNumberString(length);
    }

    private static class DetailsLogRecord
    extends LogRecord {
        private final Instance record;

        private DetailsLogRecord(Instance rec) {
            super(Level.ALL, null);
            this.record = rec;
        }

        @Override
        public long getMillis() {
            Object time = this.record.getValueOfField("millis");
            if (time instanceof Number) {
                return ((Number)time).longValue();
            }
            return 0L;
        }

        @Override
        public String getSourceClassName() {
            return DetailsUtils.getInstanceFieldString(this.record, "sourceClassName");
        }

        @Override
        public String getSourceMethodName() {
            return DetailsUtils.getInstanceFieldString(this.record, "sourceMethodName");
        }

        @Override
        public String getLoggerName() {
            return DetailsUtils.getInstanceFieldString(this.record, "loggerName");
        }

        @Override
        public String getMessage() {
            return DetailsUtils.getInstanceFieldString(this.record, "message");
        }

        @Override
        public Object[] getParameters() {
            Object pars = this.record.getValueOfField("parameters");
            if (pars instanceof ObjectArrayInstance) {
                ArrayList<String> parameters = new ArrayList<String>();
                for (Instance o : ((ObjectArrayInstance)pars).getValues()) {
                    String par = null;
                    if (o != null) {
                        par = DetailsUtils.getInstanceString(o);
                    }
                    if (par == null) {
                        par = "";
                    }
                    parameters.add(par);
                }
                return parameters.toArray();
            }
            return null;
        }

        @Override
        public Level getLevel() {
            String level = DetailsUtils.getInstanceFieldString(this.record, "level");
            return Level.parse(level);
        }
    }
}

