/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.openjdk.jmc.common.io.UnsupportedFormatException;
import org.openjdk.jmc.common.messages.internal.Messages;

public final class IOToolkit {
    private static final int[] ZIP_MAGIC = new int[]{80, 75, 3, 4};
    private static final int[] GZ_MAGIC = new int[]{31, 139};
    private static final int[] MAGIC_LZ4 = new int[]{4, 34, 77, 24};

    private IOToolkit() {
        throw new Error("Don't");
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static InputStream openUncompressedStream(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        try {
            BufferedInputStream in = new BufferedInputStream(fin);
            if (IOToolkit.hasMagic(file, GZ_MAGIC)) {
                return new GZIPInputStream(in);
            }
            if (IOToolkit.hasMagic(file, ZIP_MAGIC)) {
                ZipInputStream zin = new ZipInputStream(in);
                zin.getNextEntry();
                return zin;
            }
            if (IOToolkit.hasMagic(file, MAGIC_LZ4)) {
                throw new UnsupportedFormatException(Messages.getString("UnsupportedFormatException_LZ4_NOT_SUPPORTED"));
            }
            return in;
        }
        catch (RuntimeException e) {
            IOToolkit.closeSilently(fin);
            throw e;
        }
        catch (IOException e) {
            IOToolkit.closeSilently(fin);
            throw e;
        }
        catch (Error e) {
            IOToolkit.closeSilently(fin);
            throw e;
        }
    }

    public static InputStream openUncompressedStream(InputStream stream) throws IOException {
        InputStream in = stream;
        if (!in.markSupported()) {
            in = new BufferedInputStream(stream);
        }
        in.mark(GZ_MAGIC.length + 1);
        if (IOToolkit.hasMagic(in, GZ_MAGIC)) {
            in.reset();
            return new GZIPInputStream(in);
        }
        in.reset();
        in.mark(ZIP_MAGIC.length + 1);
        if (IOToolkit.hasMagic(in, ZIP_MAGIC)) {
            in.reset();
            ZipInputStream zin = new ZipInputStream(in);
            zin.getNextEntry();
            return zin;
        }
        if (IOToolkit.hasMagic(in, MAGIC_LZ4)) {
            throw new UnsupportedFormatException(Messages.getString("UnsupportedFormatException_LZ4_NOT_SUPPORTED"));
        }
        in.reset();
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMagic(File file, int[] magic) throws IOException {
        boolean bl;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            bl = IOToolkit.hasMagic(fis, magic);
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(fis);
            throw throwable;
        }
        IOToolkit.closeSilently(fis);
        return bl;
    }

    public static boolean hasMagic(InputStream is, int[] magic) throws IOException {
        for (int element : magic) {
            int b = is.read();
            if (b == element) continue;
            return false;
        }
        return true;
    }

    public static boolean isGZipFile(File file) throws IOException {
        return IOToolkit.hasMagic(file, GZ_MAGIC);
    }

    public static boolean isZipFile(File file) throws IOException {
        return IOToolkit.hasMagic(file, ZIP_MAGIC);
    }

    public static boolean isCompressedFile(File file) throws IOException {
        BufferedInputStream is;
        block3: {
            boolean bl;
            is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file), ZIP_MAGIC.length + 1);
                is.mark(ZIP_MAGIC.length + 1);
                if (!IOToolkit.hasMagic(is, GZ_MAGIC)) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                throw throwable;
            }
            IOToolkit.closeSilently(is);
            return bl;
        }
        is.reset();
        boolean bl = IOToolkit.hasMagic(is, ZIP_MAGIC);
        IOToolkit.closeSilently(is);
        return bl;
    }

    public static List<String> loadFromFile(File file) throws IOException {
        FileReader fr = new FileReader(file);
        try {
            List<String> list = IOToolkit.loadFromReader(fr);
            return list;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            IOToolkit.closeSilently(fr);
        }
    }

    private static List<String> loadFromReader(Reader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(reader);
        while (br.ready()) {
            lines.add(br.readLine());
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(File file, List<String> lines) throws IOException {
        PrintWriter pr = null;
        try {
            pr = new PrintWriter(new FileWriter(file));
            for (String line : lines) {
                pr.println(line);
            }
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(pr);
            throw throwable;
        }
        IOToolkit.closeSilently(pr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadFromStream(InputStream is) throws IOException {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedInputStream bis = new BufferedInputStream(is);
            BufferedReader r = new BufferedReader(new InputStreamReader(bis));
            while (r.ready()) {
                lines.add(r.readLine());
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            IOToolkit.closeSilently(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream in, File toOutput, boolean append) throws IOException {
        FileOutputStream fos = new FileOutputStream(toOutput, append);
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(fos);
            IOToolkit.copy(in, os);
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(os);
            IOToolkit.closeSilently(fos);
            throw throwable;
        }
        IOToolkit.closeSilently(os);
        IOToolkit.closeSilently(fos);
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        IOToolkit.copy(is, os, 1024);
    }

    public static void copy(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int length;
        byte[] buffer = new byte[bufferSize];
        while ((length = is.read(buffer)) > 0) {
            os.write(buffer, 0, length);
        }
        is.close();
    }

    public static void copyFile(File srcFile, File targetFile) throws IOException {
        Files.copy(srcFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static String calculateFileHash(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            int read;
            long seek = raf.length() / 10L;
            byte[] buffer = new byte[1024];
            MessageDigest hash = MessageDigest.getInstance("MD5");
            while ((read = raf.read(buffer)) > 0) {
                hash.update(buffer, 0, read);
                raf.seek(raf.getFilePointer() + seek);
            }
            String string = new BigInteger(1, hash.digest()).toString();
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOToolkit.closeSilently(raf);
        }
    }
}

