/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.graalvm.visualvm.lib.jfluid.global.Platform;
import org.graalvm.visualvm.lib.jfluid.utils.FileOrZipEntry;

public class MiscUtils {
    private static final String NOT_DIRECTORY_MSG;
    private static final String NOT_FILE_MSG;
    private static final String FILE_NOT_READABLE_MSG;
    private static final String FILE_NOT_EXIST_MSG;
    private static final String VM_VERSION_MSG;
    private static final String VM_UNKNOWN_MSG;
    private static final String VM_INCOMPATIBLE_MSG;
    private static boolean verbosePrint;
    private static boolean printInfo;

    public static String getAbsoluteFilePath(String fileName, String baseDir) {
        boolean local = false;
        if (fileName.startsWith(".")) {
            local = true;
        } else if (Platform.isWindows()) {
            if (fileName.charAt(0) != '\\' && fileName.charAt(0) != '/' && (fileName.length() <= 1 || fileName.charAt(1) != ':')) {
                local = true;
            }
        } else if (fileName.charAt(0) != '/' && fileName.charAt(0) != '~') {
            local = true;
        }
        if (local) {
            fileName = baseDir + "/" + fileName;
        }
        return fileName;
    }

    public static void getAllClassesInDir(String dirName, String packageName, boolean removeClassExt, Collection res) {
        File dir = new File(dirName);
        String[] fileNames = dir.list();
        if (fileNames == null) {
            return;
        }
        for (int i = 0; i < fileNames.length; ++i) {
            if (fileNames[i].endsWith(".class")) {
                String className = packageName + (removeClassExt ? fileNames[i].substring(0, fileNames[i].length() - 6) : fileNames[i]);
                res.add(className.intern());
                continue;
            }
            String subDirName = dirName + File.separator + fileNames[i];
            File subDir = new File(subDirName);
            if (!subDir.exists() || !subDir.isDirectory()) continue;
            String subPackage = packageName + fileNames[i] + "/";
            MiscUtils.getAllClassesInDir(subDirName, subPackage, removeClassExt, res);
        }
    }

    public static void getAllClassesInJar(String jarName, boolean removeClassExt, Collection res) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(jarName);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String className = entry.getName();
                if (!className.endsWith(".class")) continue;
                if (removeClassExt) {
                    className = className.substring(0, className.length() - 6);
                }
                res.add(className.intern());
            }
            zip.close();
        }
        catch (Exception ex) {
            System.err.println("Warning: could not open archive " + jarName);
            return;
        }
    }

    public static String getCanonicalPath(File file) {
        try {
            if (!file.exists()) {
                return null;
            }
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getClassNameForSource(String sourceFileName, String mainSourcePath, String secondarySourcePath, String workingDir) {
        if (sourceFileName.charAt(1) == ':' && !Character.isLowerCase(sourceFileName.charAt(0))) {
            sourceFileName = sourceFileName.substring(0, 1).toLowerCase() + sourceFileName.substring(1);
        }
        for (int i = 0; i < 2; ++i) {
            String sourcePath;
            String string = sourcePath = i == 0 ? mainSourcePath : secondarySourcePath;
            if (sourcePath == null) continue;
            List paths = MiscUtils.getPathComponents(sourcePath, true, workingDir);
            for (int j = 0; j < paths.size(); ++j) {
                String path = (String)paths.get(j);
                if (path.charAt(1) == ':' && !Character.isLowerCase(path.charAt(0))) {
                    path = path.substring(0, 1).toLowerCase() + path.substring(1);
                }
                if (!path.endsWith(File.separator)) {
                    path = path + File.separator;
                }
                if (!sourceFileName.startsWith(path)) continue;
                String className = sourceFileName.substring(path.length(), sourceFileName.length() - 5);
                return className.replace(File.separatorChar, '.');
            }
        }
        return null;
    }

    public static String getFirstPathComponent(String path) {
        int pos = path.indexOf(File.pathSeparatorChar);
        if (pos == -1) {
            return path;
        }
        return path.substring(0, pos);
    }

    public static String getJDKVersionForJVMExeFile(File exeFile) throws IOException {
        int readBytes;
        String[] cmdLine = new String[]{exeFile.getAbsolutePath(), "-version"};
        Process javaProcess = Runtime.getRuntime().exec(cmdLine);
        InputStream bis = javaProcess.getErrorStream();
        int maxLen = 500;
        int ofs = 0;
        byte[] bytes = new byte[maxLen];
        do {
            int availBytes;
            if ((availBytes = bis.available()) == 0) {
                availBytes = 1;
            }
            if (ofs + availBytes >= maxLen) {
                availBytes = maxLen - ofs;
            }
            if ((readBytes = bis.read(bytes, ofs, availBytes)) == -1) continue;
            ofs += readBytes;
        } while (readBytes != -1 && ofs < maxLen);
        bis.close();
        String outString = new String(bytes, 0, ofs);
        String printOutString = "\n" + VM_VERSION_MSG + "\n" + outString;
        int pos = outString.indexOf(34);
        if (pos == -1) {
            throw new IOException(VM_UNKNOWN_MSG + printOutString);
        }
        outString = outString.substring(pos + 1);
        return Platform.getJDKVersionString(outString);
    }

    public static String getLiveClassPathSubset(String path, String workingDir) {
        List liveComponents = MiscUtils.getPathComponents(path, true, workingDir);
        StringBuilder buf = new StringBuilder(liveComponents.size() * 10);
        if (liveComponents.size() > 0) {
            buf.append((String)liveComponents.get(0));
            for (int i = 1; i < liveComponents.size(); ++i) {
                buf.append(File.pathSeparator);
                buf.append((String)liveComponents.get(i));
            }
        }
        return buf.toString();
    }

    public static List getPathComponents(String path, boolean doCheck, String workingDir) {
        ArrayList<String> list = new ArrayList<String>();
        if (path != null) {
            StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                boolean addedToList = false;
                if (name == null || name.length() == 0) continue;
                if (doCheck) {
                    name = MiscUtils.getAbsoluteFilePath(name, workingDir);
                    if ((name = MiscUtils.getCanonicalPath(new File(name))) != null && !list.contains(name)) {
                        list.add(name);
                        addedToList = true;
                    }
                } else {
                    list.add(name);
                    addedToList = true;
                }
                if (!addedToList) continue;
                try {
                    MiscUtils.getClassPathFromManifest(name, list);
                }
                catch (URISyntaxException ex) {
                    System.out.println("Error processing " + name);
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    System.out.println("Error processing " + name);
                    ex.printStackTrace();
                }
            }
        }
        return list;
    }

    private static void getClassPathFromManifest(String jarPath, List pathList) throws IOException, URISyntaxException {
        if (jarPath.toLowerCase(Locale.ENGLISH).endsWith(".jar")) {
            String jarCp;
            Attributes attrs;
            File pathFile = new File(jarPath);
            JarFile jarFile = new JarFile(pathFile);
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attrs = manifest.getMainAttributes()) != null && (jarCp = attrs.getValue(Attributes.Name.CLASS_PATH)) != null) {
                File parent = pathFile.getParentFile();
                StringTokenizer tokens = new StringTokenizer(jarCp);
                while (tokens.hasMoreTokens()) {
                    URI fileUri = new URI(tokens.nextToken());
                    File cpFile = !fileUri.isAbsolute() ? new File(parent, fileUri.getPath()) : new File(fileUri);
                    String cpName = MiscUtils.getCanonicalPath(cpFile);
                    if (cpName == null || pathList.contains(cpName)) continue;
                    pathList.add(cpName);
                    MiscUtils.getClassPathFromManifest(cpName, pathList);
                }
            }
            jarFile.close();
        }
    }

    private static boolean addToList(File file, List path) {
        String pathName = MiscUtils.getCanonicalPath(file);
        if (pathName != null && !path.contains(pathName)) {
            path.add(pathName);
            return true;
        }
        return false;
    }

    public static void setSilent(boolean silent) {
        printInfo = !silent;
    }

    public static boolean isSlashedJavaCoreClassName(String name) {
        return name.startsWith("java/") || name.startsWith("sun/") || name.startsWith("javax/");
    }

    public static boolean isSupportedJVM(Map jdkProperties) {
        String jdkVersionString = (String)jdkProperties.get("java.version");
        String vmNameString = (String)jdkProperties.get("java.vm.name");
        if (jdkVersionString == null || vmNameString == null) {
            return false;
        }
        if (MiscUtils.isSupportedJDK(jdkVersionString)) {
            return true;
        }
        return MiscUtils.isSupportedJDK(vmNameString);
    }

    public static boolean isSupportedRunningJVMVersion(String jdkVersionString) {
        return MiscUtils.isSupportedJDK(jdkVersionString);
    }

    public static void setVerbosePrint() {
        verbosePrint = true;
    }

    public static File checkDirForName(String name) throws IOException {
        File file = new File(name);
        return MiscUtils.checkFile(file, true);
    }

    public static File checkFile(File file, boolean isDir) throws IOException {
        if (file.exists()) {
            if (isDir) {
                if (!file.isDirectory()) {
                    throw new IOException(MessageFormat.format(NOT_DIRECTORY_MSG, file));
                }
            } else if (!file.isFile()) {
                throw new IOException(MessageFormat.format(NOT_FILE_MSG, file));
            }
            if (!file.canRead()) {
                throw new IOException(MessageFormat.format(FILE_NOT_READABLE_MSG, file));
            }
            return file;
        }
        throw new IOException(FILE_NOT_EXIST_MSG);
    }

    public static File checkFileForName(String name) throws IOException {
        File file = new File(name);
        return MiscUtils.checkFile(file, false);
    }

    public static boolean containsDirectoryOnPath(String directory, String path) {
        String normalizedDirectory = new File(directory).getAbsolutePath().toLowerCase(Locale.ENGLISH);
        String normalizedPath = new File(path).getAbsolutePath().toLowerCase(Locale.ENGLISH);
        List pathComponents = MiscUtils.getPathComponents(normalizedPath, false, null);
        for (int i = 0; i < pathComponents.size(); ++i) {
            if (!normalizedDirectory.equals(pathComponents.get(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHeapTempFiles() {
        if (Platform.isWindows()) {
            try {
                File tempDir = new File(System.getProperty("java.io.tmpdir"));
                try (DirectoryStream<Path> files = Files.newDirectoryStream(tempDir.toPath());){
                    for (Path p : files) {
                        String fname = p.toFile().getName();
                        if (!fname.startsWith("NBProfiler") || !fname.endsWith(".map") && !fname.endsWith(".ref") && !fname.endsWith(".gc")) continue;
                        Files.delete(p);
                    }
                }
            }
            catch (IOException ex) {
                System.err.println("deleteHeapTempFiles failed");
                ex.printStackTrace();
            }
        }
    }

    public static boolean fileForNameOk(String name) {
        try {
            MiscUtils.checkFileForName(name);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean inSamePackage(String className1, String className2) {
        int ldi2;
        int ldi1 = className1.lastIndexOf(46);
        if (ldi1 != (ldi2 = className2.lastIndexOf(46))) {
            return false;
        }
        if (ldi1 == -1) {
            return true;
        }
        return className1.substring(0, ldi1).equals(className2.substring(0, ldi2));
    }

    public static void internalError(String message) {
        throw new InternalError(message);
    }

    public static void printErrorMessage(String message) {
        System.err.println("*** Profiler error (" + MiscUtils.getDate() + "): " + message);
    }

    public static void printInfoMessage(String message) {
        if (printInfo) {
            System.err.println("*** Profiler message (" + MiscUtils.getDate() + "): " + message);
        }
    }

    public static void printVerboseInfoMessage(String message) {
        if (verbosePrint) {
            System.err.println("Profiler Engine: " + message);
        }
    }

    public static void printVerboseInfoMessage(String[] elements) {
        int i;
        if (!verbosePrint) {
            return;
        }
        for (i = 0; i < elements.length - 1; ++i) {
            System.err.print(elements[i]);
            System.err.print(" ");
        }
        System.err.println(elements[i]);
    }

    public static void printWarningMessage(String message) {
        System.err.println("*** Profiler warning (" + MiscUtils.getDate() + "): " + message);
    }

    public static byte[] readFileIntoBuffer(FileOrZipEntry fileOrZip) throws IOException {
        int readBytes;
        if (fileOrZip.isFile()) {
            MiscUtils.checkFile(fileOrZip.getFile(), false);
        }
        InputStream in = fileOrZip.getInputStream();
        int len = (int)fileOrZip.getLength();
        byte[] buf = new byte[len];
        int ofs = 0;
        int remBytes = len;
        do {
            readBytes = in.read(buf, ofs, remBytes);
            remBytes -= readBytes;
        } while ((ofs += readBytes) < len);
        in.close();
        return buf;
    }

    private static String getDate() {
        return new Date().toString();
    }

    private static boolean isSupportedJDK(String jdkVersionString) {
        int jdkVersionNumber = Platform.getJDKVersionNumber(jdkVersionString);
        if (jdkVersionNumber == 2) {
            return !jdkVersionString.equals("1.5.0") && !jdkVersionString.startsWith("1.5.0_01") && !jdkVersionString.startsWith("1.5.0_02") && !jdkVersionString.startsWith("1.5.0_03");
        }
        return jdkVersionNumber != -1;
    }

    static {
        ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.jfluid.utils.Bundle");
        NOT_DIRECTORY_MSG = messages.getString("MiscUtils_NotDirectoryMsg");
        NOT_FILE_MSG = messages.getString("MiscUtils_NotFileMsg");
        FILE_NOT_READABLE_MSG = messages.getString("MiscUtils_FileNotReadableMsg");
        FILE_NOT_EXIST_MSG = messages.getString("MiscUtils_FileNotExistMsg");
        VM_VERSION_MSG = messages.getString("MiscUtils_VmVersionMsg");
        VM_UNKNOWN_MSG = messages.getString("MiscUtils_VmUnknownMsg");
        VM_INCOMPATIBLE_MSG = messages.getString("MiscUtils_VmIncompatibleMsg");
        verbosePrint = false;
        printInfo = true;
    }
}

