/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.oql;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualvm.heapviewer.oql.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.OQLSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;

public class OQLQueryCustomizer {
    public static OQLSupport.Query saveCustomizer(OQLSupport.Query query, String script) {
        String description;
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)Bundle.OQLQueryCustomizer_OkButtonText());
        String name = query == null ? Bundle.OQLQueryCustomizer_DefaultQueryName() : query.getName();
        String string = description = query == null ? null : query.getDescription();
        if (description != null && new File(description).isFile()) {
            description = null;
        }
        CustomizerPanel customizer = new CustomizerPanel(name, description, okButton);
        DialogDescriptor dd = new DialogDescriptor((Object)customizer, Bundle.OQLQueryCustomizer_SaveQueryCaption(), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == okButton) {
            return new OQLSupport.Query(script, customizer.name(), customizer.description());
        }
        return null;
    }

    private static class CustomizerPanel
    extends JPanel {
        private final JComponent submitComponent;
        private JLabel nameLabel;
        private JTextField nameField;
        private JLabel descriptionLabel;
        private JTextArea descriptionArea;

        CustomizerPanel(String name, String description, JComponent submitComponent) {
            this.submitComponent = submitComponent;
            this.initComponents(name, description, false);
            this.updateComponents();
        }

        public String name() {
            return this.nameField.getText().trim();
        }

        public String description() {
            String description = this.descriptionArea.getText().trim();
            return description.isEmpty() ? null : description;
        }

        private void updateComponents() {
            this.submitComponent.setEnabled(!this.nameField.getText().trim().isEmpty());
        }

        private void initComponents(String name, String description, boolean readOnly) {
            this.setLayout(new GridBagLayout());
            this.nameLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)Bundle.OQLQueryCustomizer_NameLabelText());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(16, 16, 8, 8);
            this.add((Component)this.nameLabel, c);
            this.nameField = new JTextField();
            this.nameLabel.setLabelFor(this.nameField);
            this.nameField.setText(name);
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateComponents();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateComponents();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateComponents();
                }
            });
            this.nameField.setEditable(!readOnly);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(16, 0, 8, 16);
            this.add((Component)this.nameField, c);
            this.descriptionLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)Bundle.OQLQueryCustomizer_DescriptionLabelText());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(8, 16, 8, 8);
            this.add((Component)this.descriptionLabel, c);
            this.descriptionArea = new JTextArea(description);
            this.descriptionLabel.setLabelFor(this.descriptionArea);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setWrapStyleWord(true);
            this.descriptionArea.setFont(this.descriptionLabel.getFont());
            this.descriptionArea.setRows(5);
            final int prefWidth = new JLabel((String)"A lengthy string serving as OQL script description sizer").getPreferredSize().width;
            JScrollPane descriptionAreaScroll = new JScrollPane(this.descriptionArea, 20, 30){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(prefWidth, super.getPreferredSize().height);
                }
            };
            this.descriptionArea.setEditable(!readOnly);
            if (readOnly) {
                this.descriptionArea.setBackground(this.nameField.getBackground());
            }
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 3;
            c.weighty = 1.0;
            c.gridwidth = 0;
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(0, 0, 16, 16);
            this.add((Component)descriptionAreaScroll, c);
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                        this.removeHierarchyListener(this);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                nameField.requestFocus();
                                nameField.selectAll();
                            }
                        });
                    }
                }
            });
        }
    }
}

