/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

public class CallBlock
extends BlockBody {
    private final BlockCallback callback;
    private final StaticScope dummyScope;

    public static Block newCallClosure(IRubyObject self2, RubyModule imClass, Signature signature, BlockCallback callback, ThreadContext context) {
        return CallBlock.newCallClosure(context, self2, signature, callback);
    }

    public static Block newCallClosure(ThreadContext context, IRubyObject self2, Signature signature, BlockCallback callback) {
        Binding binding2 = context.currentBinding(self2, Visibility.PUBLIC);
        CallBlock body = new CallBlock(context, signature, callback);
        return new Block(body, binding2);
    }

    private CallBlock(ThreadContext context, Signature signature, BlockCallback callback) {
        super(signature);
        this.callback = callback;
        this.dummyScope = context.runtime.getStaticScopeFactory().getDummyScope();
    }

    static IRubyObject[] adjustArgs(Block block, IRubyObject[] args2) {
        Signature signature = block.getSignature();
        int required = signature.required();
        if (required > 0 && required < args2.length && signature.isFixed()) {
            args2 = ArraySupport.newCopy(args2, required);
        }
        return args2;
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2) {
        return this.callback.call(context, CallBlock.adjustArgs(block, args2), Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        return this.callback.call(context, CallBlock.adjustArgs(block, args2), blockArg);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Block block) {
        return this.callback.call(context, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0) {
        return this.callback.call(context, arg0, Block.NULL_BLOCK);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
        return this.callback.call(context, value2, Block.NULL_BLOCK);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        return this.callback.call(context, CallBlock.adjustArgs(block, args2));
    }

    @Override
    public StaticScope getStaticScope() {
        return this.dummyScope;
    }

    @Override
    public void setStaticScope(StaticScope newScope) {
    }

    @Override
    public String getFile() {
        return "(internal)";
    }

    @Override
    public int getLine() {
        return -1;
    }
}

