/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.LogRecord;
import org.apache.juli.FileHandler;

public class AsyncFileHandler
extends FileHandler {
    public static final int OVERFLOW_DROP_LAST = 1;
    public static final int OVERFLOW_DROP_FIRST = 2;
    public static final int OVERFLOW_DROP_FLUSH = 3;
    public static final int OVERFLOW_DROP_CURRENT = 4;
    public static final int DEFAULT_OVERFLOW_DROP_TYPE = 1;
    public static final int DEFAULT_MAX_RECORDS = 10000;
    public static final int OVERFLOW_DROP_TYPE = Integer.parseInt(System.getProperty("org.apache.juli.AsyncOverflowDropType", Integer.toString(1)));
    public static final int MAX_RECORDS = Integer.parseInt(System.getProperty("org.apache.juli.AsyncMaxRecordCount", Integer.toString(10000)));
    protected static final LinkedBlockingDeque<LogEntry> queue = new LinkedBlockingDeque(MAX_RECORDS);
    protected static final LoggerThread logger = new LoggerThread();
    private final Object closeLock = new Object();
    protected volatile boolean closed = false;

    public AsyncFileHandler() {
        this(null, null, null);
    }

    public AsyncFileHandler(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public AsyncFileHandler(String string, String string2, String string3, Integer n) {
        super(string, string2, string3, n);
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        LoggerThread.deregisterHandler();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void open() {
        if (!this.closed) {
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                return;
            }
            this.closed = false;
        }
        LoggerThread.registerHandler();
        super.open();
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        logRecord.getSourceMethodName();
        LogEntry logEntry = new LogEntry(logRecord, this);
        boolean bl = false;
        try {
            while (!bl && !queue.offer(logEntry)) {
                switch (OVERFLOW_DROP_TYPE) {
                    case 1: {
                        queue.pollLast();
                        break;
                    }
                    case 2: {
                        queue.pollFirst();
                        break;
                    }
                    case 3: {
                        bl = queue.offer(logEntry, 1000L, TimeUnit.MILLISECONDS);
                        break;
                    }
                    case 4: {
                        bl = true;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void publishInternal(LogRecord logRecord) {
        super.publish(logRecord);
    }

    static {
        logger.start();
    }

    protected static class LogEntry {
        private final LogRecord record;
        private final AsyncFileHandler handler;

        public LogEntry(LogRecord logRecord, AsyncFileHandler asyncFileHandler) {
            this.record = logRecord;
            this.handler = asyncFileHandler;
        }

        public boolean flush() {
            if (this.handler.closed) {
                return false;
            }
            this.handler.publishInternal(this.record);
            return true;
        }
    }

    protected static class LoggerThread
    extends Thread {
        private static final AtomicInteger handlerCount = new AtomicInteger();

        public static void registerHandler() {
            handlerCount.incrementAndGet();
        }

        public static void deregisterHandler() {
            int n = handlerCount.decrementAndGet();
            if (n == 0) {
                try {
                    Thread thread = new Thread();
                    Runtime.getRuntime().addShutdownHook(thread);
                    Runtime.getRuntime().removeShutdownHook(thread);
                }
                catch (IllegalStateException illegalStateException) {
                    for (int i = 0; !queue.isEmpty() && i < 10000; ++i) {
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public LoggerThread() {
            this.setDaemon(true);
            this.setName("AsyncFileHandlerWriter-" + System.identityHashCode(this));
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        LogEntry logEntry = queue.take();
                        logEntry.flush();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

