/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.openide.util.VectorIcon;

final class Windows8VectorTabControlIcon
extends VectorIcon {
    private static final Map<Map.Entry<Integer, Integer>, Icon> INSTANCES = Windows8VectorTabControlIcon.populateInstances();
    private final int buttonId;
    private final int buttonState;

    private static void populateOne(Map<Map.Entry<Integer, Integer>, Icon> map, int n, int n2) {
        map.put(new AbstractMap.SimpleEntry<Integer, Integer>(n, n2), (Icon)((Object)new Windows8VectorTabControlIcon(n, n2)));
    }

    private static Map<Map.Entry<Integer, Integer>, Icon> populateInstances() {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put("close", 1);
        linkedHashMap.put("pin", 2);
        linkedHashMap.put("restore_group", 11);
        linkedHashMap.put("slide_group", 12);
        linkedHashMap.put("scroll_left", 9);
        linkedHashMap.put("scroll_right", 10);
        linkedHashMap.put("drop_down", 8);
        linkedHashMap.put("maximize", 3);
        linkedHashMap.put("restore", 4);
        LinkedHashMap<String, Integer> linkedHashMap2 = new LinkedHashMap<String, Integer>();
        linkedHashMap2.put("default", 0);
        linkedHashMap2.put("pressed", 1);
        linkedHashMap2.put("disabled", 2);
        linkedHashMap2.put("rollover", 3);
        LinkedHashMap<Map.Entry<Integer, Integer>, Icon> linkedHashMap3 = new LinkedHashMap<Map.Entry<Integer, Integer>, Icon>();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            for (Map.Entry entry2 : linkedHashMap2.entrySet()) {
                Windows8VectorTabControlIcon.populateOne(linkedHashMap3, (Integer)entry.getValue(), (Integer)entry2.getValue());
            }
        }
        return Collections.unmodifiableMap(linkedHashMap3);
    }

    private Windows8VectorTabControlIcon(int n, int n2) {
        super(14, 14);
        this.buttonId = n;
        this.buttonState = n2;
    }

    public static Icon get(int n, int n2) {
        return INSTANCES.get(new AbstractMap.SimpleEntry<Integer, Integer>(n, n2));
    }

    protected void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, double d) {
        Color color;
        Color color2 = new Color(0, 0, 0, 0);
        Color color3 = new Color(86, 86, 86, 255);
        Color color4 = color = this.buttonId == 1 ? new Color(199, 79, 80, 255) : null;
        if (this.buttonState == 2) {
            color3 = new Color(0, 0, 0, 45);
        } else if (this.buttonState == 1) {
            color2 = color != null ? color : new Color(57, 100, 178, 255);
            color3 = Color.WHITE;
        } else if (this.buttonState == 3) {
            color2 = color != null ? color : new Color(0, 0, 0, 70);
            color3 = Color.WHITE;
        }
        if (color2.getAlpha() > 0) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, n, n2);
        }
        graphics2D.setColor(color3);
        if (this.buttonId == 1) {
            if (this.getIconWidth() == n && this.getIconHeight() == n2) {
                Windows8VectorTabControlIcon.setAntiAliasing((Graphics2D)graphics2D, (boolean)false);
            }
            double d2 = (color2.getAlpha() > 0 ? 1.0 : 0.8) * d;
            if (d > 1.0) {
                d2 *= 1.5;
            }
            double d3 = 3.5 * d;
            int n3 = Windows8VectorTabControlIcon.round((double)(3.0 * d));
            int n4 = Windows8VectorTabControlIcon.round((double)(4.0 * d));
            graphics2D.clip(new Rectangle2D.Double(0.0, n3, n, n2 - n3 - n4));
            graphics2D.setStroke(new BasicStroke((float)d2));
            graphics2D.draw(new Line2D.Double(d3, n3, (double)n - d3, n2 - n4));
            graphics2D.draw(new Line2D.Double((double)n - d3, n3, d3, n2 - n4));
        } else if (this.buttonId == 2 || this.buttonId == 11 || this.buttonId == 4) {
            int n5 = Windows8VectorTabControlIcon.round((double)(2.0 * d));
            int n6 = Windows8VectorTabControlIcon.round((double)(6.5 * d));
            int n7 = Windows8VectorTabControlIcon.round((double)(5.5 * d));
            int n8 = n - n5 - n6;
            int n9 = n5;
            int n10 = n5;
            int n11 = Windows8VectorTabControlIcon.round((double)(5.5 * d));
            Area area = Windows8VectorTabControlIcon.getWindowSymbol(d, n8, n9, n6, n7);
            Area area2 = Windows8VectorTabControlIcon.getWindowSymbol(d, n10, n11, n6, n7);
            area.subtract(new Area(area2.getBounds2D()));
            graphics2D.fill(area);
            graphics2D.fill(area2);
        } else if (this.buttonId == 3) {
            int n12 = Windows8VectorTabControlIcon.round((double)(2.2 * d));
            int n13 = Windows8VectorTabControlIcon.round((double)(3.0 * d));
            int n14 = Windows8VectorTabControlIcon.round((double)(7.5 * d));
            graphics2D.fill(Windows8VectorTabControlIcon.getWindowSymbol(d, n12, n13, n - 2 * n12, n14));
        } else if (this.buttonId == 12) {
            int n15;
            int n16 = n15 = Windows8VectorTabControlIcon.round((double)(2.0 * d));
            int n17 = Windows8VectorTabControlIcon.round((double)(8.0 * d));
            int n18 = n - n15 * 2;
            int n19 = Windows8VectorTabControlIcon.round((double)(1.8 * d));
            graphics2D.fill(new Rectangle2D.Double(n16, n17, n18, n19));
        } else if (this.buttonId == 8 || this.buttonId == 9 || this.buttonId == 10) {
            if (this.getIconWidth() == n && this.getIconHeight() == n2) {
                Windows8VectorTabControlIcon.setAntiAliasing((Graphics2D)graphics2D, (boolean)false);
            }
            if (this.buttonId == 9) {
                graphics2D.translate(-Windows8VectorTabControlIcon.round((double)(1.0 * d)), 0);
                graphics2D.rotate(1.5707963267948966, (double)n / 2.0, (double)n2 / 2.0);
            } else if (this.buttonId == 10) {
                graphics2D.translate(Windows8VectorTabControlIcon.round((double)(1.0 * d)), 0);
                graphics2D.rotate(-1.5707963267948966, (double)n / 2.0, (double)n2 / 2.0);
            }
            int n20 = Windows8VectorTabControlIcon.round((double)(4.0 * d));
            double d4 = (d == 1.0 ? 12.0 : 10.0) * d;
            double d5 = 5.0 * d;
            double d6 = ((double)n - d4) / 2.0;
            double d7 = d6 + d4 / 2.0;
            Path2D.Double double_ = new Path2D.Double();
            double_.moveTo(d7 - d4 / 2.0, n20);
            double_.lineTo(d7, (double)n20 + d5);
            double_.lineTo(d7 + d4 / 2.0, n20);
            double_.closePath();
            graphics2D.fill(double_);
        }
    }

    private static Area getWindowSymbol(double d, int n, int n2, int n3, int n4) {
        int n5 = Windows8VectorTabControlIcon.round((double)(0.8 * d));
        int n6 = Math.max(Windows8VectorTabControlIcon.round((double)(1.8 * d)), n5 + 1);
        Area area = new Area(new Rectangle2D.Double(n, n2, n3, n4));
        area.subtract(new Area(new Rectangle2D.Double(n + n5, n2 + n6, n3 - n5 * 2, n4 - n5 - n6)));
        return area;
    }
}

