/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.actions.Closable;
import org.netbeans.api.actions.Editable;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.actions.Printable;
import org.netbeans.api.actions.Viewable;
import org.openide.awt.AcceleratorBinding;
import org.openide.awt.ActionDefaultPerfomer;
import org.openide.awt.AlwaysEnabledAction;
import org.openide.awt.ContextAction;
import org.openide.awt.ContextSelection;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.GeneralAction;
import org.openide.awt.InjectorAny;
import org.openide.awt.InjectorExactlyOne;
import org.openide.awt.JMenuPlus;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.SystemAction;

public class Actions {
    public static final String ACTION_VALUE_VISIBLE = "openide.awt.actionVisible";
    public static final String ACTION_VALUE_TOGGLE = "openide.awt.actionToggle";
    private static final String IDENTIFIER = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
    private static final Pattern FQN = Pattern.compile("(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)(?:[.](?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*))*");
    private static final ButtonActionConnectorGetter GET = new ButtonActionConnectorGetter();

    @Deprecated
    public Actions() {
    }

    private static Icon nonNullIcon(Icon icon) {
        return null;
    }

    public static String findKey(SystemAction systemAction) {
        return Actions.findKey((Action)systemAction);
    }

    private static String findKey(Action action) {
        if (action == null) {
            return null;
        }
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke == null) {
            return null;
        }
        int n = keyStroke.getModifiers();
        String string = "";
        if (n > 0) {
            string = KeyEvent.getKeyModifiersText(n);
            string = string + "+";
        } else if (keyStroke.getKeyCode() == 0) {
            return "";
        }
        string = string + KeyEvent.getKeyText(keyStroke.getKeyCode());
        return string;
    }

    @Deprecated
    public static void connect(JMenuItem jMenuItem, SystemAction systemAction, boolean bl) {
        Actions.connect(jMenuItem, (Action)systemAction, bl);
    }

    public static void connect(JMenuItem jMenuItem, Action action, boolean bl) {
        for (ButtonActionConnector buttonActionConnector : Actions.buttonActionConnectors()) {
            if (!buttonActionConnector.connect(jMenuItem, action, bl)) continue;
            return;
        }
        ButtonBridge buttonBridge = jMenuItem instanceof JCheckBoxMenuItem && action.getValue(ACTION_VALUE_TOGGLE) != null ? new CheckMenuBridge((JCheckBoxMenuItem)jMenuItem, action, bl) : new MenuBridge(jMenuItem, action, bl);
        buttonBridge.prepare();
        if (jMenuItem instanceof MenuItem) {
            ((MenuItem)jMenuItem).setBridge(buttonBridge);
        }
        jMenuItem.putClientProperty("hideWhenDisabled", action.getValue("hideWhenDisabled"));
    }

    @Deprecated
    public static void connect(JCheckBoxMenuItem jCheckBoxMenuItem, BooleanStateAction booleanStateAction, boolean bl) {
        CheckMenuBridge checkMenuBridge = new CheckMenuBridge(jCheckBoxMenuItem, booleanStateAction, bl);
        checkMenuBridge.prepare();
    }

    public static void connect(JCheckBoxMenuItem jCheckBoxMenuItem, Action action, boolean bl) {
        CheckMenuBridge checkMenuBridge = new CheckMenuBridge(jCheckBoxMenuItem, action, bl);
        checkMenuBridge.prepare();
    }

    @Deprecated
    public static void connect(AbstractButton abstractButton, SystemAction systemAction) {
        Actions.connect(abstractButton, (Action)systemAction);
    }

    public static void connect(AbstractButton abstractButton, Action action) {
        for (ButtonActionConnector buttonActionConnector : Actions.buttonActionConnectors()) {
            if (!buttonActionConnector.connect(abstractButton, action)) continue;
            return;
        }
        ButtonBridge buttonBridge = action instanceof BooleanStateAction ? new BooleanButtonBridge(abstractButton, (BooleanStateAction)action) : (action.getValue(ACTION_VALUE_TOGGLE) != null ? new BooleanButtonBridge(abstractButton, action) : new ButtonBridge(abstractButton, action));
        buttonBridge.prepare();
        abstractButton.putClientProperty("hideWhenDisabled", action.getValue("hideWhenDisabled"));
    }

    public static void connect(AbstractButton abstractButton, BooleanStateAction booleanStateAction) {
        BooleanButtonBridge booleanButtonBridge = new BooleanButtonBridge(abstractButton, booleanStateAction);
        booleanButtonBridge.prepare();
    }

    @Deprecated
    public static void setMenuText(AbstractButton abstractButton, String string, boolean bl) {
        String string2 = NbBundle.getMessage(Actions.class, (String)"USE_MNEMONICS");
        if ("always".equals(string2)) {
            bl = true;
        } else if ("never".equals(string2)) {
            bl = false;
        } else assert ("default".equals(string2));
        if (bl) {
            Mnemonics.setLocalizedText(abstractButton, string);
        } else {
            abstractButton.setText(Actions.cutAmpersand(string));
        }
    }

    public static String cutAmpersand(String string) {
        if (null == string) {
            return null;
        }
        String string2 = string;
        int n = string.indexOf("(&");
        string2 = n >= 0 && n + 3 < string.length() && string.charAt(n + 3) == ')' ? string.substring(0, n) + string.substring(n + 4) : ((n = string.indexOf(38)) < 0 ? string : (n == string.length() - 1 ? string.substring(0, n) : (" ".equals(string.substring(n + 1, n + 2)) ? string : string.substring(0, n) + string.substring(n + 1))));
        return string2;
    }

    public static Action alwaysEnabled(ActionListener actionListener, String string, String string2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("delegate", actionListener);
        hashMap.put("displayName", string);
        hashMap.put("iconBase", string2);
        hashMap.put("noIconInMenu", bl);
        return Actions.alwaysEnabled(hashMap);
    }

    static Action alwaysEnabled(Map map) {
        return AlwaysEnabledAction.create(map);
    }

    public static Action checkbox(String string, String string2, String string3, String string4, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("preferencesNode", string);
        hashMap.put("preferencesKey", string2);
        hashMap.put("displayName", string3);
        hashMap.put("iconBase", string4);
        hashMap.put("noIconInMenu", bl);
        return Actions.checkbox(hashMap);
    }

    static Action checkbox(Map map) {
        return AlwaysEnabledAction.create(map);
    }

    public static ContextAwareAction callback(String string, Action action, boolean bl, String string2, String string3, boolean bl2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", string);
        hashMap.put("surviveFocusChange", bl);
        hashMap.put("fallback", action);
        hashMap.put("displayName", string2);
        hashMap.put("iconBase", string3);
        hashMap.put("noIconInMenu", bl2);
        return Actions.callback(hashMap);
    }

    static ContextAwareAction callback(Map map) {
        return GeneralAction.callback(map);
    }

    public static ContextAwareAction context(Class<?> clazz, boolean bl, boolean bl2, ContextAwareAction contextAwareAction, String string, String string2, String string3, boolean bl3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", string);
        hashMap.put("surviveFocusChange", bl2);
        hashMap.put("delegate", contextAwareAction);
        hashMap.put("type", clazz);
        hashMap.put("selectionType", (Object)(bl ? ContextSelection.EXACTLY_ONE : ContextSelection.ANY));
        hashMap.put("displayName", string2);
        hashMap.put("iconBase", string3);
        hashMap.put("noIconInMenu", bl3);
        return GeneralAction.context(hashMap, true);
    }

    static Action context(Map map) {
        Object v = map.get("context");
        if (v instanceof Lookup) {
            Lookup lookup = (Lookup)v;
            return GeneralAction.bindContext(map, lookup);
        }
        return GeneralAction.context(map);
    }

    static ContextAction.Performer<?> inject(Map map) {
        Object v = map.get("selectionType");
        if (ContextSelection.EXACTLY_ONE.toString().equals(v)) {
            return new InjectorExactlyOne(map);
        }
        if (ContextSelection.ANY.toString().equals(v)) {
            return new InjectorAny(map);
        }
        throw new IllegalStateException("no selectionType parameter in " + map);
    }

    static ContextAction.Performer<?> performer(Map map) {
        String string = (String)map.get("type");
        if (string.equals(Openable.class.getName())) {
            return new ActionDefaultPerfomer(0);
        }
        if (string.equals(Viewable.class.getName())) {
            return new ActionDefaultPerfomer(1);
        }
        if (string.equals(Editable.class.getName())) {
            return new ActionDefaultPerfomer(2);
        }
        if (string.equals(Closable.class.getName())) {
            return new ActionDefaultPerfomer(3);
        }
        if (string.equals(Printable.class.getName())) {
            return new ActionDefaultPerfomer(4);
        }
        throw new IllegalStateException(string);
    }

    public static Action forID(String string, String string2) throws IllegalArgumentException {
        if (string.startsWith("Actions/")) {
            throw new IllegalArgumentException("category should not start with Actions/: " + string);
        }
        if (!FQN.matcher(string2).matches()) {
            throw new IllegalArgumentException("id must be valid fully qualified name: " + string2);
        }
        String string3 = "Actions/" + string + "/" + string2.replace('.', '-') + ".instance";
        Action action = (Action)FileUtil.getConfigObject((String)string3, Action.class);
        if (action == null) {
            return null;
        }
        FileObject fileObject = FileUtil.getConfigFile((String)string3);
        if (fileObject != null) {
            AcceleratorBinding.setAccelerator(action, fileObject);
        }
        return action;
    }

    private static HelpCtx findHelp(Action action) {
        if (action instanceof HelpCtx.Provider) {
            return ((HelpCtx.Provider)action).getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    static void prepareMenuBridgeItemsInContainer(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JComponent jComponent;
            MenuBridge menuBridge;
            if (!(componentArray[i] instanceof JComponent) || (menuBridge = (MenuBridge)(jComponent = (JComponent)componentArray[i]).getClientProperty("menubridgeresizehack")) == null) continue;
            menuBridge.updateState(null);
        }
    }

    static void prepareMargins(JMenuItem jMenuItem, Action action) {
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setHorizontalAlignment(2);
    }

    static void updateKey(JMenuItem jMenuItem, Action action) {
        if (!(jMenuItem instanceof JMenu)) {
            jMenuItem.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
        }
    }

    private static Collection<? extends ButtonActionConnector> buttonActionConnectors() {
        return GET.all();
    }

    private static final class ButtonActionConnectorGetter
    implements LookupListener {
        private final Lookup.Result<ButtonActionConnector> result = Lookup.getDefault().lookupResult(ButtonActionConnector.class);
        private Collection<? extends ButtonActionConnector> all;

        ButtonActionConnectorGetter() {
            this.result.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        final Collection<? extends ButtonActionConnector> all() {
            return this.all;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.all = this.result.allInstances();
            this.all.iterator().hasNext();
        }
    }

    public static interface ButtonActionConnector {
        public boolean connect(AbstractButton var1, Action var2);

        public boolean connect(JMenuItem var1, Action var2, boolean var3);
    }

    @Deprecated
    public static class SubMenu
    extends JMenuPlus
    implements DynamicMenuContent {
        private static final long serialVersionUID = -4446966671302959091L;
        private SubMenuBridge bridge;

        public SubMenu(SystemAction systemAction, SubMenuModel subMenuModel) {
            this(systemAction, subMenuModel, true);
        }

        public SubMenu(SystemAction systemAction, SubMenuModel subMenuModel, boolean bl) {
            this((Action)systemAction, subMenuModel, bl);
        }

        public SubMenu(Action action, SubMenuModel subMenuModel, boolean bl) {
            this.bridge = new SubMenuBridge(new JMenuItem(), this, action, subMenuModel, bl);
            this.bridge.prepare();
        }

        @Override
        public JComponent[] getMenuPresenters() {
            return this.bridge.getMenuPresenters();
        }

        @Override
        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.bridge.synchMenuPresenters(jComponentArray);
        }
    }

    @Deprecated
    public static class ToolbarToggleButton
    extends org.openide.awt.ToolbarToggleButton {
        private static final long serialVersionUID = -4783163952526348942L;

        public ToolbarToggleButton(BooleanStateAction booleanStateAction) {
            super((Icon)null, false);
            Actions.connect((AbstractButton)this, booleanStateAction);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    @Deprecated
    public static class ToolbarButton
    extends org.openide.awt.ToolbarButton {
        private static final long serialVersionUID = 6564434578524381134L;

        public ToolbarButton(SystemAction systemAction) {
            super((Icon)null);
            Actions.connect((AbstractButton)this, systemAction);
        }

        public ToolbarButton(Action action) {
            super((Icon)null);
            Actions.connect((AbstractButton)this, action);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public static class CheckboxMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 6190621106981774043L;

        @Deprecated
        public CheckboxMenuItem(BooleanStateAction booleanStateAction, boolean bl) {
            Actions.connect((JCheckBoxMenuItem)this, booleanStateAction, !bl);
        }

        public CheckboxMenuItem(Action action, boolean bl) {
            Actions.connect((JCheckBoxMenuItem)this, action, !bl);
        }
    }

    public static class MenuItem
    extends JMenuItem
    implements DynamicMenuContent {
        static final long serialVersionUID = -21757335363267194L;
        private Bridge bridge;

        public MenuItem(SystemAction systemAction, boolean bl) {
            Actions.connect((JMenuItem)this, systemAction, !bl);
        }

        public MenuItem(Action action, boolean bl) {
            Actions.connect((JMenuItem)this, action, !bl);
        }

        void setBridge(Bridge bridge) {
            this.bridge = bridge;
        }

        @Override
        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            if (this.bridge != null) {
                this.bridge.updateState(null);
            }
            return this.getMenuPresenters();
        }

        @Override
        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this};
        }
    }

    @Deprecated
    private static final class SubMenuBridge
    extends MenuBridge
    implements ChangeListener,
    DynamicMenuContent {
        private SubMenuModel model;
        private List<JMenuItem> currentOnes;
        private JMenuItem single;
        private JMenu multi;

        public SubMenuBridge(JMenuItem jMenuItem, JMenu jMenu, Action action, SubMenuModel subMenuModel, boolean bl) {
            super(jMenuItem, action, bl);
            this.single = jMenuItem;
            this.multi = jMenu;
            Actions.setMenuText(this.multi, (String)action.getValue("Name"), bl);
            Actions.prepareMargins(jMenuItem, action);
            Actions.prepareMargins(jMenu, action);
            this.currentOnes = new ArrayList<JMenuItem>();
            this.model = subMenuModel;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!EventQueue.isDispatchThread()) {
                new IllegalStateException("This must happen in the event thread!").printStackTrace();
            }
        }

        @Override
        public void updateState(String string) {
            super.updateState(string);
        }

        @Override
        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(null);
        }

        @Override
        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            this.currentOnes.clear();
            int n = this.model.getCount();
            if (n == 0) {
                this.updateState(null);
                this.currentOnes.add(this.single);
                this.single.setEnabled(false);
            } else if (n == 1) {
                this.updateState(null);
                this.currentOnes.add(this.single);
                this.single.setEnabled(this.action.isEnabled());
                HelpCtx helpCtx = this.model.getHelpCtx(0);
                this.associateHelp(this.single, helpCtx == null ? Actions.findHelp(this.action) : helpCtx);
            } else {
                this.currentOnes.add(this.multi);
                this.multi.removeAll();
                Mnemonics.setLocalizedText(this.multi, (String)this.action.getValue("Name"));
                boolean bl = false;
                int n2 = this.model.getCount();
                for (int i = 0; i < n2; ++i) {
                    String string = this.model.getLabel(i);
                    if (string == null) {
                        bl = this.multi.getItemCount() > 0;
                    } else {
                        if (bl) {
                            this.multi.addSeparator();
                            bl = false;
                        }
                        JMenuItem jMenuItem = new JMenuItem();
                        Mnemonics.setLocalizedText(jMenuItem, string);
                        if (i == 0) {
                            Actions.updateKey(jMenuItem, this.action);
                        }
                        jMenuItem.addActionListener(new ISubActionListener(i, this.model));
                        HelpCtx helpCtx = this.model.getHelpCtx(i);
                        this.associateHelp(jMenuItem, helpCtx == null ? Actions.findHelp(this.action) : helpCtx);
                        this.multi.add(jMenuItem);
                    }
                    this.associateHelp(this.multi, Actions.findHelp(this.action));
                }
                this.multi.setEnabled(true);
            }
            return this.currentOnes.toArray(new JMenuItem[this.currentOnes.size()]);
        }

        private void associateHelp(JComponent jComponent, HelpCtx helpCtx) {
            if (helpCtx != null && !helpCtx.equals((Object)HelpCtx.DEFAULT_HELP) && helpCtx.getHelpID() != null) {
                HelpCtx.setHelpIDString((JComponent)jComponent, (String)helpCtx.getHelpID());
            } else {
                HelpCtx.setHelpIDString((JComponent)jComponent, null);
            }
        }
    }

    private static class ISubActionListener
    implements ActionListener {
        int index;
        SubMenuModel support;

        public ISubActionListener(int n, SubMenuModel subMenuModel) {
            this.index = n;
            this.support = subMenuModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.support.performActionAt(this.index);
        }
    }

    private static final class CheckMenuBridge
    extends BooleanButtonBridge {
        private boolean popup;
        private boolean hasOwnIcon = false;

        public CheckMenuBridge(JCheckBoxMenuItem jCheckBoxMenuItem, BooleanStateAction booleanStateAction, boolean bl) {
            super((AbstractButton)jCheckBoxMenuItem, booleanStateAction);
            this.init(jCheckBoxMenuItem, bl);
        }

        public CheckMenuBridge(JCheckBoxMenuItem jCheckBoxMenuItem, Action action, boolean bl) {
            super((AbstractButton)jCheckBoxMenuItem, action);
            this.init(jCheckBoxMenuItem, bl);
        }

        private void init(JCheckBoxMenuItem jCheckBoxMenuItem, boolean bl) {
            this.popup = bl;
            if (bl) {
                Actions.prepareMargins(jCheckBoxMenuItem, this.action);
            }
            Object object = this.action.getValue("iconBase");
            Object object2 = null;
            object2 = this.action instanceof SystemAction ? this.action.getValue("icon") : this.action.getValue("SmallIcon");
            this.hasOwnIcon = object != null || object2 != null;
        }

        @Override
        public void updateState(String string) {
            Object object;
            super.updateState(string);
            if (string == null || !string.equals("AcceleratorKey")) {
                Actions.updateKey((JMenuItem)this.comp, this.action);
            }
            if ((string == null || string.equals("Name")) && (object = this.action.getValue("Name")) instanceof String) {
                Actions.setMenuText((JMenuItem)this.comp, (String)object, true);
            }
        }

        @Override
        protected void updateButtonIcon() {
            if (this.hasOwnIcon) {
                super.updateButtonIcon();
                return;
            }
            if (!this.popup) {
                this.button.setIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/actions/empty.gif", (boolean)true));
            }
        }

        @Override
        protected boolean useTextIcons() {
            return false;
        }
    }

    private static class MenuBridge
    extends ButtonBridge {
        private boolean popup;

        public MenuBridge(JMenuItem jMenuItem, Action action, boolean bl) {
            super(jMenuItem, action);
            this.popup = bl;
            if (bl) {
                Actions.prepareMargins(jMenuItem, action);
            } else {
                jMenuItem.putClientProperty("menubridgeresizehack", this);
            }
        }

        @Override
        protected void prepare() {
            if (this.popup) {
                this.addNotify();
            } else {
                super.prepare();
            }
        }

        @Override
        public void updateState(String string) {
            if (this.button == null) {
                this.button = (AbstractButton)this.comp;
            }
            if (string == null || string.equals("enabled")) {
                this.button.setEnabled(this.action.isEnabled());
            }
            if (string == null || !string.equals("AcceleratorKey")) {
                Actions.updateKey((JMenuItem)this.comp, this.action);
            }
            if (!this.popup && (string == null || string.equals("icon") || string.equals("SmallIcon") || string.equals("iconBase"))) {
                this.updateButtonIcon();
            }
            if (string == null || string.equals("Name")) {
                Object object = null;
                boolean bl = true;
                if (this.popup) {
                    object = this.action.getValue("popupText");
                }
                if (object == null) {
                    object = this.action.getValue("menuText");
                    boolean bl2 = bl = !this.popup;
                }
                if (object == null) {
                    object = this.action.getValue("Name");
                    boolean bl3 = bl = !this.popup;
                }
                if (object instanceof String) {
                    Actions.setMenuText((JMenuItem)this.comp, (String)object, bl);
                }
            }
        }

        @Override
        protected void updateButtonIcon() {
            Object object;
            Object object2 = null;
            Object object3 = this.action.getValue("noIconInMenu");
            Object object4 = this.action.getValue("iconBase");
            if (Boolean.TRUE.equals(object3)) {
                return;
            }
            if (this.action instanceof SystemAction) {
                object = (SystemAction)this.action;
                object2 = object.getIcon(this.useTextIcons());
                if (object2 != null) {
                    this.button.setIcon((Icon)object2);
                    this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)((Icon)object2)));
                }
            } else if (object4 == null && (object2 = this.action.getValue("SmallIcon")) instanceof Icon) {
                this.button.setIcon((Icon)object2);
                this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)((Icon)object2)));
            }
            if (object4 instanceof String) {
                ImageIcon imageIcon;
                ImageIcon imageIcon2;
                ImageIcon imageIcon3;
                object = (String)object4;
                ImageIcon imageIcon4 = null;
                if (object2 == null && (imageIcon4 = ImageUtilities.loadImageIcon((String)object, (boolean)true)) != null) {
                    this.button.setIcon(imageIcon4);
                    this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)imageIcon4));
                }
                if ((imageIcon3 = ImageUtilities.loadImageIcon((String)MenuBridge.insertBeforeSuffix((String)object, "_pressed"), (boolean)true)) != null) {
                    this.button.setPressedIcon(imageIcon3);
                }
                if ((imageIcon2 = ImageUtilities.loadImageIcon((String)MenuBridge.insertBeforeSuffix((String)object, "_rollover"), (boolean)true)) != null) {
                    this.button.setRolloverIcon(imageIcon2);
                }
                if ((imageIcon = ImageUtilities.loadImageIcon((String)MenuBridge.insertBeforeSuffix((String)object, "_disabled"), (boolean)true)) != null) {
                    this.button.setDisabledIcon(imageIcon);
                } else if (imageIcon4 != null) {
                    this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)imageIcon4));
                }
            }
        }

        @Override
        protected boolean useTextIcons() {
            return false;
        }
    }

    private static class BooleanButtonBridge
    extends ButtonBridge {
        private final BooleanStateAction stateAction;
        private final PropertyChangeListener bsaL;

        public BooleanButtonBridge(AbstractButton abstractButton, BooleanStateAction booleanStateAction) {
            super(abstractButton, (Action)booleanStateAction);
            this.stateAction = booleanStateAction;
            if (booleanStateAction != null && booleanStateAction != this.action) {
                this.bsaL = WeakListeners.propertyChange((PropertyChangeListener)this, (String)"booleanState", (Object)booleanStateAction);
                booleanStateAction.addPropertyChangeListener(this.bsaL);
            } else {
                this.bsaL = null;
            }
        }

        public BooleanButtonBridge(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
            this.stateAction = null;
            this.bsaL = null;
        }

        @Override
        public void updateState(String string) {
            super.updateState(string);
            if (string == null || string.equals("booleanState") || this.bsaL == null && string.equals("SwingSelectedKey")) {
                this.button.setSelected(this.getBooleanState());
            }
        }

        protected boolean getBooleanState() {
            if (this.action instanceof AlwaysEnabledAction.CheckBox) {
                return ((AlwaysEnabledAction.CheckBox)this.action).isPreferencesSelected();
            }
            return this.stateAction != null ? this.stateAction.getBooleanState() : Boolean.TRUE.equals(this.action.getValue("SwingSelectedKey"));
        }
    }

    private static class ButtonBridge
    extends Bridge
    implements ActionListener {
        private static Logger UILOG = Logger.getLogger("org.netbeans.ui.actions");
        protected AbstractButton button;

        public ButtonBridge(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
            abstractButton.addActionListener(action);
            this.button = abstractButton;
            abstractButton.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogRecord logRecord = new LogRecord(Level.FINER, "UI_ACTION_BUTTON_PRESS");
            logRecord.setParameters(new Object[]{this.button, this.button.getClass().getName(), this.action, this.action.getClass().getName(), this.action.getValue("Name")});
            logRecord.setResourceBundle(NbBundle.getBundle(Actions.class));
            logRecord.setResourceBundleName(Actions.class.getPackage().getName() + ".Bundle");
            logRecord.setLoggerName(UILOG.getName());
            UILOG.log(logRecord);
        }

        protected void updateButtonIcon() {
            Object object;
            ImageIcon imageIcon;
            String string;
            Object object2 = null;
            Object object3 = this.action.getValue("iconBase");
            boolean bl = true;
            Object object4 = this.button.getClientProperty("PreferredIconSize");
            if (object4 instanceof Integer && (Integer)object4 == 24) {
                bl = false;
            }
            if (this.action instanceof SystemAction) {
                if (object3 instanceof String) {
                    string = (String)object3;
                    imageIcon = ButtonBridge.loadImage(string, bl, null);
                    if (imageIcon != null) {
                        object2 = imageIcon;
                        this.button.setIcon(imageIcon);
                        this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)imageIcon));
                    } else {
                        object = (SystemAction)this.action;
                        object2 = object.getIcon(this.useTextIcons());
                        this.button.setIcon((Icon)object2);
                        this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)((Icon)object2)));
                    }
                } else {
                    string = (SystemAction)this.action;
                    object2 = string.getIcon(this.useTextIcons());
                    this.button.setIcon((Icon)object2);
                    this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)((Icon)object2)));
                }
            } else if (object3 instanceof String) {
                string = (String)object3;
                imageIcon = ButtonBridge.loadImage(string, bl, null);
                if (imageIcon != null) {
                    object2 = imageIcon;
                    this.button.setIcon((Icon)object2);
                    this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)imageIcon));
                } else {
                    object2 = this.action.getValue("SmallIcon");
                    if (object2 instanceof Icon) {
                        this.button.setIcon((Icon)object2);
                        this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)((Icon)object2)));
                    } else {
                        this.button.setIcon(Actions.nonNullIcon(null));
                    }
                }
            } else {
                object2 = this.action.getValue("SmallIcon");
                if (object2 instanceof Icon) {
                    this.button.setIcon((Icon)object2);
                    this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)((Icon)object2)));
                } else {
                    this.button.setIcon(Actions.nonNullIcon(null));
                }
            }
            if (object3 instanceof String) {
                ImageIcon imageIcon2;
                ImageIcon imageIcon3;
                string = (String)object3;
                imageIcon = null;
                if (object2 == null) {
                    imageIcon = ButtonBridge.loadImage(string, bl, null);
                    if (imageIcon != null) {
                        this.button.setIcon(imageIcon);
                    }
                    object2 = imageIcon;
                }
                if ((object = ButtonBridge.loadImage(string, bl, "_pressed")) != null) {
                    this.button.setPressedIcon((Icon)object);
                }
                if ((imageIcon3 = ButtonBridge.loadImage(string, bl, "_rollover")) != null) {
                    this.button.setRolloverIcon(imageIcon3);
                }
                if ((imageIcon2 = ButtonBridge.loadImage(string, bl, "_disabled")) != null) {
                    this.button.setDisabledIcon(imageIcon2);
                } else if (imageIcon != null) {
                    this.button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)imageIcon));
                }
                ImageIcon imageIcon4 = ButtonBridge.loadImage(string, bl, "_selected");
                if (imageIcon4 != null) {
                    this.button.setSelectedIcon(imageIcon4);
                }
                if ((imageIcon4 = ButtonBridge.loadImage(string, bl, "_rolloverSelected")) != null) {
                    this.button.setRolloverSelectedIcon(imageIcon4);
                }
                if ((imageIcon4 = ButtonBridge.loadImage(string, bl, "_disabledSelected")) != null) {
                    this.button.setDisabledSelectedIcon(imageIcon4);
                }
            }
        }

        static ImageIcon loadImage(String string, boolean bl, String string2) {
            String string3;
            ImageIcon imageIcon;
            if (!bl && (imageIcon = ImageUtilities.loadImageIcon((String)ButtonBridge.insertBeforeSuffix(string3 = ButtonBridge.insertBeforeSuffix(string, "24"), string2), (boolean)true)) != null) {
                return imageIcon;
            }
            return ImageUtilities.loadImageIcon((String)ButtonBridge.insertBeforeSuffix(string, string2), (boolean)true);
        }

        static String insertBeforeSuffix(String string, String string2) {
            if (string2 == null) {
                return string;
            }
            String string3 = string;
            String string4 = "";
            if (string.lastIndexOf(46) >= 0) {
                string3 = string.substring(0, string.lastIndexOf(46));
                string4 = string.substring(string.lastIndexOf(46), string.length());
            }
            return string3 + string2 + string4;
        }

        @Override
        public void updateState(String string) {
            if (string == null || string.equals("enabled")) {
                this.button.setEnabled(this.action.isEnabled());
            }
            if (string == null || string.equals("icon") || string.equals("SmallIcon") || string.equals("iconBase")) {
                this.updateButtonIcon();
            }
            if (string == null || string.equals("AcceleratorKey") || string.equals("Name") && this.action.getValue("ShortDescription") == null || string.equals("ShortDescription")) {
                String string2 = Actions.findKey(this.action);
                String string3 = (String)this.action.getValue("ShortDescription");
                if (string3 == null) {
                    string3 = (String)this.action.getValue("Name");
                    String string4 = string3 = string3 == null ? "" : Actions.cutAmpersand(string3);
                }
                if (string2 == null || string2.equals("")) {
                    this.button.setToolTipText(string3);
                } else {
                    this.button.setToolTipText(NbBundle.getMessage(Actions.class, (String)"FMT_ButtonHint", (Object)string3, (Object)string2));
                }
            }
            if (this.button instanceof Accessible && (string == null || string.equals("Name"))) {
                this.button.getAccessibleContext().setAccessibleName((String)this.action.getValue("Name"));
            }
        }

        protected boolean useTextIcons() {
            return true;
        }
    }

    private static abstract class Bridge
    implements PropertyChangeListener {
        protected JComponent comp;
        protected Action action;
        private final PropertyChangeListener actionL;

        public Bridge(JComponent jComponent, Action action) {
            if (jComponent == null || action == null) {
                throw new IllegalArgumentException("None of the arguments can be null: comp=" + jComponent + ", action=" + action);
            }
            this.comp = jComponent;
            this.action = action;
            this.actionL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)action);
            HelpCtx helpCtx = Actions.findHelp(action);
            if (helpCtx != null && !helpCtx.equals((Object)HelpCtx.DEFAULT_HELP) && helpCtx.getHelpID() != null) {
                HelpCtx.setHelpIDString((JComponent)jComponent, (String)helpCtx.getHelpID());
            }
        }

        protected void prepare() {
            this.comp.addPropertyChangeListener(new VisL());
            if (this.comp.isShowing()) {
                this.addNotify();
            } else {
                this.updateState(null);
            }
        }

        final void addNotify() {
            this.action.addPropertyChangeListener(this.actionL);
            this.updateState(null);
        }

        final void removeNotify() {
            this.action.removePropertyChangeListener(this.actionL);
        }

        public abstract void updateState(String var1);

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!EventQueue.isDispatchThread()) {
                new IllegalStateException("This must happen in the event thread!").printStackTrace();
            }
            this.updateState(propertyChangeEvent.getPropertyName());
        }

        private class VisL
        implements PropertyChangeListener {
            VisL() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("ancestor".equals(propertyChangeEvent.getPropertyName())) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        Bridge.this.addNotify();
                    } else {
                        Bridge.this.removeNotify();
                    }
                }
            }
        }
    }

    @Deprecated
    public static interface SubMenuModel {
        public int getCount();

        public String getLabel(int var1);

        public HelpCtx getHelpCtx(int var1);

        public void performActionAt(int var1);

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

