/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.netbeans.modules.search.ResultView;
import org.netbeans.swing.outline.DefaultOutlineCellRenderer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ResultsOutlineCellRenderer
extends DefaultOutlineCellRenderer {
    private static final Logger LOG = Logger.getLogger(ResultsOutlineCellRenderer.class.getName());
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private long todayStart = this.getMidnightTime();

    public ResultsOutlineCellRenderer() {
        this.setHorizontalAlignment(4);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = null;
        if (object instanceof Node.Property) {
            Node.Property property = (Node.Property)object;
            try {
                String string = this.getDisplayValue(property);
                if (property.getName().equals("path")) {
                    component = super.getTableCellRendererComponent(jTable, (Object)this.computeFitText(jTable, n, n2, string), bl, bl2, n, n2);
                    this.setToolTip(component, property);
                } else if (property.getName().equals("size")) {
                    component = super.getTableCellRendererComponent(jTable, (Object)this.formatFileSize((Long)property.getValue()), bl, bl2, n, n2);
                    this.setToolTip(component, property);
                } else if (property.getName().equals("lastModified")) {
                    component = super.getTableCellRendererComponent(jTable, (Object)this.formatDate((Date)property.getValue()), bl, bl2, n, n2);
                    this.setToolTip(component, property);
                } else {
                    component = super.getTableCellRendererComponent(jTable, (Object)string, bl, bl2, n, n2);
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, null, exception);
            }
        }
        if (component == null) {
            component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        if (component instanceof JLabel) {
            ((JLabel)component).setHorizontalAlignment(4);
            ((JLabel)component).setHorizontalTextPosition(4);
        }
        return component;
    }

    String getDisplayValue(Node.Property<?> property) throws IllegalAccessException, InvocationTargetException {
        Object object = property.getValue();
        return object != null ? object.toString() : "";
    }

    private String computeFitText(JTable jTable, int n, int n2, String string) {
        String string2;
        if (string == null) {
            string = "";
        }
        if (string.length() <= 3) {
            return string;
        }
        int n3 = jTable.getCellRect((int)n, (int)n2, (boolean)false).width;
        FontMetrics fontMetrics = jTable.getFontMetrics(jTable.getFont());
        int n4 = fontMetrics.stringWidth((string2 = "...") + "  ");
        int n5 = n3 - n4 - 15;
        if (n5 <= 0) {
            return string;
        }
        for (int i = 1; i <= string.length() - 1; ++i) {
            String string3 = string.substring(string.length() - i, string.length());
            int n6 = fontMetrics.stringWidth(string3);
            if (n6 < n5) continue;
            return string3.length() > 0 ? string2 + string3 + " " : string;
        }
        return string;
    }

    private String formatFileSize(Long l) {
        if (l < 1024L) {
            return NbBundle.getMessage(ResultView.class, (String)"TXT_FILE_SIZE_B", (Object)l);
        }
        if (l < 0x100000L) {
            return NbBundle.getMessage(ResultView.class, (String)"TXT_FILE_SIZE_KB", (Object)(l >> 10));
        }
        if (l < 0x40000000L) {
            return NbBundle.getMessage(ResultView.class, (String)"TXT_FILE_SIZE_MB", (Object)(l >> 20));
        }
        return NbBundle.getMessage(ResultView.class, (String)"TXT_FILE_SIZE_GB", (Object)(l >> 30));
    }

    private String formatDate(Date date) {
        long l = date.getTime();
        long l2 = System.currentTimeMillis();
        if (l2 - l < 3600000L) {
            return NbBundle.getMessage(ResultView.class, (String)"TXT_LAST_MODIFIED_RECENT", (Object)((l2 - l) / 60000L));
        }
        if (l > this.todayStart) {
            return NbBundle.getMessage(ResultView.class, (String)"TXT_LAST_MODIFIED_TODAY", (Object)date);
        }
        return NbBundle.getMessage(ResultView.class, (String)"TXT_LAST_MODIFIED_OLD", (Object)date);
    }

    private long getMidnightTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        return calendar.getTimeInMillis();
    }

    private void setToolTip(Component component, Node.Property<?> property) throws IllegalAccessException, InvocationTargetException {
        Object object;
        if (component instanceof JLabel && (object = property.getValue()) != null) {
            ((JLabel)component).setToolTipText(object.toString());
        }
    }
}

