// Copyright 2015-2021 The Khronos Group Inc.
//
// SPDX-License-Identifier: Apache-2.0 OR MIT
//

// This header is generated from the Khronos Vulkan XML API Registry.

#ifndef VULKAN_STRUCTS_HPP
#define VULKAN_STRUCTS_HPP

namespace VULKAN_HPP_NAMESPACE
{
  //===============
  //=== STRUCTS ===
  //===============

  struct AabbPositionsKHR
  {
    using NativeType = VkAabbPositionsKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AabbPositionsKHR( float minX_ = {},
                                           float minY_ = {},
                                           float minZ_ = {},
                                           float maxX_ = {},
                                           float maxY_ = {},
                                           float maxZ_ = {} ) VULKAN_HPP_NOEXCEPT
      : minX( minX_ )
      , minY( minY_ )
      , minZ( minZ_ )
      , maxX( maxX_ )
      , maxY( maxY_ )
      , maxZ( maxZ_ )
    {}

    VULKAN_HPP_CONSTEXPR AabbPositionsKHR( AabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AabbPositionsKHR( VkAabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AabbPositionsKHR( *reinterpret_cast<AabbPositionsKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AabbPositionsKHR & operator=( AabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AabbPositionsKHR & operator=( VkAabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AabbPositionsKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinX( float minX_ ) VULKAN_HPP_NOEXCEPT
    {
      minX = minX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinY( float minY_ ) VULKAN_HPP_NOEXCEPT
    {
      minY = minY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinZ( float minZ_ ) VULKAN_HPP_NOEXCEPT
    {
      minZ = minZ_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxX( float maxX_ ) VULKAN_HPP_NOEXCEPT
    {
      maxX = maxX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxY( float maxY_ ) VULKAN_HPP_NOEXCEPT
    {
      maxY = maxY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxZ( float maxZ_ ) VULKAN_HPP_NOEXCEPT
    {
      maxZ = maxZ_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAabbPositionsKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAabbPositionsKHR *>( this );
    }

    operator VkAabbPositionsKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAabbPositionsKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AabbPositionsKHR const & ) const = default;
#else
    bool operator==( AabbPositionsKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( minX == rhs.minX ) && ( minY == rhs.minY ) && ( minZ == rhs.minZ ) && ( maxX == rhs.maxX ) &&
             ( maxY == rhs.maxY ) && ( maxZ == rhs.maxZ );
    }

    bool operator!=( AabbPositionsKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float minX = {};
    float minY = {};
    float minZ = {};
    float maxX = {};
    float maxY = {};
    float maxZ = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AabbPositionsKHR ) == sizeof( VkAabbPositionsKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AabbPositionsKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AabbPositionsKHR>::value,
                            "AabbPositionsKHR is not nothrow_move_constructible!" );
  using AabbPositionsNV = AabbPositionsKHR;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AabbPositionsKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AabbPositionsKHR const & aabbPositionsKHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( float, seed, aabbPositionsKHR.minX );
    VULKAN_HPP_HASH_COMBINE( float, seed, aabbPositionsKHR.minY );
    VULKAN_HPP_HASH_COMBINE( float, seed, aabbPositionsKHR.minZ );
    VULKAN_HPP_HASH_COMBINE( float, seed, aabbPositionsKHR.maxX );
    VULKAN_HPP_HASH_COMBINE( float, seed, aabbPositionsKHR.maxY );
    VULKAN_HPP_HASH_COMBINE( float, seed, aabbPositionsKHR.maxZ );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  union DeviceOrHostAddressConstKHR
  {
    using NativeType = VkDeviceOrHostAddressConstKHR;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {} )
      : deviceAddress( deviceAddress_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR( const void * hostAddress_ ) : hostAddress( hostAddress_ ) {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR &
                            setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR &
                            setHostAddress( const void * hostAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      hostAddress = hostAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkDeviceOrHostAddressConstKHR const &() const
    {
      return *reinterpret_cast<const VkDeviceOrHostAddressConstKHR *>( this );
    }

    operator VkDeviceOrHostAddressConstKHR &()
    {
      return *reinterpret_cast<VkDeviceOrHostAddressConstKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress;
    const void *                        hostAddress;
#else
    VkDeviceAddress                                 deviceAddress;
    const void *                                    hostAddress;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureGeometryTrianglesDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryTrianglesDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureGeometryTrianglesDataKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR(
      VULKAN_HPP_NAMESPACE::Format                      vertexFormat_  = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData_    = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                  vertexStride_  = {},
      uint32_t                                          maxVertex_     = {},
      VULKAN_HPP_NAMESPACE::IndexType                   indexType_     = VULKAN_HPP_NAMESPACE::IndexType::eUint16,
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR indexData_     = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR transformData_ = {} ) VULKAN_HPP_NOEXCEPT
      : vertexFormat( vertexFormat_ )
      , vertexData( vertexData_ )
      , vertexStride( vertexStride_ )
      , maxVertex( maxVertex_ )
      , indexType( indexType_ )
      , indexData( indexData_ )
      , transformData( transformData_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR(
      AccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryTrianglesDataKHR( VkAccelerationStructureGeometryTrianglesDataKHR const & rhs )
      VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryTrianglesDataKHR(
          *reinterpret_cast<AccelerationStructureGeometryTrianglesDataKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureGeometryTrianglesDataKHR &
      operator=( AccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryTrianglesDataKHR &
      operator=( VkAccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
                            setVertexFormat( VULKAN_HPP_NAMESPACE::Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
      setVertexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
                            setVertexStride( VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
                            setMaxVertex( uint32_t maxVertex_ ) VULKAN_HPP_NOEXCEPT
    {
      maxVertex = maxVertex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
                            setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
      setIndexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
      setTransformData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & transformData_ ) VULKAN_HPP_NOEXCEPT
    {
      transformData = transformData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureGeometryTrianglesDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryTrianglesDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryTrianglesDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryTrianglesDataKHR *>( this );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eAccelerationStructureGeometryTrianglesDataKHR;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::Format        vertexFormat = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData    = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  vertexStride  = {};
    uint32_t                                          maxVertex     = {};
    VULKAN_HPP_NAMESPACE::IndexType                   indexType     = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR indexData     = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR transformData = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR ) ==
                              sizeof( VkAccelerationStructureGeometryTrianglesDataKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR>::value,
    "AccelerationStructureGeometryTrianglesDataKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryTrianglesDataKHR>
  {
    using Type = AccelerationStructureGeometryTrianglesDataKHR;
  };

  struct AccelerationStructureGeometryAabbsDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryAabbsDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureGeometryAabbsDataKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryAabbsDataKHR( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data_ = {},
                                                 VULKAN_HPP_NAMESPACE::DeviceSize stride_ = {} ) VULKAN_HPP_NOEXCEPT
      : data( data_ )
      , stride( stride_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR(
      AccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryAabbsDataKHR( VkAccelerationStructureGeometryAabbsDataKHR const & rhs )
      VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryAabbsDataKHR(
          *reinterpret_cast<AccelerationStructureGeometryAabbsDataKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureGeometryAabbsDataKHR &
      operator=( AccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryAabbsDataKHR &
      operator=( VkAccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR &
      setData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR &
                            setStride( VULKAN_HPP_NAMESPACE::DeviceSize stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureGeometryAabbsDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryAabbsDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryAabbsDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryAabbsDataKHR *>( this );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType = StructureType::eAccelerationStructureGeometryAabbsDataKHR;
    const void *                                      pNext = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data  = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  stride = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR ) ==
                              sizeof( VkAccelerationStructureGeometryAabbsDataKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR>::value,
    "AccelerationStructureGeometryAabbsDataKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryAabbsDataKHR>
  {
    using Type = AccelerationStructureGeometryAabbsDataKHR;
  };

  struct AccelerationStructureGeometryInstancesDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryInstancesDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureGeometryInstancesDataKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR(
      VULKAN_HPP_NAMESPACE::Bool32                      arrayOfPointers_ = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data_            = {} ) VULKAN_HPP_NOEXCEPT
      : arrayOfPointers( arrayOfPointers_ )
      , data( data_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR(
      AccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryInstancesDataKHR( VkAccelerationStructureGeometryInstancesDataKHR const & rhs )
      VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryInstancesDataKHR(
          *reinterpret_cast<AccelerationStructureGeometryInstancesDataKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureGeometryInstancesDataKHR &
      operator=( AccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryInstancesDataKHR &
      operator=( VkAccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR &
                            setArrayOfPointers( VULKAN_HPP_NAMESPACE::Bool32 arrayOfPointers_ ) VULKAN_HPP_NOEXCEPT
    {
      arrayOfPointers = arrayOfPointers_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR &
      setData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureGeometryInstancesDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryInstancesDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryInstancesDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryInstancesDataKHR *>( this );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eAccelerationStructureGeometryInstancesDataKHR;
    const void *                        pNext           = {};
    VULKAN_HPP_NAMESPACE::Bool32        arrayOfPointers = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR ) ==
                              sizeof( VkAccelerationStructureGeometryInstancesDataKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR>::value,
    "AccelerationStructureGeometryInstancesDataKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryInstancesDataKHR>
  {
    using Type = AccelerationStructureGeometryInstancesDataKHR;
  };

  union AccelerationStructureGeometryDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryDataKHR;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR triangles_ = {} )
      : triangles( triangles_ )
    {}

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryDataKHR( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR aabbs_ )
      : aabbs( aabbs_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR instances_ )
      : instances( instances_ )
    {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR & setTriangles(
      VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR const & triangles_ ) VULKAN_HPP_NOEXCEPT
    {
      triangles = triangles_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR &
      setAabbs( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR const & aabbs_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbs = aabbs_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR & setInstances(
      VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR const & instances_ ) VULKAN_HPP_NOEXCEPT
    {
      instances = instances_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkAccelerationStructureGeometryDataKHR const &() const
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryDataKHR &()
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryDataKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR triangles;
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR     aabbs;
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR instances;
#else
    VkAccelerationStructureGeometryTrianglesDataKHR triangles;
    VkAccelerationStructureGeometryAabbsDataKHR     aabbs;
    VkAccelerationStructureGeometryInstancesDataKHR instances;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureGeometryKHR
  {
    using NativeType = VkAccelerationStructureGeometryKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType = StructureType::eAccelerationStructureGeometryKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR(
      VULKAN_HPP_NAMESPACE::GeometryTypeKHR geometryType_ = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles,
      VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR geometry_ = {},
      VULKAN_HPP_NAMESPACE::GeometryFlagsKHR                     flags_    = {} ) VULKAN_HPP_NOEXCEPT
      : geometryType( geometryType_ )
      , geometry( geometry_ )
      , flags( flags_ )
    {}

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryKHR( AccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryKHR( VkAccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryKHR( *reinterpret_cast<AccelerationStructureGeometryKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureGeometryKHR &
      operator=( AccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryKHR & operator=( VkAccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR &
                            setGeometryType( VULKAN_HPP_NAMESPACE::GeometryTypeKHR geometryType_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryType = geometryType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR &
      setGeometry( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR const & geometry_ ) VULKAN_HPP_NOEXCEPT
    {
      geometry = geometry_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR &
                            setFlags( VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureGeometryKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryKHR *>( this );
    }

    operator VkAccelerationStructureGeometryKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryKHR *>( this );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType   sType        = StructureType::eAccelerationStructureGeometryKHR;
    const void *                          pNext        = {};
    VULKAN_HPP_NAMESPACE::GeometryTypeKHR geometryType = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles;
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR geometry = {};
    VULKAN_HPP_NAMESPACE::GeometryFlagsKHR                     flags    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR ) ==
                              sizeof( VkAccelerationStructureGeometryKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR>::value,
    "AccelerationStructureGeometryKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryKHR>
  {
    using Type = AccelerationStructureGeometryKHR;
  };

  union DeviceOrHostAddressKHR
  {
    using NativeType = VkDeviceOrHostAddressKHR;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {} )
      : deviceAddress( deviceAddress_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR( void * hostAddress_ ) : hostAddress( hostAddress_ ) {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR &
                            setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR & setHostAddress( void * hostAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      hostAddress = hostAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkDeviceOrHostAddressKHR const &() const
    {
      return *reinterpret_cast<const VkDeviceOrHostAddressKHR *>( this );
    }

    operator VkDeviceOrHostAddressKHR &()
    {
      return *reinterpret_cast<VkDeviceOrHostAddressKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress;
    void *                              hostAddress;
#else
    VkDeviceAddress                                 deviceAddress;
    void *                                          hostAddress;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureBuildGeometryInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildGeometryInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureBuildGeometryInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR type_ =
        VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel,
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR flags_ = {},
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR  mode_ =
        VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR::eBuild,
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         srcAccelerationStructure_ = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         dstAccelerationStructure_ = {},
      uint32_t                                                               geometryCount_            = {},
      const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR *         pGeometries_              = {},
      const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * ppGeometries_             = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR                           scratchData_ = {} ) VULKAN_HPP_NOEXCEPT
      : type( type_ )
      , flags( flags_ )
      , mode( mode_ )
      , srcAccelerationStructure( srcAccelerationStructure_ )
      , dstAccelerationStructure( dstAccelerationStructure_ )
      , geometryCount( geometryCount_ )
      , pGeometries( pGeometries_ )
      , ppGeometries( ppGeometries_ )
      , scratchData( scratchData_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR(
      AccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildGeometryInfoKHR( VkAccelerationStructureBuildGeometryInfoKHR const & rhs )
      VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildGeometryInfoKHR(
          *reinterpret_cast<AccelerationStructureBuildGeometryInfoKHR const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR       type_,
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR flags_,
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR  mode_,
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR           srcAccelerationStructure_,
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR           dstAccelerationStructure_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<
        const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR> const & geometries_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<
        const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const> const & pGeometries_ = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR                                    scratchData_ = {} )
      : type( type_ )
      , flags( flags_ )
      , mode( mode_ )
      , srcAccelerationStructure( srcAccelerationStructure_ )
      , dstAccelerationStructure( dstAccelerationStructure_ )
      , geometryCount( static_cast<uint32_t>( !geometries_.empty() ? geometries_.size() : pGeometries_.size() ) )
      , pGeometries( geometries_.data() )
      , ppGeometries( pGeometries_.data() )
      , scratchData( scratchData_ )
    {
#    ifdef VULKAN_HPP_NO_EXCEPTIONS
      VULKAN_HPP_ASSERT( ( !geometries_.empty() + !pGeometries_.empty() ) <= 1 );
#    else
      if ( 1 < ( !geometries_.empty() + !pGeometries_.empty() ) )
      {
        throw LogicError(
          VULKAN_HPP_NAMESPACE_STRING
          "::AccelerationStructureBuildGeometryInfoKHR::AccelerationStructureBuildGeometryInfoKHR: 1 < ( !geometries_.empty() + !pGeometries_.empty() )" );
      }
#    endif /*VULKAN_HPP_NO_EXCEPTIONS*/
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureBuildGeometryInfoKHR &
      operator=( AccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildGeometryInfoKHR &
      operator=( VkAccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildGeometryInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setType( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setFlags( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setMode( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setSrcAccelerationStructure(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR srcAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccelerationStructure = srcAccelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setDstAccelerationStructure(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR dstAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccelerationStructure = dstAccelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setGeometryCount( uint32_t geometryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = geometryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setPGeometries( const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * pGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      pGeometries = pGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR & setGeometries(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<
        const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR> const & geometries_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( geometries_.size() );
      pGeometries   = geometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setPpGeometries(
      const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * ppGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      ppGeometries = ppGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR & setPGeometries(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<
        const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const> const & pGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( pGeometries_.size() );
      ppGeometries  = pGeometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setScratchData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const & scratchData_ ) VULKAN_HPP_NOEXCEPT
    {
      scratchData = scratchData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureBuildGeometryInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildGeometryInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildGeometryInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildGeometryInfoKHR *>( this );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eAccelerationStructureBuildGeometryInfoKHR;
    const void *                        pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR type =
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel;
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR flags = {};
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR  mode =
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR::eBuild;
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         srcAccelerationStructure = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         dstAccelerationStructure = {};
    uint32_t                                                               geometryCount            = {};
    const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR *         pGeometries              = {};
    const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * ppGeometries             = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR                           scratchData              = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureBuildGeometryInfoKHR ) ==
                              sizeof( VkAccelerationStructureBuildGeometryInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildGeometryInfoKHR>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildGeometryInfoKHR>::value,
    "AccelerationStructureBuildGeometryInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureBuildGeometryInfoKHR>
  {
    using Type = AccelerationStructureBuildGeometryInfoKHR;
  };

  struct AccelerationStructureBuildRangeInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildRangeInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildRangeInfoKHR( uint32_t primitiveCount_  = {},
                                                                 uint32_t primitiveOffset_ = {},
                                                                 uint32_t firstVertex_     = {},
                                                                 uint32_t transformOffset_ = {} ) VULKAN_HPP_NOEXCEPT
      : primitiveCount( primitiveCount_ )
      , primitiveOffset( primitiveOffset_ )
      , firstVertex( firstVertex_ )
      , transformOffset( transformOffset_ )
    {}

    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildRangeInfoKHR( AccelerationStructureBuildRangeInfoKHR const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildRangeInfoKHR( VkAccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildRangeInfoKHR(
          *reinterpret_cast<AccelerationStructureBuildRangeInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureBuildRangeInfoKHR &
      operator=( AccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildRangeInfoKHR &
      operator=( VkAccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR &
                            setPrimitiveCount( uint32_t primitiveCount_ ) VULKAN_HPP_NOEXCEPT
    {
      primitiveCount = primitiveCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR &
                            setPrimitiveOffset( uint32_t primitiveOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      primitiveOffset = primitiveOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR &
                            setFirstVertex( uint32_t firstVertex_ ) VULKAN_HPP_NOEXCEPT
    {
      firstVertex = firstVertex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR &
                            setTransformOffset( uint32_t transformOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      transformOffset = transformOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureBuildRangeInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildRangeInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildRangeInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildRangeInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureBuildRangeInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureBuildRangeInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( primitiveCount == rhs.primitiveCount ) && ( primitiveOffset == rhs.primitiveOffset ) &&
             ( firstVertex == rhs.firstVertex ) && ( transformOffset == rhs.transformOffset );
    }

    bool operator!=( AccelerationStructureBuildRangeInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t primitiveCount  = {};
    uint32_t primitiveOffset = {};
    uint32_t firstVertex     = {};
    uint32_t transformOffset = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR ) ==
                              sizeof( VkAccelerationStructureBuildRangeInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR>::value,
    "AccelerationStructureBuildRangeInfoKHR is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR const &
                            accelerationStructureBuildRangeInfoKHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureBuildRangeInfoKHR.primitiveCount );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureBuildRangeInfoKHR.primitiveOffset );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureBuildRangeInfoKHR.firstVertex );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureBuildRangeInfoKHR.transformOffset );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureBuildSizesInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildSizesInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureBuildSizesInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildSizesInfoKHR(
      VULKAN_HPP_NAMESPACE::DeviceSize accelerationStructureSize_ = {},
      VULKAN_HPP_NAMESPACE::DeviceSize updateScratchSize_         = {},
      VULKAN_HPP_NAMESPACE::DeviceSize buildScratchSize_          = {} ) VULKAN_HPP_NOEXCEPT
      : accelerationStructureSize( accelerationStructureSize_ )
      , updateScratchSize( updateScratchSize_ )
      , buildScratchSize( buildScratchSize_ )
    {}

    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildSizesInfoKHR( AccelerationStructureBuildSizesInfoKHR const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildSizesInfoKHR( VkAccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildSizesInfoKHR(
          *reinterpret_cast<AccelerationStructureBuildSizesInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureBuildSizesInfoKHR &
      operator=( AccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildSizesInfoKHR &
      operator=( VkAccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildSizesInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildSizesInfoKHR &
      setAccelerationStructureSize( VULKAN_HPP_NAMESPACE::DeviceSize accelerationStructureSize_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureSize = accelerationStructureSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildSizesInfoKHR &
      setUpdateScratchSize( VULKAN_HPP_NAMESPACE::DeviceSize updateScratchSize_ ) VULKAN_HPP_NOEXCEPT
    {
      updateScratchSize = updateScratchSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildSizesInfoKHR &
      setBuildScratchSize( VULKAN_HPP_NAMESPACE::DeviceSize buildScratchSize_ ) VULKAN_HPP_NOEXCEPT
    {
      buildScratchSize = buildScratchSize_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureBuildSizesInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildSizesInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildSizesInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildSizesInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureBuildSizesInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureBuildSizesInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( accelerationStructureSize == rhs.accelerationStructureSize ) &&
             ( updateScratchSize == rhs.updateScratchSize ) && ( buildScratchSize == rhs.buildScratchSize );
    }

    bool operator!=( AccelerationStructureBuildSizesInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eAccelerationStructureBuildSizesInfoKHR;
    const void *                        pNext = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    accelerationStructureSize = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    updateScratchSize         = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    buildScratchSize          = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR ) ==
                              sizeof( VkAccelerationStructureBuildSizesInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR>::value,
    "AccelerationStructureBuildSizesInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureBuildSizesInfoKHR>
  {
    using Type = AccelerationStructureBuildSizesInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR const &
                            accelerationStructureBuildSizesInfoKHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, accelerationStructureBuildSizesInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, accelerationStructureBuildSizesInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DeviceSize, seed, accelerationStructureBuildSizesInfoKHR.accelerationStructureSize );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DeviceSize, seed, accelerationStructureBuildSizesInfoKHR.updateScratchSize );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DeviceSize, seed, accelerationStructureBuildSizesInfoKHR.buildScratchSize );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureCreateInfoKHR
  {
    using NativeType = VkAccelerationStructureCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureCreateInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AccelerationStructureCreateInfoKHR( VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR createFlags_ = {},
                                          VULKAN_HPP_NAMESPACE::Buffer                              buffer_      = {},
                                          VULKAN_HPP_NAMESPACE::DeviceSize                          offset_      = {},
                                          VULKAN_HPP_NAMESPACE::DeviceSize                          size_        = {},
                                          VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR        type_ =
                                            VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel,
                                          VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {} ) VULKAN_HPP_NOEXCEPT
      : createFlags( createFlags_ )
      , buffer( buffer_ )
      , offset( offset_ )
      , size( size_ )
      , type( type_ )
      , deviceAddress( deviceAddress_ )
    {}

    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoKHR( AccelerationStructureCreateInfoKHR const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoKHR( VkAccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureCreateInfoKHR( *reinterpret_cast<AccelerationStructureCreateInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureCreateInfoKHR &
      operator=( AccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoKHR &
      operator=( VkAccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR &
      setCreateFlags( VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR createFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      createFlags = createFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR &
                            setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR &
                            setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR &
                            setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR &
                            setType( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR &
                            setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureCreateInfoKHR *>( this );
    }

    operator VkAccelerationStructureCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureCreateInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureCreateInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( createFlags == rhs.createFlags ) &&
             ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( size == rhs.size ) && ( type == rhs.type ) &&
             ( deviceAddress == rhs.deviceAddress );
    }

    bool operator!=( AccelerationStructureCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eAccelerationStructureCreateInfoKHR;
    const void *                        pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR createFlags = {};
    VULKAN_HPP_NAMESPACE::Buffer                              buffer      = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                          offset      = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                          size        = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR        type =
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel;
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR ) ==
                              sizeof( VkAccelerationStructureCreateInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR>::value,
    "AccelerationStructureCreateInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureCreateInfoKHR>
  {
    using Type = AccelerationStructureCreateInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR const &
                            accelerationStructureCreateInfoKHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, accelerationStructureCreateInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, accelerationStructureCreateInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR, seed, accelerationStructureCreateInfoKHR.createFlags );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, accelerationStructureCreateInfoKHR.buffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, accelerationStructureCreateInfoKHR.offset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, accelerationStructureCreateInfoKHR.size );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR, seed, accelerationStructureCreateInfoKHR.type );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DeviceAddress, seed, accelerationStructureCreateInfoKHR.deviceAddress );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct GeometryTrianglesNV
  {
    using NativeType = VkGeometryTrianglesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryTrianglesNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      GeometryTrianglesNV( VULKAN_HPP_NAMESPACE::Buffer     vertexData_      = {},
                           VULKAN_HPP_NAMESPACE::DeviceSize vertexOffset_    = {},
                           uint32_t                         vertexCount_     = {},
                           VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_    = {},
                           VULKAN_HPP_NAMESPACE::Format     vertexFormat_    = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                           VULKAN_HPP_NAMESPACE::Buffer     indexData_       = {},
                           VULKAN_HPP_NAMESPACE::DeviceSize indexOffset_     = {},
                           uint32_t                         indexCount_      = {},
                           VULKAN_HPP_NAMESPACE::IndexType  indexType_       = VULKAN_HPP_NAMESPACE::IndexType::eUint16,
                           VULKAN_HPP_NAMESPACE::Buffer     transformData_   = {},
                           VULKAN_HPP_NAMESPACE::DeviceSize transformOffset_ = {} ) VULKAN_HPP_NOEXCEPT
      : vertexData( vertexData_ )
      , vertexOffset( vertexOffset_ )
      , vertexCount( vertexCount_ )
      , vertexStride( vertexStride_ )
      , vertexFormat( vertexFormat_ )
      , indexData( indexData_ )
      , indexOffset( indexOffset_ )
      , indexCount( indexCount_ )
      , indexType( indexType_ )
      , transformData( transformData_ )
      , transformOffset( transformOffset_ )
    {}

    VULKAN_HPP_CONSTEXPR GeometryTrianglesNV( GeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryTrianglesNV( VkGeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : GeometryTrianglesNV( *reinterpret_cast<GeometryTrianglesNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    GeometryTrianglesNV & operator=( GeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryTrianglesNV & operator=( VkGeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryTrianglesNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV &
                            setVertexData( VULKAN_HPP_NAMESPACE::Buffer vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV &
                            setVertexOffset( VULKAN_HPP_NAMESPACE::DeviceSize vertexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexOffset = vertexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexCount( uint32_t vertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexCount = vertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV &
                            setVertexStride( VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV &
                            setVertexFormat( VULKAN_HPP_NAMESPACE::Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV &
                            setIndexData( VULKAN_HPP_NAMESPACE::Buffer indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV &
                            setIndexOffset( VULKAN_HPP_NAMESPACE::DeviceSize indexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      indexOffset = indexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexCount( uint32_t indexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      indexCount = indexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV &
                            setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV &
                            setTransformData( VULKAN_HPP_NAMESPACE::Buffer transformData_ ) VULKAN_HPP_NOEXCEPT
    {
      transformData = transformData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV &
                            setTransformOffset( VULKAN_HPP_NAMESPACE::DeviceSize transformOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      transformOffset = transformOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkGeometryTrianglesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryTrianglesNV *>( this );
    }

    operator VkGeometryTrianglesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryTrianglesNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryTrianglesNV const & ) const = default;
#else
    bool operator==( GeometryTrianglesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( vertexData == rhs.vertexData ) &&
             ( vertexOffset == rhs.vertexOffset ) && ( vertexCount == rhs.vertexCount ) &&
             ( vertexStride == rhs.vertexStride ) && ( vertexFormat == rhs.vertexFormat ) &&
             ( indexData == rhs.indexData ) && ( indexOffset == rhs.indexOffset ) && ( indexCount == rhs.indexCount ) &&
             ( indexType == rhs.indexType ) && ( transformData == rhs.transformData ) &&
             ( transformOffset == rhs.transformOffset );
    }

    bool operator!=( GeometryTrianglesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eGeometryTrianglesNV;
    const void *                        pNext           = {};
    VULKAN_HPP_NAMESPACE::Buffer        vertexData      = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    vertexOffset    = {};
    uint32_t                            vertexCount     = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    vertexStride    = {};
    VULKAN_HPP_NAMESPACE::Format        vertexFormat    = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::Buffer        indexData       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    indexOffset     = {};
    uint32_t                            indexCount      = {};
    VULKAN_HPP_NAMESPACE::IndexType     indexType       = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
    VULKAN_HPP_NAMESPACE::Buffer        transformData   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    transformOffset = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::GeometryTrianglesNV ) == sizeof( VkGeometryTrianglesNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::GeometryTrianglesNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::GeometryTrianglesNV>::value,
                            "GeometryTrianglesNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eGeometryTrianglesNV>
  {
    using Type = GeometryTrianglesNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::GeometryTrianglesNV>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::GeometryTrianglesNV const & geometryTrianglesNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, geometryTrianglesNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, geometryTrianglesNV.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, geometryTrianglesNV.vertexData );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, geometryTrianglesNV.vertexOffset );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, geometryTrianglesNV.vertexCount );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, geometryTrianglesNV.vertexStride );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Format, seed, geometryTrianglesNV.vertexFormat );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, geometryTrianglesNV.indexData );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, geometryTrianglesNV.indexOffset );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, geometryTrianglesNV.indexCount );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::IndexType, seed, geometryTrianglesNV.indexType );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, geometryTrianglesNV.transformData );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, geometryTrianglesNV.transformOffset );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct GeometryAABBNV
  {
    using NativeType = VkGeometryAABBNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryAabbNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryAABBNV( VULKAN_HPP_NAMESPACE::Buffer     aabbData_ = {},
                                         uint32_t                         numAABBs_ = {},
                                         uint32_t                         stride_   = {},
                                         VULKAN_HPP_NAMESPACE::DeviceSize offset_   = {} ) VULKAN_HPP_NOEXCEPT
      : aabbData( aabbData_ )
      , numAABBs( numAABBs_ )
      , stride( stride_ )
      , offset( offset_ )
    {}

    VULKAN_HPP_CONSTEXPR GeometryAABBNV( GeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryAABBNV( VkGeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : GeometryAABBNV( *reinterpret_cast<GeometryAABBNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    GeometryAABBNV & operator=( GeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryAABBNV & operator=( VkGeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryAABBNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setAabbData( VULKAN_HPP_NAMESPACE::Buffer aabbData_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbData = aabbData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setNumAABBs( uint32_t numAABBs_ ) VULKAN_HPP_NOEXCEPT
    {
      numAABBs = numAABBs_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkGeometryAABBNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryAABBNV *>( this );
    }

    operator VkGeometryAABBNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryAABBNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryAABBNV const & ) const = default;
#else
    bool operator==( GeometryAABBNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( aabbData == rhs.aabbData ) &&
             ( numAABBs == rhs.numAABBs ) && ( stride == rhs.stride ) && ( offset == rhs.offset );
    }

    bool operator!=( GeometryAABBNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType    = StructureType::eGeometryAabbNV;
    const void *                        pNext    = {};
    VULKAN_HPP_NAMESPACE::Buffer        aabbData = {};
    uint32_t                            numAABBs = {};
    uint32_t                            stride   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    offset   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::GeometryAABBNV ) == sizeof( VkGeometryAABBNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::GeometryAABBNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::GeometryAABBNV>::value,
                            "GeometryAABBNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eGeometryAabbNV>
  {
    using Type = GeometryAABBNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::GeometryAABBNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::GeometryAABBNV const & geometryAABBNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, geometryAABBNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, geometryAABBNV.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, geometryAABBNV.aabbData );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, geometryAABBNV.numAABBs );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, geometryAABBNV.stride );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, geometryAABBNV.offset );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct GeometryDataNV
  {
    using NativeType = VkGeometryDataNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryDataNV( VULKAN_HPP_NAMESPACE::GeometryTrianglesNV triangles_ = {},
                                         VULKAN_HPP_NAMESPACE::GeometryAABBNV      aabbs_     = {} ) VULKAN_HPP_NOEXCEPT
      : triangles( triangles_ )
      , aabbs( aabbs_ )
    {}

    VULKAN_HPP_CONSTEXPR GeometryDataNV( GeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryDataNV( VkGeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : GeometryDataNV( *reinterpret_cast<GeometryDataNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    GeometryDataNV & operator=( GeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryDataNV & operator=( VkGeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryDataNV &
      setTriangles( VULKAN_HPP_NAMESPACE::GeometryTrianglesNV const & triangles_ ) VULKAN_HPP_NOEXCEPT
    {
      triangles = triangles_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryDataNV &
                            setAabbs( VULKAN_HPP_NAMESPACE::GeometryAABBNV const & aabbs_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbs = aabbs_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkGeometryDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryDataNV *>( this );
    }

    operator VkGeometryDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryDataNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryDataNV const & ) const = default;
#else
    bool operator==( GeometryDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( triangles == rhs.triangles ) && ( aabbs == rhs.aabbs );
    }

    bool operator!=( GeometryDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::GeometryTrianglesNV triangles = {};
    VULKAN_HPP_NAMESPACE::GeometryAABBNV      aabbs     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::GeometryDataNV ) == sizeof( VkGeometryDataNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::GeometryDataNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::GeometryDataNV>::value,
                            "GeometryDataNV is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::GeometryDataNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::GeometryDataNV const & geometryDataNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::GeometryTrianglesNV, seed, geometryDataNV.triangles );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::GeometryAABBNV, seed, geometryDataNV.aabbs );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct GeometryNV
  {
    using NativeType = VkGeometryNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryNV(
      VULKAN_HPP_NAMESPACE::GeometryTypeKHR  geometryType_ = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles,
      VULKAN_HPP_NAMESPACE::GeometryDataNV   geometry_     = {},
      VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags_        = {} ) VULKAN_HPP_NOEXCEPT
      : geometryType( geometryType_ )
      , geometry( geometry_ )
      , flags( flags_ )
    {}

    VULKAN_HPP_CONSTEXPR GeometryNV( GeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryNV( VkGeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : GeometryNV( *reinterpret_cast<GeometryNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    GeometryNV & operator=( GeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryNV & operator=( VkGeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV &
                            setGeometryType( VULKAN_HPP_NAMESPACE::GeometryTypeKHR geometryType_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryType = geometryType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV &
                            setGeometry( VULKAN_HPP_NAMESPACE::GeometryDataNV const & geometry_ ) VULKAN_HPP_NOEXCEPT
    {
      geometry = geometry_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setFlags( VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkGeometryNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryNV *>( this );
    }

    operator VkGeometryNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryNV const & ) const = default;
#else
    bool operator==( GeometryNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( geometryType == rhs.geometryType ) &&
             ( geometry == rhs.geometry ) && ( flags == rhs.flags );
    }

    bool operator!=( GeometryNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType        = StructureType::eGeometryNV;
    const void *                           pNext        = {};
    VULKAN_HPP_NAMESPACE::GeometryTypeKHR  geometryType = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles;
    VULKAN_HPP_NAMESPACE::GeometryDataNV   geometry     = {};
    VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::GeometryNV ) == sizeof( VkGeometryNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::GeometryNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::GeometryNV>::value,
                            "GeometryNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eGeometryNV>
  {
    using Type = GeometryNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::GeometryNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::GeometryNV const & geometryNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, geometryNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, geometryNV.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::GeometryTypeKHR, seed, geometryNV.geometryType );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::GeometryDataNV, seed, geometryNV.geometry );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::GeometryFlagsKHR, seed, geometryNV.flags );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureInfoNV
  {
    using NativeType = VkAccelerationStructureInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AccelerationStructureInfoNV( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV       type_          = {},
                                   VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV flags_         = {},
                                   uint32_t                                                instanceCount_ = {},
                                   uint32_t                                                geometryCount_ = {},
                                   const VULKAN_HPP_NAMESPACE::GeometryNV * pGeometries_ = {} ) VULKAN_HPP_NOEXCEPT
      : type( type_ )
      , flags( flags_ )
      , instanceCount( instanceCount_ )
      , geometryCount( geometryCount_ )
      , pGeometries( pGeometries_ )
    {}

    VULKAN_HPP_CONSTEXPR
      AccelerationStructureInfoNV( AccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInfoNV( VkAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureInfoNV( *reinterpret_cast<AccelerationStructureInfoNV const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureInfoNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV                                             type_,
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV                                       flags_,
      uint32_t                                                                                      instanceCount_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::GeometryNV> const & geometries_ )
      : type( type_ )
      , flags( flags_ )
      , instanceCount( instanceCount_ )
      , geometryCount( static_cast<uint32_t>( geometries_.size() ) )
      , pGeometries( geometries_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureInfoNV & operator=( AccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInfoNV & operator=( VkAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV &
                            setType( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV &
      setFlags( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV &
                            setInstanceCount( uint32_t instanceCount_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCount = instanceCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV &
                            setGeometryCount( uint32_t geometryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = geometryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV &
                            setPGeometries( const VULKAN_HPP_NAMESPACE::GeometryNV * pGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      pGeometries = pGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureInfoNV & setGeometries(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::GeometryNV> const & geometries_ )
      VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( geometries_.size() );
      pGeometries   = geometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureInfoNV *>( this );
    }

    operator VkAccelerationStructureInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureInfoNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( type == rhs.type ) && ( flags == rhs.flags ) &&
             ( instanceCount == rhs.instanceCount ) && ( geometryCount == rhs.geometryCount ) &&
             ( pGeometries == rhs.pGeometries );
    }

    bool operator!=( AccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                     sType         = StructureType::eAccelerationStructureInfoNV;
    const void *                                            pNext         = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV       type          = {};
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV flags         = {};
    uint32_t                                                instanceCount = {};
    uint32_t                                                geometryCount = {};
    const VULKAN_HPP_NAMESPACE::GeometryNV *                pGeometries   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV ) ==
                              sizeof( VkAccelerationStructureInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV>::value,
    "AccelerationStructureInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureInfoNV>
  {
    using Type = AccelerationStructureInfoNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV const & accelerationStructureInfoNV ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, accelerationStructureInfoNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, accelerationStructureInfoNV.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV, seed, accelerationStructureInfoNV.type );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV, seed, accelerationStructureInfoNV.flags );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureInfoNV.instanceCount );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureInfoNV.geometryCount );
    VULKAN_HPP_HASH_COMBINE( const VULKAN_HPP_NAMESPACE::GeometryNV *, seed, accelerationStructureInfoNV.pGeometries );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureCreateInfoNV
  {
    using NativeType = VkAccelerationStructureCreateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureCreateInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoNV(
      VULKAN_HPP_NAMESPACE::DeviceSize                  compactedSize_ = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV info_          = {} ) VULKAN_HPP_NOEXCEPT
      : compactedSize( compactedSize_ )
      , info( info_ )
    {}

    VULKAN_HPP_CONSTEXPR
      AccelerationStructureCreateInfoNV( AccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoNV( VkAccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureCreateInfoNV( *reinterpret_cast<AccelerationStructureCreateInfoNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureCreateInfoNV &
      operator=( AccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoNV & operator=( VkAccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV &
                            setCompactedSize( VULKAN_HPP_NAMESPACE::DeviceSize compactedSize_ ) VULKAN_HPP_NOEXCEPT
    {
      compactedSize = compactedSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV &
      setInfo( VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV const & info_ ) VULKAN_HPP_NOEXCEPT
    {
      info = info_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureCreateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureCreateInfoNV *>( this );
    }

    operator VkAccelerationStructureCreateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureCreateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureCreateInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( compactedSize == rhs.compactedSize ) &&
             ( info == rhs.info );
    }

    bool operator!=( AccelerationStructureCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType         = StructureType::eAccelerationStructureCreateInfoNV;
    const void *                                      pNext         = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  compactedSize = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV info          = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV ) ==
                              sizeof( VkAccelerationStructureCreateInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV>::value,
    "AccelerationStructureCreateInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureCreateInfoNV>
  {
    using Type = AccelerationStructureCreateInfoNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV const &
                            accelerationStructureCreateInfoNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, accelerationStructureCreateInfoNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, accelerationStructureCreateInfoNV.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, accelerationStructureCreateInfoNV.compactedSize );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV, seed, accelerationStructureCreateInfoNV.info );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureDeviceAddressInfoKHR
  {
    using NativeType = VkAccelerationStructureDeviceAddressInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureDeviceAddressInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureDeviceAddressInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure_ = {} ) VULKAN_HPP_NOEXCEPT
      : accelerationStructure( accelerationStructure_ )
    {}

    VULKAN_HPP_CONSTEXPR AccelerationStructureDeviceAddressInfoKHR(
      AccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureDeviceAddressInfoKHR( VkAccelerationStructureDeviceAddressInfoKHR const & rhs )
      VULKAN_HPP_NOEXCEPT
      : AccelerationStructureDeviceAddressInfoKHR(
          *reinterpret_cast<AccelerationStructureDeviceAddressInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureDeviceAddressInfoKHR &
      operator=( AccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureDeviceAddressInfoKHR &
      operator=( VkAccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureDeviceAddressInfoKHR &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureDeviceAddressInfoKHR & setAccelerationStructure(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureDeviceAddressInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureDeviceAddressInfoKHR *>( this );
    }

    operator VkAccelerationStructureDeviceAddressInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureDeviceAddressInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureDeviceAddressInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureDeviceAddressInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructure == rhs.accelerationStructure );
    }

    bool operator!=( AccelerationStructureDeviceAddressInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType = StructureType::eAccelerationStructureDeviceAddressInfoKHR;
    const void *                                   pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR ) ==
                              sizeof( VkAccelerationStructureDeviceAddressInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR>::value,
    "AccelerationStructureDeviceAddressInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureDeviceAddressInfoKHR>
  {
    using Type = AccelerationStructureDeviceAddressInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR const &
                            accelerationStructureDeviceAddressInfoKHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, accelerationStructureDeviceAddressInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, accelerationStructureDeviceAddressInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR,
                             seed,
                             accelerationStructureDeviceAddressInfoKHR.accelerationStructure );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureGeometryMotionTrianglesDataNV
  {
    using NativeType = VkAccelerationStructureGeometryMotionTrianglesDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV(
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData_ = {} ) VULKAN_HPP_NOEXCEPT
      : vertexData( vertexData_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV(
      AccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryMotionTrianglesDataNV(
      VkAccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryMotionTrianglesDataNV(
          *reinterpret_cast<AccelerationStructureGeometryMotionTrianglesDataNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureGeometryMotionTrianglesDataNV &
      operator=( AccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryMotionTrianglesDataNV &
      operator=( VkAccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this =
        *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryMotionTrianglesDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV &
      setVertexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureGeometryMotionTrianglesDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryMotionTrianglesDataNV *>( this );
    }

    operator VkAccelerationStructureGeometryMotionTrianglesDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryMotionTrianglesDataNV *>( this );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV;
    const void *                        pNext = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryMotionTrianglesDataNV ) ==
                              sizeof( VkAccelerationStructureGeometryMotionTrianglesDataNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryMotionTrianglesDataNV>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryMotionTrianglesDataNV>::value,
    "AccelerationStructureGeometryMotionTrianglesDataNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV>
  {
    using Type = AccelerationStructureGeometryMotionTrianglesDataNV;
  };

  struct TransformMatrixKHR
  {
    using NativeType = VkTransformMatrixKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      TransformMatrixKHR( std::array<std::array<float, 4>, 3> const & matrix_ = {} ) VULKAN_HPP_NOEXCEPT
      : matrix( matrix_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR( TransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    TransformMatrixKHR( VkTransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : TransformMatrixKHR( *reinterpret_cast<TransformMatrixKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    TransformMatrixKHR & operator=( TransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    TransformMatrixKHR & operator=( VkTransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::TransformMatrixKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR &
                            setMatrix( std::array<std::array<float, 4>, 3> matrix_ ) VULKAN_HPP_NOEXCEPT
    {
      matrix = matrix_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkTransformMatrixKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkTransformMatrixKHR *>( this );
    }

    operator VkTransformMatrixKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkTransformMatrixKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( TransformMatrixKHR const & ) const = default;
#else
    bool operator==( TransformMatrixKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( matrix == rhs.matrix );
    }

    bool operator!=( TransformMatrixKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ArrayWrapper2D<float, 3, 4> matrix = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::TransformMatrixKHR ) == sizeof( VkTransformMatrixKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::TransformMatrixKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::TransformMatrixKHR>::value,
                            "TransformMatrixKHR is not nothrow_move_constructible!" );
  using TransformMatrixNV = TransformMatrixKHR;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::TransformMatrixKHR>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::TransformMatrixKHR const & transformMatrixKHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    for ( size_t i = 0; i < 3; ++i )
    {
      for ( size_t j = 0; j < 4; ++j )
      {
        VULKAN_HPP_HASH_COMBINE( float, seed, transformMatrixKHR.matrix[i][j] );
      }
    }
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureInstanceKHR
  {
    using NativeType = VkAccelerationStructureInstanceKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureInstanceKHR( VULKAN_HPP_NAMESPACE::TransformMatrixKHR transform_           = {},
                                        uint32_t                                 instanceCustomIndex_ = {},
                                        uint32_t                                 mask_                = {},
                                        uint32_t instanceShaderBindingTableRecordOffset_              = {},
                                        VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_         = {},
                                        uint64_t accelerationStructureReference_ = {} ) VULKAN_HPP_NOEXCEPT
      : transform( transform_ )
      , instanceCustomIndex( instanceCustomIndex_ )
      , mask( mask_ )
      , instanceShaderBindingTableRecordOffset( instanceShaderBindingTableRecordOffset_ )
      , flags( flags_ )
      , accelerationStructureReference( accelerationStructureReference_ )
    {}

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureInstanceKHR( AccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInstanceKHR( VkAccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureInstanceKHR( *reinterpret_cast<AccelerationStructureInstanceKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureInstanceKHR &
      operator=( AccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInstanceKHR & operator=( VkAccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR &
      setTransform( VULKAN_HPP_NAMESPACE::TransformMatrixKHR const & transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR &
                            setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR &
      setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureInstanceKHR &
      setFlags( VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR &
      setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureInstanceKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureInstanceKHR *>( this );
    }

    operator VkAccelerationStructureInstanceKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureInstanceKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureInstanceKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureInstanceKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( transform == rhs.transform ) && ( instanceCustomIndex == rhs.instanceCustomIndex ) &&
             ( mask == rhs.mask ) &&
             ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) &&
             ( flags == rhs.flags ) && ( accelerationStructureReference == rhs.accelerationStructureReference );
    }

    bool operator!=( AccelerationStructureInstanceKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::TransformMatrixKHR transform = {};
    uint32_t                                 instanceCustomIndex : 24;
    uint32_t                                 mask : 8;
    uint32_t                                 instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR               flags : 8;
    uint64_t                                 accelerationStructureReference = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR ) ==
                              sizeof( VkAccelerationStructureInstanceKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR>::value,
    "AccelerationStructureInstanceKHR is not nothrow_move_constructible!" );
  using AccelerationStructureInstanceNV = AccelerationStructureInstanceKHR;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR const & accelerationStructureInstanceKHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::TransformMatrixKHR, seed, accelerationStructureInstanceKHR.transform );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureInstanceKHR.instanceCustomIndex );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureInstanceKHR.mask );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureInstanceKHR.instanceShaderBindingTableRecordOffset );
    VULKAN_HPP_HASH_COMBINE( VkGeometryInstanceFlagsKHR, seed, accelerationStructureInstanceKHR.flags );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, accelerationStructureInstanceKHR.accelerationStructureReference );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureMatrixMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureMatrixMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureMatrixMotionInstanceNV( VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT0_         = {},
                                                   VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT1_         = {},
                                                   uint32_t                                 instanceCustomIndex_ = {},
                                                   uint32_t                                 mask_                = {},
                                                   uint32_t instanceShaderBindingTableRecordOffset_              = {},
                                                   VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_         = {},
                                                   uint64_t accelerationStructureReference_ = {} ) VULKAN_HPP_NOEXCEPT
      : transformT0( transformT0_ )
      , transformT1( transformT1_ )
      , instanceCustomIndex( instanceCustomIndex_ )
      , mask( mask_ )
      , instanceShaderBindingTableRecordOffset( instanceShaderBindingTableRecordOffset_ )
      , flags( flags_ )
      , accelerationStructureReference( accelerationStructureReference_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV(
      AccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMatrixMotionInstanceNV( VkAccelerationStructureMatrixMotionInstanceNV const & rhs )
      VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMatrixMotionInstanceNV(
          *reinterpret_cast<AccelerationStructureMatrixMotionInstanceNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureMatrixMotionInstanceNV &
      operator=( AccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMatrixMotionInstanceNV &
      operator=( VkAccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
      setTransformT0( VULKAN_HPP_NAMESPACE::TransformMatrixKHR const & transformT0_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT0 = transformT0_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
      setTransformT1( VULKAN_HPP_NAMESPACE::TransformMatrixKHR const & transformT1_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT1 = transformT1_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
                            setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
      setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureMatrixMotionInstanceNV &
      setFlags( VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
      setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureMatrixMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMatrixMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureMatrixMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMatrixMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMatrixMotionInstanceNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMatrixMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( transformT0 == rhs.transformT0 ) && ( transformT1 == rhs.transformT1 ) &&
             ( instanceCustomIndex == rhs.instanceCustomIndex ) && ( mask == rhs.mask ) &&
             ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) &&
             ( flags == rhs.flags ) && ( accelerationStructureReference == rhs.accelerationStructureReference );
    }

    bool operator!=( AccelerationStructureMatrixMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT0 = {};
    VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT1 = {};
    uint32_t                                 instanceCustomIndex : 24;
    uint32_t                                 mask : 8;
    uint32_t                                 instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR               flags : 8;
    uint64_t                                 accelerationStructureReference = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV ) ==
                              sizeof( VkAccelerationStructureMatrixMotionInstanceNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV>::value,
    "AccelerationStructureMatrixMotionInstanceNV is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV const &
                            accelerationStructureMatrixMotionInstanceNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::TransformMatrixKHR, seed, accelerationStructureMatrixMotionInstanceNV.transformT0 );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::TransformMatrixKHR, seed, accelerationStructureMatrixMotionInstanceNV.transformT1 );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureMatrixMotionInstanceNV.instanceCustomIndex );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureMatrixMotionInstanceNV.mask );
    VULKAN_HPP_HASH_COMBINE(
      uint32_t, seed, accelerationStructureMatrixMotionInstanceNV.instanceShaderBindingTableRecordOffset );
    VULKAN_HPP_HASH_COMBINE( VkGeometryInstanceFlagsKHR, seed, accelerationStructureMatrixMotionInstanceNV.flags );
    VULKAN_HPP_HASH_COMBINE(
      uint64_t, seed, accelerationStructureMatrixMotionInstanceNV.accelerationStructureReference );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureMemoryRequirementsInfoNV
  {
    using NativeType = VkAccelerationStructureMemoryRequirementsInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureMemoryRequirementsInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureMemoryRequirementsInfoNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV type_ =
        VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV::eObject,
      VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure_ = {} ) VULKAN_HPP_NOEXCEPT
      : type( type_ )
      , accelerationStructure( accelerationStructure_ )
    {}

    VULKAN_HPP_CONSTEXPR AccelerationStructureMemoryRequirementsInfoNV(
      AccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMemoryRequirementsInfoNV( VkAccelerationStructureMemoryRequirementsInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMemoryRequirementsInfoNV(
          *reinterpret_cast<AccelerationStructureMemoryRequirementsInfoNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureMemoryRequirementsInfoNV &
      operator=( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMemoryRequirementsInfoNV &
      operator=( VkAccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV &
      setType( VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV & setAccelerationStructure(
      VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureMemoryRequirementsInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMemoryRequirementsInfoNV *>( this );
    }

    operator VkAccelerationStructureMemoryRequirementsInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMemoryRequirementsInfoNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMemoryRequirementsInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( type == rhs.type ) &&
             ( accelerationStructure == rhs.accelerationStructure );
    }

    bool operator!=( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eAccelerationStructureMemoryRequirementsInfoNV;
    const void *                        pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV type =
      VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV::eObject;
    VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV ) ==
                              sizeof( VkAccelerationStructureMemoryRequirementsInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV>::value,
    "AccelerationStructureMemoryRequirementsInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureMemoryRequirementsInfoNV>
  {
    using Type = AccelerationStructureMemoryRequirementsInfoNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV const &
                            accelerationStructureMemoryRequirementsInfoNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, accelerationStructureMemoryRequirementsInfoNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, accelerationStructureMemoryRequirementsInfoNV.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV,
                             seed,
                             accelerationStructureMemoryRequirementsInfoNV.type );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccelerationStructureNV,
                             seed,
                             accelerationStructureMemoryRequirementsInfoNV.accelerationStructure );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureMotionInfoNV
  {
    using NativeType = VkAccelerationStructureMotionInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureMotionInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureMotionInfoNV(
      uint32_t                                                     maxInstances_ = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV flags_        = {} ) VULKAN_HPP_NOEXCEPT
      : maxInstances( maxInstances_ )
      , flags( flags_ )
    {}

    VULKAN_HPP_CONSTEXPR
      AccelerationStructureMotionInfoNV( AccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInfoNV( VkAccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMotionInfoNV( *reinterpret_cast<AccelerationStructureMotionInfoNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureMotionInfoNV &
      operator=( AccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInfoNV & operator=( VkAccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV &
                            setMaxInstances( uint32_t maxInstances_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInstances = maxInstances_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV &
      setFlags( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureMotionInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInfoNV *>( this );
    }

    operator VkAccelerationStructureMotionInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInfoNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMotionInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMotionInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( maxInstances == rhs.maxInstances ) &&
             ( flags == rhs.flags );
    }

    bool operator!=( AccelerationStructureMotionInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eAccelerationStructureMotionInfoNV;
    const void *                        pNext        = {};
    uint32_t                            maxInstances = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV flags = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV ) ==
                              sizeof( VkAccelerationStructureMotionInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV>::value,
    "AccelerationStructureMotionInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureMotionInfoNV>
  {
    using Type = AccelerationStructureMotionInfoNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV const &
                            accelerationStructureMotionInfoNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, accelerationStructureMotionInfoNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, accelerationStructureMotionInfoNV.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureMotionInfoNV.maxInstances );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV, seed, accelerationStructureMotionInfoNV.flags );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct SRTDataNV
  {
    using NativeType = VkSRTDataNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SRTDataNV( float sx_  = {},
                                    float a_   = {},
                                    float b_   = {},
                                    float pvx_ = {},
                                    float sy_  = {},
                                    float c_   = {},
                                    float pvy_ = {},
                                    float sz_  = {},
                                    float pvz_ = {},
                                    float qx_  = {},
                                    float qy_  = {},
                                    float qz_  = {},
                                    float qw_  = {},
                                    float tx_  = {},
                                    float ty_  = {},
                                    float tz_  = {} ) VULKAN_HPP_NOEXCEPT
      : sx( sx_ )
      , a( a_ )
      , b( b_ )
      , pvx( pvx_ )
      , sy( sy_ )
      , c( c_ )
      , pvy( pvy_ )
      , sz( sz_ )
      , pvz( pvz_ )
      , qx( qx_ )
      , qy( qy_ )
      , qz( qz_ )
      , qw( qw_ )
      , tx( tx_ )
      , ty( ty_ )
      , tz( tz_ )
    {}

    VULKAN_HPP_CONSTEXPR SRTDataNV( SRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SRTDataNV( VkSRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT : SRTDataNV( *reinterpret_cast<SRTDataNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SRTDataNV & operator=( SRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SRTDataNV & operator=( VkSRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SRTDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSx( float sx_ ) VULKAN_HPP_NOEXCEPT
    {
      sx = sx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setA( float a_ ) VULKAN_HPP_NOEXCEPT
    {
      a = a_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setB( float b_ ) VULKAN_HPP_NOEXCEPT
    {
      b = b_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvx( float pvx_ ) VULKAN_HPP_NOEXCEPT
    {
      pvx = pvx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSy( float sy_ ) VULKAN_HPP_NOEXCEPT
    {
      sy = sy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setC( float c_ ) VULKAN_HPP_NOEXCEPT
    {
      c = c_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvy( float pvy_ ) VULKAN_HPP_NOEXCEPT
    {
      pvy = pvy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSz( float sz_ ) VULKAN_HPP_NOEXCEPT
    {
      sz = sz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvz( float pvz_ ) VULKAN_HPP_NOEXCEPT
    {
      pvz = pvz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQx( float qx_ ) VULKAN_HPP_NOEXCEPT
    {
      qx = qx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQy( float qy_ ) VULKAN_HPP_NOEXCEPT
    {
      qy = qy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQz( float qz_ ) VULKAN_HPP_NOEXCEPT
    {
      qz = qz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQw( float qw_ ) VULKAN_HPP_NOEXCEPT
    {
      qw = qw_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTx( float tx_ ) VULKAN_HPP_NOEXCEPT
    {
      tx = tx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTy( float ty_ ) VULKAN_HPP_NOEXCEPT
    {
      ty = ty_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTz( float tz_ ) VULKAN_HPP_NOEXCEPT
    {
      tz = tz_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSRTDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSRTDataNV *>( this );
    }

    operator VkSRTDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSRTDataNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SRTDataNV const & ) const = default;
#else
    bool operator==( SRTDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sx == rhs.sx ) && ( a == rhs.a ) && ( b == rhs.b ) && ( pvx == rhs.pvx ) && ( sy == rhs.sy ) &&
             ( c == rhs.c ) && ( pvy == rhs.pvy ) && ( sz == rhs.sz ) && ( pvz == rhs.pvz ) && ( qx == rhs.qx ) &&
             ( qy == rhs.qy ) && ( qz == rhs.qz ) && ( qw == rhs.qw ) && ( tx == rhs.tx ) && ( ty == rhs.ty ) &&
             ( tz == rhs.tz );
    }

    bool operator!=( SRTDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float sx  = {};
    float a   = {};
    float b   = {};
    float pvx = {};
    float sy  = {};
    float c   = {};
    float pvy = {};
    float sz  = {};
    float pvz = {};
    float qx  = {};
    float qy  = {};
    float qz  = {};
    float qw  = {};
    float tx  = {};
    float ty  = {};
    float tz  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SRTDataNV ) == sizeof( VkSRTDataNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SRTDataNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SRTDataNV>::value,
                            "SRTDataNV is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SRTDataNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::SRTDataNV const & sRTDataNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.sx );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.a );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.b );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.pvx );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.sy );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.c );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.pvy );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.sz );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.pvz );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.qx );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.qy );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.qz );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.qw );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.tx );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.ty );
    VULKAN_HPP_HASH_COMBINE( float, seed, sRTDataNV.tz );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AccelerationStructureSRTMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureSRTMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AccelerationStructureSRTMotionInstanceNV( VULKAN_HPP_NAMESPACE::SRTDataNV transformT0_          = {},
                                                VULKAN_HPP_NAMESPACE::SRTDataNV transformT1_          = {},
                                                uint32_t                        instanceCustomIndex_  = {},
                                                uint32_t                        mask_                 = {},
                                                uint32_t instanceShaderBindingTableRecordOffset_      = {},
                                                VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_ = {},
                                                uint64_t accelerationStructureReference_ = {} ) VULKAN_HPP_NOEXCEPT
      : transformT0( transformT0_ )
      , transformT1( transformT1_ )
      , instanceCustomIndex( instanceCustomIndex_ )
      , mask( mask_ )
      , instanceShaderBindingTableRecordOffset( instanceShaderBindingTableRecordOffset_ )
      , flags( flags_ )
      , accelerationStructureReference( accelerationStructureReference_ )
    {}

    VULKAN_HPP_CONSTEXPR AccelerationStructureSRTMotionInstanceNV(
      AccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureSRTMotionInstanceNV( VkAccelerationStructureSRTMotionInstanceNV const & rhs )
      VULKAN_HPP_NOEXCEPT
      : AccelerationStructureSRTMotionInstanceNV(
          *reinterpret_cast<AccelerationStructureSRTMotionInstanceNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureSRTMotionInstanceNV &
      operator=( AccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureSRTMotionInstanceNV &
      operator=( VkAccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
                            setTransformT0( VULKAN_HPP_NAMESPACE::SRTDataNV const & transformT0_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT0 = transformT0_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
                            setTransformT1( VULKAN_HPP_NAMESPACE::SRTDataNV const & transformT1_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT1 = transformT1_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
                            setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
      setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureSRTMotionInstanceNV &
      setFlags( VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
      setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureSRTMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureSRTMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureSRTMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureSRTMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureSRTMotionInstanceNV const & ) const = default;
#else
    bool operator==( AccelerationStructureSRTMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( transformT0 == rhs.transformT0 ) && ( transformT1 == rhs.transformT1 ) &&
             ( instanceCustomIndex == rhs.instanceCustomIndex ) && ( mask == rhs.mask ) &&
             ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) &&
             ( flags == rhs.flags ) && ( accelerationStructureReference == rhs.accelerationStructureReference );
    }

    bool operator!=( AccelerationStructureSRTMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::SRTDataNV transformT0 = {};
    VULKAN_HPP_NAMESPACE::SRTDataNV transformT1 = {};
    uint32_t                        instanceCustomIndex : 24;
    uint32_t                        mask : 8;
    uint32_t                        instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR      flags : 8;
    uint64_t                        accelerationStructureReference = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV ) ==
                              sizeof( VkAccelerationStructureSRTMotionInstanceNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV>::value,
    "AccelerationStructureSRTMotionInstanceNV is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV const &
                            accelerationStructureSRTMotionInstanceNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SRTDataNV, seed, accelerationStructureSRTMotionInstanceNV.transformT0 );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SRTDataNV, seed, accelerationStructureSRTMotionInstanceNV.transformT1 );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureSRTMotionInstanceNV.instanceCustomIndex );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, accelerationStructureSRTMotionInstanceNV.mask );
    VULKAN_HPP_HASH_COMBINE(
      uint32_t, seed, accelerationStructureSRTMotionInstanceNV.instanceShaderBindingTableRecordOffset );
    VULKAN_HPP_HASH_COMBINE( VkGeometryInstanceFlagsKHR, seed, accelerationStructureSRTMotionInstanceNV.flags );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, accelerationStructureSRTMotionInstanceNV.accelerationStructureReference );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  union AccelerationStructureMotionInstanceDataNV
  {
    using NativeType = VkAccelerationStructureMotionInstanceDataNV;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR staticInstance_ = {} )
      : staticInstance( staticInstance_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV matrixMotionInstance_ )
      : matrixMotionInstance( matrixMotionInstance_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV srtMotionInstance_ )
      : srtMotionInstance( srtMotionInstance_ )
    {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV & setStaticInstance(
      VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR const & staticInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      staticInstance = staticInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV & setMatrixMotionInstance(
      VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV const & matrixMotionInstance_ )
      VULKAN_HPP_NOEXCEPT
    {
      matrixMotionInstance = matrixMotionInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV & setSrtMotionInstance(
      VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV const & srtMotionInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      srtMotionInstance = srtMotionInstance_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkAccelerationStructureMotionInstanceDataNV const &() const
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInstanceDataNV *>( this );
    }

    operator VkAccelerationStructureMotionInstanceDataNV &()
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInstanceDataNV *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR            staticInstance;
    VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV matrixMotionInstance;
    VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV    srtMotionInstance;
#else
    VkAccelerationStructureInstanceKHR            staticInstance;
    VkAccelerationStructureMatrixMotionInstanceNV matrixMotionInstance;
    VkAccelerationStructureSRTMotionInstanceNV    srtMotionInstance;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV type_ =
        VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV::eStatic,
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV flags_ = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV  data_  = {} ) VULKAN_HPP_NOEXCEPT
      : type( type_ )
      , flags( flags_ )
      , data( data_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV( AccelerationStructureMotionInstanceNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInstanceNV( VkAccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMotionInstanceNV(
          *reinterpret_cast<AccelerationStructureMotionInstanceNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureMotionInstanceNV &
      operator=( AccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInstanceNV &
      operator=( VkAccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV &
      setType( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV &
      setFlags( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV &
      setData( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInstanceNV *>( this );
    }

  public:
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV type =
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV::eStatic;
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV flags = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV  data  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceNV ) ==
                              sizeof( VkAccelerationStructureMotionInstanceNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceNV>::value,
    "AccelerationStructureMotionInstanceNV is not nothrow_move_constructible!" );

  struct AccelerationStructureVersionInfoKHR
  {
    using NativeType = VkAccelerationStructureVersionInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAccelerationStructureVersionInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureVersionInfoKHR( const uint8_t * pVersionData_ = {} ) VULKAN_HPP_NOEXCEPT
      : pVersionData( pVersionData_ )
    {}

    VULKAN_HPP_CONSTEXPR AccelerationStructureVersionInfoKHR( AccelerationStructureVersionInfoKHR const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureVersionInfoKHR( VkAccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureVersionInfoKHR( *reinterpret_cast<AccelerationStructureVersionInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureVersionInfoKHR &
      operator=( AccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureVersionInfoKHR &
      operator=( VkAccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureVersionInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureVersionInfoKHR &
                            setPVersionData( const uint8_t * pVersionData_ ) VULKAN_HPP_NOEXCEPT
    {
      pVersionData = pVersionData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAccelerationStructureVersionInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureVersionInfoKHR *>( this );
    }

    operator VkAccelerationStructureVersionInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureVersionInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureVersionInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureVersionInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pVersionData == rhs.pVersionData );
    }

    bool operator!=( AccelerationStructureVersionInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eAccelerationStructureVersionInfoKHR;
    const void *                        pNext        = {};
    const uint8_t *                     pVersionData = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR ) ==
                              sizeof( VkAccelerationStructureVersionInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR>::value,
    "AccelerationStructureVersionInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureVersionInfoKHR>
  {
    using Type = AccelerationStructureVersionInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR const &
                            accelerationStructureVersionInfoKHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, accelerationStructureVersionInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, accelerationStructureVersionInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE( const uint8_t *, seed, accelerationStructureVersionInfoKHR.pVersionData );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AcquireNextImageInfoKHR
  {
    using NativeType = VkAcquireNextImageInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAcquireNextImageInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AcquireNextImageInfoKHR( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_ = {},
                                                  uint64_t                           timeout_   = {},
                                                  VULKAN_HPP_NAMESPACE::Semaphore    semaphore_ = {},
                                                  VULKAN_HPP_NAMESPACE::Fence        fence_     = {},
                                                  uint32_t deviceMask_ = {} ) VULKAN_HPP_NOEXCEPT
      : swapchain( swapchain_ )
      , timeout( timeout_ )
      , semaphore( semaphore_ )
      , fence( fence_ )
      , deviceMask( deviceMask_ )
    {}

    VULKAN_HPP_CONSTEXPR AcquireNextImageInfoKHR( AcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireNextImageInfoKHR( VkAcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AcquireNextImageInfoKHR( *reinterpret_cast<AcquireNextImageInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AcquireNextImageInfoKHR & operator=( AcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireNextImageInfoKHR & operator=( VkAcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR &
                            setSwapchain( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchain = swapchain_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setTimeout( uint64_t timeout_ ) VULKAN_HPP_NOEXCEPT
    {
      timeout = timeout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR &
                            setSemaphore( VULKAN_HPP_NAMESPACE::Semaphore semaphore_ ) VULKAN_HPP_NOEXCEPT
    {
      semaphore = semaphore_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setFence( VULKAN_HPP_NAMESPACE::Fence fence_ ) VULKAN_HPP_NOEXCEPT
    {
      fence = fence_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAcquireNextImageInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAcquireNextImageInfoKHR *>( this );
    }

    operator VkAcquireNextImageInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAcquireNextImageInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AcquireNextImageInfoKHR const & ) const = default;
#else
    bool operator==( AcquireNextImageInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchain == rhs.swapchain ) &&
             ( timeout == rhs.timeout ) && ( semaphore == rhs.semaphore ) && ( fence == rhs.fence ) &&
             ( deviceMask == rhs.deviceMask );
    }

    bool operator!=( AcquireNextImageInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eAcquireNextImageInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::SwapchainKHR  swapchain  = {};
    uint64_t                            timeout    = {};
    VULKAN_HPP_NAMESPACE::Semaphore     semaphore  = {};
    VULKAN_HPP_NAMESPACE::Fence         fence      = {};
    uint32_t                            deviceMask = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR ) ==
                              sizeof( VkAcquireNextImageInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR>::value,
                            "AcquireNextImageInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAcquireNextImageInfoKHR>
  {
    using Type = AcquireNextImageInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR const & acquireNextImageInfoKHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, acquireNextImageInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, acquireNextImageInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SwapchainKHR, seed, acquireNextImageInfoKHR.swapchain );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, acquireNextImageInfoKHR.timeout );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Semaphore, seed, acquireNextImageInfoKHR.semaphore );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Fence, seed, acquireNextImageInfoKHR.fence );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, acquireNextImageInfoKHR.deviceMask );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AcquireProfilingLockInfoKHR
  {
    using NativeType = VkAcquireProfilingLockInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAcquireProfilingLockInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AcquireProfilingLockInfoKHR( VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags_ = {},
                                                      uint64_t timeout_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , timeout( timeout_ )
    {}

    VULKAN_HPP_CONSTEXPR
      AcquireProfilingLockInfoKHR( AcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireProfilingLockInfoKHR( VkAcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AcquireProfilingLockInfoKHR( *reinterpret_cast<AcquireProfilingLockInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AcquireProfilingLockInfoKHR & operator=( AcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireProfilingLockInfoKHR & operator=( VkAcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR &
                            setFlags( VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setTimeout( uint64_t timeout_ ) VULKAN_HPP_NOEXCEPT
    {
      timeout = timeout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAcquireProfilingLockInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAcquireProfilingLockInfoKHR *>( this );
    }

    operator VkAcquireProfilingLockInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAcquireProfilingLockInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AcquireProfilingLockInfoKHR const & ) const = default;
#else
    bool operator==( AcquireProfilingLockInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( timeout == rhs.timeout );
    }

    bool operator!=( AcquireProfilingLockInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType   = StructureType::eAcquireProfilingLockInfoKHR;
    const void *                                       pNext   = {};
    VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags   = {};
    uint64_t                                           timeout = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR ) ==
                              sizeof( VkAcquireProfilingLockInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR>::value,
    "AcquireProfilingLockInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAcquireProfilingLockInfoKHR>
  {
    using Type = AcquireProfilingLockInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR const & acquireProfilingLockInfoKHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, acquireProfilingLockInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, acquireProfilingLockInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR, seed, acquireProfilingLockInfoKHR.flags );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, acquireProfilingLockInfoKHR.timeout );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AllocationCallbacks
  {
    using NativeType = VkAllocationCallbacks;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AllocationCallbacks( void *                               pUserData_             = {},
                                              PFN_vkAllocationFunction             pfnAllocation_         = {},
                                              PFN_vkReallocationFunction           pfnReallocation_       = {},
                                              PFN_vkFreeFunction                   pfnFree_               = {},
                                              PFN_vkInternalAllocationNotification pfnInternalAllocation_ = {},
                                              PFN_vkInternalFreeNotification pfnInternalFree_ = {} ) VULKAN_HPP_NOEXCEPT
      : pUserData( pUserData_ )
      , pfnAllocation( pfnAllocation_ )
      , pfnReallocation( pfnReallocation_ )
      , pfnFree( pfnFree_ )
      , pfnInternalAllocation( pfnInternalAllocation_ )
      , pfnInternalFree( pfnInternalFree_ )
    {}

    VULKAN_HPP_CONSTEXPR AllocationCallbacks( AllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AllocationCallbacks( VkAllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT
      : AllocationCallbacks( *reinterpret_cast<AllocationCallbacks const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AllocationCallbacks & operator=( AllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AllocationCallbacks & operator=( VkAllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AllocationCallbacks const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks &
                            setPfnAllocation( PFN_vkAllocationFunction pfnAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnAllocation = pfnAllocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks &
                            setPfnReallocation( PFN_vkReallocationFunction pfnReallocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnReallocation = pfnReallocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnFree( PFN_vkFreeFunction pfnFree_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnFree = pfnFree_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks &
      setPfnInternalAllocation( PFN_vkInternalAllocationNotification pfnInternalAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnInternalAllocation = pfnInternalAllocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks &
                            setPfnInternalFree( PFN_vkInternalFreeNotification pfnInternalFree_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnInternalFree = pfnInternalFree_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAllocationCallbacks const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAllocationCallbacks *>( this );
    }

    operator VkAllocationCallbacks &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAllocationCallbacks *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AllocationCallbacks const & ) const = default;
#else
    bool operator==( AllocationCallbacks const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( pUserData == rhs.pUserData ) && ( pfnAllocation == rhs.pfnAllocation ) &&
             ( pfnReallocation == rhs.pfnReallocation ) && ( pfnFree == rhs.pfnFree ) &&
             ( pfnInternalAllocation == rhs.pfnInternalAllocation ) && ( pfnInternalFree == rhs.pfnInternalFree );
    }

    bool operator!=( AllocationCallbacks const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    void *                               pUserData             = {};
    PFN_vkAllocationFunction             pfnAllocation         = {};
    PFN_vkReallocationFunction           pfnReallocation       = {};
    PFN_vkFreeFunction                   pfnFree               = {};
    PFN_vkInternalAllocationNotification pfnInternalAllocation = {};
    PFN_vkInternalFreeNotification       pfnInternalFree       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AllocationCallbacks ) == sizeof( VkAllocationCallbacks ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AllocationCallbacks>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AllocationCallbacks>::value,
                            "AllocationCallbacks is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AllocationCallbacks>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::AllocationCallbacks const & allocationCallbacks ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( void *, seed, allocationCallbacks.pUserData );
    VULKAN_HPP_HASH_COMBINE( PFN_vkAllocationFunction, seed, allocationCallbacks.pfnAllocation );
    VULKAN_HPP_HASH_COMBINE( PFN_vkReallocationFunction, seed, allocationCallbacks.pfnReallocation );
    VULKAN_HPP_HASH_COMBINE( PFN_vkFreeFunction, seed, allocationCallbacks.pfnFree );
    VULKAN_HPP_HASH_COMBINE( PFN_vkInternalAllocationNotification, seed, allocationCallbacks.pfnInternalAllocation );
    VULKAN_HPP_HASH_COMBINE( PFN_vkInternalFreeNotification, seed, allocationCallbacks.pfnInternalFree );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct ComponentMapping
  {
    using NativeType = VkComponentMapping;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      ComponentMapping( VULKAN_HPP_NAMESPACE::ComponentSwizzle r_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                        VULKAN_HPP_NAMESPACE::ComponentSwizzle g_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                        VULKAN_HPP_NAMESPACE::ComponentSwizzle b_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                        VULKAN_HPP_NAMESPACE::ComponentSwizzle a_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity )
        VULKAN_HPP_NOEXCEPT
      : r( r_ )
      , g( g_ )
      , b( b_ )
      , a( a_ )
    {}

    VULKAN_HPP_CONSTEXPR ComponentMapping( ComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComponentMapping( VkComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT
      : ComponentMapping( *reinterpret_cast<ComponentMapping const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ComponentMapping & operator=( ComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComponentMapping & operator=( VkComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ComponentMapping const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setR( VULKAN_HPP_NAMESPACE::ComponentSwizzle r_ ) VULKAN_HPP_NOEXCEPT
    {
      r = r_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setG( VULKAN_HPP_NAMESPACE::ComponentSwizzle g_ ) VULKAN_HPP_NOEXCEPT
    {
      g = g_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setB( VULKAN_HPP_NAMESPACE::ComponentSwizzle b_ ) VULKAN_HPP_NOEXCEPT
    {
      b = b_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setA( VULKAN_HPP_NAMESPACE::ComponentSwizzle a_ ) VULKAN_HPP_NOEXCEPT
    {
      a = a_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkComponentMapping const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComponentMapping *>( this );
    }

    operator VkComponentMapping &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComponentMapping *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComponentMapping const & ) const = default;
#else
    bool operator==( ComponentMapping const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( r == rhs.r ) && ( g == rhs.g ) && ( b == rhs.b ) && ( a == rhs.a );
    }

    bool operator!=( ComponentMapping const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ComponentSwizzle r = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle g = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle b = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle a = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ComponentMapping ) == sizeof( VkComponentMapping ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ComponentMapping>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ComponentMapping>::value,
                            "ComponentMapping is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ComponentMapping>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::ComponentMapping const & componentMapping ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentSwizzle, seed, componentMapping.r );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentSwizzle, seed, componentMapping.g );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentSwizzle, seed, componentMapping.b );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentSwizzle, seed, componentMapping.a );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferFormatProperties2ANDROID
  {
    using NativeType = VkAndroidHardwareBufferFormatProperties2ANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAndroidHardwareBufferFormatProperties2ANDROID;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatProperties2ANDROID(
      VULKAN_HPP_NAMESPACE::Format                      format_         = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      uint64_t                                          externalFormat_ = {},
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags2KHR      formatFeatures_ = {},
      VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents_ = {},
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_ =
        VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity,
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange suggestedYcbcrRange_ = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull,
      VULKAN_HPP_NAMESPACE::ChromaLocation suggestedXChromaOffset_ = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      VULKAN_HPP_NAMESPACE::ChromaLocation suggestedYChromaOffset_ =
        VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven ) VULKAN_HPP_NOEXCEPT
      : format( format_ )
      , externalFormat( externalFormat_ )
      , formatFeatures( formatFeatures_ )
      , samplerYcbcrConversionComponents( samplerYcbcrConversionComponents_ )
      , suggestedYcbcrModel( suggestedYcbcrModel_ )
      , suggestedYcbcrRange( suggestedYcbcrRange_ )
      , suggestedXChromaOffset( suggestedXChromaOffset_ )
      , suggestedYChromaOffset( suggestedYChromaOffset_ )
    {}

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatProperties2ANDROID(
      AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatProperties2ANDROID( VkAndroidHardwareBufferFormatProperties2ANDROID const & rhs )
      VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferFormatProperties2ANDROID(
          *reinterpret_cast<AndroidHardwareBufferFormatProperties2ANDROID const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AndroidHardwareBufferFormatProperties2ANDROID &
      operator=( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatProperties2ANDROID &
      operator=( VkAndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferFormatProperties2ANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferFormatProperties2ANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatProperties2ANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferFormatProperties2ANDROID *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferFormatProperties2ANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( format == rhs.format ) &&
             ( externalFormat == rhs.externalFormat ) && ( formatFeatures == rhs.formatFeatures ) &&
             ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) &&
             ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
    }

    bool operator!=( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType  = StructureType::eAndroidHardwareBufferFormatProperties2ANDROID;
    void *                                       pNext  = {};
    VULKAN_HPP_NAMESPACE::Format                 format = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    uint64_t                                     externalFormat                   = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags2KHR formatFeatures                   = {};
    VULKAN_HPP_NAMESPACE::ComponentMapping       samplerYcbcrConversionComponents = {};
    VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel =
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity;
    VULKAN_HPP_NAMESPACE::SamplerYcbcrRange suggestedYcbcrRange    = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull;
    VULKAN_HPP_NAMESPACE::ChromaLocation    suggestedXChromaOffset = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
    VULKAN_HPP_NAMESPACE::ChromaLocation    suggestedYChromaOffset = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID ) ==
                              sizeof( VkAndroidHardwareBufferFormatProperties2ANDROID ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID>::value,
    "AndroidHardwareBufferFormatProperties2ANDROID is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferFormatProperties2ANDROID>
  {
    using Type = AndroidHardwareBufferFormatProperties2ANDROID;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID const &
                            androidHardwareBufferFormatProperties2ANDROID ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, androidHardwareBufferFormatProperties2ANDROID.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, androidHardwareBufferFormatProperties2ANDROID.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Format, seed, androidHardwareBufferFormatProperties2ANDROID.format );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, androidHardwareBufferFormatProperties2ANDROID.externalFormat );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::FormatFeatureFlags2KHR,
                             seed,
                             androidHardwareBufferFormatProperties2ANDROID.formatFeatures );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentMapping,
                             seed,
                             androidHardwareBufferFormatProperties2ANDROID.samplerYcbcrConversionComponents );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion,
                             seed,
                             androidHardwareBufferFormatProperties2ANDROID.suggestedYcbcrModel );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SamplerYcbcrRange,
                             seed,
                             androidHardwareBufferFormatProperties2ANDROID.suggestedYcbcrRange );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ChromaLocation,
                             seed,
                             androidHardwareBufferFormatProperties2ANDROID.suggestedXChromaOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ChromaLocation,
                             seed,
                             androidHardwareBufferFormatProperties2ANDROID.suggestedYChromaOffset );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferFormatPropertiesANDROID
  {
    using NativeType = VkAndroidHardwareBufferFormatPropertiesANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAndroidHardwareBufferFormatPropertiesANDROID;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatPropertiesANDROID(
      VULKAN_HPP_NAMESPACE::Format                      format_         = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      uint64_t                                          externalFormat_ = {},
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures_ = {},
      VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents_ = {},
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_ =
        VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity,
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange suggestedYcbcrRange_ = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull,
      VULKAN_HPP_NAMESPACE::ChromaLocation suggestedXChromaOffset_ = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      VULKAN_HPP_NAMESPACE::ChromaLocation suggestedYChromaOffset_ =
        VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven ) VULKAN_HPP_NOEXCEPT
      : format( format_ )
      , externalFormat( externalFormat_ )
      , formatFeatures( formatFeatures_ )
      , samplerYcbcrConversionComponents( samplerYcbcrConversionComponents_ )
      , suggestedYcbcrModel( suggestedYcbcrModel_ )
      , suggestedYcbcrRange( suggestedYcbcrRange_ )
      , suggestedXChromaOffset( suggestedXChromaOffset_ )
      , suggestedYChromaOffset( suggestedYChromaOffset_ )
    {}

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatPropertiesANDROID(
      AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatPropertiesANDROID( VkAndroidHardwareBufferFormatPropertiesANDROID const & rhs )
      VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferFormatPropertiesANDROID(
          *reinterpret_cast<AndroidHardwareBufferFormatPropertiesANDROID const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AndroidHardwareBufferFormatPropertiesANDROID &
      operator=( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatPropertiesANDROID &
      operator=( VkAndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferFormatPropertiesANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferFormatPropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatPropertiesANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferFormatPropertiesANDROID *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferFormatPropertiesANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( format == rhs.format ) &&
             ( externalFormat == rhs.externalFormat ) && ( formatFeatures == rhs.formatFeatures ) &&
             ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) &&
             ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
    }

    bool operator!=( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType  = StructureType::eAndroidHardwareBufferFormatPropertiesANDROID;
    void *                                   pNext  = {};
    VULKAN_HPP_NAMESPACE::Format             format = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    uint64_t                                 externalFormat                   = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags formatFeatures                   = {};
    VULKAN_HPP_NAMESPACE::ComponentMapping   samplerYcbcrConversionComponents = {};
    VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel =
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity;
    VULKAN_HPP_NAMESPACE::SamplerYcbcrRange suggestedYcbcrRange    = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull;
    VULKAN_HPP_NAMESPACE::ChromaLocation    suggestedXChromaOffset = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
    VULKAN_HPP_NAMESPACE::ChromaLocation    suggestedYChromaOffset = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID ) ==
                              sizeof( VkAndroidHardwareBufferFormatPropertiesANDROID ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID>::value,
    "AndroidHardwareBufferFormatPropertiesANDROID is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferFormatPropertiesANDROID>
  {
    using Type = AndroidHardwareBufferFormatPropertiesANDROID;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID const &
                            androidHardwareBufferFormatPropertiesANDROID ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, androidHardwareBufferFormatPropertiesANDROID.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, androidHardwareBufferFormatPropertiesANDROID.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Format, seed, androidHardwareBufferFormatPropertiesANDROID.format );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, androidHardwareBufferFormatPropertiesANDROID.externalFormat );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags, seed, androidHardwareBufferFormatPropertiesANDROID.formatFeatures );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentMapping,
                             seed,
                             androidHardwareBufferFormatPropertiesANDROID.samplerYcbcrConversionComponents );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion,
                             seed,
                             androidHardwareBufferFormatPropertiesANDROID.suggestedYcbcrModel );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange, seed, androidHardwareBufferFormatPropertiesANDROID.suggestedYcbcrRange );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::ChromaLocation, seed, androidHardwareBufferFormatPropertiesANDROID.suggestedXChromaOffset );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::ChromaLocation, seed, androidHardwareBufferFormatPropertiesANDROID.suggestedYChromaOffset );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferPropertiesANDROID
  {
    using NativeType = VkAndroidHardwareBufferPropertiesANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAndroidHardwareBufferPropertiesANDROID;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferPropertiesANDROID( VULKAN_HPP_NAMESPACE::DeviceSize allocationSize_ = {},
                                                                 uint32_t memoryTypeBits_ = {} ) VULKAN_HPP_NOEXCEPT
      : allocationSize( allocationSize_ )
      , memoryTypeBits( memoryTypeBits_ )
    {}

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferPropertiesANDROID( AndroidHardwareBufferPropertiesANDROID const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferPropertiesANDROID( VkAndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferPropertiesANDROID(
          *reinterpret_cast<AndroidHardwareBufferPropertiesANDROID const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AndroidHardwareBufferPropertiesANDROID &
      operator=( AndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferPropertiesANDROID &
      operator=( VkAndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferPropertiesANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferPropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferPropertiesANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferPropertiesANDROID *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferPropertiesANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( allocationSize == rhs.allocationSize ) &&
             ( memoryTypeBits == rhs.memoryTypeBits );
    }

    bool operator!=( AndroidHardwareBufferPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType          = StructureType::eAndroidHardwareBufferPropertiesANDROID;
    void *                              pNext          = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    allocationSize = {};
    uint32_t                            memoryTypeBits = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID ) ==
                              sizeof( VkAndroidHardwareBufferPropertiesANDROID ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID>::value,
    "AndroidHardwareBufferPropertiesANDROID is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferPropertiesANDROID>
  {
    using Type = AndroidHardwareBufferPropertiesANDROID;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID const &
                            androidHardwareBufferPropertiesANDROID ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, androidHardwareBufferPropertiesANDROID.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, androidHardwareBufferPropertiesANDROID.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DeviceSize, seed, androidHardwareBufferPropertiesANDROID.allocationSize );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, androidHardwareBufferPropertiesANDROID.memoryTypeBits );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferUsageANDROID
  {
    using NativeType = VkAndroidHardwareBufferUsageANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAndroidHardwareBufferUsageANDROID;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferUsageANDROID( uint64_t androidHardwareBufferUsage_ = {} ) VULKAN_HPP_NOEXCEPT
      : androidHardwareBufferUsage( androidHardwareBufferUsage_ )
    {}

    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferUsageANDROID( AndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferUsageANDROID( VkAndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferUsageANDROID( *reinterpret_cast<AndroidHardwareBufferUsageANDROID const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AndroidHardwareBufferUsageANDROID &
      operator=( AndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferUsageANDROID & operator=( VkAndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferUsageANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferUsageANDROID *>( this );
    }

    operator VkAndroidHardwareBufferUsageANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferUsageANDROID *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferUsageANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferUsageANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( androidHardwareBufferUsage == rhs.androidHardwareBufferUsage );
    }

    bool operator!=( AndroidHardwareBufferUsageANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                      = StructureType::eAndroidHardwareBufferUsageANDROID;
    void *                              pNext                      = {};
    uint64_t                            androidHardwareBufferUsage = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID ) ==
                              sizeof( VkAndroidHardwareBufferUsageANDROID ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID>::value,
    "AndroidHardwareBufferUsageANDROID is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferUsageANDROID>
  {
    using Type = AndroidHardwareBufferUsageANDROID;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID const &
                            androidHardwareBufferUsageANDROID ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, androidHardwareBufferUsageANDROID.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, androidHardwareBufferUsageANDROID.pNext );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, androidHardwareBufferUsageANDROID.androidHardwareBufferUsage );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidSurfaceCreateInfoKHR
  {
    using NativeType = VkAndroidSurfaceCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidSurfaceCreateInfoKHR;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidSurfaceCreateInfoKHR( VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR flags_ = {},
                                                      struct ANativeWindow * window_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , window( window_ )
    {}

    VULKAN_HPP_CONSTEXPR
      AndroidSurfaceCreateInfoKHR( AndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidSurfaceCreateInfoKHR( VkAndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidSurfaceCreateInfoKHR( *reinterpret_cast<AndroidSurfaceCreateInfoKHR const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AndroidSurfaceCreateInfoKHR & operator=( AndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidSurfaceCreateInfoKHR & operator=( VkAndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR &
                            setFlags( VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR &
                            setWindow( struct ANativeWindow * window_ ) VULKAN_HPP_NOEXCEPT
    {
      window = window_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAndroidSurfaceCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidSurfaceCreateInfoKHR *>( this );
    }

    operator VkAndroidSurfaceCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidSurfaceCreateInfoKHR *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidSurfaceCreateInfoKHR const & ) const = default;
#  else
    bool operator==( AndroidSurfaceCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( window == rhs.window );
    }

    bool operator!=( AndroidSurfaceCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType  = StructureType::eAndroidSurfaceCreateInfoKHR;
    const void *                                       pNext  = {};
    VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR flags  = {};
    struct ANativeWindow *                             window = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR ) ==
                              sizeof( VkAndroidSurfaceCreateInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR>::value,
    "AndroidSurfaceCreateInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAndroidSurfaceCreateInfoKHR>
  {
    using Type = AndroidSurfaceCreateInfoKHR;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR const & androidSurfaceCreateInfoKHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, androidSurfaceCreateInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, androidSurfaceCreateInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR, seed, androidSurfaceCreateInfoKHR.flags );
    VULKAN_HPP_HASH_COMBINE( struct ANativeWindow *, seed, androidSurfaceCreateInfoKHR.window );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

  struct ApplicationInfo
  {
    using NativeType = VkApplicationInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eApplicationInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ApplicationInfo( const char * pApplicationName_   = {},
                                          uint32_t     applicationVersion_ = {},
                                          const char * pEngineName_        = {},
                                          uint32_t     engineVersion_      = {},
                                          uint32_t     apiVersion_         = {} ) VULKAN_HPP_NOEXCEPT
      : pApplicationName( pApplicationName_ )
      , applicationVersion( applicationVersion_ )
      , pEngineName( pEngineName_ )
      , engineVersion( engineVersion_ )
      , apiVersion( apiVersion_ )
    {}

    VULKAN_HPP_CONSTEXPR ApplicationInfo( ApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ApplicationInfo( VkApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ApplicationInfo( *reinterpret_cast<ApplicationInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ApplicationInfo & operator=( ApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ApplicationInfo & operator=( VkApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ApplicationInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPApplicationName( const char * pApplicationName_ ) VULKAN_HPP_NOEXCEPT
    {
      pApplicationName = pApplicationName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setApplicationVersion( uint32_t applicationVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      applicationVersion = applicationVersion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPEngineName( const char * pEngineName_ ) VULKAN_HPP_NOEXCEPT
    {
      pEngineName = pEngineName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setEngineVersion( uint32_t engineVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      engineVersion = engineVersion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setApiVersion( uint32_t apiVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      apiVersion = apiVersion_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkApplicationInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkApplicationInfo *>( this );
    }

    operator VkApplicationInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkApplicationInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ApplicationInfo const & ) const = default;
#else
    bool operator==( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pApplicationName == rhs.pApplicationName ) &&
             ( applicationVersion == rhs.applicationVersion ) && ( pEngineName == rhs.pEngineName ) &&
             ( engineVersion == rhs.engineVersion ) && ( apiVersion == rhs.apiVersion );
    }

    bool operator!=( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType              = StructureType::eApplicationInfo;
    const void *                        pNext              = {};
    const char *                        pApplicationName   = {};
    uint32_t                            applicationVersion = {};
    const char *                        pEngineName        = {};
    uint32_t                            engineVersion      = {};
    uint32_t                            apiVersion         = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ApplicationInfo ) == sizeof( VkApplicationInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ApplicationInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ApplicationInfo>::value,
                            "ApplicationInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eApplicationInfo>
  {
    using Type = ApplicationInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ApplicationInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::ApplicationInfo const & applicationInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, applicationInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, applicationInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( const char *, seed, applicationInfo.pApplicationName );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, applicationInfo.applicationVersion );
    VULKAN_HPP_HASH_COMBINE( const char *, seed, applicationInfo.pEngineName );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, applicationInfo.engineVersion );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, applicationInfo.apiVersion );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AttachmentDescription
  {
    using NativeType = VkAttachmentDescription;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentDescription(
      VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_         = {},
      VULKAN_HPP_NAMESPACE::Format                     format_        = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples_       = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
      VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp_        = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
      VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp_       = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
      VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp_ = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
      VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_         = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
      VULKAN_HPP_NAMESPACE::ImageLayout       initialLayout_          = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      VULKAN_HPP_NAMESPACE::ImageLayout       finalLayout_            = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined )
      VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , format( format_ )
      , samples( samples_ )
      , loadOp( loadOp_ )
      , storeOp( storeOp_ )
      , stencilLoadOp( stencilLoadOp_ )
      , stencilStoreOp( stencilStoreOp_ )
      , initialLayout( initialLayout_ )
      , finalLayout( finalLayout_ )
    {}

    VULKAN_HPP_CONSTEXPR AttachmentDescription( AttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription( VkAttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescription( *reinterpret_cast<AttachmentDescription const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentDescription & operator=( AttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription & operator=( VkAttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescription const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription &
                            setFlags( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription &
                            setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription &
                            setSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription &
                            setLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp loadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      loadOp = loadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription &
                            setStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp storeOp_ ) VULKAN_HPP_NOEXCEPT
    {
      storeOp = storeOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription &
      setStencilLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp stencilLoadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLoadOp = stencilLoadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription &
      setStencilStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilStoreOp = stencilStoreOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription &
                            setInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription &
                            setFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout finalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      finalLayout = finalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentDescription const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescription *>( this );
    }

    operator VkAttachmentDescription &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescription *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescription const & ) const = default;
#else
    bool operator==( AttachmentDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( flags == rhs.flags ) && ( format == rhs.format ) && ( samples == rhs.samples ) &&
             ( loadOp == rhs.loadOp ) && ( storeOp == rhs.storeOp ) && ( stencilLoadOp == rhs.stencilLoadOp ) &&
             ( stencilStoreOp == rhs.stencilStoreOp ) && ( initialLayout == rhs.initialLayout ) &&
             ( finalLayout == rhs.finalLayout );
    }

    bool operator!=( AttachmentDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags          = {};
    VULKAN_HPP_NAMESPACE::Format                     format         = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentDescription ) == sizeof( VkAttachmentDescription ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentDescription>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentDescription>::value,
                            "AttachmentDescription is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AttachmentDescription>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::AttachmentDescription const & attachmentDescription ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags, seed, attachmentDescription.flags );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Format, seed, attachmentDescription.format );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SampleCountFlagBits, seed, attachmentDescription.samples );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AttachmentLoadOp, seed, attachmentDescription.loadOp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AttachmentStoreOp, seed, attachmentDescription.storeOp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AttachmentLoadOp, seed, attachmentDescription.stencilLoadOp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AttachmentStoreOp, seed, attachmentDescription.stencilStoreOp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, attachmentDescription.initialLayout );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, attachmentDescription.finalLayout );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AttachmentDescription2
  {
    using NativeType = VkAttachmentDescription2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentDescription2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentDescription2(
      VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_         = {},
      VULKAN_HPP_NAMESPACE::Format                     format_        = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples_       = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
      VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp_        = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
      VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp_       = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
      VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp_ = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
      VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_         = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
      VULKAN_HPP_NAMESPACE::ImageLayout       initialLayout_          = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      VULKAN_HPP_NAMESPACE::ImageLayout       finalLayout_            = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined )
      VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , format( format_ )
      , samples( samples_ )
      , loadOp( loadOp_ )
      , storeOp( storeOp_ )
      , stencilLoadOp( stencilLoadOp_ )
      , stencilStoreOp( stencilStoreOp_ )
      , initialLayout( initialLayout_ )
      , finalLayout( finalLayout_ )
    {}

    VULKAN_HPP_CONSTEXPR AttachmentDescription2( AttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription2( VkAttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescription2( *reinterpret_cast<AttachmentDescription2 const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentDescription2 & operator=( AttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription2 & operator=( VkAttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescription2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 &
                            setFlags( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 &
                            setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 &
                            setSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 &
                            setLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp loadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      loadOp = loadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 &
                            setStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp storeOp_ ) VULKAN_HPP_NOEXCEPT
    {
      storeOp = storeOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 &
      setStencilLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp stencilLoadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLoadOp = stencilLoadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 &
      setStencilStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilStoreOp = stencilStoreOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 &
                            setInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 &
                            setFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout finalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      finalLayout = finalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentDescription2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescription2 *>( this );
    }

    operator VkAttachmentDescription2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescription2 *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescription2 const & ) const = default;
#else
    bool operator==( AttachmentDescription2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( format == rhs.format ) &&
             ( samples == rhs.samples ) && ( loadOp == rhs.loadOp ) && ( storeOp == rhs.storeOp ) &&
             ( stencilLoadOp == rhs.stencilLoadOp ) && ( stencilStoreOp == rhs.stencilStoreOp ) &&
             ( initialLayout == rhs.initialLayout ) && ( finalLayout == rhs.finalLayout );
    }

    bool operator!=( AttachmentDescription2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType              sType          = StructureType::eAttachmentDescription2;
    const void *                                     pNext          = {};
    VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags          = {};
    VULKAN_HPP_NAMESPACE::Format                     format         = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentDescription2 ) ==
                              sizeof( VkAttachmentDescription2 ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentDescription2>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentDescription2>::value,
                            "AttachmentDescription2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAttachmentDescription2>
  {
    using Type = AttachmentDescription2;
  };
  using AttachmentDescription2KHR = AttachmentDescription2;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AttachmentDescription2>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::AttachmentDescription2 const & attachmentDescription2 ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, attachmentDescription2.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, attachmentDescription2.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags, seed, attachmentDescription2.flags );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Format, seed, attachmentDescription2.format );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SampleCountFlagBits, seed, attachmentDescription2.samples );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AttachmentLoadOp, seed, attachmentDescription2.loadOp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AttachmentStoreOp, seed, attachmentDescription2.storeOp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AttachmentLoadOp, seed, attachmentDescription2.stencilLoadOp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AttachmentStoreOp, seed, attachmentDescription2.stencilStoreOp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, attachmentDescription2.initialLayout );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, attachmentDescription2.finalLayout );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AttachmentDescriptionStencilLayout
  {
    using NativeType = VkAttachmentDescriptionStencilLayout;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eAttachmentDescriptionStencilLayout;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentDescriptionStencilLayout(
      VULKAN_HPP_NAMESPACE::ImageLayout stencilInitialLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      VULKAN_HPP_NAMESPACE::ImageLayout stencilFinalLayout_   = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined )
      VULKAN_HPP_NOEXCEPT
      : stencilInitialLayout( stencilInitialLayout_ )
      , stencilFinalLayout( stencilFinalLayout_ )
    {}

    VULKAN_HPP_CONSTEXPR AttachmentDescriptionStencilLayout( AttachmentDescriptionStencilLayout const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescriptionStencilLayout( VkAttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescriptionStencilLayout( *reinterpret_cast<AttachmentDescriptionStencilLayout const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentDescriptionStencilLayout &
      operator=( AttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescriptionStencilLayout &
      operator=( VkAttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout &
      setStencilInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilInitialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilInitialLayout = stencilInitialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout &
      setStencilFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilFinalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilFinalLayout = stencilFinalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentDescriptionStencilLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescriptionStencilLayout *>( this );
    }

    operator VkAttachmentDescriptionStencilLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescriptionStencilLayout *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescriptionStencilLayout const & ) const = default;
#else
    bool operator==( AttachmentDescriptionStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stencilInitialLayout == rhs.stencilInitialLayout ) &&
             ( stencilFinalLayout == rhs.stencilFinalLayout );
    }

    bool operator!=( AttachmentDescriptionStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                = StructureType::eAttachmentDescriptionStencilLayout;
    void *                              pNext                = {};
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilInitialLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilFinalLayout   = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout ) ==
                              sizeof( VkAttachmentDescriptionStencilLayout ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout>::value,
    "AttachmentDescriptionStencilLayout is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAttachmentDescriptionStencilLayout>
  {
    using Type = AttachmentDescriptionStencilLayout;
  };
  using AttachmentDescriptionStencilLayoutKHR = AttachmentDescriptionStencilLayout;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout const &
                            attachmentDescriptionStencilLayout ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, attachmentDescriptionStencilLayout.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, attachmentDescriptionStencilLayout.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::ImageLayout, seed, attachmentDescriptionStencilLayout.stencilInitialLayout );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::ImageLayout, seed, attachmentDescriptionStencilLayout.stencilFinalLayout );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AttachmentReference
  {
    using NativeType = VkAttachmentReference;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReference(
      uint32_t                          attachment_ = {},
      VULKAN_HPP_NAMESPACE::ImageLayout layout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : attachment( attachment_ )
      , layout( layout_ )
    {}

    VULKAN_HPP_CONSTEXPR AttachmentReference( AttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference( VkAttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReference( *reinterpret_cast<AttachmentReference const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentReference & operator=( AttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference & operator=( VkAttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReference const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReference & setAttachment( uint32_t attachment_ ) VULKAN_HPP_NOEXCEPT
    {
      attachment = attachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference &
                            setLayout( VULKAN_HPP_NAMESPACE::ImageLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentReference const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReference *>( this );
    }

    operator VkAttachmentReference &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReference *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReference const & ) const = default;
#else
    bool operator==( AttachmentReference const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( attachment == rhs.attachment ) && ( layout == rhs.layout );
    }

    bool operator!=( AttachmentReference const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                          attachment = {};
    VULKAN_HPP_NAMESPACE::ImageLayout layout     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentReference ) == sizeof( VkAttachmentReference ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentReference>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentReference>::value,
                            "AttachmentReference is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AttachmentReference>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::AttachmentReference const & attachmentReference ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, attachmentReference.attachment );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, attachmentReference.layout );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AttachmentReference2
  {
    using NativeType = VkAttachmentReference2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentReference2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentReference2( uint32_t                          attachment_ = {},
                            VULKAN_HPP_NAMESPACE::ImageLayout layout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                            VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ = {} ) VULKAN_HPP_NOEXCEPT
      : attachment( attachment_ )
      , layout( layout_ )
      , aspectMask( aspectMask_ )
    {}

    VULKAN_HPP_CONSTEXPR AttachmentReference2( AttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference2( VkAttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReference2( *reinterpret_cast<AttachmentReference2 const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentReference2 & operator=( AttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference2 & operator=( VkAttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReference2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setAttachment( uint32_t attachment_ ) VULKAN_HPP_NOEXCEPT
    {
      attachment = attachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 &
                            setLayout( VULKAN_HPP_NAMESPACE::ImageLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 &
                            setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentReference2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReference2 *>( this );
    }

    operator VkAttachmentReference2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReference2 *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReference2 const & ) const = default;
#else
    bool operator==( AttachmentReference2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( attachment == rhs.attachment ) &&
             ( layout == rhs.layout ) && ( aspectMask == rhs.aspectMask );
    }

    bool operator!=( AttachmentReference2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType      = StructureType::eAttachmentReference2;
    const void *                           pNext      = {};
    uint32_t                               attachment = {};
    VULKAN_HPP_NAMESPACE::ImageLayout      layout     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentReference2 ) == sizeof( VkAttachmentReference2 ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentReference2>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentReference2>::value,
                            "AttachmentReference2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAttachmentReference2>
  {
    using Type = AttachmentReference2;
  };
  using AttachmentReference2KHR = AttachmentReference2;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AttachmentReference2>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::AttachmentReference2 const & attachmentReference2 ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, attachmentReference2.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, attachmentReference2.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, attachmentReference2.attachment );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, attachmentReference2.layout );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageAspectFlags, seed, attachmentReference2.aspectMask );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AttachmentReferenceStencilLayout
  {
    using NativeType = VkAttachmentReferenceStencilLayout;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType = StructureType::eAttachmentReferenceStencilLayout;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentReferenceStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilLayout_ =
                                          VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : stencilLayout( stencilLayout_ )
    {}

    VULKAN_HPP_CONSTEXPR
      AttachmentReferenceStencilLayout( AttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReferenceStencilLayout( VkAttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReferenceStencilLayout( *reinterpret_cast<AttachmentReferenceStencilLayout const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentReferenceStencilLayout &
      operator=( AttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReferenceStencilLayout & operator=( VkAttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReferenceStencilLayout & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReferenceStencilLayout &
                            setStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLayout = stencilLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentReferenceStencilLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReferenceStencilLayout *>( this );
    }

    operator VkAttachmentReferenceStencilLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReferenceStencilLayout *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReferenceStencilLayout const & ) const = default;
#else
    bool operator==( AttachmentReferenceStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stencilLayout == rhs.stencilLayout );
    }

    bool operator!=( AttachmentReferenceStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eAttachmentReferenceStencilLayout;
    void *                              pNext         = {};
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout ) ==
                              sizeof( VkAttachmentReferenceStencilLayout ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout>::value,
    "AttachmentReferenceStencilLayout is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAttachmentReferenceStencilLayout>
  {
    using Type = AttachmentReferenceStencilLayout;
  };
  using AttachmentReferenceStencilLayoutKHR = AttachmentReferenceStencilLayout;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout const & attachmentReferenceStencilLayout ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, attachmentReferenceStencilLayout.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, attachmentReferenceStencilLayout.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, attachmentReferenceStencilLayout.stencilLayout );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AttachmentSampleCountInfoAMD
  {
    using NativeType = VkAttachmentSampleCountInfoAMD;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentSampleCountInfoAMD;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentSampleCountInfoAMD( uint32_t                                          colorAttachmentCount_    = {},
                                    const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * pColorAttachmentSamples_ = {},
                                    VULKAN_HPP_NAMESPACE::SampleCountFlagBits         depthStencilAttachmentSamples_ =
                                      VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1 ) VULKAN_HPP_NOEXCEPT
      : colorAttachmentCount( colorAttachmentCount_ )
      , pColorAttachmentSamples( pColorAttachmentSamples_ )
      , depthStencilAttachmentSamples( depthStencilAttachmentSamples_ )
    {}

    VULKAN_HPP_CONSTEXPR
      AttachmentSampleCountInfoAMD( AttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleCountInfoAMD( VkAttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentSampleCountInfoAMD( *reinterpret_cast<AttachmentSampleCountInfoAMD const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AttachmentSampleCountInfoAMD( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<
                                    const VULKAN_HPP_NAMESPACE::SampleCountFlagBits> const & colorAttachmentSamples_,
                                  VULKAN_HPP_NAMESPACE::SampleCountFlagBits depthStencilAttachmentSamples_ =
                                    VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1 )
      : colorAttachmentCount( static_cast<uint32_t>( colorAttachmentSamples_.size() ) )
      , pColorAttachmentSamples( colorAttachmentSamples_.data() )
      , depthStencilAttachmentSamples( depthStencilAttachmentSamples_ )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentSampleCountInfoAMD & operator=( AttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleCountInfoAMD & operator=( VkAttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD &
                            setColorAttachmentCount( uint32_t colorAttachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount = colorAttachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD & setPColorAttachmentSamples(
      const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * pColorAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      pColorAttachmentSamples = pColorAttachmentSamples_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AttachmentSampleCountInfoAMD & setColorAttachmentSamples(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleCountFlagBits> const &
        colorAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount    = static_cast<uint32_t>( colorAttachmentSamples_.size() );
      pColorAttachmentSamples = colorAttachmentSamples_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD & setDepthStencilAttachmentSamples(
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits depthStencilAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      depthStencilAttachmentSamples = depthStencilAttachmentSamples_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentSampleCountInfoAMD const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentSampleCountInfoAMD *>( this );
    }

    operator VkAttachmentSampleCountInfoAMD &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentSampleCountInfoAMD *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentSampleCountInfoAMD const & ) const = default;
#else
    bool operator==( AttachmentSampleCountInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( colorAttachmentCount == rhs.colorAttachmentCount ) &&
             ( pColorAttachmentSamples == rhs.pColorAttachmentSamples ) &&
             ( depthStencilAttachmentSamples == rhs.depthStencilAttachmentSamples );
    }

    bool operator!=( AttachmentSampleCountInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType = StructureType::eAttachmentSampleCountInfoAMD;
    const void *                                      pNext = {};
    uint32_t                                          colorAttachmentCount    = {};
    const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * pColorAttachmentSamples = {};
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits         depthStencilAttachmentSamples =
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD ) ==
                              sizeof( VkAttachmentSampleCountInfoAMD ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD>::value,
    "AttachmentSampleCountInfoAMD is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAttachmentSampleCountInfoAMD>
  {
    using Type = AttachmentSampleCountInfoAMD;
  };
  using AttachmentSampleCountInfoNV = AttachmentSampleCountInfoAMD;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD>
{
  std::size_t operator()(
    VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD const & attachmentSampleCountInfoAMD ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, attachmentSampleCountInfoAMD.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, attachmentSampleCountInfoAMD.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, attachmentSampleCountInfoAMD.colorAttachmentCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::SampleCountFlagBits *, seed, attachmentSampleCountInfoAMD.pColorAttachmentSamples );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits, seed, attachmentSampleCountInfoAMD.depthStencilAttachmentSamples );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct Extent2D
  {
    using NativeType = VkExtent2D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Extent2D( uint32_t width_ = {}, uint32_t height_ = {} ) VULKAN_HPP_NOEXCEPT
      : width( width_ )
      , height( height_ )
    {}

    VULKAN_HPP_CONSTEXPR Extent2D( Extent2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent2D( VkExtent2D const & rhs ) VULKAN_HPP_NOEXCEPT : Extent2D( *reinterpret_cast<Extent2D const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Extent2D & operator=( Extent2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent2D & operator=( VkExtent2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Extent2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Extent2D & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent2D & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExtent2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtent2D *>( this );
    }

    operator VkExtent2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtent2D *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Extent2D const & ) const = default;
#else
    bool operator==( Extent2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( width == rhs.width ) && ( height == rhs.height );
    }

    bool operator!=( Extent2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t width  = {};
    uint32_t height = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Extent2D ) == sizeof( VkExtent2D ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Extent2D>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Extent2D>::value,
                            "Extent2D is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::Extent2D>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::Extent2D const & extent2D ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, extent2D.width );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, extent2D.height );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct SampleLocationEXT
  {
    using NativeType = VkSampleLocationEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SampleLocationEXT( float x_ = {}, float y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x( x_ )
      , y( y_ )
    {}

    VULKAN_HPP_CONSTEXPR SampleLocationEXT( SampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationEXT( VkSampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : SampleLocationEXT( *reinterpret_cast<SampleLocationEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SampleLocationEXT & operator=( SampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationEXT & operator=( VkSampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SampleLocationEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SampleLocationEXT & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationEXT & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSampleLocationEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSampleLocationEXT *>( this );
    }

    operator VkSampleLocationEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSampleLocationEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SampleLocationEXT const & ) const = default;
#else
    bool operator==( SampleLocationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( x == rhs.x ) && ( y == rhs.y );
    }

    bool operator!=( SampleLocationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x = {};
    float y = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SampleLocationEXT ) == sizeof( VkSampleLocationEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SampleLocationEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SampleLocationEXT>::value,
                            "SampleLocationEXT is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SampleLocationEXT>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::SampleLocationEXT const & sampleLocationEXT ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( float, seed, sampleLocationEXT.x );
    VULKAN_HPP_HASH_COMBINE( float, seed, sampleLocationEXT.y );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct SampleLocationsInfoEXT
  {
    using NativeType = VkSampleLocationsInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eSampleLocationsInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SampleLocationsInfoEXT(
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits sampleLocationsPerPixel_ =
        VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
      VULKAN_HPP_NAMESPACE::Extent2D                  sampleLocationGridSize_ = {},
      uint32_t                                        sampleLocationsCount_   = {},
      const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations_       = {} ) VULKAN_HPP_NOEXCEPT
      : sampleLocationsPerPixel( sampleLocationsPerPixel_ )
      , sampleLocationGridSize( sampleLocationGridSize_ )
      , sampleLocationsCount( sampleLocationsCount_ )
      , pSampleLocations( pSampleLocations_ )
    {}

    VULKAN_HPP_CONSTEXPR SampleLocationsInfoEXT( SampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationsInfoEXT( VkSampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : SampleLocationsInfoEXT( *reinterpret_cast<SampleLocationsInfoEXT const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SampleLocationsInfoEXT(
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits sampleLocationsPerPixel_,
      VULKAN_HPP_NAMESPACE::Extent2D            sampleLocationGridSize_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleLocationEXT> const &
        sampleLocations_ )
      : sampleLocationsPerPixel( sampleLocationsPerPixel_ )
      , sampleLocationGridSize( sampleLocationGridSize_ )
      , sampleLocationsCount( static_cast<uint32_t>( sampleLocations_.size() ) )
      , pSampleLocations( sampleLocations_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SampleLocationsInfoEXT & operator=( SampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationsInfoEXT & operator=( VkSampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setSampleLocationsPerPixel(
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits sampleLocationsPerPixel_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsPerPixel = sampleLocationsPerPixel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
      setSampleLocationGridSize( VULKAN_HPP_NAMESPACE::Extent2D const & sampleLocationGridSize_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationGridSize = sampleLocationGridSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
                            setSampleLocationsCount( uint32_t sampleLocationsCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsCount = sampleLocationsCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
      setPSampleLocations( const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      pSampleLocations = pSampleLocations_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SampleLocationsInfoEXT & setSampleLocations(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleLocationEXT> const &
        sampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsCount = static_cast<uint32_t>( sampleLocations_.size() );
      pSampleLocations     = sampleLocations_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSampleLocationsInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSampleLocationsInfoEXT *>( this );
    }

    operator VkSampleLocationsInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSampleLocationsInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SampleLocationsInfoEXT const & ) const = default;
#else
    bool operator==( SampleLocationsInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( sampleLocationsPerPixel == rhs.sampleLocationsPerPixel ) &&
             ( sampleLocationGridSize == rhs.sampleLocationGridSize ) &&
             ( sampleLocationsCount == rhs.sampleLocationsCount ) && ( pSampleLocations == rhs.pSampleLocations );
    }

    bool operator!=( SampleLocationsInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType                   = StructureType::eSampleLocationsInfoEXT;
    const void *                              pNext                   = {};
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits sampleLocationsPerPixel = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::Extent2D            sampleLocationGridSize  = {};
    uint32_t                                  sampleLocationsCount    = {};
    const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT ) ==
                              sizeof( VkSampleLocationsInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT>::value,
                            "SampleLocationsInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eSampleLocationsInfoEXT>
  {
    using Type = SampleLocationsInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const & sampleLocationsInfoEXT ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, sampleLocationsInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, sampleLocationsInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits, seed, sampleLocationsInfoEXT.sampleLocationsPerPixel );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Extent2D, seed, sampleLocationsInfoEXT.sampleLocationGridSize );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, sampleLocationsInfoEXT.sampleLocationsCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::SampleLocationEXT *, seed, sampleLocationsInfoEXT.pSampleLocations );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct AttachmentSampleLocationsEXT
  {
    using NativeType = VkAttachmentSampleLocationsEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentSampleLocationsEXT(
      uint32_t                                     attachmentIndex_     = {},
      VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT sampleLocationsInfo_ = {} ) VULKAN_HPP_NOEXCEPT
      : attachmentIndex( attachmentIndex_ )
      , sampleLocationsInfo( sampleLocationsInfo_ )
    {}

    VULKAN_HPP_CONSTEXPR
      AttachmentSampleLocationsEXT( AttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleLocationsEXT( VkAttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentSampleLocationsEXT( *reinterpret_cast<AttachmentSampleLocationsEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentSampleLocationsEXT & operator=( AttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleLocationsEXT & operator=( VkAttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleLocationsEXT &
                            setAttachmentIndex( uint32_t attachmentIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentIndex = attachmentIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleLocationsEXT & setSampleLocationsInfo(
      VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const & sampleLocationsInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsInfo = sampleLocationsInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkAttachmentSampleLocationsEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentSampleLocationsEXT *>( this );
    }

    operator VkAttachmentSampleLocationsEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentSampleLocationsEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentSampleLocationsEXT const & ) const = default;
#else
    bool operator==( AttachmentSampleLocationsEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( attachmentIndex == rhs.attachmentIndex ) && ( sampleLocationsInfo == rhs.sampleLocationsInfo );
    }

    bool operator!=( AttachmentSampleLocationsEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                     attachmentIndex     = {};
    VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT sampleLocationsInfo = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT ) ==
                              sizeof( VkAttachmentSampleLocationsEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT>::value,
    "AttachmentSampleLocationsEXT is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT>
{
  std::size_t operator()(
    VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT const & attachmentSampleLocationsEXT ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, attachmentSampleLocationsEXT.attachmentIndex );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT, seed, attachmentSampleLocationsEXT.sampleLocationsInfo );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BaseInStructure
  {
    using NativeType = VkBaseInStructure;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    BaseInStructure( VULKAN_HPP_NAMESPACE::StructureType sType_ =
                       VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo ) VULKAN_HPP_NOEXCEPT : sType( sType_ )
    {}

    BaseInStructure( BaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseInStructure( VkBaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT
      : BaseInStructure( *reinterpret_cast<BaseInStructure const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BaseInStructure & operator=( BaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseInStructure & operator=( VkBaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BaseInStructure const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BaseInStructure &
                            setPNext( const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBaseInStructure const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBaseInStructure *>( this );
    }

    operator VkBaseInStructure &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBaseInStructure *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BaseInStructure const & ) const = default;
#else
    bool operator==( BaseInStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext );
    }

    bool operator!=( BaseInStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo;
    const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BaseInStructure ) == sizeof( VkBaseInStructure ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BaseInStructure>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BaseInStructure>::value,
                            "BaseInStructure is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BaseInStructure>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BaseInStructure const & baseInStructure ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, baseInStructure.sType );
    VULKAN_HPP_HASH_COMBINE( const struct VULKAN_HPP_NAMESPACE::BaseInStructure *, seed, baseInStructure.pNext );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BaseOutStructure
  {
    using NativeType = VkBaseOutStructure;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    BaseOutStructure( VULKAN_HPP_NAMESPACE::StructureType sType_ =
                        VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo ) VULKAN_HPP_NOEXCEPT : sType( sType_ )
    {}

    BaseOutStructure( BaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseOutStructure( VkBaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT
      : BaseOutStructure( *reinterpret_cast<BaseOutStructure const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BaseOutStructure & operator=( BaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseOutStructure & operator=( VkBaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BaseOutStructure const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BaseOutStructure &
                            setPNext( struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBaseOutStructure const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBaseOutStructure *>( this );
    }

    operator VkBaseOutStructure &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBaseOutStructure *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BaseOutStructure const & ) const = default;
#else
    bool operator==( BaseOutStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext );
    }

    bool operator!=( BaseOutStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo;
    struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BaseOutStructure ) == sizeof( VkBaseOutStructure ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BaseOutStructure>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BaseOutStructure>::value,
                            "BaseOutStructure is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BaseOutStructure>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BaseOutStructure const & baseOutStructure ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, baseOutStructure.sType );
    VULKAN_HPP_HASH_COMBINE( struct VULKAN_HPP_NAMESPACE::BaseOutStructure *, seed, baseOutStructure.pNext );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindAccelerationStructureMemoryInfoNV
  {
    using NativeType = VkBindAccelerationStructureMemoryInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eBindAccelerationStructureMemoryInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindAccelerationStructureMemoryInfoNV( VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure_ = {},
                                             VULKAN_HPP_NAMESPACE::DeviceMemory            memory_                = {},
                                             VULKAN_HPP_NAMESPACE::DeviceSize              memoryOffset_          = {},
                                             uint32_t                                      deviceIndexCount_      = {},
                                             const uint32_t * pDeviceIndices_ = {} ) VULKAN_HPP_NOEXCEPT
      : accelerationStructure( accelerationStructure_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
      , deviceIndexCount( deviceIndexCount_ )
      , pDeviceIndices( pDeviceIndices_ )
    {}

    VULKAN_HPP_CONSTEXPR BindAccelerationStructureMemoryInfoNV( BindAccelerationStructureMemoryInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    BindAccelerationStructureMemoryInfoNV( VkBindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindAccelerationStructureMemoryInfoNV(
          *reinterpret_cast<BindAccelerationStructureMemoryInfoNV const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindAccelerationStructureMemoryInfoNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureNV                         accelerationStructure_,
      VULKAN_HPP_NAMESPACE::DeviceMemory                                    memory_,
      VULKAN_HPP_NAMESPACE::DeviceSize                                      memoryOffset_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ )
      : accelerationStructure( accelerationStructure_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
      , deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) )
      , pDeviceIndices( deviceIndices_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindAccelerationStructureMemoryInfoNV &
      operator=( BindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindAccelerationStructureMemoryInfoNV &
      operator=( VkBindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setAccelerationStructure(
      VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV &
                            setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV &
                            setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV &
                            setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV &
                            setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindAccelerationStructureMemoryInfoNV & setDeviceIndices(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindAccelerationStructureMemoryInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindAccelerationStructureMemoryInfoNV *>( this );
    }

    operator VkBindAccelerationStructureMemoryInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindAccelerationStructureMemoryInfoNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindAccelerationStructureMemoryInfoNV const & ) const = default;
#else
    bool operator==( BindAccelerationStructureMemoryInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( accelerationStructure == rhs.accelerationStructure ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset ) && ( deviceIndexCount == rhs.deviceIndexCount ) &&
             ( pDeviceIndices == rhs.pDeviceIndices );
    }

    bool operator!=( BindAccelerationStructureMemoryInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType           sType = StructureType::eBindAccelerationStructureMemoryInfoNV;
    const void *                                  pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory            memory                = {};
    VULKAN_HPP_NAMESPACE::DeviceSize              memoryOffset          = {};
    uint32_t                                      deviceIndexCount      = {};
    const uint32_t *                              pDeviceIndices        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV ) ==
                              sizeof( VkBindAccelerationStructureMemoryInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV>::value,
    "BindAccelerationStructureMemoryInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindAccelerationStructureMemoryInfoNV>
  {
    using Type = BindAccelerationStructureMemoryInfoNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV const &
                            bindAccelerationStructureMemoryInfoNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bindAccelerationStructureMemoryInfoNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bindAccelerationStructureMemoryInfoNV.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccelerationStructureNV,
                             seed,
                             bindAccelerationStructureMemoryInfoNV.accelerationStructure );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceMemory, seed, bindAccelerationStructureMemoryInfoNV.memory );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DeviceSize, seed, bindAccelerationStructureMemoryInfoNV.memoryOffset );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindAccelerationStructureMemoryInfoNV.deviceIndexCount );
    VULKAN_HPP_HASH_COMBINE( const uint32_t *, seed, bindAccelerationStructureMemoryInfoNV.pDeviceIndices );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindBufferMemoryDeviceGroupInfo
  {
    using NativeType = VkBindBufferMemoryDeviceGroupInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindBufferMemoryDeviceGroupInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindBufferMemoryDeviceGroupInfo( uint32_t         deviceIndexCount_ = {},
                                                          const uint32_t * pDeviceIndices_   = {} ) VULKAN_HPP_NOEXCEPT
      : deviceIndexCount( deviceIndexCount_ )
      , pDeviceIndices( pDeviceIndices_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BindBufferMemoryDeviceGroupInfo( BindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryDeviceGroupInfo( VkBindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindBufferMemoryDeviceGroupInfo( *reinterpret_cast<BindBufferMemoryDeviceGroupInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindBufferMemoryDeviceGroupInfo(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ )
      : deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) ), pDeviceIndices( deviceIndices_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindBufferMemoryDeviceGroupInfo &
      operator=( BindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryDeviceGroupInfo & operator=( VkBindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo &
                            setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo &
                            setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindBufferMemoryDeviceGroupInfo & setDeviceIndices(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindBufferMemoryDeviceGroupInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindBufferMemoryDeviceGroupInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindBufferMemoryDeviceGroupInfo const & ) const = default;
#else
    bool operator==( BindBufferMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceIndexCount == rhs.deviceIndexCount ) &&
             ( pDeviceIndices == rhs.pDeviceIndices );
    }

    bool operator!=( BindBufferMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType            = StructureType::eBindBufferMemoryDeviceGroupInfo;
    const void *                        pNext            = {};
    uint32_t                            deviceIndexCount = {};
    const uint32_t *                    pDeviceIndices   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo ) ==
                              sizeof( VkBindBufferMemoryDeviceGroupInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo>::value,
    "BindBufferMemoryDeviceGroupInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindBufferMemoryDeviceGroupInfo>
  {
    using Type = BindBufferMemoryDeviceGroupInfo;
  };
  using BindBufferMemoryDeviceGroupInfoKHR = BindBufferMemoryDeviceGroupInfo;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo const & bindBufferMemoryDeviceGroupInfo ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bindBufferMemoryDeviceGroupInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bindBufferMemoryDeviceGroupInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindBufferMemoryDeviceGroupInfo.deviceIndexCount );
    VULKAN_HPP_HASH_COMBINE( const uint32_t *, seed, bindBufferMemoryDeviceGroupInfo.pDeviceIndices );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindBufferMemoryInfo
  {
    using NativeType = VkBindBufferMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindBufferMemoryInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindBufferMemoryInfo( VULKAN_HPP_NAMESPACE::Buffer       buffer_     = {},
                                               VULKAN_HPP_NAMESPACE::DeviceMemory memory_     = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ = {} ) VULKAN_HPP_NOEXCEPT
      : buffer( buffer_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
    {}

    VULKAN_HPP_CONSTEXPR BindBufferMemoryInfo( BindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryInfo( VkBindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindBufferMemoryInfo( *reinterpret_cast<BindBufferMemoryInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindBufferMemoryInfo & operator=( BindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryInfo & operator=( VkBindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo &
                            setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo &
                            setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindBufferMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindBufferMemoryInfo *>( this );
    }

    operator VkBindBufferMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindBufferMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindBufferMemoryInfo const & ) const = default;
#else
    bool operator==( BindBufferMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset );
    }

    bool operator!=( BindBufferMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eBindBufferMemoryInfo;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer       = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory  memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    memoryOffset = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo ) == sizeof( VkBindBufferMemoryInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo>::value,
                            "BindBufferMemoryInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindBufferMemoryInfo>
  {
    using Type = BindBufferMemoryInfo;
  };
  using BindBufferMemoryInfoKHR = BindBufferMemoryInfo;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo const & bindBufferMemoryInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bindBufferMemoryInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bindBufferMemoryInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, bindBufferMemoryInfo.buffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceMemory, seed, bindBufferMemoryInfo.memory );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bindBufferMemoryInfo.memoryOffset );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct Offset2D
  {
    using NativeType = VkOffset2D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Offset2D( int32_t x_ = {}, int32_t y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x( x_ )
      , y( y_ )
    {}

    VULKAN_HPP_CONSTEXPR Offset2D( Offset2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset2D( VkOffset2D const & rhs ) VULKAN_HPP_NOEXCEPT : Offset2D( *reinterpret_cast<Offset2D const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Offset2D & operator=( Offset2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset2D & operator=( VkOffset2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Offset2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Offset2D & setX( int32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset2D & setY( int32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkOffset2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkOffset2D *>( this );
    }

    operator VkOffset2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkOffset2D *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Offset2D const & ) const = default;
#else
    bool operator==( Offset2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( x == rhs.x ) && ( y == rhs.y );
    }

    bool operator!=( Offset2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    int32_t x = {};
    int32_t y = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Offset2D ) == sizeof( VkOffset2D ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Offset2D>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Offset2D>::value,
                            "Offset2D is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::Offset2D>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::Offset2D const & offset2D ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( int32_t, seed, offset2D.x );
    VULKAN_HPP_HASH_COMBINE( int32_t, seed, offset2D.y );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct Rect2D
  {
    using NativeType = VkRect2D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Rect2D( VULKAN_HPP_NAMESPACE::Offset2D offset_ = {},
                                 VULKAN_HPP_NAMESPACE::Extent2D extent_ = {} ) VULKAN_HPP_NOEXCEPT
      : offset( offset_ )
      , extent( extent_ )
    {}

    VULKAN_HPP_CONSTEXPR Rect2D( Rect2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Rect2D( VkRect2D const & rhs ) VULKAN_HPP_NOEXCEPT : Rect2D( *reinterpret_cast<Rect2D const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Rect2D & operator=( Rect2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Rect2D & operator=( VkRect2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Rect2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Rect2D & setOffset( VULKAN_HPP_NAMESPACE::Offset2D const & offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Rect2D & setExtent( VULKAN_HPP_NAMESPACE::Extent2D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkRect2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkRect2D *>( this );
    }

    operator VkRect2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkRect2D *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Rect2D const & ) const = default;
#else
    bool operator==( Rect2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( offset == rhs.offset ) && ( extent == rhs.extent );
    }

    bool operator!=( Rect2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Offset2D offset = {};
    VULKAN_HPP_NAMESPACE::Extent2D extent = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Rect2D ) == sizeof( VkRect2D ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Rect2D>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Rect2D>::value,
                            "Rect2D is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::Rect2D>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::Rect2D const & rect2D ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Offset2D, seed, rect2D.offset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Extent2D, seed, rect2D.extent );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindImageMemoryDeviceGroupInfo
  {
    using NativeType = VkBindImageMemoryDeviceGroupInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemoryDeviceGroupInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemoryDeviceGroupInfo(
      uint32_t                             deviceIndexCount_             = {},
      const uint32_t *                     pDeviceIndices_               = {},
      uint32_t                             splitInstanceBindRegionCount_ = {},
      const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions_    = {} ) VULKAN_HPP_NOEXCEPT
      : deviceIndexCount( deviceIndexCount_ )
      , pDeviceIndices( pDeviceIndices_ )
      , splitInstanceBindRegionCount( splitInstanceBindRegionCount_ )
      , pSplitInstanceBindRegions( pSplitInstanceBindRegions_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BindImageMemoryDeviceGroupInfo( BindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryDeviceGroupInfo( VkBindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemoryDeviceGroupInfo( *reinterpret_cast<BindImageMemoryDeviceGroupInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const &
        splitInstanceBindRegions_ = {} )
      : deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) )
      , pDeviceIndices( deviceIndices_.data() )
      , splitInstanceBindRegionCount( static_cast<uint32_t>( splitInstanceBindRegions_.size() ) )
      , pSplitInstanceBindRegions( splitInstanceBindRegions_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImageMemoryDeviceGroupInfo &
      operator=( BindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryDeviceGroupInfo & operator=( VkBindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo &
                            setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo &
                            setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo & setDeviceIndices(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo &
      setSplitInstanceBindRegionCount( uint32_t splitInstanceBindRegionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      splitInstanceBindRegionCount = splitInstanceBindRegionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPSplitInstanceBindRegions(
      const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pSplitInstanceBindRegions = pSplitInstanceBindRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo & setSplitInstanceBindRegions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const &
        splitInstanceBindRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      splitInstanceBindRegionCount = static_cast<uint32_t>( splitInstanceBindRegions_.size() );
      pSplitInstanceBindRegions    = splitInstanceBindRegions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindImageMemoryDeviceGroupInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindImageMemoryDeviceGroupInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemoryDeviceGroupInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemoryDeviceGroupInfo const & ) const = default;
#else
    bool operator==( BindImageMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceIndexCount == rhs.deviceIndexCount ) &&
             ( pDeviceIndices == rhs.pDeviceIndices ) &&
             ( splitInstanceBindRegionCount == rhs.splitInstanceBindRegionCount ) &&
             ( pSplitInstanceBindRegions == rhs.pSplitInstanceBindRegions );
    }

    bool operator!=( BindImageMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType  sType                        = StructureType::eBindImageMemoryDeviceGroupInfo;
    const void *                         pNext                        = {};
    uint32_t                             deviceIndexCount             = {};
    const uint32_t *                     pDeviceIndices               = {};
    uint32_t                             splitInstanceBindRegionCount = {};
    const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo ) ==
                              sizeof( VkBindImageMemoryDeviceGroupInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo>::value,
    "BindImageMemoryDeviceGroupInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemoryDeviceGroupInfo>
  {
    using Type = BindImageMemoryDeviceGroupInfo;
  };
  using BindImageMemoryDeviceGroupInfoKHR = BindImageMemoryDeviceGroupInfo;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo const & bindImageMemoryDeviceGroupInfo )
    const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bindImageMemoryDeviceGroupInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bindImageMemoryDeviceGroupInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindImageMemoryDeviceGroupInfo.deviceIndexCount );
    VULKAN_HPP_HASH_COMBINE( const uint32_t *, seed, bindImageMemoryDeviceGroupInfo.pDeviceIndices );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindImageMemoryDeviceGroupInfo.splitInstanceBindRegionCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::Rect2D *, seed, bindImageMemoryDeviceGroupInfo.pSplitInstanceBindRegions );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindImageMemoryInfo
  {
    using NativeType = VkBindImageMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemoryInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemoryInfo( VULKAN_HPP_NAMESPACE::Image        image_      = {},
                                              VULKAN_HPP_NAMESPACE::DeviceMemory memory_     = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ = {} ) VULKAN_HPP_NOEXCEPT
      : image( image_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
    {}

    VULKAN_HPP_CONSTEXPR BindImageMemoryInfo( BindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryInfo( VkBindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemoryInfo( *reinterpret_cast<BindImageMemoryInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImageMemoryInfo & operator=( BindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryInfo & operator=( VkBindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo &
                            setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo &
                            setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindImageMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemoryInfo *>( this );
    }

    operator VkBindImageMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemoryInfo const & ) const = default;
#else
    bool operator==( BindImageMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( image == rhs.image ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset );
    }

    bool operator!=( BindImageMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eBindImageMemoryInfo;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::Image         image        = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory  memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    memoryOffset = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindImageMemoryInfo ) == sizeof( VkBindImageMemoryInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindImageMemoryInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindImageMemoryInfo>::value,
                            "BindImageMemoryInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemoryInfo>
  {
    using Type = BindImageMemoryInfo;
  };
  using BindImageMemoryInfoKHR = BindImageMemoryInfo;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindImageMemoryInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::BindImageMemoryInfo const & bindImageMemoryInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bindImageMemoryInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bindImageMemoryInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, bindImageMemoryInfo.image );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceMemory, seed, bindImageMemoryInfo.memory );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bindImageMemoryInfo.memoryOffset );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindImageMemorySwapchainInfoKHR
  {
    using NativeType = VkBindImageMemorySwapchainInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemorySwapchainInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemorySwapchainInfoKHR( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_ = {},
                                                          uint32_t imageIndex_ = {} ) VULKAN_HPP_NOEXCEPT
      : swapchain( swapchain_ )
      , imageIndex( imageIndex_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BindImageMemorySwapchainInfoKHR( BindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemorySwapchainInfoKHR( VkBindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemorySwapchainInfoKHR( *reinterpret_cast<BindImageMemorySwapchainInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImageMemorySwapchainInfoKHR &
      operator=( BindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemorySwapchainInfoKHR & operator=( VkBindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR &
                            setSwapchain( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchain = swapchain_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setImageIndex( uint32_t imageIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      imageIndex = imageIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindImageMemorySwapchainInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemorySwapchainInfoKHR *>( this );
    }

    operator VkBindImageMemorySwapchainInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemorySwapchainInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemorySwapchainInfoKHR const & ) const = default;
#else
    bool operator==( BindImageMemorySwapchainInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchain == rhs.swapchain ) &&
             ( imageIndex == rhs.imageIndex );
    }

    bool operator!=( BindImageMemorySwapchainInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eBindImageMemorySwapchainInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::SwapchainKHR  swapchain  = {};
    uint32_t                            imageIndex = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR ) ==
                              sizeof( VkBindImageMemorySwapchainInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR>::value,
    "BindImageMemorySwapchainInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemorySwapchainInfoKHR>
  {
    using Type = BindImageMemorySwapchainInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR const & bindImageMemorySwapchainInfoKHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bindImageMemorySwapchainInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bindImageMemorySwapchainInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SwapchainKHR, seed, bindImageMemorySwapchainInfoKHR.swapchain );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindImageMemorySwapchainInfoKHR.imageIndex );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindImagePlaneMemoryInfo
  {
    using NativeType = VkBindImagePlaneMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImagePlaneMemoryInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindImagePlaneMemoryInfo( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ =
                                  VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor ) VULKAN_HPP_NOEXCEPT
      : planeAspect( planeAspect_ )
    {}

    VULKAN_HPP_CONSTEXPR BindImagePlaneMemoryInfo( BindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImagePlaneMemoryInfo( VkBindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImagePlaneMemoryInfo( *reinterpret_cast<BindImagePlaneMemoryInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImagePlaneMemoryInfo & operator=( BindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImagePlaneMemoryInfo & operator=( VkBindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImagePlaneMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImagePlaneMemoryInfo &
                            setPlaneAspect( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ ) VULKAN_HPP_NOEXCEPT
    {
      planeAspect = planeAspect_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindImagePlaneMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImagePlaneMemoryInfo *>( this );
    }

    operator VkBindImagePlaneMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImagePlaneMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImagePlaneMemoryInfo const & ) const = default;
#else
    bool operator==( BindImagePlaneMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( planeAspect == rhs.planeAspect );
    }

    bool operator!=( BindImagePlaneMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType       = StructureType::eBindImagePlaneMemoryInfo;
    const void *                              pNext       = {};
    VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo ) ==
                              sizeof( VkBindImagePlaneMemoryInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo>::value,
                            "BindImagePlaneMemoryInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindImagePlaneMemoryInfo>
  {
    using Type = BindImagePlaneMemoryInfo;
  };
  using BindImagePlaneMemoryInfoKHR = BindImagePlaneMemoryInfo;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo const & bindImagePlaneMemoryInfo ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bindImagePlaneMemoryInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bindImagePlaneMemoryInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits, seed, bindImagePlaneMemoryInfo.planeAspect );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindIndexBufferIndirectCommandNV
  {
    using NativeType = VkBindIndexBufferIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindIndexBufferIndirectCommandNV(
      VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ = {},
      uint32_t                            size_          = {},
      VULKAN_HPP_NAMESPACE::IndexType     indexType_ = VULKAN_HPP_NAMESPACE::IndexType::eUint16 ) VULKAN_HPP_NOEXCEPT
      : bufferAddress( bufferAddress_ )
      , size( size_ )
      , indexType( indexType_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BindIndexBufferIndirectCommandNV( BindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindIndexBufferIndirectCommandNV( VkBindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindIndexBufferIndirectCommandNV( *reinterpret_cast<BindIndexBufferIndirectCommandNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindIndexBufferIndirectCommandNV &
      operator=( BindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindIndexBufferIndirectCommandNV & operator=( VkBindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV &
                            setBufferAddress( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV &
                            setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindIndexBufferIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindIndexBufferIndirectCommandNV *>( this );
    }

    operator VkBindIndexBufferIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindIndexBufferIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindIndexBufferIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindIndexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( indexType == rhs.indexType );
    }

    bool operator!=( BindIndexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress = {};
    uint32_t                            size          = {};
    VULKAN_HPP_NAMESPACE::IndexType     indexType     = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV ) ==
                              sizeof( VkBindIndexBufferIndirectCommandNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV>::value,
    "BindIndexBufferIndirectCommandNV is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV const & bindIndexBufferIndirectCommandNV ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DeviceAddress, seed, bindIndexBufferIndirectCommandNV.bufferAddress );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindIndexBufferIndirectCommandNV.size );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::IndexType, seed, bindIndexBufferIndirectCommandNV.indexType );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindShaderGroupIndirectCommandNV
  {
    using NativeType = VkBindShaderGroupIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindShaderGroupIndirectCommandNV( uint32_t groupIndex_ = {} ) VULKAN_HPP_NOEXCEPT
      : groupIndex( groupIndex_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BindShaderGroupIndirectCommandNV( BindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindShaderGroupIndirectCommandNV( VkBindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindShaderGroupIndirectCommandNV( *reinterpret_cast<BindShaderGroupIndirectCommandNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindShaderGroupIndirectCommandNV &
      operator=( BindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindShaderGroupIndirectCommandNV & operator=( VkBindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindShaderGroupIndirectCommandNV & setGroupIndex( uint32_t groupIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      groupIndex = groupIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindShaderGroupIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindShaderGroupIndirectCommandNV *>( this );
    }

    operator VkBindShaderGroupIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindShaderGroupIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindShaderGroupIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindShaderGroupIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( groupIndex == rhs.groupIndex );
    }

    bool operator!=( BindShaderGroupIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t groupIndex = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV ) ==
                              sizeof( VkBindShaderGroupIndirectCommandNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV>::value,
    "BindShaderGroupIndirectCommandNV is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV const & bindShaderGroupIndirectCommandNV ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindShaderGroupIndirectCommandNV.groupIndex );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct SparseMemoryBind
  {
    using NativeType = VkSparseMemoryBind;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseMemoryBind( VULKAN_HPP_NAMESPACE::DeviceSize            resourceOffset_ = {},
                                           VULKAN_HPP_NAMESPACE::DeviceSize            size_           = {},
                                           VULKAN_HPP_NAMESPACE::DeviceMemory          memory_         = {},
                                           VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset_   = {},
                                           VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_ = {} ) VULKAN_HPP_NOEXCEPT
      : resourceOffset( resourceOffset_ )
      , size( size_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
      , flags( flags_ )
    {}

    VULKAN_HPP_CONSTEXPR SparseMemoryBind( SparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseMemoryBind( VkSparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseMemoryBind( *reinterpret_cast<SparseMemoryBind const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SparseMemoryBind & operator=( SparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseMemoryBind & operator=( VkSparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseMemoryBind const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind &
                            setResourceOffset( VULKAN_HPP_NAMESPACE::DeviceSize resourceOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      resourceOffset = resourceOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind &
                            setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind &
                            setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind &
                            setFlags( VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSparseMemoryBind const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseMemoryBind *>( this );
    }

    operator VkSparseMemoryBind &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseMemoryBind *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseMemoryBind const & ) const = default;
#else
    bool operator==( SparseMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( resourceOffset == rhs.resourceOffset ) && ( size == rhs.size ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset ) && ( flags == rhs.flags );
    }

    bool operator!=( SparseMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize            resourceOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            size           = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory          memory         = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset   = {};
    VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags          = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SparseMemoryBind ) == sizeof( VkSparseMemoryBind ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SparseMemoryBind>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SparseMemoryBind>::value,
                            "SparseMemoryBind is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SparseMemoryBind>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::SparseMemoryBind const & sparseMemoryBind ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, sparseMemoryBind.resourceOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, sparseMemoryBind.size );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceMemory, seed, sparseMemoryBind.memory );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, sparseMemoryBind.memoryOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags, seed, sparseMemoryBind.flags );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct SparseBufferMemoryBindInfo
  {
    using NativeType = VkSparseBufferMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      SparseBufferMemoryBindInfo( VULKAN_HPP_NAMESPACE::Buffer                   buffer_    = {},
                                  uint32_t                                       bindCount_ = {},
                                  const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_    = {} ) VULKAN_HPP_NOEXCEPT
      : buffer( buffer_ )
      , bindCount( bindCount_ )
      , pBinds( pBinds_ )
    {}

    VULKAN_HPP_CONSTEXPR
      SparseBufferMemoryBindInfo( SparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseBufferMemoryBindInfo( VkSparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseBufferMemoryBindInfo( *reinterpret_cast<SparseBufferMemoryBindInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseBufferMemoryBindInfo(
      VULKAN_HPP_NAMESPACE::Buffer                                                                        buffer_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ )
      : buffer( buffer_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SparseBufferMemoryBindInfo & operator=( SparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseBufferMemoryBindInfo & operator=( VkSparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo &
                            setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo &
                            setPBinds( const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseBufferMemoryBindInfo & setBinds(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ )
      VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSparseBufferMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseBufferMemoryBindInfo *>( this );
    }

    operator VkSparseBufferMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseBufferMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseBufferMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseBufferMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( buffer == rhs.buffer ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
    }

    bool operator!=( SparseBufferMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Buffer                   buffer    = {};
    uint32_t                                       bindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo ) ==
                              sizeof( VkSparseBufferMemoryBindInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo>::value,
                            "SparseBufferMemoryBindInfo is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo const & sparseBufferMemoryBindInfo ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, sparseBufferMemoryBindInfo.buffer );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, sparseBufferMemoryBindInfo.bindCount );
    VULKAN_HPP_HASH_COMBINE( const VULKAN_HPP_NAMESPACE::SparseMemoryBind *, seed, sparseBufferMemoryBindInfo.pBinds );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct SparseImageOpaqueMemoryBindInfo
  {
    using NativeType = VkSparseImageOpaqueMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      SparseImageOpaqueMemoryBindInfo( VULKAN_HPP_NAMESPACE::Image                    image_     = {},
                                       uint32_t                                       bindCount_ = {},
                                       const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_ = {} ) VULKAN_HPP_NOEXCEPT
      : image( image_ )
      , bindCount( bindCount_ )
      , pBinds( pBinds_ )
    {}

    VULKAN_HPP_CONSTEXPR
      SparseImageOpaqueMemoryBindInfo( SparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageOpaqueMemoryBindInfo( VkSparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageOpaqueMemoryBindInfo( *reinterpret_cast<SparseImageOpaqueMemoryBindInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageOpaqueMemoryBindInfo(
      VULKAN_HPP_NAMESPACE::Image                                                                         image_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ )
      : image( image_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SparseImageOpaqueMemoryBindInfo &
      operator=( SparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageOpaqueMemoryBindInfo & operator=( VkSparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo &
                            setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo &
                            setPBinds( const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageOpaqueMemoryBindInfo & setBinds(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ )
      VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSparseImageOpaqueMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageOpaqueMemoryBindInfo *>( this );
    }

    operator VkSparseImageOpaqueMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageOpaqueMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageOpaqueMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseImageOpaqueMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( image == rhs.image ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
    }

    bool operator!=( SparseImageOpaqueMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Image                    image     = {};
    uint32_t                                       bindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo ) ==
                              sizeof( VkSparseImageOpaqueMemoryBindInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo>::value,
    "SparseImageOpaqueMemoryBindInfo is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo const & sparseImageOpaqueMemoryBindInfo ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, sparseImageOpaqueMemoryBindInfo.image );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, sparseImageOpaqueMemoryBindInfo.bindCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::SparseMemoryBind *, seed, sparseImageOpaqueMemoryBindInfo.pBinds );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct ImageSubresource
  {
    using NativeType = VkImageSubresource;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageSubresource( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ = {},
                                           uint32_t                               mipLevel_   = {},
                                           uint32_t                               arrayLayer_ = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask( aspectMask_ )
      , mipLevel( mipLevel_ )
      , arrayLayer( arrayLayer_ )
    {}

    VULKAN_HPP_CONSTEXPR ImageSubresource( ImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresource( VkImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageSubresource( *reinterpret_cast<ImageSubresource const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageSubresource & operator=( ImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresource & operator=( VkImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageSubresource const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresource &
                            setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setMipLevel( uint32_t mipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      mipLevel = mipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setArrayLayer( uint32_t arrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      arrayLayer = arrayLayer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageSubresource const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresource *>( this );
    }

    operator VkImageSubresource &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresource *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresource const & ) const = default;
#else
    bool operator==( ImageSubresource const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( aspectMask == rhs.aspectMask ) && ( mipLevel == rhs.mipLevel ) && ( arrayLayer == rhs.arrayLayer );
    }

    bool operator!=( ImageSubresource const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask = {};
    uint32_t                               mipLevel   = {};
    uint32_t                               arrayLayer = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageSubresource ) == sizeof( VkImageSubresource ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageSubresource>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageSubresource>::value,
                            "ImageSubresource is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ImageSubresource>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::ImageSubresource const & imageSubresource ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageAspectFlags, seed, imageSubresource.aspectMask );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageSubresource.mipLevel );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageSubresource.arrayLayer );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct Offset3D
  {
    using NativeType = VkOffset3D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Offset3D( int32_t x_ = {}, int32_t y_ = {}, int32_t z_ = {} ) VULKAN_HPP_NOEXCEPT
      : x( x_ )
      , y( y_ )
      , z( z_ )
    {}

    VULKAN_HPP_CONSTEXPR Offset3D( Offset3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset3D( VkOffset3D const & rhs ) VULKAN_HPP_NOEXCEPT : Offset3D( *reinterpret_cast<Offset3D const *>( &rhs ) ) {}

    explicit Offset3D( Offset2D const & offset2D, int32_t z_ = {} ) : x( offset2D.x ), y( offset2D.y ), z( z_ ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Offset3D & operator=( Offset3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset3D & operator=( VkOffset3D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Offset3D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Offset3D & setX( int32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset3D & setY( int32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset3D & setZ( int32_t z_ ) VULKAN_HPP_NOEXCEPT
    {
      z = z_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkOffset3D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkOffset3D *>( this );
    }

    operator VkOffset3D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkOffset3D *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Offset3D const & ) const = default;
#else
    bool operator==( Offset3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( x == rhs.x ) && ( y == rhs.y ) && ( z == rhs.z );
    }

    bool operator!=( Offset3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    int32_t x = {};
    int32_t y = {};
    int32_t z = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Offset3D ) == sizeof( VkOffset3D ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Offset3D>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Offset3D>::value,
                            "Offset3D is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::Offset3D>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::Offset3D const & offset3D ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( int32_t, seed, offset3D.x );
    VULKAN_HPP_HASH_COMBINE( int32_t, seed, offset3D.y );
    VULKAN_HPP_HASH_COMBINE( int32_t, seed, offset3D.z );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct Extent3D
  {
    using NativeType = VkExtent3D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      Extent3D( uint32_t width_ = {}, uint32_t height_ = {}, uint32_t depth_ = {} ) VULKAN_HPP_NOEXCEPT
      : width( width_ )
      , height( height_ )
      , depth( depth_ )
    {}

    VULKAN_HPP_CONSTEXPR Extent3D( Extent3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent3D( VkExtent3D const & rhs ) VULKAN_HPP_NOEXCEPT : Extent3D( *reinterpret_cast<Extent3D const *>( &rhs ) ) {}

    explicit Extent3D( Extent2D const & extent2D, uint32_t depth_ = {} )
      : width( extent2D.width ), height( extent2D.height ), depth( depth_ )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Extent3D & operator=( Extent3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent3D & operator=( VkExtent3D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Extent3D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Extent3D & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent3D & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent3D & setDepth( uint32_t depth_ ) VULKAN_HPP_NOEXCEPT
    {
      depth = depth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkExtent3D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtent3D *>( this );
    }

    operator VkExtent3D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtent3D *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Extent3D const & ) const = default;
#else
    bool operator==( Extent3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( width == rhs.width ) && ( height == rhs.height ) && ( depth == rhs.depth );
    }

    bool operator!=( Extent3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t width  = {};
    uint32_t height = {};
    uint32_t depth  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Extent3D ) == sizeof( VkExtent3D ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Extent3D>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Extent3D>::value,
                            "Extent3D is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::Extent3D>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::Extent3D const & extent3D ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, extent3D.width );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, extent3D.height );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, extent3D.depth );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct SparseImageMemoryBind
  {
    using NativeType = VkSparseImageMemoryBind;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      SparseImageMemoryBind( VULKAN_HPP_NAMESPACE::ImageSubresource      subresource_  = {},
                             VULKAN_HPP_NAMESPACE::Offset3D              offset_       = {},
                             VULKAN_HPP_NAMESPACE::Extent3D              extent_       = {},
                             VULKAN_HPP_NAMESPACE::DeviceMemory          memory_       = {},
                             VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset_ = {},
                             VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_        = {} ) VULKAN_HPP_NOEXCEPT
      : subresource( subresource_ )
      , offset( offset_ )
      , extent( extent_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
      , flags( flags_ )
    {}

    VULKAN_HPP_CONSTEXPR SparseImageMemoryBind( SparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBind( VkSparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageMemoryBind( *reinterpret_cast<SparseImageMemoryBind const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SparseImageMemoryBind & operator=( SparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBind & operator=( VkSparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseImageMemoryBind const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind &
      setSubresource( VULKAN_HPP_NAMESPACE::ImageSubresource const & subresource_ ) VULKAN_HPP_NOEXCEPT
    {
      subresource = subresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind &
                            setOffset( VULKAN_HPP_NAMESPACE::Offset3D const & offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind &
                            setExtent( VULKAN_HPP_NAMESPACE::Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind &
                            setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind &
                            setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind &
                            setFlags( VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSparseImageMemoryBind const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageMemoryBind *>( this );
    }

    operator VkSparseImageMemoryBind &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageMemoryBind *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageMemoryBind const & ) const = default;
#else
    bool operator==( SparseImageMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( subresource == rhs.subresource ) && ( offset == rhs.offset ) && ( extent == rhs.extent ) &&
             ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset ) && ( flags == rhs.flags );
    }

    bool operator!=( SparseImageMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageSubresource      subresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D              offset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D              extent       = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory          memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset = {};
    VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SparseImageMemoryBind ) == sizeof( VkSparseImageMemoryBind ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SparseImageMemoryBind>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SparseImageMemoryBind>::value,
                            "SparseImageMemoryBind is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SparseImageMemoryBind>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::SparseImageMemoryBind const & sparseImageMemoryBind ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageSubresource, seed, sparseImageMemoryBind.subresource );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Offset3D, seed, sparseImageMemoryBind.offset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Extent3D, seed, sparseImageMemoryBind.extent );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceMemory, seed, sparseImageMemoryBind.memory );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, sparseImageMemoryBind.memoryOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags, seed, sparseImageMemoryBind.flags );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct SparseImageMemoryBindInfo
  {
    using NativeType = VkSparseImageMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      SparseImageMemoryBindInfo( VULKAN_HPP_NAMESPACE::Image                         image_     = {},
                                 uint32_t                                            bindCount_ = {},
                                 const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * pBinds_ = {} ) VULKAN_HPP_NOEXCEPT
      : image( image_ )
      , bindCount( bindCount_ )
      , pBinds( pBinds_ )
    {}

    VULKAN_HPP_CONSTEXPR
      SparseImageMemoryBindInfo( SparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBindInfo( VkSparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageMemoryBindInfo( *reinterpret_cast<SparseImageMemoryBindInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageMemoryBindInfo(
      VULKAN_HPP_NAMESPACE::Image                                                                              image_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind> const & binds_ )
      : image( image_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SparseImageMemoryBindInfo & operator=( SparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBindInfo & operator=( VkSparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo &
                            setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo &
                            setPBinds( const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageMemoryBindInfo & setBinds(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind> const & binds_ )
      VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSparseImageMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageMemoryBindInfo *>( this );
    }

    operator VkSparseImageMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseImageMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( image == rhs.image ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
    }

    bool operator!=( SparseImageMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Image                         image     = {};
    uint32_t                                            bindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * pBinds    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo ) ==
                              sizeof( VkSparseImageMemoryBindInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo>::value,
                            "SparseImageMemoryBindInfo is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo const & sparseImageMemoryBindInfo ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, sparseImageMemoryBindInfo.image );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, sparseImageMemoryBindInfo.bindCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind *, seed, sparseImageMemoryBindInfo.pBinds );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindSparseInfo
  {
    using NativeType = VkBindSparseInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindSparseInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindSparseInfo( uint32_t                                                      waitSemaphoreCount_   = {},
                      const VULKAN_HPP_NAMESPACE::Semaphore *                       pWaitSemaphores_      = {},
                      uint32_t                                                      bufferBindCount_      = {},
                      const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo *      pBufferBinds_         = {},
                      uint32_t                                                      imageOpaqueBindCount_ = {},
                      const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds_    = {},
                      uint32_t                                                      imageBindCount_       = {},
                      const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo *       pImageBinds_          = {},
                      uint32_t                                                      signalSemaphoreCount_ = {},
                      const VULKAN_HPP_NAMESPACE::Semaphore * pSignalSemaphores_ = {} ) VULKAN_HPP_NOEXCEPT
      : waitSemaphoreCount( waitSemaphoreCount_ )
      , pWaitSemaphores( pWaitSemaphores_ )
      , bufferBindCount( bufferBindCount_ )
      , pBufferBinds( pBufferBinds_ )
      , imageOpaqueBindCount( imageOpaqueBindCount_ )
      , pImageOpaqueBinds( pImageOpaqueBinds_ )
      , imageBindCount( imageBindCount_ )
      , pImageBinds( pImageBinds_ )
      , signalSemaphoreCount( signalSemaphoreCount_ )
      , pSignalSemaphores( pSignalSemaphores_ )
    {}

    VULKAN_HPP_CONSTEXPR BindSparseInfo( BindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindSparseInfo( VkBindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindSparseInfo( *reinterpret_cast<BindSparseInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const & waitSemaphores_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo> const &
        bufferBinds_ = {},
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo> const &
        imageOpaqueBinds_ = {},
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo> const &
        imageBinds_ = {},
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const &
        signalSemaphores_ = {} )
      : waitSemaphoreCount( static_cast<uint32_t>( waitSemaphores_.size() ) )
      , pWaitSemaphores( waitSemaphores_.data() )
      , bufferBindCount( static_cast<uint32_t>( bufferBinds_.size() ) )
      , pBufferBinds( bufferBinds_.data() )
      , imageOpaqueBindCount( static_cast<uint32_t>( imageOpaqueBinds_.size() ) )
      , pImageOpaqueBinds( imageOpaqueBinds_.data() )
      , imageBindCount( static_cast<uint32_t>( imageBinds_.size() ) )
      , pImageBinds( imageBinds_.data() )
      , signalSemaphoreCount( static_cast<uint32_t>( signalSemaphores_.size() ) )
      , pSignalSemaphores( signalSemaphores_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindSparseInfo & operator=( BindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindSparseInfo & operator=( VkBindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindSparseInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setWaitSemaphoreCount( uint32_t waitSemaphoreCount_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreCount = waitSemaphoreCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo &
      setPWaitSemaphores( const VULKAN_HPP_NAMESPACE::Semaphore * pWaitSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      pWaitSemaphores = pWaitSemaphores_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setWaitSemaphores(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const & waitSemaphores_ )
      VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreCount = static_cast<uint32_t>( waitSemaphores_.size() );
      pWaitSemaphores    = waitSemaphores_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setBufferBindCount( uint32_t bufferBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferBindCount = bufferBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo &
      setPBufferBinds( const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo * pBufferBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBufferBinds = pBufferBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setBufferBinds(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo> const &
        bufferBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferBindCount = static_cast<uint32_t>( bufferBinds_.size() );
      pBufferBinds    = bufferBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo &
                            setImageOpaqueBindCount( uint32_t imageOpaqueBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOpaqueBindCount = imageOpaqueBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPImageOpaqueBinds(
      const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageOpaqueBinds = pImageOpaqueBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setImageOpaqueBinds(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo> const &
        imageOpaqueBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOpaqueBindCount = static_cast<uint32_t>( imageOpaqueBinds_.size() );
      pImageOpaqueBinds    = imageOpaqueBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setImageBindCount( uint32_t imageBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageBindCount = imageBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo &
      setPImageBinds( const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo * pImageBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageBinds = pImageBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setImageBinds(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo> const &
        imageBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      imageBindCount = static_cast<uint32_t>( imageBinds_.size() );
      pImageBinds    = imageBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo &
                            setSignalSemaphoreCount( uint32_t signalSemaphoreCount_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreCount = signalSemaphoreCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo &
      setPSignalSemaphores( const VULKAN_HPP_NAMESPACE::Semaphore * pSignalSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      pSignalSemaphores = pSignalSemaphores_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setSignalSemaphores(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const & signalSemaphores_ )
      VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreCount = static_cast<uint32_t>( signalSemaphores_.size() );
      pSignalSemaphores    = signalSemaphores_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindSparseInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindSparseInfo *>( this );
    }

    operator VkBindSparseInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindSparseInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindSparseInfo const & ) const = default;
#else
    bool operator==( BindSparseInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( waitSemaphoreCount == rhs.waitSemaphoreCount ) &&
             ( pWaitSemaphores == rhs.pWaitSemaphores ) && ( bufferBindCount == rhs.bufferBindCount ) &&
             ( pBufferBinds == rhs.pBufferBinds ) && ( imageOpaqueBindCount == rhs.imageOpaqueBindCount ) &&
             ( pImageOpaqueBinds == rhs.pImageOpaqueBinds ) && ( imageBindCount == rhs.imageBindCount ) &&
             ( pImageBinds == rhs.pImageBinds ) && ( signalSemaphoreCount == rhs.signalSemaphoreCount ) &&
             ( pSignalSemaphores == rhs.pSignalSemaphores );
    }

    bool operator!=( BindSparseInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                           sType                = StructureType::eBindSparseInfo;
    const void *                                                  pNext                = {};
    uint32_t                                                      waitSemaphoreCount   = {};
    const VULKAN_HPP_NAMESPACE::Semaphore *                       pWaitSemaphores      = {};
    uint32_t                                                      bufferBindCount      = {};
    const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo *      pBufferBinds         = {};
    uint32_t                                                      imageOpaqueBindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds    = {};
    uint32_t                                                      imageBindCount       = {};
    const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo *       pImageBinds          = {};
    uint32_t                                                      signalSemaphoreCount = {};
    const VULKAN_HPP_NAMESPACE::Semaphore *                       pSignalSemaphores    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindSparseInfo ) == sizeof( VkBindSparseInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindSparseInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindSparseInfo>::value,
                            "BindSparseInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindSparseInfo>
  {
    using Type = BindSparseInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindSparseInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BindSparseInfo const & bindSparseInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bindSparseInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bindSparseInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindSparseInfo.waitSemaphoreCount );
    VULKAN_HPP_HASH_COMBINE( const VULKAN_HPP_NAMESPACE::Semaphore *, seed, bindSparseInfo.pWaitSemaphores );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindSparseInfo.bufferBindCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo *, seed, bindSparseInfo.pBufferBinds );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindSparseInfo.imageOpaqueBindCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo *, seed, bindSparseInfo.pImageOpaqueBinds );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindSparseInfo.imageBindCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo *, seed, bindSparseInfo.pImageBinds );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindSparseInfo.signalSemaphoreCount );
    VULKAN_HPP_HASH_COMBINE( const VULKAN_HPP_NAMESPACE::Semaphore *, seed, bindSparseInfo.pSignalSemaphores );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BindVertexBufferIndirectCommandNV
  {
    using NativeType = VkBindVertexBufferIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandNV( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ = {},
                                                            uint32_t                            size_          = {},
                                                            uint32_t stride_ = {} ) VULKAN_HPP_NOEXCEPT
      : bufferAddress( bufferAddress_ )
      , size( size_ )
      , stride( stride_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BindVertexBufferIndirectCommandNV( BindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindVertexBufferIndirectCommandNV( VkBindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindVertexBufferIndirectCommandNV( *reinterpret_cast<BindVertexBufferIndirectCommandNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindVertexBufferIndirectCommandNV &
      operator=( BindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindVertexBufferIndirectCommandNV & operator=( VkBindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV &
                            setBufferAddress( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBindVertexBufferIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindVertexBufferIndirectCommandNV *>( this );
    }

    operator VkBindVertexBufferIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindVertexBufferIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindVertexBufferIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindVertexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( stride == rhs.stride );
    }

    bool operator!=( BindVertexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress = {};
    uint32_t                            size          = {};
    uint32_t                            stride        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV ) ==
                              sizeof( VkBindVertexBufferIndirectCommandNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV>::value,
    "BindVertexBufferIndirectCommandNV is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV const &
                            bindVertexBufferIndirectCommandNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DeviceAddress, seed, bindVertexBufferIndirectCommandNV.bufferAddress );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindVertexBufferIndirectCommandNV.size );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bindVertexBufferIndirectCommandNV.stride );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct ImageSubresourceLayers
  {
    using NativeType = VkImageSubresourceLayers;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageSubresourceLayers( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_     = {},
                                                 uint32_t                               mipLevel_       = {},
                                                 uint32_t                               baseArrayLayer_ = {},
                                                 uint32_t layerCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask( aspectMask_ )
      , mipLevel( mipLevel_ )
      , baseArrayLayer( baseArrayLayer_ )
      , layerCount( layerCount_ )
    {}

    VULKAN_HPP_CONSTEXPR ImageSubresourceLayers( ImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceLayers( VkImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageSubresourceLayers( *reinterpret_cast<ImageSubresourceLayers const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageSubresourceLayers & operator=( ImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceLayers & operator=( VkImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers &
                            setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setMipLevel( uint32_t mipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      mipLevel = mipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageSubresourceLayers const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresourceLayers *>( this );
    }

    operator VkImageSubresourceLayers &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresourceLayers *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresourceLayers const & ) const = default;
#else
    bool operator==( ImageSubresourceLayers const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( aspectMask == rhs.aspectMask ) && ( mipLevel == rhs.mipLevel ) &&
             ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
    }

    bool operator!=( ImageSubresourceLayers const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask     = {};
    uint32_t                               mipLevel       = {};
    uint32_t                               baseArrayLayer = {};
    uint32_t                               layerCount     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers ) ==
                              sizeof( VkImageSubresourceLayers ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers>::value,
                            "ImageSubresourceLayers is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresourceLayers ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageAspectFlags, seed, imageSubresourceLayers.aspectMask );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageSubresourceLayers.mipLevel );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageSubresourceLayers.baseArrayLayer );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageSubresourceLayers.layerCount );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct ImageBlit2KHR
  {
    using NativeType = VkImageBlit2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageBlit2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      ImageBlit2KHR( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers          srcSubresource_ = {},
                     std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & srcOffsets_     = {},
                     VULKAN_HPP_NAMESPACE::ImageSubresourceLayers          dstSubresource_ = {},
                     std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & dstOffsets_     = {} ) VULKAN_HPP_NOEXCEPT
      : srcSubresource( srcSubresource_ )
      , srcOffsets( srcOffsets_ )
      , dstSubresource( dstSubresource_ )
      , dstOffsets( dstOffsets_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2KHR( ImageBlit2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageBlit2KHR( VkImageBlit2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageBlit2KHR( *reinterpret_cast<ImageBlit2KHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageBlit2KHR & operator=( ImageBlit2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageBlit2KHR & operator=( VkImageBlit2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageBlit2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2KHR &
      setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2KHR &
      setSrcOffsets( std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & srcOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffsets = srcOffsets_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2KHR &
      setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2KHR &
      setDstOffsets( std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & dstOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffsets = dstOffsets_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageBlit2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageBlit2KHR *>( this );
    }

    operator VkImageBlit2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageBlit2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageBlit2KHR const & ) const = default;
#else
    bool operator==( ImageBlit2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSubresource == rhs.srcSubresource ) &&
             ( srcOffsets == rhs.srcOffsets ) && ( dstSubresource == rhs.dstSubresource ) &&
             ( dstOffsets == rhs.dstOffsets );
    }

    bool operator!=( ImageBlit2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                     sType = StructureType::eImageBlit2KHR;
    const void *                                                            pNext = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers                            srcSubresource = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> srcOffsets     = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers                            dstSubresource = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> dstOffsets     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageBlit2KHR ) == sizeof( VkImageBlit2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageBlit2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageBlit2KHR>::value,
                            "ImageBlit2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eImageBlit2KHR>
  {
    using Type = ImageBlit2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ImageBlit2KHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::ImageBlit2KHR const & imageBlit2KHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, imageBlit2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, imageBlit2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers, seed, imageBlit2KHR.srcSubresource );
    for ( size_t i = 0; i < 2; ++i )
    {
      VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Offset3D, seed, imageBlit2KHR.srcOffsets[i] );
    }
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers, seed, imageBlit2KHR.dstSubresource );
    for ( size_t i = 0; i < 2; ++i )
    {
      VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Offset3D, seed, imageBlit2KHR.dstOffsets[i] );
    }
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BlitImageInfo2KHR
  {
    using NativeType = VkBlitImageInfo2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBlitImageInfo2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2KHR(
      VULKAN_HPP_NAMESPACE::Image                 srcImage_       = {},
      VULKAN_HPP_NAMESPACE::ImageLayout           srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      VULKAN_HPP_NAMESPACE::Image                 dstImage_       = {},
      VULKAN_HPP_NAMESPACE::ImageLayout           dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      uint32_t                                    regionCount_    = {},
      const VULKAN_HPP_NAMESPACE::ImageBlit2KHR * pRegions_       = {},
      VULKAN_HPP_NAMESPACE::Filter                filter_ = VULKAN_HPP_NAMESPACE::Filter::eNearest ) VULKAN_HPP_NOEXCEPT
      : srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( regionCount_ )
      , pRegions( pRegions_ )
      , filter( filter_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2KHR( BlitImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BlitImageInfo2KHR( VkBlitImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BlitImageInfo2KHR( *reinterpret_cast<BlitImageInfo2KHR const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BlitImageInfo2KHR(
      VULKAN_HPP_NAMESPACE::Image                                                                      srcImage_,
      VULKAN_HPP_NAMESPACE::ImageLayout                                                                srcImageLayout_,
      VULKAN_HPP_NAMESPACE::Image                                                                      dstImage_,
      VULKAN_HPP_NAMESPACE::ImageLayout                                                                dstImageLayout_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageBlit2KHR> const & regions_,
      VULKAN_HPP_NAMESPACE::Filter filter_ = VULKAN_HPP_NAMESPACE::Filter::eNearest )
      : srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
      , filter( filter_ )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BlitImageInfo2KHR & operator=( BlitImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BlitImageInfo2KHR & operator=( VkBlitImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BlitImageInfo2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2KHR & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2KHR &
                            setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2KHR & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2KHR &
                            setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2KHR & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2KHR &
                            setPRegions( const VULKAN_HPP_NAMESPACE::ImageBlit2KHR * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BlitImageInfo2KHR & setRegions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageBlit2KHR> const & regions_ )
      VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2KHR & setFilter( VULKAN_HPP_NAMESPACE::Filter filter_ ) VULKAN_HPP_NOEXCEPT
    {
      filter = filter_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBlitImageInfo2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBlitImageInfo2KHR *>( this );
    }

    operator VkBlitImageInfo2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBlitImageInfo2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BlitImageInfo2KHR const & ) const = default;
#else
    bool operator==( BlitImageInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) &&
             ( srcImageLayout == rhs.srcImageLayout ) && ( dstImage == rhs.dstImage ) &&
             ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) &&
             ( pRegions == rhs.pRegions ) && ( filter == rhs.filter );
    }

    bool operator!=( BlitImageInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType          = StructureType::eBlitImageInfo2KHR;
    const void *                                pNext          = {};
    VULKAN_HPP_NAMESPACE::Image                 srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout           srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Image                 dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout           dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                    regionCount    = {};
    const VULKAN_HPP_NAMESPACE::ImageBlit2KHR * pRegions       = {};
    VULKAN_HPP_NAMESPACE::Filter                filter         = VULKAN_HPP_NAMESPACE::Filter::eNearest;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BlitImageInfo2KHR ) == sizeof( VkBlitImageInfo2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BlitImageInfo2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BlitImageInfo2KHR>::value,
                            "BlitImageInfo2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBlitImageInfo2KHR>
  {
    using Type = BlitImageInfo2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BlitImageInfo2KHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BlitImageInfo2KHR const & blitImageInfo2KHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, blitImageInfo2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, blitImageInfo2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, blitImageInfo2KHR.srcImage );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, blitImageInfo2KHR.srcImageLayout );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, blitImageInfo2KHR.dstImage );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, blitImageInfo2KHR.dstImageLayout );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, blitImageInfo2KHR.regionCount );
    VULKAN_HPP_HASH_COMBINE( const VULKAN_HPP_NAMESPACE::ImageBlit2KHR *, seed, blitImageInfo2KHR.pRegions );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Filter, seed, blitImageInfo2KHR.filter );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionBufferCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionBufferCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eBufferCollectionBufferCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BufferCollectionBufferCreateInfoFUCHSIA( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ = {},
                                               uint32_t index_ = {} ) VULKAN_HPP_NOEXCEPT
      : collection( collection_ )
      , index( index_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferCollectionBufferCreateInfoFUCHSIA( BufferCollectionBufferCreateInfoFUCHSIA const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionBufferCreateInfoFUCHSIA( VkBufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionBufferCreateInfoFUCHSIA(
          *reinterpret_cast<BufferCollectionBufferCreateInfoFUCHSIA const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCollectionBufferCreateInfoFUCHSIA &
      operator=( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionBufferCreateInfoFUCHSIA &
      operator=( VkBufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA &
      setCollection( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ ) VULKAN_HPP_NOEXCEPT
    {
      collection = collection_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA & setIndex( uint32_t index_ ) VULKAN_HPP_NOEXCEPT
    {
      index = index_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCollectionBufferCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionBufferCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionBufferCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionBufferCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionBufferCreateInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( collection == rhs.collection ) &&
             ( index == rhs.index );
    }

    bool operator!=( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType           sType      = StructureType::eBufferCollectionBufferCreateInfoFUCHSIA;
    const void *                                  pNext      = {};
    VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection = {};
    uint32_t                                      index      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA ) ==
                              sizeof( VkBufferCollectionBufferCreateInfoFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA>::value,
    "BufferCollectionBufferCreateInfoFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionBufferCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionBufferCreateInfoFUCHSIA;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA const &
                            bufferCollectionBufferCreateInfoFUCHSIA ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferCollectionBufferCreateInfoFUCHSIA.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferCollectionBufferCreateInfoFUCHSIA.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA, seed, bufferCollectionBufferCreateInfoFUCHSIA.collection );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCollectionBufferCreateInfoFUCHSIA.index );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionConstraintsInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionConstraintsInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eBufferCollectionConstraintsInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BufferCollectionConstraintsInfoFUCHSIA( uint32_t minBufferCount_                  = {},
                                              uint32_t maxBufferCount_                  = {},
                                              uint32_t minBufferCountForCamping_        = {},
                                              uint32_t minBufferCountForDedicatedSlack_ = {},
                                              uint32_t minBufferCountForSharedSlack_    = {} ) VULKAN_HPP_NOEXCEPT
      : minBufferCount( minBufferCount_ )
      , maxBufferCount( maxBufferCount_ )
      , minBufferCountForCamping( minBufferCountForCamping_ )
      , minBufferCountForDedicatedSlack( minBufferCountForDedicatedSlack_ )
      , minBufferCountForSharedSlack( minBufferCountForSharedSlack_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferCollectionConstraintsInfoFUCHSIA( BufferCollectionConstraintsInfoFUCHSIA const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionConstraintsInfoFUCHSIA( VkBufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionConstraintsInfoFUCHSIA(
          *reinterpret_cast<BufferCollectionConstraintsInfoFUCHSIA const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCollectionConstraintsInfoFUCHSIA &
      operator=( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionConstraintsInfoFUCHSIA &
      operator=( VkBufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
                            setMinBufferCount( uint32_t minBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCount = minBufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
                            setMaxBufferCount( uint32_t maxBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxBufferCount = maxBufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
                            setMinBufferCountForCamping( uint32_t minBufferCountForCamping_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForCamping = minBufferCountForCamping_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
      setMinBufferCountForDedicatedSlack( uint32_t minBufferCountForDedicatedSlack_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForDedicatedSlack = minBufferCountForDedicatedSlack_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
      setMinBufferCountForSharedSlack( uint32_t minBufferCountForSharedSlack_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForSharedSlack = minBufferCountForSharedSlack_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCollectionConstraintsInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionConstraintsInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionConstraintsInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionConstraintsInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionConstraintsInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( minBufferCount == rhs.minBufferCount ) &&
             ( maxBufferCount == rhs.maxBufferCount ) && ( minBufferCountForCamping == rhs.minBufferCountForCamping ) &&
             ( minBufferCountForDedicatedSlack == rhs.minBufferCountForDedicatedSlack ) &&
             ( minBufferCountForSharedSlack == rhs.minBufferCountForSharedSlack );
    }

    bool operator!=( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType          = StructureType::eBufferCollectionConstraintsInfoFUCHSIA;
    const void *                        pNext          = {};
    uint32_t                            minBufferCount = {};
    uint32_t                            maxBufferCount = {};
    uint32_t                            minBufferCountForCamping        = {};
    uint32_t                            minBufferCountForDedicatedSlack = {};
    uint32_t                            minBufferCountForSharedSlack    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA ) ==
                              sizeof( VkBufferCollectionConstraintsInfoFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA>::value,
    "BufferCollectionConstraintsInfoFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionConstraintsInfoFUCHSIA>
  {
    using Type = BufferCollectionConstraintsInfoFUCHSIA;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA const &
                            bufferCollectionConstraintsInfoFUCHSIA ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferCollectionConstraintsInfoFUCHSIA.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferCollectionConstraintsInfoFUCHSIA.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCollectionConstraintsInfoFUCHSIA.minBufferCount );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCollectionConstraintsInfoFUCHSIA.maxBufferCount );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCollectionConstraintsInfoFUCHSIA.minBufferCountForCamping );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCollectionConstraintsInfoFUCHSIA.minBufferCountForDedicatedSlack );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCollectionConstraintsInfoFUCHSIA.minBufferCountForSharedSlack );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eBufferCollectionCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionCreateInfoFUCHSIA( zx_handle_t collectionToken_ = {} ) VULKAN_HPP_NOEXCEPT
      : collectionToken( collectionToken_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BufferCollectionCreateInfoFUCHSIA( BufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionCreateInfoFUCHSIA( VkBufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionCreateInfoFUCHSIA( *reinterpret_cast<BufferCollectionCreateInfoFUCHSIA const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCollectionCreateInfoFUCHSIA &
      operator=( BufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionCreateInfoFUCHSIA & operator=( VkBufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionCreateInfoFUCHSIA &
                            setCollectionToken( zx_handle_t collectionToken_ ) VULKAN_HPP_NOEXCEPT
    {
      collectionToken = collectionToken_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCollectionCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionCreateInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( memcmp( &collectionToken, &rhs.collectionToken, sizeof( zx_handle_t ) ) == 0 );
    }

    bool operator!=( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eBufferCollectionCreateInfoFUCHSIA;
    const void *                        pNext           = {};
    zx_handle_t                         collectionToken = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA ) ==
                              sizeof( VkBufferCollectionCreateInfoFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA>::value,
    "BufferCollectionCreateInfoFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionCreateInfoFUCHSIA;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA const &
                            bufferCollectionCreateInfoFUCHSIA ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferCollectionCreateInfoFUCHSIA.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferCollectionCreateInfoFUCHSIA.pNext );
    VULKAN_HPP_HASH_COMBINE( zx_handle_t, seed, bufferCollectionCreateInfoFUCHSIA.collectionToken );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionImageCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionImageCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eBufferCollectionImageCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BufferCollectionImageCreateInfoFUCHSIA( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ = {},
                                              uint32_t index_ = {} ) VULKAN_HPP_NOEXCEPT
      : collection( collection_ )
      , index( index_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferCollectionImageCreateInfoFUCHSIA( BufferCollectionImageCreateInfoFUCHSIA const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionImageCreateInfoFUCHSIA( VkBufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionImageCreateInfoFUCHSIA(
          *reinterpret_cast<BufferCollectionImageCreateInfoFUCHSIA const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCollectionImageCreateInfoFUCHSIA &
      operator=( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionImageCreateInfoFUCHSIA &
      operator=( VkBufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA &
      setCollection( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ ) VULKAN_HPP_NOEXCEPT
    {
      collection = collection_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA & setIndex( uint32_t index_ ) VULKAN_HPP_NOEXCEPT
    {
      index = index_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCollectionImageCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionImageCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionImageCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionImageCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionImageCreateInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( collection == rhs.collection ) &&
             ( index == rhs.index );
    }

    bool operator!=( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType           sType      = StructureType::eBufferCollectionImageCreateInfoFUCHSIA;
    const void *                                  pNext      = {};
    VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection = {};
    uint32_t                                      index      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA ) ==
                              sizeof( VkBufferCollectionImageCreateInfoFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA>::value,
    "BufferCollectionImageCreateInfoFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionImageCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionImageCreateInfoFUCHSIA;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA const &
                            bufferCollectionImageCreateInfoFUCHSIA ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferCollectionImageCreateInfoFUCHSIA.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferCollectionImageCreateInfoFUCHSIA.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA, seed, bufferCollectionImageCreateInfoFUCHSIA.collection );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCollectionImageCreateInfoFUCHSIA.index );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct SysmemColorSpaceFUCHSIA
  {
    using NativeType = VkSysmemColorSpaceFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eSysmemColorSpaceFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SysmemColorSpaceFUCHSIA( uint32_t colorSpace_ = {} ) VULKAN_HPP_NOEXCEPT
      : colorSpace( colorSpace_ )
    {}

    VULKAN_HPP_CONSTEXPR SysmemColorSpaceFUCHSIA( SysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SysmemColorSpaceFUCHSIA( VkSysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : SysmemColorSpaceFUCHSIA( *reinterpret_cast<SysmemColorSpaceFUCHSIA const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SysmemColorSpaceFUCHSIA & operator=( SysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SysmemColorSpaceFUCHSIA & operator=( VkSysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SysmemColorSpaceFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SysmemColorSpaceFUCHSIA & setColorSpace( uint32_t colorSpace_ ) VULKAN_HPP_NOEXCEPT
    {
      colorSpace = colorSpace_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSysmemColorSpaceFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSysmemColorSpaceFUCHSIA *>( this );
    }

    operator VkSysmemColorSpaceFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSysmemColorSpaceFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SysmemColorSpaceFUCHSIA const & ) const = default;
#  else
    bool operator==( SysmemColorSpaceFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( colorSpace == rhs.colorSpace );
    }

    bool operator!=( SysmemColorSpaceFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eSysmemColorSpaceFUCHSIA;
    const void *                        pNext      = {};
    uint32_t                            colorSpace = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA ) ==
                              sizeof( VkSysmemColorSpaceFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA>::value,
                            "SysmemColorSpaceFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eSysmemColorSpaceFUCHSIA>
  {
    using Type = SysmemColorSpaceFUCHSIA;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA const & sysmemColorSpaceFUCHSIA ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, sysmemColorSpaceFUCHSIA.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, sysmemColorSpaceFUCHSIA.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, sysmemColorSpaceFUCHSIA.colorSpace );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionPropertiesFUCHSIA
  {
    using NativeType = VkBufferCollectionPropertiesFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eBufferCollectionPropertiesFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionPropertiesFUCHSIA(
      uint32_t                                          memoryTypeBits_                   = {},
      uint32_t                                          bufferCount_                      = {},
      uint32_t                                          createInfoIndex_                  = {},
      uint64_t                                          sysmemPixelFormat_                = {},
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures_                   = {},
      VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA     sysmemColorSpaceIndex_            = {},
      VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents_ = {},
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_ =
        VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity,
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange suggestedYcbcrRange_ = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull,
      VULKAN_HPP_NAMESPACE::ChromaLocation suggestedXChromaOffset_ = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      VULKAN_HPP_NAMESPACE::ChromaLocation suggestedYChromaOffset_ =
        VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven ) VULKAN_HPP_NOEXCEPT
      : memoryTypeBits( memoryTypeBits_ )
      , bufferCount( bufferCount_ )
      , createInfoIndex( createInfoIndex_ )
      , sysmemPixelFormat( sysmemPixelFormat_ )
      , formatFeatures( formatFeatures_ )
      , sysmemColorSpaceIndex( sysmemColorSpaceIndex_ )
      , samplerYcbcrConversionComponents( samplerYcbcrConversionComponents_ )
      , suggestedYcbcrModel( suggestedYcbcrModel_ )
      , suggestedYcbcrRange( suggestedYcbcrRange_ )
      , suggestedXChromaOffset( suggestedXChromaOffset_ )
      , suggestedYChromaOffset( suggestedYChromaOffset_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BufferCollectionPropertiesFUCHSIA( BufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionPropertiesFUCHSIA( VkBufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionPropertiesFUCHSIA( *reinterpret_cast<BufferCollectionPropertiesFUCHSIA const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCollectionPropertiesFUCHSIA &
      operator=( BufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionPropertiesFUCHSIA & operator=( VkBufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
                            setMemoryTypeBits( uint32_t memoryTypeBits_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryTypeBits = memoryTypeBits_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
                            setBufferCount( uint32_t bufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferCount = bufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
                            setCreateInfoIndex( uint32_t createInfoIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      createInfoIndex = createInfoIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
                            setSysmemPixelFormat( uint64_t sysmemPixelFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      sysmemPixelFormat = sysmemPixelFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
      setFormatFeatures( VULKAN_HPP_NAMESPACE::FormatFeatureFlags formatFeatures_ ) VULKAN_HPP_NOEXCEPT
    {
      formatFeatures = formatFeatures_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA & setSysmemColorSpaceIndex(
      VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA const & sysmemColorSpaceIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      sysmemColorSpaceIndex = sysmemColorSpaceIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA & setSamplerYcbcrConversionComponents(
      VULKAN_HPP_NAMESPACE::ComponentMapping const & samplerYcbcrConversionComponents_ ) VULKAN_HPP_NOEXCEPT
    {
      samplerYcbcrConversionComponents = samplerYcbcrConversionComponents_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA & setSuggestedYcbcrModel(
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_ ) VULKAN_HPP_NOEXCEPT
    {
      suggestedYcbcrModel = suggestedYcbcrModel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
      setSuggestedYcbcrRange( VULKAN_HPP_NAMESPACE::SamplerYcbcrRange suggestedYcbcrRange_ ) VULKAN_HPP_NOEXCEPT
    {
      suggestedYcbcrRange = suggestedYcbcrRange_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
      setSuggestedXChromaOffset( VULKAN_HPP_NAMESPACE::ChromaLocation suggestedXChromaOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      suggestedXChromaOffset = suggestedXChromaOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
      setSuggestedYChromaOffset( VULKAN_HPP_NAMESPACE::ChromaLocation suggestedYChromaOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      suggestedYChromaOffset = suggestedYChromaOffset_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCollectionPropertiesFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionPropertiesFUCHSIA *>( this );
    }

    operator VkBufferCollectionPropertiesFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionPropertiesFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionPropertiesFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionPropertiesFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memoryTypeBits == rhs.memoryTypeBits ) &&
             ( bufferCount == rhs.bufferCount ) && ( createInfoIndex == rhs.createInfoIndex ) &&
             ( sysmemPixelFormat == rhs.sysmemPixelFormat ) && ( formatFeatures == rhs.formatFeatures ) &&
             ( sysmemColorSpaceIndex == rhs.sysmemColorSpaceIndex ) &&
             ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) &&
             ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
    }

    bool operator!=( BufferCollectionPropertiesFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType = StructureType::eBufferCollectionPropertiesFUCHSIA;
    void *                                            pNext = {};
    uint32_t                                          memoryTypeBits                   = {};
    uint32_t                                          bufferCount                      = {};
    uint32_t                                          createInfoIndex                  = {};
    uint64_t                                          sysmemPixelFormat                = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures                   = {};
    VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA     sysmemColorSpaceIndex            = {};
    VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents = {};
    VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel =
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity;
    VULKAN_HPP_NAMESPACE::SamplerYcbcrRange suggestedYcbcrRange    = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull;
    VULKAN_HPP_NAMESPACE::ChromaLocation    suggestedXChromaOffset = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
    VULKAN_HPP_NAMESPACE::ChromaLocation    suggestedYChromaOffset = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA ) ==
                              sizeof( VkBufferCollectionPropertiesFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA>::value,
    "BufferCollectionPropertiesFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionPropertiesFUCHSIA>
  {
    using Type = BufferCollectionPropertiesFUCHSIA;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA const &
                            bufferCollectionPropertiesFUCHSIA ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferCollectionPropertiesFUCHSIA.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, bufferCollectionPropertiesFUCHSIA.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCollectionPropertiesFUCHSIA.memoryTypeBits );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCollectionPropertiesFUCHSIA.bufferCount );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCollectionPropertiesFUCHSIA.createInfoIndex );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, bufferCollectionPropertiesFUCHSIA.sysmemPixelFormat );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags, seed, bufferCollectionPropertiesFUCHSIA.formatFeatures );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA, seed, bufferCollectionPropertiesFUCHSIA.sysmemColorSpaceIndex );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentMapping,
                             seed,
                             bufferCollectionPropertiesFUCHSIA.samplerYcbcrConversionComponents );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion, seed, bufferCollectionPropertiesFUCHSIA.suggestedYcbcrModel );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange, seed, bufferCollectionPropertiesFUCHSIA.suggestedYcbcrRange );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::ChromaLocation, seed, bufferCollectionPropertiesFUCHSIA.suggestedXChromaOffset );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::ChromaLocation, seed, bufferCollectionPropertiesFUCHSIA.suggestedYChromaOffset );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  struct BufferCreateInfo
  {
    using NativeType = VkBufferCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BufferCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateFlags flags_ = {},
                        VULKAN_HPP_NAMESPACE::DeviceSize        size_  = {},
                        VULKAN_HPP_NAMESPACE::BufferUsageFlags  usage_ = {},
                        VULKAN_HPP_NAMESPACE::SharingMode sharingMode_ = VULKAN_HPP_NAMESPACE::SharingMode::eExclusive,
                        uint32_t                          queueFamilyIndexCount_ = {},
                        const uint32_t *                  pQueueFamilyIndices_   = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , size( size_ )
      , usage( usage_ )
      , sharingMode( sharingMode_ )
      , queueFamilyIndexCount( queueFamilyIndexCount_ )
      , pQueueFamilyIndices( pQueueFamilyIndices_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferCreateInfo( BufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCreateInfo( VkBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCreateInfo( *reinterpret_cast<BufferCreateInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BufferCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateFlags                               flags_,
                      VULKAN_HPP_NAMESPACE::DeviceSize                                      size_,
                      VULKAN_HPP_NAMESPACE::BufferUsageFlags                                usage_,
                      VULKAN_HPP_NAMESPACE::SharingMode                                     sharingMode_,
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_ )
      : flags( flags_ )
      , size( size_ )
      , usage( usage_ )
      , sharingMode( sharingMode_ )
      , queueFamilyIndexCount( static_cast<uint32_t>( queueFamilyIndices_.size() ) )
      , pQueueFamilyIndices( queueFamilyIndices_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCreateInfo & operator=( BufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCreateInfo & operator=( VkBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::BufferCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo &
                            setUsage( VULKAN_HPP_NAMESPACE::BufferUsageFlags usage_ ) VULKAN_HPP_NOEXCEPT
    {
      usage = usage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo &
                            setSharingMode( VULKAN_HPP_NAMESPACE::SharingMode sharingMode_ ) VULKAN_HPP_NOEXCEPT
    {
      sharingMode = sharingMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo &
                            setQueueFamilyIndexCount( uint32_t queueFamilyIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = queueFamilyIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo &
                            setPQueueFamilyIndices( const uint32_t * pQueueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueFamilyIndices = pQueueFamilyIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BufferCreateInfo & setQueueFamilyIndices(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = static_cast<uint32_t>( queueFamilyIndices_.size() );
      pQueueFamilyIndices   = queueFamilyIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCreateInfo *>( this );
    }

    operator VkBufferCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCreateInfo const & ) const = default;
#else
    bool operator==( BufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( size == rhs.size ) &&
             ( usage == rhs.usage ) && ( sharingMode == rhs.sharingMode ) &&
             ( queueFamilyIndexCount == rhs.queueFamilyIndexCount ) &&
             ( pQueueFamilyIndices == rhs.pQueueFamilyIndices );
    }

    bool operator!=( BufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType     sType                 = StructureType::eBufferCreateInfo;
    const void *                            pNext                 = {};
    VULKAN_HPP_NAMESPACE::BufferCreateFlags flags                 = {};
    VULKAN_HPP_NAMESPACE::DeviceSize        size                  = {};
    VULKAN_HPP_NAMESPACE::BufferUsageFlags  usage                 = {};
    VULKAN_HPP_NAMESPACE::SharingMode       sharingMode           = VULKAN_HPP_NAMESPACE::SharingMode::eExclusive;
    uint32_t                                queueFamilyIndexCount = {};
    const uint32_t *                        pQueueFamilyIndices   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCreateInfo ) == sizeof( VkBufferCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCreateInfo>::value,
                            "BufferCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCreateInfo>
  {
    using Type = BufferCreateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferCreateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferCreateInfo const & bufferCreateInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::BufferCreateFlags, seed, bufferCreateInfo.flags );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferCreateInfo.size );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::BufferUsageFlags, seed, bufferCreateInfo.usage );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SharingMode, seed, bufferCreateInfo.sharingMode );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferCreateInfo.queueFamilyIndexCount );
    VULKAN_HPP_HASH_COMBINE( const uint32_t *, seed, bufferCreateInfo.pQueueFamilyIndices );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferConstraintsInfoFUCHSIA
  {
    using NativeType = VkBufferConstraintsInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferConstraintsInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferConstraintsInfoFUCHSIA(
      VULKAN_HPP_NAMESPACE::BufferCreateInfo                       createInfo_                  = {},
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags                     requiredFormatFeatures_      = {},
      VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA bufferCollectionConstraints_ = {} )
      VULKAN_HPP_NOEXCEPT
      : createInfo( createInfo_ )
      , requiredFormatFeatures( requiredFormatFeatures_ )
      , bufferCollectionConstraints( bufferCollectionConstraints_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BufferConstraintsInfoFUCHSIA( BufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferConstraintsInfoFUCHSIA( VkBufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferConstraintsInfoFUCHSIA( *reinterpret_cast<BufferConstraintsInfoFUCHSIA const *>( &rhs ) )
    {}
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferConstraintsInfoFUCHSIA & operator=( BufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferConstraintsInfoFUCHSIA & operator=( VkBufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA &
      setCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateInfo const & createInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      createInfo = createInfo_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA &
      setRequiredFormatFeatures( VULKAN_HPP_NAMESPACE::FormatFeatureFlags requiredFormatFeatures_ ) VULKAN_HPP_NOEXCEPT
    {
      requiredFormatFeatures = requiredFormatFeatures_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA & setBufferCollectionConstraints(
      VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA const & bufferCollectionConstraints_ )
      VULKAN_HPP_NOEXCEPT
    {
      bufferCollectionConstraints = bufferCollectionConstraints_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferConstraintsInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferConstraintsInfoFUCHSIA *>( this );
    }

    operator VkBufferConstraintsInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferConstraintsInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferConstraintsInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( createInfo == rhs.createInfo ) &&
             ( requiredFormatFeatures == rhs.requiredFormatFeatures ) &&
             ( bufferCollectionConstraints == rhs.bufferCollectionConstraints );
    }

    bool operator!=( BufferConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                          sType = StructureType::eBufferConstraintsInfoFUCHSIA;
    const void *                                                 pNext = {};
    VULKAN_HPP_NAMESPACE::BufferCreateInfo                       createInfo                  = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags                     requiredFormatFeatures      = {};
    VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA bufferCollectionConstraints = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA ) ==
                              sizeof( VkBufferConstraintsInfoFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA>::value,
    "BufferConstraintsInfoFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferConstraintsInfoFUCHSIA>
  {
    using Type = BufferConstraintsInfoFUCHSIA;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA>
{
  std::size_t operator()(
    VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA const & bufferConstraintsInfoFUCHSIA ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferConstraintsInfoFUCHSIA.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferConstraintsInfoFUCHSIA.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::BufferCreateInfo, seed, bufferConstraintsInfoFUCHSIA.createInfo );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags, seed, bufferConstraintsInfoFUCHSIA.requiredFormatFeatures );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA,
                             seed,
                             bufferConstraintsInfoFUCHSIA.bufferCollectionConstraints );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  struct BufferCopy
  {
    using NativeType = VkBufferCopy;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCopy( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ = {},
                                     VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ = {},
                                     VULKAN_HPP_NAMESPACE::DeviceSize size_      = {} ) VULKAN_HPP_NOEXCEPT
      : srcOffset( srcOffset_ )
      , dstOffset( dstOffset_ )
      , size( size_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferCopy( BufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy( VkBufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCopy( *reinterpret_cast<BufferCopy const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCopy & operator=( BufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy & operator=( VkBufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setSrcOffset( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setDstOffset( VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCopy *>( this );
    }

    operator VkBufferCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCopy *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCopy const & ) const = default;
#else
    bool operator==( BufferCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( srcOffset == rhs.srcOffset ) && ( dstOffset == rhs.dstOffset ) && ( size == rhs.size );
    }

    bool operator!=( BufferCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize srcOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize dstOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize size      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCopy ) == sizeof( VkBufferCopy ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCopy>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCopy>::value,
                            "BufferCopy is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferCopy>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferCopy const & bufferCopy ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferCopy.srcOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferCopy.dstOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferCopy.size );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BufferCopy2KHR
  {
    using NativeType = VkBufferCopy2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCopy2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCopy2KHR( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ = {},
                                         VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ = {},
                                         VULKAN_HPP_NAMESPACE::DeviceSize size_      = {} ) VULKAN_HPP_NOEXCEPT
      : srcOffset( srcOffset_ )
      , dstOffset( dstOffset_ )
      , size( size_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferCopy2KHR( BufferCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy2KHR( VkBufferCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCopy2KHR( *reinterpret_cast<BufferCopy2KHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCopy2KHR & operator=( BufferCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy2KHR & operator=( VkBufferCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCopy2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCopy2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2KHR &
                            setSrcOffset( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2KHR &
                            setDstOffset( VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2KHR & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferCopy2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCopy2KHR *>( this );
    }

    operator VkBufferCopy2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCopy2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCopy2KHR const & ) const = default;
#else
    bool operator==( BufferCopy2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcOffset == rhs.srcOffset ) &&
             ( dstOffset == rhs.dstOffset ) && ( size == rhs.size );
    }

    bool operator!=( BufferCopy2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType     = StructureType::eBufferCopy2KHR;
    const void *                        pNext     = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    srcOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    dstOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCopy2KHR ) == sizeof( VkBufferCopy2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCopy2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCopy2KHR>::value,
                            "BufferCopy2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCopy2KHR>
  {
    using Type = BufferCopy2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferCopy2KHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferCopy2KHR const & bufferCopy2KHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferCopy2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferCopy2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferCopy2KHR.srcOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferCopy2KHR.dstOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferCopy2KHR.size );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BufferDeviceAddressCreateInfoEXT
  {
    using NativeType = VkBufferDeviceAddressCreateInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType = StructureType::eBufferDeviceAddressCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BufferDeviceAddressCreateInfoEXT( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {} ) VULKAN_HPP_NOEXCEPT
      : deviceAddress( deviceAddress_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BufferDeviceAddressCreateInfoEXT( BufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressCreateInfoEXT( VkBufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferDeviceAddressCreateInfoEXT( *reinterpret_cast<BufferDeviceAddressCreateInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferDeviceAddressCreateInfoEXT &
      operator=( BufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressCreateInfoEXT & operator=( VkBufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressCreateInfoEXT &
                            setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferDeviceAddressCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferDeviceAddressCreateInfoEXT *>( this );
    }

    operator VkBufferDeviceAddressCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferDeviceAddressCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferDeviceAddressCreateInfoEXT const & ) const = default;
#else
    bool operator==( BufferDeviceAddressCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceAddress == rhs.deviceAddress );
    }

    bool operator!=( BufferDeviceAddressCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eBufferDeviceAddressCreateInfoEXT;
    const void *                        pNext         = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT ) ==
                              sizeof( VkBufferDeviceAddressCreateInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT>::value,
    "BufferDeviceAddressCreateInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferDeviceAddressCreateInfoEXT>
  {
    using Type = BufferDeviceAddressCreateInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT const & bufferDeviceAddressCreateInfoEXT ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferDeviceAddressCreateInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferDeviceAddressCreateInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DeviceAddress, seed, bufferDeviceAddressCreateInfoEXT.deviceAddress );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BufferDeviceAddressInfo
  {
    using NativeType = VkBufferDeviceAddressInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferDeviceAddressInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferDeviceAddressInfo( VULKAN_HPP_NAMESPACE::Buffer buffer_ = {} ) VULKAN_HPP_NOEXCEPT
      : buffer( buffer_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferDeviceAddressInfo( BufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressInfo( VkBufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferDeviceAddressInfo( *reinterpret_cast<BufferDeviceAddressInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferDeviceAddressInfo & operator=( BufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressInfo & operator=( VkBufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressInfo &
                            setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferDeviceAddressInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferDeviceAddressInfo *>( this );
    }

    operator VkBufferDeviceAddressInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferDeviceAddressInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferDeviceAddressInfo const & ) const = default;
#else
    bool operator==( BufferDeviceAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
    }

    bool operator!=( BufferDeviceAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eBufferDeviceAddressInfo;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo ) ==
                              sizeof( VkBufferDeviceAddressInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo>::value,
                            "BufferDeviceAddressInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferDeviceAddressInfo>
  {
    using Type = BufferDeviceAddressInfo;
  };
  using BufferDeviceAddressInfoEXT = BufferDeviceAddressInfo;
  using BufferDeviceAddressInfoKHR = BufferDeviceAddressInfo;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo const & bufferDeviceAddressInfo ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferDeviceAddressInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferDeviceAddressInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, bufferDeviceAddressInfo.buffer );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BufferImageCopy
  {
    using NativeType = VkBufferImageCopy;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferImageCopy( VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset_      = {},
                                          uint32_t                                     bufferRowLength_   = {},
                                          uint32_t                                     bufferImageHeight_ = {},
                                          VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                          VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                          VULKAN_HPP_NAMESPACE::Extent3D imageExtent_ = {} ) VULKAN_HPP_NOEXCEPT
      : bufferOffset( bufferOffset_ )
      , bufferRowLength( bufferRowLength_ )
      , bufferImageHeight( bufferImageHeight_ )
      , imageSubresource( imageSubresource_ )
      , imageOffset( imageOffset_ )
      , imageExtent( imageExtent_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferImageCopy( BufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy( VkBufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferImageCopy( *reinterpret_cast<BufferImageCopy const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferImageCopy & operator=( BufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy & operator=( VkBufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferImageCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy &
                            setBufferOffset( VULKAN_HPP_NAMESPACE::DeviceSize bufferOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferOffset = bufferOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy &
      setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy &
                            setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy &
                            setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferImageCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferImageCopy *>( this );
    }

    operator VkBufferImageCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferImageCopy *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferImageCopy const & ) const = default;
#else
    bool operator==( BufferImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( bufferOffset == rhs.bufferOffset ) && ( bufferRowLength == rhs.bufferRowLength ) &&
             ( bufferImageHeight == rhs.bufferImageHeight ) && ( imageSubresource == rhs.imageSubresource ) &&
             ( imageOffset == rhs.imageOffset ) && ( imageExtent == rhs.imageExtent );
    }

    bool operator!=( BufferImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset      = {};
    uint32_t                                     bufferRowLength   = {};
    uint32_t                                     bufferImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferImageCopy ) == sizeof( VkBufferImageCopy ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferImageCopy>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferImageCopy>::value,
                            "BufferImageCopy is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferImageCopy>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferImageCopy const & bufferImageCopy ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferImageCopy.bufferOffset );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferImageCopy.bufferRowLength );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferImageCopy.bufferImageHeight );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers, seed, bufferImageCopy.imageSubresource );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Offset3D, seed, bufferImageCopy.imageOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Extent3D, seed, bufferImageCopy.imageExtent );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BufferImageCopy2KHR
  {
    using NativeType = VkBufferImageCopy2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferImageCopy2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferImageCopy2KHR( VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset_      = {},
                                              uint32_t                                     bufferRowLength_   = {},
                                              uint32_t                                     bufferImageHeight_ = {},
                                              VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                              VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                              VULKAN_HPP_NAMESPACE::Extent3D imageExtent_ = {} ) VULKAN_HPP_NOEXCEPT
      : bufferOffset( bufferOffset_ )
      , bufferRowLength( bufferRowLength_ )
      , bufferImageHeight( bufferImageHeight_ )
      , imageSubresource( imageSubresource_ )
      , imageOffset( imageOffset_ )
      , imageExtent( imageExtent_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferImageCopy2KHR( BufferImageCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy2KHR( VkBufferImageCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferImageCopy2KHR( *reinterpret_cast<BufferImageCopy2KHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferImageCopy2KHR & operator=( BufferImageCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy2KHR & operator=( VkBufferImageCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2KHR &
                            setBufferOffset( VULKAN_HPP_NAMESPACE::DeviceSize bufferOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferOffset = bufferOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2KHR & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2KHR &
                            setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2KHR &
      setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2KHR &
                            setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2KHR &
                            setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferImageCopy2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferImageCopy2KHR *>( this );
    }

    operator VkBufferImageCopy2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferImageCopy2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferImageCopy2KHR const & ) const = default;
#else
    bool operator==( BufferImageCopy2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( bufferOffset == rhs.bufferOffset ) &&
             ( bufferRowLength == rhs.bufferRowLength ) && ( bufferImageHeight == rhs.bufferImageHeight ) &&
             ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) &&
             ( imageExtent == rhs.imageExtent );
    }

    bool operator!=( BufferImageCopy2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType             = StructureType::eBufferImageCopy2KHR;
    const void *                                 pNext             = {};
    VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset      = {};
    uint32_t                                     bufferRowLength   = {};
    uint32_t                                     bufferImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR ) == sizeof( VkBufferImageCopy2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR>::value,
                            "BufferImageCopy2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferImageCopy2KHR>
  {
    using Type = BufferImageCopy2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR const & bufferImageCopy2KHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferImageCopy2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferImageCopy2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferImageCopy2KHR.bufferOffset );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferImageCopy2KHR.bufferRowLength );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferImageCopy2KHR.bufferImageHeight );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers, seed, bufferImageCopy2KHR.imageSubresource );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Offset3D, seed, bufferImageCopy2KHR.imageOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Extent3D, seed, bufferImageCopy2KHR.imageExtent );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BufferMemoryBarrier
  {
    using NativeType = VkBufferMemoryBarrier;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryBarrier;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier( VULKAN_HPP_NAMESPACE::AccessFlags srcAccessMask_       = {},
                                              VULKAN_HPP_NAMESPACE::AccessFlags dstAccessMask_       = {},
                                              uint32_t                          srcQueueFamilyIndex_ = {},
                                              uint32_t                          dstQueueFamilyIndex_ = {},
                                              VULKAN_HPP_NAMESPACE::Buffer      buffer_              = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize  offset_              = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize  size_ = {} ) VULKAN_HPP_NOEXCEPT
      : srcAccessMask( srcAccessMask_ )
      , dstAccessMask( dstAccessMask_ )
      , srcQueueFamilyIndex( srcQueueFamilyIndex_ )
      , dstQueueFamilyIndex( dstQueueFamilyIndex_ )
      , buffer( buffer_ )
      , offset( offset_ )
      , size( size_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier( BufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier( VkBufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryBarrier( *reinterpret_cast<BufferMemoryBarrier const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferMemoryBarrier & operator=( BufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier & operator=( VkBufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier &
                            setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier &
                            setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier &
                            setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier &
                            setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier &
                            setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferMemoryBarrier const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryBarrier *>( this );
    }

    operator VkBufferMemoryBarrier &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryBarrier *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryBarrier const & ) const = default;
#else
    bool operator==( BufferMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcAccessMask == rhs.srcAccessMask ) &&
             ( dstAccessMask == rhs.dstAccessMask ) && ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) &&
             ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( buffer == rhs.buffer ) &&
             ( offset == rhs.offset ) && ( size == rhs.size );
    }

    bool operator!=( BufferMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType               = StructureType::eBufferMemoryBarrier;
    const void *                        pNext               = {};
    VULKAN_HPP_NAMESPACE::AccessFlags   srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::AccessFlags   dstAccessMask       = {};
    uint32_t                            srcQueueFamilyIndex = {};
    uint32_t                            dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    offset              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size                = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferMemoryBarrier ) == sizeof( VkBufferMemoryBarrier ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier>::value,
                            "BufferMemoryBarrier is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryBarrier>
  {
    using Type = BufferMemoryBarrier;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::BufferMemoryBarrier const & bufferMemoryBarrier ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferMemoryBarrier.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferMemoryBarrier.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccessFlags, seed, bufferMemoryBarrier.srcAccessMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccessFlags, seed, bufferMemoryBarrier.dstAccessMask );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferMemoryBarrier.srcQueueFamilyIndex );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferMemoryBarrier.dstQueueFamilyIndex );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, bufferMemoryBarrier.buffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferMemoryBarrier.offset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferMemoryBarrier.size );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BufferMemoryBarrier2KHR
  {
    using NativeType = VkBufferMemoryBarrier2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryBarrier2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier2KHR( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR srcStageMask_  = {},
                                                  VULKAN_HPP_NAMESPACE::AccessFlags2KHR        srcAccessMask_ = {},
                                                  VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR dstStageMask_  = {},
                                                  VULKAN_HPP_NAMESPACE::AccessFlags2KHR        dstAccessMask_ = {},
                                                  uint32_t                         srcQueueFamilyIndex_       = {},
                                                  uint32_t                         dstQueueFamilyIndex_       = {},
                                                  VULKAN_HPP_NAMESPACE::Buffer     buffer_                    = {},
                                                  VULKAN_HPP_NAMESPACE::DeviceSize offset_                    = {},
                                                  VULKAN_HPP_NAMESPACE::DeviceSize size_ = {} ) VULKAN_HPP_NOEXCEPT
      : srcStageMask( srcStageMask_ )
      , srcAccessMask( srcAccessMask_ )
      , dstStageMask( dstStageMask_ )
      , dstAccessMask( dstAccessMask_ )
      , srcQueueFamilyIndex( srcQueueFamilyIndex_ )
      , dstQueueFamilyIndex( dstQueueFamilyIndex_ )
      , buffer( buffer_ )
      , offset( offset_ )
      , size( size_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier2KHR( BufferMemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier2KHR( VkBufferMemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryBarrier2KHR( *reinterpret_cast<BufferMemoryBarrier2KHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferMemoryBarrier2KHR & operator=( BufferMemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier2KHR & operator=( VkBufferMemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2KHR &
      setSrcStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2KHR &
                            setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2KHR srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2KHR &
      setDstStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2KHR &
                            setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2KHR dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2KHR &
                            setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2KHR &
                            setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2KHR &
                            setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2KHR &
                            setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2KHR &
                            setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferMemoryBarrier2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryBarrier2KHR *>( this );
    }

    operator VkBufferMemoryBarrier2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryBarrier2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryBarrier2KHR const & ) const = default;
#else
    bool operator==( BufferMemoryBarrier2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) &&
             ( srcAccessMask == rhs.srcAccessMask ) && ( dstStageMask == rhs.dstStageMask ) &&
             ( dstAccessMask == rhs.dstAccessMask ) && ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) &&
             ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( buffer == rhs.buffer ) &&
             ( offset == rhs.offset ) && ( size == rhs.size );
    }

    bool operator!=( BufferMemoryBarrier2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType               = StructureType::eBufferMemoryBarrier2KHR;
    const void *                                 pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR srcStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2KHR        srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR dstStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2KHR        dstAccessMask       = {};
    uint32_t                                     srcQueueFamilyIndex = {};
    uint32_t                                     dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Buffer                 buffer              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize             offset              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize             size                = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR ) ==
                              sizeof( VkBufferMemoryBarrier2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR>::value,
                            "BufferMemoryBarrier2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryBarrier2KHR>
  {
    using Type = BufferMemoryBarrier2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR const & bufferMemoryBarrier2KHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferMemoryBarrier2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferMemoryBarrier2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR, seed, bufferMemoryBarrier2KHR.srcStageMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccessFlags2KHR, seed, bufferMemoryBarrier2KHR.srcAccessMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR, seed, bufferMemoryBarrier2KHR.dstStageMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccessFlags2KHR, seed, bufferMemoryBarrier2KHR.dstAccessMask );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferMemoryBarrier2KHR.srcQueueFamilyIndex );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, bufferMemoryBarrier2KHR.dstQueueFamilyIndex );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, bufferMemoryBarrier2KHR.buffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferMemoryBarrier2KHR.offset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferMemoryBarrier2KHR.size );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BufferMemoryRequirementsInfo2
  {
    using NativeType = VkBufferMemoryRequirementsInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryRequirementsInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryRequirementsInfo2( VULKAN_HPP_NAMESPACE::Buffer buffer_ = {} ) VULKAN_HPP_NOEXCEPT
      : buffer( buffer_ )
    {}

    VULKAN_HPP_CONSTEXPR
      BufferMemoryRequirementsInfo2( BufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryRequirementsInfo2( VkBufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryRequirementsInfo2( *reinterpret_cast<BufferMemoryRequirementsInfo2 const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferMemoryRequirementsInfo2 &
      operator=( BufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryRequirementsInfo2 & operator=( VkBufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryRequirementsInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryRequirementsInfo2 &
                            setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferMemoryRequirementsInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryRequirementsInfo2 *>( this );
    }

    operator VkBufferMemoryRequirementsInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryRequirementsInfo2 *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryRequirementsInfo2 const & ) const = default;
#else
    bool operator==( BufferMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
    }

    bool operator!=( BufferMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eBufferMemoryRequirementsInfo2;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2 ) ==
                              sizeof( VkBufferMemoryRequirementsInfo2 ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2>::value,
    "BufferMemoryRequirementsInfo2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryRequirementsInfo2>
  {
    using Type = BufferMemoryRequirementsInfo2;
  };
  using BufferMemoryRequirementsInfo2KHR = BufferMemoryRequirementsInfo2;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2 const & bufferMemoryRequirementsInfo2 )
    const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferMemoryRequirementsInfo2.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferMemoryRequirementsInfo2.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, bufferMemoryRequirementsInfo2.buffer );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BufferOpaqueCaptureAddressCreateInfo
  {
    using NativeType = VkBufferOpaqueCaptureAddressCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eBufferOpaqueCaptureAddressCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferOpaqueCaptureAddressCreateInfo( uint64_t opaqueCaptureAddress_ = {} ) VULKAN_HPP_NOEXCEPT
      : opaqueCaptureAddress( opaqueCaptureAddress_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferOpaqueCaptureAddressCreateInfo( BufferOpaqueCaptureAddressCreateInfo const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    BufferOpaqueCaptureAddressCreateInfo( VkBufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferOpaqueCaptureAddressCreateInfo( *reinterpret_cast<BufferOpaqueCaptureAddressCreateInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferOpaqueCaptureAddressCreateInfo &
      operator=( BufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferOpaqueCaptureAddressCreateInfo &
      operator=( VkBufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferOpaqueCaptureAddressCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferOpaqueCaptureAddressCreateInfo &
                            setOpaqueCaptureAddress( uint64_t opaqueCaptureAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      opaqueCaptureAddress = opaqueCaptureAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferOpaqueCaptureAddressCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

    operator VkBufferOpaqueCaptureAddressCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferOpaqueCaptureAddressCreateInfo const & ) const = default;
#else
    bool operator==( BufferOpaqueCaptureAddressCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( opaqueCaptureAddress == rhs.opaqueCaptureAddress );
    }

    bool operator!=( BufferOpaqueCaptureAddressCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                = StructureType::eBufferOpaqueCaptureAddressCreateInfo;
    const void *                        pNext                = {};
    uint64_t                            opaqueCaptureAddress = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo ) ==
                              sizeof( VkBufferOpaqueCaptureAddressCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo>::value,
    "BufferOpaqueCaptureAddressCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferOpaqueCaptureAddressCreateInfo>
  {
    using Type = BufferOpaqueCaptureAddressCreateInfo;
  };
  using BufferOpaqueCaptureAddressCreateInfoKHR = BufferOpaqueCaptureAddressCreateInfo;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo const &
                            bufferOpaqueCaptureAddressCreateInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferOpaqueCaptureAddressCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferOpaqueCaptureAddressCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, bufferOpaqueCaptureAddressCreateInfo.opaqueCaptureAddress );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct BufferViewCreateInfo
  {
    using NativeType = VkBufferViewCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferViewCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BufferViewCreateInfo( VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags_  = {},
                            VULKAN_HPP_NAMESPACE::Buffer                buffer_ = {},
                            VULKAN_HPP_NAMESPACE::Format     format_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                            VULKAN_HPP_NAMESPACE::DeviceSize offset_ = {},
                            VULKAN_HPP_NAMESPACE::DeviceSize range_  = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , buffer( buffer_ )
      , format( format_ )
      , offset( offset_ )
      , range( range_ )
    {}

    VULKAN_HPP_CONSTEXPR BufferViewCreateInfo( BufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferViewCreateInfo( VkBufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferViewCreateInfo( *reinterpret_cast<BufferViewCreateInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferViewCreateInfo & operator=( BufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferViewCreateInfo & operator=( VkBufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferViewCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo &
                            setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo &
                            setRange( VULKAN_HPP_NAMESPACE::DeviceSize range_ ) VULKAN_HPP_NOEXCEPT
    {
      range = range_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkBufferViewCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferViewCreateInfo *>( this );
    }

    operator VkBufferViewCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferViewCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferViewCreateInfo const & ) const = default;
#else
    bool operator==( BufferViewCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( buffer == rhs.buffer ) &&
             ( format == rhs.format ) && ( offset == rhs.offset ) && ( range == rhs.range );
    }

    bool operator!=( BufferViewCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType  = StructureType::eBufferViewCreateInfo;
    const void *                                pNext  = {};
    VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags  = {};
    VULKAN_HPP_NAMESPACE::Buffer                buffer = {};
    VULKAN_HPP_NAMESPACE::Format                format = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceSize            offset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            range  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferViewCreateInfo ) == sizeof( VkBufferViewCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferViewCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferViewCreateInfo>::value,
                            "BufferViewCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferViewCreateInfo>
  {
    using Type = BufferViewCreateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::BufferViewCreateInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::BufferViewCreateInfo const & bufferViewCreateInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, bufferViewCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, bufferViewCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::BufferViewCreateFlags, seed, bufferViewCreateInfo.flags );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, bufferViewCreateInfo.buffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Format, seed, bufferViewCreateInfo.format );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferViewCreateInfo.offset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, bufferViewCreateInfo.range );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CalibratedTimestampInfoEXT
  {
    using NativeType = VkCalibratedTimestampInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCalibratedTimestampInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CalibratedTimestampInfoEXT( VULKAN_HPP_NAMESPACE::TimeDomainEXT timeDomain_ =
                                    VULKAN_HPP_NAMESPACE::TimeDomainEXT::eDevice ) VULKAN_HPP_NOEXCEPT
      : timeDomain( timeDomain_ )
    {}

    VULKAN_HPP_CONSTEXPR
      CalibratedTimestampInfoEXT( CalibratedTimestampInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CalibratedTimestampInfoEXT( VkCalibratedTimestampInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : CalibratedTimestampInfoEXT( *reinterpret_cast<CalibratedTimestampInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CalibratedTimestampInfoEXT & operator=( CalibratedTimestampInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CalibratedTimestampInfoEXT & operator=( VkCalibratedTimestampInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CalibratedTimestampInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CalibratedTimestampInfoEXT &
                            setTimeDomain( VULKAN_HPP_NAMESPACE::TimeDomainEXT timeDomain_ ) VULKAN_HPP_NOEXCEPT
    {
      timeDomain = timeDomain_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCalibratedTimestampInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCalibratedTimestampInfoEXT *>( this );
    }

    operator VkCalibratedTimestampInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCalibratedTimestampInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CalibratedTimestampInfoEXT const & ) const = default;
#else
    bool operator==( CalibratedTimestampInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( timeDomain == rhs.timeDomain );
    }

    bool operator!=( CalibratedTimestampInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eCalibratedTimestampInfoEXT;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::TimeDomainEXT timeDomain = VULKAN_HPP_NAMESPACE::TimeDomainEXT::eDevice;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoEXT ) ==
                              sizeof( VkCalibratedTimestampInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoEXT>::value,
                            "CalibratedTimestampInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCalibratedTimestampInfoEXT>
  {
    using Type = CalibratedTimestampInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoEXT>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoEXT const & calibratedTimestampInfoEXT ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, calibratedTimestampInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, calibratedTimestampInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::TimeDomainEXT, seed, calibratedTimestampInfoEXT.timeDomain );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CheckpointData2NV
  {
    using NativeType = VkCheckpointData2NV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCheckpointData2NV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CheckpointData2NV( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR stage_ = {},
                                            void * pCheckpointMarker_ = {} ) VULKAN_HPP_NOEXCEPT
      : stage( stage_ )
      , pCheckpointMarker( pCheckpointMarker_ )
    {}

    VULKAN_HPP_CONSTEXPR CheckpointData2NV( CheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointData2NV( VkCheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CheckpointData2NV( *reinterpret_cast<CheckpointData2NV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CheckpointData2NV & operator=( CheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointData2NV & operator=( VkCheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CheckpointData2NV const *>( &rhs );
      return *this;
    }

    operator VkCheckpointData2NV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCheckpointData2NV *>( this );
    }

    operator VkCheckpointData2NV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCheckpointData2NV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CheckpointData2NV const & ) const = default;
#else
    bool operator==( CheckpointData2NV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stage == rhs.stage ) &&
             ( pCheckpointMarker == rhs.pCheckpointMarker );
    }

    bool operator!=( CheckpointData2NV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType             = StructureType::eCheckpointData2NV;
    void *                                       pNext             = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR stage             = {};
    void *                                       pCheckpointMarker = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CheckpointData2NV ) == sizeof( VkCheckpointData2NV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CheckpointData2NV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CheckpointData2NV>::value,
                            "CheckpointData2NV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCheckpointData2NV>
  {
    using Type = CheckpointData2NV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CheckpointData2NV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CheckpointData2NV const & checkpointData2NV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, checkpointData2NV.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, checkpointData2NV.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR, seed, checkpointData2NV.stage );
    VULKAN_HPP_HASH_COMBINE( void *, seed, checkpointData2NV.pCheckpointMarker );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CheckpointDataNV
  {
    using NativeType = VkCheckpointDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCheckpointDataNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CheckpointDataNV(
      VULKAN_HPP_NAMESPACE::PipelineStageFlagBits stage_ = VULKAN_HPP_NAMESPACE::PipelineStageFlagBits::eTopOfPipe,
      void *                                      pCheckpointMarker_ = {} ) VULKAN_HPP_NOEXCEPT
      : stage( stage_ )
      , pCheckpointMarker( pCheckpointMarker_ )
    {}

    VULKAN_HPP_CONSTEXPR CheckpointDataNV( CheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointDataNV( VkCheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CheckpointDataNV( *reinterpret_cast<CheckpointDataNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CheckpointDataNV & operator=( CheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointDataNV & operator=( VkCheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CheckpointDataNV const *>( &rhs );
      return *this;
    }

    operator VkCheckpointDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCheckpointDataNV *>( this );
    }

    operator VkCheckpointDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCheckpointDataNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CheckpointDataNV const & ) const = default;
#else
    bool operator==( CheckpointDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stage == rhs.stage ) &&
             ( pCheckpointMarker == rhs.pCheckpointMarker );
    }

    bool operator!=( CheckpointDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType = StructureType::eCheckpointDataNV;
    void *                                      pNext = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlagBits stage = VULKAN_HPP_NAMESPACE::PipelineStageFlagBits::eTopOfPipe;
    void *                                      pCheckpointMarker = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CheckpointDataNV ) == sizeof( VkCheckpointDataNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CheckpointDataNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CheckpointDataNV>::value,
                            "CheckpointDataNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCheckpointDataNV>
  {
    using Type = CheckpointDataNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CheckpointDataNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CheckpointDataNV const & checkpointDataNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, checkpointDataNV.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, checkpointDataNV.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::PipelineStageFlagBits, seed, checkpointDataNV.stage );
    VULKAN_HPP_HASH_COMBINE( void *, seed, checkpointDataNV.pCheckpointMarker );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  union ClearColorValue
  {
    using NativeType = VkClearColorValue;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<float, 4> & float32_ = {} ) : float32( float32_ ) {}

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<int32_t, 4> & int32_ ) : int32( int32_ ) {}

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<uint32_t, 4> & uint32_ ) : uint32( uint32_ ) {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setFloat32( std::array<float, 4> float32_ ) VULKAN_HPP_NOEXCEPT
    {
      float32 = float32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setInt32( std::array<int32_t, 4> int32_ ) VULKAN_HPP_NOEXCEPT
    {
      int32 = int32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setUint32( std::array<uint32_t, 4> uint32_ ) VULKAN_HPP_NOEXCEPT
    {
      uint32 = uint32_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkClearColorValue const &() const
    {
      return *reinterpret_cast<const VkClearColorValue *>( this );
    }

    operator VkClearColorValue &()
    {
      return *reinterpret_cast<VkClearColorValue *>( this );
    }

    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4>    float32;
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<int32_t, 4>  int32;
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<uint32_t, 4> uint32;
  };

  struct ClearDepthStencilValue
  {
    using NativeType = VkClearDepthStencilValue;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClearDepthStencilValue( float depth_ = {}, uint32_t stencil_ = {} ) VULKAN_HPP_NOEXCEPT
      : depth( depth_ )
      , stencil( stencil_ )
    {}

    VULKAN_HPP_CONSTEXPR ClearDepthStencilValue( ClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearDepthStencilValue( VkClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClearDepthStencilValue( *reinterpret_cast<ClearDepthStencilValue const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ClearDepthStencilValue & operator=( ClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearDepthStencilValue & operator=( VkClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearDepthStencilValue const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearDepthStencilValue & setDepth( float depth_ ) VULKAN_HPP_NOEXCEPT
    {
      depth = depth_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearDepthStencilValue & setStencil( uint32_t stencil_ ) VULKAN_HPP_NOEXCEPT
    {
      stencil = stencil_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkClearDepthStencilValue const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearDepthStencilValue *>( this );
    }

    operator VkClearDepthStencilValue &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearDepthStencilValue *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClearDepthStencilValue const & ) const = default;
#else
    bool operator==( ClearDepthStencilValue const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( depth == rhs.depth ) && ( stencil == rhs.stencil );
    }

    bool operator!=( ClearDepthStencilValue const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float    depth   = {};
    uint32_t stencil = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue ) ==
                              sizeof( VkClearDepthStencilValue ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ClearDepthStencilValue>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ClearDepthStencilValue>::value,
                            "ClearDepthStencilValue is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ClearDepthStencilValue>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue const & clearDepthStencilValue ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( float, seed, clearDepthStencilValue.depth );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, clearDepthStencilValue.stencil );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  union ClearValue
  {
    using NativeType = VkClearValue;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClearValue( VULKAN_HPP_NAMESPACE::ClearColorValue color_ = {} ) : color( color_ ) {}

    VULKAN_HPP_CONSTEXPR_14 ClearValue( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue depthStencil_ )
      : depthStencil( depthStencil_ )
    {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearValue &
                            setColor( VULKAN_HPP_NAMESPACE::ClearColorValue const & color_ ) VULKAN_HPP_NOEXCEPT
    {
      color = color_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearValue &
      setDepthStencil( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue const & depthStencil_ ) VULKAN_HPP_NOEXCEPT
    {
      depthStencil = depthStencil_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkClearValue const &() const
    {
      return *reinterpret_cast<const VkClearValue *>( this );
    }

    operator VkClearValue &()
    {
      return *reinterpret_cast<VkClearValue *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::ClearColorValue        color;
    VULKAN_HPP_NAMESPACE::ClearDepthStencilValue depthStencil;
#else
    VkClearColorValue        color;
    VkClearDepthStencilValue depthStencil;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct ClearAttachment
  {
    using NativeType = VkClearAttachment;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ClearAttachment( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_      = {},
                                             uint32_t                               colorAttachment_ = {},
                                             VULKAN_HPP_NAMESPACE::ClearValue clearValue_ = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask( aspectMask_ )
      , colorAttachment( colorAttachment_ )
      , clearValue( clearValue_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment( ClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearAttachment( VkClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClearAttachment( *reinterpret_cast<ClearAttachment const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ClearAttachment & operator=( ClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearAttachment & operator=( VkClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearAttachment const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearAttachment &
                            setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setColorAttachment( uint32_t colorAttachment_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachment = colorAttachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment &
                            setClearValue( VULKAN_HPP_NAMESPACE::ClearValue const & clearValue_ ) VULKAN_HPP_NOEXCEPT
    {
      clearValue = clearValue_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkClearAttachment const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearAttachment *>( this );
    }

    operator VkClearAttachment &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearAttachment *>( this );
    }

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask      = {};
    uint32_t                               colorAttachment = {};
    VULKAN_HPP_NAMESPACE::ClearValue       clearValue      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ClearAttachment ) == sizeof( VkClearAttachment ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ClearAttachment>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ClearAttachment>::value,
                            "ClearAttachment is not nothrow_move_constructible!" );

  struct ClearRect
  {
    using NativeType = VkClearRect;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClearRect( VULKAN_HPP_NAMESPACE::Rect2D rect_           = {},
                                    uint32_t                     baseArrayLayer_ = {},
                                    uint32_t                     layerCount_     = {} ) VULKAN_HPP_NOEXCEPT
      : rect( rect_ )
      , baseArrayLayer( baseArrayLayer_ )
      , layerCount( layerCount_ )
    {}

    VULKAN_HPP_CONSTEXPR ClearRect( ClearRect const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearRect( VkClearRect const & rhs ) VULKAN_HPP_NOEXCEPT : ClearRect( *reinterpret_cast<ClearRect const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ClearRect & operator=( ClearRect const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearRect & operator=( VkClearRect const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearRect const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearRect & setRect( VULKAN_HPP_NAMESPACE::Rect2D const & rect_ ) VULKAN_HPP_NOEXCEPT
    {
      rect = rect_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearRect & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearRect & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkClearRect const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearRect *>( this );
    }

    operator VkClearRect &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearRect *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClearRect const & ) const = default;
#else
    bool                     operator==( ClearRect const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( rect == rhs.rect ) && ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
    }

    bool operator!=( ClearRect const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Rect2D rect           = {};
    uint32_t                     baseArrayLayer = {};
    uint32_t                     layerCount     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ClearRect ) == sizeof( VkClearRect ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ClearRect>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ClearRect>::value,
                            "ClearRect is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ClearRect>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::ClearRect const & clearRect ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Rect2D, seed, clearRect.rect );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, clearRect.baseArrayLayer );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, clearRect.layerCount );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CoarseSampleLocationNV
  {
    using NativeType = VkCoarseSampleLocationNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CoarseSampleLocationNV( uint32_t pixelX_ = {}, uint32_t pixelY_ = {}, uint32_t sample_ = {} ) VULKAN_HPP_NOEXCEPT
      : pixelX( pixelX_ )
      , pixelY( pixelY_ )
      , sample( sample_ )
    {}

    VULKAN_HPP_CONSTEXPR CoarseSampleLocationNV( CoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleLocationNV( VkCoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CoarseSampleLocationNV( *reinterpret_cast<CoarseSampleLocationNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CoarseSampleLocationNV & operator=( CoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleLocationNV & operator=( VkCoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setPixelX( uint32_t pixelX_ ) VULKAN_HPP_NOEXCEPT
    {
      pixelX = pixelX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setPixelY( uint32_t pixelY_ ) VULKAN_HPP_NOEXCEPT
    {
      pixelY = pixelY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setSample( uint32_t sample_ ) VULKAN_HPP_NOEXCEPT
    {
      sample = sample_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCoarseSampleLocationNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCoarseSampleLocationNV *>( this );
    }

    operator VkCoarseSampleLocationNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCoarseSampleLocationNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CoarseSampleLocationNV const & ) const = default;
#else
    bool operator==( CoarseSampleLocationNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( pixelX == rhs.pixelX ) && ( pixelY == rhs.pixelY ) && ( sample == rhs.sample );
    }

    bool operator!=( CoarseSampleLocationNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t pixelX = {};
    uint32_t pixelY = {};
    uint32_t sample = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV ) ==
                              sizeof( VkCoarseSampleLocationNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV>::value,
                            "CoarseSampleLocationNV is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV const & coarseSampleLocationNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, coarseSampleLocationNV.pixelX );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, coarseSampleLocationNV.pixelY );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, coarseSampleLocationNV.sample );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CoarseSampleOrderCustomNV
  {
    using NativeType = VkCoarseSampleOrderCustomNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CoarseSampleOrderCustomNV(
      VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV shadingRate_ =
        VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV::eNoInvocations,
      uint32_t                                             sampleCount_         = {},
      uint32_t                                             sampleLocationCount_ = {},
      const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * pSampleLocations_    = {} ) VULKAN_HPP_NOEXCEPT
      : shadingRate( shadingRate_ )
      , sampleCount( sampleCount_ )
      , sampleLocationCount( sampleLocationCount_ )
      , pSampleLocations( pSampleLocations_ )
    {}

    VULKAN_HPP_CONSTEXPR
      CoarseSampleOrderCustomNV( CoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleOrderCustomNV( VkCoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CoarseSampleOrderCustomNV( *reinterpret_cast<CoarseSampleOrderCustomNV const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CoarseSampleOrderCustomNV(
      VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV shadingRate_,
      uint32_t                                        sampleCount_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV> const &
        sampleLocations_ )
      : shadingRate( shadingRate_ )
      , sampleCount( sampleCount_ )
      , sampleLocationCount( static_cast<uint32_t>( sampleLocations_.size() ) )
      , pSampleLocations( sampleLocations_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CoarseSampleOrderCustomNV & operator=( CoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleOrderCustomNV & operator=( VkCoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV &
      setShadingRate( VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV shadingRate_ ) VULKAN_HPP_NOEXCEPT
    {
      shadingRate = shadingRate_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setSampleCount( uint32_t sampleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleCount = sampleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV &
                            setSampleLocationCount( uint32_t sampleLocationCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationCount = sampleLocationCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV &
      setPSampleLocations( const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * pSampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      pSampleLocations = pSampleLocations_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CoarseSampleOrderCustomNV & setSampleLocations(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV> const &
        sampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationCount = static_cast<uint32_t>( sampleLocations_.size() );
      pSampleLocations    = sampleLocations_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCoarseSampleOrderCustomNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCoarseSampleOrderCustomNV *>( this );
    }

    operator VkCoarseSampleOrderCustomNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCoarseSampleOrderCustomNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CoarseSampleOrderCustomNV const & ) const = default;
#else
    bool operator==( CoarseSampleOrderCustomNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( shadingRate == rhs.shadingRate ) && ( sampleCount == rhs.sampleCount ) &&
             ( sampleLocationCount == rhs.sampleLocationCount ) && ( pSampleLocations == rhs.pSampleLocations );
    }

    bool operator!=( CoarseSampleOrderCustomNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV shadingRate =
      VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV::eNoInvocations;
    uint32_t                                             sampleCount         = {};
    uint32_t                                             sampleLocationCount = {};
    const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * pSampleLocations    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV ) ==
                              sizeof( VkCoarseSampleOrderCustomNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV>::value,
                            "CoarseSampleOrderCustomNV is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV const & coarseSampleOrderCustomNV ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV, seed, coarseSampleOrderCustomNV.shadingRate );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, coarseSampleOrderCustomNV.sampleCount );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, coarseSampleOrderCustomNV.sampleLocationCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV *, seed, coarseSampleOrderCustomNV.pSampleLocations );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CommandBufferAllocateInfo
  {
    using NativeType = VkCommandBufferAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferAllocateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferAllocateInfo(
      VULKAN_HPP_NAMESPACE::CommandPool        commandPool_        = {},
      VULKAN_HPP_NAMESPACE::CommandBufferLevel level_              = VULKAN_HPP_NAMESPACE::CommandBufferLevel::ePrimary,
      uint32_t                                 commandBufferCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : commandPool( commandPool_ )
      , level( level_ )
      , commandBufferCount( commandBufferCount_ )
    {}

    VULKAN_HPP_CONSTEXPR
      CommandBufferAllocateInfo( CommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferAllocateInfo( VkCommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferAllocateInfo( *reinterpret_cast<CommandBufferAllocateInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferAllocateInfo & operator=( CommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferAllocateInfo & operator=( VkCommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo &
                            setCommandPool( VULKAN_HPP_NAMESPACE::CommandPool commandPool_ ) VULKAN_HPP_NOEXCEPT
    {
      commandPool = commandPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo &
                            setLevel( VULKAN_HPP_NAMESPACE::CommandBufferLevel level_ ) VULKAN_HPP_NOEXCEPT
    {
      level = level_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo &
                            setCommandBufferCount( uint32_t commandBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBufferCount = commandBufferCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferAllocateInfo *>( this );
    }

    operator VkCommandBufferAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferAllocateInfo const & ) const = default;
#else
    bool operator==( CommandBufferAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandPool == rhs.commandPool ) &&
             ( level == rhs.level ) && ( commandBufferCount == rhs.commandBufferCount );
    }

    bool operator!=( CommandBufferAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType              = StructureType::eCommandBufferAllocateInfo;
    const void *                             pNext              = {};
    VULKAN_HPP_NAMESPACE::CommandPool        commandPool        = {};
    VULKAN_HPP_NAMESPACE::CommandBufferLevel level              = VULKAN_HPP_NAMESPACE::CommandBufferLevel::ePrimary;
    uint32_t                                 commandBufferCount = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo ) ==
                              sizeof( VkCommandBufferAllocateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo>::value,
                            "CommandBufferAllocateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferAllocateInfo>
  {
    using Type = CommandBufferAllocateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo const & commandBufferAllocateInfo ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, commandBufferAllocateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, commandBufferAllocateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::CommandPool, seed, commandBufferAllocateInfo.commandPool );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::CommandBufferLevel, seed, commandBufferAllocateInfo.level );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, commandBufferAllocateInfo.commandBufferCount );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CommandBufferInheritanceInfo
  {
    using NativeType = VkCommandBufferInheritanceInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceInfo(
      VULKAN_HPP_NAMESPACE::RenderPass                  renderPass_           = {},
      uint32_t                                          subpass_              = {},
      VULKAN_HPP_NAMESPACE::Framebuffer                 framebuffer_          = {},
      VULKAN_HPP_NAMESPACE::Bool32                      occlusionQueryEnable_ = {},
      VULKAN_HPP_NAMESPACE::QueryControlFlags           queryFlags_           = {},
      VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics_   = {} ) VULKAN_HPP_NOEXCEPT
      : renderPass( renderPass_ )
      , subpass( subpass_ )
      , framebuffer( framebuffer_ )
      , occlusionQueryEnable( occlusionQueryEnable_ )
      , queryFlags( queryFlags_ )
      , pipelineStatistics( pipelineStatistics_ )
    {}

    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceInfo( CommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceInfo( VkCommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceInfo( *reinterpret_cast<CommandBufferInheritanceInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceInfo & operator=( CommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceInfo & operator=( VkCommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo &
                            setRenderPass( VULKAN_HPP_NAMESPACE::RenderPass renderPass_ ) VULKAN_HPP_NOEXCEPT
    {
      renderPass = renderPass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setSubpass( uint32_t subpass_ ) VULKAN_HPP_NOEXCEPT
    {
      subpass = subpass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo &
                            setFramebuffer( VULKAN_HPP_NAMESPACE::Framebuffer framebuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      framebuffer = framebuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo &
      setOcclusionQueryEnable( VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      occlusionQueryEnable = occlusionQueryEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo &
                            setQueryFlags( VULKAN_HPP_NAMESPACE::QueryControlFlags queryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      queryFlags = queryFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo &
      setPipelineStatistics( VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineStatistics = pipelineStatistics_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferInheritanceInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceInfo *>( this );
    }

    operator VkCommandBufferInheritanceInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceInfo const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( renderPass == rhs.renderPass ) &&
             ( subpass == rhs.subpass ) && ( framebuffer == rhs.framebuffer ) &&
             ( occlusionQueryEnable == rhs.occlusionQueryEnable ) && ( queryFlags == rhs.queryFlags ) &&
             ( pipelineStatistics == rhs.pipelineStatistics );
    }

    bool operator!=( CommandBufferInheritanceInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType       = StructureType::eCommandBufferInheritanceInfo;
    const void *                                      pNext       = {};
    VULKAN_HPP_NAMESPACE::RenderPass                  renderPass  = {};
    uint32_t                                          subpass     = {};
    VULKAN_HPP_NAMESPACE::Framebuffer                 framebuffer = {};
    VULKAN_HPP_NAMESPACE::Bool32                      occlusionQueryEnable = {};
    VULKAN_HPP_NAMESPACE::QueryControlFlags           queryFlags           = {};
    VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo ) ==
                              sizeof( VkCommandBufferInheritanceInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo>::value,
    "CommandBufferInheritanceInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceInfo>
  {
    using Type = CommandBufferInheritanceInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo>
{
  std::size_t operator()(
    VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo const & commandBufferInheritanceInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, commandBufferInheritanceInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, commandBufferInheritanceInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::RenderPass, seed, commandBufferInheritanceInfo.renderPass );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, commandBufferInheritanceInfo.subpass );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Framebuffer, seed, commandBufferInheritanceInfo.framebuffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, commandBufferInheritanceInfo.occlusionQueryEnable );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::QueryControlFlags, seed, commandBufferInheritanceInfo.queryFlags );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags, seed, commandBufferInheritanceInfo.pipelineStatistics );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CommandBufferBeginInfo
  {
    using NativeType = VkCommandBufferBeginInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferBeginInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferBeginInfo(
      VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags              flags_            = {},
      const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , pInheritanceInfo( pInheritanceInfo_ )
    {}

    VULKAN_HPP_CONSTEXPR CommandBufferBeginInfo( CommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferBeginInfo( VkCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferBeginInfo( *reinterpret_cast<CommandBufferBeginInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferBeginInfo & operator=( CommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferBeginInfo & operator=( VkCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setPInheritanceInfo(
      const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pInheritanceInfo = pInheritanceInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferBeginInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferBeginInfo *>( this );
    }

    operator VkCommandBufferBeginInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferBeginInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferBeginInfo const & ) const = default;
#else
    bool operator==( CommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( pInheritanceInfo == rhs.pInheritanceInfo );
    }

    bool operator!=( CommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                        sType = StructureType::eCommandBufferBeginInfo;
    const void *                                               pNext = {};
    VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags              flags = {};
    const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo ) ==
                              sizeof( VkCommandBufferBeginInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo>::value,
                            "CommandBufferBeginInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferBeginInfo>
  {
    using Type = CommandBufferBeginInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo const & commandBufferBeginInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, commandBufferBeginInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, commandBufferBeginInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags, seed, commandBufferBeginInfo.flags );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo *, seed, commandBufferBeginInfo.pInheritanceInfo );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CommandBufferInheritanceConditionalRenderingInfoEXT
  {
    using NativeType = VkCommandBufferInheritanceConditionalRenderingInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceConditionalRenderingInfoEXT(
      VULKAN_HPP_NAMESPACE::Bool32 conditionalRenderingEnable_ = {} ) VULKAN_HPP_NOEXCEPT
      : conditionalRenderingEnable( conditionalRenderingEnable_ )
    {}

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceConditionalRenderingInfoEXT(
      CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceConditionalRenderingInfoEXT(
      VkCommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceConditionalRenderingInfoEXT(
          *reinterpret_cast<CommandBufferInheritanceConditionalRenderingInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceConditionalRenderingInfoEXT &
      operator=( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceConditionalRenderingInfoEXT &
      operator=( VkCommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this =
        *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceConditionalRenderingInfoEXT &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceConditionalRenderingInfoEXT &
      setConditionalRenderingEnable( VULKAN_HPP_NAMESPACE::Bool32 conditionalRenderingEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      conditionalRenderingEnable = conditionalRenderingEnable_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferInheritanceConditionalRenderingInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceConditionalRenderingInfoEXT *>( this );
    }

    operator VkCommandBufferInheritanceConditionalRenderingInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceConditionalRenderingInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceConditionalRenderingInfoEXT const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( conditionalRenderingEnable == rhs.conditionalRenderingEnable );
    }

    bool operator!=( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT;
    const void *                        pNext = {};
    VULKAN_HPP_NAMESPACE::Bool32        conditionalRenderingEnable = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT ) ==
                              sizeof( VkCommandBufferInheritanceConditionalRenderingInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<
                              VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT>::value,
                            "CommandBufferInheritanceConditionalRenderingInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT>
  {
    using Type = CommandBufferInheritanceConditionalRenderingInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT const &
                            commandBufferInheritanceConditionalRenderingInfoEXT ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, commandBufferInheritanceConditionalRenderingInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, commandBufferInheritanceConditionalRenderingInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32,
                             seed,
                             commandBufferInheritanceConditionalRenderingInfoEXT.conditionalRenderingEnable );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CommandBufferInheritanceRenderPassTransformInfoQCOM
  {
    using NativeType = VkCommandBufferInheritanceRenderPassTransformInfoQCOM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderPassTransformInfoQCOM(
      VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ =
        VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity,
      VULKAN_HPP_NAMESPACE::Rect2D renderArea_ = {} ) VULKAN_HPP_NOEXCEPT
      : transform( transform_ )
      , renderArea( renderArea_ )
    {}

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderPassTransformInfoQCOM(
      CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderPassTransformInfoQCOM(
      VkCommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceRenderPassTransformInfoQCOM(
          *reinterpret_cast<CommandBufferInheritanceRenderPassTransformInfoQCOM const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceRenderPassTransformInfoQCOM &
      operator=( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderPassTransformInfoQCOM &
      operator=( VkCommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this =
        *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM &
                            setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM &
      setTransform( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM &
                            setRenderArea( VULKAN_HPP_NAMESPACE::Rect2D const & renderArea_ ) VULKAN_HPP_NOEXCEPT
    {
      renderArea = renderArea_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferInheritanceRenderPassTransformInfoQCOM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceRenderPassTransformInfoQCOM *>( this );
    }

    operator VkCommandBufferInheritanceRenderPassTransformInfoQCOM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceRenderPassTransformInfoQCOM *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceRenderPassTransformInfoQCOM const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( transform == rhs.transform ) &&
             ( renderArea == rhs.renderArea );
    }

    bool operator!=( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM;
    void *                              pNext = {};
    VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform =
      VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity;
    VULKAN_HPP_NAMESPACE::Rect2D renderArea = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM ) ==
                              sizeof( VkCommandBufferInheritanceRenderPassTransformInfoQCOM ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<
                              VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM>::value,
                            "CommandBufferInheritanceRenderPassTransformInfoQCOM is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM>
  {
    using Type = CommandBufferInheritanceRenderPassTransformInfoQCOM;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM const &
                            commandBufferInheritanceRenderPassTransformInfoQCOM ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, commandBufferInheritanceRenderPassTransformInfoQCOM.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, commandBufferInheritanceRenderPassTransformInfoQCOM.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR,
                             seed,
                             commandBufferInheritanceRenderPassTransformInfoQCOM.transform );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Rect2D, seed, commandBufferInheritanceRenderPassTransformInfoQCOM.renderArea );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CommandBufferInheritanceRenderingInfoKHR
  {
    using NativeType = VkCommandBufferInheritanceRenderingInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eCommandBufferInheritanceRenderingInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderingInfoKHR(
      VULKAN_HPP_NAMESPACE::RenderingFlagsKHR   flags_                   = {},
      uint32_t                                  viewMask_                = {},
      uint32_t                                  colorAttachmentCount_    = {},
      const VULKAN_HPP_NAMESPACE::Format *      pColorAttachmentFormats_ = {},
      VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat_   = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_ = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1 )
      VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , viewMask( viewMask_ )
      , colorAttachmentCount( colorAttachmentCount_ )
      , pColorAttachmentFormats( pColorAttachmentFormats_ )
      , depthAttachmentFormat( depthAttachmentFormat_ )
      , stencilAttachmentFormat( stencilAttachmentFormat_ )
      , rasterizationSamples( rasterizationSamples_ )
    {}

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderingInfoKHR(
      CommandBufferInheritanceRenderingInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderingInfoKHR( VkCommandBufferInheritanceRenderingInfoKHR const & rhs )
      VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceRenderingInfoKHR(
          *reinterpret_cast<CommandBufferInheritanceRenderingInfoKHR const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CommandBufferInheritanceRenderingInfoKHR(
      VULKAN_HPP_NAMESPACE::RenderingFlagsKHR                                                   flags_,
      uint32_t                                                                                  viewMask_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & colorAttachmentFormats_,
      VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat_   = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_ = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1 )
      : flags( flags_ )
      , viewMask( viewMask_ )
      , colorAttachmentCount( static_cast<uint32_t>( colorAttachmentFormats_.size() ) )
      , pColorAttachmentFormats( colorAttachmentFormats_.data() )
      , depthAttachmentFormat( depthAttachmentFormat_ )
      , stencilAttachmentFormat( stencilAttachmentFormat_ )
      , rasterizationSamples( rasterizationSamples_ )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceRenderingInfoKHR &
      operator=( CommandBufferInheritanceRenderingInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderingInfoKHR &
      operator=( VkCommandBufferInheritanceRenderingInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfoKHR &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfoKHR &
                            setFlags( VULKAN_HPP_NAMESPACE::RenderingFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfoKHR &
                            setViewMask( uint32_t viewMask_ ) VULKAN_HPP_NOEXCEPT
    {
      viewMask = viewMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfoKHR &
                            setColorAttachmentCount( uint32_t colorAttachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount = colorAttachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfoKHR &
      setPColorAttachmentFormats( const VULKAN_HPP_NAMESPACE::Format * pColorAttachmentFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      pColorAttachmentFormats = pColorAttachmentFormats_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CommandBufferInheritanceRenderingInfoKHR & setColorAttachmentFormats(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const &
        colorAttachmentFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount    = static_cast<uint32_t>( colorAttachmentFormats_.size() );
      pColorAttachmentFormats = colorAttachmentFormats_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfoKHR &
      setDepthAttachmentFormat( VULKAN_HPP_NAMESPACE::Format depthAttachmentFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      depthAttachmentFormat = depthAttachmentFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfoKHR &
      setStencilAttachmentFormat( VULKAN_HPP_NAMESPACE::Format stencilAttachmentFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilAttachmentFormat = stencilAttachmentFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfoKHR &
      setRasterizationSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      rasterizationSamples = rasterizationSamples_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferInheritanceRenderingInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceRenderingInfoKHR *>( this );
    }

    operator VkCommandBufferInheritanceRenderingInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceRenderingInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceRenderingInfoKHR const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceRenderingInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( viewMask == rhs.viewMask ) && ( colorAttachmentCount == rhs.colorAttachmentCount ) &&
             ( pColorAttachmentFormats == rhs.pColorAttachmentFormats ) &&
             ( depthAttachmentFormat == rhs.depthAttachmentFormat ) &&
             ( stencilAttachmentFormat == rhs.stencilAttachmentFormat ) &&
             ( rasterizationSamples == rhs.rasterizationSamples );
    }

    bool operator!=( CommandBufferInheritanceRenderingInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType    = StructureType::eCommandBufferInheritanceRenderingInfoKHR;
    const void *                              pNext    = {};
    VULKAN_HPP_NAMESPACE::RenderingFlagsKHR   flags    = {};
    uint32_t                                  viewMask = {};
    uint32_t                                  colorAttachmentCount    = {};
    const VULKAN_HPP_NAMESPACE::Format *      pColorAttachmentFormats = {};
    VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat   = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples    = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfoKHR ) ==
                              sizeof( VkCommandBufferInheritanceRenderingInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfoKHR>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfoKHR>::value,
    "CommandBufferInheritanceRenderingInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceRenderingInfoKHR>
  {
    using Type = CommandBufferInheritanceRenderingInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfoKHR const &
                            commandBufferInheritanceRenderingInfoKHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, commandBufferInheritanceRenderingInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, commandBufferInheritanceRenderingInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::RenderingFlagsKHR, seed, commandBufferInheritanceRenderingInfoKHR.flags );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, commandBufferInheritanceRenderingInfoKHR.viewMask );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, commandBufferInheritanceRenderingInfoKHR.colorAttachmentCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::Format *, seed, commandBufferInheritanceRenderingInfoKHR.pColorAttachmentFormats );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Format, seed, commandBufferInheritanceRenderingInfoKHR.depthAttachmentFormat );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Format, seed, commandBufferInheritanceRenderingInfoKHR.stencilAttachmentFormat );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits, seed, commandBufferInheritanceRenderingInfoKHR.rasterizationSamples );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct Viewport
  {
    using NativeType = VkViewport;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Viewport( float x_        = {},
                                   float y_        = {},
                                   float width_    = {},
                                   float height_   = {},
                                   float minDepth_ = {},
                                   float maxDepth_ = {} ) VULKAN_HPP_NOEXCEPT
      : x( x_ )
      , y( y_ )
      , width( width_ )
      , height( height_ )
      , minDepth( minDepth_ )
      , maxDepth( maxDepth_ )
    {}

    VULKAN_HPP_CONSTEXPR Viewport( Viewport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Viewport( VkViewport const & rhs ) VULKAN_HPP_NOEXCEPT : Viewport( *reinterpret_cast<Viewport const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Viewport & operator=( Viewport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Viewport & operator=( VkViewport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Viewport const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Viewport & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setWidth( float width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setHeight( float height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setMinDepth( float minDepth_ ) VULKAN_HPP_NOEXCEPT
    {
      minDepth = minDepth_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setMaxDepth( float maxDepth_ ) VULKAN_HPP_NOEXCEPT
    {
      maxDepth = maxDepth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkViewport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkViewport *>( this );
    }

    operator VkViewport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkViewport *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Viewport const & ) const = default;
#else
    bool operator==( Viewport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( x == rhs.x ) && ( y == rhs.y ) && ( width == rhs.width ) && ( height == rhs.height ) &&
             ( minDepth == rhs.minDepth ) && ( maxDepth == rhs.maxDepth );
    }

    bool operator!=( Viewport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x        = {};
    float y        = {};
    float width    = {};
    float height   = {};
    float minDepth = {};
    float maxDepth = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Viewport ) == sizeof( VkViewport ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Viewport>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Viewport>::value,
                            "Viewport is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::Viewport>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::Viewport const & viewport ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( float, seed, viewport.x );
    VULKAN_HPP_HASH_COMBINE( float, seed, viewport.y );
    VULKAN_HPP_HASH_COMBINE( float, seed, viewport.width );
    VULKAN_HPP_HASH_COMBINE( float, seed, viewport.height );
    VULKAN_HPP_HASH_COMBINE( float, seed, viewport.minDepth );
    VULKAN_HPP_HASH_COMBINE( float, seed, viewport.maxDepth );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CommandBufferInheritanceViewportScissorInfoNV
  {
    using NativeType = VkCommandBufferInheritanceViewportScissorInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eCommandBufferInheritanceViewportScissorInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceViewportScissorInfoNV(
      VULKAN_HPP_NAMESPACE::Bool32           viewportScissor2D_  = {},
      uint32_t                               viewportDepthCount_ = {},
      const VULKAN_HPP_NAMESPACE::Viewport * pViewportDepths_    = {} ) VULKAN_HPP_NOEXCEPT
      : viewportScissor2D( viewportScissor2D_ )
      , viewportDepthCount( viewportDepthCount_ )
      , pViewportDepths( pViewportDepths_ )
    {}

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceViewportScissorInfoNV(
      CommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceViewportScissorInfoNV( VkCommandBufferInheritanceViewportScissorInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceViewportScissorInfoNV(
          *reinterpret_cast<CommandBufferInheritanceViewportScissorInfoNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceViewportScissorInfoNV &
      operator=( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceViewportScissorInfoNV &
      operator=( VkCommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV &
                            setViewportScissor2D( VULKAN_HPP_NAMESPACE::Bool32 viewportScissor2D_ ) VULKAN_HPP_NOEXCEPT
    {
      viewportScissor2D = viewportScissor2D_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV &
                            setViewportDepthCount( uint32_t viewportDepthCount_ ) VULKAN_HPP_NOEXCEPT
    {
      viewportDepthCount = viewportDepthCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV &
      setPViewportDepths( const VULKAN_HPP_NAMESPACE::Viewport * pViewportDepths_ ) VULKAN_HPP_NOEXCEPT
    {
      pViewportDepths = pViewportDepths_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferInheritanceViewportScissorInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceViewportScissorInfoNV *>( this );
    }

    operator VkCommandBufferInheritanceViewportScissorInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceViewportScissorInfoNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceViewportScissorInfoNV const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( viewportScissor2D == rhs.viewportScissor2D ) &&
             ( viewportDepthCount == rhs.viewportDepthCount ) && ( pViewportDepths == rhs.pViewportDepths );
    }

    bool operator!=( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType = StructureType::eCommandBufferInheritanceViewportScissorInfoNV;
    const void *                           pNext = {};
    VULKAN_HPP_NAMESPACE::Bool32           viewportScissor2D  = {};
    uint32_t                               viewportDepthCount = {};
    const VULKAN_HPP_NAMESPACE::Viewport * pViewportDepths    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV ) ==
                              sizeof( VkCommandBufferInheritanceViewportScissorInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV>::value,
    "CommandBufferInheritanceViewportScissorInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceViewportScissorInfoNV>
  {
    using Type = CommandBufferInheritanceViewportScissorInfoNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV const &
                            commandBufferInheritanceViewportScissorInfoNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, commandBufferInheritanceViewportScissorInfoNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, commandBufferInheritanceViewportScissorInfoNV.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, commandBufferInheritanceViewportScissorInfoNV.viewportScissor2D );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, commandBufferInheritanceViewportScissorInfoNV.viewportDepthCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::Viewport *, seed, commandBufferInheritanceViewportScissorInfoNV.pViewportDepths );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CommandBufferSubmitInfoKHR
  {
    using NativeType = VkCommandBufferSubmitInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferSubmitInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferSubmitInfoKHR( VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer_ = {},
                                                     uint32_t deviceMask_ = {} ) VULKAN_HPP_NOEXCEPT
      : commandBuffer( commandBuffer_ )
      , deviceMask( deviceMask_ )
    {}

    VULKAN_HPP_CONSTEXPR
      CommandBufferSubmitInfoKHR( CommandBufferSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferSubmitInfoKHR( VkCommandBufferSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferSubmitInfoKHR( *reinterpret_cast<CommandBufferSubmitInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferSubmitInfoKHR & operator=( CommandBufferSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferSubmitInfoKHR & operator=( VkCommandBufferSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfoKHR &
                            setCommandBuffer( VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBuffer = commandBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfoKHR & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandBufferSubmitInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferSubmitInfoKHR *>( this );
    }

    operator VkCommandBufferSubmitInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferSubmitInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferSubmitInfoKHR const & ) const = default;
#else
    bool operator==( CommandBufferSubmitInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandBuffer == rhs.commandBuffer ) &&
             ( deviceMask == rhs.deviceMask );
    }

    bool operator!=( CommandBufferSubmitInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eCommandBufferSubmitInfoKHR;
    const void *                        pNext         = {};
    VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer = {};
    uint32_t                            deviceMask    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfoKHR ) ==
                              sizeof( VkCommandBufferSubmitInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfoKHR>::value,
                            "CommandBufferSubmitInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferSubmitInfoKHR>
  {
    using Type = CommandBufferSubmitInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfoKHR const & commandBufferSubmitInfoKHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, commandBufferSubmitInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, commandBufferSubmitInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::CommandBuffer, seed, commandBufferSubmitInfoKHR.commandBuffer );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, commandBufferSubmitInfoKHR.deviceMask );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CommandPoolCreateInfo
  {
    using NativeType = VkCommandPoolCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandPoolCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandPoolCreateInfo( VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags_ = {},
                                                uint32_t queueFamilyIndex_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , queueFamilyIndex( queueFamilyIndex_ )
    {}

    VULKAN_HPP_CONSTEXPR CommandPoolCreateInfo( CommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandPoolCreateInfo( VkCommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandPoolCreateInfo( *reinterpret_cast<CommandPoolCreateInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandPoolCreateInfo & operator=( CommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandPoolCreateInfo & operator=( VkCommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo &
                            setQueueFamilyIndex( uint32_t queueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndex = queueFamilyIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCommandPoolCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandPoolCreateInfo *>( this );
    }

    operator VkCommandPoolCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandPoolCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandPoolCreateInfo const & ) const = default;
#else
    bool operator==( CommandPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( queueFamilyIndex == rhs.queueFamilyIndex );
    }

    bool operator!=( CommandPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType            = StructureType::eCommandPoolCreateInfo;
    const void *                                 pNext            = {};
    VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags            = {};
    uint32_t                                     queueFamilyIndex = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo ) == sizeof( VkCommandPoolCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo>::value,
                            "CommandPoolCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandPoolCreateInfo>
  {
    using Type = CommandPoolCreateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo const & commandPoolCreateInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, commandPoolCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, commandPoolCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags, seed, commandPoolCreateInfo.flags );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, commandPoolCreateInfo.queueFamilyIndex );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct SpecializationMapEntry
  {
    using NativeType = VkSpecializationMapEntry;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      SpecializationMapEntry( uint32_t constantID_ = {}, uint32_t offset_ = {}, size_t size_ = {} ) VULKAN_HPP_NOEXCEPT
      : constantID( constantID_ )
      , offset( offset_ )
      , size( size_ )
    {}

    VULKAN_HPP_CONSTEXPR SpecializationMapEntry( SpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationMapEntry( VkSpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT
      : SpecializationMapEntry( *reinterpret_cast<SpecializationMapEntry const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SpecializationMapEntry & operator=( SpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationMapEntry & operator=( VkSpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SpecializationMapEntry const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setConstantID( uint32_t constantID_ ) VULKAN_HPP_NOEXCEPT
    {
      constantID = constantID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setOffset( uint32_t offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setSize( size_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSpecializationMapEntry const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSpecializationMapEntry *>( this );
    }

    operator VkSpecializationMapEntry &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSpecializationMapEntry *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SpecializationMapEntry const & ) const = default;
#else
    bool operator==( SpecializationMapEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( constantID == rhs.constantID ) && ( offset == rhs.offset ) && ( size == rhs.size );
    }

    bool operator!=( SpecializationMapEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t constantID = {};
    uint32_t offset     = {};
    size_t   size       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SpecializationMapEntry ) ==
                              sizeof( VkSpecializationMapEntry ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SpecializationMapEntry>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SpecializationMapEntry>::value,
                            "SpecializationMapEntry is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SpecializationMapEntry>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::SpecializationMapEntry const & specializationMapEntry ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, specializationMapEntry.constantID );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, specializationMapEntry.offset );
    VULKAN_HPP_HASH_COMBINE( size_t, seed, specializationMapEntry.size );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct SpecializationInfo
  {
    using NativeType = VkSpecializationInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SpecializationInfo( uint32_t                                             mapEntryCount_ = {},
                                             const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries_   = {},
                                             size_t                                               dataSize_      = {},
                                             const void * pData_ = {} ) VULKAN_HPP_NOEXCEPT
      : mapEntryCount( mapEntryCount_ )
      , pMapEntries( pMapEntries_ )
      , dataSize( dataSize_ )
      , pData( pData_ )
    {}

    VULKAN_HPP_CONSTEXPR SpecializationInfo( SpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationInfo( VkSpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SpecializationInfo( *reinterpret_cast<SpecializationInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    SpecializationInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<
                          const VULKAN_HPP_NAMESPACE::SpecializationMapEntry> const &  mapEntries_,
                        VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_ = {} )
      : mapEntryCount( static_cast<uint32_t>( mapEntries_.size() ) )
      , pMapEntries( mapEntries_.data() )
      , dataSize( data_.size() * sizeof( T ) )
      , pData( data_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SpecializationInfo & operator=( SpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationInfo & operator=( VkSpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SpecializationInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setMapEntryCount( uint32_t mapEntryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      mapEntryCount = mapEntryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo &
      setPMapEntries( const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      pMapEntries = pMapEntries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SpecializationInfo & setMapEntries(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SpecializationMapEntry> const &
        mapEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      mapEntryCount = static_cast<uint32_t>( mapEntries_.size() );
      pMapEntries   = mapEntries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setDataSize( size_t dataSize_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = dataSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setPData( const void * pData_ ) VULKAN_HPP_NOEXCEPT
    {
      pData = pData_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    SpecializationInfo &
      setData( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = data_.size() * sizeof( T );
      pData    = data_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkSpecializationInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSpecializationInfo *>( this );
    }

    operator VkSpecializationInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSpecializationInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SpecializationInfo const & ) const = default;
#else
    bool operator==( SpecializationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( mapEntryCount == rhs.mapEntryCount ) && ( pMapEntries == rhs.pMapEntries ) &&
             ( dataSize == rhs.dataSize ) && ( pData == rhs.pData );
    }

    bool operator!=( SpecializationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                             mapEntryCount = {};
    const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries   = {};
    size_t                                               dataSize      = {};
    const void *                                         pData         = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SpecializationInfo ) == sizeof( VkSpecializationInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SpecializationInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SpecializationInfo>::value,
                            "SpecializationInfo is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::SpecializationInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::SpecializationInfo const & specializationInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, specializationInfo.mapEntryCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::SpecializationMapEntry *, seed, specializationInfo.pMapEntries );
    VULKAN_HPP_HASH_COMBINE( size_t, seed, specializationInfo.dataSize );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, specializationInfo.pData );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct PipelineShaderStageCreateInfo
  {
    using NativeType = VkPipelineShaderStageCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineShaderStageCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineShaderStageCreateInfo(
      VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags_  = {},
      VULKAN_HPP_NAMESPACE::ShaderStageFlagBits            stage_  = VULKAN_HPP_NAMESPACE::ShaderStageFlagBits::eVertex,
      VULKAN_HPP_NAMESPACE::ShaderModule                   module_ = {},
      const char *                                         pName_  = {},
      const VULKAN_HPP_NAMESPACE::SpecializationInfo *     pSpecializationInfo_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , stage( stage_ )
      , module( module_ )
      , pName( pName_ )
      , pSpecializationInfo( pSpecializationInfo_ )
    {}

    VULKAN_HPP_CONSTEXPR
      PipelineShaderStageCreateInfo( PipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineShaderStageCreateInfo( VkPipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineShaderStageCreateInfo( *reinterpret_cast<PipelineShaderStageCreateInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineShaderStageCreateInfo &
      operator=( PipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineShaderStageCreateInfo & operator=( VkPipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo &
                            setStage( VULKAN_HPP_NAMESPACE::ShaderStageFlagBits stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo &
                            setModule( VULKAN_HPP_NAMESPACE::ShaderModule module_ ) VULKAN_HPP_NOEXCEPT
    {
      module = module_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPName( const char * pName_ ) VULKAN_HPP_NOEXCEPT
    {
      pName = pName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPSpecializationInfo(
      const VULKAN_HPP_NAMESPACE::SpecializationInfo * pSpecializationInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pSpecializationInfo = pSpecializationInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPipelineShaderStageCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineShaderStageCreateInfo *>( this );
    }

    operator VkPipelineShaderStageCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineShaderStageCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PipelineShaderStageCreateInfo const & ) const = default;
#else
    bool operator==( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stage == rhs.stage ) &&
             ( module == rhs.module ) && ( pName == rhs.pName ) && ( pSpecializationInfo == rhs.pSpecializationInfo );
    }

    bool operator!=( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType  = StructureType::ePipelineShaderStageCreateInfo;
    const void *                                         pNext  = {};
    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags  = {};
    VULKAN_HPP_NAMESPACE::ShaderStageFlagBits            stage  = VULKAN_HPP_NAMESPACE::ShaderStageFlagBits::eVertex;
    VULKAN_HPP_NAMESPACE::ShaderModule                   module = {};
    const char *                                         pName  = {};
    const VULKAN_HPP_NAMESPACE::SpecializationInfo *     pSpecializationInfo = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo ) ==
                              sizeof( VkPipelineShaderStageCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo>::value,
    "PipelineShaderStageCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::ePipelineShaderStageCreateInfo>
  {
    using Type = PipelineShaderStageCreateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const & pipelineShaderStageCreateInfo )
    const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, pipelineShaderStageCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, pipelineShaderStageCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags, seed, pipelineShaderStageCreateInfo.flags );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ShaderStageFlagBits, seed, pipelineShaderStageCreateInfo.stage );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ShaderModule, seed, pipelineShaderStageCreateInfo.module );
    VULKAN_HPP_HASH_COMBINE( const char *, seed, pipelineShaderStageCreateInfo.pName );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::SpecializationInfo *, seed, pipelineShaderStageCreateInfo.pSpecializationInfo );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct ComputePipelineCreateInfo
  {
    using NativeType = VkComputePipelineCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eComputePipelineCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComputePipelineCreateInfo( VULKAN_HPP_NAMESPACE::PipelineCreateFlags           flags_  = {},
                                                    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo stage_  = {},
                                                    VULKAN_HPP_NAMESPACE::PipelineLayout                layout_ = {},
                                                    VULKAN_HPP_NAMESPACE::Pipeline basePipelineHandle_          = {},
                                                    int32_t basePipelineIndex_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , stage( stage_ )
      , layout( layout_ )
      , basePipelineHandle( basePipelineHandle_ )
      , basePipelineIndex( basePipelineIndex_ )
    {}

    VULKAN_HPP_CONSTEXPR
      ComputePipelineCreateInfo( ComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComputePipelineCreateInfo( VkComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ComputePipelineCreateInfo( *reinterpret_cast<ComputePipelineCreateInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ComputePipelineCreateInfo & operator=( ComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComputePipelineCreateInfo & operator=( VkComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::PipelineCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo &
      setStage( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const & stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo &
                            setLayout( VULKAN_HPP_NAMESPACE::PipelineLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo &
      setBasePipelineHandle( VULKAN_HPP_NAMESPACE::Pipeline basePipelineHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineHandle = basePipelineHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo &
                            setBasePipelineIndex( int32_t basePipelineIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineIndex = basePipelineIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkComputePipelineCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComputePipelineCreateInfo *>( this );
    }

    operator VkComputePipelineCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComputePipelineCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComputePipelineCreateInfo const & ) const = default;
#else
    bool operator==( ComputePipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stage == rhs.stage ) &&
             ( layout == rhs.layout ) && ( basePipelineHandle == rhs.basePipelineHandle ) &&
             ( basePipelineIndex == rhs.basePipelineIndex );
    }

    bool operator!=( ComputePipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                 sType              = StructureType::eComputePipelineCreateInfo;
    const void *                                        pNext              = {};
    VULKAN_HPP_NAMESPACE::PipelineCreateFlags           flags              = {};
    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo stage              = {};
    VULKAN_HPP_NAMESPACE::PipelineLayout                layout             = {};
    VULKAN_HPP_NAMESPACE::Pipeline                      basePipelineHandle = {};
    int32_t                                             basePipelineIndex  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo ) ==
                              sizeof( VkComputePipelineCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo>::value,
                            "ComputePipelineCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eComputePipelineCreateInfo>
  {
    using Type = ComputePipelineCreateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo const & computePipelineCreateInfo ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, computePipelineCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, computePipelineCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::PipelineCreateFlags, seed, computePipelineCreateInfo.flags );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo, seed, computePipelineCreateInfo.stage );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::PipelineLayout, seed, computePipelineCreateInfo.layout );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Pipeline, seed, computePipelineCreateInfo.basePipelineHandle );
    VULKAN_HPP_HASH_COMBINE( int32_t, seed, computePipelineCreateInfo.basePipelineIndex );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct ConditionalRenderingBeginInfoEXT
  {
    using NativeType = VkConditionalRenderingBeginInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType = StructureType::eConditionalRenderingBeginInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ConditionalRenderingBeginInfoEXT(
      VULKAN_HPP_NAMESPACE::Buffer                       buffer_ = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                   offset_ = {},
      VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT flags_  = {} ) VULKAN_HPP_NOEXCEPT
      : buffer( buffer_ )
      , offset( offset_ )
      , flags( flags_ )
    {}

    VULKAN_HPP_CONSTEXPR
      ConditionalRenderingBeginInfoEXT( ConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConditionalRenderingBeginInfoEXT( VkConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ConditionalRenderingBeginInfoEXT( *reinterpret_cast<ConditionalRenderingBeginInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ConditionalRenderingBeginInfoEXT &
      operator=( ConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConditionalRenderingBeginInfoEXT & operator=( VkConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT &
                            setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT &
                            setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT &
                            setFlags( VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkConditionalRenderingBeginInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConditionalRenderingBeginInfoEXT *>( this );
    }

    operator VkConditionalRenderingBeginInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConditionalRenderingBeginInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ConditionalRenderingBeginInfoEXT const & ) const = default;
#else
    bool operator==( ConditionalRenderingBeginInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) &&
             ( flags == rhs.flags );
    }

    bool operator!=( ConditionalRenderingBeginInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType  = StructureType::eConditionalRenderingBeginInfoEXT;
    const void *                                       pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer                       buffer = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                   offset = {};
    VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT flags  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT ) ==
                              sizeof( VkConditionalRenderingBeginInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT>::value,
    "ConditionalRenderingBeginInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eConditionalRenderingBeginInfoEXT>
  {
    using Type = ConditionalRenderingBeginInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT const & conditionalRenderingBeginInfoEXT ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, conditionalRenderingBeginInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, conditionalRenderingBeginInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, conditionalRenderingBeginInfoEXT.buffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, conditionalRenderingBeginInfoEXT.offset );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT, seed, conditionalRenderingBeginInfoEXT.flags );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct ConformanceVersion
  {
    using NativeType = VkConformanceVersion;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ConformanceVersion( uint8_t major_    = {},
                                             uint8_t minor_    = {},
                                             uint8_t subminor_ = {},
                                             uint8_t patch_    = {} ) VULKAN_HPP_NOEXCEPT
      : major( major_ )
      , minor( minor_ )
      , subminor( subminor_ )
      , patch( patch_ )
    {}

    VULKAN_HPP_CONSTEXPR ConformanceVersion( ConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConformanceVersion( VkConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT
      : ConformanceVersion( *reinterpret_cast<ConformanceVersion const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ConformanceVersion & operator=( ConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConformanceVersion & operator=( VkConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ConformanceVersion const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setMajor( uint8_t major_ ) VULKAN_HPP_NOEXCEPT
    {
      major = major_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setMinor( uint8_t minor_ ) VULKAN_HPP_NOEXCEPT
    {
      minor = minor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setSubminor( uint8_t subminor_ ) VULKAN_HPP_NOEXCEPT
    {
      subminor = subminor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setPatch( uint8_t patch_ ) VULKAN_HPP_NOEXCEPT
    {
      patch = patch_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkConformanceVersion const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConformanceVersion *>( this );
    }

    operator VkConformanceVersion &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConformanceVersion *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ConformanceVersion const & ) const = default;
#else
    bool operator==( ConformanceVersion const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( major == rhs.major ) && ( minor == rhs.minor ) && ( subminor == rhs.subminor ) && ( patch == rhs.patch );
    }

    bool operator!=( ConformanceVersion const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint8_t major    = {};
    uint8_t minor    = {};
    uint8_t subminor = {};
    uint8_t patch    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ConformanceVersion ) == sizeof( VkConformanceVersion ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ConformanceVersion>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ConformanceVersion>::value,
                            "ConformanceVersion is not nothrow_move_constructible!" );
  using ConformanceVersionKHR = ConformanceVersion;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ConformanceVersion>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::ConformanceVersion const & conformanceVersion ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint8_t, seed, conformanceVersion.major );
    VULKAN_HPP_HASH_COMBINE( uint8_t, seed, conformanceVersion.minor );
    VULKAN_HPP_HASH_COMBINE( uint8_t, seed, conformanceVersion.subminor );
    VULKAN_HPP_HASH_COMBINE( uint8_t, seed, conformanceVersion.patch );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CooperativeMatrixPropertiesNV
  {
    using NativeType = VkCooperativeMatrixPropertiesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCooperativeMatrixPropertiesNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesNV(
      uint32_t                              MSize_ = {},
      uint32_t                              NSize_ = {},
      uint32_t                              KSize_ = {},
      VULKAN_HPP_NAMESPACE::ComponentTypeNV AType_ = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16,
      VULKAN_HPP_NAMESPACE::ComponentTypeNV BType_ = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16,
      VULKAN_HPP_NAMESPACE::ComponentTypeNV CType_ = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16,
      VULKAN_HPP_NAMESPACE::ComponentTypeNV DType_ = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16,
      VULKAN_HPP_NAMESPACE::ScopeNV         scope_ = VULKAN_HPP_NAMESPACE::ScopeNV::eDevice ) VULKAN_HPP_NOEXCEPT
      : MSize( MSize_ )
      , NSize( NSize_ )
      , KSize( KSize_ )
      , AType( AType_ )
      , BType( BType_ )
      , CType( CType_ )
      , DType( DType_ )
      , scope( scope_ )
    {}

    VULKAN_HPP_CONSTEXPR
      CooperativeMatrixPropertiesNV( CooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeMatrixPropertiesNV( VkCooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CooperativeMatrixPropertiesNV( *reinterpret_cast<CooperativeMatrixPropertiesNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CooperativeMatrixPropertiesNV &
      operator=( CooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeMatrixPropertiesNV & operator=( VkCooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setMSize( uint32_t MSize_ ) VULKAN_HPP_NOEXCEPT
    {
      MSize = MSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setNSize( uint32_t NSize_ ) VULKAN_HPP_NOEXCEPT
    {
      NSize = NSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setKSize( uint32_t KSize_ ) VULKAN_HPP_NOEXCEPT
    {
      KSize = KSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV &
                            setAType( VULKAN_HPP_NAMESPACE::ComponentTypeNV AType_ ) VULKAN_HPP_NOEXCEPT
    {
      AType = AType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV &
                            setBType( VULKAN_HPP_NAMESPACE::ComponentTypeNV BType_ ) VULKAN_HPP_NOEXCEPT
    {
      BType = BType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV &
                            setCType( VULKAN_HPP_NAMESPACE::ComponentTypeNV CType_ ) VULKAN_HPP_NOEXCEPT
    {
      CType = CType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV &
                            setDType( VULKAN_HPP_NAMESPACE::ComponentTypeNV DType_ ) VULKAN_HPP_NOEXCEPT
    {
      DType = DType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV &
                            setScope( VULKAN_HPP_NAMESPACE::ScopeNV scope_ ) VULKAN_HPP_NOEXCEPT
    {
      scope = scope_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCooperativeMatrixPropertiesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCooperativeMatrixPropertiesNV *>( this );
    }

    operator VkCooperativeMatrixPropertiesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCooperativeMatrixPropertiesNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CooperativeMatrixPropertiesNV const & ) const = default;
#else
    bool operator==( CooperativeMatrixPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( MSize == rhs.MSize ) && ( NSize == rhs.NSize ) &&
             ( KSize == rhs.KSize ) && ( AType == rhs.AType ) && ( BType == rhs.BType ) && ( CType == rhs.CType ) &&
             ( DType == rhs.DType ) && ( scope == rhs.scope );
    }

    bool operator!=( CooperativeMatrixPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType   sType = StructureType::eCooperativeMatrixPropertiesNV;
    void *                                pNext = {};
    uint32_t                              MSize = {};
    uint32_t                              NSize = {};
    uint32_t                              KSize = {};
    VULKAN_HPP_NAMESPACE::ComponentTypeNV AType = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeNV BType = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeNV CType = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeNV DType = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16;
    VULKAN_HPP_NAMESPACE::ScopeNV         scope = VULKAN_HPP_NAMESPACE::ScopeNV::eDevice;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV ) ==
                              sizeof( VkCooperativeMatrixPropertiesNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV>::value,
    "CooperativeMatrixPropertiesNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCooperativeMatrixPropertiesNV>
  {
    using Type = CooperativeMatrixPropertiesNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV const & cooperativeMatrixPropertiesNV )
    const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, cooperativeMatrixPropertiesNV.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, cooperativeMatrixPropertiesNV.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, cooperativeMatrixPropertiesNV.MSize );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, cooperativeMatrixPropertiesNV.NSize );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, cooperativeMatrixPropertiesNV.KSize );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentTypeNV, seed, cooperativeMatrixPropertiesNV.AType );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentTypeNV, seed, cooperativeMatrixPropertiesNV.BType );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentTypeNV, seed, cooperativeMatrixPropertiesNV.CType );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ComponentTypeNV, seed, cooperativeMatrixPropertiesNV.DType );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ScopeNV, seed, cooperativeMatrixPropertiesNV.scope );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CopyAccelerationStructureInfoKHR
  {
    using NativeType = VkCopyAccelerationStructureInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType = StructureType::eCopyAccelerationStructureInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyAccelerationStructureInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src_ = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst_ = {},
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ =
        VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone ) VULKAN_HPP_NOEXCEPT
      : src( src_ )
      , dst( dst_ )
      , mode( mode_ )
    {}

    VULKAN_HPP_CONSTEXPR
      CopyAccelerationStructureInfoKHR( CopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureInfoKHR( VkCopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyAccelerationStructureInfoKHR( *reinterpret_cast<CopyAccelerationStructureInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyAccelerationStructureInfoKHR &
      operator=( CopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureInfoKHR & operator=( VkCopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR &
                            setSrc( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR &
                            setDst( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR &
                            setMode( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyAccelerationStructureInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyAccelerationStructureInfoKHR *>( this );
    }

    operator VkCopyAccelerationStructureInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyAccelerationStructureInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyAccelerationStructureInfoKHR const & ) const = default;
#else
    bool operator==( CopyAccelerationStructureInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( src == rhs.src ) && ( dst == rhs.dst ) &&
             ( mode == rhs.mode );
    }

    bool operator!=( CopyAccelerationStructureInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType = StructureType::eCopyAccelerationStructureInfoKHR;
    const void *                                           pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src   = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst   = {};
    VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode =
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR ) ==
                              sizeof( VkCopyAccelerationStructureInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR>::value,
    "CopyAccelerationStructureInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyAccelerationStructureInfoKHR>
  {
    using Type = CopyAccelerationStructureInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR const & copyAccelerationStructureInfoKHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, copyAccelerationStructureInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, copyAccelerationStructureInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR, seed, copyAccelerationStructureInfoKHR.src );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR, seed, copyAccelerationStructureInfoKHR.dst );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR, seed, copyAccelerationStructureInfoKHR.mode );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CopyAccelerationStructureToMemoryInfoKHR
  {
    using NativeType = VkCopyAccelerationStructureToMemoryInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eCopyAccelerationStructureToMemoryInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src_ = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR           dst_ = {},
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ =
        VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone ) VULKAN_HPP_NOEXCEPT
      : src( src_ )
      , dst( dst_ )
      , mode( mode_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR(
      CopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureToMemoryInfoKHR( VkCopyAccelerationStructureToMemoryInfoKHR const & rhs )
      VULKAN_HPP_NOEXCEPT
      : CopyAccelerationStructureToMemoryInfoKHR(
          *reinterpret_cast<CopyAccelerationStructureToMemoryInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyAccelerationStructureToMemoryInfoKHR &
      operator=( CopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureToMemoryInfoKHR &
      operator=( VkCopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureToMemoryInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR &
                            setSrc( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR &
                            setDst( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const & dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR &
                            setMode( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyAccelerationStructureToMemoryInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyAccelerationStructureToMemoryInfoKHR *>( this );
    }

    operator VkCopyAccelerationStructureToMemoryInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyAccelerationStructureToMemoryInfoKHR *>( this );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType = StructureType::eCopyAccelerationStructureToMemoryInfoKHR;
    const void *                                   pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR src   = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR   dst   = {};
    VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode =
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureToMemoryInfoKHR ) ==
                              sizeof( VkCopyAccelerationStructureToMemoryInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureToMemoryInfoKHR>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureToMemoryInfoKHR>::value,
    "CopyAccelerationStructureToMemoryInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyAccelerationStructureToMemoryInfoKHR>
  {
    using Type = CopyAccelerationStructureToMemoryInfoKHR;
  };

  struct CopyBufferInfo2KHR
  {
    using NativeType = VkCopyBufferInfo2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyBufferInfo2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CopyBufferInfo2KHR( VULKAN_HPP_NAMESPACE::Buffer                 srcBuffer_   = {},
                          VULKAN_HPP_NAMESPACE::Buffer                 dstBuffer_   = {},
                          uint32_t                                     regionCount_ = {},
                          const VULKAN_HPP_NAMESPACE::BufferCopy2KHR * pRegions_    = {} ) VULKAN_HPP_NOEXCEPT
      : srcBuffer( srcBuffer_ )
      , dstBuffer( dstBuffer_ )
      , regionCount( regionCount_ )
      , pRegions( pRegions_ )
    {}

    VULKAN_HPP_CONSTEXPR CopyBufferInfo2KHR( CopyBufferInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferInfo2KHR( VkCopyBufferInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyBufferInfo2KHR( *reinterpret_cast<CopyBufferInfo2KHR const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferInfo2KHR(
      VULKAN_HPP_NAMESPACE::Buffer                                                                      srcBuffer_,
      VULKAN_HPP_NAMESPACE::Buffer                                                                      dstBuffer_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferCopy2KHR> const & regions_ )
      : srcBuffer( srcBuffer_ )
      , dstBuffer( dstBuffer_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyBufferInfo2KHR & operator=( CopyBufferInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferInfo2KHR & operator=( VkCopyBufferInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyBufferInfo2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2KHR &
                            setSrcBuffer( VULKAN_HPP_NAMESPACE::Buffer srcBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBuffer = srcBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2KHR &
                            setDstBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBuffer = dstBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2KHR & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2KHR &
                            setPRegions( const VULKAN_HPP_NAMESPACE::BufferCopy2KHR * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferInfo2KHR & setRegions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferCopy2KHR> const & regions_ )
      VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyBufferInfo2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyBufferInfo2KHR *>( this );
    }

    operator VkCopyBufferInfo2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyBufferInfo2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyBufferInfo2KHR const & ) const = default;
#else
    bool operator==( CopyBufferInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcBuffer == rhs.srcBuffer ) &&
             ( dstBuffer == rhs.dstBuffer ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
    }

    bool operator!=( CopyBufferInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType       = StructureType::eCopyBufferInfo2KHR;
    const void *                                 pNext       = {};
    VULKAN_HPP_NAMESPACE::Buffer                 srcBuffer   = {};
    VULKAN_HPP_NAMESPACE::Buffer                 dstBuffer   = {};
    uint32_t                                     regionCount = {};
    const VULKAN_HPP_NAMESPACE::BufferCopy2KHR * pRegions    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyBufferInfo2KHR ) == sizeof( VkCopyBufferInfo2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyBufferInfo2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyBufferInfo2KHR>::value,
                            "CopyBufferInfo2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyBufferInfo2KHR>
  {
    using Type = CopyBufferInfo2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CopyBufferInfo2KHR>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::CopyBufferInfo2KHR const & copyBufferInfo2KHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, copyBufferInfo2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, copyBufferInfo2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, copyBufferInfo2KHR.srcBuffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, copyBufferInfo2KHR.dstBuffer );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, copyBufferInfo2KHR.regionCount );
    VULKAN_HPP_HASH_COMBINE( const VULKAN_HPP_NAMESPACE::BufferCopy2KHR *, seed, copyBufferInfo2KHR.pRegions );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CopyBufferToImageInfo2KHR
  {
    using NativeType = VkCopyBufferToImageInfo2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyBufferToImageInfo2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyBufferToImageInfo2KHR(
      VULKAN_HPP_NAMESPACE::Buffer                      srcBuffer_      = {},
      VULKAN_HPP_NAMESPACE::Image                       dstImage_       = {},
      VULKAN_HPP_NAMESPACE::ImageLayout                 dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      uint32_t                                          regionCount_    = {},
      const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR * pRegions_       = {} ) VULKAN_HPP_NOEXCEPT
      : srcBuffer( srcBuffer_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( regionCount_ )
      , pRegions( pRegions_ )
    {}

    VULKAN_HPP_CONSTEXPR
      CopyBufferToImageInfo2KHR( CopyBufferToImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferToImageInfo2KHR( VkCopyBufferToImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyBufferToImageInfo2KHR( *reinterpret_cast<CopyBufferToImageInfo2KHR const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferToImageInfo2KHR(
      VULKAN_HPP_NAMESPACE::Buffer      srcBuffer_,
      VULKAN_HPP_NAMESPACE::Image       dstImage_,
      VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR> const & regions_ )
      : srcBuffer( srcBuffer_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyBufferToImageInfo2KHR & operator=( CopyBufferToImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferToImageInfo2KHR & operator=( VkCopyBufferToImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2KHR &
                            setSrcBuffer( VULKAN_HPP_NAMESPACE::Buffer srcBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBuffer = srcBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2KHR &
                            setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2KHR &
                            setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2KHR & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2KHR &
      setPRegions( const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferToImageInfo2KHR & setRegions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR> const & regions_ )
      VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyBufferToImageInfo2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyBufferToImageInfo2KHR *>( this );
    }

    operator VkCopyBufferToImageInfo2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyBufferToImageInfo2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyBufferToImageInfo2KHR const & ) const = default;
#else
    bool operator==( CopyBufferToImageInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcBuffer == rhs.srcBuffer ) &&
             ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) &&
             ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
    }

    bool operator!=( CopyBufferToImageInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType          = StructureType::eCopyBufferToImageInfo2KHR;
    const void *                                      pNext          = {};
    VULKAN_HPP_NAMESPACE::Buffer                      srcBuffer      = {};
    VULKAN_HPP_NAMESPACE::Image                       dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout                 dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                          regionCount    = {};
    const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR * pRegions       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2KHR ) ==
                              sizeof( VkCopyBufferToImageInfo2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2KHR>::value,
                            "CopyBufferToImageInfo2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyBufferToImageInfo2KHR>
  {
    using Type = CopyBufferToImageInfo2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2KHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2KHR const & copyBufferToImageInfo2KHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, copyBufferToImageInfo2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, copyBufferToImageInfo2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, copyBufferToImageInfo2KHR.srcBuffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, copyBufferToImageInfo2KHR.dstImage );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, copyBufferToImageInfo2KHR.dstImageLayout );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, copyBufferToImageInfo2KHR.regionCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR *, seed, copyBufferToImageInfo2KHR.pRegions );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CopyCommandTransformInfoQCOM
  {
    using NativeType = VkCopyCommandTransformInfoQCOM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyCommandTransformInfoQCOM;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CopyCommandTransformInfoQCOM( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ =
                                      VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity ) VULKAN_HPP_NOEXCEPT
      : transform( transform_ )
    {}

    VULKAN_HPP_CONSTEXPR
      CopyCommandTransformInfoQCOM( CopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyCommandTransformInfoQCOM( VkCopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyCommandTransformInfoQCOM( *reinterpret_cast<CopyCommandTransformInfoQCOM const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyCommandTransformInfoQCOM & operator=( CopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyCommandTransformInfoQCOM & operator=( VkCopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyCommandTransformInfoQCOM & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyCommandTransformInfoQCOM &
      setTransform( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyCommandTransformInfoQCOM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyCommandTransformInfoQCOM *>( this );
    }

    operator VkCopyCommandTransformInfoQCOM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyCommandTransformInfoQCOM *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyCommandTransformInfoQCOM const & ) const = default;
#else
    bool operator==( CopyCommandTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( transform == rhs.transform );
    }

    bool operator!=( CopyCommandTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType = StructureType::eCopyCommandTransformInfoQCOM;
    const void *                                      pNext = {};
    VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform =
      VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM ) ==
                              sizeof( VkCopyCommandTransformInfoQCOM ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM>::value,
    "CopyCommandTransformInfoQCOM is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyCommandTransformInfoQCOM>
  {
    using Type = CopyCommandTransformInfoQCOM;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM>
{
  std::size_t operator()(
    VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM const & copyCommandTransformInfoQCOM ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, copyCommandTransformInfoQCOM.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, copyCommandTransformInfoQCOM.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR, seed, copyCommandTransformInfoQCOM.transform );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CopyDescriptorSet
  {
    using NativeType = VkCopyDescriptorSet;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyDescriptorSet;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyDescriptorSet( VULKAN_HPP_NAMESPACE::DescriptorSet srcSet_          = {},
                                            uint32_t                            srcBinding_      = {},
                                            uint32_t                            srcArrayElement_ = {},
                                            VULKAN_HPP_NAMESPACE::DescriptorSet dstSet_          = {},
                                            uint32_t                            dstBinding_      = {},
                                            uint32_t                            dstArrayElement_ = {},
                                            uint32_t descriptorCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : srcSet( srcSet_ )
      , srcBinding( srcBinding_ )
      , srcArrayElement( srcArrayElement_ )
      , dstSet( dstSet_ )
      , dstBinding( dstBinding_ )
      , dstArrayElement( dstArrayElement_ )
      , descriptorCount( descriptorCount_ )
    {}

    VULKAN_HPP_CONSTEXPR CopyDescriptorSet( CopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyDescriptorSet( VkCopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyDescriptorSet( *reinterpret_cast<CopyDescriptorSet const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyDescriptorSet & operator=( CopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyDescriptorSet & operator=( VkCopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyDescriptorSet const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet &
                            setSrcSet( VULKAN_HPP_NAMESPACE::DescriptorSet srcSet_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSet = srcSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcBinding( uint32_t srcBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBinding = srcBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcArrayElement( uint32_t srcArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      srcArrayElement = srcArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet &
                            setDstSet( VULKAN_HPP_NAMESPACE::DescriptorSet dstSet_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSet = dstSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstBinding( uint32_t dstBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBinding = dstBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstArrayElement( uint32_t dstArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      dstArrayElement = dstArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyDescriptorSet const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyDescriptorSet *>( this );
    }

    operator VkCopyDescriptorSet &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyDescriptorSet *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyDescriptorSet const & ) const = default;
#else
    bool operator==( CopyDescriptorSet const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSet == rhs.srcSet ) &&
             ( srcBinding == rhs.srcBinding ) && ( srcArrayElement == rhs.srcArrayElement ) &&
             ( dstSet == rhs.dstSet ) && ( dstBinding == rhs.dstBinding ) &&
             ( dstArrayElement == rhs.dstArrayElement ) && ( descriptorCount == rhs.descriptorCount );
    }

    bool operator!=( CopyDescriptorSet const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eCopyDescriptorSet;
    const void *                        pNext           = {};
    VULKAN_HPP_NAMESPACE::DescriptorSet srcSet          = {};
    uint32_t                            srcBinding      = {};
    uint32_t                            srcArrayElement = {};
    VULKAN_HPP_NAMESPACE::DescriptorSet dstSet          = {};
    uint32_t                            dstBinding      = {};
    uint32_t                            dstArrayElement = {};
    uint32_t                            descriptorCount = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyDescriptorSet ) == sizeof( VkCopyDescriptorSet ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyDescriptorSet>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyDescriptorSet>::value,
                            "CopyDescriptorSet is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyDescriptorSet>
  {
    using Type = CopyDescriptorSet;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CopyDescriptorSet>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CopyDescriptorSet const & copyDescriptorSet ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, copyDescriptorSet.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, copyDescriptorSet.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DescriptorSet, seed, copyDescriptorSet.srcSet );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, copyDescriptorSet.srcBinding );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, copyDescriptorSet.srcArrayElement );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DescriptorSet, seed, copyDescriptorSet.dstSet );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, copyDescriptorSet.dstBinding );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, copyDescriptorSet.dstArrayElement );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, copyDescriptorSet.descriptorCount );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct ImageCopy2KHR
  {
    using NativeType = VkImageCopy2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageCopy2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageCopy2KHR( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource_ = {},
                                        VULKAN_HPP_NAMESPACE::Offset3D               srcOffset_      = {},
                                        VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource_ = {},
                                        VULKAN_HPP_NAMESPACE::Offset3D               dstOffset_      = {},
                                        VULKAN_HPP_NAMESPACE::Extent3D               extent_ = {} ) VULKAN_HPP_NOEXCEPT
      : srcSubresource( srcSubresource_ )
      , srcOffset( srcOffset_ )
      , dstSubresource( dstSubresource_ )
      , dstOffset( dstOffset_ )
      , extent( extent_ )
    {}

    VULKAN_HPP_CONSTEXPR ImageCopy2KHR( ImageCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageCopy2KHR( VkImageCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageCopy2KHR( *reinterpret_cast<ImageCopy2KHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageCopy2KHR & operator=( ImageCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageCopy2KHR & operator=( VkImageCopy2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageCopy2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageCopy2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2KHR &
      setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2KHR &
                            setSrcOffset( VULKAN_HPP_NAMESPACE::Offset3D const & srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2KHR &
      setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2KHR &
                            setDstOffset( VULKAN_HPP_NAMESPACE::Offset3D const & dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2KHR &
                            setExtent( VULKAN_HPP_NAMESPACE::Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageCopy2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageCopy2KHR *>( this );
    }

    operator VkImageCopy2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageCopy2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageCopy2KHR const & ) const = default;
#else
    bool operator==( ImageCopy2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSubresource == rhs.srcSubresource ) &&
             ( srcOffset == rhs.srcOffset ) && ( dstSubresource == rhs.dstSubresource ) &&
             ( dstOffset == rhs.dstOffset ) && ( extent == rhs.extent );
    }

    bool operator!=( ImageCopy2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType          = StructureType::eImageCopy2KHR;
    const void *                                 pNext          = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               srcOffset      = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               dstOffset      = {};
    VULKAN_HPP_NAMESPACE::Extent3D               extent         = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageCopy2KHR ) == sizeof( VkImageCopy2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageCopy2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageCopy2KHR>::value,
                            "ImageCopy2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eImageCopy2KHR>
  {
    using Type = ImageCopy2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ImageCopy2KHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::ImageCopy2KHR const & imageCopy2KHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, imageCopy2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, imageCopy2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers, seed, imageCopy2KHR.srcSubresource );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Offset3D, seed, imageCopy2KHR.srcOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers, seed, imageCopy2KHR.dstSubresource );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Offset3D, seed, imageCopy2KHR.dstOffset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Extent3D, seed, imageCopy2KHR.extent );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CopyImageInfo2KHR
  {
    using NativeType = VkCopyImageInfo2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageInfo2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageInfo2KHR(
      VULKAN_HPP_NAMESPACE::Image                 srcImage_       = {},
      VULKAN_HPP_NAMESPACE::ImageLayout           srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      VULKAN_HPP_NAMESPACE::Image                 dstImage_       = {},
      VULKAN_HPP_NAMESPACE::ImageLayout           dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      uint32_t                                    regionCount_    = {},
      const VULKAN_HPP_NAMESPACE::ImageCopy2KHR * pRegions_       = {} ) VULKAN_HPP_NOEXCEPT
      : srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( regionCount_ )
      , pRegions( pRegions_ )
    {}

    VULKAN_HPP_CONSTEXPR CopyImageInfo2KHR( CopyImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageInfo2KHR( VkCopyImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyImageInfo2KHR( *reinterpret_cast<CopyImageInfo2KHR const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageInfo2KHR(
      VULKAN_HPP_NAMESPACE::Image                                                                      srcImage_,
      VULKAN_HPP_NAMESPACE::ImageLayout                                                                srcImageLayout_,
      VULKAN_HPP_NAMESPACE::Image                                                                      dstImage_,
      VULKAN_HPP_NAMESPACE::ImageLayout                                                                dstImageLayout_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageCopy2KHR> const & regions_ )
      : srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyImageInfo2KHR & operator=( CopyImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageInfo2KHR & operator=( VkCopyImageInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyImageInfo2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2KHR & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2KHR &
                            setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2KHR & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2KHR &
                            setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2KHR & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2KHR &
                            setPRegions( const VULKAN_HPP_NAMESPACE::ImageCopy2KHR * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageInfo2KHR & setRegions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageCopy2KHR> const & regions_ )
      VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyImageInfo2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageInfo2KHR *>( this );
    }

    operator VkCopyImageInfo2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageInfo2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageInfo2KHR const & ) const = default;
#else
    bool operator==( CopyImageInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) &&
             ( srcImageLayout == rhs.srcImageLayout ) && ( dstImage == rhs.dstImage ) &&
             ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) &&
             ( pRegions == rhs.pRegions );
    }

    bool operator!=( CopyImageInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType          = StructureType::eCopyImageInfo2KHR;
    const void *                                pNext          = {};
    VULKAN_HPP_NAMESPACE::Image                 srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout           srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Image                 dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout           dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                    regionCount    = {};
    const VULKAN_HPP_NAMESPACE::ImageCopy2KHR * pRegions       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyImageInfo2KHR ) == sizeof( VkCopyImageInfo2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyImageInfo2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyImageInfo2KHR>::value,
                            "CopyImageInfo2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyImageInfo2KHR>
  {
    using Type = CopyImageInfo2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CopyImageInfo2KHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CopyImageInfo2KHR const & copyImageInfo2KHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, copyImageInfo2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, copyImageInfo2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, copyImageInfo2KHR.srcImage );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, copyImageInfo2KHR.srcImageLayout );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, copyImageInfo2KHR.dstImage );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, copyImageInfo2KHR.dstImageLayout );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, copyImageInfo2KHR.regionCount );
    VULKAN_HPP_HASH_COMBINE( const VULKAN_HPP_NAMESPACE::ImageCopy2KHR *, seed, copyImageInfo2KHR.pRegions );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CopyImageToBufferInfo2KHR
  {
    using NativeType = VkCopyImageToBufferInfo2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageToBufferInfo2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageToBufferInfo2KHR(
      VULKAN_HPP_NAMESPACE::Image                       srcImage_       = {},
      VULKAN_HPP_NAMESPACE::ImageLayout                 srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      VULKAN_HPP_NAMESPACE::Buffer                      dstBuffer_      = {},
      uint32_t                                          regionCount_    = {},
      const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR * pRegions_       = {} ) VULKAN_HPP_NOEXCEPT
      : srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstBuffer( dstBuffer_ )
      , regionCount( regionCount_ )
      , pRegions( pRegions_ )
    {}

    VULKAN_HPP_CONSTEXPR
      CopyImageToBufferInfo2KHR( CopyImageToBufferInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToBufferInfo2KHR( VkCopyImageToBufferInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyImageToBufferInfo2KHR( *reinterpret_cast<CopyImageToBufferInfo2KHR const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToBufferInfo2KHR(
      VULKAN_HPP_NAMESPACE::Image       srcImage_,
      VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_,
      VULKAN_HPP_NAMESPACE::Buffer      dstBuffer_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR> const & regions_ )
      : srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstBuffer( dstBuffer_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyImageToBufferInfo2KHR & operator=( CopyImageToBufferInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToBufferInfo2KHR & operator=( VkCopyImageToBufferInfo2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2KHR &
                            setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2KHR &
                            setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2KHR &
                            setDstBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBuffer = dstBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2KHR & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2KHR &
      setPRegions( const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToBufferInfo2KHR & setRegions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR> const & regions_ )
      VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyImageToBufferInfo2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageToBufferInfo2KHR *>( this );
    }

    operator VkCopyImageToBufferInfo2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageToBufferInfo2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageToBufferInfo2KHR const & ) const = default;
#else
    bool operator==( CopyImageToBufferInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) &&
             ( srcImageLayout == rhs.srcImageLayout ) && ( dstBuffer == rhs.dstBuffer ) &&
             ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
    }

    bool operator!=( CopyImageToBufferInfo2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType          = StructureType::eCopyImageToBufferInfo2KHR;
    const void *                                      pNext          = {};
    VULKAN_HPP_NAMESPACE::Image                       srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout                 srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Buffer                      dstBuffer      = {};
    uint32_t                                          regionCount    = {};
    const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR * pRegions       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2KHR ) ==
                              sizeof( VkCopyImageToBufferInfo2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2KHR>::value,
                            "CopyImageToBufferInfo2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyImageToBufferInfo2KHR>
  {
    using Type = CopyImageToBufferInfo2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2KHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2KHR const & copyImageToBufferInfo2KHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, copyImageToBufferInfo2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, copyImageToBufferInfo2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, copyImageToBufferInfo2KHR.srcImage );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, copyImageToBufferInfo2KHR.srcImageLayout );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, copyImageToBufferInfo2KHR.dstBuffer );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, copyImageToBufferInfo2KHR.regionCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::BufferImageCopy2KHR *, seed, copyImageToBufferInfo2KHR.pRegions );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CopyMemoryToAccelerationStructureInfoKHR
  {
    using NativeType = VkCopyMemoryToAccelerationStructureInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eCopyMemoryToAccelerationStructureInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR(
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      src_ = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst_ = {},
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ =
        VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone ) VULKAN_HPP_NOEXCEPT
      : src( src_ )
      , dst( dst_ )
      , mode( mode_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR(
      CopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToAccelerationStructureInfoKHR( VkCopyMemoryToAccelerationStructureInfoKHR const & rhs )
      VULKAN_HPP_NOEXCEPT
      : CopyMemoryToAccelerationStructureInfoKHR(
          *reinterpret_cast<CopyMemoryToAccelerationStructureInfoKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyMemoryToAccelerationStructureInfoKHR &
      operator=( CopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToAccelerationStructureInfoKHR &
      operator=( VkCopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyMemoryToAccelerationStructureInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR &
                            setSrc( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR &
                            setDst( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR &
                            setMode( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCopyMemoryToAccelerationStructureInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryToAccelerationStructureInfoKHR *>( this );
    }

    operator VkCopyMemoryToAccelerationStructureInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryToAccelerationStructureInfoKHR *>( this );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType = StructureType::eCopyMemoryToAccelerationStructureInfoKHR;
    const void *                                      pNext = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR src   = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR    dst   = {};
    VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode =
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyMemoryToAccelerationStructureInfoKHR ) ==
                              sizeof( VkCopyMemoryToAccelerationStructureInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyMemoryToAccelerationStructureInfoKHR>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyMemoryToAccelerationStructureInfoKHR>::value,
    "CopyMemoryToAccelerationStructureInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyMemoryToAccelerationStructureInfoKHR>
  {
    using Type = CopyMemoryToAccelerationStructureInfoKHR;
  };

  struct CuFunctionCreateInfoNVX
  {
    using NativeType = VkCuFunctionCreateInfoNVX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCuFunctionCreateInfoNVX;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CuFunctionCreateInfoNVX( VULKAN_HPP_NAMESPACE::CuModuleNVX module_ = {},
                                                  const char *                      pName_  = {} ) VULKAN_HPP_NOEXCEPT
      : module( module_ )
      , pName( pName_ )
    {}

    VULKAN_HPP_CONSTEXPR CuFunctionCreateInfoNVX( CuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuFunctionCreateInfoNVX( VkCuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
      : CuFunctionCreateInfoNVX( *reinterpret_cast<CuFunctionCreateInfoNVX const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CuFunctionCreateInfoNVX & operator=( CuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuFunctionCreateInfoNVX & operator=( VkCuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CuFunctionCreateInfoNVX & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuFunctionCreateInfoNVX &
                            setModule( VULKAN_HPP_NAMESPACE::CuModuleNVX module_ ) VULKAN_HPP_NOEXCEPT
    {
      module = module_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuFunctionCreateInfoNVX & setPName( const char * pName_ ) VULKAN_HPP_NOEXCEPT
    {
      pName = pName_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCuFunctionCreateInfoNVX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCuFunctionCreateInfoNVX *>( this );
    }

    operator VkCuFunctionCreateInfoNVX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCuFunctionCreateInfoNVX *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CuFunctionCreateInfoNVX const & ) const = default;
#else
    bool operator==( CuFunctionCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( module == rhs.module ) && ( pName == rhs.pName );
    }

    bool operator!=( CuFunctionCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eCuFunctionCreateInfoNVX;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::CuModuleNVX   module = {};
    const char *                        pName  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX ) ==
                              sizeof( VkCuFunctionCreateInfoNVX ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX>::value,
                            "CuFunctionCreateInfoNVX is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCuFunctionCreateInfoNVX>
  {
    using Type = CuFunctionCreateInfoNVX;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX const & cuFunctionCreateInfoNVX ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, cuFunctionCreateInfoNVX.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, cuFunctionCreateInfoNVX.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::CuModuleNVX, seed, cuFunctionCreateInfoNVX.module );
    VULKAN_HPP_HASH_COMBINE( const char *, seed, cuFunctionCreateInfoNVX.pName );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CuLaunchInfoNVX
  {
    using NativeType = VkCuLaunchInfoNVX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCuLaunchInfoNVX;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CuLaunchInfoNVX( VULKAN_HPP_NAMESPACE::CuFunctionNVX function_       = {},
                                          uint32_t                            gridDimX_       = {},
                                          uint32_t                            gridDimY_       = {},
                                          uint32_t                            gridDimZ_       = {},
                                          uint32_t                            blockDimX_      = {},
                                          uint32_t                            blockDimY_      = {},
                                          uint32_t                            blockDimZ_      = {},
                                          uint32_t                            sharedMemBytes_ = {},
                                          size_t                              paramCount_     = {},
                                          const void * const *                pParams_        = {},
                                          size_t                              extraCount_     = {},
                                          const void * const *                pExtras_        = {} ) VULKAN_HPP_NOEXCEPT
      : function( function_ )
      , gridDimX( gridDimX_ )
      , gridDimY( gridDimY_ )
      , gridDimZ( gridDimZ_ )
      , blockDimX( blockDimX_ )
      , blockDimY( blockDimY_ )
      , blockDimZ( blockDimZ_ )
      , sharedMemBytes( sharedMemBytes_ )
      , paramCount( paramCount_ )
      , pParams( pParams_ )
      , extraCount( extraCount_ )
      , pExtras( pExtras_ )
    {}

    VULKAN_HPP_CONSTEXPR CuLaunchInfoNVX( CuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuLaunchInfoNVX( VkCuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
      : CuLaunchInfoNVX( *reinterpret_cast<CuLaunchInfoNVX const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CuLaunchInfoNVX( VULKAN_HPP_NAMESPACE::CuFunctionNVX                                       function_,
                     uint32_t                                                                  gridDimX_,
                     uint32_t                                                                  gridDimY_,
                     uint32_t                                                                  gridDimZ_,
                     uint32_t                                                                  blockDimX_,
                     uint32_t                                                                  blockDimY_,
                     uint32_t                                                                  blockDimZ_,
                     uint32_t                                                                  sharedMemBytes_,
                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & params_,
                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & extras_ = {} )
      : function( function_ )
      , gridDimX( gridDimX_ )
      , gridDimY( gridDimY_ )
      , gridDimZ( gridDimZ_ )
      , blockDimX( blockDimX_ )
      , blockDimY( blockDimY_ )
      , blockDimZ( blockDimZ_ )
      , sharedMemBytes( sharedMemBytes_ )
      , paramCount( params_.size() )
      , pParams( params_.data() )
      , extraCount( extras_.size() )
      , pExtras( extras_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CuLaunchInfoNVX & operator=( CuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuLaunchInfoNVX & operator=( VkCuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX &
                            setFunction( VULKAN_HPP_NAMESPACE::CuFunctionNVX function_ ) VULKAN_HPP_NOEXCEPT
    {
      function = function_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setGridDimX( uint32_t gridDimX_ ) VULKAN_HPP_NOEXCEPT
    {
      gridDimX = gridDimX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setGridDimY( uint32_t gridDimY_ ) VULKAN_HPP_NOEXCEPT
    {
      gridDimY = gridDimY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setGridDimZ( uint32_t gridDimZ_ ) VULKAN_HPP_NOEXCEPT
    {
      gridDimZ = gridDimZ_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setBlockDimX( uint32_t blockDimX_ ) VULKAN_HPP_NOEXCEPT
    {
      blockDimX = blockDimX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setBlockDimY( uint32_t blockDimY_ ) VULKAN_HPP_NOEXCEPT
    {
      blockDimY = blockDimY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setBlockDimZ( uint32_t blockDimZ_ ) VULKAN_HPP_NOEXCEPT
    {
      blockDimZ = blockDimZ_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setSharedMemBytes( uint32_t sharedMemBytes_ ) VULKAN_HPP_NOEXCEPT
    {
      sharedMemBytes = sharedMemBytes_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setParamCount( size_t paramCount_ ) VULKAN_HPP_NOEXCEPT
    {
      paramCount = paramCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setPParams( const void * const * pParams_ ) VULKAN_HPP_NOEXCEPT
    {
      pParams = pParams_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CuLaunchInfoNVX &
      setParams( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & params_ ) VULKAN_HPP_NOEXCEPT
    {
      paramCount = params_.size();
      pParams    = params_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setExtraCount( size_t extraCount_ ) VULKAN_HPP_NOEXCEPT
    {
      extraCount = extraCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setPExtras( const void * const * pExtras_ ) VULKAN_HPP_NOEXCEPT
    {
      pExtras = pExtras_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CuLaunchInfoNVX &
      setExtras( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & extras_ ) VULKAN_HPP_NOEXCEPT
    {
      extraCount = extras_.size();
      pExtras    = extras_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCuLaunchInfoNVX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCuLaunchInfoNVX *>( this );
    }

    operator VkCuLaunchInfoNVX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCuLaunchInfoNVX *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CuLaunchInfoNVX const & ) const = default;
#else
    bool operator==( CuLaunchInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( function == rhs.function ) &&
             ( gridDimX == rhs.gridDimX ) && ( gridDimY == rhs.gridDimY ) && ( gridDimZ == rhs.gridDimZ ) &&
             ( blockDimX == rhs.blockDimX ) && ( blockDimY == rhs.blockDimY ) && ( blockDimZ == rhs.blockDimZ ) &&
             ( sharedMemBytes == rhs.sharedMemBytes ) && ( paramCount == rhs.paramCount ) &&
             ( pParams == rhs.pParams ) && ( extraCount == rhs.extraCount ) && ( pExtras == rhs.pExtras );
    }

    bool operator!=( CuLaunchInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType          = StructureType::eCuLaunchInfoNVX;
    const void *                        pNext          = {};
    VULKAN_HPP_NAMESPACE::CuFunctionNVX function       = {};
    uint32_t                            gridDimX       = {};
    uint32_t                            gridDimY       = {};
    uint32_t                            gridDimZ       = {};
    uint32_t                            blockDimX      = {};
    uint32_t                            blockDimY      = {};
    uint32_t                            blockDimZ      = {};
    uint32_t                            sharedMemBytes = {};
    size_t                              paramCount     = {};
    const void * const *                pParams        = {};
    size_t                              extraCount     = {};
    const void * const *                pExtras        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX ) == sizeof( VkCuLaunchInfoNVX ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX>::value,
                            "CuLaunchInfoNVX is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCuLaunchInfoNVX>
  {
    using Type = CuLaunchInfoNVX;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX const & cuLaunchInfoNVX ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, cuLaunchInfoNVX.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, cuLaunchInfoNVX.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::CuFunctionNVX, seed, cuLaunchInfoNVX.function );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, cuLaunchInfoNVX.gridDimX );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, cuLaunchInfoNVX.gridDimY );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, cuLaunchInfoNVX.gridDimZ );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, cuLaunchInfoNVX.blockDimX );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, cuLaunchInfoNVX.blockDimY );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, cuLaunchInfoNVX.blockDimZ );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, cuLaunchInfoNVX.sharedMemBytes );
    VULKAN_HPP_HASH_COMBINE( size_t, seed, cuLaunchInfoNVX.paramCount );
    VULKAN_HPP_HASH_COMBINE( const void * const *, seed, cuLaunchInfoNVX.pParams );
    VULKAN_HPP_HASH_COMBINE( size_t, seed, cuLaunchInfoNVX.extraCount );
    VULKAN_HPP_HASH_COMBINE( const void * const *, seed, cuLaunchInfoNVX.pExtras );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct CuModuleCreateInfoNVX
  {
    using NativeType = VkCuModuleCreateInfoNVX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCuModuleCreateInfoNVX;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CuModuleCreateInfoNVX( size_t dataSize_ = {}, const void * pData_ = {} ) VULKAN_HPP_NOEXCEPT
      : dataSize( dataSize_ )
      , pData( pData_ )
    {}

    VULKAN_HPP_CONSTEXPR CuModuleCreateInfoNVX( CuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuModuleCreateInfoNVX( VkCuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
      : CuModuleCreateInfoNVX( *reinterpret_cast<CuModuleCreateInfoNVX const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    CuModuleCreateInfoNVX( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_ )
      : dataSize( data_.size() * sizeof( T ) ), pData( data_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CuModuleCreateInfoNVX & operator=( CuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuModuleCreateInfoNVX & operator=( VkCuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CuModuleCreateInfoNVX & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuModuleCreateInfoNVX & setDataSize( size_t dataSize_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = dataSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuModuleCreateInfoNVX & setPData( const void * pData_ ) VULKAN_HPP_NOEXCEPT
    {
      pData = pData_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    CuModuleCreateInfoNVX &
      setData( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = data_.size() * sizeof( T );
      pData    = data_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkCuModuleCreateInfoNVX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCuModuleCreateInfoNVX *>( this );
    }

    operator VkCuModuleCreateInfoNVX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCuModuleCreateInfoNVX *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CuModuleCreateInfoNVX const & ) const = default;
#else
    bool operator==( CuModuleCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( dataSize == rhs.dataSize ) && ( pData == rhs.pData );
    }

    bool operator!=( CuModuleCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType    = StructureType::eCuModuleCreateInfoNVX;
    const void *                        pNext    = {};
    size_t                              dataSize = {};
    const void *                        pData    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX ) == sizeof( VkCuModuleCreateInfoNVX ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX>::value,
                            "CuModuleCreateInfoNVX is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCuModuleCreateInfoNVX>
  {
    using Type = CuModuleCreateInfoNVX;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX const & cuModuleCreateInfoNVX ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, cuModuleCreateInfoNVX.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, cuModuleCreateInfoNVX.pNext );
    VULKAN_HPP_HASH_COMBINE( size_t, seed, cuModuleCreateInfoNVX.dataSize );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, cuModuleCreateInfoNVX.pData );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#if defined( VK_USE_PLATFORM_WIN32_KHR )
  struct D3D12FenceSubmitInfoKHR
  {
    using NativeType = VkD3D12FenceSubmitInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eD3D12FenceSubmitInfoKHR;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR D3D12FenceSubmitInfoKHR( uint32_t         waitSemaphoreValuesCount_   = {},
                                                  const uint64_t * pWaitSemaphoreValues_       = {},
                                                  uint32_t         signalSemaphoreValuesCount_ = {},
                                                  const uint64_t * pSignalSemaphoreValues_ = {} ) VULKAN_HPP_NOEXCEPT
      : waitSemaphoreValuesCount( waitSemaphoreValuesCount_ )
      , pWaitSemaphoreValues( pWaitSemaphoreValues_ )
      , signalSemaphoreValuesCount( signalSemaphoreValuesCount_ )
      , pSignalSemaphoreValues( pSignalSemaphoreValues_ )
    {}

    VULKAN_HPP_CONSTEXPR D3D12FenceSubmitInfoKHR( D3D12FenceSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    D3D12FenceSubmitInfoKHR( VkD3D12FenceSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : D3D12FenceSubmitInfoKHR( *reinterpret_cast<D3D12FenceSubmitInfoKHR const *>( &rhs ) )
    {}

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    D3D12FenceSubmitInfoKHR(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint64_t> const & waitSemaphoreValues_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint64_t> const & signalSemaphoreValues_ = {} )
      : waitSemaphoreValuesCount( static_cast<uint32_t>( waitSemaphoreValues_.size() ) )
      , pWaitSemaphoreValues( waitSemaphoreValues_.data() )
      , signalSemaphoreValuesCount( static_cast<uint32_t>( signalSemaphoreValues_.size() ) )
      , pSignalSemaphoreValues( signalSemaphoreValues_.data() )
    {}
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#  endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    D3D12FenceSubmitInfoKHR & operator=( D3D12FenceSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    D3D12FenceSubmitInfoKHR & operator=( VkD3D12FenceSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::D3D12FenceSubmitInfoKHR const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 D3D12FenceSubmitInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 D3D12FenceSubmitInfoKHR &
                            setWaitSemaphoreValuesCount( uint32_t waitSemaphoreValuesCount_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreValuesCount = waitSemaphoreValuesCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 D3D12FenceSubmitInfoKHR &
                            setPWaitSemaphoreValues( const uint64_t * pWaitSemaphoreValues_ ) VULKAN_HPP_NOEXCEPT
    {
      pWaitSemaphoreValues = pWaitSemaphoreValues_;
      return *this;
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    D3D12FenceSubmitInfoKHR & setWaitSemaphoreValues(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint64_t> const & waitSemaphoreValues_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreValuesCount = static_cast<uint32_t>( waitSemaphoreValues_.size() );
      pWaitSemaphoreValues     = waitSemaphoreValues_.data();
      return *this;
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 D3D12FenceSubmitInfoKHR &
                            setSignalSemaphoreValuesCount( uint32_t signalSemaphoreValuesCount_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreValuesCount = signalSemaphoreValuesCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 D3D12FenceSubmitInfoKHR &
                            setPSignalSemaphoreValues( const uint64_t * pSignalSemaphoreValues_ ) VULKAN_HPP_NOEXCEPT
    {
      pSignalSemaphoreValues = pSignalSemaphoreValues_;
      return *this;
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    D3D12FenceSubmitInfoKHR & setSignalSemaphoreValues(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint64_t> const & signalSemaphoreValues_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreValuesCount = static_cast<uint32_t>( signalSemaphoreValues_.size() );
      pSignalSemaphoreValues     = signalSemaphoreValues_.data();
      return *this;
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#  endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkD3D12FenceSubmitInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkD3D12FenceSubmitInfoKHR *>( this );
    }

    operator VkD3D12FenceSubmitInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkD3D12FenceSubmitInfoKHR *>( this );
    }

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( D3D12FenceSubmitInfoKHR const & ) const = default;
#  else
    bool operator==( D3D12FenceSubmitInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( waitSemaphoreValuesCount == rhs.waitSemaphoreValuesCount ) &&
             ( pWaitSemaphoreValues == rhs.pWaitSemaphoreValues ) &&
             ( signalSemaphoreValuesCount == rhs.signalSemaphoreValuesCount ) &&
             ( pSignalSemaphoreValues == rhs.pSignalSemaphoreValues );
    }

    bool operator!=( D3D12FenceSubmitInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                      = StructureType::eD3D12FenceSubmitInfoKHR;
    const void *                        pNext                      = {};
    uint32_t                            waitSemaphoreValuesCount   = {};
    const uint64_t *                    pWaitSemaphoreValues       = {};
    uint32_t                            signalSemaphoreValuesCount = {};
    const uint64_t *                    pSignalSemaphoreValues     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::D3D12FenceSubmitInfoKHR ) ==
                              sizeof( VkD3D12FenceSubmitInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::D3D12FenceSubmitInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::D3D12FenceSubmitInfoKHR>::value,
                            "D3D12FenceSubmitInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eD3D12FenceSubmitInfoKHR>
  {
    using Type = D3D12FenceSubmitInfoKHR;
  };

}  // VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::D3D12FenceSubmitInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::D3D12FenceSubmitInfoKHR const & d3D12FenceSubmitInfoKHR ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, d3D12FenceSubmitInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, d3D12FenceSubmitInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, d3D12FenceSubmitInfoKHR.waitSemaphoreValuesCount );
    VULKAN_HPP_HASH_COMBINE( const uint64_t *, seed, d3D12FenceSubmitInfoKHR.pWaitSemaphoreValues );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, d3D12FenceSubmitInfoKHR.signalSemaphoreValuesCount );
    VULKAN_HPP_HASH_COMBINE( const uint64_t *, seed, d3D12FenceSubmitInfoKHR.pSignalSemaphoreValues );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
#endif /*VK_USE_PLATFORM_WIN32_KHR*/

  struct DebugMarkerMarkerInfoEXT
  {
    using NativeType = VkDebugMarkerMarkerInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugMarkerMarkerInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 DebugMarkerMarkerInfoEXT( const char *                 pMarkerName_ = {},
                                                      std::array<float, 4> const & color_ = {} ) VULKAN_HPP_NOEXCEPT
      : pMarkerName( pMarkerName_ )
      , color( color_ )
    {}

    VULKAN_HPP_CONSTEXPR_14
      DebugMarkerMarkerInfoEXT( DebugMarkerMarkerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerMarkerInfoEXT( VkDebugMarkerMarkerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugMarkerMarkerInfoEXT( *reinterpret_cast<DebugMarkerMarkerInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugMarkerMarkerInfoEXT & operator=( DebugMarkerMarkerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerMarkerInfoEXT & operator=( VkDebugMarkerMarkerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugMarkerMarkerInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugMarkerMarkerInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerMarkerInfoEXT & setPMarkerName( const char * pMarkerName_ ) VULKAN_HPP_NOEXCEPT
    {
      pMarkerName = pMarkerName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerMarkerInfoEXT & setColor( std::array<float, 4> color_ ) VULKAN_HPP_NOEXCEPT
    {
      color = color_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugMarkerMarkerInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugMarkerMarkerInfoEXT *>( this );
    }

    operator VkDebugMarkerMarkerInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugMarkerMarkerInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugMarkerMarkerInfoEXT const & ) const = default;
#else
    bool operator==( DebugMarkerMarkerInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pMarkerName == rhs.pMarkerName ) &&
             ( color == rhs.color );
    }

    bool operator!=( DebugMarkerMarkerInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType       = StructureType::eDebugMarkerMarkerInfoEXT;
    const void *                                   pNext       = {};
    const char *                                   pMarkerName = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4> color       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugMarkerMarkerInfoEXT ) ==
                              sizeof( VkDebugMarkerMarkerInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugMarkerMarkerInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugMarkerMarkerInfoEXT>::value,
                            "DebugMarkerMarkerInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugMarkerMarkerInfoEXT>
  {
    using Type = DebugMarkerMarkerInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DebugMarkerMarkerInfoEXT>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DebugMarkerMarkerInfoEXT const & debugMarkerMarkerInfoEXT ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, debugMarkerMarkerInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugMarkerMarkerInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE( const char *, seed, debugMarkerMarkerInfoEXT.pMarkerName );
    for ( size_t i = 0; i < 4; ++i )
    {
      VULKAN_HPP_HASH_COMBINE( float, seed, debugMarkerMarkerInfoEXT.color[i] );
    }
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DebugMarkerObjectNameInfoEXT
  {
    using NativeType = VkDebugMarkerObjectNameInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugMarkerObjectNameInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugMarkerObjectNameInfoEXT( VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType_ =
                                                         VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT::eUnknown,
                                                       uint64_t     object_      = {},
                                                       const char * pObjectName_ = {} ) VULKAN_HPP_NOEXCEPT
      : objectType( objectType_ )
      , object( object_ )
      , pObjectName( pObjectName_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DebugMarkerObjectNameInfoEXT( DebugMarkerObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerObjectNameInfoEXT( VkDebugMarkerObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugMarkerObjectNameInfoEXT( *reinterpret_cast<DebugMarkerObjectNameInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugMarkerObjectNameInfoEXT & operator=( DebugMarkerObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerObjectNameInfoEXT & operator=( VkDebugMarkerObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugMarkerObjectNameInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectNameInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectNameInfoEXT &
      setObjectType( VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType_ ) VULKAN_HPP_NOEXCEPT
    {
      objectType = objectType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectNameInfoEXT & setObject( uint64_t object_ ) VULKAN_HPP_NOEXCEPT
    {
      object = object_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectNameInfoEXT &
                            setPObjectName( const char * pObjectName_ ) VULKAN_HPP_NOEXCEPT
    {
      pObjectName = pObjectName_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugMarkerObjectNameInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugMarkerObjectNameInfoEXT *>( this );
    }

    operator VkDebugMarkerObjectNameInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugMarkerObjectNameInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugMarkerObjectNameInfoEXT const & ) const = default;
#else
    bool operator==( DebugMarkerObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( objectType == rhs.objectType ) &&
             ( object == rhs.object ) && ( pObjectName == rhs.pObjectName );
    }

    bool operator!=( DebugMarkerObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType = StructureType::eDebugMarkerObjectNameInfoEXT;
    const void *                                   pNext = {};
    VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType =
      VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT::eUnknown;
    uint64_t     object      = {};
    const char * pObjectName = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugMarkerObjectNameInfoEXT ) ==
                              sizeof( VkDebugMarkerObjectNameInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugMarkerObjectNameInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugMarkerObjectNameInfoEXT>::value,
    "DebugMarkerObjectNameInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugMarkerObjectNameInfoEXT>
  {
    using Type = DebugMarkerObjectNameInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DebugMarkerObjectNameInfoEXT>
{
  std::size_t operator()(
    VULKAN_HPP_NAMESPACE::DebugMarkerObjectNameInfoEXT const & debugMarkerObjectNameInfoEXT ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, debugMarkerObjectNameInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugMarkerObjectNameInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT, seed, debugMarkerObjectNameInfoEXT.objectType );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, debugMarkerObjectNameInfoEXT.object );
    VULKAN_HPP_HASH_COMBINE( const char *, seed, debugMarkerObjectNameInfoEXT.pObjectName );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DebugMarkerObjectTagInfoEXT
  {
    using NativeType = VkDebugMarkerObjectTagInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugMarkerObjectTagInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugMarkerObjectTagInfoEXT( VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType_ =
                                                        VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT::eUnknown,
                                                      uint64_t     object_  = {},
                                                      uint64_t     tagName_ = {},
                                                      size_t       tagSize_ = {},
                                                      const void * pTag_    = {} ) VULKAN_HPP_NOEXCEPT
      : objectType( objectType_ )
      , object( object_ )
      , tagName( tagName_ )
      , tagSize( tagSize_ )
      , pTag( pTag_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DebugMarkerObjectTagInfoEXT( DebugMarkerObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerObjectTagInfoEXT( VkDebugMarkerObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugMarkerObjectTagInfoEXT( *reinterpret_cast<DebugMarkerObjectTagInfoEXT const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    DebugMarkerObjectTagInfoEXT( VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT                 objectType_,
                                 uint64_t                                                       object_,
                                 uint64_t                                                       tagName_,
                                 VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & tag_ )
      : objectType( objectType_ )
      , object( object_ )
      , tagName( tagName_ )
      , tagSize( tag_.size() * sizeof( T ) )
      , pTag( tag_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugMarkerObjectTagInfoEXT & operator=( DebugMarkerObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerObjectTagInfoEXT & operator=( VkDebugMarkerObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugMarkerObjectTagInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT &
      setObjectType( VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType_ ) VULKAN_HPP_NOEXCEPT
    {
      objectType = objectType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setObject( uint64_t object_ ) VULKAN_HPP_NOEXCEPT
    {
      object = object_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setTagName( uint64_t tagName_ ) VULKAN_HPP_NOEXCEPT
    {
      tagName = tagName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setTagSize( size_t tagSize_ ) VULKAN_HPP_NOEXCEPT
    {
      tagSize = tagSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setPTag( const void * pTag_ ) VULKAN_HPP_NOEXCEPT
    {
      pTag = pTag_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    DebugMarkerObjectTagInfoEXT &
      setTag( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & tag_ ) VULKAN_HPP_NOEXCEPT
    {
      tagSize = tag_.size() * sizeof( T );
      pTag    = tag_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugMarkerObjectTagInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugMarkerObjectTagInfoEXT *>( this );
    }

    operator VkDebugMarkerObjectTagInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugMarkerObjectTagInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugMarkerObjectTagInfoEXT const & ) const = default;
#else
    bool operator==( DebugMarkerObjectTagInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( objectType == rhs.objectType ) &&
             ( object == rhs.object ) && ( tagName == rhs.tagName ) && ( tagSize == rhs.tagSize ) &&
             ( pTag == rhs.pTag );
    }

    bool operator!=( DebugMarkerObjectTagInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType = StructureType::eDebugMarkerObjectTagInfoEXT;
    const void *                                   pNext = {};
    VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType =
      VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT::eUnknown;
    uint64_t     object  = {};
    uint64_t     tagName = {};
    size_t       tagSize = {};
    const void * pTag    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugMarkerObjectTagInfoEXT ) ==
                              sizeof( VkDebugMarkerObjectTagInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugMarkerObjectTagInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugMarkerObjectTagInfoEXT>::value,
    "DebugMarkerObjectTagInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugMarkerObjectTagInfoEXT>
  {
    using Type = DebugMarkerObjectTagInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DebugMarkerObjectTagInfoEXT>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DebugMarkerObjectTagInfoEXT const & debugMarkerObjectTagInfoEXT ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, debugMarkerObjectTagInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugMarkerObjectTagInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT, seed, debugMarkerObjectTagInfoEXT.objectType );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, debugMarkerObjectTagInfoEXT.object );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, debugMarkerObjectTagInfoEXT.tagName );
    VULKAN_HPP_HASH_COMBINE( size_t, seed, debugMarkerObjectTagInfoEXT.tagSize );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugMarkerObjectTagInfoEXT.pTag );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DebugReportCallbackCreateInfoEXT
  {
    using NativeType = VkDebugReportCallbackCreateInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType = StructureType::eDebugReportCallbackCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugReportCallbackCreateInfoEXT( VULKAN_HPP_NAMESPACE::DebugReportFlagsEXT flags_       = {},
                                                           PFN_vkDebugReportCallbackEXT              pfnCallback_ = {},
                                                           void * pUserData_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , pfnCallback( pfnCallback_ )
      , pUserData( pUserData_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DebugReportCallbackCreateInfoEXT( DebugReportCallbackCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugReportCallbackCreateInfoEXT( VkDebugReportCallbackCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugReportCallbackCreateInfoEXT( *reinterpret_cast<DebugReportCallbackCreateInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugReportCallbackCreateInfoEXT &
      operator=( DebugReportCallbackCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugReportCallbackCreateInfoEXT & operator=( VkDebugReportCallbackCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugReportCallbackCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugReportCallbackCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugReportCallbackCreateInfoEXT &
                            setFlags( VULKAN_HPP_NAMESPACE::DebugReportFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugReportCallbackCreateInfoEXT &
                            setPfnCallback( PFN_vkDebugReportCallbackEXT pfnCallback_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnCallback = pfnCallback_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugReportCallbackCreateInfoEXT & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugReportCallbackCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugReportCallbackCreateInfoEXT *>( this );
    }

    operator VkDebugReportCallbackCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugReportCallbackCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugReportCallbackCreateInfoEXT const & ) const = default;
#else
    bool operator==( DebugReportCallbackCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( pfnCallback == rhs.pfnCallback ) && ( pUserData == rhs.pUserData );
    }

    bool operator!=( DebugReportCallbackCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType       = StructureType::eDebugReportCallbackCreateInfoEXT;
    const void *                              pNext       = {};
    VULKAN_HPP_NAMESPACE::DebugReportFlagsEXT flags       = {};
    PFN_vkDebugReportCallbackEXT              pfnCallback = {};
    void *                                    pUserData   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugReportCallbackCreateInfoEXT ) ==
                              sizeof( VkDebugReportCallbackCreateInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugReportCallbackCreateInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugReportCallbackCreateInfoEXT>::value,
    "DebugReportCallbackCreateInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugReportCallbackCreateInfoEXT>
  {
    using Type = DebugReportCallbackCreateInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DebugReportCallbackCreateInfoEXT>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::DebugReportCallbackCreateInfoEXT const & debugReportCallbackCreateInfoEXT ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, debugReportCallbackCreateInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugReportCallbackCreateInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DebugReportFlagsEXT, seed, debugReportCallbackCreateInfoEXT.flags );
    VULKAN_HPP_HASH_COMBINE( PFN_vkDebugReportCallbackEXT, seed, debugReportCallbackCreateInfoEXT.pfnCallback );
    VULKAN_HPP_HASH_COMBINE( void *, seed, debugReportCallbackCreateInfoEXT.pUserData );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DebugUtilsLabelEXT
  {
    using NativeType = VkDebugUtilsLabelEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsLabelEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT( const char *                 pLabelName_ = {},
                                                std::array<float, 4> const & color_      = {} ) VULKAN_HPP_NOEXCEPT
      : pLabelName( pLabelName_ )
      , color( color_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT( DebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsLabelEXT( VkDebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsLabelEXT( *reinterpret_cast<DebugUtilsLabelEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsLabelEXT & operator=( DebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsLabelEXT & operator=( VkDebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT & setPLabelName( const char * pLabelName_ ) VULKAN_HPP_NOEXCEPT
    {
      pLabelName = pLabelName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT & setColor( std::array<float, 4> color_ ) VULKAN_HPP_NOEXCEPT
    {
      color = color_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugUtilsLabelEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsLabelEXT *>( this );
    }

    operator VkDebugUtilsLabelEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsLabelEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugUtilsLabelEXT const & ) const = default;
#else
    bool operator==( DebugUtilsLabelEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pLabelName == rhs.pLabelName ) &&
             ( color == rhs.color );
    }

    bool operator!=( DebugUtilsLabelEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType      = StructureType::eDebugUtilsLabelEXT;
    const void *                                   pNext      = {};
    const char *                                   pLabelName = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4> color      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT ) == sizeof( VkDebugUtilsLabelEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT>::value,
                            "DebugUtilsLabelEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsLabelEXT>
  {
    using Type = DebugUtilsLabelEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT const & debugUtilsLabelEXT ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, debugUtilsLabelEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugUtilsLabelEXT.pNext );
    VULKAN_HPP_HASH_COMBINE( const char *, seed, debugUtilsLabelEXT.pLabelName );
    for ( size_t i = 0; i < 4; ++i )
    {
      VULKAN_HPP_HASH_COMBINE( float, seed, debugUtilsLabelEXT.color[i] );
    }
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DebugUtilsObjectNameInfoEXT
  {
    using NativeType = VkDebugUtilsObjectNameInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsObjectNameInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugUtilsObjectNameInfoEXT(
      VULKAN_HPP_NAMESPACE::ObjectType objectType_   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown,
      uint64_t                         objectHandle_ = {},
      const char *                     pObjectName_  = {} ) VULKAN_HPP_NOEXCEPT
      : objectType( objectType_ )
      , objectHandle( objectHandle_ )
      , pObjectName( pObjectName_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DebugUtilsObjectNameInfoEXT( DebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsObjectNameInfoEXT( VkDebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsObjectNameInfoEXT( *reinterpret_cast<DebugUtilsObjectNameInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsObjectNameInfoEXT & operator=( DebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsObjectNameInfoEXT & operator=( VkDebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT &
                            setObjectType( VULKAN_HPP_NAMESPACE::ObjectType objectType_ ) VULKAN_HPP_NOEXCEPT
    {
      objectType = objectType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT & setObjectHandle( uint64_t objectHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      objectHandle = objectHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT &
                            setPObjectName( const char * pObjectName_ ) VULKAN_HPP_NOEXCEPT
    {
      pObjectName = pObjectName_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugUtilsObjectNameInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsObjectNameInfoEXT *>( this );
    }

    operator VkDebugUtilsObjectNameInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsObjectNameInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugUtilsObjectNameInfoEXT const & ) const = default;
#else
    bool operator==( DebugUtilsObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( objectType == rhs.objectType ) &&
             ( objectHandle == rhs.objectHandle ) && ( pObjectName == rhs.pObjectName );
    }

    bool operator!=( DebugUtilsObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eDebugUtilsObjectNameInfoEXT;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::ObjectType    objectType   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown;
    uint64_t                            objectHandle = {};
    const char *                        pObjectName  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT ) ==
                              sizeof( VkDebugUtilsObjectNameInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT>::value,
    "DebugUtilsObjectNameInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsObjectNameInfoEXT>
  {
    using Type = DebugUtilsObjectNameInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT const & debugUtilsObjectNameInfoEXT ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, debugUtilsObjectNameInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugUtilsObjectNameInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ObjectType, seed, debugUtilsObjectNameInfoEXT.objectType );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, debugUtilsObjectNameInfoEXT.objectHandle );
    VULKAN_HPP_HASH_COMBINE( const char *, seed, debugUtilsObjectNameInfoEXT.pObjectName );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DebugUtilsMessengerCallbackDataEXT
  {
    using NativeType = VkDebugUtilsMessengerCallbackDataEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDebugUtilsMessengerCallbackDataEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT(
      VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT flags_            = {},
      const char *                                                  pMessageIdName_   = {},
      int32_t                                                       messageIdNumber_  = {},
      const char *                                                  pMessage_         = {},
      uint32_t                                                      queueLabelCount_  = {},
      const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pQueueLabels_     = {},
      uint32_t                                                      cmdBufLabelCount_ = {},
      const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pCmdBufLabels_    = {},
      uint32_t                                                      objectCount_      = {},
      const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT *     pObjects_         = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , pMessageIdName( pMessageIdName_ )
      , messageIdNumber( messageIdNumber_ )
      , pMessage( pMessage_ )
      , queueLabelCount( queueLabelCount_ )
      , pQueueLabels( pQueueLabels_ )
      , cmdBufLabelCount( cmdBufLabelCount_ )
      , pCmdBufLabels( pCmdBufLabels_ )
      , objectCount( objectCount_ )
      , pObjects( pObjects_ )
    {}

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT( DebugUtilsMessengerCallbackDataEXT const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsMessengerCallbackDataEXT( VkDebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsMessengerCallbackDataEXT( *reinterpret_cast<DebugUtilsMessengerCallbackDataEXT const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT(
      VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT flags_,
      const char *                                                  pMessageIdName_,
      int32_t                                                       messageIdNumber_,
      const char *                                                  pMessage_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const &
        queueLabels_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const &
        cmdBufLabels_ = {},
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT> const &
        objects_ = {} )
      : flags( flags_ )
      , pMessageIdName( pMessageIdName_ )
      , messageIdNumber( messageIdNumber_ )
      , pMessage( pMessage_ )
      , queueLabelCount( static_cast<uint32_t>( queueLabels_.size() ) )
      , pQueueLabels( queueLabels_.data() )
      , cmdBufLabelCount( static_cast<uint32_t>( cmdBufLabels_.size() ) )
      , pCmdBufLabels( cmdBufLabels_.data() )
      , objectCount( static_cast<uint32_t>( objects_.size() ) )
      , pObjects( objects_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsMessengerCallbackDataEXT &
      operator=( DebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsMessengerCallbackDataEXT &
      operator=( VkDebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
      setFlags( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
                            setPMessageIdName( const char * pMessageIdName_ ) VULKAN_HPP_NOEXCEPT
    {
      pMessageIdName = pMessageIdName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
                            setMessageIdNumber( int32_t messageIdNumber_ ) VULKAN_HPP_NOEXCEPT
    {
      messageIdNumber = messageIdNumber_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
                            setPMessage( const char * pMessage_ ) VULKAN_HPP_NOEXCEPT
    {
      pMessage = pMessage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
                            setQueueLabelCount( uint32_t queueLabelCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueLabelCount = queueLabelCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
      setPQueueLabels( const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT * pQueueLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueLabels = pQueueLabels_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT & setQueueLabels(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const &
        queueLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      queueLabelCount = static_cast<uint32_t>( queueLabels_.size() );
      pQueueLabels    = queueLabels_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
                            setCmdBufLabelCount( uint32_t cmdBufLabelCount_ ) VULKAN_HPP_NOEXCEPT
    {
      cmdBufLabelCount = cmdBufLabelCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
      setPCmdBufLabels( const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT * pCmdBufLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      pCmdBufLabels = pCmdBufLabels_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT & setCmdBufLabels(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const &
        cmdBufLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      cmdBufLabelCount = static_cast<uint32_t>( cmdBufLabels_.size() );
      pCmdBufLabels    = cmdBufLabels_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
                            setObjectCount( uint32_t objectCount_ ) VULKAN_HPP_NOEXCEPT
    {
      objectCount = objectCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
      setPObjects( const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT * pObjects_ ) VULKAN_HPP_NOEXCEPT
    {
      pObjects = pObjects_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT & setObjects(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT> const &
        objects_ ) VULKAN_HPP_NOEXCEPT
    {
      objectCount = static_cast<uint32_t>( objects_.size() );
      pObjects    = objects_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugUtilsMessengerCallbackDataEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsMessengerCallbackDataEXT *>( this );
    }

    operator VkDebugUtilsMessengerCallbackDataEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsMessengerCallbackDataEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugUtilsMessengerCallbackDataEXT const & ) const = default;
#else
    bool operator==( DebugUtilsMessengerCallbackDataEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( pMessageIdName == rhs.pMessageIdName ) && ( messageIdNumber == rhs.messageIdNumber ) &&
             ( pMessage == rhs.pMessage ) && ( queueLabelCount == rhs.queueLabelCount ) &&
             ( pQueueLabels == rhs.pQueueLabels ) && ( cmdBufLabelCount == rhs.cmdBufLabelCount ) &&
             ( pCmdBufLabels == rhs.pCmdBufLabels ) && ( objectCount == rhs.objectCount ) &&
             ( pObjects == rhs.pObjects );
    }

    bool operator!=( DebugUtilsMessengerCallbackDataEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eDebugUtilsMessengerCallbackDataEXT;
    const void *                        pNext = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT flags            = {};
    const char *                                                  pMessageIdName   = {};
    int32_t                                                       messageIdNumber  = {};
    const char *                                                  pMessage         = {};
    uint32_t                                                      queueLabelCount  = {};
    const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pQueueLabels     = {};
    uint32_t                                                      cmdBufLabelCount = {};
    const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pCmdBufLabels    = {};
    uint32_t                                                      objectCount      = {};
    const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT *     pObjects         = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT ) ==
                              sizeof( VkDebugUtilsMessengerCallbackDataEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT>::value,
    "DebugUtilsMessengerCallbackDataEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsMessengerCallbackDataEXT>
  {
    using Type = DebugUtilsMessengerCallbackDataEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT const &
                            debugUtilsMessengerCallbackDataEXT ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, debugUtilsMessengerCallbackDataEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugUtilsMessengerCallbackDataEXT.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT, seed, debugUtilsMessengerCallbackDataEXT.flags );
    VULKAN_HPP_HASH_COMBINE( const char *, seed, debugUtilsMessengerCallbackDataEXT.pMessageIdName );
    VULKAN_HPP_HASH_COMBINE( int32_t, seed, debugUtilsMessengerCallbackDataEXT.messageIdNumber );
    VULKAN_HPP_HASH_COMBINE( const char *, seed, debugUtilsMessengerCallbackDataEXT.pMessage );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, debugUtilsMessengerCallbackDataEXT.queueLabelCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *, seed, debugUtilsMessengerCallbackDataEXT.pQueueLabels );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, debugUtilsMessengerCallbackDataEXT.cmdBufLabelCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *, seed, debugUtilsMessengerCallbackDataEXT.pCmdBufLabels );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, debugUtilsMessengerCallbackDataEXT.objectCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT *, seed, debugUtilsMessengerCallbackDataEXT.pObjects );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DebugUtilsMessengerCreateInfoEXT
  {
    using NativeType = VkDebugUtilsMessengerCreateInfoEXT;

    static const bool                                  allowDuplicate = true;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType = StructureType::eDebugUtilsMessengerCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DebugUtilsMessengerCreateInfoEXT( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT flags_           = {},
                                        VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT messageSeverity_ = {},
                                        VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT     messageType_     = {},
                                        PFN_vkDebugUtilsMessengerCallbackEXT                    pfnUserCallback_ = {},
                                        void * pUserData_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , messageSeverity( messageSeverity_ )
      , messageType( messageType_ )
      , pfnUserCallback( pfnUserCallback_ )
      , pUserData( pUserData_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DebugUtilsMessengerCreateInfoEXT( DebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsMessengerCreateInfoEXT( VkDebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsMessengerCreateInfoEXT( *reinterpret_cast<DebugUtilsMessengerCreateInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsMessengerCreateInfoEXT &
      operator=( DebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsMessengerCreateInfoEXT & operator=( VkDebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT &
      setFlags( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT &
      setMessageSeverity( VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT messageSeverity_ ) VULKAN_HPP_NOEXCEPT
    {
      messageSeverity = messageSeverity_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT &
      setMessageType( VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT messageType_ ) VULKAN_HPP_NOEXCEPT
    {
      messageType = messageType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT &
      setPfnUserCallback( PFN_vkDebugUtilsMessengerCallbackEXT pfnUserCallback_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnUserCallback = pfnUserCallback_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugUtilsMessengerCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsMessengerCreateInfoEXT *>( this );
    }

    operator VkDebugUtilsMessengerCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsMessengerCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugUtilsMessengerCreateInfoEXT const & ) const = default;
#else
    bool operator==( DebugUtilsMessengerCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( messageSeverity == rhs.messageSeverity ) && ( messageType == rhs.messageType ) &&
             ( pfnUserCallback == rhs.pfnUserCallback ) && ( pUserData == rhs.pUserData );
    }

    bool operator!=( DebugUtilsMessengerCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                     sType = StructureType::eDebugUtilsMessengerCreateInfoEXT;
    const void *                                            pNext = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT flags = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT messageSeverity = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT     messageType     = {};
    PFN_vkDebugUtilsMessengerCallbackEXT                    pfnUserCallback = {};
    void *                                                  pUserData       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT ) ==
                              sizeof( VkDebugUtilsMessengerCreateInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT>::value,
    "DebugUtilsMessengerCreateInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsMessengerCreateInfoEXT>
  {
    using Type = DebugUtilsMessengerCreateInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT const & debugUtilsMessengerCreateInfoEXT ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, debugUtilsMessengerCreateInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugUtilsMessengerCreateInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT, seed, debugUtilsMessengerCreateInfoEXT.flags );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT, seed, debugUtilsMessengerCreateInfoEXT.messageSeverity );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT, seed, debugUtilsMessengerCreateInfoEXT.messageType );
    VULKAN_HPP_HASH_COMBINE(
      PFN_vkDebugUtilsMessengerCallbackEXT, seed, debugUtilsMessengerCreateInfoEXT.pfnUserCallback );
    VULKAN_HPP_HASH_COMBINE( void *, seed, debugUtilsMessengerCreateInfoEXT.pUserData );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DebugUtilsObjectTagInfoEXT
  {
    using NativeType = VkDebugUtilsObjectTagInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsObjectTagInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugUtilsObjectTagInfoEXT(
      VULKAN_HPP_NAMESPACE::ObjectType objectType_   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown,
      uint64_t                         objectHandle_ = {},
      uint64_t                         tagName_      = {},
      size_t                           tagSize_      = {},
      const void *                     pTag_         = {} ) VULKAN_HPP_NOEXCEPT
      : objectType( objectType_ )
      , objectHandle( objectHandle_ )
      , tagName( tagName_ )
      , tagSize( tagSize_ )
      , pTag( pTag_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DebugUtilsObjectTagInfoEXT( DebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsObjectTagInfoEXT( VkDebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsObjectTagInfoEXT( *reinterpret_cast<DebugUtilsObjectTagInfoEXT const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    DebugUtilsObjectTagInfoEXT( VULKAN_HPP_NAMESPACE::ObjectType                               objectType_,
                                uint64_t                                                       objectHandle_,
                                uint64_t                                                       tagName_,
                                VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & tag_ )
      : objectType( objectType_ )
      , objectHandle( objectHandle_ )
      , tagName( tagName_ )
      , tagSize( tag_.size() * sizeof( T ) )
      , pTag( tag_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsObjectTagInfoEXT & operator=( DebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsObjectTagInfoEXT & operator=( VkDebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT &
                            setObjectType( VULKAN_HPP_NAMESPACE::ObjectType objectType_ ) VULKAN_HPP_NOEXCEPT
    {
      objectType = objectType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setObjectHandle( uint64_t objectHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      objectHandle = objectHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setTagName( uint64_t tagName_ ) VULKAN_HPP_NOEXCEPT
    {
      tagName = tagName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setTagSize( size_t tagSize_ ) VULKAN_HPP_NOEXCEPT
    {
      tagSize = tagSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setPTag( const void * pTag_ ) VULKAN_HPP_NOEXCEPT
    {
      pTag = pTag_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    DebugUtilsObjectTagInfoEXT &
      setTag( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & tag_ ) VULKAN_HPP_NOEXCEPT
    {
      tagSize = tag_.size() * sizeof( T );
      pTag    = tag_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDebugUtilsObjectTagInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsObjectTagInfoEXT *>( this );
    }

    operator VkDebugUtilsObjectTagInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsObjectTagInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugUtilsObjectTagInfoEXT const & ) const = default;
#else
    bool operator==( DebugUtilsObjectTagInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( objectType == rhs.objectType ) &&
             ( objectHandle == rhs.objectHandle ) && ( tagName == rhs.tagName ) && ( tagSize == rhs.tagSize ) &&
             ( pTag == rhs.pTag );
    }

    bool operator!=( DebugUtilsObjectTagInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eDebugUtilsObjectTagInfoEXT;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::ObjectType    objectType   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown;
    uint64_t                            objectHandle = {};
    uint64_t                            tagName      = {};
    size_t                              tagSize      = {};
    const void *                        pTag         = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT ) ==
                              sizeof( VkDebugUtilsObjectTagInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT>::value,
                            "DebugUtilsObjectTagInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsObjectTagInfoEXT>
  {
    using Type = DebugUtilsObjectTagInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT const & debugUtilsObjectTagInfoEXT ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, debugUtilsObjectTagInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugUtilsObjectTagInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ObjectType, seed, debugUtilsObjectTagInfoEXT.objectType );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, debugUtilsObjectTagInfoEXT.objectHandle );
    VULKAN_HPP_HASH_COMBINE( uint64_t, seed, debugUtilsObjectTagInfoEXT.tagName );
    VULKAN_HPP_HASH_COMBINE( size_t, seed, debugUtilsObjectTagInfoEXT.tagSize );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, debugUtilsObjectTagInfoEXT.pTag );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DedicatedAllocationBufferCreateInfoNV
  {
    using NativeType = VkDedicatedAllocationBufferCreateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDedicatedAllocationBufferCreateInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DedicatedAllocationBufferCreateInfoNV( VULKAN_HPP_NAMESPACE::Bool32 dedicatedAllocation_ = {} )
      VULKAN_HPP_NOEXCEPT : dedicatedAllocation( dedicatedAllocation_ )
    {}

    VULKAN_HPP_CONSTEXPR DedicatedAllocationBufferCreateInfoNV( DedicatedAllocationBufferCreateInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationBufferCreateInfoNV( VkDedicatedAllocationBufferCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : DedicatedAllocationBufferCreateInfoNV(
          *reinterpret_cast<DedicatedAllocationBufferCreateInfoNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DedicatedAllocationBufferCreateInfoNV &
      operator=( DedicatedAllocationBufferCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationBufferCreateInfoNV &
      operator=( VkDedicatedAllocationBufferCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DedicatedAllocationBufferCreateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationBufferCreateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationBufferCreateInfoNV &
      setDedicatedAllocation( VULKAN_HPP_NAMESPACE::Bool32 dedicatedAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      dedicatedAllocation = dedicatedAllocation_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDedicatedAllocationBufferCreateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDedicatedAllocationBufferCreateInfoNV *>( this );
    }

    operator VkDedicatedAllocationBufferCreateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDedicatedAllocationBufferCreateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DedicatedAllocationBufferCreateInfoNV const & ) const = default;
#else
    bool operator==( DedicatedAllocationBufferCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( dedicatedAllocation == rhs.dedicatedAllocation );
    }

    bool operator!=( DedicatedAllocationBufferCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType               = StructureType::eDedicatedAllocationBufferCreateInfoNV;
    const void *                        pNext               = {};
    VULKAN_HPP_NAMESPACE::Bool32        dedicatedAllocation = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DedicatedAllocationBufferCreateInfoNV ) ==
                              sizeof( VkDedicatedAllocationBufferCreateInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DedicatedAllocationBufferCreateInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DedicatedAllocationBufferCreateInfoNV>::value,
    "DedicatedAllocationBufferCreateInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDedicatedAllocationBufferCreateInfoNV>
  {
    using Type = DedicatedAllocationBufferCreateInfoNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DedicatedAllocationBufferCreateInfoNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DedicatedAllocationBufferCreateInfoNV const &
                            dedicatedAllocationBufferCreateInfoNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, dedicatedAllocationBufferCreateInfoNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, dedicatedAllocationBufferCreateInfoNV.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, dedicatedAllocationBufferCreateInfoNV.dedicatedAllocation );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DedicatedAllocationImageCreateInfoNV
  {
    using NativeType = VkDedicatedAllocationImageCreateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDedicatedAllocationImageCreateInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DedicatedAllocationImageCreateInfoNV( VULKAN_HPP_NAMESPACE::Bool32 dedicatedAllocation_ = {} ) VULKAN_HPP_NOEXCEPT
      : dedicatedAllocation( dedicatedAllocation_ )
    {}

    VULKAN_HPP_CONSTEXPR DedicatedAllocationImageCreateInfoNV( DedicatedAllocationImageCreateInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationImageCreateInfoNV( VkDedicatedAllocationImageCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : DedicatedAllocationImageCreateInfoNV( *reinterpret_cast<DedicatedAllocationImageCreateInfoNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DedicatedAllocationImageCreateInfoNV &
      operator=( DedicatedAllocationImageCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationImageCreateInfoNV &
      operator=( VkDedicatedAllocationImageCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DedicatedAllocationImageCreateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationImageCreateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationImageCreateInfoNV &
      setDedicatedAllocation( VULKAN_HPP_NAMESPACE::Bool32 dedicatedAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      dedicatedAllocation = dedicatedAllocation_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDedicatedAllocationImageCreateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDedicatedAllocationImageCreateInfoNV *>( this );
    }

    operator VkDedicatedAllocationImageCreateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDedicatedAllocationImageCreateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DedicatedAllocationImageCreateInfoNV const & ) const = default;
#else
    bool operator==( DedicatedAllocationImageCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( dedicatedAllocation == rhs.dedicatedAllocation );
    }

    bool operator!=( DedicatedAllocationImageCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType               = StructureType::eDedicatedAllocationImageCreateInfoNV;
    const void *                        pNext               = {};
    VULKAN_HPP_NAMESPACE::Bool32        dedicatedAllocation = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DedicatedAllocationImageCreateInfoNV ) ==
                              sizeof( VkDedicatedAllocationImageCreateInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DedicatedAllocationImageCreateInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DedicatedAllocationImageCreateInfoNV>::value,
    "DedicatedAllocationImageCreateInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDedicatedAllocationImageCreateInfoNV>
  {
    using Type = DedicatedAllocationImageCreateInfoNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DedicatedAllocationImageCreateInfoNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DedicatedAllocationImageCreateInfoNV const &
                            dedicatedAllocationImageCreateInfoNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, dedicatedAllocationImageCreateInfoNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, dedicatedAllocationImageCreateInfoNV.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, dedicatedAllocationImageCreateInfoNV.dedicatedAllocation );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DedicatedAllocationMemoryAllocateInfoNV
  {
    using NativeType = VkDedicatedAllocationMemoryAllocateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDedicatedAllocationMemoryAllocateInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DedicatedAllocationMemoryAllocateInfoNV( VULKAN_HPP_NAMESPACE::Image  image_  = {},
                                               VULKAN_HPP_NAMESPACE::Buffer buffer_ = {} ) VULKAN_HPP_NOEXCEPT
      : image( image_ )
      , buffer( buffer_ )
    {}

    VULKAN_HPP_CONSTEXPR DedicatedAllocationMemoryAllocateInfoNV( DedicatedAllocationMemoryAllocateInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationMemoryAllocateInfoNV( VkDedicatedAllocationMemoryAllocateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : DedicatedAllocationMemoryAllocateInfoNV(
          *reinterpret_cast<DedicatedAllocationMemoryAllocateInfoNV const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DedicatedAllocationMemoryAllocateInfoNV &
      operator=( DedicatedAllocationMemoryAllocateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationMemoryAllocateInfoNV &
      operator=( VkDedicatedAllocationMemoryAllocateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DedicatedAllocationMemoryAllocateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationMemoryAllocateInfoNV &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationMemoryAllocateInfoNV &
                            setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationMemoryAllocateInfoNV &
                            setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDedicatedAllocationMemoryAllocateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDedicatedAllocationMemoryAllocateInfoNV *>( this );
    }

    operator VkDedicatedAllocationMemoryAllocateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDedicatedAllocationMemoryAllocateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DedicatedAllocationMemoryAllocateInfoNV const & ) const = default;
#else
    bool operator==( DedicatedAllocationMemoryAllocateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( image == rhs.image ) && ( buffer == rhs.buffer );
    }

    bool operator!=( DedicatedAllocationMemoryAllocateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eDedicatedAllocationMemoryAllocateInfoNV;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Image         image  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DedicatedAllocationMemoryAllocateInfoNV ) ==
                              sizeof( VkDedicatedAllocationMemoryAllocateInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::DedicatedAllocationMemoryAllocateInfoNV>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DedicatedAllocationMemoryAllocateInfoNV>::value,
    "DedicatedAllocationMemoryAllocateInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDedicatedAllocationMemoryAllocateInfoNV>
  {
    using Type = DedicatedAllocationMemoryAllocateInfoNV;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DedicatedAllocationMemoryAllocateInfoNV>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DedicatedAllocationMemoryAllocateInfoNV const &
                            dedicatedAllocationMemoryAllocateInfoNV ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, dedicatedAllocationMemoryAllocateInfoNV.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, dedicatedAllocationMemoryAllocateInfoNV.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, dedicatedAllocationMemoryAllocateInfoNV.image );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, dedicatedAllocationMemoryAllocateInfoNV.buffer );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct MemoryBarrier2KHR
  {
    using NativeType = VkMemoryBarrier2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eMemoryBarrier2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      MemoryBarrier2KHR( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR srcStageMask_  = {},
                         VULKAN_HPP_NAMESPACE::AccessFlags2KHR        srcAccessMask_ = {},
                         VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR dstStageMask_  = {},
                         VULKAN_HPP_NAMESPACE::AccessFlags2KHR        dstAccessMask_ = {} ) VULKAN_HPP_NOEXCEPT
      : srcStageMask( srcStageMask_ )
      , srcAccessMask( srcAccessMask_ )
      , dstStageMask( dstStageMask_ )
      , dstAccessMask( dstAccessMask_ )
    {}

    VULKAN_HPP_CONSTEXPR MemoryBarrier2KHR( MemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    MemoryBarrier2KHR( VkMemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : MemoryBarrier2KHR( *reinterpret_cast<MemoryBarrier2KHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    MemoryBarrier2KHR & operator=( MemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    MemoryBarrier2KHR & operator=( VkMemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2KHR &
      setSrcStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2KHR &
                            setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2KHR srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2KHR &
      setDstStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2KHR &
                            setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2KHR dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkMemoryBarrier2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkMemoryBarrier2KHR *>( this );
    }

    operator VkMemoryBarrier2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkMemoryBarrier2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( MemoryBarrier2KHR const & ) const = default;
#else
    bool operator==( MemoryBarrier2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) &&
             ( srcAccessMask == rhs.srcAccessMask ) && ( dstStageMask == rhs.dstStageMask ) &&
             ( dstAccessMask == rhs.dstAccessMask );
    }

    bool operator!=( MemoryBarrier2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType         = StructureType::eMemoryBarrier2KHR;
    const void *                                 pNext         = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR srcStageMask  = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2KHR        srcAccessMask = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR dstStageMask  = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2KHR        dstAccessMask = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR ) == sizeof( VkMemoryBarrier2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR>::value,
                            "MemoryBarrier2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eMemoryBarrier2KHR>
  {
    using Type = MemoryBarrier2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR const & memoryBarrier2KHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, memoryBarrier2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, memoryBarrier2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR, seed, memoryBarrier2KHR.srcStageMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccessFlags2KHR, seed, memoryBarrier2KHR.srcAccessMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR, seed, memoryBarrier2KHR.dstStageMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccessFlags2KHR, seed, memoryBarrier2KHR.dstAccessMask );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct ImageSubresourceRange
  {
    using NativeType = VkImageSubresourceRange;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageSubresourceRange( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_     = {},
                                                uint32_t                               baseMipLevel_   = {},
                                                uint32_t                               levelCount_     = {},
                                                uint32_t                               baseArrayLayer_ = {},
                                                uint32_t layerCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask( aspectMask_ )
      , baseMipLevel( baseMipLevel_ )
      , levelCount( levelCount_ )
      , baseArrayLayer( baseArrayLayer_ )
      , layerCount( layerCount_ )
    {}

    VULKAN_HPP_CONSTEXPR ImageSubresourceRange( ImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceRange( VkImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageSubresourceRange( *reinterpret_cast<ImageSubresourceRange const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageSubresourceRange & operator=( ImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceRange & operator=( VkImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageSubresourceRange const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange &
                            setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setBaseMipLevel( uint32_t baseMipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      baseMipLevel = baseMipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setLevelCount( uint32_t levelCount_ ) VULKAN_HPP_NOEXCEPT
    {
      levelCount = levelCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageSubresourceRange const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresourceRange *>( this );
    }

    operator VkImageSubresourceRange &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresourceRange *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresourceRange const & ) const = default;
#else
    bool operator==( ImageSubresourceRange const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( aspectMask == rhs.aspectMask ) && ( baseMipLevel == rhs.baseMipLevel ) &&
             ( levelCount == rhs.levelCount ) && ( baseArrayLayer == rhs.baseArrayLayer ) &&
             ( layerCount == rhs.layerCount );
    }

    bool operator!=( ImageSubresourceRange const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask     = {};
    uint32_t                               baseMipLevel   = {};
    uint32_t                               levelCount     = {};
    uint32_t                               baseArrayLayer = {};
    uint32_t                               layerCount     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageSubresourceRange ) == sizeof( VkImageSubresourceRange ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageSubresourceRange>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageSubresourceRange>::value,
                            "ImageSubresourceRange is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ImageSubresourceRange>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::ImageSubresourceRange const & imageSubresourceRange ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageAspectFlags, seed, imageSubresourceRange.aspectMask );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageSubresourceRange.baseMipLevel );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageSubresourceRange.levelCount );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageSubresourceRange.baseArrayLayer );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageSubresourceRange.layerCount );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct ImageMemoryBarrier2KHR
  {
    using NativeType = VkImageMemoryBarrier2KHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageMemoryBarrier2KHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageMemoryBarrier2KHR(
      VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR srcStageMask_        = {},
      VULKAN_HPP_NAMESPACE::AccessFlags2KHR        srcAccessMask_       = {},
      VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR dstStageMask_        = {},
      VULKAN_HPP_NAMESPACE::AccessFlags2KHR        dstAccessMask_       = {},
      VULKAN_HPP_NAMESPACE::ImageLayout            oldLayout_           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      VULKAN_HPP_NAMESPACE::ImageLayout            newLayout_           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
      uint32_t                                     srcQueueFamilyIndex_ = {},
      uint32_t                                     dstQueueFamilyIndex_ = {},
      VULKAN_HPP_NAMESPACE::Image                  image_               = {},
      VULKAN_HPP_NAMESPACE::ImageSubresourceRange  subresourceRange_    = {} ) VULKAN_HPP_NOEXCEPT
      : srcStageMask( srcStageMask_ )
      , srcAccessMask( srcAccessMask_ )
      , dstStageMask( dstStageMask_ )
      , dstAccessMask( dstAccessMask_ )
      , oldLayout( oldLayout_ )
      , newLayout( newLayout_ )
      , srcQueueFamilyIndex( srcQueueFamilyIndex_ )
      , dstQueueFamilyIndex( dstQueueFamilyIndex_ )
      , image( image_ )
      , subresourceRange( subresourceRange_ )
    {}

    VULKAN_HPP_CONSTEXPR ImageMemoryBarrier2KHR( ImageMemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageMemoryBarrier2KHR( VkImageMemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageMemoryBarrier2KHR( *reinterpret_cast<ImageMemoryBarrier2KHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageMemoryBarrier2KHR & operator=( ImageMemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageMemoryBarrier2KHR & operator=( VkImageMemoryBarrier2KHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR &
      setSrcStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR &
                            setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2KHR srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR &
      setDstStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR &
                            setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2KHR dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR &
                            setOldLayout( VULKAN_HPP_NAMESPACE::ImageLayout oldLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      oldLayout = oldLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR &
                            setNewLayout( VULKAN_HPP_NAMESPACE::ImageLayout newLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      newLayout = newLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR &
                            setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR &
                            setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2KHR &
      setSubresourceRange( VULKAN_HPP_NAMESPACE::ImageSubresourceRange const & subresourceRange_ ) VULKAN_HPP_NOEXCEPT
    {
      subresourceRange = subresourceRange_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkImageMemoryBarrier2KHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageMemoryBarrier2KHR *>( this );
    }

    operator VkImageMemoryBarrier2KHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageMemoryBarrier2KHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageMemoryBarrier2KHR const & ) const = default;
#else
    bool operator==( ImageMemoryBarrier2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) &&
             ( srcAccessMask == rhs.srcAccessMask ) && ( dstStageMask == rhs.dstStageMask ) &&
             ( dstAccessMask == rhs.dstAccessMask ) && ( oldLayout == rhs.oldLayout ) &&
             ( newLayout == rhs.newLayout ) && ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) &&
             ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( image == rhs.image ) &&
             ( subresourceRange == rhs.subresourceRange );
    }

    bool operator!=( ImageMemoryBarrier2KHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType               = StructureType::eImageMemoryBarrier2KHR;
    const void *                                 pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR srcStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2KHR        srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR dstStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2KHR        dstAccessMask       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout            oldLayout           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout            newLayout           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                     srcQueueFamilyIndex = {};
    uint32_t                                     dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Image                  image               = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceRange  subresourceRange    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR ) ==
                              sizeof( VkImageMemoryBarrier2KHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR>::value,
                            "ImageMemoryBarrier2KHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eImageMemoryBarrier2KHR>
  {
    using Type = ImageMemoryBarrier2KHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR const & imageMemoryBarrier2KHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, imageMemoryBarrier2KHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, imageMemoryBarrier2KHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR, seed, imageMemoryBarrier2KHR.srcStageMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccessFlags2KHR, seed, imageMemoryBarrier2KHR.srcAccessMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::PipelineStageFlags2KHR, seed, imageMemoryBarrier2KHR.dstStageMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::AccessFlags2KHR, seed, imageMemoryBarrier2KHR.dstAccessMask );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, imageMemoryBarrier2KHR.oldLayout );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, imageMemoryBarrier2KHR.newLayout );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageMemoryBarrier2KHR.srcQueueFamilyIndex );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, imageMemoryBarrier2KHR.dstQueueFamilyIndex );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Image, seed, imageMemoryBarrier2KHR.image );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::ImageSubresourceRange, seed, imageMemoryBarrier2KHR.subresourceRange );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DependencyInfoKHR
  {
    using NativeType = VkDependencyInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDependencyInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DependencyInfoKHR(
      VULKAN_HPP_NAMESPACE::DependencyFlags                 dependencyFlags_          = {},
      uint32_t                                              memoryBarrierCount_       = {},
      const VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR *       pMemoryBarriers_          = {},
      uint32_t                                              bufferMemoryBarrierCount_ = {},
      const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR * pBufferMemoryBarriers_    = {},
      uint32_t                                              imageMemoryBarrierCount_  = {},
      const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR *  pImageMemoryBarriers_     = {} ) VULKAN_HPP_NOEXCEPT
      : dependencyFlags( dependencyFlags_ )
      , memoryBarrierCount( memoryBarrierCount_ )
      , pMemoryBarriers( pMemoryBarriers_ )
      , bufferMemoryBarrierCount( bufferMemoryBarrierCount_ )
      , pBufferMemoryBarriers( pBufferMemoryBarriers_ )
      , imageMemoryBarrierCount( imageMemoryBarrierCount_ )
      , pImageMemoryBarriers( pImageMemoryBarriers_ )
    {}

    VULKAN_HPP_CONSTEXPR DependencyInfoKHR( DependencyInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DependencyInfoKHR( VkDependencyInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DependencyInfoKHR( *reinterpret_cast<DependencyInfoKHR const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfoKHR(
      VULKAN_HPP_NAMESPACE::DependencyFlags dependencyFlags_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR> const &
        memoryBarriers_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR> const &
        bufferMemoryBarriers_ = {},
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR> const &
        imageMemoryBarriers_ = {} )
      : dependencyFlags( dependencyFlags_ )
      , memoryBarrierCount( static_cast<uint32_t>( memoryBarriers_.size() ) )
      , pMemoryBarriers( memoryBarriers_.data() )
      , bufferMemoryBarrierCount( static_cast<uint32_t>( bufferMemoryBarriers_.size() ) )
      , pBufferMemoryBarriers( bufferMemoryBarriers_.data() )
      , imageMemoryBarrierCount( static_cast<uint32_t>( imageMemoryBarriers_.size() ) )
      , pImageMemoryBarriers( imageMemoryBarriers_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DependencyInfoKHR & operator=( DependencyInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DependencyInfoKHR & operator=( VkDependencyInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DependencyInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DependencyInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfoKHR &
      setDependencyFlags( VULKAN_HPP_NAMESPACE::DependencyFlags dependencyFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      dependencyFlags = dependencyFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfoKHR &
                            setMemoryBarrierCount( uint32_t memoryBarrierCount_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryBarrierCount = memoryBarrierCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfoKHR &
      setPMemoryBarriers( const VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR * pMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      pMemoryBarriers = pMemoryBarriers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfoKHR & setMemoryBarriers(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR> const &
        memoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryBarrierCount = static_cast<uint32_t>( memoryBarriers_.size() );
      pMemoryBarriers    = memoryBarriers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DependencyInfoKHR &
                            setBufferMemoryBarrierCount( uint32_t bufferMemoryBarrierCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferMemoryBarrierCount = bufferMemoryBarrierCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfoKHR & setPBufferMemoryBarriers(
      const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR * pBufferMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      pBufferMemoryBarriers = pBufferMemoryBarriers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfoKHR & setBufferMemoryBarriers(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR> const &
        bufferMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferMemoryBarrierCount = static_cast<uint32_t>( bufferMemoryBarriers_.size() );
      pBufferMemoryBarriers    = bufferMemoryBarriers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DependencyInfoKHR &
                            setImageMemoryBarrierCount( uint32_t imageMemoryBarrierCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageMemoryBarrierCount = imageMemoryBarrierCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfoKHR & setPImageMemoryBarriers(
      const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR * pImageMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageMemoryBarriers = pImageMemoryBarriers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfoKHR & setImageMemoryBarriers(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR> const &
        imageMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      imageMemoryBarrierCount = static_cast<uint32_t>( imageMemoryBarriers_.size() );
      pImageMemoryBarriers    = imageMemoryBarriers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDependencyInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDependencyInfoKHR *>( this );
    }

    operator VkDependencyInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDependencyInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DependencyInfoKHR const & ) const = default;
#else
    bool operator==( DependencyInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( dependencyFlags == rhs.dependencyFlags ) &&
             ( memoryBarrierCount == rhs.memoryBarrierCount ) && ( pMemoryBarriers == rhs.pMemoryBarriers ) &&
             ( bufferMemoryBarrierCount == rhs.bufferMemoryBarrierCount ) &&
             ( pBufferMemoryBarriers == rhs.pBufferMemoryBarriers ) &&
             ( imageMemoryBarrierCount == rhs.imageMemoryBarrierCount ) &&
             ( pImageMemoryBarriers == rhs.pImageMemoryBarriers );
    }

    bool operator!=( DependencyInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                   sType                    = StructureType::eDependencyInfoKHR;
    const void *                                          pNext                    = {};
    VULKAN_HPP_NAMESPACE::DependencyFlags                 dependencyFlags          = {};
    uint32_t                                              memoryBarrierCount       = {};
    const VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR *       pMemoryBarriers          = {};
    uint32_t                                              bufferMemoryBarrierCount = {};
    const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR * pBufferMemoryBarriers    = {};
    uint32_t                                              imageMemoryBarrierCount  = {};
    const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR *  pImageMemoryBarriers     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DependencyInfoKHR ) == sizeof( VkDependencyInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DependencyInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DependencyInfoKHR>::value,
                            "DependencyInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDependencyInfoKHR>
  {
    using Type = DependencyInfoKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DependencyInfoKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DependencyInfoKHR const & dependencyInfoKHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, dependencyInfoKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, dependencyInfoKHR.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DependencyFlags, seed, dependencyInfoKHR.dependencyFlags );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, dependencyInfoKHR.memoryBarrierCount );
    VULKAN_HPP_HASH_COMBINE( const VULKAN_HPP_NAMESPACE::MemoryBarrier2KHR *, seed, dependencyInfoKHR.pMemoryBarriers );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, dependencyInfoKHR.bufferMemoryBarrierCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2KHR *, seed, dependencyInfoKHR.pBufferMemoryBarriers );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, dependencyInfoKHR.imageMemoryBarrierCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2KHR *, seed, dependencyInfoKHR.pImageMemoryBarriers );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorBufferInfo
  {
    using NativeType = VkDescriptorBufferInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorBufferInfo( VULKAN_HPP_NAMESPACE::Buffer     buffer_ = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize offset_ = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize range_  = {} ) VULKAN_HPP_NOEXCEPT
      : buffer( buffer_ )
      , offset( offset_ )
      , range( range_ )
    {}

    VULKAN_HPP_CONSTEXPR DescriptorBufferInfo( DescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorBufferInfo( VkDescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorBufferInfo( *reinterpret_cast<DescriptorBufferInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorBufferInfo & operator=( DescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorBufferInfo & operator=( VkDescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorBufferInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorBufferInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorBufferInfo &
                            setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorBufferInfo &
                            setRange( VULKAN_HPP_NAMESPACE::DeviceSize range_ ) VULKAN_HPP_NOEXCEPT
    {
      range = range_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorBufferInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorBufferInfo *>( this );
    }

    operator VkDescriptorBufferInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorBufferInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorBufferInfo const & ) const = default;
#else
    bool operator==( DescriptorBufferInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( range == rhs.range );
    }

    bool operator!=( DescriptorBufferInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Buffer     buffer = {};
    VULKAN_HPP_NAMESPACE::DeviceSize offset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize range  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorBufferInfo ) == sizeof( VkDescriptorBufferInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorBufferInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorBufferInfo>::value,
                            "DescriptorBufferInfo is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorBufferInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::DescriptorBufferInfo const & descriptorBufferInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Buffer, seed, descriptorBufferInfo.buffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, descriptorBufferInfo.offset );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceSize, seed, descriptorBufferInfo.range );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorImageInfo
  {
    using NativeType = VkDescriptorImageInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorImageInfo( VULKAN_HPP_NAMESPACE::Sampler     sampler_   = {},
                                              VULKAN_HPP_NAMESPACE::ImageView   imageView_ = {},
                                              VULKAN_HPP_NAMESPACE::ImageLayout imageLayout_ =
                                                VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : sampler( sampler_ )
      , imageView( imageView_ )
      , imageLayout( imageLayout_ )
    {}

    VULKAN_HPP_CONSTEXPR DescriptorImageInfo( DescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorImageInfo( VkDescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorImageInfo( *reinterpret_cast<DescriptorImageInfo const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorImageInfo & operator=( DescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorImageInfo & operator=( VkDescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorImageInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorImageInfo &
                            setSampler( VULKAN_HPP_NAMESPACE::Sampler sampler_ ) VULKAN_HPP_NOEXCEPT
    {
      sampler = sampler_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorImageInfo &
                            setImageView( VULKAN_HPP_NAMESPACE::ImageView imageView_ ) VULKAN_HPP_NOEXCEPT
    {
      imageView = imageView_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorImageInfo &
                            setImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout imageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      imageLayout = imageLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorImageInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorImageInfo *>( this );
    }

    operator VkDescriptorImageInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorImageInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorImageInfo const & ) const = default;
#else
    bool operator==( DescriptorImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sampler == rhs.sampler ) && ( imageView == rhs.imageView ) && ( imageLayout == rhs.imageLayout );
    }

    bool operator!=( DescriptorImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Sampler     sampler     = {};
    VULKAN_HPP_NAMESPACE::ImageView   imageView   = {};
    VULKAN_HPP_NAMESPACE::ImageLayout imageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorImageInfo ) == sizeof( VkDescriptorImageInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorImageInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorImageInfo>::value,
                            "DescriptorImageInfo is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorImageInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::DescriptorImageInfo const & descriptorImageInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Sampler, seed, descriptorImageInfo.sampler );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageView, seed, descriptorImageInfo.imageView );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ImageLayout, seed, descriptorImageInfo.imageLayout );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorPoolSize
  {
    using NativeType = VkDescriptorPoolSize;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DescriptorPoolSize( VULKAN_HPP_NAMESPACE::DescriptorType type_ = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler,
                          uint32_t                             descriptorCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : type( type_ )
      , descriptorCount( descriptorCount_ )
    {}

    VULKAN_HPP_CONSTEXPR DescriptorPoolSize( DescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolSize( VkDescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorPoolSize( *reinterpret_cast<DescriptorPoolSize const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorPoolSize & operator=( DescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolSize & operator=( VkDescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorPoolSize const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolSize &
                            setType( VULKAN_HPP_NAMESPACE::DescriptorType type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolSize & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorPoolSize const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorPoolSize *>( this );
    }

    operator VkDescriptorPoolSize &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorPoolSize *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorPoolSize const & ) const = default;
#else
    bool operator==( DescriptorPoolSize const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( type == rhs.type ) && ( descriptorCount == rhs.descriptorCount );
    }

    bool operator!=( DescriptorPoolSize const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DescriptorType type            = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler;
    uint32_t                             descriptorCount = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorPoolSize ) == sizeof( VkDescriptorPoolSize ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorPoolSize>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorPoolSize>::value,
                            "DescriptorPoolSize is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorPoolSize>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::DescriptorPoolSize const & descriptorPoolSize ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DescriptorType, seed, descriptorPoolSize.type );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorPoolSize.descriptorCount );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorPoolCreateInfo
  {
    using NativeType = VkDescriptorPoolCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorPoolCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DescriptorPoolCreateInfo( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags  flags_         = {},
                                uint32_t                                         maxSets_       = {},
                                uint32_t                                         poolSizeCount_ = {},
                                const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * pPoolSizes_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , maxSets( maxSets_ )
      , poolSizeCount( poolSizeCount_ )
      , pPoolSizes( pPoolSizes_ )
    {}

    VULKAN_HPP_CONSTEXPR DescriptorPoolCreateInfo( DescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolCreateInfo( VkDescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorPoolCreateInfo( *reinterpret_cast<DescriptorPoolCreateInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorPoolCreateInfo(
      VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags                                                       flags_,
      uint32_t                                                                                              maxSets_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorPoolSize> const & poolSizes_ )
      : flags( flags_ )
      , maxSets( maxSets_ )
      , poolSizeCount( static_cast<uint32_t>( poolSizes_.size() ) )
      , pPoolSizes( poolSizes_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorPoolCreateInfo & operator=( DescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolCreateInfo & operator=( VkDescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setMaxSets( uint32_t maxSets_ ) VULKAN_HPP_NOEXCEPT
    {
      maxSets = maxSets_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setPoolSizeCount( uint32_t poolSizeCount_ ) VULKAN_HPP_NOEXCEPT
    {
      poolSizeCount = poolSizeCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo &
      setPPoolSizes( const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * pPoolSizes_ ) VULKAN_HPP_NOEXCEPT
    {
      pPoolSizes = pPoolSizes_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorPoolCreateInfo & setPoolSizes(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorPoolSize> const & poolSizes_ )
      VULKAN_HPP_NOEXCEPT
    {
      poolSizeCount = static_cast<uint32_t>( poolSizes_.size() );
      pPoolSizes    = poolSizes_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorPoolCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorPoolCreateInfo *>( this );
    }

    operator VkDescriptorPoolCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorPoolCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorPoolCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( maxSets == rhs.maxSets ) &&
             ( poolSizeCount == rhs.poolSizeCount ) && ( pPoolSizes == rhs.pPoolSizes );
    }

    bool operator!=( DescriptorPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType              sType         = StructureType::eDescriptorPoolCreateInfo;
    const void *                                     pNext         = {};
    VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags  flags         = {};
    uint32_t                                         maxSets       = {};
    uint32_t                                         poolSizeCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * pPoolSizes    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo ) ==
                              sizeof( VkDescriptorPoolCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo>::value,
                            "DescriptorPoolCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorPoolCreateInfo>
  {
    using Type = DescriptorPoolCreateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo const & descriptorPoolCreateInfo ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, descriptorPoolCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, descriptorPoolCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags, seed, descriptorPoolCreateInfo.flags );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorPoolCreateInfo.maxSets );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorPoolCreateInfo.poolSizeCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::DescriptorPoolSize *, seed, descriptorPoolCreateInfo.pPoolSizes );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorPoolInlineUniformBlockCreateInfoEXT
  {
    using NativeType = VkDescriptorPoolInlineUniformBlockCreateInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDescriptorPoolInlineUniformBlockCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DescriptorPoolInlineUniformBlockCreateInfoEXT( uint32_t maxInlineUniformBlockBindings_ = {} ) VULKAN_HPP_NOEXCEPT
      : maxInlineUniformBlockBindings( maxInlineUniformBlockBindings_ )
    {}

    VULKAN_HPP_CONSTEXPR DescriptorPoolInlineUniformBlockCreateInfoEXT(
      DescriptorPoolInlineUniformBlockCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolInlineUniformBlockCreateInfoEXT( VkDescriptorPoolInlineUniformBlockCreateInfoEXT const & rhs )
      VULKAN_HPP_NOEXCEPT
      : DescriptorPoolInlineUniformBlockCreateInfoEXT(
          *reinterpret_cast<DescriptorPoolInlineUniformBlockCreateInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorPoolInlineUniformBlockCreateInfoEXT &
      operator=( DescriptorPoolInlineUniformBlockCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolInlineUniformBlockCreateInfoEXT &
      operator=( VkDescriptorPoolInlineUniformBlockCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolInlineUniformBlockCreateInfoEXT &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolInlineUniformBlockCreateInfoEXT &
      setMaxInlineUniformBlockBindings( uint32_t maxInlineUniformBlockBindings_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInlineUniformBlockBindings = maxInlineUniformBlockBindings_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorPoolInlineUniformBlockCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorPoolInlineUniformBlockCreateInfoEXT *>( this );
    }

    operator VkDescriptorPoolInlineUniformBlockCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorPoolInlineUniformBlockCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorPoolInlineUniformBlockCreateInfoEXT const & ) const = default;
#else
    bool operator==( DescriptorPoolInlineUniformBlockCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( maxInlineUniformBlockBindings == rhs.maxInlineUniformBlockBindings );
    }

    bool operator!=( DescriptorPoolInlineUniformBlockCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eDescriptorPoolInlineUniformBlockCreateInfoEXT;
    const void *                        pNext = {};
    uint32_t                            maxInlineUniformBlockBindings = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfoEXT ) ==
                              sizeof( VkDescriptorPoolInlineUniformBlockCreateInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfoEXT>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfoEXT>::value,
    "DescriptorPoolInlineUniformBlockCreateInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorPoolInlineUniformBlockCreateInfoEXT>
  {
    using Type = DescriptorPoolInlineUniformBlockCreateInfoEXT;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfoEXT>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfoEXT const &
                            descriptorPoolInlineUniformBlockCreateInfoEXT ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, descriptorPoolInlineUniformBlockCreateInfoEXT.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, descriptorPoolInlineUniformBlockCreateInfoEXT.pNext );
    VULKAN_HPP_HASH_COMBINE(
      uint32_t, seed, descriptorPoolInlineUniformBlockCreateInfoEXT.maxInlineUniformBlockBindings );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorSetAllocateInfo
  {
    using NativeType = VkDescriptorSetAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetAllocateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetAllocateInfo(
      VULKAN_HPP_NAMESPACE::DescriptorPool              descriptorPool_     = {},
      uint32_t                                          descriptorSetCount_ = {},
      const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * pSetLayouts_        = {} ) VULKAN_HPP_NOEXCEPT
      : descriptorPool( descriptorPool_ )
      , descriptorSetCount( descriptorSetCount_ )
      , pSetLayouts( pSetLayouts_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DescriptorSetAllocateInfo( DescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetAllocateInfo( VkDescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetAllocateInfo( *reinterpret_cast<DescriptorSetAllocateInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetAllocateInfo(
      VULKAN_HPP_NAMESPACE::DescriptorPool descriptorPool_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayout> const &
        setLayouts_ )
      : descriptorPool( descriptorPool_ )
      , descriptorSetCount( static_cast<uint32_t>( setLayouts_.size() ) )
      , pSetLayouts( setLayouts_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetAllocateInfo & operator=( DescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetAllocateInfo & operator=( VkDescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo &
      setDescriptorPool( VULKAN_HPP_NAMESPACE::DescriptorPool descriptorPool_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorPool = descriptorPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo &
                            setDescriptorSetCount( uint32_t descriptorSetCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = descriptorSetCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo &
      setPSetLayouts( const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * pSetLayouts_ ) VULKAN_HPP_NOEXCEPT
    {
      pSetLayouts = pSetLayouts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetAllocateInfo & setSetLayouts(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayout> const &
        setLayouts_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = static_cast<uint32_t>( setLayouts_.size() );
      pSetLayouts        = setLayouts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorSetAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetAllocateInfo *>( this );
    }

    operator VkDescriptorSetAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetAllocateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( descriptorPool == rhs.descriptorPool ) &&
             ( descriptorSetCount == rhs.descriptorSetCount ) && ( pSetLayouts == rhs.pSetLayouts );
    }

    bool operator!=( DescriptorSetAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType              = StructureType::eDescriptorSetAllocateInfo;
    const void *                                      pNext              = {};
    VULKAN_HPP_NAMESPACE::DescriptorPool              descriptorPool     = {};
    uint32_t                                          descriptorSetCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * pSetLayouts        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo ) ==
                              sizeof( VkDescriptorSetAllocateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo>::value,
                            "DescriptorSetAllocateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetAllocateInfo>
  {
    using Type = DescriptorSetAllocateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo const & descriptorSetAllocateInfo ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, descriptorSetAllocateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, descriptorSetAllocateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DescriptorPool, seed, descriptorSetAllocateInfo.descriptorPool );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorSetAllocateInfo.descriptorSetCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::DescriptorSetLayout *, seed, descriptorSetAllocateInfo.pSetLayouts );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorSetLayoutBinding
  {
    using NativeType = VkDescriptorSetLayoutBinding;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBinding(
      uint32_t                               binding_            = {},
      VULKAN_HPP_NAMESPACE::DescriptorType   descriptorType_     = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler,
      uint32_t                               descriptorCount_    = {},
      VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags_         = {},
      const VULKAN_HPP_NAMESPACE::Sampler *  pImmutableSamplers_ = {} ) VULKAN_HPP_NOEXCEPT
      : binding( binding_ )
      , descriptorType( descriptorType_ )
      , descriptorCount( descriptorCount_ )
      , stageFlags( stageFlags_ )
      , pImmutableSamplers( pImmutableSamplers_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DescriptorSetLayoutBinding( DescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutBinding( VkDescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutBinding( *reinterpret_cast<DescriptorSetLayoutBinding const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBinding(
      uint32_t                                                                                   binding_,
      VULKAN_HPP_NAMESPACE::DescriptorType                                                       descriptorType_,
      VULKAN_HPP_NAMESPACE::ShaderStageFlags                                                     stageFlags_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Sampler> const & immutableSamplers_ )
      : binding( binding_ )
      , descriptorType( descriptorType_ )
      , descriptorCount( static_cast<uint32_t>( immutableSamplers_.size() ) )
      , stageFlags( stageFlags_ )
      , pImmutableSamplers( immutableSamplers_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutBinding & operator=( DescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutBinding & operator=( VkDescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setBinding( uint32_t binding_ ) VULKAN_HPP_NOEXCEPT
    {
      binding = binding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding &
      setDescriptorType( VULKAN_HPP_NAMESPACE::DescriptorType descriptorType_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorType = descriptorType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding &
                            setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding &
                            setStageFlags( VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      stageFlags = stageFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding &
      setPImmutableSamplers( const VULKAN_HPP_NAMESPACE::Sampler * pImmutableSamplers_ ) VULKAN_HPP_NOEXCEPT
    {
      pImmutableSamplers = pImmutableSamplers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBinding & setImmutableSamplers(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Sampler> const & immutableSamplers_ )
      VULKAN_HPP_NOEXCEPT
    {
      descriptorCount    = static_cast<uint32_t>( immutableSamplers_.size() );
      pImmutableSamplers = immutableSamplers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorSetLayoutBinding const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutBinding *>( this );
    }

    operator VkDescriptorSetLayoutBinding &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutBinding *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutBinding const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutBinding const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( binding == rhs.binding ) && ( descriptorType == rhs.descriptorType ) &&
             ( descriptorCount == rhs.descriptorCount ) && ( stageFlags == rhs.stageFlags ) &&
             ( pImmutableSamplers == rhs.pImmutableSamplers );
    }

    bool operator!=( DescriptorSetLayoutBinding const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                               binding            = {};
    VULKAN_HPP_NAMESPACE::DescriptorType   descriptorType     = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler;
    uint32_t                               descriptorCount    = {};
    VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags         = {};
    const VULKAN_HPP_NAMESPACE::Sampler *  pImmutableSamplers = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding ) ==
                              sizeof( VkDescriptorSetLayoutBinding ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding>::value,
                            "DescriptorSetLayoutBinding is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding const & descriptorSetLayoutBinding ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorSetLayoutBinding.binding );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DescriptorType, seed, descriptorSetLayoutBinding.descriptorType );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorSetLayoutBinding.descriptorCount );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::ShaderStageFlags, seed, descriptorSetLayoutBinding.stageFlags );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::Sampler *, seed, descriptorSetLayoutBinding.pImmutableSamplers );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorSetLayoutBindingFlagsCreateInfo
  {
    using NativeType = VkDescriptorSetLayoutBindingFlagsCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDescriptorSetLayoutBindingFlagsCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBindingFlagsCreateInfo(
      uint32_t                                             bindingCount_  = {},
      const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * pBindingFlags_ = {} ) VULKAN_HPP_NOEXCEPT
      : bindingCount( bindingCount_ )
      , pBindingFlags( pBindingFlags_ )
    {}

    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBindingFlagsCreateInfo(
      DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutBindingFlagsCreateInfo( VkDescriptorSetLayoutBindingFlagsCreateInfo const & rhs )
      VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutBindingFlagsCreateInfo(
          *reinterpret_cast<DescriptorSetLayoutBindingFlagsCreateInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBindingFlagsCreateInfo(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags> const &
        bindingFlags_ )
      : bindingCount( static_cast<uint32_t>( bindingFlags_.size() ) ), pBindingFlags( bindingFlags_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutBindingFlagsCreateInfo &
      operator=( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutBindingFlagsCreateInfo &
      operator=( VkDescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBindingFlagsCreateInfo &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBindingFlagsCreateInfo &
                            setBindingCount( uint32_t bindingCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount = bindingCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBindingFlagsCreateInfo &
      setPBindingFlags( const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * pBindingFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      pBindingFlags = pBindingFlags_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBindingFlagsCreateInfo & setBindingFlags(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags> const &
        bindingFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount  = static_cast<uint32_t>( bindingFlags_.size() );
      pBindingFlags = bindingFlags_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorSetLayoutBindingFlagsCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutBindingFlagsCreateInfo *>( this );
    }

    operator VkDescriptorSetLayoutBindingFlagsCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutBindingFlagsCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutBindingFlagsCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( bindingCount == rhs.bindingCount ) &&
             ( pBindingFlags == rhs.pBindingFlags );
    }

    bool operator!=( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eDescriptorSetLayoutBindingFlagsCreateInfo;
    const void *                        pNext        = {};
    uint32_t                            bindingCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * pBindingFlags = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo ) ==
                              sizeof( VkDescriptorSetLayoutBindingFlagsCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo>::value,
    "DescriptorSetLayoutBindingFlagsCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetLayoutBindingFlagsCreateInfo>
  {
    using Type = DescriptorSetLayoutBindingFlagsCreateInfo;
  };
  using DescriptorSetLayoutBindingFlagsCreateInfoEXT = DescriptorSetLayoutBindingFlagsCreateInfo;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo const &
                            descriptorSetLayoutBindingFlagsCreateInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, descriptorSetLayoutBindingFlagsCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, descriptorSetLayoutBindingFlagsCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorSetLayoutBindingFlagsCreateInfo.bindingCount );
    VULKAN_HPP_HASH_COMBINE( const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags *,
                             seed,
                             descriptorSetLayoutBindingFlagsCreateInfo.pBindingFlags );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorSetLayoutCreateInfo
  {
    using NativeType = VkDescriptorSetLayoutCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetLayoutCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutCreateInfo(
      VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags     flags_        = {},
      uint32_t                                                 bindingCount_ = {},
      const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * pBindings_    = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , bindingCount( bindingCount_ )
      , pBindings( pBindings_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DescriptorSetLayoutCreateInfo( DescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutCreateInfo( VkDescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutCreateInfo( *reinterpret_cast<DescriptorSetLayoutCreateInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutCreateInfo(
      VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags flags_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding> const &
        bindings_ )
      : flags( flags_ ), bindingCount( static_cast<uint32_t>( bindings_.size() ) ), pBindings( bindings_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutCreateInfo &
      operator=( DescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutCreateInfo & operator=( VkDescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo &
                            setBindingCount( uint32_t bindingCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount = bindingCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo &
      setPBindings( const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * pBindings_ ) VULKAN_HPP_NOEXCEPT
    {
      pBindings = pBindings_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutCreateInfo & setBindings(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding> const &
        bindings_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount = static_cast<uint32_t>( bindings_.size() );
      pBindings    = bindings_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorSetLayoutCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutCreateInfo *>( this );
    }

    operator VkDescriptorSetLayoutCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( bindingCount == rhs.bindingCount ) && ( pBindings == rhs.pBindings );
    }

    bool operator!=( DescriptorSetLayoutCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                      sType = StructureType::eDescriptorSetLayoutCreateInfo;
    const void *                                             pNext = {};
    VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags     flags = {};
    uint32_t                                                 bindingCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * pBindings    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo ) ==
                              sizeof( VkDescriptorSetLayoutCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo>::value,
    "DescriptorSetLayoutCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetLayoutCreateInfo>
  {
    using Type = DescriptorSetLayoutCreateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo const & descriptorSetLayoutCreateInfo )
    const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, descriptorSetLayoutCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, descriptorSetLayoutCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags, seed, descriptorSetLayoutCreateInfo.flags );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorSetLayoutCreateInfo.bindingCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding *, seed, descriptorSetLayoutCreateInfo.pBindings );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorSetLayoutSupport
  {
    using NativeType = VkDescriptorSetLayoutSupport;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetLayoutSupport;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutSupport( VULKAN_HPP_NAMESPACE::Bool32 supported_ = {} ) VULKAN_HPP_NOEXCEPT
      : supported( supported_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DescriptorSetLayoutSupport( DescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutSupport( VkDescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutSupport( *reinterpret_cast<DescriptorSetLayoutSupport const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutSupport & operator=( DescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutSupport & operator=( VkDescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport const *>( &rhs );
      return *this;
    }

    operator VkDescriptorSetLayoutSupport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutSupport *>( this );
    }

    operator VkDescriptorSetLayoutSupport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutSupport *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutSupport const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( supported == rhs.supported );
    }

    bool operator!=( DescriptorSetLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType     = StructureType::eDescriptorSetLayoutSupport;
    void *                              pNext     = {};
    VULKAN_HPP_NAMESPACE::Bool32        supported = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport ) ==
                              sizeof( VkDescriptorSetLayoutSupport ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport>::value,
                            "DescriptorSetLayoutSupport is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetLayoutSupport>
  {
    using Type = DescriptorSetLayoutSupport;
  };
  using DescriptorSetLayoutSupportKHR = DescriptorSetLayoutSupport;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport const & descriptorSetLayoutSupport ) const
    VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, descriptorSetLayoutSupport.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, descriptorSetLayoutSupport.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, descriptorSetLayoutSupport.supported );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorSetVariableDescriptorCountAllocateInfo
  {
    using NativeType = VkDescriptorSetVariableDescriptorCountAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDescriptorSetVariableDescriptorCountAllocateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DescriptorSetVariableDescriptorCountAllocateInfo( uint32_t         descriptorSetCount_ = {},
                                                        const uint32_t * pDescriptorCounts_  = {} ) VULKAN_HPP_NOEXCEPT
      : descriptorSetCount( descriptorSetCount_ )
      , pDescriptorCounts( pDescriptorCounts_ )
    {}

    VULKAN_HPP_CONSTEXPR DescriptorSetVariableDescriptorCountAllocateInfo(
      DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetVariableDescriptorCountAllocateInfo( VkDescriptorSetVariableDescriptorCountAllocateInfo const & rhs )
      VULKAN_HPP_NOEXCEPT
      : DescriptorSetVariableDescriptorCountAllocateInfo(
          *reinterpret_cast<DescriptorSetVariableDescriptorCountAllocateInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetVariableDescriptorCountAllocateInfo(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & descriptorCounts_ )
      : descriptorSetCount( static_cast<uint32_t>( descriptorCounts_.size() ) )
      , pDescriptorCounts( descriptorCounts_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetVariableDescriptorCountAllocateInfo &
      operator=( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetVariableDescriptorCountAllocateInfo &
      operator=( VkDescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetVariableDescriptorCountAllocateInfo &
                            setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetVariableDescriptorCountAllocateInfo &
                            setDescriptorSetCount( uint32_t descriptorSetCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = descriptorSetCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetVariableDescriptorCountAllocateInfo &
                            setPDescriptorCounts( const uint32_t * pDescriptorCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      pDescriptorCounts = pDescriptorCounts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetVariableDescriptorCountAllocateInfo & setDescriptorCounts(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & descriptorCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = static_cast<uint32_t>( descriptorCounts_.size() );
      pDescriptorCounts  = descriptorCounts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorSetVariableDescriptorCountAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetVariableDescriptorCountAllocateInfo *>( this );
    }

    operator VkDescriptorSetVariableDescriptorCountAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetVariableDescriptorCountAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetVariableDescriptorCountAllocateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( descriptorSetCount == rhs.descriptorSetCount ) &&
             ( pDescriptorCounts == rhs.pDescriptorCounts );
    }

    bool operator!=( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eDescriptorSetVariableDescriptorCountAllocateInfo;
    const void *                        pNext = {};
    uint32_t                            descriptorSetCount = {};
    const uint32_t *                    pDescriptorCounts  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo ) ==
                              sizeof( VkDescriptorSetVariableDescriptorCountAllocateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo>::value,
    "DescriptorSetVariableDescriptorCountAllocateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetVariableDescriptorCountAllocateInfo>
  {
    using Type = DescriptorSetVariableDescriptorCountAllocateInfo;
  };
  using DescriptorSetVariableDescriptorCountAllocateInfoEXT = DescriptorSetVariableDescriptorCountAllocateInfo;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo const &
                            descriptorSetVariableDescriptorCountAllocateInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, descriptorSetVariableDescriptorCountAllocateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, descriptorSetVariableDescriptorCountAllocateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorSetVariableDescriptorCountAllocateInfo.descriptorSetCount );
    VULKAN_HPP_HASH_COMBINE(
      const uint32_t *, seed, descriptorSetVariableDescriptorCountAllocateInfo.pDescriptorCounts );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorSetVariableDescriptorCountLayoutSupport
  {
    using NativeType = VkDescriptorSetVariableDescriptorCountLayoutSupport;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDescriptorSetVariableDescriptorCountLayoutSupport;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DescriptorSetVariableDescriptorCountLayoutSupport( uint32_t maxVariableDescriptorCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : maxVariableDescriptorCount( maxVariableDescriptorCount_ )
    {}

    VULKAN_HPP_CONSTEXPR DescriptorSetVariableDescriptorCountLayoutSupport(
      DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetVariableDescriptorCountLayoutSupport( VkDescriptorSetVariableDescriptorCountLayoutSupport const & rhs )
      VULKAN_HPP_NOEXCEPT
      : DescriptorSetVariableDescriptorCountLayoutSupport(
          *reinterpret_cast<DescriptorSetVariableDescriptorCountLayoutSupport const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetVariableDescriptorCountLayoutSupport &
      operator=( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetVariableDescriptorCountLayoutSupport &
      operator=( VkDescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this =
        *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport const *>( &rhs );
      return *this;
    }

    operator VkDescriptorSetVariableDescriptorCountLayoutSupport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetVariableDescriptorCountLayoutSupport *>( this );
    }

    operator VkDescriptorSetVariableDescriptorCountLayoutSupport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetVariableDescriptorCountLayoutSupport *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetVariableDescriptorCountLayoutSupport const & ) const = default;
#else
    bool operator==( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( maxVariableDescriptorCount == rhs.maxVariableDescriptorCount );
    }

    bool operator!=( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eDescriptorSetVariableDescriptorCountLayoutSupport;
    void *                              pNext = {};
    uint32_t                            maxVariableDescriptorCount = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport ) ==
                              sizeof( VkDescriptorSetVariableDescriptorCountLayoutSupport ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport>::value,
    "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport>::value,
    "DescriptorSetVariableDescriptorCountLayoutSupport is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetVariableDescriptorCountLayoutSupport>
  {
    using Type = DescriptorSetVariableDescriptorCountLayoutSupport;
  };
  using DescriptorSetVariableDescriptorCountLayoutSupportEXT = DescriptorSetVariableDescriptorCountLayoutSupport;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport const &
                            descriptorSetVariableDescriptorCountLayoutSupport ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::StructureType, seed, descriptorSetVariableDescriptorCountLayoutSupport.sType );
    VULKAN_HPP_HASH_COMBINE( void *, seed, descriptorSetVariableDescriptorCountLayoutSupport.pNext );
    VULKAN_HPP_HASH_COMBINE(
      uint32_t, seed, descriptorSetVariableDescriptorCountLayoutSupport.maxVariableDescriptorCount );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorUpdateTemplateEntry
  {
    using NativeType = VkDescriptorUpdateTemplateEntry;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorUpdateTemplateEntry(
      uint32_t                             dstBinding_      = {},
      uint32_t                             dstArrayElement_ = {},
      uint32_t                             descriptorCount_ = {},
      VULKAN_HPP_NAMESPACE::DescriptorType descriptorType_  = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler,
      size_t                               offset_          = {},
      size_t                               stride_          = {} ) VULKAN_HPP_NOEXCEPT
      : dstBinding( dstBinding_ )
      , dstArrayElement( dstArrayElement_ )
      , descriptorCount( descriptorCount_ )
      , descriptorType( descriptorType_ )
      , offset( offset_ )
      , stride( stride_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DescriptorUpdateTemplateEntry( DescriptorUpdateTemplateEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorUpdateTemplateEntry( VkDescriptorUpdateTemplateEntry const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorUpdateTemplateEntry( *reinterpret_cast<DescriptorUpdateTemplateEntry const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorUpdateTemplateEntry &
      operator=( DescriptorUpdateTemplateEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorUpdateTemplateEntry & operator=( VkDescriptorUpdateTemplateEntry const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry & setDstBinding( uint32_t dstBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBinding = dstBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry &
                            setDstArrayElement( uint32_t dstArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      dstArrayElement = dstArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry &
                            setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry &
      setDescriptorType( VULKAN_HPP_NAMESPACE::DescriptorType descriptorType_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorType = descriptorType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry & setOffset( size_t offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry & setStride( size_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorUpdateTemplateEntry const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorUpdateTemplateEntry *>( this );
    }

    operator VkDescriptorUpdateTemplateEntry &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorUpdateTemplateEntry *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorUpdateTemplateEntry const & ) const = default;
#else
    bool operator==( DescriptorUpdateTemplateEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( dstBinding == rhs.dstBinding ) && ( dstArrayElement == rhs.dstArrayElement ) &&
             ( descriptorCount == rhs.descriptorCount ) && ( descriptorType == rhs.descriptorType ) &&
             ( offset == rhs.offset ) && ( stride == rhs.stride );
    }

    bool operator!=( DescriptorUpdateTemplateEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                             dstBinding      = {};
    uint32_t                             dstArrayElement = {};
    uint32_t                             descriptorCount = {};
    VULKAN_HPP_NAMESPACE::DescriptorType descriptorType  = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler;
    size_t                               offset          = {};
    size_t                               stride          = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry ) ==
                              sizeof( VkDescriptorUpdateTemplateEntry ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry>::value,
    "DescriptorUpdateTemplateEntry is not nothrow_move_constructible!" );
  using DescriptorUpdateTemplateEntryKHR = DescriptorUpdateTemplateEntry;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry const & descriptorUpdateTemplateEntry )
    const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorUpdateTemplateEntry.dstBinding );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorUpdateTemplateEntry.dstArrayElement );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorUpdateTemplateEntry.descriptorCount );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DescriptorType, seed, descriptorUpdateTemplateEntry.descriptorType );
    VULKAN_HPP_HASH_COMBINE( size_t, seed, descriptorUpdateTemplateEntry.offset );
    VULKAN_HPP_HASH_COMBINE( size_t, seed, descriptorUpdateTemplateEntry.stride );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DescriptorUpdateTemplateCreateInfo
  {
    using NativeType = VkDescriptorUpdateTemplateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDescriptorUpdateTemplateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorUpdateTemplateCreateInfo(
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateFlags   flags_                      = {},
      uint32_t                                                    descriptorUpdateEntryCount_ = {},
      const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry * pDescriptorUpdateEntries_   = {},
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType          templateType_ =
        VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType::eDescriptorSet,
      VULKAN_HPP_NAMESPACE::DescriptorSetLayout descriptorSetLayout_ = {},
      VULKAN_HPP_NAMESPACE::PipelineBindPoint   pipelineBindPoint_ = VULKAN_HPP_NAMESPACE::PipelineBindPoint::eGraphics,
      VULKAN_HPP_NAMESPACE::PipelineLayout      pipelineLayout_    = {},
      uint32_t                                  set_               = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , descriptorUpdateEntryCount( descriptorUpdateEntryCount_ )
      , pDescriptorUpdateEntries( pDescriptorUpdateEntries_ )
      , templateType( templateType_ )
      , descriptorSetLayout( descriptorSetLayout_ )
      , pipelineBindPoint( pipelineBindPoint_ )
      , pipelineLayout( pipelineLayout_ )
      , set( set_ )
    {}

    VULKAN_HPP_CONSTEXPR DescriptorUpdateTemplateCreateInfo( DescriptorUpdateTemplateCreateInfo const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    DescriptorUpdateTemplateCreateInfo( VkDescriptorUpdateTemplateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorUpdateTemplateCreateInfo( *reinterpret_cast<DescriptorUpdateTemplateCreateInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorUpdateTemplateCreateInfo(
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateFlags flags_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry> const &
                                                         descriptorUpdateEntries_,
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType templateType_ =
        VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType::eDescriptorSet,
      VULKAN_HPP_NAMESPACE::DescriptorSetLayout descriptorSetLayout_ = {},
      VULKAN_HPP_NAMESPACE::PipelineBindPoint   pipelineBindPoint_ = VULKAN_HPP_NAMESPACE::PipelineBindPoint::eGraphics,
      VULKAN_HPP_NAMESPACE::PipelineLayout      pipelineLayout_    = {},
      uint32_t                                  set_               = {} )
      : flags( flags_ )
      , descriptorUpdateEntryCount( static_cast<uint32_t>( descriptorUpdateEntries_.size() ) )
      , pDescriptorUpdateEntries( descriptorUpdateEntries_.data() )
      , templateType( templateType_ )
      , descriptorSetLayout( descriptorSetLayout_ )
      , pipelineBindPoint( pipelineBindPoint_ )
      , pipelineLayout( pipelineLayout_ )
      , set( set_ )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorUpdateTemplateCreateInfo &
      operator=( DescriptorUpdateTemplateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorUpdateTemplateCreateInfo &
      operator=( VkDescriptorUpdateTemplateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
      setFlags( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
                            setDescriptorUpdateEntryCount( uint32_t descriptorUpdateEntryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorUpdateEntryCount = descriptorUpdateEntryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo & setPDescriptorUpdateEntries(
      const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry * pDescriptorUpdateEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      pDescriptorUpdateEntries = pDescriptorUpdateEntries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorUpdateTemplateCreateInfo & setDescriptorUpdateEntries(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry> const &
        descriptorUpdateEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorUpdateEntryCount = static_cast<uint32_t>( descriptorUpdateEntries_.size() );
      pDescriptorUpdateEntries   = descriptorUpdateEntries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
      setTemplateType( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType templateType_ ) VULKAN_HPP_NOEXCEPT
    {
      templateType = templateType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
      setDescriptorSetLayout( VULKAN_HPP_NAMESPACE::DescriptorSetLayout descriptorSetLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetLayout = descriptorSetLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
      setPipelineBindPoint( VULKAN_HPP_NAMESPACE::PipelineBindPoint pipelineBindPoint_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineBindPoint = pipelineBindPoint_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
      setPipelineLayout( VULKAN_HPP_NAMESPACE::PipelineLayout pipelineLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineLayout = pipelineLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo & setSet( uint32_t set_ ) VULKAN_HPP_NOEXCEPT
    {
      set = set_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDescriptorUpdateTemplateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorUpdateTemplateCreateInfo *>( this );
    }

    operator VkDescriptorUpdateTemplateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorUpdateTemplateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorUpdateTemplateCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorUpdateTemplateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( descriptorUpdateEntryCount == rhs.descriptorUpdateEntryCount ) &&
             ( pDescriptorUpdateEntries == rhs.pDescriptorUpdateEntries ) && ( templateType == rhs.templateType ) &&
             ( descriptorSetLayout == rhs.descriptorSetLayout ) && ( pipelineBindPoint == rhs.pipelineBindPoint ) &&
             ( pipelineLayout == rhs.pipelineLayout ) && ( set == rhs.set );
    }

    bool operator!=( DescriptorUpdateTemplateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType = StructureType::eDescriptorUpdateTemplateCreateInfo;
    const void *                        pNext = {};
    VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateFlags   flags                      = {};
    uint32_t                                                    descriptorUpdateEntryCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry * pDescriptorUpdateEntries   = {};
    VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType          templateType =
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType::eDescriptorSet;
    VULKAN_HPP_NAMESPACE::DescriptorSetLayout descriptorSetLayout = {};
    VULKAN_HPP_NAMESPACE::PipelineBindPoint   pipelineBindPoint   = VULKAN_HPP_NAMESPACE::PipelineBindPoint::eGraphics;
    VULKAN_HPP_NAMESPACE::PipelineLayout      pipelineLayout      = {};
    uint32_t                                  set                 = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateInfo ) ==
                              sizeof( VkDescriptorUpdateTemplateCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateInfo>::value,
    "DescriptorUpdateTemplateCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorUpdateTemplateCreateInfo>
  {
    using Type = DescriptorUpdateTemplateCreateInfo;
  };
  using DescriptorUpdateTemplateCreateInfoKHR = DescriptorUpdateTemplateCreateInfo;

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateInfo const &
                            descriptorUpdateTemplateCreateInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, descriptorUpdateTemplateCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, descriptorUpdateTemplateCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateFlags, seed, descriptorUpdateTemplateCreateInfo.flags );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorUpdateTemplateCreateInfo.descriptorUpdateEntryCount );
    VULKAN_HPP_HASH_COMBINE( const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry *,
                             seed,
                             descriptorUpdateTemplateCreateInfo.pDescriptorUpdateEntries );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType, seed, descriptorUpdateTemplateCreateInfo.templateType );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::DescriptorSetLayout, seed, descriptorUpdateTemplateCreateInfo.descriptorSetLayout );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::PipelineBindPoint, seed, descriptorUpdateTemplateCreateInfo.pipelineBindPoint );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::PipelineLayout, seed, descriptorUpdateTemplateCreateInfo.pipelineLayout );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, descriptorUpdateTemplateCreateInfo.set );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DeviceBufferMemoryRequirementsKHR
  {
    using NativeType = VkDeviceBufferMemoryRequirementsKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDeviceBufferMemoryRequirementsKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceBufferMemoryRequirementsKHR(
      const VULKAN_HPP_NAMESPACE::BufferCreateInfo * pCreateInfo_ = {} ) VULKAN_HPP_NOEXCEPT
      : pCreateInfo( pCreateInfo_ )
    {}

    VULKAN_HPP_CONSTEXPR
      DeviceBufferMemoryRequirementsKHR( DeviceBufferMemoryRequirementsKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceBufferMemoryRequirementsKHR( VkDeviceBufferMemoryRequirementsKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceBufferMemoryRequirementsKHR( *reinterpret_cast<DeviceBufferMemoryRequirementsKHR const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceBufferMemoryRequirementsKHR &
      operator=( DeviceBufferMemoryRequirementsKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceBufferMemoryRequirementsKHR & operator=( VkDeviceBufferMemoryRequirementsKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirementsKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceBufferMemoryRequirementsKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceBufferMemoryRequirementsKHR &
      setPCreateInfo( const VULKAN_HPP_NAMESPACE::BufferCreateInfo * pCreateInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pCreateInfo = pCreateInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceBufferMemoryRequirementsKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceBufferMemoryRequirementsKHR *>( this );
    }

    operator VkDeviceBufferMemoryRequirementsKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceBufferMemoryRequirementsKHR *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceBufferMemoryRequirementsKHR const & ) const = default;
#else
    bool operator==( DeviceBufferMemoryRequirementsKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pCreateInfo == rhs.pCreateInfo );
    }

    bool operator!=( DeviceBufferMemoryRequirementsKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType       = StructureType::eDeviceBufferMemoryRequirementsKHR;
    const void *                                   pNext       = {};
    const VULKAN_HPP_NAMESPACE::BufferCreateInfo * pCreateInfo = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirementsKHR ) ==
                              sizeof( VkDeviceBufferMemoryRequirementsKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirementsKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT(
    std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirementsKHR>::value,
    "DeviceBufferMemoryRequirementsKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDeviceBufferMemoryRequirementsKHR>
  {
    using Type = DeviceBufferMemoryRequirementsKHR;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirementsKHR>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirementsKHR const &
                            deviceBufferMemoryRequirementsKHR ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, deviceBufferMemoryRequirementsKHR.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, deviceBufferMemoryRequirementsKHR.pNext );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::BufferCreateInfo *, seed, deviceBufferMemoryRequirementsKHR.pCreateInfo );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DeviceQueueCreateInfo
  {
    using NativeType = VkDeviceQueueCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceQueueCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceQueueCreateInfo( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags_            = {},
                                                uint32_t                                     queueFamilyIndex_ = {},
                                                uint32_t                                     queueCount_       = {},
                                                const float * pQueuePriorities_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , queueFamilyIndex( queueFamilyIndex_ )
      , queueCount( queueCount_ )
      , pQueuePriorities( pQueuePriorities_ )
    {}

    VULKAN_HPP_CONSTEXPR DeviceQueueCreateInfo( DeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceQueueCreateInfo( VkDeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceQueueCreateInfo( *reinterpret_cast<DeviceQueueCreateInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceQueueCreateInfo( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags                       flags_,
                           uint32_t                                                           queueFamilyIndex_,
                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const float> const & queuePriorities_ )
      : flags( flags_ )
      , queueFamilyIndex( queueFamilyIndex_ )
      , queueCount( static_cast<uint32_t>( queuePriorities_.size() ) )
      , pQueuePriorities( queuePriorities_.data() )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceQueueCreateInfo & operator=( DeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceQueueCreateInfo & operator=( VkDeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo &
                            setQueueFamilyIndex( uint32_t queueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndex = queueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setQueueCount( uint32_t queueCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCount = queueCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo &
                            setPQueuePriorities( const float * pQueuePriorities_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueuePriorities = pQueuePriorities_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceQueueCreateInfo & setQueuePriorities(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const float> const & queuePriorities_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCount       = static_cast<uint32_t>( queuePriorities_.size() );
      pQueuePriorities = queuePriorities_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceQueueCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceQueueCreateInfo *>( this );
    }

    operator VkDeviceQueueCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceQueueCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceQueueCreateInfo const & ) const = default;
#else
    bool operator==( DeviceQueueCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( queueFamilyIndex == rhs.queueFamilyIndex ) && ( queueCount == rhs.queueCount ) &&
             ( pQueuePriorities == rhs.pQueuePriorities );
    }

    bool operator!=( DeviceQueueCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType            = StructureType::eDeviceQueueCreateInfo;
    const void *                                 pNext            = {};
    VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags            = {};
    uint32_t                                     queueFamilyIndex = {};
    uint32_t                                     queueCount       = {};
    const float *                                pQueuePriorities = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo ) == sizeof( VkDeviceQueueCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo>::value,
                            "DeviceQueueCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDeviceQueueCreateInfo>
  {
    using Type = DeviceQueueCreateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo const & deviceQueueCreateInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, deviceQueueCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, deviceQueueCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags, seed, deviceQueueCreateInfo.flags );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, deviceQueueCreateInfo.queueFamilyIndex );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, deviceQueueCreateInfo.queueCount );
    VULKAN_HPP_HASH_COMBINE( const float *, seed, deviceQueueCreateInfo.pQueuePriorities );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct PhysicalDeviceFeatures
  {
    using NativeType = VkPhysicalDeviceFeatures;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      PhysicalDeviceFeatures( VULKAN_HPP_NAMESPACE::Bool32 robustBufferAccess_                      = {},
                              VULKAN_HPP_NAMESPACE::Bool32 fullDrawIndexUint32_                     = {},
                              VULKAN_HPP_NAMESPACE::Bool32 imageCubeArray_                          = {},
                              VULKAN_HPP_NAMESPACE::Bool32 independentBlend_                        = {},
                              VULKAN_HPP_NAMESPACE::Bool32 geometryShader_                          = {},
                              VULKAN_HPP_NAMESPACE::Bool32 tessellationShader_                      = {},
                              VULKAN_HPP_NAMESPACE::Bool32 sampleRateShading_                       = {},
                              VULKAN_HPP_NAMESPACE::Bool32 dualSrcBlend_                            = {},
                              VULKAN_HPP_NAMESPACE::Bool32 logicOp_                                 = {},
                              VULKAN_HPP_NAMESPACE::Bool32 multiDrawIndirect_                       = {},
                              VULKAN_HPP_NAMESPACE::Bool32 drawIndirectFirstInstance_               = {},
                              VULKAN_HPP_NAMESPACE::Bool32 depthClamp_                              = {},
                              VULKAN_HPP_NAMESPACE::Bool32 depthBiasClamp_                          = {},
                              VULKAN_HPP_NAMESPACE::Bool32 fillModeNonSolid_                        = {},
                              VULKAN_HPP_NAMESPACE::Bool32 depthBounds_                             = {},
                              VULKAN_HPP_NAMESPACE::Bool32 wideLines_                               = {},
                              VULKAN_HPP_NAMESPACE::Bool32 largePoints_                             = {},
                              VULKAN_HPP_NAMESPACE::Bool32 alphaToOne_                              = {},
                              VULKAN_HPP_NAMESPACE::Bool32 multiViewport_                           = {},
                              VULKAN_HPP_NAMESPACE::Bool32 samplerAnisotropy_                       = {},
                              VULKAN_HPP_NAMESPACE::Bool32 textureCompressionETC2_                  = {},
                              VULKAN_HPP_NAMESPACE::Bool32 textureCompressionASTC_LDR_              = {},
                              VULKAN_HPP_NAMESPACE::Bool32 textureCompressionBC_                    = {},
                              VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryPrecise_                   = {},
                              VULKAN_HPP_NAMESPACE::Bool32 pipelineStatisticsQuery_                 = {},
                              VULKAN_HPP_NAMESPACE::Bool32 vertexPipelineStoresAndAtomics_          = {},
                              VULKAN_HPP_NAMESPACE::Bool32 fragmentStoresAndAtomics_                = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderTessellationAndGeometryPointSize_  = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderImageGatherExtended_               = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageExtendedFormats_       = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageMultisample_           = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageReadWithoutFormat_     = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageWriteWithoutFormat_    = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderUniformBufferArrayDynamicIndexing_ = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderSampledImageArrayDynamicIndexing_  = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderStorageBufferArrayDynamicIndexing_ = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageArrayDynamicIndexing_  = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderClipDistance_                      = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderCullDistance_                      = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderFloat64_                           = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderInt64_                             = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderInt16_                             = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderResourceResidency_                 = {},
                              VULKAN_HPP_NAMESPACE::Bool32 shaderResourceMinLod_                    = {},
                              VULKAN_HPP_NAMESPACE::Bool32 sparseBinding_                           = {},
                              VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyBuffer_                   = {},
                              VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage2D_                  = {},
                              VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage3D_                  = {},
                              VULKAN_HPP_NAMESPACE::Bool32 sparseResidency2Samples_                 = {},
                              VULKAN_HPP_NAMESPACE::Bool32 sparseResidency4Samples_                 = {},
                              VULKAN_HPP_NAMESPACE::Bool32 sparseResidency8Samples_                 = {},
                              VULKAN_HPP_NAMESPACE::Bool32 sparseResidency16Samples_                = {},
                              VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyAliased_                  = {},
                              VULKAN_HPP_NAMESPACE::Bool32 variableMultisampleRate_                 = {},
                              VULKAN_HPP_NAMESPACE::Bool32 inheritedQueries_ = {} ) VULKAN_HPP_NOEXCEPT
      : robustBufferAccess( robustBufferAccess_ )
      , fullDrawIndexUint32( fullDrawIndexUint32_ )
      , imageCubeArray( imageCubeArray_ )
      , independentBlend( independentBlend_ )
      , geometryShader( geometryShader_ )
      , tessellationShader( tessellationShader_ )
      , sampleRateShading( sampleRateShading_ )
      , dualSrcBlend( dualSrcBlend_ )
      , logicOp( logicOp_ )
      , multiDrawIndirect( multiDrawIndirect_ )
      , drawIndirectFirstInstance( drawIndirectFirstInstance_ )
      , depthClamp( depthClamp_ )
      , depthBiasClamp( depthBiasClamp_ )
      , fillModeNonSolid( fillModeNonSolid_ )
      , depthBounds( depthBounds_ )
      , wideLines( wideLines_ )
      , largePoints( largePoints_ )
      , alphaToOne( alphaToOne_ )
      , multiViewport( multiViewport_ )
      , samplerAnisotropy( samplerAnisotropy_ )
      , textureCompressionETC2( textureCompressionETC2_ )
      , textureCompressionASTC_LDR( textureCompressionASTC_LDR_ )
      , textureCompressionBC( textureCompressionBC_ )
      , occlusionQueryPrecise( occlusionQueryPrecise_ )
      , pipelineStatisticsQuery( pipelineStatisticsQuery_ )
      , vertexPipelineStoresAndAtomics( vertexPipelineStoresAndAtomics_ )
      , fragmentStoresAndAtomics( fragmentStoresAndAtomics_ )
      , shaderTessellationAndGeometryPointSize( shaderTessellationAndGeometryPointSize_ )
      , shaderImageGatherExtended( shaderImageGatherExtended_ )
      , shaderStorageImageExtendedFormats( shaderStorageImageExtendedFormats_ )
      , shaderStorageImageMultisample( shaderStorageImageMultisample_ )
      , shaderStorageImageReadWithoutFormat( shaderStorageImageReadWithoutFormat_ )
      , shaderStorageImageWriteWithoutFormat( shaderStorageImageWriteWithoutFormat_ )
      , shaderUniformBufferArrayDynamicIndexing( shaderUniformBufferArrayDynamicIndexing_ )
      , shaderSampledImageArrayDynamicIndexing( shaderSampledImageArrayDynamicIndexing_ )
      , shaderStorageBufferArrayDynamicIndexing( shaderStorageBufferArrayDynamicIndexing_ )
      , shaderStorageImageArrayDynamicIndexing( shaderStorageImageArrayDynamicIndexing_ )
      , shaderClipDistance( shaderClipDistance_ )
      , shaderCullDistance( shaderCullDistance_ )
      , shaderFloat64( shaderFloat64_ )
      , shaderInt64( shaderInt64_ )
      , shaderInt16( shaderInt16_ )
      , shaderResourceResidency( shaderResourceResidency_ )
      , shaderResourceMinLod( shaderResourceMinLod_ )
      , sparseBinding( sparseBinding_ )
      , sparseResidencyBuffer( sparseResidencyBuffer_ )
      , sparseResidencyImage2D( sparseResidencyImage2D_ )
      , sparseResidencyImage3D( sparseResidencyImage3D_ )
      , sparseResidency2Samples( sparseResidency2Samples_ )
      , sparseResidency4Samples( sparseResidency4Samples_ )
      , sparseResidency8Samples( sparseResidency8Samples_ )
      , sparseResidency16Samples( sparseResidency16Samples_ )
      , sparseResidencyAliased( sparseResidencyAliased_ )
      , variableMultisampleRate( variableMultisampleRate_ )
      , inheritedQueries( inheritedQueries_ )
    {}

    VULKAN_HPP_CONSTEXPR PhysicalDeviceFeatures( PhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PhysicalDeviceFeatures( VkPhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT
      : PhysicalDeviceFeatures( *reinterpret_cast<PhysicalDeviceFeatures const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PhysicalDeviceFeatures & operator=( PhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PhysicalDeviceFeatures & operator=( VkPhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setRobustBufferAccess( VULKAN_HPP_NAMESPACE::Bool32 robustBufferAccess_ ) VULKAN_HPP_NOEXCEPT
    {
      robustBufferAccess = robustBufferAccess_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setFullDrawIndexUint32( VULKAN_HPP_NAMESPACE::Bool32 fullDrawIndexUint32_ ) VULKAN_HPP_NOEXCEPT
    {
      fullDrawIndexUint32 = fullDrawIndexUint32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setImageCubeArray( VULKAN_HPP_NAMESPACE::Bool32 imageCubeArray_ ) VULKAN_HPP_NOEXCEPT
    {
      imageCubeArray = imageCubeArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setIndependentBlend( VULKAN_HPP_NAMESPACE::Bool32 independentBlend_ ) VULKAN_HPP_NOEXCEPT
    {
      independentBlend = independentBlend_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setGeometryShader( VULKAN_HPP_NAMESPACE::Bool32 geometryShader_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryShader = geometryShader_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setTessellationShader( VULKAN_HPP_NAMESPACE::Bool32 tessellationShader_ ) VULKAN_HPP_NOEXCEPT
    {
      tessellationShader = tessellationShader_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setSampleRateShading( VULKAN_HPP_NAMESPACE::Bool32 sampleRateShading_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleRateShading = sampleRateShading_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setDualSrcBlend( VULKAN_HPP_NAMESPACE::Bool32 dualSrcBlend_ ) VULKAN_HPP_NOEXCEPT
    {
      dualSrcBlend = dualSrcBlend_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setLogicOp( VULKAN_HPP_NAMESPACE::Bool32 logicOp_ ) VULKAN_HPP_NOEXCEPT
    {
      logicOp = logicOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setMultiDrawIndirect( VULKAN_HPP_NAMESPACE::Bool32 multiDrawIndirect_ ) VULKAN_HPP_NOEXCEPT
    {
      multiDrawIndirect = multiDrawIndirect_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setDrawIndirectFirstInstance( VULKAN_HPP_NAMESPACE::Bool32 drawIndirectFirstInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      drawIndirectFirstInstance = drawIndirectFirstInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setDepthClamp( VULKAN_HPP_NAMESPACE::Bool32 depthClamp_ ) VULKAN_HPP_NOEXCEPT
    {
      depthClamp = depthClamp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setDepthBiasClamp( VULKAN_HPP_NAMESPACE::Bool32 depthBiasClamp_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBiasClamp = depthBiasClamp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setFillModeNonSolid( VULKAN_HPP_NAMESPACE::Bool32 fillModeNonSolid_ ) VULKAN_HPP_NOEXCEPT
    {
      fillModeNonSolid = fillModeNonSolid_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setDepthBounds( VULKAN_HPP_NAMESPACE::Bool32 depthBounds_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBounds = depthBounds_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setWideLines( VULKAN_HPP_NAMESPACE::Bool32 wideLines_ ) VULKAN_HPP_NOEXCEPT
    {
      wideLines = wideLines_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setLargePoints( VULKAN_HPP_NAMESPACE::Bool32 largePoints_ ) VULKAN_HPP_NOEXCEPT
    {
      largePoints = largePoints_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setAlphaToOne( VULKAN_HPP_NAMESPACE::Bool32 alphaToOne_ ) VULKAN_HPP_NOEXCEPT
    {
      alphaToOne = alphaToOne_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setMultiViewport( VULKAN_HPP_NAMESPACE::Bool32 multiViewport_ ) VULKAN_HPP_NOEXCEPT
    {
      multiViewport = multiViewport_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setSamplerAnisotropy( VULKAN_HPP_NAMESPACE::Bool32 samplerAnisotropy_ ) VULKAN_HPP_NOEXCEPT
    {
      samplerAnisotropy = samplerAnisotropy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setTextureCompressionETC2( VULKAN_HPP_NAMESPACE::Bool32 textureCompressionETC2_ ) VULKAN_HPP_NOEXCEPT
    {
      textureCompressionETC2 = textureCompressionETC2_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setTextureCompressionASTC_LDR( VULKAN_HPP_NAMESPACE::Bool32 textureCompressionASTC_LDR_ ) VULKAN_HPP_NOEXCEPT
    {
      textureCompressionASTC_LDR = textureCompressionASTC_LDR_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setTextureCompressionBC( VULKAN_HPP_NAMESPACE::Bool32 textureCompressionBC_ ) VULKAN_HPP_NOEXCEPT
    {
      textureCompressionBC = textureCompressionBC_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setOcclusionQueryPrecise( VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryPrecise_ ) VULKAN_HPP_NOEXCEPT
    {
      occlusionQueryPrecise = occlusionQueryPrecise_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setPipelineStatisticsQuery( VULKAN_HPP_NAMESPACE::Bool32 pipelineStatisticsQuery_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineStatisticsQuery = pipelineStatisticsQuery_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setVertexPipelineStoresAndAtomics(
      VULKAN_HPP_NAMESPACE::Bool32 vertexPipelineStoresAndAtomics_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexPipelineStoresAndAtomics = vertexPipelineStoresAndAtomics_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setFragmentStoresAndAtomics( VULKAN_HPP_NAMESPACE::Bool32 fragmentStoresAndAtomics_ ) VULKAN_HPP_NOEXCEPT
    {
      fragmentStoresAndAtomics = fragmentStoresAndAtomics_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderTessellationAndGeometryPointSize(
      VULKAN_HPP_NAMESPACE::Bool32 shaderTessellationAndGeometryPointSize_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderTessellationAndGeometryPointSize = shaderTessellationAndGeometryPointSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderImageGatherExtended( VULKAN_HPP_NAMESPACE::Bool32 shaderImageGatherExtended_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderImageGatherExtended = shaderImageGatherExtended_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderStorageImageExtendedFormats(
      VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageExtendedFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageExtendedFormats = shaderStorageImageExtendedFormats_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderStorageImageMultisample(
      VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageMultisample_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageMultisample = shaderStorageImageMultisample_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderStorageImageReadWithoutFormat(
      VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageReadWithoutFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageReadWithoutFormat = shaderStorageImageReadWithoutFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderStorageImageWriteWithoutFormat(
      VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageWriteWithoutFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageWriteWithoutFormat = shaderStorageImageWriteWithoutFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderUniformBufferArrayDynamicIndexing(
      VULKAN_HPP_NAMESPACE::Bool32 shaderUniformBufferArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderUniformBufferArrayDynamicIndexing = shaderUniformBufferArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderSampledImageArrayDynamicIndexing(
      VULKAN_HPP_NAMESPACE::Bool32 shaderSampledImageArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderSampledImageArrayDynamicIndexing = shaderSampledImageArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderStorageBufferArrayDynamicIndexing(
      VULKAN_HPP_NAMESPACE::Bool32 shaderStorageBufferArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageBufferArrayDynamicIndexing = shaderStorageBufferArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderStorageImageArrayDynamicIndexing(
      VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageArrayDynamicIndexing = shaderStorageImageArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderClipDistance( VULKAN_HPP_NAMESPACE::Bool32 shaderClipDistance_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderClipDistance = shaderClipDistance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderCullDistance( VULKAN_HPP_NAMESPACE::Bool32 shaderCullDistance_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderCullDistance = shaderCullDistance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setShaderFloat64( VULKAN_HPP_NAMESPACE::Bool32 shaderFloat64_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderFloat64 = shaderFloat64_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setShaderInt64( VULKAN_HPP_NAMESPACE::Bool32 shaderInt64_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderInt64 = shaderInt64_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setShaderInt16( VULKAN_HPP_NAMESPACE::Bool32 shaderInt16_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderInt16 = shaderInt16_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderResourceResidency( VULKAN_HPP_NAMESPACE::Bool32 shaderResourceResidency_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderResourceResidency = shaderResourceResidency_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderResourceMinLod( VULKAN_HPP_NAMESPACE::Bool32 shaderResourceMinLod_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderResourceMinLod = shaderResourceMinLod_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setSparseBinding( VULKAN_HPP_NAMESPACE::Bool32 sparseBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseBinding = sparseBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setSparseResidencyBuffer( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyBuffer = sparseResidencyBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setSparseResidencyImage2D( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage2D_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyImage2D = sparseResidencyImage2D_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setSparseResidencyImage3D( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage3D_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyImage3D = sparseResidencyImage3D_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setSparseResidency2Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency2Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency2Samples = sparseResidency2Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setSparseResidency4Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency4Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency4Samples = sparseResidency4Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setSparseResidency8Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency8Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency8Samples = sparseResidency8Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setSparseResidency16Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency16Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency16Samples = sparseResidency16Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setSparseResidencyAliased( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyAliased_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyAliased = sparseResidencyAliased_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setVariableMultisampleRate( VULKAN_HPP_NAMESPACE::Bool32 variableMultisampleRate_ ) VULKAN_HPP_NOEXCEPT
    {
      variableMultisampleRate = variableMultisampleRate_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setInheritedQueries( VULKAN_HPP_NAMESPACE::Bool32 inheritedQueries_ ) VULKAN_HPP_NOEXCEPT
    {
      inheritedQueries = inheritedQueries_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkPhysicalDeviceFeatures const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPhysicalDeviceFeatures *>( this );
    }

    operator VkPhysicalDeviceFeatures &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPhysicalDeviceFeatures *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PhysicalDeviceFeatures const & ) const = default;
#else
    bool operator==( PhysicalDeviceFeatures const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( robustBufferAccess == rhs.robustBufferAccess ) && ( fullDrawIndexUint32 == rhs.fullDrawIndexUint32 ) &&
             ( imageCubeArray == rhs.imageCubeArray ) && ( independentBlend == rhs.independentBlend ) &&
             ( geometryShader == rhs.geometryShader ) && ( tessellationShader == rhs.tessellationShader ) &&
             ( sampleRateShading == rhs.sampleRateShading ) && ( dualSrcBlend == rhs.dualSrcBlend ) &&
             ( logicOp == rhs.logicOp ) && ( multiDrawIndirect == rhs.multiDrawIndirect ) &&
             ( drawIndirectFirstInstance == rhs.drawIndirectFirstInstance ) && ( depthClamp == rhs.depthClamp ) &&
             ( depthBiasClamp == rhs.depthBiasClamp ) && ( fillModeNonSolid == rhs.fillModeNonSolid ) &&
             ( depthBounds == rhs.depthBounds ) && ( wideLines == rhs.wideLines ) &&
             ( largePoints == rhs.largePoints ) && ( alphaToOne == rhs.alphaToOne ) &&
             ( multiViewport == rhs.multiViewport ) && ( samplerAnisotropy == rhs.samplerAnisotropy ) &&
             ( textureCompressionETC2 == rhs.textureCompressionETC2 ) &&
             ( textureCompressionASTC_LDR == rhs.textureCompressionASTC_LDR ) &&
             ( textureCompressionBC == rhs.textureCompressionBC ) &&
             ( occlusionQueryPrecise == rhs.occlusionQueryPrecise ) &&
             ( pipelineStatisticsQuery == rhs.pipelineStatisticsQuery ) &&
             ( vertexPipelineStoresAndAtomics == rhs.vertexPipelineStoresAndAtomics ) &&
             ( fragmentStoresAndAtomics == rhs.fragmentStoresAndAtomics ) &&
             ( shaderTessellationAndGeometryPointSize == rhs.shaderTessellationAndGeometryPointSize ) &&
             ( shaderImageGatherExtended == rhs.shaderImageGatherExtended ) &&
             ( shaderStorageImageExtendedFormats == rhs.shaderStorageImageExtendedFormats ) &&
             ( shaderStorageImageMultisample == rhs.shaderStorageImageMultisample ) &&
             ( shaderStorageImageReadWithoutFormat == rhs.shaderStorageImageReadWithoutFormat ) &&
             ( shaderStorageImageWriteWithoutFormat == rhs.shaderStorageImageWriteWithoutFormat ) &&
             ( shaderUniformBufferArrayDynamicIndexing == rhs.shaderUniformBufferArrayDynamicIndexing ) &&
             ( shaderSampledImageArrayDynamicIndexing == rhs.shaderSampledImageArrayDynamicIndexing ) &&
             ( shaderStorageBufferArrayDynamicIndexing == rhs.shaderStorageBufferArrayDynamicIndexing ) &&
             ( shaderStorageImageArrayDynamicIndexing == rhs.shaderStorageImageArrayDynamicIndexing ) &&
             ( shaderClipDistance == rhs.shaderClipDistance ) && ( shaderCullDistance == rhs.shaderCullDistance ) &&
             ( shaderFloat64 == rhs.shaderFloat64 ) && ( shaderInt64 == rhs.shaderInt64 ) &&
             ( shaderInt16 == rhs.shaderInt16 ) && ( shaderResourceResidency == rhs.shaderResourceResidency ) &&
             ( shaderResourceMinLod == rhs.shaderResourceMinLod ) && ( sparseBinding == rhs.sparseBinding ) &&
             ( sparseResidencyBuffer == rhs.sparseResidencyBuffer ) &&
             ( sparseResidencyImage2D == rhs.sparseResidencyImage2D ) &&
             ( sparseResidencyImage3D == rhs.sparseResidencyImage3D ) &&
             ( sparseResidency2Samples == rhs.sparseResidency2Samples ) &&
             ( sparseResidency4Samples == rhs.sparseResidency4Samples ) &&
             ( sparseResidency8Samples == rhs.sparseResidency8Samples ) &&
             ( sparseResidency16Samples == rhs.sparseResidency16Samples ) &&
             ( sparseResidencyAliased == rhs.sparseResidencyAliased ) &&
             ( variableMultisampleRate == rhs.variableMultisampleRate ) && ( inheritedQueries == rhs.inheritedQueries );
    }

    bool operator!=( PhysicalDeviceFeatures const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Bool32 robustBufferAccess                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 fullDrawIndexUint32                     = {};
    VULKAN_HPP_NAMESPACE::Bool32 imageCubeArray                          = {};
    VULKAN_HPP_NAMESPACE::Bool32 independentBlend                        = {};
    VULKAN_HPP_NAMESPACE::Bool32 geometryShader                          = {};
    VULKAN_HPP_NAMESPACE::Bool32 tessellationShader                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 sampleRateShading                       = {};
    VULKAN_HPP_NAMESPACE::Bool32 dualSrcBlend                            = {};
    VULKAN_HPP_NAMESPACE::Bool32 logicOp                                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 multiDrawIndirect                       = {};
    VULKAN_HPP_NAMESPACE::Bool32 drawIndirectFirstInstance               = {};
    VULKAN_HPP_NAMESPACE::Bool32 depthClamp                              = {};
    VULKAN_HPP_NAMESPACE::Bool32 depthBiasClamp                          = {};
    VULKAN_HPP_NAMESPACE::Bool32 fillModeNonSolid                        = {};
    VULKAN_HPP_NAMESPACE::Bool32 depthBounds                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 wideLines                               = {};
    VULKAN_HPP_NAMESPACE::Bool32 largePoints                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 alphaToOne                              = {};
    VULKAN_HPP_NAMESPACE::Bool32 multiViewport                           = {};
    VULKAN_HPP_NAMESPACE::Bool32 samplerAnisotropy                       = {};
    VULKAN_HPP_NAMESPACE::Bool32 textureCompressionETC2                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 textureCompressionASTC_LDR              = {};
    VULKAN_HPP_NAMESPACE::Bool32 textureCompressionBC                    = {};
    VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryPrecise                   = {};
    VULKAN_HPP_NAMESPACE::Bool32 pipelineStatisticsQuery                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 vertexPipelineStoresAndAtomics          = {};
    VULKAN_HPP_NAMESPACE::Bool32 fragmentStoresAndAtomics                = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderTessellationAndGeometryPointSize  = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderImageGatherExtended               = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageExtendedFormats       = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageMultisample           = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageReadWithoutFormat     = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageWriteWithoutFormat    = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderUniformBufferArrayDynamicIndexing = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderSampledImageArrayDynamicIndexing  = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageBufferArrayDynamicIndexing = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageArrayDynamicIndexing  = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderClipDistance                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderCullDistance                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderFloat64                           = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderInt64                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderInt16                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderResourceResidency                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderResourceMinLod                    = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseBinding                           = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyBuffer                   = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage2D                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage3D                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency2Samples                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency4Samples                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency8Samples                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency16Samples                = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyAliased                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 variableMultisampleRate                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 inheritedQueries                        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures ) ==
                              sizeof( VkPhysicalDeviceFeatures ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures>::value,
                            "PhysicalDeviceFeatures is not nothrow_move_constructible!" );

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures>
{
  std::size_t
    operator()( VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures const & physicalDeviceFeatures ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.robustBufferAccess );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.fullDrawIndexUint32 );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.imageCubeArray );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.independentBlend );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.geometryShader );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.tessellationShader );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.sampleRateShading );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.dualSrcBlend );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.logicOp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.multiDrawIndirect );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.drawIndirectFirstInstance );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.depthClamp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.depthBiasClamp );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.fillModeNonSolid );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.depthBounds );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.wideLines );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.largePoints );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.alphaToOne );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.multiViewport );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.samplerAnisotropy );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.textureCompressionETC2 );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.textureCompressionASTC_LDR );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.textureCompressionBC );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.occlusionQueryPrecise );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.pipelineStatisticsQuery );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.vertexPipelineStoresAndAtomics );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.fragmentStoresAndAtomics );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderTessellationAndGeometryPointSize );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderImageGatherExtended );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderStorageImageExtendedFormats );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderStorageImageMultisample );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderStorageImageReadWithoutFormat );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderStorageImageWriteWithoutFormat );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderUniformBufferArrayDynamicIndexing );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderSampledImageArrayDynamicIndexing );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderStorageBufferArrayDynamicIndexing );
    VULKAN_HPP_HASH_COMBINE(
      VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderStorageImageArrayDynamicIndexing );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderClipDistance );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderCullDistance );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderFloat64 );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderInt64 );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderInt16 );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderResourceResidency );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.shaderResourceMinLod );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.sparseBinding );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.sparseResidencyBuffer );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.sparseResidencyImage2D );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.sparseResidencyImage3D );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.sparseResidency2Samples );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.sparseResidency4Samples );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.sparseResidency8Samples );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.sparseResidency16Samples );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.sparseResidencyAliased );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.variableMultisampleRate );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::Bool32, seed, physicalDeviceFeatures.inheritedQueries );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DeviceCreateInfo
  {
    using NativeType = VkDeviceCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceCreateInfo( VULKAN_HPP_NAMESPACE::DeviceCreateFlags flags_                         = {},
                                           uint32_t                                queueCreateInfoCount_          = {},
                                           const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo * pQueueCreateInfos_ = {},
                                           uint32_t                                            enabledLayerCount_ = {},
                                           const char * const * ppEnabledLayerNames_                              = {},
                                           uint32_t             enabledExtensionCount_                            = {},
                                           const char * const * ppEnabledExtensionNames_                          = {},
                                           const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * pEnabledFeatures_ = {} )
      VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , queueCreateInfoCount( queueCreateInfoCount_ )
      , pQueueCreateInfos( pQueueCreateInfos_ )
      , enabledLayerCount( enabledLayerCount_ )
      , ppEnabledLayerNames( ppEnabledLayerNames_ )
      , enabledExtensionCount( enabledExtensionCount_ )
      , ppEnabledExtensionNames( ppEnabledExtensionNames_ )
      , pEnabledFeatures( pEnabledFeatures_ )
    {}

    VULKAN_HPP_CONSTEXPR DeviceCreateInfo( DeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceCreateInfo( VkDeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceCreateInfo( *reinterpret_cast<DeviceCreateInfo const *>( &rhs ) )
    {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo(
      VULKAN_HPP_NAMESPACE::DeviceCreateFlags flags_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo> const &
                                                                                queueCreateInfos_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const & pEnabledLayerNames_     = {},
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const & pEnabledExtensionNames_ = {},
      const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures *                      pEnabledFeatures_       = {} )
      : flags( flags_ )
      , queueCreateInfoCount( static_cast<uint32_t>( queueCreateInfos_.size() ) )
      , pQueueCreateInfos( queueCreateInfos_.data() )
      , enabledLayerCount( static_cast<uint32_t>( pEnabledLayerNames_.size() ) )
      , ppEnabledLayerNames( pEnabledLayerNames_.data() )
      , enabledExtensionCount( static_cast<uint32_t>( pEnabledExtensionNames_.size() ) )
      , ppEnabledExtensionNames( pEnabledExtensionNames_.data() )
      , pEnabledFeatures( pEnabledFeatures_ )
    {}
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceCreateInfo & operator=( DeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceCreateInfo & operator=( VkDeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::DeviceCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo &
                            setQueueCreateInfoCount( uint32_t queueCreateInfoCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCreateInfoCount = queueCreateInfoCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo &
      setPQueueCreateInfos( const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo * pQueueCreateInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueCreateInfos = pQueueCreateInfos_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo & setQueueCreateInfos(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo> const &
        queueCreateInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCreateInfoCount = static_cast<uint32_t>( queueCreateInfos_.size() );
      pQueueCreateInfos    = queueCreateInfos_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setEnabledLayerCount( uint32_t enabledLayerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledLayerCount = enabledLayerCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo &
                            setPpEnabledLayerNames( const char * const * ppEnabledLayerNames_ ) VULKAN_HPP_NOEXCEPT
    {
      ppEnabledLayerNames = ppEnabledLayerNames_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo & setPEnabledLayerNames( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const &
                                                pEnabledLayerNames_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledLayerCount   = static_cast<uint32_t>( pEnabledLayerNames_.size() );
      ppEnabledLayerNames = pEnabledLayerNames_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo &
                            setEnabledExtensionCount( uint32_t enabledExtensionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledExtensionCount = enabledExtensionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo &
      setPpEnabledExtensionNames( const char * const * ppEnabledExtensionNames_ ) VULKAN_HPP_NOEXCEPT
    {
      ppEnabledExtensionNames = ppEnabledExtensionNames_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo & setPEnabledExtensionNames(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const & pEnabledExtensionNames_ )
      VULKAN_HPP_NOEXCEPT
    {
      enabledExtensionCount   = static_cast<uint32_t>( pEnabledExtensionNames_.size() );
      ppEnabledExtensionNames = pEnabledExtensionNames_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo &
      setPEnabledFeatures( const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * pEnabledFeatures_ ) VULKAN_HPP_NOEXCEPT
    {
      pEnabledFeatures = pEnabledFeatures_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceCreateInfo *>( this );
    }

    operator VkDeviceCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceCreateInfo const & ) const = default;
#else
    bool operator==( DeviceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( queueCreateInfoCount == rhs.queueCreateInfoCount ) && ( pQueueCreateInfos == rhs.pQueueCreateInfos ) &&
             ( enabledLayerCount == rhs.enabledLayerCount ) && ( ppEnabledLayerNames == rhs.ppEnabledLayerNames ) &&
             ( enabledExtensionCount == rhs.enabledExtensionCount ) &&
             ( ppEnabledExtensionNames == rhs.ppEnabledExtensionNames ) && ( pEnabledFeatures == rhs.pEnabledFeatures );
    }

    bool operator!=( DeviceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType                   = StructureType::eDeviceCreateInfo;
    const void *                                         pNext                   = {};
    VULKAN_HPP_NAMESPACE::DeviceCreateFlags              flags                   = {};
    uint32_t                                             queueCreateInfoCount    = {};
    const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo *  pQueueCreateInfos       = {};
    uint32_t                                             enabledLayerCount       = {};
    const char * const *                                 ppEnabledLayerNames     = {};
    uint32_t                                             enabledExtensionCount   = {};
    const char * const *                                 ppEnabledExtensionNames = {};
    const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * pEnabledFeatures        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DeviceCreateInfo ) == sizeof( VkDeviceCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DeviceCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DeviceCreateInfo>::value,
                            "DeviceCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDeviceCreateInfo>
  {
    using Type = DeviceCreateInfo;
  };

}  // namespace VULKAN_HPP_NAMESPACE

template <>
struct std::hash<VULKAN_HPP_NAMESPACE::DeviceCreateInfo>
{
  std::size_t operator()( VULKAN_HPP_NAMESPACE::DeviceCreateInfo const & deviceCreateInfo ) const VULKAN_HPP_NOEXCEPT
  {
    std::size_t seed = 0;
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::StructureType, seed, deviceCreateInfo.sType );
    VULKAN_HPP_HASH_COMBINE( const void *, seed, deviceCreateInfo.pNext );
    VULKAN_HPP_HASH_COMBINE( VULKAN_HPP_NAMESPACE::DeviceCreateFlags, seed, deviceCreateInfo.flags );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, deviceCreateInfo.queueCreateInfoCount );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo *, seed, deviceCreateInfo.pQueueCreateInfos );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, deviceCreateInfo.enabledLayerCount );
    VULKAN_HPP_HASH_COMBINE( const char * const *, seed, deviceCreateInfo.ppEnabledLayerNames );
    VULKAN_HPP_HASH_COMBINE( uint32_t, seed, deviceCreateInfo.enabledExtensionCount );
    VULKAN_HPP_HASH_COMBINE( const char * const *, seed, deviceCreateInfo.ppEnabledExtensionNames );
    VULKAN_HPP_HASH_COMBINE(
      const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures *, seed, deviceCreateInfo.pEnabledFeatures );
    return seed;
  }
};

namespace VULKAN_HPP_NAMESPACE
{
  struct DeviceDeviceMemoryReportCreateInfoEXT
  {
    using NativeType = VkDeviceDeviceMemoryReportCreateInfoEXT;

    static const bool                                  allowDuplicate = true;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType =
      StructureType::eDeviceDeviceMemoryReportCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DeviceDeviceMemoryReportCreateInfoEXT( VULKAN_HPP_NAMESPACE::DeviceMemoryReportFlagsEXT flags_           = {},
                                             PFN_vkDeviceMemoryReportCallbackEXT              pfnUserCallback_ = {},
                                             void * pUserData_ = {} ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , pfnUserCallback( pfnUserCallback_ )
      , pUserData( pUserData_ )
    {}

    VULKAN_HPP_CONSTEXPR DeviceDeviceMemoryReportCreateInfoEXT( DeviceDeviceMemoryReportCreateInfoEXT const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    DeviceDeviceMemoryReportCreateInfoEXT( VkDeviceDeviceMemoryReportCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceDeviceMemoryReportCreateInfoEXT(
          *reinterpret_cast<DeviceDeviceMemoryReportCreateInfoEXT const *>( &rhs ) )
    {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceDeviceMemoryReportCreateInfoEXT &
      operator=( DeviceDeviceMemoryReportCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceDeviceMemoryReportCreateInfoEXT &
      operator=( VkDeviceDeviceMemoryReportCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceDeviceMemoryReportCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceDeviceMemoryReportCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceDeviceMemoryReportCreateInfoEXT &
                            setFlags( VULKAN_HPP_NAMESPACE::DeviceMemoryReportFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceDeviceMemoryReportCreateInfoEXT &
      setPfnUserCallback( PFN_vkDeviceMemoryReportCallbackEXT pfnUserCallback_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnUserCallback = pfnUserCallback_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceDeviceMemoryReportCreateInfoEXT &
                            setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    operator VkDeviceDeviceMemoryReportCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceDeviceMemoryReportCreateInfoEXT *>( this );
    }

    operator VkDeviceDeviceMemoryReportCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceDeviceMemoryReportCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceDeviceMemoryReportCreateInfoEXT const & ) const = default;
#else
    bool operator==( DeviceDeviceMemoryReportCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( pfnUserCallback == rhs.pfnUserCallback ) && ( pUserData == rhs.pUserData );
    }

    bool operator!=( DeviceDeviceMemoryReportCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType              sType = StructureType::eDev