/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.GlyfCompositeDescript;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfSimpleDescript;
import org.apache.batik.svggen.font.table.LocaTable;
import org.apache.batik.svggen.font.table.Table;

public class GlyfTable
implements Table {
    private byte[] buf = null;
    private GlyfDescript[] descript;

    protected GlyfTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        raf.seek(de.getOffset());
        this.buf = new byte[de.getLength()];
        raf.read(this.buf);
    }

    public void init(int numGlyphs, LocaTable loca) {
        if (this.buf == null) {
            return;
        }
        this.descript = new GlyfDescript[numGlyphs];
        ByteArrayInputStream bais = new ByteArrayInputStream(this.buf);
        int i = 0;
        while (i < numGlyphs) {
            int len = loca.getOffset(i + 1) - loca.getOffset(i);
            if (len > 0) {
                bais.reset();
                bais.skip(loca.getOffset(i));
                short numberOfContours = (short)(bais.read() << 8 | bais.read());
                this.descript[i] = numberOfContours >= 0 ? new GlyfSimpleDescript(this, numberOfContours, bais) : new GlyfCompositeDescript(this, bais);
            }
            ++i;
        }
        this.buf = null;
        int i2 = 0;
        while (i2 < numGlyphs) {
            if (this.descript[i2] != null) {
                this.descript[i2].resolve();
            }
            ++i2;
        }
    }

    public GlyfDescript getDescription(int i) {
        return this.descript[i];
    }

    public int getType() {
        return 1735162214;
    }
}

