/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.GZIPException;
import com.jcraft.jzlib.GZIPOutputStream;
import java.io.IOException;
import org.jcodings.specific.ASCIIEncoding;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.stringio.StringIO;
import org.jruby.ext.zlib.RubyGzipFile;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOOutputStream;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Zlib::GzipWriter"}, parent="Zlib::GzipFile")
public class JZlibRubyGzipWriter
extends RubyGzipFile {
    private GZIPOutputStream io;

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        JZlibRubyGzipWriter result2 = JZlibRubyGzipWriter.newInstance(recv2, args2);
        return RubyGzipFile.wrapBlock(context, result2, block);
    }

    public static JZlibRubyGzipWriter newInstance(IRubyObject recv2, IRubyObject[] args2) {
        RubyClass klass = (RubyClass)recv2;
        JZlibRubyGzipWriter result2 = (JZlibRubyGzipWriter)klass.allocate();
        result2.callInit(args2, Block.NULL_BLOCK);
        return result2;
    }

    @JRubyMethod(name={"open"}, required=1, optional=3, meta=true)
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        args2[0] = Helpers.invoke(context, (IRubyObject)runtime2.getFile(), "open", args2[0], (IRubyObject)runtime2.newString("wb"));
        JZlibRubyGzipWriter gzio = JZlibRubyGzipWriter.newInstance(recv2, args2);
        return RubyGzipFile.wrapBlock(context, gzio, block);
    }

    public JZlibRubyGzipWriter(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public IRubyObject initialize(IRubyObject[] args2) {
        return this.initialize19(this.getRuntime().getCurrentContext(), args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject opt = context.nil;
        int argc = args2.length;
        if (argc > 1 && !(opt = TypeConverter.checkHashType(runtime2, opt)).isNil()) {
            --argc;
        }
        this.level = this.processLevel(argc, args2, runtime2);
        this.processStrategy(argc, args2);
        this.initializeCommon(args2[0], this.level);
        this.ecopts(context, opt);
        return this;
    }

    private int processStrategy(int argc, IRubyObject[] args2) {
        return argc < 3 ? 0 : RubyZlib.FIXNUMARG(args2[2], 0);
    }

    private int processLevel(int argc, IRubyObject[] args2, Ruby runtime2) {
        int level2 = argc < 2 ? -1 : RubyZlib.FIXNUMARG(args2[1], -1);
        JZlibRubyGzipWriter.checkLevel(runtime2, level2);
        return level2;
    }

    private IRubyObject initializeCommon(IRubyObject stream, int level2) {
        this.realIo = (RubyObject)stream;
        try {
            Deflater deflater = new Deflater(level2, 31, false);
            IOOutputStream ioOutputStream = new IOOutputStream(this.realIo, false, false){

                @Override
                public void write(byte[] bytes2, int off, int len) throws IOException {
                    byte[] bytesCopy = new byte[len];
                    System.arraycopy(bytes2, off, bytesCopy, 0, len);
                    super.write(bytesCopy, 0, len);
                }
            };
            this.io = new GZIPOutputStream(ioOutputStream, deflater, 512, false);
            return this;
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static void checkLevel(Ruby runtime2, int level2) {
        if (level2 != -1 && (level2 < 0 || level2 > 9)) {
            throw RubyZlib.newStreamError(runtime2, "stream error: invalid level");
        }
    }

    @Override
    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        if (!this.closed) {
            try {
                this.io.close();
                if (this.realIo.respondsTo("close")) {
                    this.realIo.callMethod(this.realIo.getRuntime().getCurrentContext(), "close");
                }
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }
        this.closed = true;
        return this.realIo;
    }

    @JRubyMethod(name={"append", "<<"}, required=1)
    public IRubyObject append(IRubyObject p1) {
        this.write(p1);
        return this;
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.write(RubyKernel.sprintf(context, this, args2));
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(IRubyObject[] args2) {
        IRubyObject sep;
        if (args2.length != 0) {
            int j = args2.length;
            for (int i2 = 0; i2 < j; ++i2) {
                this.write(args2[i2]);
            }
        }
        if (!(sep = this.getRuntime().getGlobalVariables().get("$\\")).isNil()) {
            this.write(sep);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos() {
        return RubyNumeric.int2fix(this.getRuntime(), this.io.getTotalIn());
    }

    @JRubyMethod(name={"orig_name="}, required=1)
    public IRubyObject set_orig_name(IRubyObject obj) {
        this.nullFreeOrigName = obj.convertToString().strDup(this.getRuntime());
        this.ensureNonNull(this.nullFreeOrigName);
        try {
            this.io.setName(this.nullFreeOrigName.toString());
        }
        catch (GZIPException e) {
            throw RubyZlib.newGzipFileError(this.getRuntime(), "header is already written");
        }
        return obj;
    }

    @JRubyMethod(name={"comment="}, required=1)
    public IRubyObject set_comment(IRubyObject obj) {
        this.nullFreeComment = obj.convertToString().strDup(this.getRuntime());
        this.ensureNonNull(this.nullFreeComment);
        try {
            this.io.setComment(this.nullFreeComment.toString());
        }
        catch (GZIPException e) {
            throw RubyZlib.newGzipFileError(this.getRuntime(), "header is already written");
        }
        return obj;
    }

    private void ensureNonNull(RubyString obj) {
        String str = obj.toString();
        if (str.indexOf(0) >= 0) {
            String trim = str.substring(0, str.indexOf(0));
            obj.setValue(new ByteList(trim.getBytes()));
        }
    }

    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(IRubyObject p1) {
        try {
            this.io.write(RubyNumeric.num2chr(p1));
            return p1;
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        RubyClass StringIO2 = context.runtime.getClass("StringIO");
        StringIO sio = (StringIO)StringIO2.newInstance(context, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        sio.puts(context, args2);
        this.write(sio.string(context));
        return context.nil;
    }

    @Override
    public IRubyObject finish() {
        if (!this.finished) {
            try {
                this.io.finish();
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }
        this.finished = true;
        return this.realIo;
    }

    @JRubyMethod(name={"flush"}, optional=1)
    public IRubyObject flush(IRubyObject[] args2) {
        int flush2 = 2;
        if (args2.length > 0 && !args2[0].isNil()) {
            flush2 = RubyNumeric.fix2int(args2[0]);
        }
        boolean tmp = this.io.getSyncFlush();
        try {
            if (flush2 != 0) {
                this.io.setSyncFlush(true);
            }
            this.io.flush();
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
        finally {
            this.io.setSyncFlush(tmp);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"mtime="}, required=1)
    public IRubyObject set_mtime(IRubyObject arg2) {
        if (arg2 instanceof RubyTime) {
            this.mtime = (RubyTime)arg2;
        } else if (!arg2.isNil()) {
            this.mtime.setDateTime(new DateTime(RubyNumeric.fix2long(arg2) * 1000L));
        }
        try {
            this.io.setModifiedTime(this.mtime.to_i().getLongValue());
        }
        catch (GZIPException e) {
            throw RubyZlib.newGzipFileError(this.getRuntime(), "header is already written");
        }
        return this.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"crc"})
    public IRubyObject crc() {
        long crc2 = 0L;
        try {
            crc2 = this.io.getCRC();
        }
        catch (GZIPException gZIPException) {
            // empty catch block
        }
        return this.getRuntime().newFixnum(crc2);
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(IRubyObject p1) {
        Ruby runtime2 = this.getRuntime();
        RubyString str = p1.asString();
        if (this.enc2 != null && this.enc2 != ASCIIEncoding.INSTANCE) {
            str = EncodingUtils.strConvEncOpts(runtime2.getCurrentContext(), str, str.getEncoding(), this.enc2, 0, runtime2.getNil());
        }
        try {
            if (str.size() > 0) {
                this.io.write(str.getByteList().getUnsafeBytes(), str.getByteList().begin(), str.getByteList().length());
            }
            return runtime2.newFixnum(str.getByteList().length());
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    @Override
    @JRubyMethod
    public IRubyObject set_sync(IRubyObject arg2) {
        IRubyObject s2 = super.set_sync(arg2);
        this.io.setSyncFlush(this.sync);
        return s2;
    }
}

